/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.queryproc;

import java.util.Enumeration;
import quadbase.reportdesigner.queryproc.ICollationKey;
import quadbase.reportdesigner.queryproc.ICollator;
import quadbase.reportdesigner.util.IRSMetaData;
import quadbase.reportdesigner.util.IResultSet;

public class OuterJoin
implements IResultSet {
    int joinCol;
    int numCols;
    IResultSet irs;
    Enumeration enum1;
    ICollator cmp;
    boolean isDataFromEnum;
    Object enumVal = null;
    Object rsVal = null;
    ICollationKey enumKey;
    ICollationKey rsKey;
    boolean fetchEnumAgain = false;

    public OuterJoin(IResultSet rs, Enumeration e, int col, ICollator comp) throws Exception {
        this.irs = rs;
        this.enum1 = e;
        this.joinCol = col;
        this.cmp = comp;
        this.numCols = this.irs.getMetaData().getColumnCount();
        if (col <= 0 || col > this.numCols) {
            throw new IllegalArgumentException("Invalid column index :" + col);
        }
        if (this.enum1.hasMoreElements()) {
            this.enumVal = this.enum1.nextElement();
            this.enumKey = this.cmp.getCollationKey(this.enumVal);
        }
        this.isDataFromEnum = false;
    }

    @Override
    public boolean next() throws Exception {
        if (this.isDataFromEnum || this.fetchEnumAgain) {
            if (this.enum1.hasMoreElements()) {
                this.enumVal = this.enum1.nextElement();
                this.enumKey = this.cmp.getCollationKey(this.enumVal);
            } else {
                this.enumVal = null;
            }
        }
        if (!this.isDataFromEnum || this.fetchEnumAgain) {
            if (this.irs.next()) {
                this.rsVal = this.irs.getObject(this.joinCol);
                this.rsKey = this.cmp.getCollationKey(this.rsVal);
            } else {
                this.rsVal = null;
            }
        }
        this.fetchEnumAgain = false;
        if (this.enumVal == null && this.rsVal == null) {
            return false;
        }
        if (this.enumVal == null) {
            this.isDataFromEnum = false;
            return true;
        }
        if (this.rsVal == null) {
            this.isDataFromEnum = true;
            return true;
        }
        int cmpResult = this.enumKey.compareTo(this.rsKey);
        if (cmpResult == 0) {
            this.fetchEnumAgain = true;
        }
        this.isDataFromEnum = cmpResult < 0;
        return true;
    }

    @Override
    public Object getObject(int colNo) throws Exception {
        if (this.isDataFromEnum) {
            if (colNo == this.joinCol) {
                return this.enumKey.getSourceObject();
            }
            if (colNo <= 0 || colNo > this.numCols) {
                throw new IllegalArgumentException("Invalid column index :" + colNo);
            }
            return null;
        }
        return this.irs.getObject(colNo);
    }

    @Override
    public void close() throws Exception {
        this.irs.close();
        this.irs = null;
        this.enum1 = null;
        this.isDataFromEnum = false;
    }

    @Override
    public IRSMetaData getMetaData() throws Exception {
        return this.irs.getMetaData();
    }
}

