/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.queryproc;

import java.io.PrintStream;
import java.util.Enumeration;
import quadbase.reportdesigner.queryproc.ATreeNode;
import quadbase.reportdesigner.queryproc.AggrAvg;
import quadbase.reportdesigner.queryproc.AggrCount;
import quadbase.reportdesigner.queryproc.AggrMinMax;
import quadbase.reportdesigner.queryproc.AggrSum;
import quadbase.reportdesigner.queryproc.Aggregator;
import quadbase.reportdesigner.queryproc.IAggregatorFactory;
import quadbase.reportdesigner.queryproc.ICollationKey;
import quadbase.reportdesigner.queryproc.ICollator;
import quadbase.reportdesigner.queryproc.IQueryProc;
import quadbase.reportdesigner.queryproc.IRECProvider;
import quadbase.reportdesigner.queryproc.IRoundingFunc;
import quadbase.reportdesigner.queryproc.ITreeNodeFactory;
import quadbase.reportdesigner.queryproc.OuterJoin;
import quadbase.reportdesigner.queryproc.TreeLevelInfo;
import quadbase.reportdesigner.queryproc.TreeResultSet;
import quadbase.reportdesigner.queryproc.VecTreeNode;
import quadbase.reportdesigner.util.IRSMetaData;
import quadbase.reportdesigner.util.IResultSet;
import quadbase.reportdesigner.util.internal.IQueryProcInfo;

public abstract class QueryProc
implements IQueryProc,
ITreeNodeFactory,
IAggregatorFactory {
    static final String NO_METADATA = "Input metadata not yet available";
    static final int MAX_CHILDREN = 500;
    static boolean init = false;
    boolean useObjectBuffer;
    IResultSet rs;
    IRSMetaData md;
    int mainCol = -1;
    Object lBoundVal;
    Object uBoundVal;
    boolean isLinear = false;
    boolean isCatRounded;
    int[] groupCols;
    int[] aggrColNo;
    int[] aggrOp;
    ATreeNode tree;
    TreeLevelInfo rootInfo;
    IRECProvider rec;
    int[] indexMap;

    public QueryProc(boolean useObjectBuffer) {
        this.useObjectBuffer = useObjectBuffer;
        if (!init) {
            ATreeNode.setNodeFactory(this);
            ATreeNode.setAggrFactory(this);
            init = true;
        }
    }

    @Override
    public void setInputResultSet(IResultSet resultSet) {
        this.rs = resultSet;
    }

    @Override
    public void setSelectionCol(int colNo) {
        this.mainCol = colNo;
    }

    @Override
    public void setGroupColList(int[] gCols) {
        this.groupCols = gCols;
    }

    @Override
    public void setAggregateList(int[] colNo, int[] aggr) {
        this.aggrColNo = colNo;
        this.aggrOp = aggr;
    }

    @Override
    public void setLinearOutput(boolean isLinear) {
        this.isLinear = isLinear;
    }

    @Override
    public boolean isLinearOutput() {
        return this.isLinear;
    }

    @Override
    public void setSelectionRange(Object t1, Object t2) {
        this.lBoundVal = t1;
        this.uBoundVal = t2;
    }

    @Override
    public Object getSelectionLBound() {
        return this.lBoundVal;
    }

    @Override
    public Object getSelectionUBound() {
        return this.uBoundVal;
    }

    @Override
    public void setRounded(boolean round) {
        this.isCatRounded = round;
    }

    @Override
    public boolean isRounded() {
        return this.isCatRounded;
    }

    @Override
    public IResultSet getOutputRows() throws Exception {
        if (this.tree == null) {
            throw new IllegalArgumentException("Result not ready");
        }
        TreeResultSet rs = new TreeResultSet(this.md, this.tree);
        if (this.isLinear) {
            Object lb = this.lBoundVal != null ? this.lBoundVal : this.tree.getSmallestChild().getId();
            Object ub = this.uBoundVal != null ? this.uBoundVal : this.tree.getLargestChild().getId();
            Enumeration e = this.rec.getEnumeration(lb, ub);
            return new OuterJoin(rs, e, 1, this.rec.getCollator());
        }
        return rs;
    }

    void verifyInput() throws Exception {
        int i;
        this.md = this.rs.getMetaData();
        if (this.md == null) {
            throw new IllegalArgumentException(NO_METADATA);
        }
        int numCols = this.md.getColumnCount();
        if (this.mainCol <= 0 || this.mainCol > numCols) {
            throw new IllegalArgumentException("Invalid category column :" + this.mainCol);
        }
        if (this.groupCols != null) {
            for (int groupCol : this.groupCols) {
                if (groupCol > 0 && groupCol <= numCols) continue;
                throw new IllegalArgumentException("Invalid group column :" + groupCol);
            }
        }
        if (this.aggrColNo == null || this.aggrOp == null) {
            throw new IllegalArgumentException("Aggregates not specified!");
        }
        for (i = 0; i < this.aggrColNo.length; ++i) {
            if (this.aggrColNo[i] > 0 && this.aggrColNo[i] <= numCols) continue;
            this.aggrOp = null;
            this.aggrColNo = null;
            throw new IllegalArgumentException("Invalid aggregate column :" + this.aggrColNo[i]);
        }
        for (i = 0; i < this.aggrOp.length; ++i) {
            if (this.aggrOp[i] < 0 || this.aggrOp[i] > 5) {
                this.aggrOp = null;
                this.aggrColNo = null;
                throw new IllegalArgumentException("Invalid aggregate operator :" + this.aggrOp[i]);
            }
            if (this.aggrOp[i] == 0 || this.isNumeric(this.md.getColumnType(this.aggrColNo[i]))) continue;
            throw new IllegalArgumentException("Non-numeric aggregate column :" + this.aggrColNo[i]);
        }
    }

    boolean isNumeric(int sqlType) {
        return sqlType == 4 || sqlType == 6 || sqlType == 8 || sqlType == 7 || sqlType == 2 || sqlType == 3 || sqlType == -6 || sqlType == 5 || sqlType != -5;
    }

    @Override
    public void setInputInfo(IQueryProcInfo info) {
        this.setSelectionCol(info.getSelectionCol());
        this.setGroupColList(info.getGroupCols());
        this.setAggregateList(info.getAggrCols(), info.getAggrOps());
        this.setLinearOutput(info.isLinearOutput());
        this.setSelectionRange(info.getSelectionLBound(), info.getSelectionUBound());
        this.setRounded(info.isRounded());
        if (this.isRounded()) {
            this.setRoundingIntervalUnit(info.getRoundingIntervalUnit());
            this.setRoundingIntervalSize(info.getRoundingIntervalSize());
        }
    }

    @Override
    public void run() throws Exception {
        this.verifyInput();
        this.rec = this.newRECProvider();
        this.rootInfo = new TreeLevelInfo(this.md, 1);
        this.rootInfo.setMaxChildren(500);
        TreeLevelInfo t = this.rootInfo;
        t.setChildCol(this.mainCol);
        t = t.getChildInfo();
        IRoundingFunc rf = this.rec.getRoundingFunc();
        rf.setRangeOnly(!this.isRounded());
        t.setRoundingFunc(this.rec.getRoundingFunc());
        t.setCollator((ICollator)((Object)this.rec));
        t.setMaxChildren(500);
        for (int groupCol : this.groupCols) {
            t.setChildCol(groupCol);
            t = t.getChildInfo();
            t.setMaxChildren(500);
        }
        t.setAggregateList(this.aggrColNo, this.aggrOp);
        this.tree = ATreeNode.getNodeFactory().createATreeNode(this.rootInfo, this.rootInfo.getCollator().getCollationKey("ROOT"));
        this.indexMap = null;
        while (this.rs.next()) {
            if (this.useObjectBuffer) {
                this.makeObjectBuffer(this.rs);
            }
            this.tree.addRow(this.rs);
        }
        this.indexMap = null;
    }

    @Override
    public void printResultSet(PrintStream out) throws Exception {
        int i;
        IResultSet ors = this.getOutputRows();
        IRSMetaData omd = ors.getMetaData();
        int numCols = omd.getColumnCount();
        for (i = 1; i <= numCols; ++i) {
            out.print(omd.getColumnName(i) + "(" + omd.getColumnType(i) + ")\t");
        }
        out.println("");
        while (ors.next()) {
            for (i = 1; i <= numCols; ++i) {
                out.print(ors.getObject(i) + "\t");
            }
            out.println("");
        }
        ors.close();
    }

    @Override
    public ATreeNode createATreeNode(TreeLevelInfo info, ICollationKey key) throws Exception {
        return new VecTreeNode(info, key);
    }

    @Override
    public Aggregator createAggregator(int func, int sqlType) {
        switch (func) {
            case 0: {
                return new AggrCount();
            }
            case 1: 
            case 2: {
                return new AggrMinMax(sqlType, func);
            }
            case 3: {
                return new AggrSum(sqlType);
            }
            case 4: {
                return new AggrAvg(sqlType);
            }
        }
        throw new IllegalArgumentException("Invalid aggregate type :" + func);
    }

    abstract IRECProvider newRECProvider();

    private void makeObjectBuffer(IResultSet resultSet) throws Exception {
        if (this.indexMap == null) {
            this.sortColIndex();
        }
        int lastValue = this.indexMap[0];
        resultSet.getObject(lastValue);
        int arraySize = this.indexMap.length;
        for (int i = 1; i < arraySize; ++i) {
            int curValue = this.indexMap[i];
            if (curValue <= lastValue) continue;
            resultSet.getObject(curValue);
            lastValue = curValue;
        }
    }

    @Override
    public int[] getSortedColIndex() {
        if (this.indexMap == null) {
            this.sortColIndex();
        }
        return this.indexMap;
    }

    private void sortColIndex() {
        int i;
        int nAggregator = this.aggrColNo == null ? 0 : this.aggrColNo.length;
        int nGroupBy = this.groupCols == null ? 0 : this.groupCols.length;
        int bufferSize = nAggregator + nGroupBy + 1;
        this.indexMap = new int[bufferSize];
        for (i = 0; i < nAggregator; ++i) {
            this.indexMap[i] = this.aggrColNo[i];
        }
        for (i = 0; i < nGroupBy; ++i) {
            this.indexMap[i + nAggregator] = this.groupCols[i];
        }
        this.indexMap[bufferSize - 1] = this.mainCol;
        for (int i2 = 0; i2 < bufferSize - 1; ++i2) {
            for (int j = i2 + 1; j < bufferSize; ++j) {
                int value1 = this.indexMap[i2];
                int value2 = this.indexMap[j];
                if (value1 <= value2) continue;
                int temp = value1;
                this.indexMap[i2] = value2;
                this.indexMap[j] = temp;
            }
        }
    }
}

