/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.queryproc;

import java.util.Enumeration;
import quadbase.reportdesigner.queryproc.ICollationKey;
import quadbase.reportdesigner.queryproc.ICollator;
import quadbase.reportdesigner.queryproc.IRECProvider;
import quadbase.reportdesigner.queryproc.IRoundingFunc;
import quadbase.reportdesigner.queryproc.StringCollationKey;

class StringRECProvider
implements IRECProvider,
IRoundingFunc,
ICollator {
    String lbVal;
    String ubVal;

    public StringRECProvider(Object lBound, Object uBound) {
        if (lBound != null) {
            this.lbVal = lBound.toString();
        }
        if (uBound != null) {
            this.ubVal = uBound.toString();
        }
    }

    @Override
    public ICollator getCollator() {
        return this;
    }

    @Override
    public boolean isRangeOnly() {
        return true;
    }

    @Override
    public void setRangeOnly(boolean b) {
        if (!b) {
            throw new IllegalArgumentException("Rounding disallowed for strings.");
        }
    }

    @Override
    public Object roundOff(Object p0) {
        String l0 = p0.toString();
        if (this.lbVal != null && this.lbVal.compareTo(l0) > 0) {
            return null;
        }
        if (this.ubVal != null && this.ubVal.compareTo(l0) <= 0) {
            return null;
        }
        return p0;
    }

    @Override
    public IRoundingFunc getRoundingFunc() {
        return this;
    }

    @Override
    public Enumeration getEnumeration(Object lBound, Object uBound) {
        throw new IllegalArgumentException("Enumerations disallowed for strings.");
    }

    @Override
    public ICollationKey getCollationKey(Object x) {
        return new StringCollationKey(x);
    }
}

