/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.queryproc;

import java.util.Enumeration;
import java.util.logging.Logger;
import quadbase.reportdesigner.queryproc.ATreeNode;
import quadbase.reportdesigner.queryproc.Aggregator;
import quadbase.reportdesigner.queryproc.TreeLevelInfo;
import quadbase.reportdesigner.util.IRSMetaData;
import quadbase.reportdesigner.util.IResultSet;

class TreeResultSet
implements IResultSet {
    private static final Logger LOGGER = Logger.getLogger(TreeResultSet.class.getName());
    ATreeNode root;
    ATreeNode[] node;
    Enumeration[] enum1;
    int numLevels = 0;
    int currLevel = 0;
    int aggrCount;
    boolean cursorValid = true;
    IRSMetaData inputMD;

    TreeResultSet(IRSMetaData md, ATreeNode root) throws Exception {
        this.root = root;
        TreeLevelInfo info = root.getInfo();
        while (!info.isLeaf()) {
            info = info.getChildInfo();
            ++this.numLevels;
        }
        this.aggrCount = info.getAggregateCount();
        this.enum1 = new Enumeration[this.numLevels];
        this.node = new ATreeNode[this.numLevels];
        this.enum1[0] = root.sortedChildren();
        this.inputMD = md;
    }

    @Override
    public boolean next() {
        int i;
        if (!this.cursorValid) {
            return false;
        }
        for (i = this.numLevels - 1; i >= 0; --i) {
            if (this.enum1[i] == null || !this.enum1[i].hasMoreElements()) continue;
            this.node[i] = (ATreeNode)this.enum1[i].nextElement();
            break;
        }
        if (i < 0) {
            this.cursorValid = false;
            return false;
        }
        for (int j = i + 1; j < this.numLevels; ++j) {
            if (this.node[j - 1] == null) {
                this.enum1[j] = null;
                this.node[j] = null;
                continue;
            }
            this.enum1[j] = this.node[j - 1].sortedChildren();
            this.node[j] = this.enum1[j].hasMoreElements() ? (ATreeNode)this.enum1[j].nextElement() : null;
        }
        return true;
    }

    @Override
    public void close() {
        for (int i = 0; i < this.numLevels; ++i) {
            this.node[i] = null;
            this.enum1[i] = null;
        }
    }

    @Override
    public IRSMetaData getMetaData() throws Exception {
        return new MetaData(this.root.getInfo());
    }

    @Override
    public Object getObject(int index) {
        if (index <= 0 || index > this.numLevels + this.aggrCount) {
            throw new IllegalArgumentException("Invalid column index :" + index);
        }
        if (index <= this.numLevels) {
            if (this.node[index - 1] == null) {
                return null;
            }
            return this.node[index - 1].getId();
        }
        if (this.node[this.numLevels - 1] == null) {
            return null;
        }
        return this.node[this.numLevels - 1].getAggregateResult(index - 1 - this.numLevels);
    }

    void printStatistics() {
        LOGGER.finest("Tree root enumeration :");
        ATreeNode x = this.root;
        while (!x.getInfo().isLeaf()) {
            Enumeration e = x.sortedChildren();
            while (e.hasMoreElements()) {
                x = (ATreeNode)e.nextElement();
                LOGGER.finest(x.getId().toString());
            }
            LOGGER.finest("]");
        }
    }

    class MetaData
    implements IRSMetaData {
        int[] colMap;
        int[] sqlType;
        TreeLevelInfo leafInfo;

        public MetaData(TreeLevelInfo info) throws Exception {
            this.sqlType = new int[TreeResultSet.this.numLevels + TreeResultSet.this.aggrCount];
            this.colMap = new int[TreeResultSet.this.numLevels + TreeResultSet.this.aggrCount];
            int j = 0;
            while (!info.isLeaf()) {
                info = info.getChildInfo();
                this.colMap[j] = info.getIdCol();
                this.sqlType[j] = TreeResultSet.this.inputMD.getColumnType(this.colMap[j]);
                ++j;
            }
            this.leafInfo = info;
            for (int i = 0; i < TreeResultSet.this.aggrCount; ++i) {
                this.colMap[j] = this.leafInfo.getAggregateCol(i);
                this.sqlType[j] = Aggregator.getResultType(this.leafInfo.getAggregateOp(i), TreeResultSet.this.inputMD.getColumnType(this.colMap[j]));
                ++j;
            }
        }

        @Override
        public int getColumnCount() {
            return this.sqlType.length;
        }

        @Override
        public String getColumnName(int index) throws Exception {
            if (index <= 0 || index > this.sqlType.length) {
                throw new IllegalArgumentException("Invalid column index :" + index);
            }
            String name = TreeResultSet.this.inputMD.getColumnName(this.colMap[index - 1]);
            if (index <= TreeResultSet.this.numLevels) {
                return name;
            }
            return Aggregator.getName(this.leafInfo.getAggregateOp(index - TreeResultSet.this.numLevels - 1)) + "_" + name;
        }

        @Override
        public String getTableName(int index) throws Exception {
            return "";
        }

        @Override
        public int getColumnType(int index) throws Exception {
            if (index <= 0 || index > this.sqlType.length) {
                throw new IllegalArgumentException("Invalid column index :" + index);
            }
            return this.sqlType[index - 1];
        }
    }
}

