/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.util.Date;
import java.util.Vector;
import java.util.logging.Logger;
import quadbase.common.util.internal.DataSet;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.Function;
import quadbase.reportdesigner.report.IOUtil2;
import quadbase.reportdesigner.report.ScriptReportElement;
import quadbase.reportdesigner.util.IAggregateConstants;
import quadbase.reportdesigner.util.internal.BooleanCompare;
import quadbase.reportdesigner.util.internal.DateCompare;
import quadbase.reportdesigner.util.internal.NumberCompare;
import quadbase.reportdesigner.util.internal.StringCompare;

public class Aggregation
implements IAggregateConstants {
    private static final Logger LOGGER = Logger.getLogger(Aggregation.class.getName());

    public static Object getComputedValue(short aggregate, Object[] element) {
        LOGGER.finest("Aggregation object, compute: " + aggregate + " size :" + element.length);
        switch (aggregate) {
            case 1: {
                return Aggregation.sum(element);
            }
            case 2: {
                return Aggregation.findMinMax(element, false);
            }
            case 3: {
                return Aggregation.findMinMax(element, true);
            }
            case 4: {
                return Aggregation.count(element);
            }
            case 5: {
                return Aggregation.average(element);
            }
            case 12: {
                return Aggregation.median(element);
            }
            case 6: {
                return Aggregation.getFirstValue(element);
            }
            case 7: {
                return Aggregation.getLastValue(element);
            }
            case 8: {
                return Aggregation.sumSquare(element);
            }
            case 9: {
                return Aggregation.variance(element);
            }
            case 10: {
                return Aggregation.standardDeviation(element);
            }
            case 11: {
                return Aggregation.countDistinct(element);
            }
        }
        return Aggregation.getFirstValue(element);
    }

    public static Object getComputedValue(short aggregate, DataSet element, ReportTable table) {
        LOGGER.finest("Aggregation dataset, compute: " + aggregate + " size :" + element.size());
        switch (aggregate) {
            case 1: {
                return Aggregation.sum(element);
            }
            case 2: {
                return Aggregation.findMinMax(element, false);
            }
            case 3: {
                return Aggregation.findMinMax(element, true);
            }
            case 4: {
                return Aggregation.count(element);
            }
            case 5: {
                return Aggregation.average(element);
            }
            case 12: {
                return Aggregation.median(element);
            }
            case 8: {
                return Aggregation.sumSquare(element);
            }
            case 9: {
                return Aggregation.variance(element);
            }
            case 10: {
                return Aggregation.standardDeviation(element);
            }
            case 11: {
                return Aggregation.countDistinct(element);
            }
            case 7: {
                int[] indexArray = null;
                if (table instanceof ReportTreeTable) {
                    Vector<ReportTable> subTables = ((ReportTreeTable)table).getSubTable();
                    while (subTables != null && !subTables.isEmpty()) {
                        ReportTable subTable = subTables.get(subTables.size() - 1);
                        indexArray = subTable.indexArray;
                        if (subTable instanceof ReportTreeTable) {
                            subTables = ((ReportTreeTable)subTable).getSubTable();
                            continue;
                        }
                        subTables = null;
                    }
                } else {
                    indexArray = table.indexArray;
                }
                return Aggregation.getLastValue(element, indexArray);
            }
        }
        int[] indexArray = null;
        if (table instanceof ReportTreeTable) {
            Vector<ReportTable> subTables = ((ReportTreeTable)table).getSubTable();
            while (subTables != null && !subTables.isEmpty()) {
                ReportTable subTable = subTables.get(0);
                indexArray = subTable.indexArray;
                if (subTable instanceof ReportTreeTable) {
                    subTables = ((ReportTreeTable)subTable).getSubTable();
                    continue;
                }
                subTables = null;
            }
        } else {
            indexArray = table.indexArray;
        }
        return Aggregation.getFirstValue(element, indexArray);
    }

    private static Double sum(DataSet element) {
        if (element == null) {
            return 0.0;
        }
        double d = 0.0;
        for (int r = 0; r < element.size(); ++r) {
            d += IOUtil2.getValue(element.elementAt(r));
        }
        return d;
    }

    private static Double sum(Object[] element) {
        if (element == null) {
            return 0.0;
        }
        double d = 0.0;
        for (Object element2 : element) {
            d += IOUtil2.getValue(element2);
        }
        return d;
    }

    static Double average(Object[] element) {
        if (element == null) {
            return 0.0;
        }
        return Aggregation.sum(element) / (double)Aggregation.count(element).intValue();
    }

    private static Double average(DataSet element) {
        if (element == null) {
            return 0.0;
        }
        return Aggregation.sum(element) / (double)Aggregation.count(element).intValue();
    }

    private static Double median(Object[] element) {
        int i;
        if (element == null) {
            return 0.0;
        }
        Vector<Object> vec = new Vector<Object>();
        for (Object element2 : element) {
            if (element2 == null) continue;
            vec.addElement(element2);
        }
        double[] value = new double[vec.size()];
        for (i = 0; i < vec.size(); ++i) {
            value[i] = IOUtil2.getValue(vec.elementAt(i));
        }
        for (i = 0; i < value.length; ++i) {
            for (int j = i + 1; j < value.length; ++j) {
                if (!(value[j] < value[i])) continue;
                double temp = value[i];
                value[i] = value[j];
                value[j] = temp;
            }
        }
        if (value.length % 2 == 1) {
            return value[value.length / 2];
        }
        if (value.length == 0) {
            return null;
        }
        return (value[value.length / 2] + value[value.length / 2 - 1]) / 2.0;
    }

    private static Double median(DataSet element) {
        int i;
        if (element == null) {
            return 0.0;
        }
        Vector<Object> vec = new Vector<Object>();
        for (int i2 = 0; i2 < element.size(); ++i2) {
            if (element.elementAt(i2) == null) continue;
            vec.addElement(element.elementAt(i2));
        }
        double[] value = new double[vec.size()];
        for (i = 0; i < vec.size(); ++i) {
            value[i] = IOUtil2.getValue(vec.elementAt(i));
        }
        for (i = 0; i < value.length; ++i) {
            for (int j = i + 1; j < value.length; ++j) {
                if (!(value[j] < value[i])) continue;
                double temp = value[i];
                value[i] = value[j];
                value[j] = temp;
            }
        }
        if (value.length % 2 == 1) {
            return value[value.length / 2];
        }
        if (value.length == 0) {
            return null;
        }
        return (value[value.length / 2] + value[value.length / 2 - 1]) / 2.0;
    }

    private static Integer count(Object[] element) {
        if (element == null) {
            return 0;
        }
        int countNULL = 0;
        for (Object element2 : element) {
            if (element2 != null) continue;
            ++countNULL;
        }
        return element.length - countNULL;
    }

    private static Integer count(DataSet element) {
        if (element == null) {
            return 0;
        }
        int countNULL = 0;
        for (int r = 0; r < element.size(); ++r) {
            if (element.elementAt(r) != null) continue;
            ++countNULL;
        }
        return element.size() - countNULL;
    }

    private static Integer countDistinct(Object[] element) {
        if (element == null) {
            return 0;
        }
        Vector<Object> set = new Vector<Object>();
        for (int r = 0; r < element.length; ++r) {
            if (element[r] == null || element[r].equals("") || set.contains(element[r])) continue;
            set.addElement(element[r]);
        }
        return set.size();
    }

    private static Integer countDistinct(DataSet element) {
        if (element == null) {
            return 0;
        }
        Vector<Object> set = new Vector<Object>();
        for (int r = 0; r < element.size(); ++r) {
            if (element.elementAt(r) == null || element.elementAt(r).equals("") || set.contains(element.elementAt(r))) continue;
            set.addElement(element.elementAt(r));
        }
        return set.size();
    }

    private static Object getFirstValue(DataSet element, int[] indexArray) {
        if (element == null) {
            return null;
        }
        if (indexArray != null) {
            for (int r = 0; r < element.size(); ++r) {
                if (element.elementAt(indexArray[r]) == null) continue;
                return element.elementAt(indexArray[r]);
            }
        } else {
            for (int r = 0; r < element.size(); ++r) {
                if (element.elementAt(r) == null) continue;
                return element.elementAt(r);
            }
        }
        return null;
    }

    private static Object getFirstValue(Object[] element) {
        if (element == null) {
            return null;
        }
        for (Object element2 : element) {
            if (element2 == null) continue;
            return element2;
        }
        return null;
    }

    private static Object getLastValue(Object[] element) {
        if (element == null) {
            return null;
        }
        for (int r = element.length - 1; r >= 0; --r) {
            if (element[r] == null) continue;
            return element[r];
        }
        return null;
    }

    private static Object getLastValue(DataSet element, int[] indexArray) {
        if (element == null) {
            return null;
        }
        if (indexArray != null) {
            int startIndex = element.size() - indexArray.length;
            for (int r = indexArray.length - 1; r >= 0; --r) {
                if (element.elementAt(indexArray[r] + startIndex) == null) continue;
                return element.elementAt(indexArray[r] + startIndex);
            }
        } else {
            for (int r = element.size() - 1; r >= 0; --r) {
                if (element.elementAt(r) == null) continue;
                return element.elementAt(r);
            }
        }
        return null;
    }

    private static Object findMinMax(Object[] element, boolean findMin) {
        if (element == null) {
            return null;
        }
        Object val = Aggregation.getFirstValue(element);
        if (val == null) {
            return null;
        }
        for (int r = 1; r < element.length; ++r) {
            Object val2 = element[r];
            if (val2 == null) continue;
            if (val instanceof Boolean && val2 instanceof Boolean) {
                val = new BooleanCompare((Boolean)val).greaterThan(findMin, new BooleanCompare((Boolean)val2)) ? val2 : val;
                continue;
            }
            if (val instanceof Number && val2 instanceof Number) {
                val = new NumberCompare((Number)val).greaterThan(findMin, new NumberCompare((Number)val2)) ? val2 : val;
                continue;
            }
            if (val instanceof Date && val2 instanceof Date) {
                val = new DateCompare((Date)val).greaterThan(findMin, new DateCompare((Date)val2)) ? val2 : val;
                continue;
            }
            if (!(val instanceof String) || !(val2 instanceof String)) continue;
            val = new StringCompare((String)val).greaterThan(findMin, new StringCompare((String)val2)) ? val2 : val;
        }
        return val;
    }

    private static Object findMinMax(DataSet element, boolean findMin) {
        if (element == null) {
            return null;
        }
        Object val = Aggregation.getFirstValue(element, null);
        if (val == null) {
            return null;
        }
        for (int r = 1; r < element.size(); ++r) {
            Object val2 = element.elementAt(r);
            if (val2 == null) continue;
            if (val instanceof Boolean && val2 instanceof Boolean) {
                val = new BooleanCompare((Boolean)val).greaterThan(findMin, new BooleanCompare((Boolean)val2)) ? val2 : val;
                continue;
            }
            if (val instanceof Number && val2 instanceof Number) {
                val = new NumberCompare((Number)val).greaterThan(findMin, new NumberCompare((Number)val2)) ? val2 : val;
                continue;
            }
            if (val instanceof Date && val2 instanceof Date) {
                val = new DateCompare((Date)val).greaterThan(findMin, new DateCompare((Date)val2)) ? val2 : val;
                continue;
            }
            if (!(val instanceof String) || !(val2 instanceof String)) continue;
            val = new StringCompare((String)val).greaterThan(findMin, new StringCompare((String)val2)) ? val2 : val;
        }
        return val;
    }

    static Double sumSquare(Object[] element) {
        if (element == null) {
            return 0.0;
        }
        double d = 0.0;
        for (Object element2 : element) {
            d += Math.pow(IOUtil2.getValue(element2), 2.0);
        }
        return d;
    }

    private static Double sumSquare(DataSet element) {
        if (element == null) {
            return 0.0;
        }
        double d = 0.0;
        for (int r = 0; r < element.size(); ++r) {
            d += Math.pow(IOUtil2.getValue(element.elementAt(r)), 2.0);
        }
        return d;
    }

    static Double variance(Object[] element) {
        LOGGER.finest("variance");
        if (element == null) {
            return 0.0;
        }
        double mean = Aggregation.average(element);
        LOGGER.finest("man: " + mean);
        double v = 0.0;
        for (Object element2 : element) {
            v = Math.pow(IOUtil2.getValue(element2) - mean, 2.0) + v;
        }
        if (Aggregation.count(element) <= 1) {
            return 0.0;
        }
        return v / (double)(Aggregation.count(element) - 1);
    }

    private static Double variance(DataSet element) {
        LOGGER.finest("variance");
        if (element == null) {
            return 0.0;
        }
        double mean = Aggregation.average(element);
        LOGGER.finest("man: " + mean);
        double v = 0.0;
        for (int r = 0; r < element.size(); ++r) {
            v = Math.pow(IOUtil2.getValue(element.elementAt(r)) - mean, 2.0) + v;
        }
        if (Aggregation.count(element) <= 1) {
            return 0.0;
        }
        return v / (double)(Aggregation.count(element) - 1);
    }

    static Double standardDeviation(Object[] element) {
        if (element == null) {
            return 0.0;
        }
        return Math.sqrt(Aggregation.variance(element));
    }

    private static Double standardDeviation(DataSet element) {
        if (element == null) {
            return 0.0;
        }
        return Math.sqrt(Aggregation.variance(element));
    }

    static void getAggrColumn(ReportSection sec, ReportTable tbl, Vector<int[]> vec, Vector<Object> res) throws Exception {
        ReportCell[] cells = sec.getData();
        if (cells == null) {
            return;
        }
        for (ReportCell cell : cells) {
            Function function;
            Formula formulaObj = cell.getFormulaObj();
            if (formulaObj == null || !(formulaObj.getFormula() instanceof Function) || (function = (Function)formulaObj.getFormula()).getArgs() == null) continue;
            int[] pair = new int[2];
            pair[1] = function.getAggregation();
            if (!(function.getArgs().elementAt(0) instanceof ScriptReportElement)) continue;
            pair[0] = ((ScriptReportElement)function.getArgs().elementAt(0)).getColumnIndex(tbl);
            vec.addElement(pair);
        }
        for (int i = 0; i < vec.size(); ++i) {
            res.addElement(null);
        }
    }

    static void calculateAggregation(Object obj, int colIndex, Vector[] preAggCol, Vector[] resultCol) {
        for (int i = 0; i < preAggCol.length; ++i) {
            Aggregation.calculateAggregation(obj, colIndex, preAggCol[i], resultCol[i]);
        }
    }

    static void calculateAggregation(Object obj, int colIndex, Vector<int[]> preAggCol, Vector<Object> resultCol) {
        for (int j = 0; j < preAggCol.size(); ++j) {
            int[] tmp = preAggCol.elementAt(j);
            if (tmp[0] != colIndex) continue;
            resultCol.setElementAt(Aggregation.performAggregation(tmp[1], obj, resultCol.elementAt(j)), j);
        }
    }

    private static Object performAggregation(int aggr, Object newObj, Object result) {
        switch ((short)aggr) {
            case 1: {
                return Aggregation.sum(new Object[]{newObj, result});
            }
            case 2: {
                return Aggregation.findMinMax(new Object[]{newObj, result}, false);
            }
            case 3: {
                return Aggregation.findMinMax(new Object[]{newObj, result}, true);
            }
            case 4: {
                return newObj == null ? IOUtil2.getValue(result) : IOUtil2.getValue(result) + 1.0;
            }
            case 6: {
                return result == null ? newObj : result;
            }
            case 7: {
                return newObj == null ? result : newObj;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (result == null) {
                    result = new Vector<Object>();
                }
                if (newObj != null) {
                    result.addElement(newObj);
                }
                return result;
            }
        }
        return result;
    }
}

