/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.util.Date;
import java.util.Vector;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.ArraySet;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.Report;

public class ArrayElement
extends Operand {
    ArraySet array;
    Operand index;
    Operand expression;
    Object value;
    Object initValue;

    public ArrayElement(ArraySet array, Operand index) {
        this.array = array;
        this.index = index;
        switch (array.datatype) {
            case 0: {
                this.value = 0.0;
                this.initValue = 0.0;
                break;
            }
            case 1: {
                this.value = "";
                this.initValue = "";
                break;
            }
            case 2: {
                this.value = Boolean.FALSE;
                this.initValue = Boolean.FALSE;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.value = new Date();
                this.initValue = new Date();
                break;
            }
            default: {
                this.value = null;
            }
        }
    }

    public Operand getExpression() {
        return this.expression;
    }

    public void setExpression(Operand op) {
        this.expression = op;
    }

    @Override
    public Object getValue(ReportTable table, int row, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound) throws Exception {
        return this.getValue(table, row, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, null, null);
    }

    @Override
    public Object getValue(ReportTable table, int row, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol) throws Exception {
        return this.getValue(table, row, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, null);
    }

    @Override
    public Object getValue(ReportTable table, int row, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol, ColData[] colData) throws Exception {
        int idx = ((Number)this.index.getValue(table, row, page, section, totalpages, totalsections, r, cell, dataobj, secondRound)).intValue();
        Object object = this.array.getElement(idx);
        this.datatype = this.array.getDatatype(r);
        return object;
    }

    public String toString() {
        return this.array.toString() + "[" + this.index.toString() + "]";
    }

    @Override
    public int getDatatype(Report report) {
        if (this.datatype < 0) {
            this.datatype = this.array.getDatatype(report);
        }
        return this.datatype;
    }

    public void calculate(ReportTable table, int row, int page, int section, int totalPages, int totalSections, Report report, ReportCell cell, Object dataobj, boolean secondRound) throws Exception {
        int idx = ((Number)this.index.getValue(table, row, page, section, totalPages, totalSections, report, cell, dataobj, secondRound)).intValue();
        this.value = this.expression.getValue(table, row, page, section, totalPages, totalSections, report, cell, dataobj, secondRound);
        this.array.setElement(idx, this.value);
    }
}

