/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.awt.Font;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ScriptReportElement;

public class ArraySet
extends Operand {
    String name;
    Object[] value;
    Object[] initValue;
    Vector operandValue;
    ScriptReportElement scriptRptElt;

    public ArraySet(String name, int datatype) {
        this.name = name;
        this.datatype = datatype;
    }

    public ArraySet(Vector vec) {
        this.value = vec.toArray();
    }

    public ArraySet(Vector vec, boolean operand) {
        if (operand) {
            this.operandValue = vec;
        }
    }

    public ArraySet(String name, ScriptReportElement scriptRptElt) {
        this.name = name;
        this.scriptRptElt = scriptRptElt;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Vector vec) {
        this.value = vec.toArray();
    }

    public void setInitValue(Vector vec) {
        this.initValue = vec.toArray();
    }

    public void init() {
        if (this.initValue != null) {
            this.value = new Object[this.initValue.length];
            for (int i = 0; i < this.initValue.length; ++i) {
                this.value[i] = this.initValue[i];
            }
        }
    }

    public Object getElement(int index) {
        return this.value[index];
    }

    public void setElement(int index, Object theValue) {
        if (this.value == null) {
            this.value = new Object[index * 2 + 1];
        } else if (index >= this.value.length) {
            Object[] newValue = new Object[index * 2 + 1];
            for (int i = 0; i < this.value.length; ++i) {
                newValue[i] = this.value[i];
            }
            this.value = newValue;
        }
        this.value[index] = theValue;
    }

    public Operand getOperandElement(int index) {
        return (Operand)this.operandValue.elementAt(index);
    }

    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj) throws Exception {
        return this.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, false, null, null);
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound) throws Exception {
        return this.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, null, null);
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol) throws Exception {
        return this.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, null);
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol, ColData[] colData) throws Exception {
        if (this.scriptRptElt != null) {
            if (this.name.equalsIgnoreCase("value")) {
                this.value = new Object[1];
                Object object = this.scriptRptElt.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                if (this.scriptRptElt.getDatatype(r) == 0) {
                    this.value[0] = object;
                } else if (this.scriptRptElt.getDatatype(r) == 1) {
                    this.value[0] = object;
                } else if (this.scriptRptElt.getDatatype(r) == 3) {
                    this.value[0] = object;
                } else if (this.scriptRptElt.getDatatype(r) == 2) {
                    this.value[0] = object;
                }
            } else if (this.name.equalsIgnoreCase("bgcolor")) {
                this.value = new Object[3];
                this.scriptRptElt.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                Color c = this.scriptRptElt.getReportElement().getBgColor();
                if (c != null) {
                    this.value[0] = (double)c.getRed();
                    this.value[1] = (double)c.getGreen();
                    this.value[2] = (double)c.getBlue();
                }
            } else if (this.name.equalsIgnoreCase("fontcolor")) {
                this.value = new Object[3];
                this.scriptRptElt.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                Color c = this.scriptRptElt.getReportElement().getFontColor();
                if (c != null) {
                    this.value[0] = (double)c.getRed();
                    this.value[1] = (double)c.getGreen();
                    this.value[2] = (double)c.getBlue();
                }
            } else if (this.name.equalsIgnoreCase("font")) {
                this.value = new Object[3];
                this.scriptRptElt.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                Font f = this.scriptRptElt.getReportElement().getRefFont();
                this.value[0] = f.getFontName();
                this.value[1] = this.getFontStyle(f.getStyle());
                this.value[2] = (double)f.getSize();
            } else if (this.name.equalsIgnoreCase("align")) {
                this.value = new Object[1];
                this.scriptRptElt.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                short align = this.scriptRptElt.getReportElement().getAlign();
                this.value[0] = this.getAlignString(align);
            } else if (this.name.equalsIgnoreCase("valign")) {
                this.value = new Object[1];
                this.scriptRptElt.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                short align = this.scriptRptElt.getReportElement().getVAlign();
                this.value[0] = this.getVAlignString(align);
            } else if (this.name.equalsIgnoreCase("bordercolor")) {
                this.value = new Object[3];
                this.scriptRptElt.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                Color c = this.scriptRptElt.getReportElement().getBorderColor();
                if (c != null) {
                    this.value[0] = (double)c.getRed();
                    this.value[1] = (double)c.getGreen();
                    this.value[2] = (double)c.getBlue();
                }
            } else if (this.name.equalsIgnoreCase("borderthickness")) {
                this.value = new Object[1];
                this.scriptRptElt.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                int border = this.scriptRptElt.getReportElement().getBorderThickness();
                this.value[0] = (double)border;
            } else if (this.name.equalsIgnoreCase("hyperlink")) {
                this.value = new Object[3];
                this.scriptRptElt.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                this.value[0] = this.scriptRptElt.getReportElement().getLink();
                this.value[1] = this.scriptRptElt.getReportElement().getHint();
                this.value[2] = this.scriptRptElt.getReportElement().getTarget();
            } else if (this.name.equalsIgnoreCase("BOOKMARK")) {
                this.value = new Object[1];
                this.scriptRptElt.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                this.value[0] = this.scriptRptElt.getReportElement().getBookmark();
            } else if (this.name.equalsIgnoreCase("XPOSITION")) {
                this.value = new Object[1];
                this.scriptRptElt.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                double x = this.scriptRptElt.getReportElement().getX();
                this.value[0] = x;
            } else if (this.name.equalsIgnoreCase("YPOSITION")) {
                this.value = new Object[1];
                this.scriptRptElt.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                double y = this.scriptRptElt.getReportElement().getY();
                this.value[0] = y;
            } else if (this.name.equalsIgnoreCase("WIDTH")) {
                this.value = new Object[1];
                this.scriptRptElt.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                double width = this.scriptRptElt.getReportElement().getWidth();
                this.value[0] = width;
            } else if (this.name.equalsIgnoreCase("HEIGHT")) {
                this.value = new Object[1];
                this.scriptRptElt.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                double height = this.scriptRptElt.getReportElement().getHeight();
                this.value[0] = height;
            } else if (this.name.equalsIgnoreCase("VISIBLE")) {
                this.value = new Object[1];
                this.scriptRptElt.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                boolean visible = true;
                if (this.scriptRptElt.getReportElement() instanceof ReportColumn) {
                    visible = ((ReportColumn)this.scriptRptElt.getReportElement()).isVisible();
                }
                this.value[0] = visible;
            }
        }
        return this;
    }

    public int size() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length;
    }

    public int operandSize() {
        if (this.operandValue == null) {
            return 0;
        }
        return this.operandValue.size();
    }

    private String getAlignString(short align) {
        switch (align) {
            case 1: {
                return "LEFT";
            }
            case 0: {
                return "RIGHT";
            }
        }
        return "CENTER";
    }

    private String getVAlignString(short align) {
        switch (align) {
            case 1: {
                return "TOP";
            }
            case 2: {
                return "BOTTOM";
            }
        }
        return "MIDDLE";
    }

    private String getFontStyle(int style) {
        if (style == 0) {
            return "PLAIN";
        }
        if (style == 1) {
            return "BOLD";
        }
        if (style == 2) {
            return "ITALIC";
        }
        return "BOLDITALIC";
    }

    public boolean equals(Object object) {
        if (object instanceof ArraySet) {
            for (int i = 0; i < this.value.length; ++i) {
                Object obj1 = this.value[i];
                Object obj2 = ((ArraySet)object).getElement(i);
                if (obj1 == null && obj2 == null) continue;
                if (obj1 == null && obj2 != null) {
                    return false;
                }
                if (obj2 == null && obj1 != null) {
                    return false;
                }
                if (obj1 instanceof Number && obj2 instanceof Number) {
                    if (((Number)obj1).doubleValue() == ((Number)obj2).doubleValue()) continue;
                    return false;
                }
                if (obj1 instanceof String && obj2 instanceof String) {
                    if (((String)obj1).equals(obj2)) continue;
                    return false;
                }
                if (obj1 instanceof Boolean && obj2 instanceof Boolean) {
                    if (((Boolean)obj1).booleanValue() == ((Boolean)obj2).booleanValue()) continue;
                    return false;
                }
                if (obj1 instanceof Date && obj2 instanceof Date || obj1 instanceof Time && obj2 instanceof Time || obj1 instanceof Timestamp && obj2 instanceof Timestamp) {
                    if (((Date)obj1).equals(obj2)) continue;
                    return false;
                }
                return false;
            }
        } else {
            Object obj1 = this.value[0];
            if (obj1 instanceof Number && object instanceof Number) {
                if (((Number)obj1).doubleValue() != ((Number)object).doubleValue()) {
                    return false;
                }
            } else if (obj1 instanceof String && object instanceof String) {
                if (!((String)obj1).equals(object)) {
                    return false;
                }
            } else if (obj1 instanceof Boolean && object instanceof Boolean) {
                if (((Boolean)obj1).booleanValue() != ((Boolean)object).booleanValue()) {
                    return false;
                }
            } else if (obj1 instanceof Date && object instanceof Date || obj1 instanceof Time && object instanceof Time || obj1 instanceof Timestamp && object instanceof Timestamp) {
                if (!((Date)obj1).equals(object)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        if (this.value == null) {
            return "[]";
        }
        String s = "[";
        for (int i = 0; i < this.value.length - 1; ++i) {
            s = s + this.value[i] + ",";
        }
        return s + this.value[this.value.length - 1] + "]";
    }

    @Override
    public int getDatatype(Report report) {
        if (this.name.equalsIgnoreCase("value")) {
            return this.scriptRptElt.getDatatype(report);
        }
        if (this.name.equalsIgnoreCase("bgcolor")) {
            return -1;
        }
        if (this.name.equalsIgnoreCase("fontcolor")) {
            return -1;
        }
        if (this.name.equalsIgnoreCase("font")) {
            return -1;
        }
        if (this.name.equalsIgnoreCase("align")) {
            return -1;
        }
        if (this.name.equalsIgnoreCase("valign")) {
            return -1;
        }
        if (this.name.equalsIgnoreCase("bordercolor")) {
            return -1;
        }
        if (this.name.equalsIgnoreCase("borderthickness")) {
            return 0;
        }
        if (this.name.equalsIgnoreCase("hyperlink")) {
            return -1;
        }
        if (this.name.equalsIgnoreCase("bookmark")) {
            return -1;
        }
        if (this.name.equalsIgnoreCase("xposition")) {
            return 0;
        }
        if (this.name.equalsIgnoreCase("yposition")) {
            return 0;
        }
        if (this.name.equalsIgnoreCase("width")) {
            return 0;
        }
        if (this.name.equalsIgnoreCase("height")) {
            return 0;
        }
        if (this.name.equalsIgnoreCase("visible")) {
            return 2;
        }
        return this.datatype;
    }
}

