/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.report.ArrayElement;
import quadbase.reportdesigner.report.ArraySet;
import quadbase.reportdesigner.report.ERStatement;
import quadbase.reportdesigner.report.Expression;
import quadbase.reportdesigner.report.Function;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.Script;
import quadbase.reportdesigner.report.ScriptReportElement;
import quadbase.reportdesigner.report.Variable;

public class AssignStmt
implements ERStatement {
    Variable var;
    ArrayElement arrayElt;
    String varname;
    String arrayname;
    Operand rightExp;

    public AssignStmt(Variable var, Operand rightExp) {
        this.var = var;
        this.rightExp = rightExp;
    }

    public AssignStmt(ArraySet array, Operand index, Operand rightExp) {
        this.arrayElt = new ArrayElement(array, index);
        this.rightExp = rightExp;
    }

    public Variable getVariable() {
        return this.var;
    }

    public void setVariable(Variable var) {
        this.var = var;
    }

    public Operand getRightExp() {
        return this.rightExp;
    }

    public void setRightExp(Operand rightExp) {
        this.rightExp = rightExp;
    }

    @Override
    public void execute(Script script) throws Exception {
        if (this.var == null && this.arrayElt == null) {
            for (int i = 0; i < script.getVariables().size(); ++i) {
                Variable variable = (Variable)script.getVariables().elementAt(i);
                if (!variable.getName().equals(this.varname)) continue;
                this.var = variable;
                break;
            }
            if (this.var == null && this.arrayElt == null) {
                throw new Exception(LanguageEncoder.getText("Variable") + " " + this.varname + " " + LanguageEncoder.getText("not found"));
            }
        }
        if (this.var != null) {
            this.var.setExpression(this.rightExp);
            this.var.calculate(script.table, script.index, script.page, script.section, script.totalPages, script.totalSections, script.report, script.cell, script.dataobj, true);
        }
        if (this.arrayElt != null) {
            this.arrayElt.setExpression(this.rightExp);
            this.arrayElt.calculate(script.table, script.index, script.page, script.section, script.totalPages, script.totalSections, script.report, script.cell, script.dataobj, true);
        }
    }

    @Override
    public void testExecute(Script script) throws Exception {
        this.execute(script);
    }

    @Override
    public void setThisDataType(int datatype) {
        if (this.rightExp instanceof ScriptReportElement) {
            ((ScriptReportElement)this.rightExp).setThisDataType(datatype);
        } else if (this.rightExp instanceof Function) {
            ((Function)this.rightExp).setThisDataType(datatype);
        } else if (this.rightExp instanceof Expression) {
            ((Expression)this.rightExp).setThisDataType(datatype);
        }
    }
}

