/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.FormattedRow;
import quadbase.reportdesigner.ReportElements.FormattedRowKey;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.report.CSVReportColumnar;
import quadbase.reportdesigner.report.CSVReportCrossTab;
import quadbase.reportdesigner.report.CSVReportMasterDetails;
import quadbase.reportdesigner.report.CSVReportSummary;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportUI;

public class CSVReport {
    private static final Logger LOGGER = Logger.getLogger(CSVReport.class.getName());
    public static String defaultExportNewlineDelimiter = System.getProperty("line.separator");
    public static String defaultNewlineDelimiterPlatform = "windows";
    Report report;
    PrintWriter out;
    String delimiter = ",";
    String endDelimiter = null;
    String strQuote = "\"";
    protected Vector treeStructure = null;
    protected Vector rowElements = null;
    protected Hashtable rows = null;
    private boolean skipFormatTable = false;

    public CSVReport(Report report) {
        this.report = report;
    }

    public CSVReport(Report report, boolean skipFormatTable) {
        this.report = report;
        this.skipFormatTable = skipFormatTable;
    }

    public boolean exportTXT(OutputStream outstream) throws Exception {
        this.setTextExport();
        return this.exportCSV(outstream);
    }

    public boolean exportCSV(OutputStream outstream) throws Exception {
        try {
            this.out = this.report.getExportEncoding() != null ? new PrintWriter((Writer)new OutputStreamWriter(outstream, this.report.getExportEncoding()), true) : new PrintWriter(outstream, true);
            this.delimiter = this.getDelimiter(false);
            this.endDelimiter = this.getNewlineDelim();
            return this.exportCSV();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot export CSV", ex);
            throw ex;
        }
    }

    private boolean exportCSV() throws Exception {
        if (this.report.getInitializeReportError() != null) {
            ReportTable table = null;
            Vector<ReportTable> vec = this.report.getReportTables();
            if (vec.size() > 0) {
                table = vec.elementAt(0);
            }
            this.writeSection(ReportUI.createErrorSection(this.report.getActualPageWidth(), this.report.getActualPageHeight(), this.report.getInitializeReportError()), table);
            this.out.flush();
            return true;
        }
        ReportTable table = null;
        this.formatTable();
        Vector<ReportTable> vec = this.report.getReportTables();
        if (vec.size() > 0) {
            table = vec.elementAt(0);
        }
        this.startToGetData(table);
        this.writeSection(this.report.getPageHeader(), table);
        this.writeSection(this.report.getReportHeader(), table);
        for (int i = 0; i < vec.size(); ++i) {
            table = vec.elementAt(i);
            this.writeTable(table);
        }
        if (this instanceof CSVReportSummary) {
            this.writeSection(this.report.getReportFooter(), table, ((CSVReportSummary)this).footerAggCol, ((CSVReportSummary)this).footerResCol);
        } else if (this instanceof CSVReportColumnar) {
            this.writeSection(this.report.getReportFooter(), table, ((CSVReportColumnar)this).footerAggCol, ((CSVReportColumnar)this).footerResCol);
        } else if (this instanceof CSVReportCrossTab) {
            this.writeSection(this.report.getReportFooter(), table, ((CSVReportCrossTab)this).footerAggCol, ((CSVReportCrossTab)this).footerResCol);
        } else if (this instanceof CSVReportMasterDetails) {
            this.writeSection(this.report.getReportFooter(), table, ((CSVReportMasterDetails)this).footerAggCol, ((CSVReportMasterDetails)this).footerResCol);
        } else {
            this.writeSection(this.report.getReportFooter(), table);
        }
        this.writeSection(this.report.getPageFooter(), table);
        this.out.flush();
        return true;
    }

    private void setTextExport() {
        this.delimiter = this.getDelimiter(true);
        this.endDelimiter = this.getNewlineDelim();
        this.strQuote = "";
    }

    private void copy(CSVReport _csvrpt) {
        this.delimiter = _csvrpt.delimiter;
        this.endDelimiter = _csvrpt.endDelimiter;
        this.strQuote = _csvrpt.strQuote;
    }

    void formatTable() throws Exception {
        if (!this.skipFormatTable) {
            this.report.formatTable();
        }
    }

    protected void writeTable(ReportTable tbl) throws Exception {
        this.writeSection(tbl.getHeader(), tbl);
        this.writeCells(tbl);
        this.writeSection(tbl.getFooter(), tbl);
    }

    protected void writeSection(ReportSection section, ReportTable tbl) throws Exception {
        this.writeSection(section, tbl, this.out);
    }

    protected void writeSection(ReportSection section, ReportTable tbl, PrintWriter out) throws Exception {
        Color bgColor = null;
        boolean printOnNewPage = false;
        boolean visible = false;
        boolean resetPageNumber = false;
        if (section.getScriptObj() != null) {
            bgColor = section.getBgColor();
            printOnNewPage = section.isPrintOnNewPage();
            visible = section.isVisible();
            resetPageNumber = section.isResetPageNumber();
            section.getScriptObj().applyScript(tbl, 1, 1, 1, 1, this.report, section);
        }
        this.writeSectionHelper(section, tbl, out);
        for (int i = 0; i < section.getSectionCount(); ++i) {
            this.writeSection(section.getSection(i), tbl);
        }
        if (section.getScriptObj() != null) {
            section.setBgColor(bgColor);
            section.setPrintOnNewPage(printOnNewPage);
            section.setVisible(visible);
            section.setResetPageNumber(resetPageNumber);
        }
    }

    protected void writeSectionHelper(ReportSection cellArray, ReportTable tbl, PrintWriter out) throws Exception {
        int r;
        if (cellArray == null || cellArray.getData() == null || !cellArray.isVisible()) {
            return;
        }
        Vector cells = cellArray.getTextCellForHTML();
        cells = ReportUI.removeSecuredInvisibleCols(cells, tbl, this.report.getPreviewSecurityLevel());
        Vector subReportTree = cellArray.getSubReportForHTML();
        for (r = 0; r < cells.size(); ++r) {
            ReportCell[] tmp = (ReportCell[])cells.elementAt(r);
            Vector sectionCells = this.getSectionCells(cellArray);
            int ctOfCells = tmp.length;
            if (sectionCells != null) {
                ctOfCells += sectionCells.size();
            }
            for (ReportCell element : tmp) {
                ReportCell cell = tbl.formatCell(element, this.report);
                if (cell.isVisible()) continue;
                --ctOfCells;
            }
            int visibleCell = 0;
            for (int c = 0; c < tmp.length; ++c) {
                ReportCell cell = tbl.formatCell(tmp[c], this.report);
                if (!cell.isVisible()) continue;
                if (++visibleCell == ctOfCells) {
                    out.print(this.getText(cell, tbl) + this.endDelimiter);
                    continue;
                }
                out.print(this.getText(cell, tbl) + this.getSeparator(c, tmp.length));
            }
            if (sectionCells == null) continue;
            for (int j = 0; j < sectionCells.size(); ++j) {
                ReportCell cell = (ReportCell)sectionCells.elementAt(j);
                if (!cell.isVisible()) continue;
                out.print(this.getText(cell, tbl) + this.getSeparator(j + tmp.length, ctOfCells));
            }
        }
        if (subReportTree.size() <= 0) {
            return;
        }
        for (r = 0; r < subReportTree.size(); ++r) {
            ReportCell[] subReports = (ReportCell[])subReportTree.elementAt(r);
            Vector[] buffers = new Vector[subReports.length];
            for (int c = 0; c < subReports.length; ++c) {
                buffers[c] = this.writeSubReport((SubReportObject)subReports[c], tbl);
            }
            Vector subReportList = this.sortVectorSize(buffers);
            for (int i = 0; i < subReportList.size(); ++i) {
                Vector rowList = (Vector)subReportList.elementAt(i);
                int rowCt = ((Vector)rowList.elementAt(0)).size();
                for (int c = 0; c < rowList.size(); ++c) {
                    buffers[c] = (Vector)rowList.elementAt(c);
                }
                for (int j = 0; j < rowCt; ++j) {
                    for (int k = 0; k < rowList.size(); ++k) {
                        out.print(buffers[k].elementAt(j).toString() + this.getSeparator(k, rowList.size()));
                    }
                }
            }
        }
    }

    private Vector sortVectorSize(Vector[] buffers) {
        Vector vec = new Vector();
        for (Vector buffer : buffers) {
            boolean addNewRow = true;
            for (int l = 0; l < vec.size(); ++l) {
                int bufSize = ((Vector)((Vector)vec.elementAt(l)).elementAt(0)).size();
                if (bufSize != buffer.size()) continue;
                addNewRow = false;
                ((Vector)vec.elementAt(l)).addElement(buffer);
                break;
            }
            if (!addNewRow) continue;
            Vector<Vector> subvec = new Vector<Vector>();
            subvec.addElement(buffer);
            vec.addElement(subvec);
        }
        return vec;
    }

    private Vector writeSubReport(SubReportObject subReport, ReportTable tbl) throws Exception {
        Vector<String> buffer = new Vector<String>();
        ReportCell cell = tbl.formatCell(subReport, 1, 1, 1, 1, this.report);
        if (!cell.isVisible()) {
            return buffer;
        }
        try {
            Report sreport = null;
            if (subReport.hasUsableReport()) {
                sreport = subReport.getSubReport().getReportInfo();
                if (sreport.getQueryParams().size() != 0) {
                    sreport = subReport.reloadReportWithParameters(sreport, this.report, tbl);
                } else if (sreport.dbInfo.getDriverName() != null) {
                    sreport = subReport.loadReport(this.report, tbl);
                } else {
                    try {
                        Report temp = ReloadReport.reloadData(new Report(sreport), false);
                        if (temp != null) {
                            sreport = temp;
                        }
                    }
                    catch (Exception ex) {
                        sreport.getReportTables().elementAt(0).setVisible(false);
                        subReport.setHeight(0.0);
                        this.report.setInitializeReportError(LanguageEncoder.getText("Subreport datasource not found!") + "\n" + IOUtil.getStackTrace(ex));
                    }
                }
            } else {
                sreport = subReport.loadReport(this.report, tbl);
            }
            CSVReport csvReport = new CSVReport(sreport);
            csvReport.copy(this);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            csvReport.exportCSV(out);
            out.close();
            StringReader sReader = new StringReader(out.toString());
            BufferedReader bReader = new BufferedReader(sReader);
            String tmp = null;
            while ((tmp = bReader.readLine()) != null) {
                buffer.addElement(tmp);
            }
            bReader.close();
            sReader.close();
            this.report.addTriggeredAlerts(sreport.getTriggeredAlerts(), sreport.getFileNameWithoutPath());
            return buffer;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to write sub-report", ex);
            return buffer;
        }
    }

    private Vector writeSectionToBuffer(ReportSection sec, ReportTable tbl) {
        Vector<String> buffer = new Vector<String>();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            PrintWriter pWriter = this.report.getExportEncoding() != null ? new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, this.report.getExportEncoding()), true) : new PrintWriter(out, true);
            this.writeSection(sec, tbl, pWriter);
            pWriter.close();
            out.close();
            StringReader sReader = new StringReader(out.toString());
            BufferedReader bReader = new BufferedReader(sReader);
            String tmp = null;
            while ((tmp = bReader.readLine()) != null) {
                buffer.addElement(tmp);
            }
            bReader.close();
            sReader.close();
            return buffer;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Can't write section to buffer", ex);
            return buffer;
        }
    }

    private Vector writeCellsToBuffer(ReportTable tbl) {
        Vector<String> buffer = new Vector<String>();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            PrintWriter pWriter = this.report.getExportEncoding() != null ? new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, this.report.getExportEncoding()), true) : new PrintWriter(out, true);
            this.writeCells(tbl, pWriter);
            pWriter.close();
            out.close();
            StringReader sReader = new StringReader(out.toString());
            BufferedReader bReader = new BufferedReader(sReader);
            String tmp = null;
            while ((tmp = bReader.readLine()) != null) {
                buffer.addElement(tmp);
            }
            bReader.close();
            sReader.close();
            return buffer;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to write cells to buffer", ex);
            return buffer;
        }
    }

    protected void writeCells(ReportTable tbl) throws Exception {
        boolean drawSubReport;
        Color bgColor = null;
        boolean printOnNewPage = false;
        boolean visible = false;
        if (tbl.getScriptObj() != null) {
            bgColor = tbl.getBgColor();
            printOnNewPage = tbl.isPrintOnNewPage();
            visible = tbl.isVisible();
            tbl.getScriptObj().applyScript(tbl, 1, 1, 1, 1, this.report, tbl);
        }
        if (tbl instanceof ReportTreeTable) {
            this.writeTreeCells((ReportTreeTable)tbl);
            return;
        }
        if (!tbl.isVisible()) {
            return;
        }
        ReportSection mSection = tbl.getMasterSection();
        boolean drawMaster = mSection != null && mSection.isVisible() && mSection.getData() != null && mSection.getCellCount() > 0;
        boolean bl = drawSubReport = tbl.getSubReportCount() > 0;
        if (drawSubReport || drawMaster) {
            Vector<Object> subReportTree = new Vector();
            if (drawSubReport) {
                subReportTree = tbl.getSubReportForHTML();
            }
            for (int r = 0; drawMaster || r < subReportTree.size(); ++r) {
                Vector[] buffers;
                ReportCell[] subReports = new ReportCell[]{};
                if (drawSubReport) {
                    subReports = (ReportCell[])subReportTree.elementAt(r);
                }
                if (r == 0) {
                    int masterCt = 0;
                    if (drawMaster) {
                        masterCt = 1;
                    }
                    buffers = new Vector[subReports.length + 1 + masterCt];
                    if (drawMaster) {
                        buffers[0] = this.writeSectionToBuffer(mSection, tbl);
                    }
                    buffers[masterCt] = this.writeCellsToBuffer(tbl);
                    for (int c = 0; c < subReports.length; ++c) {
                        buffers[c + 1 + masterCt] = this.writeSubReport((SubReportObject)subReports[c], tbl);
                    }
                    drawMaster = false;
                } else {
                    buffers = new Vector[subReports.length];
                    for (int c = 0; c < subReports.length; ++c) {
                        buffers[c] = this.writeSubReport((SubReportObject)subReports[c], tbl);
                    }
                }
                Vector subReportList = this.sortVectorSize(buffers);
                for (int i = 0; i < subReportList.size(); ++i) {
                    Vector rowList = (Vector)subReportList.elementAt(i);
                    int rowCt = ((Vector)rowList.elementAt(0)).size();
                    for (int c = 0; c < rowList.size(); ++c) {
                        buffers[c] = (Vector)rowList.elementAt(c);
                    }
                    for (int j = 0; j < rowCt; ++j) {
                        for (int k = 0; k < rowList.size(); ++k) {
                            this.out.print(buffers[k].elementAt(j).toString() + this.getSeparator(k, rowList.size()));
                        }
                    }
                }
            }
        } else {
            this.writeCells(tbl, this.out);
        }
        if (tbl.getScriptObj() != null) {
            tbl.setBgColor(bgColor);
            tbl.setPrintOnNewPage(printOnNewPage);
            tbl.setVisible(visible);
        }
    }

    private void writeCells(ReportTable tbl, PrintWriter out) throws Exception {
        int nRow = tbl.getRowCount();
        this.rows = tbl.getFormattedRows();
        ReportColumn[] col = tbl.getSortedVisibleColumns();
        col = ReportUI.removeSecuredInvisibleCols(col, this.report.getPreviewSecurityLevel());
        for (int i = 0; i < nRow; ++i) {
            int ii = i;
            boolean hasVisibleColumn = false;
            if (tbl.indexArray != null) {
                ii = tbl.indexArray[i];
            }
            this.rowElements = this.getRowElements(ii);
            int ctOfRowElt = 0;
            if (this.rowElements != null) {
                ctOfRowElt = this.rowElements.size();
            }
            int startColIndex = 0;
            int totalVisibleCol = col.length;
            for (ReportColumn element : col) {
                ReportCell cell = tbl.formatCell(element, ii, this.report);
                if (cell.isVisible()) {
                    hasVisibleColumn = true;
                    continue;
                }
                --totalVisibleCol;
            }
            if (hasVisibleColumn) {
                int visibleCol = 0;
                for (int j = 0; j < col.length; ++j) {
                    ReportCell cell = tbl.formatCell(col[j], ii, this.report);
                    if (!cell.isVisible()) continue;
                    if (++visibleCol == totalVisibleCol + ctOfRowElt) {
                        out.print(this.getText(cell, tbl) + this.endDelimiter);
                        continue;
                    }
                    out.print(this.getText(cell, tbl) + this.getSeparator(j, col.length + ctOfRowElt));
                }
                startColIndex = col.length;
            }
            if (this.rowElements != null) {
                for (int j = 0; j < this.rowElements.size(); ++j) {
                    ReportCell elt = (ReportCell)this.rowElements.elementAt(j);
                    if (!elt.isVisible()) continue;
                    out.print(this.getText(tbl.formatCell(elt, this.report), tbl) + this.getSeparator(j + startColIndex, this.rowElements.size() + startColIndex));
                }
            }
            this.rowElements = null;
        }
    }

    protected void writeTreeCells(ReportTreeTable sTbl) throws Exception {
        if (this.treeStructure == null) {
            this.treeStructure = new Vector();
        }
        for (int i = 0; i < sTbl.countSubTable(); ++i) {
            this.treeStructure.addElement(i);
            int idx = sTbl.indexArray == null ? i : sTbl.indexArray[i];
            ReportTable tbl = sTbl.getSubTable(idx);
            this.writeSection(tbl.getHeader(), tbl);
            this.writeCells(tbl);
            this.writeSection(tbl.getFooter(), tbl);
        }
        if (this.treeStructure.size() > 1) {
            this.treeStructure.removeElementAt(this.treeStructure.size() - 1);
        } else {
            this.treeStructure.removeAllElements();
        }
    }

    protected String getText(ReportElement elt, ReportTable tbl) {
        if (!elt.isVisible()) {
            return "";
        }
        if (elt.getFontColor() == null) {
            return "";
        }
        if (elt instanceof ReportRTFObject) {
            return this.quote(((ReportRTFObject)elt).getFullText(this.report, tbl));
        }
        return this.quote(elt.getText());
    }

    private String quote(String text) {
        if (QbUtil.isNullOrEmpty(this.strQuote)) {
            return text;
        }
        return this.strQuote + text.replace(this.strQuote, this.strQuote + this.strQuote) + this.strQuote;
    }

    protected String getSeparator(int index, int totalItem) {
        if (index == totalItem - 1) {
            return this.endDelimiter;
        }
        return this.delimiter;
    }

    protected String getNewlineDelim() {
        int nlDelim = this.report.getExportNewlineDelimiter();
        if (nlDelim == 0) {
            return "\r\n";
        }
        if (nlDelim == 1) {
            return "\r";
        }
        if (nlDelim == 2) {
            return "\n";
        }
        return defaultExportNewlineDelimiter;
    }

    public static void setDefaultNewlineDelim(String platform) {
        defaultNewlineDelimiterPlatform = platform;
        if (platform.equalsIgnoreCase("windows")) {
            defaultExportNewlineDelimiter = "\r\n";
        } else if (platform.equalsIgnoreCase("mac")) {
            defaultExportNewlineDelimiter = "\r";
        } else if (platform.equalsIgnoreCase("others")) {
            defaultExportNewlineDelimiter = "\n";
        } else if (platform.equalsIgnoreCase("system")) {
            defaultExportNewlineDelimiter = System.getProperty("line.separator");
        }
    }

    public static String getDefaultNewlineDelimPlatform() {
        return defaultNewlineDelimiterPlatform;
    }

    protected String getDelimiter(boolean forText) {
        switch (this.report.getExportDelimiter()) {
            case 0: {
                return "\t";
            }
            case 1: {
                return " ";
            }
            case 2: {
                return "  ";
            }
            case 3: {
                return ",";
            }
            case 4: {
                return ";";
            }
            case -1: {
                return forText ? "\t" : ",";
            }
        }
        return "\t";
    }

    protected void writeSection(ReportSection section, ReportTable tbl, Vector preAggCol, Vector resultCol) throws Exception {
        Color bgColor = null;
        boolean printOnNewPage = false;
        boolean visible = false;
        boolean resetPageNumber = false;
        if (section.getScriptObj() != null) {
            bgColor = section.getBgColor();
            printOnNewPage = section.isPrintOnNewPage();
            visible = section.isVisible();
            resetPageNumber = section.isResetPageNumber();
            section.getScriptObj().applyScript(tbl, 1, 1, 1, 1, this.report, section);
        }
        this.writeSectionHelper(section, tbl, preAggCol, resultCol);
        for (int i = 0; i < section.getSectionCount(); ++i) {
            this.writeSectionHelper(section.getSection(i), tbl, preAggCol, resultCol);
        }
        if (section.getScriptObj() != null) {
            section.setBgColor(bgColor);
            section.setPrintOnNewPage(printOnNewPage);
            section.setVisible(visible);
            section.setResetPageNumber(resetPageNumber);
        }
    }

    protected void writeSectionHelper(ReportSection cellArray, ReportTable tbl, Vector preAggCol, Vector resultCol) throws Exception {
        if (cellArray == null || !cellArray.isVisible() || cellArray.getData() == null) {
            return;
        }
        Vector cells = cellArray.getCellForHTML();
        cells = ReportUI.removeSecuredInvisibleCols(cells, tbl, this.report.getPreviewSecurityLevel());
        for (int r = 0; r < cells.size(); ++r) {
            ReportCell[] tmp = (ReportCell[])cells.elementAt(r);
            int totalVisibleCol = tmp.length;
            for (ReportCell element : tmp) {
                ReportCell rc = tbl.formatCell(element, -1, 1, 1, 1, 1, this.report, false, preAggCol, resultCol);
                if (rc.isVisible()) continue;
                --totalVisibleCol;
            }
            int visibleCol = 0;
            for (int c = 0; c < tmp.length; ++c) {
                ReportCell rc = tbl.formatCell(tmp[c], -1, 1, 1, 1, 1, this.report, false, preAggCol, resultCol);
                if (!rc.isVisible()) continue;
                if (++visibleCol == totalVisibleCol) {
                    this.out.print(this.getText(rc, tbl) + this.endDelimiter);
                    continue;
                }
                this.out.print(this.getText(rc, tbl) + this.getSeparator(c, tmp.length));
            }
        }
    }

    protected int[] getTreeLevel() {
        if (this.treeStructure != null && this.treeStructure.size() > 0) {
            int[] values = new int[this.treeStructure.size()];
            for (int i = 0; i < this.treeStructure.size(); ++i) {
                values[i] = (Integer)this.treeStructure.elementAt(i);
            }
            return values;
        }
        return null;
    }

    protected Vector getRowElements(int rowIndex) {
        FormattedRow row;
        FormattedRowKey key;
        if (this.rows != null && this.rows.containsKey(key = this.treeStructure == null || this.treeStructure.size() == 0 ? new FormattedRowKey(rowIndex, null) : new FormattedRowKey(rowIndex, this.getTreeLevel())) && (row = (FormattedRow)this.rows.get(key)) != null) {
            this.rowElements = row.getRowElements();
            return this.rowElements;
        }
        return null;
    }

    protected Vector getSectionCells(ReportSection section) {
        if (this.treeStructure != null && section.hasSectionCells(this.treeStructure)) {
            return section.getSectionCells(this.treeStructure);
        }
        return null;
    }

    public void startToGetData(ReportTable table) throws Exception {
    }
}

