/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.util.Vector;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.Aggregation;
import quadbase.reportdesigner.report.CSVReport;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.ColDataBuffer;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.Report;

public class CSVReportColumnar
extends CSVReport {
    Vector footerAggCol;
    Vector footerResCol;
    private ColDataBuffer colDataBuffer;
    int startIndex = 0;
    int displayRow = Report.getInputDataBlockSize();

    public CSVReportColumnar(Report report) {
        super(report);
    }

    @Override
    void formatTable() throws Exception {
    }

    @Override
    protected void writeTable(ReportTable tbl) throws Exception {
        this.writeSection(tbl.getHeader(), tbl);
        this.footerAggCol = new Vector();
        this.footerResCol = new Vector();
        Aggregation.getAggrColumn(tbl.getFooter(), tbl, this.footerAggCol, this.footerResCol);
        Aggregation.getAggrColumn(this.report.getReportFooter(), tbl, this.footerAggCol, this.footerResCol);
        this.writeCells(tbl);
        this.writeSection(tbl.getFooter(), tbl, this.footerAggCol, this.footerResCol);
        this.colDataBuffer.join();
    }

    private void formatTable(ReportTable tbl, int startIndex, int displayRow) throws Exception {
        while (!this.colDataBuffer.isDataReady(startIndex)) {
            Thread.sleep(100L);
        }
        ColData[] colData = this.colDataBuffer.getData(startIndex);
        this.colDataBuffer.clearDataBuffer(startIndex);
        for (int i = 0; i < this.report.colInfo.length; ++i) {
            int m = this.report.colInfo[i].getMapping();
            if (m >= 0) {
                tbl.getColumn(i).setDataSet(colData[m].getDataSet());
                continue;
            }
            Formula formulaObj = this.report.colInfo[i].getFormulaObj();
            if (formulaObj == null) continue;
            Object obj = null;
            int rowCt = tbl.getRowCount();
            for (int j = 0; j < rowCt; ++j) {
                obj = formulaObj.getValue(tbl, j, 1, 1, 1, 1, this.report, null, null, false, null, null, colData);
                tbl.getColumn(i).addData(obj);
            }
        }
    }

    @Override
    public void startToGetData(ReportTable tbl) throws Exception {
        this.colDataBuffer = new ColDataBuffer(this.report.dbInfo, this.report.originalIResultSet, this.startIndex, this.displayRow);
        this.colDataBuffer.start();
        this.formatTable(tbl, this.startIndex, this.displayRow);
    }

    @Override
    protected void writeCells(ReportTable tbl) throws Exception {
        if (!tbl.isVisible()) {
            return;
        }
        int curRow = 0;
        int nRow = 0;
        boolean firstTime = true;
        do {
            if (!firstTime) {
                this.formatTable(tbl, this.startIndex, this.displayRow);
            }
            firstTime = false;
            nRow = tbl.getRowCount();
            ReportColumn[] col = tbl.getSortedVisibleColumns();
            ReportColumn[] originalCol = tbl.getVisibleColumnList();
            this.startIndex += nRow;
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < col.length; ++j) {
                    ReportCell cell = tbl.formatCell(col[j], i, this.report);
                    if (cell.isVisible()) {
                        this.out.print(this.getText(cell, tbl) + this.getSeparator(j, col.length));
                    }
                    Aggregation.calculateAggregation(originalCol[j].getData(i), j, this.footerAggCol, this.footerResCol);
                }
                ++curRow;
            }
        } while (this.displayRow == nRow);
    }
}

