/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.awt.Font;
import java.util.Vector;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.report.ArraySet;
import quadbase.reportdesigner.report.ERStatement;
import quadbase.reportdesigner.report.Expression;
import quadbase.reportdesigner.report.Function;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.ParseException;
import quadbase.reportdesigner.report.ReportAlertObject;
import quadbase.reportdesigner.report.Script;
import quadbase.reportdesigner.report.ScriptReportElement;

public class CellAttrAssignStmt
implements ERStatement {
    String cellAttr;
    Vector values = new Vector();
    Vector operandValues = new Vector();
    ArraySet cellAttrArray;
    Script script;

    public CellAttrAssignStmt(String cellAttr, Operand op) {
        this.cellAttr = cellAttr;
        if (op instanceof ArraySet) {
            int i;
            if (((ArraySet)op).size() == 0 && ((ArraySet)op).operandSize() == 0) {
                this.cellAttrArray = (ArraySet)op;
            }
            for (i = 0; i < ((ArraySet)op).size(); ++i) {
                this.values.addElement(((ArraySet)op).getElement(i));
            }
            for (i = 0; i < ((ArraySet)op).operandSize(); ++i) {
                this.operandValues.addElement(((ArraySet)op).getOperandElement(i));
            }
        } else {
            this.operandValues.addElement(op);
        }
    }

    public String getCellAttr() {
        return this.cellAttr;
    }

    public void setCellAttr(String cellAttr) {
        this.cellAttr = cellAttr;
    }

    public Vector getValues() {
        return this.values;
    }

    public void setValues(Vector values) {
        this.values = values;
    }

    @Override
    public void execute(Script s) throws Exception {
        this.script = s;
        if (this.operandValues.size() > 0) {
            this.values = new Vector();
        }
        for (int i = 0; i < this.operandValues.size(); ++i) {
            Object object = ((Operand)this.operandValues.elementAt(i)).getValue(s.table, s.index, s.page, s.section, s.totalPages, s.totalSections, s.report, s.cell, s.dataobj, true);
            this.values.addElement(object);
        }
        if (this.cellAttrArray != null) {
            this.values = new Vector();
            Object object = this.cellAttrArray.getValue(s.table, s.index, s.page, s.section, s.totalPages, s.totalSections, s.report, s.cell, s.dataobj);
            if (object instanceof ArraySet) {
                for (int i = 0; i < ((ArraySet)object).size(); ++i) {
                    this.values.addElement(((ArraySet)object).getElement(i));
                }
            } else {
                for (int i = 0; i < this.cellAttrArray.size(); ++i) {
                    this.values.addElement(this.cellAttrArray.getElement(i));
                }
            }
        }
        if (this.cellAttr.equalsIgnoreCase("value")) {
            if (this.values.elementAt(0) == null) {
                s.cell.setScriptedValue("Q#B#S#V#S#T#N");
            } else {
                s.cell.setScriptedValue(this.values.elementAt(0));
            }
        } else if (this.cellAttr.equalsIgnoreCase("bgcolor")) {
            if (s.cell != null) {
                s.cell.setBgColor(this.getColor("BGCOLOR"));
            }
            if (s.tableElt != null) {
                s.tableElt.setBgColor(this.getColor("BGCOLOR"));
            }
        } else if (this.cellAttr.equalsIgnoreCase("fontcolor")) {
            s.cell.setFontColor(this.getColor("FONTCOLOR"));
        } else if (this.cellAttr.equalsIgnoreCase("font")) {
            s.cell.setFont(this.getFont());
            s.cell.setUnderline(this.isUnderline());
        } else if (this.cellAttr.equalsIgnoreCase("align")) {
            s.cell.setAlign(this.getAlignment((String)this.values.elementAt(0)));
        } else if (this.cellAttr.equalsIgnoreCase("valign")) {
            s.cell.setVAlign(this.getVAlignment((String)this.values.elementAt(0)));
        } else if (this.cellAttr.equalsIgnoreCase("bordercolor")) {
            s.cell.setBorderColor(this.getColor("BORDERCOLOR"));
        } else if (this.cellAttr.equalsIgnoreCase("borderthickness")) {
            s.cell.setBorderThickness(((Number)this.values.elementAt(0)).intValue());
        } else if (this.cellAttr.equalsIgnoreCase("hyperlink")) {
            if (this.values.size() != 3) {
                throw new ParseException("wrong number of arguments for HYPERLINK");
            }
            s.cell.setLink((String)this.values.elementAt(0));
            s.cell.setHint((String)this.values.elementAt(1));
            s.cell.setTarget((String)this.values.elementAt(2));
        } else if (this.cellAttr.equalsIgnoreCase("xposition")) {
            s.cell.setX(((Number)this.values.elementAt(0)).doubleValue());
        } else if (this.cellAttr.equalsIgnoreCase("yPosition")) {
            s.cell.setY(((Number)this.values.elementAt(0)).doubleValue());
        } else if (this.cellAttr.equalsIgnoreCase("width")) {
            s.cell.setWidth(((Number)this.values.elementAt(0)).doubleValue());
        } else if (this.cellAttr.equalsIgnoreCase("height")) {
            if (s.cell != null) {
                s.cell.setHeight(((Number)this.values.elementAt(0)).doubleValue());
            }
            if (s.tableElt != null) {
                s.tableElt.setHeight(((Number)this.values.elementAt(0)).doubleValue());
            }
        } else if (this.cellAttr.equalsIgnoreCase("bookmark")) {
            s.cell.setBookmark((String)this.values.elementAt(0));
        } else if (this.cellAttr.equalsIgnoreCase("rotation")) {
            if (s.cell != null) {
                int rotation = ((Number)this.values.elementAt(0)).intValue();
                if (rotation != 0 && rotation != -90 && rotation != 90) {
                    throw new ParseException("Invalid value for rotation. Use -90, 0 or 90.");
                }
                s.cell.setRotateAngle(rotation);
            }
        } else if (this.cellAttr.equalsIgnoreCase("visible")) {
            if (s.cell != null) {
                s.cell.setVisible((Boolean)this.values.elementAt(0));
            }
            if (s.tableElt != null) {
                s.tableElt.setVisible((Boolean)this.values.elementAt(0));
            }
        } else if (this.cellAttr.equalsIgnoreCase("print_on_new_page")) {
            if (s.tableElt != null) {
                s.tableElt.setPrintOnNewPage((Boolean)this.values.elementAt(0));
            }
        } else if (this.cellAttr.equalsIgnoreCase("reset_page_number")) {
            if (s.tableElt != null && s.tableElt instanceof ReportSection) {
                ((ReportSection)s.tableElt).setResetPageNumber((Boolean)this.values.elementAt(0));
            }
        } else if (this.cellAttr.equalsIgnoreCase("alert")) {
            if (this.values.size() != 2) {
                throw new ParseException("Wrong number of arguments for alert");
            }
            Vector<ReportAlertObject> alerts = s.report.getTriggeredAlerts();
            boolean found = false;
            for (int i = 0; alerts != null && i < alerts.size(); ++i) {
                ReportAlertObject rao = alerts.get(i);
                if (!rao.getAlertName().equals(this.values.elementAt(0))) continue;
                found = true;
                rao.addDesc((String)this.values.elementAt(1));
            }
            if (!found) {
                s.report.addTriggeredAlert(new ReportAlertObject(s.getName(), (String)this.values.elementAt(0), (String)this.values.elementAt(1), null, false));
            }
        } else {
            throw new Exception(LanguageEncoder.getText("Invalid statement"));
        }
    }

    @Override
    public void testExecute(Script script) throws Exception {
        this.execute(script);
    }

    private Color getColor(String s) throws Exception {
        if (this.values.size() != 3) {
            throw new ParseException("wrong number of arguments for " + s);
        }
        return new Color(((Number)this.values.elementAt(0)).intValue(), ((Number)this.values.elementAt(1)).intValue(), ((Number)this.values.elementAt(2)).intValue());
    }

    private Font getFont() throws Exception {
        if (this.values.size() != 3 && this.values.size() != 4) {
            throw new ParseException("wrong number of arguments for FONT");
        }
        return FontTable.newFont((String)this.values.elementAt(0), this.getFontStyle((String)this.values.elementAt(1)), ((Number)this.values.elementAt(2)).intValue());
    }

    private boolean isUnderline() throws Exception {
        if (this.values.size() == 3) {
            return false;
        }
        return (Boolean)this.values.elementAt(3);
    }

    private int getFontStyle(String s) throws Exception {
        int tmp = 0;
        if (s.indexOf("BOLD") >= 0) {
            tmp |= 1;
        }
        if (s.indexOf("ITALIC") >= 0) {
            tmp |= 2;
        }
        return tmp;
    }

    private short getAlignment(String s) throws Exception {
        if (s.toUpperCase().indexOf("LEFT") >= 0) {
            return 1;
        }
        if (s.toUpperCase().indexOf("RIGHT") >= 0) {
            return 2;
        }
        return 0;
    }

    private short getVAlignment(String s) throws Exception {
        if (s.toUpperCase().indexOf("TOP") >= 0) {
            return 1;
        }
        if (s.toUpperCase().indexOf("BOTTOM") >= 0) {
            return 2;
        }
        return 0;
    }

    @Override
    public void setThisDataType(int datatype) {
        if (this.operandValues == null) {
            return;
        }
        for (int i = 0; i < this.operandValues.size(); ++i) {
            if (this.operandValues.elementAt(i) instanceof ScriptReportElement) {
                ((ScriptReportElement)this.operandValues.elementAt(i)).setThisDataType(datatype);
                continue;
            }
            if (this.operandValues.elementAt(i) instanceof Function) {
                ((Function)this.operandValues.elementAt(i)).setThisDataType(datatype);
                continue;
            }
            if (!(this.operandValues.elementAt(i) instanceof Expression)) continue;
            ((Expression)this.operandValues.elementAt(i)).setThisDataType(datatype);
        }
    }
}

