/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.LoadChart;
import quadbase.chart.ReloadChart;
import quadbase.chart.chart3d.ExportChart3D;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.common.awt.Arc;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.UseDefaultParam;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.CBAggrColFooter;
import quadbase.reportdesigner.ReportElements.CBColumnFooter;
import quadbase.reportdesigner.ReportElements.CBColumnHeader;
import quadbase.reportdesigner.ReportElements.RBColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.report.CrossTabTable;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.ImageMapNode;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.IChartModifier;

public class ChartObject {
    private static final Logger LOGGER = Logger.getLogger(ChartObject.class.getName());
    public static int countHelper;
    public static Hashtable<String, Object> memCache;
    public static boolean useCache;

    private static void addChartToCache(ReportChartObject cell, Object chart) {
        String key = cell.getID();
        LOGGER.finest("Preload chart: put - " + key + " , " + chart);
        memCache.put(key, chart);
    }

    private static Chart getChartFromCache(ReportChartObject cell) {
        String key = cell.getID();
        LOGGER.finest("Preload chart: get - " + key);
        Object res = memCache.get(key);
        if (res == null) {
            return null;
        }
        if (res instanceof String) {
            if (res.toString().equals("NULL")) {
                LOGGER.finest("Preload chart: get - null");
                return null;
            }
            if (res.toString().equals("WAIT")) {
                LOGGER.finest("Preload chart: get - wait");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return ChartObject.getChartFromCache(cell);
            }
        }
        return (Chart)res;
    }

    private static boolean isCached(ReportChartObject cell) {
        return memCache.containsKey(cell.getID());
    }

    public static void preLoadCharts(Report report, Vector preSetParam) {
        useCache = true;
        Vector<ReportChartObject> charts = report.getAllCharts();
        LOGGER.finest("Preload chart: pre-load charts");
        for (int i = 0; i < charts.size(); ++i) {
            ReportChartObject cObj = charts.elementAt(i);
            if (ChartObject.isCached(cObj) || cObj.isReportDataUsed() || cObj.getParameterMap() != null) continue;
            StoreChartThread thread = new StoreChartThread(report, cObj, preSetParam);
            thread.start();
        }
        LOGGER.finest("Preload chart: pre-load charts done");
    }

    public static Chart getIndependentChart(Report report, ReportChartObject cell, Vector preSetParams) throws Exception {
        IChartModifier chartMod;
        if (cell.isReportDataUsed()) {
            return null;
        }
        Chart chart = null;
        if (useCache) {
            chart = ChartObject.getChartFromCache(cell);
        }
        if (chart == null) {
            LOGGER.finest("Preload chart: create independent chart");
            chart = ChartObject.createIndependentChart(report, cell, preSetParams);
        }
        if ((chartMod = cell.getChartModifier()) != null) {
            chart = chartMod.modifyChart(chart).setNewData(null);
        }
        return chart;
    }

    private static Chart createIndependentChart(Report report, ReportChartObject cell, Vector preSetParams) throws Exception {
        if (cell.isReportDataUsed()) {
            return null;
        }
        boolean isTemplate = cell.getText().toUpperCase().endsWith(".TPL");
        if (cell.getChart() != null) {
            Chart temp = cell.getChart().setNewData(null);
            if (temp.getQueryFileInfo() == null || preSetParams == null) {
                return temp;
            }
            if (preSetParams.elementAt(0) instanceof QueryInParamSet) {
                if (preSetParams.size() > 0) {
                    temp.getQueryFileInfo().setInSet((QueryInParamSet)preSetParams.elementAt(0));
                }
            } else {
                QueryInParam[] ps = temp.getQueryFileInfo().getInSet().getParameter();
                Object[] values = (Object[])preSetParams.elementAt(0);
                int unMappedCt = 0;
                for (Object value : values) {
                    if (value == null || !value.equals("UnMapped")) continue;
                    ++unMappedCt;
                }
                if (unMappedCt > 0) {
                    if (temp.isPrevParamPrompt()) {
                        QueryInParam[] unMappedParam = new QueryInParam[unMappedCt];
                        unMappedCt = 0;
                        for (int i = 0; i < values.length; ++i) {
                            if (values[i] == null || !values[i].equals("UnMapped")) continue;
                            unMappedParam[unMappedCt++] = ps[i];
                        }
                        DBInfoBasic newDBInfo = temp.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(temp.dbInfo.getJNDIName(), temp.dbInfo.getQuery(), temp.dbInfo.getEnvProperties()) : new DBInfoBasic(temp.dbInfo.getURLString(), temp.dbInfo.getDriverName(), temp.dbInfo.getUserID(), temp.dbInfo.getPassword(), temp.dbInfo.getQuery(), temp.dbInfo.getAdditionalDb());
                        QueryFileInfo qfi = new QueryFileInfo(((QueryFileInfo)temp.dbInfo).getProductName(), ((QueryFileInfo)temp.dbInfo).getVersion(), newDBInfo, new QueryInParamSet(unMappedParam));
                        Vector<QueryInParamSet> parameter = QueryFileInfo.getParameter(qfi, false, true, true, false, true);
                        unMappedCt = 0;
                        QueryInParam[] params = parameter.elementAt(0).getParameter();
                        for (int i = 0; i < values.length; ++i) {
                            if (values[i] != null && values[i].equals("UnMapped")) {
                                ps[i].setValue(params[unMappedCt++].getValue());
                                continue;
                            }
                            ps[i].setValue(values[i]);
                        }
                    } else {
                        for (int i = 0; i < values.length; ++i) {
                            if (values[i] != null && values[i].equals("UnMapped")) {
                                if (ps[i].getValue() != null && !ps[i].equals("UnMapped")) continue;
                                ps[i].setValue(ps[i].getDefaultValue(temp.getQueryFileInfo()));
                                continue;
                            }
                            ps[i].setValue(values[i]);
                        }
                    }
                } else {
                    for (int i = 0; i < ps.length; ++i) {
                        if (ps[i] instanceof QueryMultiValueInParam && values[i] instanceof Vector) {
                            ((QueryMultiValueInParam)ps[i]).setValues((Vector)values[i]);
                            continue;
                        }
                        if (values[i] != null && values[i] instanceof UseDefaultParam) {
                            ps[i].setValue(ps[i].getDefaultValue(temp.getQueryFileInfo()));
                            continue;
                        }
                        ps[i].setValue(values[i]);
                    }
                }
            }
            return temp;
        }
        if (cell.getBytes() != null) {
            byte[] bytes = null;
            if (bytes == null || bytes.length == 0) {
                bytes = cell.getBytes();
            }
            return ChartObject.openChart(new ByteArrayInputStream(bytes), null, isTemplate, preSetParams);
        }
        return ChartObject.openChart(report.getSubFilesTable(), cell.getText(), null, preSetParams);
    }

    public static Chart getReportDataUsedChart(Report report, ReportTable tbl, ReportCell[] cells, ReportChartObject cell, Vector preSetParams) throws Exception {
        if (!cell.isReportDataUsed()) {
            return null;
        }
        if (!cell.isSectionDataIncluded()) {
            cells = null;
        }
        Chart chart = null;
        String text = cell.getText(report.getSubFilesTable());
        chart = text != null && !text.equals("") && !text.toLowerCase().endsWith(".cht") && !text.toLowerCase().endsWith(".tpl") && !text.toLowerCase().endsWith(".pac") && !text.toLowerCase().endsWith(".qch") && !text.toLowerCase().endsWith(".xml") ? ChartObject.openChart(report.getSubFilesTable(), cell.getText(), ChartObject.getColData(report, tbl, cells, cell.isSummaryDataUsed(), cell.getColDataMapping()), preSetParams) : (cell.getChart() != null ? cell.getChart().setNewData(ChartObject.getColData(report, tbl, cells, cell.isSummaryDataUsed(), cell.getColDataMapping())) : (cell.getBytes() != null ? ChartObject.openChart(new ByteArrayInputStream(cell.getBytes()), ChartObject.getColData(report, tbl, cells, cell.isSummaryDataUsed(), cell.getColDataMapping()), true, preSetParams) : ChartObject.openChart(report.getSubFilesTable(), cell.getText(), ChartObject.getColData(report, tbl, cells, cell.isSummaryDataUsed(), cell.getColDataMapping()), preSetParams)));
        IChartModifier chartMod = cell.getChartModifier();
        if (chartMod != null) {
            chart = chartMod.modifyChart(chart).setNewData(null);
        }
        return chart;
    }

    public static Vector getPresetParams(Report report, ReportTable tbl, ReportChartObject cell) {
        return ChartObject.getPresetParams(report, tbl, cell, true);
    }

    public static Vector<Object[]> getPresetParams(Report report, ReportTable tbl, ReportChartObject cell, boolean useDefaultWhenValNull) {
        String[] parameterMap = cell.getParameterMap();
        if (parameterMap == null) {
            return null;
        }
        Object[] parameters = new Object[parameterMap.length];
        for (int i = 0; i < parameterMap.length; ++i) {
            if (parameterMap[i] == null || parameterMap[i].equals("")) continue;
            Object value = null;
            try {
                int index = ChartObject.getColumnIndex(tbl, parameterMap[i]);
                if (index == -1) continue;
                String form = "COL(" + index + ")";
                ByteArrayInputStream inputStream = new ByteArrayInputStream(form.getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                Formula formula = new Formula("IJ123JI", form);
                NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                formula.setFormula(parser.parse(report.formulas, report.getQueryParameters(), report.getFormulaParameters(), "IJ123JI"));
                value = formula.getValue(tbl, 0, 1, 1, 1, 1, report, new ReportCell(), new Object());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to process parameter mapping", ex);
            }
            parameters[i] = value != null ? value : (useDefaultWhenValNull ? new UseDefaultParam() : null);
        }
        Vector<Object[]> params = new Vector<Object[]>();
        params.addElement(parameters);
        return params;
    }

    public static void draw(Graphics g, Report report, ReportTable tbl, ReportCell[] cells, ReportChartObject cell, int width, int height, Vector<ImageMapNode> imageMap, int xoffset, int yoffset, int[] mapping, byte[] drillByteArray, String drillFileName, String drillUserObject, int drillIndex, String drillDownLinkPrefix) throws Exception {
        ChartObject.draw(g, report, tbl, cells, cell, width, height, imageMap, xoffset, yoffset, mapping, drillByteArray, drillFileName, drillUserObject, drillIndex, drillDownLinkPrefix, null, null);
    }

    public static void draw(Graphics g, Report report, ReportTable tbl, ReportCell[] cells, ReportChartObject cell, int width, int height, Vector<ImageMapNode> imageMap, int xoffset, int yoffset, int[] mapping, byte[] drillByteArray, String drillFileName, String drillUserObject, int drillIndex, String drillDownLinkPrefix, Vector preSetParams, Chart chart) throws Exception {
        boolean reportDrillDown;
        if (preSetParams == null) {
            preSetParams = ChartObject.getPresetParams(report, tbl, cell);
        }
        if (chart == null) {
            chart = !cell.isReportDataUsed() ? ChartObject.getIndependentChart(report, cell, preSetParams) : ChartObject.getReportDataUsedChart(report, tbl, cells, cell, preSetParams);
        }
        chart.setChartInReport(true);
        boolean bl = reportDrillDown = mapping != null && cell.isReportDataUsed();
        if (imageMap != null && (reportDrillDown || cell.getLink().equals(""))) {
            chart.imagemap = true;
        }
        if (reportDrillDown) {
            chart.setReportDrillDownMapping(mapping);
            chart.setReportDrillDownLinkPrefix(drillDownLinkPrefix);
        }
        if (chart.showTable()) {
            chart.getTable().resizeTable(width, height);
        }
        chart.draw(g, IOUtil.getOffScreenComponent(), width, height);
        report.addTriggeredAlerts(chart.getTriggeredAlertDetails(), new File(cell.getText()).getName());
        if (!chart.imagemap) {
            return;
        }
        ExportChart3D.createImageMapForFaceObject(chart);
        Vector<quadbase.chart.ImageMapNode> mapList = chart.cgraphics.maplist;
        for (int i = 0; i < mapList.size(); ++i) {
            quadbase.chart.ImageMapNode node = mapList.elementAt(i);
            Object obj = node.obj;
            obj = ChartObject.translateObject(obj, xoffset, yoffset);
            ImageMapNode imgNode = null;
            if (reportDrillDown && mapping != null) {
                Object[] values = new Object[mapping.length];
                if ((values = ChartObject.getValues(values, node.link)) != null) {
                    imgNode = new ImageMapNode(obj, null, drillByteArray, drillFileName != null ? drillFileName : node.link, drillUserObject, values, drillIndex, report.currentNode.getFileName());
                }
            } else {
                imgNode = new ImageMapNode(obj, node.link, node.target, node.hint);
            }
            if (imgNode == null || imageMap == null) continue;
            imageMap.addElement(imgNode);
        }
    }

    private static ColData[] getSummaryColData(Report report, ReportTable tbl, ReportCell[] orgCells) {
        try {
            CrossTabTable crossTbl = (CrossTabTable)report.getReportTables().elementAt(0);
            int[] fieldsCount = crossTbl.getFieldsCount();
            ColData[] colData = null;
            int rowCt = 0;
            if (report.isShowRowAggregationGrandTotal()) {
                int i;
                colData = new ColData[fieldsCount.length * 2 + 1];
                for (int i2 = 0; i2 < fieldsCount.length; ++i2) {
                    rowCt = rowCt == 0 ? fieldsCount[i2] : (rowCt *= fieldsCount[i2]);
                    colData[i2 * 2] = new ColData("Level" + i2, 12, colData.length);
                    int tmpType = (Integer)ChartObject.findValue(orgCells, i2, 0, 0, fieldsCount, report, tbl)[1];
                    colData[i2 * 2 + 1] = new ColData("Level" + i2 + "_VAL", tmpType, colData.length);
                }
                ReportCell[] hdCells = crossTbl.getHeader().getCells();
                Vector[] names = new Vector[fieldsCount.length];
                for (i = 0; i < fieldsCount.length; ++i) {
                    names[i] = new Vector();
                    for (int j = 0; j < fieldsCount[i]; ++j) {
                        names[i].addElement(ChartObject.findHeader(hdCells, report, tbl, i, j, fieldsCount));
                    }
                }
                for (i = 0; i < fieldsCount.length; ++i) {
                    int k;
                    int repeatHeader = 1;
                    for (int k2 = i + 1; k2 < fieldsCount.length; ++k2) {
                        repeatHeader *= fieldsCount[k2];
                    }
                    int repeatSet = 1;
                    for (k = 0; k < i; ++k) {
                        repeatSet *= fieldsCount[k];
                    }
                    for (k = 0; k < repeatSet; ++k) {
                        for (int l = 0; l < names[i].size(); ++l) {
                            Object tmpName = names[i].elementAt(l);
                            Object tmpValue = ChartObject.findValue(orgCells, i, l, k, fieldsCount, report, tbl)[0];
                            for (int m = 0; m < repeatHeader; ++m) {
                                colData[i * 2].add(tmpName);
                                colData[i * 2 + 1].add(tmpValue);
                            }
                        }
                    }
                }
            } else {
                int i;
                int lastFC = fieldsCount.length - 1;
                colData = new ColData[fieldsCount.length + 1 + 1];
                for (int i3 = 0; i3 < fieldsCount.length; ++i3) {
                    rowCt = rowCt == 0 ? fieldsCount[i3] : (rowCt *= fieldsCount[i3]);
                    colData[i3] = new ColData("Level" + i3, 12, colData.length);
                }
                int tmpType = (Integer)ChartObject.findValue(orgCells, lastFC, 0, 0, fieldsCount, report, tbl)[1];
                colData[lastFC + 1] = new ColData("VAL", tmpType, colData.length);
                ReportCell[] hdCells = crossTbl.getHeader().getCells();
                Vector[] names = new Vector[fieldsCount.length];
                for (i = 0; i < fieldsCount.length; ++i) {
                    names[i] = new Vector();
                    for (int j = 0; j < fieldsCount[i]; ++j) {
                        names[i].addElement(ChartObject.findHeader(hdCells, report, tbl, i, j, fieldsCount));
                    }
                }
                for (i = 0; i < fieldsCount.length; ++i) {
                    int k;
                    int repeatHeader = 1;
                    for (int k3 = i + 1; k3 < fieldsCount.length; ++k3) {
                        repeatHeader *= fieldsCount[k3];
                    }
                    int repeatSet = 1;
                    for (k = 0; k < i; ++k) {
                        repeatSet *= fieldsCount[k];
                    }
                    for (k = 0; k < repeatSet; ++k) {
                        for (int l = 0; l < names[i].size(); ++l) {
                            Object tmpName = names[i].elementAt(l);
                            for (int m = 0; m < repeatHeader; ++m) {
                                colData[i].add(tmpName);
                            }
                            if (i != lastFC) continue;
                            Object tmpValue = ChartObject.findValue(orgCells, i, l, k, fieldsCount, report, tbl)[0];
                            colData[lastFC + 1].add(tmpValue);
                        }
                    }
                }
            }
            colData[colData.length - 1] = new ColData("qbCount", 4, colData.length);
            for (int j = 0; j < rowCt; ++j) {
                colData[colData.length - 1].add(j);
            }
            return colData;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to get summary col data", ex);
            return null;
        }
    }

    private static String findHeader(ReportCell[] hdCells, Report report, ReportTable tbl, int i, int j, int[] fieldsCount) {
        int ct = 0;
        if (i == fieldsCount.length - 1) {
            for (ReportCell hdCell : hdCells) {
                if (!(hdCell instanceof CBColumnHeader)) continue;
                if (ct == j) {
                    if ((hdCell.getText() == null || hdCell.getText().equals("")) && hdCell.getFormulaObj() != null) {
                        try {
                            Object dataVal = hdCell.getFormulaObj().getValue(tbl, 0, 1, 1, 1, 1, report, hdCell, null, true);
                            if (dataVal != null) {
                                hdCell.setText(dataVal.toString());
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINE, "Cannot get formula object value", ex);
                        }
                    }
                    return hdCell.getText();
                }
                ++ct;
            }
        } else {
            for (ReportCell hdCell : hdCells) {
                if (!(hdCell instanceof RBColumnHeader) || ((RBColumnHeader)hdCell).getColBreakLevel() != i) continue;
                if (ct == j) {
                    return hdCell.getText();
                }
                ++ct;
            }
        }
        return "NULL";
    }

    private static Object[] findValue(ReportCell[] ftCells, int i, int j, int setIdx, int[] fieldsCount, Report report, ReportTable tbl) {
        int ct = 0;
        j = setIdx * fieldsCount[i] + j;
        if (i == fieldsCount.length - 1) {
            for (ReportCell ftCell : ftCells) {
                if (!(ftCell instanceof CBColumnFooter)) continue;
                if (ct == j) {
                    return ChartObject.getValue(ftCell, report, tbl);
                }
                ++ct;
            }
        } else {
            for (ReportCell ftCell : ftCells) {
                if (!(ftCell instanceof CBAggrColFooter) || ((CBAggrColFooter)ftCell).getColBreakLevel() != fieldsCount.length - 2 - i) continue;
                if (ct == j) {
                    return ChartObject.getValue(ftCell, report, tbl);
                }
                ++ct;
            }
        }
        Object[] nullVal = new Object[]{"NULL", 12};
        return nullVal;
    }

    private static Object[] getValue(ReportCell cell, Report report, ReportTable tbl) {
        int type = 12;
        Object dataVal = null;
        try {
            if (cell.getFormulaObj() != null) {
                cell.getFormulaObj().getDatatype(report);
                type = cell.getFormulaObj().getSQLType();
                dataVal = cell.getFormulaObj().getValue(tbl, 0, 1, 1, 1, 1, report, cell, null, true);
            } else if (cell.getFormula() != null) {
                type = cell.getSQLType();
                dataVal = tbl.getValue(cell, 1, 1, 1, 1, report);
            } else {
                type = 12;
                dataVal = cell.getText();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot get value", ex);
        }
        Object[] retVal = new Object[]{dataVal, type};
        return retVal;
    }

    public static ColData[] getColData(Report report, ReportTable tbl, ReportCell[] orgCells, boolean useSummaryData, String[] colDataMapping) {
        ColData[] unMappedColData = ChartObject.getUnmappedColData(report, tbl, orgCells, useSummaryData);
        if (colDataMapping == null) {
            return unMappedColData;
        }
        if (unMappedColData == null || unMappedColData.length == 0) {
            return unMappedColData;
        }
        Vector<ColData> oldColData = new Vector<ColData>();
        for (ColData element : unMappedColData) {
            oldColData.add(element);
        }
        Vector<ColData> newColData = new Vector<ColData>();
        int emptyColCt = 0;
        int rowCt = unMappedColData[0].getSize();
        int len = colDataMapping.length;
        if (colDataMapping[len - 2].equals("reportValue")) {
            colDataMapping[len - 2] = "Value";
        }
        if (colDataMapping[len - 3].equals("reportColumnLabel")) {
            colDataMapping[len - 3] = "ColumnLabel";
        }
        for (int i = 0; i < len - 1; ++i) {
            boolean foundIt = false;
            for (int j = 0; j < oldColData.size(); ++j) {
                ColData tmpData = (ColData)oldColData.elementAt(j);
                if (!tmpData.getName().equals(colDataMapping[i])) continue;
                newColData.add(tmpData);
                oldColData.remove(tmpData);
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            ColData tData = new ColData("EMPTY_COL" + emptyColCt, 4, report.colInfo.length);
            ++emptyColCt;
            for (int j = 0; j < rowCt; ++j) {
                tData.add(null);
            }
            newColData.add(tData);
        }
        if (oldColData.size() > 0) {
            newColData.add((ColData)oldColData.lastElement());
        }
        ColData[] res = new ColData[newColData.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (ColData)newColData.elementAt(i);
        }
        return res;
    }

    public static ColData[] getUnmappedColData(Report report, ReportTable tbl, ReportCell[] orgCells, boolean useSummaryData) {
        Vector<ColData> colData;
        int rowCt;
        block50: {
            if (useSummaryData) {
                return ChartObject.getSummaryColData(report, tbl, orgCells);
            }
            countHelper = 0;
            String[] header = new String[tbl.getColumnCount()];
            rowCt = report.getRowCount(tbl);
            colData = new Vector<ColData>();
            for (int i = 0; i < header.length; ++i) {
                header[i] = tbl.getColumn(i).getText();
                int colInfoIndex = report.getColInfoIndex(i);
                int originalDataType = report.getSQLType(report.getColInfoIndex(i));
                ColData colDataI = new ColData(header[i], originalDataType, report.colInfo.length);
                if (report.colInfo[report.getColInfoIndex(i)].getMapping() == -1) {
                    for (int j = 0; j < rowCt; ++j) {
                        try {
                            if (tbl.getColumn(i).getScriptObj() != null) {
                                ReportCell cell = tbl.formatCell(tbl.getColumn(i), j, report);
                                countHelper = j;
                                ReportTable table = ChartObject.findTable(tbl);
                                Object object = report.colInfo[colInfoIndex].getFormulaObj().getValue(table, j, 1, 1, 1, 1, report, null, null, true);
                                if (cell.getScriptedValue() != null) {
                                    if (colDataI.getScriptedVec() == null) {
                                        colDataI.initializeScriptedData();
                                    }
                                    if (cell.getScriptedValue().equals("Q#B#S#V#S#T#N")) {
                                        colDataI.setScriptedValAt("Q#B#S#V#S#T#N", j);
                                    } else {
                                        colDataI.setScriptedValAt(cell.getScriptedValue(), j);
                                    }
                                }
                                colDataI.add(object);
                                continue;
                            }
                            countHelper = j;
                            ReportTable table = ChartObject.findTable(tbl);
                            Object object = report.colInfo[colInfoIndex].getFormulaObj().getValue(table, j, 1, 1, 1, 1, report, null, null, true);
                            colDataI.add(object);
                            continue;
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINEST, "Failed to add object to column data", ex);
                        }
                    }
                } else {
                    Object[] columnData = report.getColumnData(i, tbl);
                    for (int j = 0; j < rowCt; ++j) {
                        if (tbl.getColumn(i).getScriptObj() != null) {
                            ReportCell cell = tbl.formatCell(tbl.getColumn(i), j, report);
                            if (cell.getScriptedValue() != null) {
                                if (colDataI.getScriptedVec() == null) {
                                    colDataI.initializeScriptedData();
                                }
                                if (cell.getScriptedValue().equals("Q#B#S#V#S#T#N")) {
                                    colDataI.setScriptedValAt("Q#B#S#V#S#T#N", j);
                                } else {
                                    colDataI.setScriptedValAt(cell.getScriptedValue(), j);
                                }
                            }
                            colDataI.add(columnData[j]);
                            continue;
                        }
                        colDataI.add(columnData[j]);
                    }
                }
                colData.add(colDataI);
            }
            try {
                Vector<ReportTable> orgTableList = new Vector<ReportTable>();
                ChartObject.findTables(orgTableList, tbl);
                int startIdx = -1;
                boolean startFromHeader = true;
                for (int i = 0; i < orgTableList.size(); ++i) {
                    ReportTable table = orgTableList.elementAt(i);
                    ReportCell[] ocells = table.getHeader().getData(true);
                    if (ocells != null && ocells.length > 0 && orgCells != null && orgCells.length > 0) {
                        for (ReportCell ocell : ocells) {
                            if (!orgCells[0].getID().equals(ocell.getID())) continue;
                            startIdx = i;
                            startFromHeader = true;
                            break;
                        }
                        if (startIdx >= 0) break;
                    }
                    if ((ocells = table.getFooter().getData(true)) == null || ocells.length <= 0 || orgCells == null || orgCells.length <= 0) continue;
                    for (ReportCell ocell : ocells) {
                        if (!orgCells[0].getID().equals(ocell.getID()) && (orgCells.length <= 1 || !orgCells[1].getID().equals(ocell.getID()))) continue;
                        startIdx = i;
                        startFromHeader = false;
                        break;
                    }
                    if (startIdx >= 0) break;
                }
                if (startIdx >= 0) {
                    for (int k = startIdx; k < orgTableList.size(); ++k) {
                        Vector<ReportCell[]> cellsSet = new Vector<ReportCell[]>();
                        ReportTable orgtable = orgTableList.elementAt(k);
                        ReportCell[] hcells = ChartObject.getPlotableCells(orgtable.getHeader().getData(true));
                        ReportCell[] fcells = ChartObject.getPlotableCells(orgtable.getFooter().getData(true));
                        if (startFromHeader) {
                            if (hcells.length > 0) {
                                cellsSet.addElement(hcells);
                            }
                            if (fcells.length > 0) {
                                cellsSet.addElement(fcells);
                            }
                        } else {
                            if (fcells.length > 0) {
                                cellsSet.addElement(fcells);
                            }
                            if (hcells.length > 0) {
                                cellsSet.addElement(hcells);
                            }
                        }
                        for (int h = 0; h < cellsSet.size(); ++h) {
                            ReportCell[] cells;
                            for (ReportCell cell : cells = (ReportCell[])cellsSet.elementAt(h)) {
                                Object dataVal;
                                int j;
                                int type;
                                ColData colDataN = null;
                                if (cell.getFormulaObj() != null) {
                                    if (cell.getFormulaObj().text.trim().startsWith("getHeader(")) continue;
                                    cell.getFormulaObj().getDatatype(report);
                                    type = cell.getFormulaObj().getSQLType();
                                    colDataN = new ColData(ChartObject.getFormulaID(cell, report), type, report.colInfo.length);
                                    j = 0;
                                    while (j < rowCt) {
                                        countHelper = j++;
                                        Vector<ReportTable> tableList = new Vector<ReportTable>();
                                        ReportTable table = ChartObject.findTables(tableList, tbl);
                                        table = tableList.elementAt(k);
                                        dataVal = cell.getFormulaObj().getValue(table, 0, 1, 1, 1, 1, report, cell, null, true);
                                        colDataN.add(dataVal);
                                    }
                                } else if (cell.getFormula() != null) {
                                    type = cell.getSQLType();
                                    colDataN = new ColData(ChartObject.getFormulaID(cell, report), type, report.colInfo.length);
                                    dataVal = tbl.getValue(cell, 1, 1, 1, 1, report);
                                    for (j = 0; j < rowCt; ++j) {
                                        colDataN.add(dataVal);
                                    }
                                } else {
                                    type = 12;
                                    colDataN = new ColData(ChartObject.getFormulaID(cell, report), type, report.colInfo.length);
                                    dataVal = cell.getText();
                                    for (j = 0; j < rowCt; ++j) {
                                        colDataN.add(dataVal);
                                    }
                                }
                                colData.add(colDataN);
                            }
                        }
                    }
                    break block50;
                }
                if (ChartObject.getPlotableCells(orgCells).length > 0 && !report.getFileName().endsWith(".qrp")) {
                    ReportCell[] cells;
                    for (ReportCell cell : cells = ChartObject.getPlotableCells(orgCells)) {
                        Object dataVal;
                        int type;
                        if (cell.getFormulaObj() != null) {
                            cell.getFormulaObj().getDatatype(report);
                            type = cell.getFormulaObj().getSQLType();
                            dataVal = cell.getFormulaObj().getValue(tbl, 0, 1, 1, 1, 1, report, cell, null, true);
                        } else if (cell.getFormula() != null) {
                            type = cell.getSQLType();
                            dataVal = tbl.getValue(cell, 1, 1, 1, 1, report);
                        } else {
                            type = 12;
                            dataVal = cell.getText();
                        }
                        ColData colDataN = new ColData(ChartObject.getFormulaID(cell, report), type, report.colInfo.length);
                        for (int j = 0; j < rowCt; ++j) {
                            colDataN.add(dataVal);
                        }
                        colData.add(colDataN);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to get unmapped column data", ex);
            }
        }
        ColData[] cData = new ColData[colData.size() + 1];
        for (int i = 0; i < colData.size(); ++i) {
            cData[i] = (ColData)colData.elementAt(i);
        }
        cData[cData.length - 1] = new ColData("qbCount", 4, cData.length);
        for (int j = 0; j < rowCt; ++j) {
            cData[cData.length - 1].add(j);
        }
        return cData;
    }

    private static String getFormulaID(ReportCell cell, Report report) {
        String id = cell.getCustomID();
        if (!id.equals(cell.getID())) {
            return id;
        }
        int idx = id.lastIndexOf(95);
        String secID = id.substring(0, idx);
        LOGGER.finest("Section ID: " + secID);
        String name = report.getSectionReferenceName(secID);
        if (name == null) {
            name = secID;
        }
        LOGGER.finest("Section name:" + name);
        if (cell.getFormulaObj() != null) {
            name = cell.getFormulaObj().getName() != null ? name + "_" + cell.getFormulaObj().getName() : name + "_" + ChartObject.createFormulaName(cell.getFormulaObj().getText());
        } else if (cell.getFormula() != null) {
            name = cell.getFormulaObj().getName() != null ? name + "_" + cell.getFormulaName() : name + "_" + ChartObject.createFormulaName(cell.getFormula());
        } else {
            return id;
        }
        name = name.toUpperCase();
        return name;
    }

    private static String createFormulaName(String formula) {
        String str = "";
        for (int i = 0; i < formula.length(); ++i) {
            char c = formula.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) {
                str = str + c;
                continue;
            }
            if (str.endsWith("_")) continue;
            str = str + "_";
        }
        if (str.endsWith("_")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private static ReportCell[] getPlotableCells(ReportCell[] cells) {
        if (cells == null) {
            return new ReportCell[0];
        }
        Vector<ReportCell> vec = new Vector<ReportCell>();
        for (int i = 0; i < cells.length; ++i) {
            if (ReportElement.findElementType(cells[i]) != 5 && ReportElement.findElementType(cells[i]) != 6 || cells[i].getCustomID().equals("quick_designer_group_footer")) continue;
            vec.addElement(cells[i]);
        }
        ReportCell[] newCells = new ReportCell[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            newCells[i] = (ReportCell)vec.elementAt(i);
        }
        return newCells;
    }

    public static Chart openChart(FileInMemTable subFilesTable, String templateName, ColData[] colData, Vector preSetParams) throws Exception {
        if (IOUtil.isXMLFormat(templateName)) {
            return new quadbase.chart.ReadDataFile().createXMLChart(templateName, IOUtil.getOffScreenComponent(), true, preSetParams);
        }
        LoadChart loadChart = new LoadChart();
        loadChart.setSubFilesTable(subFilesTable);
        loadChart.setParameterField(preSetParams);
        if (colData == null) {
            Chart tmpChart = loadChart.loadChartFromFile(IOUtil.getOffScreenComponent(), templateName, preSetParams, true);
            try {
                if (!templateName.toUpperCase().endsWith(".TPL")) {
                    return ReloadChart.reloadData(tmpChart, false);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to reload chart data", ex);
                return tmpChart;
            }
            return tmpChart;
        }
        try (ReadDataFile rdf = new ReadDataFile();){
            Chart c;
            Chart chart = c = loadChart.loadChartFromReport(rdf.getInputStream(subFilesTable, templateName), colData);
            return chart;
        }
    }

    public static Chart openChart(InputStream instream, ColData[] colData, boolean isTemplate, Vector preSetParams) throws Exception {
        LoadChart loadChart = new LoadChart();
        loadChart.setParameterField(preSetParams);
        return loadChart.loadChartFromReport(new DataInputStream(instream), colData, isTemplate);
    }

    public static void export(String fileName, int format, Report report, ReportTable tbl, ReportCell[] cells, ReportChartObject cell, int width, int height, int[] mapping, String drillDownLinkPrefix, String htmlTarget) throws Exception {
        boolean reportDrillDown;
        Chart chart = null;
        Vector preSetParams = ChartObject.getPresetParams(report, tbl, cell);
        chart = !cell.isReportDataUsed() ? ChartObject.getIndependentChart(report, cell, preSetParams) : ChartObject.getReportDataUsedChart(report, tbl, cells, cell, preSetParams);
        chart.setChartInReport(true);
        if (format == 1) {
            chart.setBackgroundTransparent(cell.isGIFTransparent());
        }
        if (format == 15) {
            chart.flashFrameCount = cell.getFlashFrameCount();
            chart.flashFrameRate = cell.getFlashFrameRate();
        }
        boolean exportMapFile = false;
        boolean bl = reportDrillDown = mapping != null && cell.isReportDataUsed();
        if ((cell.isExportMapFile() || reportDrillDown) && (format == 10 || format == 7 || format == 1)) {
            exportMapFile = true;
        }
        if ((exportMapFile || format == 15) && reportDrillDown) {
            chart.setReportDrillDownMapping(mapping);
            chart.setReportDrillDownLinkPrefix(drillDownLinkPrefix);
        }
        if (htmlTarget != null) {
            chart.setHtmlTarget(htmlTarget);
        }
        chart.get_directExport(fileName, fileName, format, width, height, IOUtil.getOffScreenComponent(), exportMapFile, format == 10 ? cell.getPNGCompression() : cell.getJPEGQuality());
        report.addTriggeredAlerts(chart.getTriggeredAlertDetails(), new File(cell.getText()).getName());
    }

    public static byte[][] export(int format, Report report, ReportTable tbl, ReportCell[] cells, ReportChartObject cell, int width, int height, int[] mapping, String drillDownLinkPrefix) throws Exception {
        return ChartObject.export(format, report, tbl, cells, cell, width, height, mapping, drillDownLinkPrefix, null, null);
    }

    public static byte[][] export(int format, Report report, ReportTable tbl, ReportCell[] cells, ReportChartObject cell, int width, int height, int[] mapping, String drillDownLinkPrefix, String htmlTarget, String filename) throws Exception {
        Chart chart = null;
        Vector preSetParams = ChartObject.getPresetParams(report, tbl, cell);
        chart = !cell.isReportDataUsed() ? ChartObject.getIndependentChart(report, cell, preSetParams) : ChartObject.getReportDataUsedChart(report, tbl, cells, cell, preSetParams);
        chart.setChartInReport(true);
        if (format == 1) {
            chart.setBackgroundTransparent(cell.isGIFTransparent());
        }
        if (format == 15) {
            chart.flashFrameCount = cell.getFlashFrameCount();
            chart.flashFrameRate = cell.getFlashFrameRate();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        ByteArrayOutputStream out2 = null;
        boolean exportMapFile = false;
        boolean reportDrillDown = mapping != null && cell.isReportDataUsed();
        cell.setExportMapFile(true);
        if ((cell.isExportMapFile() || reportDrillDown) && (format == 10 || format == 7 || format == 1)) {
            exportMapFile = true;
            out2 = new ByteArrayOutputStream(1024);
        }
        if ((exportMapFile || format == 15) && reportDrillDown) {
            chart.setReportDrillDownMapping(mapping);
            chart.setReportDrillDownLinkPrefix(drillDownLinkPrefix);
        }
        if (htmlTarget != null) {
            chart.setHtmlTarget(htmlTarget);
        }
        chart.get_directExport(out, out2, filename, format, width, height, IOUtil.getOffScreenComponent(), exportMapFile, format == 10 ? cell.getPNGCompression() : cell.getJPEGQuality());
        report.addTriggeredAlerts(chart.getTriggeredAlertDetails(), new File(cell.getText(report.getSubFilesTable())).getName());
        out.close();
        if (out2 != null) {
            out2.close();
        }
        byte[][] res = new byte[2][];
        res[0] = out.toByteArray();
        if (out2 != null) {
            res[1] = out2.toByteArray();
        }
        return res;
    }

    public static String getChartName(String fileName, boolean includeFileExtension) {
        if (fileName == null) {
            return fileName;
        }
        int i = fileName.lastIndexOf(47);
        int j = fileName.lastIndexOf(92);
        if (j > i) {
            i = j;
        }
        fileName = fileName.substring(i + 1);
        String fnLC = fileName.toLowerCase();
        if (!includeFileExtension && (fnLC.endsWith(".tpl") || fnLC.endsWith(".cht") || fnLC.endsWith(".pac") || fnLC.endsWith(".qch"))) {
            return fileName.substring(0, fileName.length() - 4);
        }
        return fileName;
    }

    public static String getChartName(String fileName, int format) {
        int i = fileName.lastIndexOf(47);
        int j = fileName.lastIndexOf(92);
        if (j > i) {
            i = j;
        }
        return ChartObject.addExtension(fileName.substring(i + 1), format);
    }

    public static String addExtension(String tmp, int format) {
        switch (format) {
            case 0: {
                return tmp + ".cht";
            }
            case 8: {
                return tmp + ".wmf";
            }
            case 2: {
                return tmp + ".bmp";
            }
            case 1: 
            case 6: 
            case 9: {
                return tmp + ".gif";
            }
            case 4: 
            case 7: {
                return tmp + ".jpg";
            }
            case 10: {
                return tmp + ".png";
            }
        }
        return tmp + ".tpl";
    }

    private static ReportTable findTable(ReportTable table) {
        if (table instanceof ReportTreeTable) {
            Vector<ReportTable> subTables = ((ReportTreeTable)table).getSubTable();
            for (int i = 0; i < subTables.size(); ++i) {
                ReportTable tbl;
                if (subTables.elementAt(i).isAggregationTable() || (tbl = ChartObject.findTable(subTables.elementAt(i))) == null) continue;
                return tbl;
            }
        } else {
            if (table.getColumn(0).getDataCount() > countHelper) {
                return table;
            }
            countHelper -= table.getColumn(0).getDataCount();
        }
        return null;
    }

    private static ReportTable findTables(Vector<ReportTable> vec, ReportTable table) {
        if (table instanceof ReportTreeTable) {
            Vector<ReportTable> subTables = ((ReportTreeTable)table).getSubTable();
            for (int i = 0; i < subTables.size(); ++i) {
                ReportTable tbl;
                if (subTables.elementAt(i).isAggregationTable() || (tbl = ChartObject.findTables(vec, subTables.elementAt(i))) == null) continue;
                vec.insertElementAt(table, 0);
                return tbl;
            }
        } else {
            if (table.getColumn(0).getDataCount() > countHelper) {
                vec.insertElementAt(table, 0);
                return table;
            }
            countHelper -= table.getColumn(0).getDataCount();
        }
        return null;
    }

    private static Polygon faceToPolygon(Face f) {
        Polygon p = new Polygon();
        p.addPoint(f.v1.screen_x, f.v1.screen_y);
        p.addPoint(f.v2.screen_x, f.v2.screen_y);
        p.addPoint(f.v3.screen_x, f.v3.screen_y);
        p.addPoint(f.v4.screen_x, f.v4.screen_y);
        return p;
    }

    private static Object[] getValues(Object[] objs, String param) throws Exception {
        String sepBASE = "&PARAM";
        for (int i = objs.length - 1; i >= 0; --i) {
            String sep = sepBASE + i + "=";
            int idx = param.lastIndexOf(sep);
            if (param.length() < (idx += sep.length()) + 1) {
                return null;
            }
            objs[i] = DataType.read(QbUtil.urlDecode(param.substring(idx)));
            param = param.substring(0, idx - sep.length());
        }
        return objs;
    }

    private static Object translateObject(Object obj, int xOffset, int yOffset) {
        if (obj instanceof Face) {
            obj = ChartObject.faceToPolygon((Face)obj);
        }
        if (obj instanceof Polygon) {
            ((Polygon)obj).translate(xOffset, yOffset);
        } else if (obj instanceof Arc) {
            ((Arc)obj).translate(xOffset, yOffset);
        } else if (obj instanceof Rectangle) {
            ((Rectangle)obj).translate(xOffset, yOffset);
        }
        return obj;
    }

    public static boolean isParamChart(Chart chart) {
        if (chart.getQueryParameters() == null || chart.getQueryParameters().size() == 0) {
            return false;
        }
        return chart.getQueryFileInfo() != null;
    }

    private static int getColumnIndex(ReportTable table, String id) {
        if (table != null) {
            for (int i = 0; i < table.getColumnCount(); ++i) {
                if (!id.equals(table.getColumn(i).getID())) continue;
                return i;
            }
        }
        return -1;
    }

    private static ColData convertColDataType(ColData colDataI, Object scriptedValue, int noOfColumns) {
        if (DataType.isNumeric(DataType.mapType(colDataI.originalType)) && DataType.isNumeric(DataType.mapType(DataType.findType(scriptedValue)))) {
            ColData cdNew = new ColData(colDataI.getName(), 8, noOfColumns);
            for (int i = 0; i < colDataI.getSize(); ++i) {
                Object value = colDataI.getData(i);
                cdNew.add(DataType.createObject(scriptedValue.toString(), cdNew.originalType));
            }
            return cdNew;
        }
        ColData cdNew = new ColData(colDataI.getName(), 12, noOfColumns);
        for (int i = 0; i < colDataI.getSize(); ++i) {
            Object value = colDataI.getData(i);
            cdNew.add(DataType.createObject(scriptedValue.toString(), cdNew.originalType));
        }
        return cdNew;
    }

    static {
        memCache = new Hashtable();
        useCache = false;
    }

    private static class StoreChartThread
    extends Thread {
        ReportChartObject cObj = null;
        Vector<QueryInParamSet> preSetParam = null;
        Report report = null;

        public StoreChartThread(Report report, ReportChartObject obj, Vector<QueryInParamSet> param) {
            this.report = report;
            this.cObj = obj;
            this.preSetParam = param;
        }

        @Override
        public void run() {
            try {
                ChartObject.addChartToCache(this.cObj, "WAIT");
                Chart chart = ChartObject.createIndependentChart(this.report, this.cObj, this.preSetParam);
                if (chart != null) {
                    ChartObject.addChartToCache(this.cObj, chart);
                } else {
                    ChartObject.addChartToCache(this.cObj, "NULL");
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed running ChartObject", ex);
                ChartObject.addChartToCache(this.cObj, "NULL");
            }
        }
    }
}

