/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.IOLAPResultSet;
import quadbase.common.util.internal.CastUtil;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataSet;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.DeleteFile;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.IDataSet;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.report.ColDataResultSet;
import quadbase.reportdesigner.report.DBAccess;
import quadbase.reportdesigner.report.DataFileInput;
import quadbase.reportdesigner.report.EJBAccess;
import quadbase.reportdesigner.report.IOUtil2;
import quadbase.reportdesigner.report.XMLReport;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.IRSMetaData;
import quadbase.reportdesigner.util.IResultSet;
import quadbase.reportdesigner.util.ISpreadSheetModel;
import quadbase.reportdesigner.util.internal.BooleanCompare;
import quadbase.reportdesigner.util.internal.DateCompare;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.reportdesigner.util.internal.ICompareObject;
import quadbase.reportdesigner.util.internal.NumberCompare;
import quadbase.reportdesigner.util.internal.SortObject;
import quadbase.reportdesigner.util.internal.StringCompare;

public class ColData {
    private static final Logger LOGGER = Logger.getLogger(ColData.class.getName());
    int dataType;
    int originalType;
    private IDataSet vec;
    String colName;
    String tableName;
    boolean bNumeric;
    public boolean bGenUniqueName;
    int noUniqueField;
    Object[] fieldName;
    private boolean hasNulls = false;
    private Hashtable<Object, Integer> hashtbl;
    IFormat dataFormat;
    int axisType;
    boolean isCompleteSet = false;
    DBInfoBasic dbInfo;
    int[] recIndex;
    public static final int SPACE = 0;
    public static final int COMMA = 1;
    public static final int SEMICOLON = 2;
    public static final int TXTFORMAT = 0;
    public static final int XMLFORMAT = 1;
    private int uniqueNumber = QbUtil.nextNumber();
    private String address = null;
    private int stringDisplaySize = -1;

    public ColData(String colName, int dtype, int noOfCol) {
        this(colName, "", dtype, -1, noOfCol);
    }

    public ColData(String colName, int dtype, int initialCapacity, int noOfCol) {
        this(colName, "", dtype, initialCapacity, noOfCol);
    }

    public ColData(String colName, String tableName, int dtype, int initialCapacity, int noOfCol) {
        this(colName, tableName, dtype, initialCapacity, -1, noOfCol);
    }

    public ColData(String colName, String tableName, int dtype, int initialCapacity, int strMaxChar, int noOfCol) {
        this.colName = colName;
        this.tableName = tableName;
        this.originalType = dtype;
        this.dataType = DataType.mapType(dtype);
        this.bNumeric = DataType.isNumeric(this.dataType);
        this.stringDisplaySize = strMaxChar;
        this.vec = initialCapacity > 0 ? new DataSet(initialCapacity, this.getAddress(), this.getMaxCharForRecordFile(), noOfCol, this.dataType) : new DataSet(this.getAddress(), this.getMaxCharForRecordFile(), noOfCol, this.dataType);
        this.bGenUniqueName = false;
        this.dataFormat = FormatUtil.createFormat(this.dataType);
        switch (this.dataType) {
            case 0: 
            case 8: 
            case 9: 
            case 10: {
                this.axisType = this.dataType;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                this.axisType = 99;
                break;
            }
            default: {
                this.axisType = 7;
            }
        }
    }

    int getMaxCharForRecordFile() {
        if ((this.dataType == 6 || this.dataType == 7) && this.stringDisplaySize > 0) {
            return this.stringDisplaySize;
        }
        return ServerMessage.getMaxFieldSize();
    }

    public void setStringDisplaySize(int disSize) {
        this.stringDisplaySize = disSize;
    }

    public int getStringDisplaySize() {
        return this.stringDisplaySize;
    }

    public void setRecIndex(int[] recIndex) {
        this.recIndex = recIndex;
    }

    public int[] getRecIndex() {
        return this.recIndex;
    }

    public final int getDataType() {
        return this.dataType;
    }

    public final int getOriginalDataType() {
        return this.originalType;
    }

    public final boolean isNumeric() {
        return this.bNumeric;
    }

    public final String getName() {
        return this.colName;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public final int getSize() {
        return this.vec.size();
    }

    public IDataSet getDataSet() {
        return this.vec;
    }

    public final int getNumField() {
        return this.noUniqueField;
    }

    public final void add(Object elem) {
        if (!DataType.match(this.originalType, elem)) {
            try {
                elem = DataType.createObject(elem.toString(), this.dataType);
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINE, "Cannot create object", ex);
                LOGGER.finest("Warning: NumberFormatException: Record=" + (this.vec.size() + 1) + ", Type=" + this.originalType + ", Value=" + elem.toString());
                elem = null;
            }
        }
        this.vec.addElement(elem);
    }

    public final Object getData(int i) {
        if (i >= 0 && i < this.vec.size()) {
            if (this.recIndex != null && i < this.recIndex.length) {
                i = this.recIndex[i];
            }
            return this.vec.elementAt(i);
        }
        return null;
    }

    public void removeData(int i) {
        this.vec.removeElementAt(i);
    }

    public final void setData(int i, Object obj) {
        this.vec.setElementAt(obj, i);
    }

    public final double getValue(int i) {
        return IOUtil2.getValue(this.vec.elementAt(i));
    }

    void save(DataOutputStream out, int nRow) throws IOException {
        IOUtil.writeString(out, this.colName);
        out.writeInt(this.originalType);
        for (int i = 0; i < nRow; ++i) {
            Object obj = this.vec.elementAt(i);
            DataType.write(out, obj);
        }
    }

    void saveXML(Writer out, int nRow) throws IOException {
        out.write("<COLUMN Name=\"" + XMLReport.encodeXML(this.colName) + "\" Type=\"" + DataType.getTypeName(this.originalType) + "\">\n");
        for (int i = 0; i < nRow; ++i) {
            Object obj = this.vec.elementAt(i);
            out.write("<DATA>" + XMLReport.encodeXML(DataType.write(obj)) + "</DATA>\n");
        }
        out.write("</COLUMN>\n");
    }

    public final void retrieveField() {
        int i;
        if (this.bGenUniqueName) {
            return;
        }
        Vector<Object> set = new Vector<Object>();
        for (i = 0; i < this.getSize(); ++i) {
            Object obj = this.getData(i);
            if (obj == null) {
                this.hasNulls = true;
                continue;
            }
            if (set.contains(this.getData(i))) continue;
            set.addElement(this.getData(i));
        }
        if (this.hasNulls) {
            set.addElement(null);
        }
        if (set.size() == 0) {
            set.addElement("");
        }
        this.noUniqueField = set.size();
        this.fieldName = new Object[this.noUniqueField];
        for (i = 0; i < this.noUniqueField; ++i) {
            this.fieldName[i] = set.elementAt(i);
        }
        set.removeAllElements();
        set.trimToSize();
        this.bGenUniqueName = true;
    }

    public final void setFieldForExportOnly(Object[] val) {
        if (this.bGenUniqueName) {
            return;
        }
        this.noUniqueField = val.length;
        this.fieldName = new Object[this.noUniqueField];
        for (int i = 0; i < this.noUniqueField; ++i) {
            this.fieldName[i] = val[i];
        }
        this.bGenUniqueName = true;
    }

    public Object[] getSortOrder(boolean asc) {
        int nField = this.fieldName.length;
        Object[] sarray = new Object[this.fieldName.length];
        ICompareObject[] obj = new ICompareObject[nField];
        if (this.dataType == 0) {
            for (int i = 0; i < nField; ++i) {
                obj[i] = new BooleanCompare((Boolean)this.fieldName[i]);
            }
            sarray = SortObject.sort(obj, asc);
        } else if (DataType.isNumeric(this.dataType)) {
            for (int i = 0; i < nField; ++i) {
                obj[i] = new NumberCompare((Number)this.fieldName[i]);
            }
            sarray = SortObject.sort(obj, asc);
        } else if (DataType.isDateTime(this.dataType)) {
            for (int i = 0; i < nField; ++i) {
                obj[i] = new DateCompare((Date)this.fieldName[i]);
            }
            sarray = SortObject.sort(obj, asc);
        } else if (this.dataType == 7) {
            for (int i = 0; i < nField; ++i) {
                obj[i] = new StringCompare((String)this.fieldName[i]);
            }
            sarray = SortObject.sort(obj, asc);
        }
        return sarray;
    }

    public int[] setSortOrder(boolean asc) {
        Object[] sarray = null;
        try {
            sarray = this.getSortOrder(asc);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot get sort order", ex);
        }
        int[] order = null;
        if (sarray != null) {
            order = this.getNewOrder(sarray);
            if (order == null) {
                return null;
            }
            this.replaceOrder(order, true);
        }
        return order;
    }

    private int[] getNewStrOrder(Object[] fname) {
        int i;
        if (this.fieldName.length != fname.length) {
            return null;
        }
        int nField = fname.length;
        String[] fname_keys = new String[nField];
        String[] cname_keys = new String[nField];
        if (fname[0] instanceof String) {
            for (i = 0; i < nField; ++i) {
                fname_keys[i] = (String)fname[i];
            }
        } else {
            for (i = 0; i < nField; ++i) {
                fname_keys[i] = fname[i].toString();
            }
        }
        if (this.fieldName[0] instanceof String) {
            for (i = 0; i < nField; ++i) {
                cname_keys[i] = (String)this.fieldName[i];
            }
        } else {
            for (i = 0; i < nField; ++i) {
                cname_keys[i] = this.fieldName[i].toString();
            }
        }
        int[] order = new int[nField];
        for (int i2 = 0; i2 < nField; ++i2) {
            boolean found = false;
            for (int j = 0; j < nField; ++j) {
                if (!fname_keys[i2].equals(cname_keys[j])) continue;
                order[i2] = j;
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return order;
    }

    private int[] getNewOrder(Object[] fname) {
        if (fname instanceof String[] || this.dataType == 7) {
            return this.getNewStrOrder(fname);
        }
        Object[] cname = this.fieldName;
        if (cname.length != fname.length) {
            LOGGER.finest("Length mismatch");
            return null;
        }
        int[] order = new int[fname.length];
        for (int i = 0; i < fname.length; ++i) {
            boolean found = false;
            for (int j = 0; j < cname.length; ++j) {
                if (!fname[i].equals(cname[j])) continue;
                order[i] = j;
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return order;
    }

    public void setFieldOrder(int[] order) {
        this.replaceOrder(order, true);
    }

    private void replaceOrder(int[] order, boolean replaceFieldName) {
        int i;
        if (replaceFieldName) {
            this.createHashTable();
        }
        Object[] obj = new Object[this.fieldName.length];
        for (i = 0; i < this.fieldName.length; ++i) {
            if (!replaceFieldName) continue;
            obj[i] = this.fieldName[i];
        }
        for (i = 0; i < this.fieldName.length; ++i) {
            if (replaceFieldName) {
                this.fieldName[i] = obj[order[i]];
            }
            if (!replaceFieldName) continue;
            this.hashtbl.put(this.fieldName[i], i);
        }
    }

    final void createHashTable() {
        if (this.hashtbl != null) {
            return;
        }
        this.hashtbl = new Hashtable(4 * this.noUniqueField);
        for (int i = 0; i < this.noUniqueField; ++i) {
            if (this.fieldName[i] == null) {
                this.hashtbl.put("Null", i);
                continue;
            }
            this.hashtbl.put(this.fieldName[i], i);
        }
    }

    final int mapHashTable(int i) {
        Object obj = this.getData(i);
        if (obj == null && this.hasNulls) {
            return this.fieldName.length - 1;
        }
        return obj != null ? this.hashtbl.get(obj) : -999;
    }

    final void clearHashTable() {
        if (this.hashtbl != null) {
            this.hashtbl.clear();
            this.hashtbl = null;
        }
    }

    public Object[] getFieldName() {
        return this.fieldName;
    }

    public static final ColData[] getColData(IResultSet rs) throws Exception {
        return ColData.getColData(rs, 0, -1);
    }

    public static final ColData[] getColDataForCrossTab(IOLAPResultSet rs) throws Exception {
        int l;
        int i;
        int rowLength = rs.getRowBreakCount() + rs.getColumnBreakCount() + 2;
        ColData[] colData = new ColData[rowLength];
        for (i = 0; i < rs.getRowBreakCount(); ++i) {
            colData[i] = rs.getRowBreakColumnHeader() != null && rs.getRowBreakColumnHeader().length > 1 ? new ColData(rs.getRowBreakColumnHeader()[i], rs.getRowLabelDataType(), colData.length) : new ColData("", rs.getRowLabelDataType(), colData.length);
            for (int k = 0; k < rs.getRowCount(); ++k) {
                Object val = rs.getRowLabel(k)[i];
                for (l = 0; l < rs.getColumnCount(); ++l) {
                    colData[i].add(val);
                }
            }
        }
        for (int j = 0; j < rs.getColumnBreakCount(); ++j) {
            colData[i] = new ColData("ColBreak" + j, rs.getColumnLabelDataType(), colData.length);
            for (int l2 = 0; l2 < rs.getRowCount(); ++l2) {
                for (int k = 0; k < rs.getColumnCount(); ++k) {
                    colData[i].add(rs.getColumnLabel(k)[j]);
                }
            }
            ++i;
        }
        colData[i] = new ColData("Value", rs.getCellDataType(), colData.length);
        colData[i + 1] = new ColData("qbCount", 4, colData.length);
        int recNo = 0;
        for (int k = 0; k < rs.getRowCount(); ++k) {
            for (l = 0; l < rs.getColumnCount(); ++l) {
                colData[i].add(rs.getCell(l, k));
                colData[i + 1].add(recNo++);
            }
        }
        return colData;
    }

    public static final ColData[] getColDataForSummary(IOLAPResultSet rs) throws Exception {
        int i;
        int colLength = rs.getRowBreakCount() + rs.getColumnCount() + 1;
        ColData[] colData = new ColData[colLength];
        for (i = 0; i < rs.getRowBreakCount(); ++i) {
            colData[i] = rs.getRowBreakColumnHeader() != null && rs.getRowBreakColumnHeader().length > 1 ? new ColData(rs.getRowBreakColumnHeader()[i], rs.getRowLabelDataType(), colData.length) : new ColData("", rs.getRowLabelDataType(), colData.length);
            for (int k = 0; k < rs.getRowCount(); ++k) {
                Object val = rs.getRowLabel(k)[i];
                colData[i].add(val);
            }
        }
        for (int j = 0; j < rs.getColumnCount(); ++j) {
            colData[i + j] = new ColData((String)rs.getColumnLabel(j)[rs.getColumnBreakCount() - 1], rs.getCellDataType(), colData.length);
        }
        colData[colLength - 1] = new ColData("qbCount", 4, colData.length);
        int recNo = 0;
        for (int k = 0; k < rs.getRowCount(); ++k) {
            for (int l = 0; l < rs.getColumnCount(); ++l) {
                colData[l + i].add(rs.getCell(l, k));
                colData[colLength - 1].add(recNo++);
            }
        }
        return colData;
    }

    public static final ColData[] getColData(IResultSet rs, int startIndex, int displayRow) throws Exception {
        IRSMetaData md = rs.getMetaData();
        int rowLength = md.getColumnCount();
        ColData[] colData = new ColData[rowLength + 1];
        for (int i = 0; i < rowLength; ++i) {
            colData[i] = new ColData(md.getColumnName(i + 1), md.getTableName(i + 1), md.getColumnType(i + 1), -1, CastUtil.getColumnDisplaySize(md, i + 1), rowLength + 1);
        }
        colData[rowLength] = new ColData("qbCount", 4, colData.length);
        int recNo = 0;
        while (displayRow < 0 || recNo < displayRow) {
            block10: {
                try {
                    if (!rs.next()) {
                    }
                    break block10;
                }
                catch (SQLException e) {
                    LOGGER.log(Level.FINE, "Checking for next row failed", e);
                }
                break;
            }
            if (recNo < startIndex) {
                ++recNo;
                continue;
            }
            for (int i = 0; i < rowLength; ++i) {
                colData[i].add(rs.getObject(i + 1));
            }
            colData[rowLength].add(recNo++);
        }
        try {
            if (displayRow < 0 || recNo < displayRow) {
                rs.close();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to close IResultSet", ex);
        }
        return colData;
    }

    public static IResultSet getResultSet(ColData[] dataSet) {
        return new ColDataResultSet(dataSet);
    }

    public static final ColData[] getColData(ISpreadSheetModel ss) {
        ColData[] colData = new ColData[4];
        int rowCount = ss.getRowCount();
        int columnCount = ss.getColumnCount();
        int vectorSize = rowCount * columnCount;
        colData[0] = new ColData("RowLabel", ss.getRowLabelType(), vectorSize, colData.length);
        colData[1] = new ColData("ColumnLabel", ss.getColumnLabelType(), vectorSize, colData.length);
        colData[2] = new ColData("Value", ss.getValueType(), vectorSize, colData.length);
        colData[3] = new ColData("qbCount", 4, vectorSize, colData.length);
        int recNo = 0;
        for (int i = 1; i <= rowCount; ++i) {
            Object rowValue = ss.getRowLabel(i);
            for (int j = 1; j <= columnCount; ++j) {
                colData[0].add(rowValue);
                Object columnValue = ss.getColumnLabel(j);
                colData[1].add(columnValue);
                Object value = ss.getValueAt(i, j);
                colData[2].add(value);
                colData[3].add(recNo++);
            }
        }
        return colData;
    }

    public static final synchronized ColData[] getOneWayColData(IResultSet rs, int displayRow) throws Exception {
        IRSMetaData md = rs.getMetaData();
        int rowLength = md.getColumnCount();
        ColData[] colData = new ColData[rowLength + 1];
        for (int i = 0; i < rowLength; ++i) {
            colData[i] = new ColData(md.getColumnName(i + 1), md.getTableName(i + 1), md.getColumnType(i + 1), -1, CastUtil.getColumnDisplaySize(md, i + 1), rowLength + 1);
        }
        colData[rowLength] = new ColData("qbCount", 4, colData.length);
        int recNo = 0;
        while ((displayRow < 0 || recNo < displayRow) && rs.next()) {
            for (int i = 0; i < rowLength; ++i) {
                colData[i].add(rs.getObject(i + 1));
            }
            colData[rowLength].add(recNo++);
        }
        return colData;
    }

    public static ColData[] getColData(Object[] sourceList, int[] sourceType, boolean[] doTranspose, Object[] transposeColList, boolean isMergedDataTransposed, boolean[] transposeCol, boolean useDBbuffer) throws Exception {
        Vector<ColData[]> colDataList = new Vector<ColData[]>();
        for (int i = 0; i < sourceList.length; ++i) {
            Object temp = sourceList[i];
            if (temp instanceof DBInfoBasic) {
                colDataList.addElement(DBAccess.retrieveResult(null, (DBInfoBasic)temp, useDBbuffer, false, null, null, null, false));
                continue;
            }
            if (sourceType[i] == 4) {
                colDataList.addElement(new DataFileInput().readProcessedData((String)temp, false, null, null, 4));
                continue;
            }
            if (sourceType[i] == 7) {
                XMLFileQueryInfo xmlInfo = (XMLFileQueryInfo)temp;
                colDataList.addElement(new DataFileInput().readProcessedData(xmlInfo.getFileName(), false, null, null, null, 0, -1, xmlInfo, 7));
                continue;
            }
            if (sourceType[i] == 6) {
                colDataList.addElement(new DataFileInput().readProcessedData((String)temp, false, null, null, 6));
                continue;
            }
            if (sourceType[i] == 5) {
                EJBInfo ejbInfo = (EJBInfo)temp;
                colDataList.addElement(EJBAccess.retrieveResult(ejbInfo.getJNDIName(), ejbInfo.getHomeName(), ejbInfo.getRemoteName(), ejbInfo.getSelectedMethodName(), ejbInfo.getSelectedMethodParamVal(), ejbInfo.getEnvironment()));
                continue;
            }
            colDataList.addElement(new DataFileInput().readProcessedData((String)temp, false, null, null));
        }
        ColData[] colData = ColData.merge(colDataList, true);
        return colData;
    }

    public static void print(PrintStream out, ColData[] colData, int separator, int format) {
        if (colData == null || colData.length <= 0) {
            return;
        }
        if (format == 1) {
            ColData.printToXML(out, colData);
        } else {
            ColData.printToTXT(out, colData, separator);
        }
    }

    private static void printToTXT(PrintStream out, ColData[] colData, int separator) {
        int nCol = colData.length - 1;
        String dataType = "";
        String fieldName = "";
        String sep = " ";
        if (separator == 1) {
            sep = ", ";
        } else if (separator == 2) {
            sep = "; ";
        }
        for (int i = 0; i < nCol; ++i) {
            if (i == 0) {
                dataType = DataType.getTypeName(colData[i].getOriginalDataType());
                fieldName = "\"" + colData[i].getName() + "\"";
                continue;
            }
            dataType = dataType + sep + DataType.getTypeName(colData[i].getOriginalDataType());
            fieldName = fieldName + sep + "\"" + colData[i].getName() + "\"";
        }
        out.println(dataType);
        out.println(fieldName);
        int nRow = colData[0].getSize();
        for (int i = 0; i < nRow; ++i) {
            String row = "";
            for (int j = 0; j < nCol; ++j) {
                Object obj = colData[j].getData(i);
                row = j == 0 ? ColData.toString(obj, true) : row + sep + ColData.toString(obj, true);
            }
            out.println(row);
        }
    }

    private static void printToXML(PrintStream ps, ColData[] colData) {
        int i;
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)ps, false, ServerMessage.xmlEncoding);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.FINEST, "Unsupported encoding", e);
            throw new IllegalArgumentException("Unsupported encoding " + ServerMessage.xmlEncoding);
        }
        out.println("<?xml version=\"1.0\" encoding=\"" + ServerMessage.xmlEncoding + "\"?>\n");
        out.println("<EspressData>");
        int nCol = colData.length - 1;
        for (i = 0; i < nCol; ++i) {
            out.println("  <DataType>" + DataType.getTypeName(colData[i].getOriginalDataType()) + "</DataType>");
        }
        out.println();
        for (i = 0; i < nCol; ++i) {
            out.println("  <FieldName><![CDATA[" + colData[i].getName() + "]]></FieldName>");
        }
        out.println();
        int nRow = colData[0].getSize();
        for (int i2 = 0; i2 < nRow; ++i2) {
            out.println("  <Row>");
            for (int j = 0; j < nCol; ++j) {
                out.println("    <Data><![CDATA[" + ColData.toString(colData[j].getData(i2), false) + "]]></Data>");
            }
            out.println("  </Row>");
        }
        out.println("</EspressData>");
    }

    private static String toString(Object obj, boolean quote) {
        if (obj == null) {
            return "\"\"";
        }
        if (!quote) {
            return obj.toString();
        }
        if (obj instanceof Number) {
            return obj.toString();
        }
        return "\"" + obj.toString() + "\"";
    }

    public static ColData[] merge(Vector colList, boolean fillInNullData) throws Exception {
        int i;
        if (colList.size() == 1) {
            return (ColData[])colList.elementAt(0);
        }
        int nRow = ColData.getRowCount(colList, 0);
        int nCol = ColData.getColumnCount(colList, 0);
        for (int i2 = 1; i2 < colList.size(); ++i2) {
            if (!fillInNullData && nRow != ColData.getRowCount(colList, i2)) {
                throw new Exception("Cannot merge: All data must have same number of rows!");
            }
            nRow = nRow > ColData.getRowCount(colList, i2) ? nRow : ColData.getRowCount(colList, i2);
            nCol += ColData.getColumnCount(colList, i2);
        }
        ColData[] mergeCol = new ColData[nCol + 1];
        int idx = 0;
        for (i = 0; i < colList.size(); ++i) {
            int nSheetCol = ColData.getColumnCount(colList, i);
            int nSheetRow = ColData.getRowCount(colList, i);
            for (int j = 0; j < nSheetCol; ++j) {
                ColData tmpCol = ((ColData[])colList.elementAt(i))[j];
                String colName = ColData.getColumnName(tmpCol.getName(), mergeCol);
                mergeCol[idx] = new ColData(colName, "", tmpCol.getOriginalDataType(), -1, tmpCol.getStringDisplaySize(), colList.size());
                mergeCol[idx].vec = (IDataSet)tmpCol.vec.clone();
                for (int k = nSheetRow; k < nRow; ++k) {
                    mergeCol[idx].add(null);
                    mergeCol[idx].bGenUniqueName = false;
                }
                ++idx;
            }
        }
        mergeCol[idx] = new ColData("qbCount", 4, mergeCol.length);
        for (i = 0; i < nRow; ++i) {
            mergeCol[idx].add(i);
        }
        return mergeCol;
    }

    private static String getColumnName(String name, ColData[] mergeCol) {
        int idx = 2;
        if (!ColData.isColumnNameExisted(name, mergeCol)) {
            return name;
        }
        while (ColData.isColumnNameExisted(name + "_" + idx, mergeCol)) {
            ++idx;
        }
        return name + "_" + idx;
    }

    private static boolean isColumnNameExisted(String name, ColData[] mergeCol) {
        for (ColData element : mergeCol) {
            if (element == null || !element.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static int getRowCount(Vector colList, int i) {
        if (colList == null || colList.isEmpty()) {
            return 0;
        }
        return ((ColData[])colList.elementAt(i))[0].getSize();
    }

    private static int getColumnCount(Vector colList, int i) {
        if (colList == null || colList.isEmpty()) {
            return 0;
        }
        return ((ColData[])colList.elementAt(i)).length - 1;
    }

    public void cleanup() {
        try {
            this.finalize();
        }
        catch (Throwable ex) {
            LOGGER.log(Level.FINEST, "Cleanup failed", ex);
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            try {
                for (int i = 0; i < this.vec.size(); ++i) {
                    Object obj = this.vec.elementAt(i);
                    if (obj instanceof ReportImage) {
                        ReportImage ri = (ReportImage)obj;
                        if (!ri.isDBImage()) continue;
                        new DeleteFile(ri.getRelativePath()).delete();
                        continue;
                    }
                    i = this.vec.size();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to remove database images", ex);
            }
            this.vec.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    public static void releaseDiskBuffer(ColData[] colData) {
        if (colData != null) {
            for (ColData element : colData) {
                if (element == null) continue;
                element.releaseDiskBuffer();
            }
        }
    }

    private void releaseDiskBuffer() {
        this.vec.releaseDiskBuffer();
    }

    public Vector<Object> getDistinctValue() {
        Vector<Object> value = new Vector<Object>();
        for (int i = 0; i < this.getSize(); ++i) {
            boolean duplicate = false;
            for (int j = 0; j < value.size(); ++j) {
                if (this.getData(i) != null && !this.getData(i).equals(value.elementAt(j))) continue;
                duplicate = true;
                break;
            }
            if (duplicate || this.getData(i) == null) continue;
            value.addElement(this.getData(i));
        }
        return value;
    }

    private String getAddress() {
        if (this.address == null) {
            this.address = String.valueOf(this.uniqueNumber);
        }
        return this.address;
    }

    public Object getNonEmptyValue(int index) {
        for (int i = index; i >= 0; --i) {
            if (this.vec.elementAt(i) == null || this.vec.elementAt(i).equals("")) continue;
            return this.vec.elementAt(i);
        }
        return null;
    }

    public static ColData[] getColDataWithUniqueName(ColData[] colData) {
        if (colData == null) {
            return null;
        }
        if (colData.length < 2) {
            return colData;
        }
        block0: for (int i = 1; i < colData.length; ++i) {
            String name = colData[i].colName;
            for (int j = 0; j < i; ++j) {
                if (!name.equals(colData[j].colName)) continue;
                colData[i].colName = colData[i].colName + "(IDX " + i + ")";
                continue block0;
            }
        }
        return colData;
    }

    public static boolean isColDataCompatible(ColData[] oldColData, ColData[] newColData) {
        if (oldColData != null && newColData != null) {
            if (oldColData.length != newColData.length) {
                return false;
            }
            for (int i = 0; i < oldColData.length; ++i) {
                if (oldColData[i].getOriginalDataType() == newColData[i].getOriginalDataType()) continue;
                return false;
            }
            return true;
        }
        return oldColData == null && newColData == null;
    }

    public IFormat getDataFormat() {
        return this.dataFormat;
    }
}

