/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.util.IRSMetaData;
import quadbase.reportdesigner.util.IResultSet;
import quadbase.reportdesigner.util.ISpreadSheetModel;

public class ColDataResultSet
implements IResultSet,
IRSMetaData,
Cloneable {
    ColData[] dataSet;
    int cursor = -1;
    boolean isClosed = false;
    int size;

    public int getSize() {
        return this.size;
    }

    public ColDataResultSet(ColData[] data) {
        this.dataSet = data;
        this.size = this.dataSet[0].getSize();
    }

    public int getCursor() {
        return this.cursor;
    }

    public void resetCursor() {
        this.cursor = -1;
    }

    @Override
    public final boolean next() {
        return ++this.cursor < this.size;
    }

    @Override
    public final void close() {
        this.isClosed = true;
    }

    @Override
    public final IRSMetaData getMetaData() {
        return this;
    }

    @Override
    public final Object getObject(int col) {
        if (col <= 0 || col > this.dataSet.length - 1) {
            throw new IllegalArgumentException("Invalid column index :" + col);
        }
        return this.dataSet[col - 1].getData(this.cursor);
    }

    @Override
    public final int getColumnCount() {
        return this.dataSet.length - 1;
    }

    @Override
    public final String getColumnName(int col) {
        if (col <= 0 || col > this.dataSet.length - 1) {
            throw new IllegalArgumentException("Invalid column index :" + col);
        }
        return this.dataSet[col - 1].getName();
    }

    @Override
    public final String getTableName(int col) {
        if (col <= 0 || col > this.dataSet.length - 1) {
            throw new IllegalArgumentException("Invalid column index :" + col);
        }
        return this.dataSet[col - 1].getTableName();
    }

    @Override
    public final int getColumnType(int col) {
        if (col <= 0 || col > this.dataSet.length - 1) {
            throw new IllegalArgumentException("Invalid column index :" + col);
        }
        return this.dataSet[col - 1].getOriginalDataType();
    }

    public final int getColumnDisplaySize(int col) {
        if (col <= 0 || col > this.dataSet.length - 1) {
            throw new IllegalArgumentException("Invalid column index :" + col);
        }
        return this.dataSet[col - 1].getStringDisplaySize();
    }

    public static final ColData[] getColData(ISpreadSheetModel ss) {
        ColData[] colData = new ColData[4];
        int rowCount = ss.getRowCount();
        int columnCount = ss.getColumnCount();
        int vectorSize = rowCount * columnCount;
        colData[0] = new ColData("RowLabel", ss.getRowLabelType(), vectorSize, colData.length);
        colData[1] = new ColData("ColumnLabel", ss.getColumnLabelType(), vectorSize, colData.length);
        colData[2] = new ColData("Value", ss.getValueType(), vectorSize, colData.length);
        colData[3] = new ColData("qbCount", 4, vectorSize, colData.length);
        int recNo = 0;
        for (int i = 1; i <= rowCount; ++i) {
            Object rowValue = ss.getRowLabel(i);
            for (int j = 1; j <= columnCount; ++j) {
                colData[0].add(rowValue);
                Object columnValue = ss.getColumnLabel(j);
                colData[1].add(columnValue);
                Object value = ss.getValueAt(i, j);
                colData[2].add(value);
                colData[3].add(recNo++);
            }
        }
        return colData;
    }
}

