/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.IOLAPResultSet;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DataFileInput;
import quadbase.reportdesigner.report.EJBAccess;
import quadbase.reportdesigner.report.ExcelAccess;
import quadbase.reportdesigner.report.OLAPAccess;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.SOAPAccess;
import quadbase.reportdesigner.report.SalesForceAccess;
import quadbase.reportdesigner.report.message.ReadDBqueryMeta;
import quadbase.reportdesigner.report.message.ReadDataFileMeta;
import quadbase.reportdesigner.util.IRSMetaData;
import quadbase.reportdesigner.util.IResultSet;
import quadbase.reportdesigner.util.StreamResultSet;
import quadbase.reportdesigner.util.internal.TransposeRS;

public class ColMetaData {
    private static final Logger LOGGER = Logger.getLogger(ColMetaData.class.getName());
    String columnName;
    int sqlType;

    public ColMetaData(String columnName, int sqlType) {
        this.columnName = columnName;
        this.sqlType = sqlType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public void write(DataOutputStream dout) throws IOException {
        IOUtil.writeString(dout, Coder.encode(this.columnName));
        dout.writeInt(this.sqlType);
    }

    public static ColMetaData read(DataInputStream din, int version) throws IOException {
        String columnName = Coder.decode(IOUtil.readString(din, true), version);
        int sqlType = din.readInt();
        return new ColMetaData(columnName, sqlType);
    }

    public static Vector<ColMetaData> getVector(ColData[] colData) {
        Vector<ColMetaData> output = new Vector<ColMetaData>();
        int nColumn = colData.length - 1;
        for (int i = 0; i < nColumn; ++i) {
            output.addElement(new ColMetaData(colData[i].getName(), colData[i].getOriginalDataType()));
        }
        return output;
    }

    public static Vector<ColMetaData> getVector(XMLFieldInfo[] xmlInfo) {
        Vector<ColMetaData> output = new Vector<ColMetaData>();
        int nColumn = xmlInfo.length - 1;
        for (int i = 0; i < nColumn; ++i) {
            output.addElement(new ColMetaData(xmlInfo[i].getAlias(), ColMetaData.getDataType(xmlInfo[i])));
        }
        return output;
    }

    private static int getDataType(XMLFieldInfo leafNode) {
        if (leafNode.getXMLType() == 1) {
            return DataType.findType(leafNode.getElementDataType());
        }
        if (leafNode.getXMLType() == 2) {
            return DataType.findType(leafNode.getAttributeDataType());
        }
        return -1;
    }

    public static Vector<ColMetaData> getVector(String remoteName) {
        return EJBAccess.getColMetaData(remoteName);
    }

    public static Vector<ColMetaData> getVector(SOAPQueryFileInfo soapInfo) {
        try {
            return ColMetaData.getVector(SOAPAccess.retrieveResult(soapInfo));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot retrieve SOAP vector", ex);
            return null;
        }
    }

    public static Vector<ColMetaData> getVector(SalesForceQueryFileInfo sfQueryInfo) {
        try {
            return ColMetaData.getVector(SalesForceAccess.getColData(sfQueryInfo));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot retrieve SalesForce vector", ex);
            return null;
        }
    }

    public static Vector<ColMetaData> getVector(ExcelFileInfo excelInfo) {
        try {
            return ColMetaData.getVector(ExcelAccess.getColData(excelInfo));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot retrieve Excel vector", ex);
            return null;
        }
    }

    public static Vector<ColMetaData> getVector(IOLAPResultSet olapRS, String connectionString, String MDXQuery, String uri, String datasource, String catalog, int reportType) {
        try {
            OLAPAccess olapAccess = new OLAPAccess(olapRS, connectionString, MDXQuery, uri, datasource, catalog);
            return ColMetaData.getVector(olapAccess.retrieveResult(reportType));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot retrieve OLAP vector", ex);
            return null;
        }
    }

    public static Vector<ColMetaData> getVector(String dataFilename, boolean transposeData, boolean[] transposeCol) throws Exception {
        return ColMetaData.getVector(dataFilename, transposeData, transposeCol, 2);
    }

    public static Vector<ColMetaData> getVector(String dataFilename, boolean transposeData, boolean[] transposeCol, int dataType) throws Exception {
        return ColMetaData.getVector(dataFilename, transposeData, transposeCol, dataType, null);
    }

    private static Vector<ColMetaData> makeFromLocalDataFile(String dataFilename, boolean transposeData, boolean[] transposeCol, int dataType) throws Exception {
        DataInputStream inputStream = new ReadDataFile().getInputStream(null, dataFilename);
        IResultSet rs = IOUtil.isXMLFormat(dataFilename) || dataType == 4 ? new ReadDataFile().createXMLResultSet(dataFilename) : (dataType == 6 ? new ReadDataFile().getClassResultSet(dataFilename) : new StreamResultSet(inputStream));
        IRSMetaData metaData = rs.getMetaData();
        Vector<ColMetaData> output = new Vector<ColMetaData>();
        int nColumn = metaData.getColumnCount();
        for (int i = 1; i <= nColumn; ++i) {
            output.addElement(new ColMetaData(metaData.getColumnName(i), metaData.getColumnType(i)));
        }
        rs.close();
        if (transposeData) {
            return ColMetaData.transposeVector(output, transposeCol);
        }
        return output;
    }

    public static Vector<ColMetaData> getVector(Vector parameters, DBInfoBasic dbInfo, boolean transposeData, boolean[] transposeCol) throws Exception {
        if (ServerMessage.useServer) {
            return ReadDBqueryMeta.getMeta(parameters, dbInfo, transposeData, transposeCol);
        }
        return ColMetaData.makeFromLocalDB(parameters, dbInfo, transposeData, transposeCol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector<ColMetaData> makeFromLocalDB(Vector parameters, DBInfoBasic dbInfo, boolean transposeData, boolean[] transposeCol) throws Exception {
        Vector<ColMetaData> output = new Vector<ColMetaData>();
        Class.forName(dbInfo.getDriverName());
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            conn = dbInfo.openConnection();
            String query = dbInfo.getQuery();
            boolean hasParameter = QueryFileInfo.hasParameter(parameters);
            if (QueryParser.isCallableStmt(query)) {
                if (hasParameter) {
                    query = ColMetaData.findInParam(parameters).convertToJDBCquery(query);
                }
                CallableStatement callstmt = conn.prepareCall(query);
                if (hasParameter) {
                    ColMetaData.findInParam(parameters).setStmtValue(callstmt);
                }
                rs = callstmt.executeQuery();
                stmt = callstmt;
            } else if (QueryParser.isPreparedStmt(query)) {
                if (hasParameter) {
                    query = ColMetaData.findInParam(parameters).convertToJDBCquery(query);
                }
                pStmt = conn.prepareStatement(query);
                if (hasParameter) {
                    ColMetaData.findInParam(parameters).setStmtValue(pStmt);
                }
                rs = pStmt.executeQuery();
                stmt = pStmt;
            } else {
                stmt = conn.createStatement();
                rs = stmt.executeQuery(query);
            }
            ResultSetMetaData rsmd = rs.getMetaData();
            int nColumn = rsmd.getColumnCount();
            for (int j = 1; j <= nColumn; ++j) {
                int sqlType = rsmd.getColumnType(j);
                String columnName = rsmd.getColumnName(j);
                output.addElement(new ColMetaData(columnName, sqlType));
            }
        }
        catch (Throwable throwable) {
            CloseUtils.close(rs);
            CloseUtils.close(stmt);
            CloseUtils.close(conn);
            throw throwable;
        }
        CloseUtils.close(rs);
        CloseUtils.close(stmt);
        CloseUtils.close(conn);
        if (transposeData) {
            return ColMetaData.transposeVector(output, transposeCol);
        }
        return output;
    }

    private static QueryInParamSet findInParam(Vector parameter) {
        for (int i = 0; i < parameter.size(); ++i) {
            Object target = parameter.elementAt(i);
            if (!(target instanceof QueryInParamSet)) continue;
            return (QueryInParamSet)target;
        }
        return null;
    }

    private static Vector<ColMetaData> transposeVector(Vector<ColMetaData> target, boolean[] transposeCol) throws IllegalArgumentException {
        if (transposeCol == null) {
            transposeCol = TransposeRS.getDefaultTransposeColumn(target.size());
        }
        Vector<ColMetaData> output = new Vector<ColMetaData>();
        int type = -5;
        for (int i = 0; i < target.size(); ++i) {
            if (!transposeCol[i]) {
                output.addElement(target.elementAt(i));
                continue;
            }
            if (type == -5) {
                type = target.elementAt(i).getSqlType();
                continue;
            }
            if (target.elementAt(i).getSqlType() == type) continue;
            type = 8;
        }
        output.addElement(new ColMetaData("ColumnLabel", 12));
        output.addElement(new ColMetaData("Value", type));
        return output;
    }

    public static Vector<ColMetaData> getVector(String dataFilename, boolean transposeData, boolean[] transposeCol, int dataType, QueryInParamSet inSet) throws Exception {
        if (ServerMessage.useServer || !ServerMessage.isLoadBalancer) {
            return ReadDataFileMeta.getMeta(dataFilename, transposeData, transposeCol, dataType, inSet);
        }
        return ColMetaData.makeFromLocalDataFile(dataFilename, transposeData, transposeCol, dataType, inSet);
    }

    public static Vector<ColMetaData> makeFromLocalDataFile(String dataFilename, boolean transposeData, boolean[] transposeCol, int dataType, QueryInParamSet inSet) throws Exception {
        if (inSet != null) {
            IResultSet rs = DataFileInput.getClassResultSet(dataFilename, inSet);
            IRSMetaData metaData = rs.getMetaData();
            Vector<ColMetaData> output = new Vector<ColMetaData>();
            int nColumn = metaData.getColumnCount();
            for (int i = 1; i <= nColumn; ++i) {
                output.addElement(new ColMetaData(metaData.getColumnName(i), metaData.getColumnType(i)));
            }
            rs.close();
            if (transposeData) {
                return ColMetaData.transposeVector(output, transposeCol);
            }
            return output;
        }
        return ColMetaData.makeFromLocalDataFile(dataFilename, transposeData, transposeCol, dataType);
    }
}

