/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.Report;

public class ColumnarTable
extends ReportTable {
    private static final Logger LOGGER = Logger.getLogger(ColumnarTable.class.getName());
    Report report;

    protected ColumnarTable(Report report, boolean formatColumn) {
        super(report.getLocale(), report.getTimeZone());
        this.setWidth(report.getActualPageWidth());
        this.report = report;
    }

    public ColumnarTable(Report report) {
        this(report, false);
        for (int i = 0; i < report.colInfo.length; ++i) {
            ReportColumn rCol = report.createColumn(i, report.colInfo.length);
            rCol.setAlternateRow(5);
            rCol.setVisible(report.colInfo[i].isVisible());
            this.addColumn(rCol);
        }
        this.formatColumn();
    }

    public ColumnarTable(ColumnarTable _table) {
        super(_table);
        this.report = _table.report;
        this.header = _table.header;
        this.footer = _table.footer;
        for (int i = 0; i < _table.getColumnCount(); ++i) {
            ReportColumn tcol = new ReportColumn(_table.getColumn(i));
            tcol.resetData();
            this.addColumn(tcol);
        }
    }

    @Override
    public void formatTable() throws Exception {
        int j;
        int rowCt;
        int i;
        for (i = 0; i < this.report.colInfo.length; ++i) {
            int m = this.report.colInfo[i].getMapping();
            if (m < 0) continue;
            rowCt = this.report.colData[m].getSize();
            this.getColumn(i).removeAllData();
            for (j = 0; j < rowCt; ++j) {
                this.getColumn(i).addData(this.report.colData[m].getData(j));
            }
        }
        for (i = 0; i < this.report.colInfo.length; ++i) {
            Formula formula = this.report.colInfo[i].getFormulaObj();
            if (formula == null) continue;
            rowCt = this.getRowCount();
            this.getColumn(i).removeAllData();
            for (j = 0; j < rowCt; ++j) {
                try {
                    this.getColumn(i).addData(formula.getValue(this, j, 1, 1, 1, 1, this.report, null, null));
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Can't add forumula, adding null instead", ex);
                    this.getColumn(i).addData(null);
                }
            }
        }
        if (this.report.getTopN() > 0) {
            this.topN();
        }
        this.releaseDiskBuffer();
        ColData.releaseDiskBuffer(this.report.colData);
    }

    private void topN() {
        block6: {
            if (this.report.colDataSorted) break block6;
            int colInfoIndex = 0;
            for (int i = 0; i < this.report.colInfo.length; ++i) {
                if (!this.report.colInfo[i].isTopN()) continue;
                colInfoIndex = i;
            }
            ReportColumn column = this.getColumn(colInfoIndex);
            int[] sortedIndex = column.sort(this.report.isAscending());
            if (sortedIndex == null) {
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    this.getColumn(i).setTopNData(null, false, (short)0);
                }
            } else {
                int i;
                int size = this.report.getTopN() < sortedIndex.length ? this.report.getTopN() : sortedIndex.length;
                int[] sortedTopNIndex = new int[size];
                for (i = 0; i < size; ++i) {
                    sortedTopNIndex[i] = sortedIndex[i];
                }
                for (i = 0; i < this.getColumnCount(); ++i) {
                    this.getColumn(i).setTopNData(sortedTopNIndex, false, (short)0);
                }
            }
        }
    }
}

