/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.util.logging.Logger;
import quadbase.reportdesigner.report.MultiDimData;
import quadbase.reportdesigner.util.ColInfo;

public class CrossTabColumnAttr {
    private static final Logger LOGGER = Logger.getLogger(CrossTabColumnAttr.class.getName());
    CrossTabColumnAttr[] crossTabColumn;
    int totalChildCt = 0;
    boolean isNullColumn;
    int colBkValCt = 1;

    public CrossTabColumnAttr(MultiDimData mData) {
        this(mData, true);
    }

    private CrossTabColumnAttr(MultiDimData pData, boolean isParent) {
        if (pData == null) {
            this.isNullColumn = true;
            return;
        }
        int ctRowBk = 0;
        this.colBkValCt = pData.report.getColumnBreakValueCount();
        if (isParent) {
            for (ColInfo element : pData.report.colInfo) {
                if (!element.isRowBreak()) continue;
                ++ctRowBk;
            }
            int breakCt = pData.report.breakColInfo.length;
            int[] maxChild = new int[breakCt];
            this.findTreeStructure(pData, 0, maxChild);
            this.createCrossTabColumn(ctRowBk, maxChild, pData);
            this.setValues(pData, ctRowBk);
            this.totalChildCt = this.count(0);
            LOGGER.finest("Total child count: " + this.totalChildCt);
        }
    }

    private void findTreeStructure(MultiDimData mData, int lvl, int[] maxChild) {
        if (mData == null) {
            return;
        }
        if (mData.multiData == null) {
            return;
        }
        for (MultiDimData element : mData.multiData) {
            this.findTreeStructure(element, lvl + 1, maxChild);
        }
        if (mData.multiData.length > maxChild[lvl]) {
            maxChild[lvl] = mData.multiData.length;
        }
    }

    private void createCrossTabColumn(int lvl, int[] maxChild, MultiDimData pData) {
        if (lvl >= maxChild.length) {
            return;
        }
        this.crossTabColumn = new CrossTabColumnAttr[maxChild[lvl]];
        for (int i = 0; i < this.crossTabColumn.length; ++i) {
            this.crossTabColumn[i] = new CrossTabColumnAttr(null, false);
            this.crossTabColumn[i].createCrossTabColumn(lvl + 1, maxChild, pData);
        }
    }

    public boolean isNullColumn() {
        return this.isNullColumn;
    }

    public boolean isNullColumn(int ii) {
        int i = ii / this.colBkValCt;
        return this.isNullColumn(i, this.totalChildCt);
    }

    private boolean isNullColumn(int i, int childCount) {
        if (this.crossTabColumn != null && this.crossTabColumn.length > 0 && childCount > 0) {
            int numPerSlot = childCount / this.crossTabColumn.length;
            return this.crossTabColumn[i / numPerSlot].isNullColumn(i % numPerSlot, numPerSlot);
        }
        return this.isNullColumn();
    }

    private int count(int ct) {
        if (this.crossTabColumn == null) {
            ++ct;
        } else {
            int max = 0;
            for (CrossTabColumnAttr element : this.crossTabColumn) {
                int val;
                if (element == null || (val = element.count(ct)) <= max) continue;
                max = val;
            }
            ct = max * this.crossTabColumn.length;
        }
        return ct;
    }

    private void setValues(MultiDimData mData, int lvl) {
        int i;
        int[] loc = new int[mData.report.breakColInfo.length];
        for (i = 0; i < lvl; ++i) {
            loc[i] = -1;
        }
        if (this.crossTabColumn != null) {
            for (i = 0; i < this.crossTabColumn.length; ++i) {
                loc[lvl] = i;
                this.crossTabColumn[i].setValue(mData, loc, lvl + 1);
            }
        }
    }

    private void setValue(MultiDimData mData, int[] loc, int lvl) {
        if (this.crossTabColumn == null) {
            this.isNullColumn = this.isNullColumn(mData, loc, 0);
        } else {
            if (lvl >= loc.length) {
                return;
            }
            for (int i = 0; i < this.crossTabColumn.length; ++i) {
                loc[lvl] = i;
                if (this.crossTabColumn[i] == null) continue;
                this.crossTabColumn[i].setValue(mData, loc, lvl + 1);
            }
        }
    }

    private boolean isNullColumn(MultiDimData mData, int[] loc, int lvl) {
        if (lvl < loc.length && loc[lvl] == -1) {
            if (mData == null || mData.multiData == null) {
                return true;
            }
            for (MultiDimData element : mData.multiData) {
                boolean b = this.isNullColumn(element, loc, lvl + 1);
                if (b) continue;
                return b;
            }
            return true;
        }
        if (mData == null) {
            return true;
        }
        if (mData.multiData != null) {
            return this.isNullColumn(mData.multiData[loc[lvl]], loc, lvl + 1);
        }
        return mData.plotData.isEmpty();
    }

    private int testing(int ct) {
        if (this.crossTabColumn == null) {
            LOGGER.finest("IDX[" + ct + "] IS NULL COLUMN = " + this.isNullColumn);
            ++ct;
        } else {
            for (CrossTabColumnAttr element : this.crossTabColumn) {
                ct = element.testing(ct);
            }
        }
        return ct;
    }

    private void debug(MultiDimData mData, int idx, int lvl, int len) {
        if (mData == null) {
            LOGGER.finest("Level = " + lvl + " IDX[" + idx + "] OF " + len + " EMPTY!!!!!!!!!");
        } else if (mData.multiData == null) {
            LOGGER.finest("Level = " + lvl + " IDX[" + idx + "] OF " + len + " LAST LEVEL");
            LOGGER.finest("CT ELT = " + mData.plotData.countElement());
        } else {
            LOGGER.finest("Level = " + lvl + " IDX[" + idx + "]OF " + len);
            for (int i = 0; i < mData.multiData.length; ++i) {
                this.debug(mData.multiData[i], i, lvl + 1, mData.multiData.length);
            }
        }
    }
}

