/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DataSet;
import quadbase.common.util.internal.DataSetColumn;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IDataSet;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.CBAggrColumn;
import quadbase.reportdesigner.ReportElements.ColumnBreakColumn;
import quadbase.reportdesigner.ReportElements.CrossTabReportSection;
import quadbase.reportdesigner.ReportElements.FormattedCell;
import quadbase.reportdesigner.ReportElements.FormattedRowKey;
import quadbase.reportdesigner.ReportElements.RBColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.ReportStyle;
import quadbase.reportdesigner.report.AbstractReportSectionFactory;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.CrossTabColumnAttr;
import quadbase.reportdesigner.report.CrossTabSectionFactory;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.MultiDimData;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.IAggregateConstants;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class CrossTabTable
extends ReportMultiSectionTable {
    private static final Logger LOGGER = Logger.getLogger(CrossTabTable.class.getName());
    MultiDimData mData;
    CrossTabColumnAttr colAttr;
    int count;
    private int[] fieldsCount;
    private Vector<ReportCell> headerCells;
    private boolean isDesignMode = false;

    public CrossTabTable() {
    }

    public CrossTabTable(Report report) {
        this(report, false);
    }

    public CrossTabTable(Report report, boolean isDesignMode) {
        super(report.getLocale(), report.getTimeZone());
        int i;
        this.isDesignMode = isDesignMode;
        boolean setupColumnBreak = true;
        this.setWidth(report.getActualPageWidth());
        this.headerCells = new Vector();
        for (ColInfo element : report.colInfo) {
            if (!element.isSorted()) continue;
            report.colData[element.getMapping()].setSortOrder(element.isAsc());
        }
        this.mData = this.createMultiDimData(report);
        this.mData.setAggrDataForMultiDimData(report.rowBreakAggrIncluded, report.colBreakAggrIncluded);
        this.colAttr = new CrossTabColumnAttr(this.mData);
        int colBkValCt = 0;
        double defaultCellHeight = ReportStyle.getDefaultCellHeight(this.mData.report.reportStyle);
        for (i = 0; i < report.colInfo.length; ++i) {
            if (report.colInfo[i].isColumnBreak()) {
                if (!setupColumnBreak) continue;
                this.fieldsCount = new int[report.getColumnBreakCount()];
                this.insertAllColumns(report);
                setupColumnBreak = false;
                continue;
            }
            if (!report.isShowRowAggregationGrandTotal() && report.colInfo[i].isColumnBreakValue()) continue;
            ReportColumn rCol = report.createColumn(i, report.colInfo.length);
            if (report.colInfo[i].isColumnBreakValue() && report.placeColumnBreakValueVertically()) {
                ++colBkValCt;
            }
            rCol.setVisible(report.colInfo[i].isVisible());
            rCol.setHeight(defaultCellHeight);
            this.addColumn(rCol);
        }
        this.dataHeader = new CrossTabReportSection[report.breakColInfo.length - 1 - report.getColumnBreakCount()];
        this.dataFooter = new CrossTabReportSection[report.breakColInfo.length - 1 - report.getColumnBreakCount()];
        for (i = 0; i < this.dataFooter.length; ++i) {
            this.dataHeader[i] = new CrossTabReportSection(this);
            this.dataFooter[i] = new CrossTabReportSection(this);
        }
        this.formatColumn();
    }

    @Override
    public AbstractReportSectionFactory getReportSectionFactory() {
        return new CrossTabSectionFactory();
    }

    @Override
    public AbstractReportSectionFactory getReportSectionFactory(int version, boolean pack, FileInMemTable subFilesTable, String domainPath) {
        if (this.reportSectionFactory == null) {
            this.reportSectionFactory = new CrossTabSectionFactory(version, pack, subFilesTable, domainPath);
        }
        return this.reportSectionFactory;
    }

    static CrossTabTable createMultiSectionTable(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable, String domainPath) throws Exception {
        CrossTabTable tbl = new CrossTabTable();
        tbl.read(in, version, pack, fromReportDesigner, subFilesTable, domainPath);
        return tbl;
    }

    private MultiDimData createMultiDimData(Report report) {
        MultiDimData mData = new MultiDimData(report);
        for (int i = 0; i < report.colData[0].getSize(); ++i) {
            mData.addRecNo(i);
        }
        mData.build(0);
        if (!report.isColDataSorted() && mData.report.recIndex == null) {
            mData.report.recIndex = new int[report.colData[0].getSize()];
            this.count = 0;
            this.traversMultiDataTree(mData, mData.report.recIndex);
            for (ColData element : mData.report.colData) {
                element.setRecIndex(report.recIndex);
            }
        }
        if (!report.isForExportOnly()) {
            try {
                mData.multiData = new MultiDimData[report.colData[report.breakColInfo[0].getMapping()].getNumField()];
                mData.createTreeFromSortedData();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to create multi dimensional data", e);
            }
        }
        return mData;
    }

    public CrossTabTable(CrossTabTable _table) {
        super(_table);
        this.mData = _table.mData;
        this.count = _table.count;
        this.colAttr = _table.colAttr;
        this.fieldsCount = _table.fieldsCount;
        this.headerCells = _table.headerCells;
        this.isDesignMode = _table.isDesignMode;
        this.header = _table.header;
        this.footer = _table.footer;
        for (int i = 0; i < _table.getColumnCount(); ++i) {
            ReportColumn tcol = new ReportColumn(_table.getColumn(i));
            tcol.resetData();
            this.addColumn(tcol);
        }
    }

    private void traversMultiDataTree(MultiDimData multiData, int[] recIndex) {
        block4: {
            if (multiData == null) break block4;
            if (multiData.multiData != null) {
                for (MultiDimData element : multiData.multiData) {
                    this.traversMultiDataTree(element, recIndex);
                }
            } else {
                for (int i = 0; i < multiData.recNoVec.size(); ++i) {
                    recIndex[this.count++] = multiData.recNoVec.elementAt(i);
                }
            }
        }
    }

    @Override
    public void formatTable() throws Exception {
        this.formatTable(false);
    }

    public void formatTable(boolean isDesignMode) throws Exception {
        Vector<ReportTable> _subTables = this.getSubTable();
        this.isDesignMode = isDesignMode;
        this.reformat();
        IDataSet[] dataSetTree = new DataSet[this.getColumnCount()];
        Properties treeProp2 = new Properties();
        for (int j = 0; j < dataSetTree.length; ++j) {
            dataSetTree[j] = new DataSetColumn(CrossTabTable.getColumnAddress(j), ServerMessage.getMaxFieldSize(), this.getColumnCount(), true, treeProp2);
        }
        this.createTable(this.mData, this, dataSetTree);
        this.setTableNumber(this);
        if (this.mData.report.isCrossTabFixedField()) {
            ReportElement[] newCellsX;
            int[] rowBkIdx = new int[this.fieldsCount.length];
            for (int i = 0; i < rowBkIdx.length; ++i) {
                rowBkIdx[i] = 0;
            }
            for (ReportElement element : newCellsX = ReportElement.sortElement(this.getHeader().getData(), 1, true)) {
                if (!(element instanceof RBColumnHeader)) continue;
                int rowBkLevel = ((RBColumnHeader)element).getColBreakLevel();
                this.getCrossTabHeader().calcRBColumnHeaderWidth((RBColumnHeader)element, this.getColumns(), this.fieldsCount, this.mData.report.isRowAggregationSubtotalOnLeft(), this.mData.report.isShowRowAggregationSubtotal(), rowBkIdx[rowBkLevel]);
                int n = rowBkLevel;
                rowBkIdx[n] = rowBkIdx[n] + 1;
            }
            CrossTabReportSection.repositionCells(this.getHeader(), this.getHeader(), this.getColumns(), this.fieldsCount, false, this.mData.report.isRowAggregationSubtotalOnLeft(), this.mData.report.isShowRowAggregationSubtotal());
        }
        Vector<ReportTable> subTables = this.getSubTable();
        if (_subTables.size() != subTables.size()) {
            this.releaseDiskBuffer();
            ColData.releaseDiskBuffer(this.mData.report.colData);
            return;
        }
        for (int i = 0; i < _subTables.size(); ++i) {
            ReportTable _tbl = _subTables.elementAt(i);
            ReportTable tbl = subTables.elementAt(i);
            tbl.copySortingInfo(_tbl, 0, false, this.mData.report);
            tbl.setTableNumber(_tbl.getTableNumber());
        }
        this.setTableID();
        this.releaseDiskBuffer();
        ColData.releaseDiskBuffer(this.mData.report.colData);
    }

    public CrossTabReportSection getCrossTabHeader() {
        return (CrossTabReportSection)this.header;
    }

    public CrossTabReportSection getCrossTabFooter() {
        return (CrossTabReportSection)this.footer;
    }

    @Override
    public int getStartOfColumnBreakColumn() {
        return this.mData.report.breakColIndex[this.mData.report.breakColIndex.length - this.fieldsCount.length];
    }

    @Override
    public int getEndOfColumnBreakColumn() {
        int count = this.getColumnBreakColumnCount();
        if (count <= 0) {
            return this.getStartOfColumnBreakColumn();
        }
        return this.getStartOfColumnBreakColumn() + this.getColumnBreakColumnCount() - 1;
    }

    @Override
    public int getColumnBreakColumnCount() {
        int count = 1;
        for (int i = this.fieldsCount.length - 1; i >= 0; --i) {
            count = count * this.fieldsCount[i] + (this.mData.report.isShowRowAggregationSubtotal() ? 1 : 0);
        }
        return this.mData.report.getColumnBreakValueCount() * (count - (this.mData.report.isShowRowAggregationSubtotal() ? 1 : 0));
    }

    private ReportTable createTable(MultiDimData data, ReportTreeTable cTbl, IDataSet[] dataSetTree) throws Exception {
        int i;
        int nCol = data.report.colInfo.length;
        if (data.level < data.report.breakColInfo.length - data.report.getColumnBreakCount()) {
            for (int i2 = 0; data.multiData != null && i2 < data.multiData.length; ++i2) {
                if (data.multiData[i2] == null) continue;
                Properties treeProp = new Properties();
                treeProp.put("DataSetTreeArray", dataSetTree);
                ReportTable subTbl = this.createTable(data.multiData[i2], new ReportTreeTable(this, cTbl.getColumnCount(), treeProp), dataSetTree);
                if (subTbl == null) continue;
                cTbl.addSubTable(subTbl);
            }
            if (data.aggrData != null) {
                Properties treeProp = new Properties();
                treeProp.put("DataSetTreeArray", dataSetTree);
                ReportTable subTbl = this.createTable(data.aggrData, new ReportTreeTable(this, cTbl.getColumnCount(), treeProp), dataSetTree);
                subTbl.setAggregationTable(true);
                cTbl.addSubTable(subTbl);
            }
            if (cTbl.countSubTable() == 0) {
                return null;
            }
            if (data.level <= this.dataHeader.length && data.level > 0) {
                Object fieldName = data.getFieldName();
                cTbl.setHeader(this.dataHeader[data.level - 1]);
                cTbl.setFooter(this.dataFooter[data.level - 1]);
                if (cTbl.getFirstTable().getColumn(this.getFormatColumnIndex(data)) != null) {
                    cTbl.getFirstTable().getColumn(this.getFormatColumnIndex(data)).setData(0, fieldName);
                }
                cTbl.setDrillDownData(this.getFormatColumnIndex(data), fieldName);
            }
            this.copyFormattedInfo(cTbl);
            return cTbl;
        }
        int vIndex = data.report.getColumnBreakValueCount();
        ReportTable rTbl = new ReportTable(this);
        boolean processColumnBreak = true;
        int colIdx = 0;
        int colBkValCt = 0;
        for (i = 0; i < nCol; ++i) {
            Properties treeProp;
            Object tblCol = null;
            if (data.report.colInfo[i].isRowBreak()) {
                tblCol = i == data.report.breakColIndex[data.level - 1] ? data.getFieldName() : "";
                treeProp = new Properties();
                treeProp.put("DataSetTreeArray", dataSetTree);
                rTbl.addColumn(this.createColumn(colIdx++, tblCol, treeProp));
                continue;
            }
            if (data.report.colInfo[i].isColumnBreak()) {
                if (!processColumnBreak) continue;
                Vector<ReportColumn> rowList = new Vector<ReportColumn>();
                Properties treeProp2 = new Properties();
                treeProp2.put("DataSetTreeArray", dataSetTree);
                int newColIdx = this.addColumnBreakColumns(data, this.colAttr, rowList, this.fieldsCount.length, colIdx, treeProp2);
                for (int k = 0; k < rowList.size(); ++k) {
                    rTbl.addColumn(rowList.elementAt(k));
                }
                if (newColIdx < 0) {
                    return null;
                }
                colIdx = newColIdx;
                processColumnBreak = false;
                continue;
            }
            if (data.report.colInfo[i].getFormula() == null) {
                if (data.report.isShowRowAggregationGrandTotal() || !data.report.colInfo[i].isColumnBreakValue()) {
                    tblCol = data.getComputedValue(vIndex);
                    treeProp = new Properties();
                    treeProp.put("DataSetTreeArray", dataSetTree);
                    ReportColumn temp_col = this.createColumn(colIdx++, tblCol, treeProp);
                    Vector<Object> aData = new Vector<Object>();
                    data.getValueList(vIndex, aData);
                    int aDataSize = aData.size();
                    for (int o = 0; o < aDataSize; ++o) {
                        temp_col.addActualData(aData.elementAt(o));
                    }
                    if (data.report.colInfo[i].isColumnBreakValue() && data.report.placeColumnBreakValueVertically()) {
                        ++colBkValCt;
                    }
                    rTbl.addColumn(temp_col);
                }
                ++vIndex;
                continue;
            }
            treeProp = new Properties();
            treeProp.put("DataSetTreeArray", dataSetTree);
            rTbl.addColumn(this.createColumn(colIdx++, tblCol, treeProp));
        }
        for (i = 0; i < nCol; ++i) {
            Formula formula;
            if (data.report.colInfo[i].getFormulaObj() == null) {
                String name = data.report.colInfo[i].getFormulaName();
                String text = data.report.colInfo[i].getFormula();
                if (text == null) continue;
                formula = new Formula(name, text);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                formula.setFormula(parser.parse(new Vector(), data.report.getQueryParameters(), data.report.getFormulaParameters(), null));
            } else {
                formula = data.report.colInfo[i].getFormulaObj();
                if (formula == null) continue;
            }
            Object obj = null;
            try {
                obj = formula.getValue(rTbl, 0, 1, 1, 1, 1, data.report, null, null);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Cannot get formula value", ex);
            }
            try {
                rTbl.getColumn(this.getFormatColumnIndex(this.mData, i)).addData(obj);
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to add formula value to column", ex);
            }
        }
        if (data.level <= this.dataHeader.length && data.level > 0) {
            rTbl.setHeader(this.dataHeader[data.level - 1]);
            rTbl.setFooter(this.dataFooter[data.level - 1]);
        }
        return rTbl;
    }

    private static String getColumnAddress(int j) {
        return "CRTCOL_" + j + "_" + QbUtil.nextNumber();
    }

    private ReportTreeTable copyFormattedInfo(ReportTreeTable cTbl) {
        for (int i = 0; i < cTbl.getColumnCount(); ++i) {
            Hashtable<FormattedRowKey, FormattedCell> formattedCellsTable = cTbl.getColumn(i).getFormattedCellsTable();
            if (formattedCellsTable == null) continue;
            Enumeration<FormattedRowKey> keys = formattedCellsTable.keys();
            while (keys.hasMoreElements()) {
                FormattedRowKey key = keys.nextElement();
                int[] tree = key.getTreeStructure();
                FormattedCell cell = formattedCellsTable.get(key);
                ReportTable table = cTbl;
                for (int element : tree) {
                    if (!(table instanceof ReportTreeTable)) continue;
                    table = table.getSubTable(element);
                }
                table.getColumn(i).addFormattedCell(cell);
            }
        }
        if (cTbl.getFormattedRows() != null) {
            Enumeration<FormattedRowKey> keys = cTbl.getFormattedRows().keys();
            while (keys.hasMoreElements()) {
                FormattedRowKey key = keys.nextElement();
                int[] tree = key.getTreeStructure();
                if (tree == null) continue;
                ReportTable table = cTbl;
                for (int j = 0; j < tree.length - 1; ++j) {
                }
                for (int element : tree) {
                    if (!(table instanceof ReportTreeTable)) continue;
                    table = table.getSubTable(element);
                }
                table.addFormattedRow(key, cTbl.getFormattedRows().get(key));
            }
        }
        return cTbl;
    }

    private ReportColumn createColumn(int i, Object tblCol, IDataSet dataSetTree) {
        Properties treeProp = new Properties();
        treeProp.put("DataSetTree", dataSetTree);
        return this.createColumn(i, tblCol, treeProp);
    }

    private ReportColumn createColumn(int i, Object tblCol, Properties treeProp) {
        ReportColumn rCol = null;
        IDataSet[] dataSetTree = (IDataSet[])treeProp.get("DataSetTreeArray");
        if (dataSetTree != null && i < dataSetTree.length) {
            treeProp.put("DataSetTree", dataSetTree[i]);
        }
        if (this.getColumn(i) instanceof ColumnBreakColumn) {
            rCol = new ColumnBreakColumn((ColumnBreakColumn)this.getColumn(i), treeProp);
            rCol.applyStyle(this.getFirstColumnBreakColumn(((ColumnBreakColumn)this.getColumn(i)).getColBreakValueIndex()));
        } else if (this.getColumn(i) instanceof CBAggrColumn) {
            rCol = new CBAggrColumn((CBAggrColumn)this.getColumn(i), treeProp);
            rCol.applyStyle(this.getFirstCBAggrColumn(((CBAggrColumn)rCol).getColBreakLevel(), ((CBAggrColumn)rCol).getColBreakValueIndex()));
        } else {
            rCol = new ReportColumn(this.getColumn(i), treeProp);
        }
        rCol.resetData();
        rCol.addData(tblCol);
        return rCol;
    }

    private ReportColumn newColumnBreakColumn(String name, IFormat dataFormat, Report report, int colBKValIdx) {
        if (report.isCrossTabFixedField()) {
            return new ColumnBreakColumn(name, dataFormat, colBKValIdx, report.colInfo.length);
        }
        return new ReportColumn(name, dataFormat, report.colInfo.length);
    }

    private ReportCell newRBColumnHeader(String text, int level, Report report) {
        if (report.isCrossTabFixedField()) {
            return new RBColumnHeader(text, level);
        }
        return new ReportCell(text);
    }

    private ReportColumn newCBAggrColumn(String name, IFormat dataFormat, int level, int colBkValIdx, Report report) {
        if (report.isCrossTabFixedField()) {
            return new CBAggrColumn(name, dataFormat, level, colBkValIdx, report.colInfo.length);
        }
        return new ReportColumn(name, dataFormat, report.colInfo.length);
    }

    private int getFormatColumnIndex(MultiDimData data) {
        return this.getFormatColumnIndex(this.mData, data.report.breakColIndex[data.level - 1]);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.reformat();
        super.write(out);
        try {
            this.formatTable();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to format table", ex);
        }
    }

    private int addColumnBreakColumns(MultiDimData mdData, CrossTabColumnAttr columnAttr, Vector<ReportColumn> rowList, int level, int insertColumnIndex, Properties treeProp) {
        Vector<Object> aData;
        ReportColumn temp_col;
        int i;
        boolean hasData = false;
        int dimDataCt = mdData.multiData.length;
        if (this.mData.report.isCrossTabFixedField() && this.isDesignMode) {
            dimDataCt = 1;
        }
        if (this.mData.report.isShowRowAggregationSubtotal() && this.mData.report.isRowAggregationSubtotalOnLeft() && level != this.fieldsCount.length) {
            for (i = 0; i < mdData.report.getColumnBreakValueCount(); ++i) {
                Object aggrValue = mdData.getComputedValue(i);
                temp_col = this.createColumn(insertColumnIndex++, aggrValue, treeProp);
                aData = new Vector<Object>();
                mdData.getValueList(i, aData);
                for (int o = 0; o < aData.size(); ++o) {
                    temp_col.addActualData(aData.elementAt(o));
                }
                rowList.add(temp_col);
            }
        }
        for (int j = 0; j < dimDataCt; ++j) {
            if (level > 1) {
                if (mdData.multiData[j] != null) {
                    if ((insertColumnIndex = this.addColumnBreakColumns(mdData.multiData[j], columnAttr.crossTabColumn[j], rowList, level - 1, insertColumnIndex, treeProp)) > 0) {
                        hasData = true;
                        continue;
                    }
                    insertColumnIndex = -insertColumnIndex;
                    continue;
                }
                IDataSet[] dataSetTree = (IDataSet[])treeProp.get("DataSetTreeArray");
                insertColumnIndex = this.insertEmptyColumns(this.fieldsCount.length - level + 1, rowList, insertColumnIndex, columnAttr.crossTabColumn[j], dataSetTree);
                continue;
            }
            for (int i2 = 0; i2 < mdData.report.getColumnBreakValueCount(); ++i2) {
                Object tblCol = null;
                if (mdData.multiData[j] != null && !mdData.multiData[j].plotData.isEmpty()) {
                    tblCol = mdData.multiData[j].getValue(0, i2);
                    hasData = true;
                }
                ReportColumn temp_col2 = this.createColumn(insertColumnIndex++, tblCol, treeProp);
                if (mdData.multiData[j] != null) {
                    Object[] td;
                    for (Object element : td = mdData.multiData[j].plotData.getColumnValue(i2)) {
                        temp_col2.addActualData(element);
                    }
                }
                if (this.mData.report.isCrossTabFixedField() && columnAttr.crossTabColumn[j].isNullColumn() && !this.isDesignMode) {
                    temp_col2.setVisible(false);
                }
                rowList.add(temp_col2);
            }
        }
        if (this.mData.report.isShowRowAggregationSubtotal() && !this.mData.report.isRowAggregationSubtotalOnLeft() && level != this.fieldsCount.length) {
            for (i = 0; i < mdData.report.getColumnBreakValueCount(); ++i) {
                Object aggrValue = mdData.getComputedValue(i);
                temp_col = this.createColumn(insertColumnIndex++, aggrValue, treeProp);
                aData = new Vector();
                mdData.getValueList(i, aData);
                int aDataSize = aData.size();
                for (int o = 0; o < aDataSize; ++o) {
                    temp_col.addActualData(aData.elementAt(o));
                }
                rowList.add(temp_col);
            }
        }
        if (hasData || this.mData.report.isCrossTabFixedField()) {
            return insertColumnIndex;
        }
        return --insertColumnIndex;
    }

    @Override
    public int getVisibleColumnCount() {
        int ct = 0;
        boolean foundFirstColumnBreakColumn = false;
        if (this.isDesignMode && this.mData.report.isCrossTabFixedField()) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (!this.getColumn(i).isVisible()) continue;
                if (!foundFirstColumnBreakColumn && this.getColumn(i) instanceof ColumnBreakColumn) {
                    ct += this.mData.report.getColumnBreakValueCount();
                    foundFirstColumnBreakColumn = true;
                    continue;
                }
                if (this.getColumn(i) instanceof ColumnBreakColumn) continue;
                ++ct;
            }
            return ct;
        }
        return super.getVisibleColumnCount();
    }

    @Override
    public void formatColumn() {
        super.formatColumn(this.mData.report.isCrossTabFixedField());
        int extraspace = 0;
        if (this.mData.report.getColumnBreakValueCount() > 1 && !this.mData.report.placeColumnBreakValueVertically()) {
            extraspace = 1;
        }
        CrossTabReportSection header = this.getCrossTabHeader();
        ReportCell[] reportCells = header.getData();
        double defaultCellHeight = ReportStyle.getDefaultCellHeight(this.mData.report.reportStyle);
        for (ReportCell element : reportCells) {
            element.setY((double)(this.fieldsCount.length - 1 + extraspace) * defaultCellHeight + element.getY());
            element.setHeight(defaultCellHeight);
        }
        int offset = 0;
        for (int i = 0; i < this.getStartOfColumnBreakColumn(); ++i) {
            if (!this.getColumn(i).isVisible()) continue;
            ++offset;
        }
        this.insertHeaderCells(header, offset);
        header.setHeight((double)(this.fieldsCount.length + extraspace) * defaultCellHeight);
    }

    private void insertHeaderCells(ReportSection header, int offset) {
        for (int i = 0; i < this.headerCells.size(); ++i) {
            ReportCell cell = this.headerCells.elementAt(i);
            cell.setX((double)offset + cell.getX());
            if (!this.mData.report.isCrossTabFixedField() && cell.getWidth() > 1.0) {
                cell.setX(cell.getX() + cell.getWidth() / 2.0 - 0.5);
                cell.setWidth(1.0);
            }
            header.addData(cell);
        }
    }

    private double insertAllColumns(Report report) {
        Vector<ReportColumn> rowList = new Vector<ReportColumn>();
        double defaultCellHeight = ReportStyle.getDefaultCellHeight(this.mData.report.reportStyle);
        if (report.placeColumnBreakValueVertically()) {
            this.setHeight((double)report.getColumnBreakValueCount() * defaultCellHeight);
        } else {
            this.setHeight(defaultCellHeight);
        }
        Vector<ReportCell> colBkValHdrList = new Vector<ReportCell>();
        double val = this.insertAllColumns(report, 0, new Vector<Object>(), "", 0.0, rowList, colBkValHdrList, this.colAttr);
        for (int i = 0; i < rowList.size(); ++i) {
            this.addColumn(rowList.elementAt(i));
        }
        double curX = 0.0;
        for (int i = 0; i < colBkValHdrList.size(); ++i) {
            ReportElement elt = colBkValHdrList.elementAt(i);
            if (i != 0) {
                elt.setX(curX);
            }
            curX = elt.getX() + elt.getWidth();
        }
        return val;
    }

    private double insertAllColumns(Report report, int level, Vector<Object> pathObjects, String pathString, double startX, Vector<ReportColumn> rowList, Vector<ReportCell> colBkValHdrList, CrossTabColumnAttr columnAttr) {
        double subWidthTotal;
        block34: {
            ReportColumn col;
            int i;
            double cellHeight;
            Object[] fieldName;
            ColData rowCol;
            int colBreakIndex;
            int startIdx;
            block35: {
                subWidthTotal = 0.0;
                startIdx = rowList.size();
                colBreakIndex = report.breakColInfo.length - this.fieldsCount.length + level;
                rowCol = report.colData[report.breakColInfo[colBreakIndex].getMapping()];
                fieldName = rowCol.getFieldName();
                cellHeight = ReportStyle.getDefaultCellHeight(report.reportStyle);
                if (report.colBreakAggrIncluded != null && level < report.colBreakAggrIncluded.length && report.colBreakAggrIncluded[level] && report.isCrossTabFixedField() && fieldName != null && !this.isDesignMode) {
                    Object[] newFieldName = new Object[fieldName.length - 1];
                    for (i = 0; i < newFieldName.length; ++i) {
                        newFieldName[i] = fieldName[i + 1];
                    }
                    fieldName = newFieldName;
                }
                if (this.isDesignMode && report.isCrossTabFixedField() && fieldName != null && fieldName.length > 1) {
                    fieldName = new Object[]{rowCol.getFieldName()[0]};
                }
                if (fieldName == null) break block34;
                this.fieldsCount[level] = fieldName.length;
                if (level != this.fieldsCount.length - 1) break block35;
                for (int m = 0; m < fieldName.length; ++m) {
                    String columnName = "";
                    columnName = fieldName[m] != null ? fieldName[m].toString() : "Null";
                    if (report.getColumnBreakValueCount() == 1 || report.placeColumnBreakValueVertically()) {
                        for (int i2 = 0; i2 < report.getColumnBreakValueCount(); ++i2) {
                            ReportColumn rCol = this.newColumnBreakColumn(columnName, report.getDataFormat(report.breakColIndex[colBreakIndex]), report, i2);
                            if (rCol instanceof ColumnBreakColumn) {
                                ((ColumnBreakColumn)rCol).setPathObjects(pathObjects);
                            }
                            if (report.isCrossTabFixedField() && columnAttr.crossTabColumn != null && m < columnAttr.crossTabColumn.length) {
                                rCol.setVisible(report.breakColInfo[report.breakColInfo.length - this.fieldsCount.length].isVisible() && (this.isDesignMode || !columnAttr.crossTabColumn[m].isNullColumn()));
                            } else {
                                rCol.setVisible(report.breakColInfo[report.breakColInfo.length - this.fieldsCount.length].isVisible());
                            }
                            rCol.setY((double)i2 * cellHeight);
                            rCol.setHeight(cellHeight);
                            rowList.add(rCol);
                        }
                        subWidthTotal += 1.0;
                        continue;
                    }
                    ReportCell cell = this.newRBColumnHeader(columnName, level, report);
                    cell.setY((double)level * ReportStyle.getDefaultCellHeight(report.reportStyle));
                    cell.setX(startX + (double)(m * report.getColumnBreakValueCount()));
                    cell.setWidth(report.getColumnBreakValueCount());
                    cell.setHeight(cellHeight);
                    this.headerCells.addElement(cell);
                    colBkValHdrList.addElement(cell);
                    for (int i3 = 0; i3 < report.getColumnBreakValueCount(); ++i3) {
                        ColData valCol = report.colData[report.colInfo[report.breakColValueIndex[i3]].getMapping()];
                        ReportColumn rCol = this.newColumnBreakColumn(FormatUtil.formatLabel(valCol.getName(), valCol.dataFormat), report.getDataFormat(report.breakColValueIndex[i3]), report, i3);
                        if (rCol instanceof ColumnBreakColumn) {
                            ((ColumnBreakColumn)rCol).setParentColumnName(columnName);
                            ((ColumnBreakColumn)rCol).setPathObjects(pathObjects);
                        }
                        rCol.setVisible(report.breakColInfo[report.breakColInfo.length - this.fieldsCount.length].isVisible());
                        rCol.setHeight(cellHeight);
                        rowList.add(rCol);
                        subWidthTotal += 1.0;
                    }
                }
                if (level != 0 && report.isShowRowAggregationSubtotal()) {
                    int i4;
                    if (!report.isRowAggregationSubtotalOnLeft()) {
                        for (i4 = 0; i4 < report.getColumnBreakValueCount(); ++i4) {
                            ReportColumn col2 = this.newCBAggrColumn(IAggregateConstants.AGGR[report.valColInfo[i4].getAggregation()] + " (" + pathString + ")", report.getDataFormat(report.breakColIndex[colBreakIndex]), 0, i4, report);
                            col2.setVisible(report.breakColInfo[report.breakColInfo.length - this.fieldsCount.length].isVisible());
                            if (report.placeColumnBreakValueVertically()) {
                                col2.setY((double)i4 * cellHeight);
                                rowList.add(col2);
                                if (i4 == 0) {
                                    subWidthTotal += 1.0;
                                }
                            } else {
                                rowList.add(col2);
                                subWidthTotal += 1.0;
                            }
                            col2.setHeight(cellHeight);
                        }
                    } else {
                        for (i4 = report.getColumnBreakValueCount() - 1; i4 >= 0; --i4) {
                            ReportColumn col3 = this.newCBAggrColumn(IAggregateConstants.AGGR[report.valColInfo[i4].getAggregation()] + " (" + pathString + ")", report.getDataFormat(report.breakColIndex[colBreakIndex]), 0, i4, report);
                            col3.setVisible(report.breakColInfo[report.breakColInfo.length - this.fieldsCount.length].isVisible());
                            if (report.placeColumnBreakValueVertically()) {
                                col3.setY((double)i4 * cellHeight);
                                rowList.insertElementAt(col3, startIdx);
                                if (i4 == 0) {
                                    subWidthTotal += 1.0;
                                }
                            } else {
                                rowList.insertElementAt(col3, startIdx);
                                subWidthTotal += 1.0;
                            }
                            col3.setHeight(cellHeight);
                        }
                    }
                }
                break block34;
            }
            String subpathString = "";
            for (int m = 0; m < fieldName.length; ++m) {
                String columnName = FormatUtil.formatLabel(fieldName[m], rowCol.dataFormat);
                subpathString = pathString == null || pathString.trim().equals("") ? columnName : pathString + " : " + columnName;
                if (columnAttr.crossTabColumn != null && columnAttr.crossTabColumn.length > m) {
                    pathObjects.add(fieldName[m]);
                    subWidthTotal += this.insertAllColumns(report, level + 1, pathObjects, subpathString, subWidthTotal, rowList, colBkValHdrList, columnAttr.crossTabColumn[m]);
                    pathObjects.remove(pathObjects.size() - 1);
                }
                ReportCell cell = this.newRBColumnHeader(columnName, level, report);
                cell.setY((double)level * cellHeight);
                cell.setX(subWidthTotal - subWidthTotal / (double)(m + 1) + startX);
                cell.setWidth(subWidthTotal / (double)(m + 1));
                cell.setHeight(cellHeight);
                this.headerCells.addElement(cell);
            }
            if (level == 0 || !report.isShowRowAggregationSubtotal()) break block34;
            if (!report.isRowAggregationSubtotalOnLeft()) {
                for (i = 0; i < report.getColumnBreakValueCount(); ++i) {
                    col = this.newCBAggrColumn(IAggregateConstants.AGGR[report.valColInfo[i].getAggregation()] + " (" + pathString + ")", report.getDataFormat(report.breakColIndex[colBreakIndex]), level, i, report);
                    col.setVisible(report.breakColInfo[report.breakColInfo.length - this.fieldsCount.length].isVisible());
                    if (report.placeColumnBreakValueVertically()) {
                        col.setY((double)i * cellHeight);
                        rowList.add(col);
                        if (i == 0) {
                            subWidthTotal += 1.0;
                        }
                    } else {
                        rowList.add(col);
                        subWidthTotal += 1.0;
                    }
                    col.setHeight(cellHeight);
                }
            } else {
                for (i = report.getColumnBreakValueCount() - 1; i >= 0; --i) {
                    col = this.newCBAggrColumn(IAggregateConstants.AGGR[report.valColInfo[i].getAggregation()] + " (" + pathString + ")", report.getDataFormat(report.breakColIndex[colBreakIndex]), level, i, report);
                    col.setVisible(report.breakColInfo[report.breakColInfo.length - this.fieldsCount.length].isVisible());
                    if (report.placeColumnBreakValueVertically()) {
                        col.setY((double)i * cellHeight);
                        rowList.insertElementAt(col, startIdx);
                        if (i == 0) {
                            subWidthTotal += 1.0;
                        }
                    } else {
                        rowList.insertElementAt(col, startIdx);
                        subWidthTotal += 1.0;
                    }
                    col.setHeight(cellHeight);
                    subWidthTotal += 1.0;
                }
            }
        }
        return subWidthTotal;
    }

    private int insertEmptyColumns(int level, Vector<ReportColumn> rowList, int insertColumnIndex, CrossTabColumnAttr columnAttr, IDataSet[] dataSetTree) {
        if (level == this.fieldsCount.length - 1) {
            for (int i = 0; i < this.fieldsCount[level]; ++i) {
                for (int j = 0; j < this.mData.report.getColumnBreakValueCount(); ++j) {
                    ReportColumn temp_col = this.createColumn(insertColumnIndex, null, dataSetTree[insertColumnIndex++]);
                    rowList.add(temp_col);
                }
            }
            insertColumnIndex = this.addSubTotalColumnsToRowList(rowList, insertColumnIndex, dataSetTree);
        } else {
            for (int i = 0; i < this.fieldsCount[level]; ++i) {
                insertColumnIndex = this.insertEmptyColumns(level + 1, rowList, insertColumnIndex, columnAttr.crossTabColumn[i], dataSetTree);
            }
            insertColumnIndex = this.addSubTotalColumnsToRowList(rowList, insertColumnIndex, dataSetTree);
        }
        return insertColumnIndex;
    }

    private int addSubTotalColumnsToRowList(Vector<ReportColumn> rowList, int insertColumnIndex, IDataSet[] dataSetTree) {
        if (this.mData.report.isShowRowAggregationSubtotal()) {
            for (int j = 0; j < this.mData.report.getColumnBreakValueCount(); ++j) {
                ReportColumn temp_col = this.createColumn(insertColumnIndex, null, dataSetTree[insertColumnIndex++]);
                rowList.add(temp_col);
            }
        }
        return insertColumnIndex;
    }

    public boolean isDesignMode() {
        return this.isDesignMode;
    }

    private void setTableNumber(ReportTreeTable cTbl) {
        for (int i = 0; i < cTbl.getSubTable().size(); ++i) {
            cTbl.getSubTable(i).setTableNumber(i);
        }
    }

    public int[] getFieldsCount() {
        return this.fieldsCount;
    }

    public CrossTabColumnAttr getColumnAttributes() {
        return this.colAttr;
    }

    @Override
    protected void copyDataHeaderAndFooter(boolean applyScript, boolean copyRpt, boolean keepElt, ReportCell[] globalFormatTemplates, ReportMultiSectionTable tmp, int columnCountMismatch, int separatingIndex, Vector<ReportColumn> columns, int[] fieldsCount, boolean isCrossTabSubTotalColumnPositionLeft, boolean isAddCrossTabSubTotalColumn, int i) {
        if (this.dataHeader[i] instanceof CrossTabReportSection) {
            ((CrossTabReportSection)this.dataHeader[i]).copy(tmp.dataHeader[i], columnCountMismatch, separatingIndex, columns, globalFormatTemplates, !copyRpt, false, true, applyScript, keepElt, fieldsCount, isCrossTabSubTotalColumnPositionLeft, isAddCrossTabSubTotalColumn, this.getHeader(), this.getColumns());
        }
        if (tmp.dataFooter[i] != null) {
            tmp.dataFooter[i].setNewExcelSheet(false);
        }
        if (this.dataFooter[i] instanceof CrossTabReportSection) {
            ((CrossTabReportSection)this.dataFooter[i]).copy(tmp.dataFooter[i], columnCountMismatch, separatingIndex, columns, globalFormatTemplates, !copyRpt, false, true, applyScript, keepElt, fieldsCount, isCrossTabSubTotalColumnPositionLeft, isAddCrossTabSubTotalColumn, this.getHeader(), this.getColumns());
        }
    }

    public static void insertCrossTabFormula(Report report, ReportTable tbl, int colBkFooterCount, double newY) {
        int startRow = tbl.getStartOfColumnBreakColumn();
        int count = tbl.getColumnBreakColumnCount() + startRow;
        for (int i = startRow; i < count; i += report.getColumnBreakValueCount()) {
            for (int k = 0; k < report.getColumnBreakValueCount(); ++k) {
                ColInfo rowBKVal = report.valColInfo[k];
                int dataType = report.getSQLType(rowBKVal);
                short aggr = rowBKVal.getAggregation();
                if (tbl.getColumn(i + k) == null || !tbl.getColumn(i + k).isVisible()) continue;
                ReportCell cell = report.createReportCell(tbl.getColumn(i + k), i + k, aggr, dataType, null, true);
                cell.setX(tbl.getColumn(i + k).getX());
                if (!report.isColumnAggregationInHeader()) {
                    tbl.getFooter().addData(cell);
                    cell.setY(tbl.getColumn(i + k).getY());
                } else {
                    tbl.getHeader().addData(cell);
                    cell.setY(tbl.getColumn(i + k).getY() + newY);
                }
                for (int j = 0; j < colBkFooterCount; ++j) {
                    cell = report.createReportCell(tbl.getColumn(i + k), i + k, aggr, dataType, null, true);
                    cell.setX(tbl.getColumn(i + k).getX());
                    cell.setY(tbl.getColumn(i + k).getY());
                    if (!report.isColumnAggregationInHeader()) {
                        tbl.getRowBreakFooter(j).addData(cell);
                        continue;
                    }
                    tbl.getRowBreakHeader(j).addData(cell);
                }
            }
        }
    }
}

