/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbCallableStatement;
import quadbase.common.util.internal.QbConnection;
import quadbase.reportdesigner.queryproc.IQueryProc;
import quadbase.reportdesigner.queryproc.IQueryProcFactory;
import quadbase.reportdesigner.queryproc.filter.EqFilter;
import quadbase.reportdesigner.queryproc.filter.FilterResultSet;
import quadbase.reportdesigner.queryproc.filter.RunSimpleFilter;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DataFileInput;
import quadbase.reportdesigner.report.FilterInfo;
import quadbase.reportdesigner.report.IOUtil2;
import quadbase.reportdesigner.report.OneWayResultSet;
import quadbase.reportdesigner.report.PreprocInfo;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.IResultSet;
import quadbase.reportdesigner.util.QueryResultSet;
import quadbase.reportdesigner.util.internal.TransposeRS;

public class DBAccess {
    private static final Logger LOGGER = Logger.getLogger(DBAccess.class.getName());
    static OneWayResultSet onewayRS = null;

    public static ColData[] retrieveResult(Vector parameters, DBInfoBasic dbInfo, boolean useDBbuffer, boolean transposeData, boolean[] transposeCol, FilterInfo filtInfo, PreprocInfo procInfo, boolean optimizeMemory) throws Exception {
        return DBAccess.retrieveResult(parameters, dbInfo, useDBbuffer, transposeData, transposeCol, filtInfo, procInfo, 0, -1, optimizeMemory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColData[] retrieveResult(Vector parameters, DBInfoBasic dbInfo, boolean useDBbuffer, boolean transposeData, boolean[] transposeCol, FilterInfo filtInfo, PreprocInfo procInfo, int startIndex, int displayRow, boolean optimizeMemory) throws Exception {
        ColData[] colData;
        DBInfoBasic dbInfoTmp = (DBInfoBasic)dbInfo.clone();
        if (Report.getReplaceColInfoList() != null) {
            dbInfoTmp.setQuery(Report.getReplaceColInfoList().replaceColumnInfoForWhereClause(dbInfoTmp.getQuery(), dbInfoTmp.getDriverName(), dbInfoTmp.getURLString()));
        }
        if (ServerMessage.useServer) {
            byte[] indata;
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
            DataOutputStream dout = new DataOutputStream(bstream);
            int messageType = -1;
            if (filtInfo != null || procInfo != null) {
                dout.writeShort(27587);
                messageType = 27587;
            } else {
                dout.writeShort(24097);
                messageType = 24097;
            }
            dbInfoTmp.write(dout);
            boolean hasParameter = QueryFileInfo.hasParameter(parameters);
            dout.writeBoolean(hasParameter);
            if (hasParameter) {
                DBAccess.findInParam(parameters).write(dout);
            }
            dout.writeBoolean(useDBbuffer);
            dout.writeBoolean(transposeData);
            IOUtil.writeBooleans(dout, transposeCol);
            dout.writeInt(startIndex);
            dout.writeInt(displayRow);
            dout.writeBoolean(false);
            IOUtil.writeStr(dout, "");
            if (messageType == 27587) {
                dout.writeBoolean(filtInfo != null);
                if (filtInfo != null) {
                    filtInfo.writeAsStream(dout);
                }
                dout.writeBoolean(procInfo != null);
                if (procInfo != null) {
                    procInfo.writeAsStream(dout);
                }
            }
            IConnection socket = null;
            try {
                socket = ServerMessage.createConnection();
                byte[] array = bstream.toByteArray();
                socket.setContentLength(array.length);
                socket.getOutputStream().write(array);
                socket.getOutputStream().flush();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to contact EspressReport server", ex);
                if (socket != null) {
                    socket.close();
                }
                throw new IOException("Failed to contact EspressReport server at " + ServerMessage.getServerInfo() + " " + ex.getMessage());
            }
            try {
                DataInputStream instream = new DataInputStream(socket.getInputStream());
                int code = instream.readInt();
                if (code != 0) {
                    throw new SQLException(IOUtil2.getErrorString(code) + "\n" + IOUtil.readString(instream, true));
                }
                indata = new byte[instream.readInt()];
                instream.readFully(indata, 0, indata.length);
                instream.close();
                socket.close();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Can't read data", ex);
                try {
                    socket.close();
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Can't close socket", ex2);
                }
                throw ex;
            }
            catch (Error err) {
                LOGGER.log(Level.FINEST, "Can't read data", err);
                try {
                    socket.close();
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Can't close socket", ex2);
                }
                throw new SQLException(err.toString());
            }
            DataInputStream binput = new DataInputStream(new ByteArrayInputStream(indata));
            return DataFileInput.getColDataFromStream(binput);
        }
        if (displayRow != -1 && optimizeMemory && !(dbInfoTmp instanceof IQueryFileInfo)) {
            IResultSet rs = DBAccess.getOneWayResultSet(parameters, dbInfoTmp, transposeData, transposeCol, filtInfo, procInfo, startIndex, displayRow);
            colData = ColData.getColData(rs);
        } else {
            Connection conn = dbInfoTmp.openConnection();
            try {
                if (optimizeMemory && dbInfoTmp instanceof IQueryFileInfo) {
                    startIndex = 0;
                    displayRow = -1;
                }
                IResultSet rs = DBAccess.getResultSetFromLocal(parameters, dbInfoTmp, conn, transposeData, transposeCol, filtInfo, procInfo, startIndex, displayRow);
                colData = ColData.getColData(rs, startIndex, displayRow);
            }
            finally {
                if (dbInfoTmp.isCloseConnectionEnabled()) {
                    conn.close();
                }
            }
        }
        return colData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IResultSet retrieveIResultSet(Vector parameters, DBInfoBasic dbInfo, boolean useDBbuffer, boolean transposeData, boolean[] transposeCol, FilterInfo filtInfo, PreprocInfo procInfo, int startIndex, int displayRow, boolean optimizeMemory) throws Exception {
        DBInfoBasic dbInfoTmp = (DBInfoBasic)dbInfo.clone();
        if (Report.getReplaceColInfoList() != null) {
            dbInfoTmp.setQuery(Report.getReplaceColInfoList().replaceColumnInfoForWhereClause(dbInfoTmp.getQuery(), dbInfoTmp.getDriverName(), dbInfoTmp.getURLString()));
        }
        IResultSet rs = null;
        if (displayRow != -1 && optimizeMemory && !(dbInfoTmp instanceof IQueryFileInfo)) {
            rs = DBAccess.getOneWayResultSet(parameters, dbInfoTmp, transposeData, transposeCol, filtInfo, procInfo, startIndex, displayRow);
        } else {
            Connection conn = dbInfoTmp.openConnection();
            try {
                if (optimizeMemory && dbInfoTmp instanceof IQueryFileInfo) {
                    startIndex = 0;
                    displayRow = -1;
                }
                rs = DBAccess.getResultSetFromLocal(parameters, dbInfoTmp, conn, transposeData, transposeCol, filtInfo, procInfo, startIndex, displayRow);
            }
            finally {
                if (dbInfoTmp.isCloseConnectionEnabled()) {
                    conn.close();
                }
            }
        }
        return rs;
    }

    private static IResultSet getResultSetFromLocal(Vector parameters, DBInfoBasic dbInfo, Connection conn, boolean transposeData, boolean[] transposeCol, FilterInfo filtInfo, PreprocInfo procInfo, int startIndex, int displayRow) throws Exception {
        Statement stmt;
        boolean isResult;
        String query = dbInfo.getQuery();
        query = query.trim();
        boolean hasParameter = QueryFileInfo.hasParameter(parameters);
        String productName = "";
        try {
            productName = conn.getMetaData().getDatabaseProductName();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Can't get database product name", ex);
        }
        if ((startIndex > 0 || displayRow > 0) && productName.toLowerCase().contains("mysql") && query.toLowerCase().indexOf(" limit ") < 0 && query.toLowerCase().indexOf("\nlimit ") < 0) {
            query = query + " LIMIT " + startIndex + ", " + displayRow;
        }
        if (QueryParser.isCallableStmt(query)) {
            if (hasParameter) {
                query = DBAccess.findInParam(parameters).convertToJDBCquery(query);
            }
            CallableStatement callstmt = conn instanceof QbConnection ? conn.prepareCall(query) : new QbCallableStatement(conn, query);
            if (hasParameter) {
                DBAccess.findInParam(parameters).setStmtValue(callstmt);
            }
            isResult = callstmt.execute();
            stmt = callstmt;
        } else if (QueryParser.isPreparedStmt(query)) {
            if (hasParameter) {
                query = DBAccess.findInParam(parameters).convertToJDBCquery(query);
            }
            PreparedStatement pStmt = conn.prepareStatement(query);
            if (hasParameter) {
                DBAccess.findInParam(parameters).setStmtValue(pStmt);
            }
            isResult = pStmt.execute();
            stmt = pStmt;
        } else {
            stmt = conn.createStatement();
            if (displayRow > 0) {
                stmt.setFetchSize(displayRow);
            }
            isResult = stmt.execute(query);
        }
        while (!isResult) {
            if (stmt.getUpdateCount() == -1) {
                stmt.close();
                throw new SQLException("No result set return !");
            }
            isResult = stmt.getMoreResults();
        }
        QueryResultSet rs = null;
        rs = new QueryResultSet(stmt, productName);
        return DBAccess.processResultSet(rs, true, transposeData, transposeCol, filtInfo, procInfo);
    }

    static synchronized void cleanOneWayResultSet() {
        try {
            if (onewayRS != null) {
                onewayRS.close();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Can't close IResultset", ex);
        }
        onewayRS = null;
    }

    private static synchronized IResultSet getOneWayResultSet(Vector parameters, DBInfoBasic dbInfo, boolean transposeData, boolean[] transposeCol, FilterInfo filtInfo, PreprocInfo procInfo, int startIndex, int displayRow) throws Exception {
        IResultSet rs = null;
        if (onewayRS == null || !onewayRS.equals(dbInfo)) {
            Statement stmt;
            boolean isResult;
            DBAccess.cleanOneWayResultSet();
            Connection conn = dbInfo.openConnection();
            String query = dbInfo.getQuery();
            query = query.trim();
            boolean hasParameter = QueryFileInfo.hasParameter(parameters);
            if (QueryParser.isCallableStmt(query)) {
                if (hasParameter) {
                    query = DBAccess.findInParam(parameters).convertToJDBCquery(query);
                }
                CallableStatement callstmt = conn.prepareCall(query);
                if (hasParameter) {
                    DBAccess.findInParam(parameters).setStmtValue(callstmt);
                }
                isResult = callstmt.execute();
                stmt = callstmt;
            } else if (QueryParser.isPreparedStmt(query)) {
                if (hasParameter) {
                    query = DBAccess.findInParam(parameters).convertToJDBCquery(query);
                }
                PreparedStatement pStmt = conn.prepareStatement(query);
                if (hasParameter) {
                    DBAccess.findInParam(parameters).setStmtValue(pStmt);
                }
                isResult = pStmt.execute();
                stmt = pStmt;
            } else {
                stmt = conn.createStatement();
                isResult = stmt.execute(query);
            }
            while (!isResult) {
                if (stmt.getUpdateCount() == -1) {
                    stmt.close();
                    throw new SQLException("No result set return !");
                }
                isResult = stmt.getMoreResults();
            }
            rs = new QueryResultSet(stmt);
            onewayRS = new OneWayResultSet(conn, dbInfo, rs, stmt);
        }
        rs = onewayRS.getResultSet(displayRow);
        return DBAccess.processResultSet(rs, true, transposeData, transposeCol, filtInfo, procInfo);
    }

    public static IResultSet processResultSet(IResultSet rs, boolean isFromDatabase, boolean transposeData, boolean[] transposeCol, FilterInfo filtInfo, PreprocInfo procInfo) throws Exception {
        if (transposeData) {
            rs = TransposeRS.doTranspose(rs, transposeCol);
        }
        if (filtInfo != null) {
            RunSimpleFilter rsf = new RunSimpleFilter();
            int[] compareOp = filtInfo.getCompareOp();
            int[] colIndex = filtInfo.getColIndex();
            Object[] value = filtInfo.getValue();
            for (int i = 0; i < filtInfo.getSize(); ++i) {
                if (compareOp[i] != 0) continue;
                rsf.andCondition(new EqFilter(colIndex[i], value[i]));
            }
            rs = rsf.run(rs);
        }
        if (procInfo != null) {
            Class<?> factoryClass = Class.forName("quadbase.reportdesigner.queryproc.ReportDelegate");
            IQueryProcFactory factory = (IQueryProcFactory)factoryClass.newInstance();
            IQueryProc q = factory.createQueryProc(procInfo.getSelectionColType(), isFromDatabase);
            if (isFromDatabase && filtInfo != null) {
                ((FilterResultSet)rs).setIQueryProc(q);
            }
            q.setInputResultSet(rs);
            q.setInputInfo(procInfo);
            q.run();
            rs = q.getOutputRows();
        }
        return rs;
    }

    private static QueryInParamSet findInParam(Vector parameter) {
        for (int i = 0; i < parameter.size(); ++i) {
            Object target = parameter.elementAt(i);
            if (!(target instanceof QueryInParamSet)) continue;
            return (QueryInParamSet)target;
        }
        return null;
    }
}

