/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.report.ChartObject;
import quadbase.reportdesigner.report.DHTMLReport;
import quadbase.reportdesigner.report.DHTMLSubReport;
import quadbase.reportdesigner.report.WriteDataFile;
import quadbase.util.internal.PNGJimiEncoder;

public class DHTMLRTFObject
extends DHTMLSubReport {
    private static final Logger LOGGER = Logger.getLogger(DHTMLRTFObject.class.getName());
    private Vector lines = null;
    private ReportRTFObject rtfObject = null;
    private int currentColumnCount = 0;
    private double bottomY = 0.0;
    private boolean drawTop = true;
    private boolean drawBottom = false;
    private boolean started = false;

    public DHTMLRTFObject(ReportRTFObject rtfObject, Vector l, double x, double y, double reportWidth, double reportHeight, DHTMLReport parent) {
        super(parent.report, x, y, reportWidth, reportHeight, rtfObject.getZ(), parent);
        if (reportHeight < 0.0) {
            this.pageHeight = parent.pageHeight;
        } else {
            this.checkVisibility = true;
            this.pageHeight = reportHeight;
        }
        this.rtfObject = rtfObject;
        this.lines = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            float averageColumnHeight = 999.0f;
            if (!this.report.isExportToMultiPages() && !this.checkVisibility) {
                averageColumnHeight = (float)this.getTotalTextHeight() / (float)this.rtfObject.getActualColumnCount();
            }
            String dhtmlText = "";
            int textHeight = 0;
            for (int i = 0; i < this.lines.size(); ++i) {
                Object[] seg;
                int j;
                Vector segments = (Vector)this.lines.elementAt(i);
                int ascent = 0;
                int descent = 0;
                for (j = 0; j < segments.size(); ++j) {
                    seg = (Object[])segments.elementAt(j);
                    if (seg[0] != null && seg[0] instanceof Image) {
                        int iHeight = (Integer)seg[2];
                        if (iHeight <= ascent) continue;
                        ascent = iHeight;
                        continue;
                    }
                    FontMetrics fontMetrics = QbUtil.getViewerFontMetrics((FontMetrics)seg[1], this.report.isAdjustFont());
                    if (fontMetrics.getMaxAscent() <= ascent) continue;
                    ascent = fontMetrics.getMaxAscent();
                    descent = fontMetrics.getMaxDescent();
                }
                if ((this.report.isExportToMultiPages() || this.checkVisibility) && QbUtil.toPixel_export(this.pageHeight - this.elementYPos) < ascent + descent + textHeight || !this.report.isExportToMultiPages() && !this.checkVisibility && (float)textHeight >= averageColumnHeight) {
                    if (i > 0) {
                        this.writeRichText(dhtmlText, textHeight);
                    }
                    this.elementYPos += QbUtil.toInch_export(textHeight);
                    this.pageBreak(null);
                    dhtmlText = "";
                    textHeight = 0;
                }
                textHeight = textHeight + ascent + descent;
                for (j = 0; j < segments.size(); ++j) {
                    seg = (Object[])segments.elementAt(j);
                    if (seg[0] != null && seg[0] instanceof Image) {
                        int iWidth = (Integer)seg[1];
                        int iHeight = (Integer)seg[2];
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        if (IOUtil.isJimiIncluded()) {
                            PNGJimiEncoder.createPNGImage((Image)seg[0], bout, 0);
                            byte[] barray = bout.toByteArray();
                            String imgPath = this.rtfObject.getSavedFileLocation();
                            String imgURL = this.rtfObject.getSavedFileURL();
                            if (imgPath == null || imgURL == null) {
                                imgPath = this.imageName + this.imageCount;
                                imgURL = ChartObject.getChartName(this.imageName + this.imageCount, 10);
                            } else {
                                imgPath = imgPath + this.imageCount;
                                imgURL = ChartObject.addExtension(imgURL + this.imageCount, 10);
                            }
                            if (!this.report.isDynamicExport()) {
                                ++this.imageCount;
                                new WriteDataFile().output(null, barray, imgPath + ".png");
                                dhtmlText = dhtmlText + "<IMG " + this.qt("SRC", imgURL) + " border=\"0\"" + this.qt("HEIGHT", iHeight) + " " + this.qt("WIDTH", iWidth) + ">";
                            } else {
                                dhtmlText = dhtmlText + "<IMG " + this.qt("SRC", this.doDynamicImageExport(barray)) + " border=\"0\"" + this.qt("HEIGHT", iHeight) + " " + this.qt("WIDTH", iWidth) + ">";
                            }
                        } else {
                            dhtmlText = dhtmlText + "<IMG " + this.qt("HEIGHT", 1) + " " + this.qt("WIDTH", iWidth) + ">";
                        }
                        bout.close();
                        if (j != segments.size() - 1 || i >= this.lines.size() - 1) continue;
                        dhtmlText = dhtmlText + "<BR>";
                        continue;
                    }
                    FontMetrics fontMetrics = (FontMetrics)seg[1];
                    String text = (String)seg[0];
                    text = QbUtil.replace(text, "\n", "<BR>");
                    text = QbUtil.replace(text, "  ", " &nbsp;");
                    String newtext = "";
                    for (int k = 0; k < text.length(); ++k) {
                        char ch = text.charAt(k);
                        newtext = ch > '\u00ff' ? newtext + "&#" + ch + ";" : newtext + ch;
                    }
                    text = newtext;
                    Font font = fontMetrics.getFont();
                    dhtmlText = dhtmlText + "<font STYLE=\"";
                    dhtmlText = dhtmlText + "color:" + DHTMLRTFObject.colorToHTML((Color)seg[2]) + "; ";
                    String fontname = font.getName();
                    if (fontname.equals("Dialog") || fontname.equals("SansSerif")) {
                        fontname = "Arial";
                    } else if (fontname.equals("Monospaced")) {
                        fontname = "Courier New";
                    }
                    dhtmlText = dhtmlText + "font-family:" + fontname + "; ";
                    dhtmlText = dhtmlText + "font-size:" + QbUtil.resizeExportFont(font.getSize(), this.report.isAdjustFont()) + "pt; ";
                    dhtmlText = dhtmlText + "font-weight:";
                    dhtmlText = font.isBold() ? dhtmlText + "bold; " : dhtmlText + "normal; ";
                    dhtmlText = dhtmlText + "font-style:";
                    dhtmlText = font.isItalic() ? dhtmlText + "italic; " : dhtmlText + "normal; ";
                    dhtmlText = dhtmlText + "line-height:1.2; ";
                    if (((Boolean)seg[3]).booleanValue()) {
                        dhtmlText = dhtmlText + "text-decoration:underline; ";
                    }
                    dhtmlText = dhtmlText + "\">" + text;
                    if (j == segments.size() - 1 && i < this.lines.size() - 1) {
                        dhtmlText = dhtmlText + "<BR>";
                    }
                    dhtmlText = dhtmlText + "</font>";
                }
            }
            this.writeRichText(dhtmlText, textHeight);
            this.elementYPos += QbUtil.toInch_export(textHeight);
            if (this.bottomY > this.elementYPos) {
                this.elementYPos = this.bottomY;
            }
            this.drawBottom = true;
            this.drawBorder();
            if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
                this.elementYPos += QbUtil.toInch_export(this.rtfObject.getBorderThickness() - 1);
            }
            this.writeMultiPageSectionColor();
        }
        catch (Exception ex) {
            if (!"Subreport page break.".equals(ex.getMessage())) {
                LOGGER.log(Level.WARNING, "Failed to run DHTML RTF object", ex);
            } else {
                LOGGER.log(Level.FINEST, "Subreport page break", ex);
            }
        }
        catch (Error err) {
            LOGGER.log(Level.WARNING, "Failed to run DHTML RTF object", err);
        }
        finally {
            Object LOCK;
            this.finish = true;
            Object object = LOCK = this.getLOCK();
            synchronized (object) {
                LOCK.notify();
            }
        }
    }

    private void writeRichText(String dhtmlText, int textHeight) throws Exception {
        this.started = true;
        int x = QbUtil.toPixel_export(this.getX(null));
        int y = QbUtil.toPixel_export(this.getY(null));
        int width = QbUtil.toPixel_export(this.maxWidthOfSections);
        int height = textHeight;
        if (this.checkVisibility) {
            height = QbUtil.toPixel_export(this.rtfObject.getHeight());
        }
        StringBuffer dhtml = new StringBuffer();
        x += QbUtil.toPixel_export(this.rtfObject.getColumnWidth() + this.rtfObject.getColumnSpacing()) * this.currentColumnCount;
        dhtml.append("<DIV ID=\"DivName");
        dhtml.append(this.divnameCount);
        dhtml.append("\" STYLE=\"position:absolute; ");
        dhtml.append("left:" + x + "px; ");
        dhtml.append("top:" + y + "px; ");
        dhtml.append("width:" + width + "px; height:").append(height).append("px; ");
        dhtml.append("margin:0px 0px 0px 0px; padding:0px 0px 0xp 0px; ");
        dhtml.append("z-index:" + (this.rtfObject.getZ() + this.parent.zIndexOffset + 2) + "; ");
        dhtml.append("text-align: " + ALIGN[this.rtfObject.getAlign()]);
        dhtml.append("\">");
        dhtml.append(dhtmlText);
        dhtml.append("</DIV>\n");
        ++this.divnameCount;
        this.out.write(dhtml.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pageBreak(ReportSection section) throws Exception {
        if (this.elementYPos <= this.pageHeaderHeight) {
            return;
        }
        if (this.currentColumnCount < this.rtfObject.getActualColumnCount() - 1) {
            if (this.elementYPos > this.bottomY) {
                this.bottomY = this.elementYPos;
            }
            this.elementYPos = this.pageTopY;
            ++this.currentColumnCount;
            return;
        }
        if (this.bottomY > this.elementYPos) {
            this.elementYPos = this.bottomY;
        }
        this.drawBorder();
        if (this.checkVisibility) {
            throw new Exception("Subreport page break.");
        }
        if (this.report.isExportToMultiPages()) {
            Object LOCK;
            this.writeMultiPageSectionColor();
            ++this.currentPageNumber;
            Object object = LOCK = this.getLOCK();
            synchronized (object) {
                LOCK.notify();
                try {
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.currentColumnCount = 0;
            this.pageTopY = this.elementYPos;
            this.elementXPos = 0.0;
            this.bottomY = 0.0;
        }
    }

    private int getTotalTextHeight() {
        int textHeight = 0;
        for (int i = 0; i < this.lines.size(); ++i) {
            Vector segments = (Vector)this.lines.elementAt(i);
            int ascent = 0;
            int descent = 0;
            for (int j = 0; j < segments.size(); ++j) {
                Object[] seg = (Object[])segments.elementAt(j);
                if (seg[0] != null && seg[0] instanceof Image) {
                    int iHeight = (Integer)seg[2];
                    if (iHeight <= ascent) continue;
                    ascent = iHeight;
                    continue;
                }
                FontMetrics fontMetrics = QbUtil.getViewerFontMetrics((FontMetrics)seg[1], this.report.isAdjustFont());
                if (fontMetrics.getMaxAscent() <= ascent) continue;
                ascent = fontMetrics.getMaxAscent();
                descent = fontMetrics.getMaxDescent();
            }
            textHeight = textHeight + ascent + descent;
        }
        return textHeight;
    }

    private void drawBorder() throws Exception {
        if (!this.started) {
            return;
        }
        int x = QbUtil.toPixel_export(this.getX(null));
        int y = QbUtil.toPixel_export(this.getY(null) - (this.elementYPos - this.pageTopY));
        int width = QbUtil.toPixel_export(this.maxWidthOfSections);
        int height = QbUtil.toPixel_export(this.elementYPos - this.pageTopY);
        if (this.checkVisibility) {
            height = QbUtil.toPixel_export(this.rtfObject.getHeight());
        }
        if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
            x -= this.rtfObject.getBorderThickness();
            y -= this.rtfObject.getBorderThickness();
            width = width + this.rtfObject.getBorderThickness() * 2 - 1;
            height = height + this.rtfObject.getBorderThickness() * 2 - 1;
        }
        if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null || this.rtfObject.getBgColor() != null) {
            StringBuffer dhtml = new StringBuffer();
            dhtml.append("<DIV ID=\"DivName");
            dhtml.append(this.divnameCount);
            dhtml.append("\" STYLE=\"position:absolute; ");
            dhtml.append("left:" + x + "px; ");
            dhtml.append("top:" + y + "px; ");
            dhtml.append("width:" + width + "px; height:").append(height).append("px; ");
            dhtml.append("margin:0px 0px 0px 0px; padding:0px 0px 0xp 0px; ");
            if (this.rtfObject.getBgColor() != null) {
                dhtml.append("background-color:").append(DHTMLRTFObject.colorToHTML(this.rtfObject.getBgColor())).append("; ");
            }
            if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
                dhtml.append("border-style:solid; ");
                dhtml.append("border-width:");
                dhtml.append(this.drawTop || this.rtfObject.isBorderClosed() ? this.rtfObject.getBorderThickness() : 0).append("px ");
                dhtml.append(this.rtfObject.getBorderThickness()).append("px ");
                dhtml.append(this.drawBottom || this.rtfObject.isBorderClosed() || this.checkVisibility ? this.rtfObject.getBorderThickness() : 0).append("px ");
                dhtml.append(this.rtfObject.getBorderThickness()).append("px; ");
                dhtml.append("border-color:").append(DHTMLRTFObject.colorToHTML(this.rtfObject.getBorderColor())).append("; ");
            }
            dhtml.append("z-index:" + (this.rtfObject.getZ() + this.parent.zIndexOffset + 1));
            dhtml.append("\">");
            dhtml.append("</DIV>\n");
            ++this.divnameCount;
            this.out.write(dhtml.toString());
        }
        if (this.drawTop) {
            this.drawTop = false;
        }
    }
}

