/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.ColorTable;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.ExportBarcode;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.HttpsIO;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.Bookmark;
import quadbase.reportdesigner.ReportElements.ColumnBreakColumn;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.FormattedRow;
import quadbase.reportdesigner.ReportElements.FormattedRowKey;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportDocument;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.report.ChartObject;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DHTMLRTFObject;
import quadbase.reportdesigner.report.DHTMLReportColumnar;
import quadbase.reportdesigner.report.DHTMLReportCrossTab;
import quadbase.reportdesigner.report.DHTMLReportMasterDetails;
import quadbase.reportdesigner.report.DHTMLReportSummary;
import quadbase.reportdesigner.report.DHTMLReportWithSlider;
import quadbase.reportdesigner.report.DHTMLSubReport;
import quadbase.reportdesigner.report.DHTMLTOCObject;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.FinishedSpecificPageException;
import quadbase.reportdesigner.report.ISubReportExport;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportGraphics;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.report.SaveReport;
import quadbase.reportdesigner.report.WriteDataFile;
import quadbase.reportdesigner.util.BarcodeFormat;
import quadbase.reportdesigner.util.CSSStyle;
import quadbase.reportdesigner.util.HTMLBlock;
import quadbase.reportdesigner.util.internal.BarcodeUtil;

public class DHTMLReport {
    private static final Logger LOGGER = Logger.getLogger(DHTMLReport.class.getName());
    public static final int SINGLE_BORDER_THICKNESS_MODIFIER = 1;
    public static final int DOUBLE_BORDER_THICKNESS_MODIFIER = 3;
    public static final String BORDER_STYLE_DOUBLE = "double";
    protected static final String[] ALIGN = new String[]{"center", "left", "right"};
    protected static final String[] VALIGN = new String[]{"middle", "top", "bottom", "baseline"};
    protected int imageCount = 0;
    protected String imageName = null;
    protected int divnameCount = 0;
    protected int barcodeCount = 0;
    protected double leftMargin;
    protected double rightMargin;
    protected double topMargin;
    protected double bottomMargin;
    protected static double browserMargin = 0.4;
    protected double linksHeight = 0.0;
    protected double pageHeight = 0.0;
    protected double pageHeaderHeight = 0.0;
    protected double maxWidthOfSections = 0.0;
    protected double formsHeight = QbUtil.toInch_export(200.0);
    protected double elementXPos = 0.0;
    protected double elementYPos = 0.0;
    protected int maxYPos = 0;
    protected Report report;
    protected int fontFraction = 4;
    protected String lastFileName = null;
    protected String prefix = null;
    protected String originalFileName = null;
    private Vector<ReportSection> sectionList = null;
    private Vector<ReportTable> tableList = null;
    protected int currentPageNumber = 1;
    protected int totalPageNumber = 1;
    protected int totalSections = 1;
    protected ReportTable hTable = null;
    protected ReportTable fTable = null;
    protected Writer out;
    protected static final String evalText = "Evaluation copy by Quadbase Systems Inc.";
    protected static final String contactText = "Please contact sales@quadbase.com for purchasing information.";
    protected boolean checkVisibility = false;
    protected int columnWrapCount = 0;
    protected int columnWrapInitialRow = 0;
    protected int columnWrapDisplayRow = 0;
    protected int lastDrawCol = 0;
    protected double columnWrapWidth = 0.0;
    protected boolean doColumnWrap = false;
    double[] wrapInfo;
    double curMaxY;
    int rowCount;
    int totalRowCount;
    protected ReportUI reportUI = null;
    protected ReportGraphics reportGraphics = null;
    protected boolean checkTotalPageNumber = false;
    protected ExportThread exportThread = null;
    protected Vector<Integer> treeStructure = null;
    protected Vector<ReportElement> rowElements = null;
    protected Hashtable<FormattedRowKey, FormattedRow> rows = null;
    protected int pagebreaks = 0;
    protected boolean checkFitGroupOnPage = false;
    protected boolean resetPageNumber = false;
    protected int currentPage = 1;
    protected Hashtable<String, Integer> sectionTotalPagesTable = null;
    protected String treeCopy = "";
    protected boolean populateTable = true;
    protected int savedStartPage = 1;
    protected Vector<Integer> sectionTotalPages = null;
    protected Vector<Integer> sectionStartPage = null;
    protected Hashtable<Integer, int[]> pageLookup = null;
    private Graphics offScreenGraphics = null;
    Hashtable<Font, FontMetrics> fontMetricsTable = new Hashtable(10);
    Object[] previousRowValue;
    boolean[] previousRowIsBGColor2;
    boolean calculated = false;
    boolean exportSpecificPage = false;
    int exportPage;
    OutputStream outStream;
    long exportTime = 0L;
    boolean ddBytesSentToServlet = false;
    Hashtable<CSSStyle, String> styleTable = null;
    int styleCount = 0;
    boolean useExternalStyleSheet = false;
    boolean isWriteRepeatSection = false;
    boolean forcePageBreak = false;
    boolean drawBeforeExport = false;
    boolean isTableFormatted = false;
    boolean titleAdjusted = false;
    double tableDataCellHeight = 0.3;
    boolean printOnNewPageForToc = false;
    boolean skipFirstValueForToc = false;
    Vector<Object> lockObjects = null;
    int pageBreakRowCount = 0;
    boolean skipFormatTable = false;
    protected int zIndexOffset = 0;
    protected boolean isSliderFeature = true;
    private int tblDivCount = 0;
    private static final int iconWidth = 15;
    private boolean expandAll = false;
    private int expandToGroupLevel = -1;
    protected int reportIndex = 0;
    protected String rptName = "MAIN";
    private static final String SLIDER_PREFIX = "SLIDER_";
    protected String ieStyleString = "";
    private boolean useVML = false;

    public DHTMLReport(Report report) {
        this.report = report;
        this.drawBeforeExport = report.drawBeforeDisplay;
        if (report.getExpandAndCollapseScriptName() != null) {
            this.rptName = report.getExpandAndCollapseScriptName();
        }
        this.maxWidthOfSections = report.getMaxWidthOfSections();
        this.init();
    }

    public DHTMLReport(Report report, boolean skipFormatTable) {
        this(report);
        this.skipFormatTable = skipFormatTable;
    }

    private void init() {
        int maxLevelCount;
        this.imageCount = 0;
        this.divnameCount = 0;
        this.barcodeCount = 0;
        this.tblDivCount = 0;
        ReportTable tbl = this.report.getReportTables().elementAt(0);
        this.leftMargin = this.report.getLeftMargin();
        boolean bl = this.isSliderFeature = this.report.isExpandAndCollapseEnabled() && this.report.isExpandAndCollapseSupported();
        if (this.isSliderFeature && (maxLevelCount = this.getLevelCount(tbl)) * 15 > QbUtil.toPixel_export(this.leftMargin)) {
            this.leftMargin = QbUtil.toInch_export(maxLevelCount * 15 + 3);
        }
        this.rightMargin = this.report.getRightMargin();
        this.topMargin = this.report.getTopMargin();
        this.bottomMargin = this.report.getBottomMargin();
        this.linksHeight = 0.0;
        this.elementXPos = 0.0;
        this.elementYPos = 0.0;
        this.maxYPos = 0;
        this.currentPageNumber = 1;
        this.treeCopy = "";
        this.currentPage = 1;
        this.totalSections = 1;
        this.savedStartPage = 1;
        this.treeStructure = new Vector();
        this.useExternalStyleSheet = this.report.getExternalStyleSheetName() != null;
        this.isWriteRepeatSection = false;
        this.report.exportedFiles = new Vector();
        DHTMLReport.setBrowserMargin(this.report.isExportToSingleWPagination() ? browserMargin : 0.0);
        this.getOffScreenGraphics();
        this.pageBreakRowCount = 0;
    }

    public boolean exportDHTML(OutputStream outstream, String filename) throws Exception {
        try {
            this.expandAll = this.report.isDefaultToExpandAll();
            this.expandToGroupLevel = this.report.getExpandGroupLevelTo();
            if (this.styleTable == null) {
                this.getStyleTable(this.report);
            }
            long totalTime = System.currentTimeMillis();
            if (filename == null) {
                this.imageName = "TEMPIMG_";
                if (this.report.isExportToMultiPages()) {
                    throw new Exception("In order to export to multiple pages, you have to specify the file name");
                }
            } else {
                this.prefix = Report.getPrefixFileName(filename);
                this.originalFileName = Report.getFullName(filename, this.getExtension());
                this.lastFileName = Report.getFullName(this.prefix + "_LAST", this.getExtension());
                this.imageName = new FileInfo(this.originalFileName).getAbsolutePath();
                int i = this.imageName.lastIndexOf(46);
                if (i >= 0) {
                    this.imageName = this.imageName.substring(0, i);
                }
                this.imageName = this.imageName + "_";
            }
            long newReportUI = System.currentTimeMillis();
            this.reportUI = new ReportUI(this.report, this.getOffScreenGraphics(), false);
            boolean formatted = this.reportUI.preCalcTotalSections();
            if (formatted) {
                this.isTableFormatted = true;
            }
            this.totalSections = this.reportUI.getTotalSections();
            this.maxWidthOfSections *= (double)this.totalSections;
            this.reportGraphics = this.reportUI.getReportGraphics();
            LOGGER.finest("New report UI: " + (double)(System.currentTimeMillis() - newReportUI) / 1000.0);
            this.pageHeight = this.report.getPageHeight() - this.topMargin - this.bottomMargin - DHTMLReport.getBrowserMargin() - (this.hasNoData(this.report.getPageFooter()) ? 0.0 : this.resizeSection(this.reportGraphics, this.report.getPageFooter(), this.report.getReportTables().elementAt(this.report.getReportTables().size() - 1)).getHeight());
            if (this.report.isExportToSingleWPagination()) {
                this.out = new StringWriter();
                this.checkTotalPageNumber = true;
                this.exportDHTML();
                this.totalPageNumber = this.currentPageNumber;
                this.populatePageLookupTable();
                if (this.report.isTocEnabled()) {
                    this.init();
                    this.out = new StringWriter();
                    this.exportDHTML();
                }
                this.init();
                this.checkTotalPageNumber = false;
                this.populateTable = false;
                this.out = this.report.getExportEncoding() != null ? new PrintWriter((Writer)new OutputStreamWriter(outstream, this.report.getExportEncoding()), true) : new PrintWriter(outstream, true);
                return this.exportDHTML();
            }
            if (!this.report.isExportToMultiPages() || filename == null) {
                this.drawBeforeExport = false;
                this.checkTotalPageNumber = false;
                if (this.report.isTocEnabled() && !this.report.getTableOfContentsObject().isUseGroups()) {
                    this.out = new StringWriter();
                    this.exportDHTML();
                    this.init();
                }
                this.out = this.report.getExportEncoding() != null ? new PrintWriter((Writer)new OutputStreamWriter(outstream, this.report.getExportEncoding()), true) : new PrintWriter(outstream, true);
                return this.exportDHTML();
            }
            long checkTotalPages = System.currentTimeMillis();
            this.out = new StringWriter();
            this.checkTotalPageNumber = true;
            this.exportDHTML();
            if (this.report.isTocEnabled()) {
                this.init();
                this.out = new StringWriter();
                this.exportDHTML();
            }
            this.totalPageNumber = this.currentPageNumber;
            this.populatePageLookupTable();
            LOGGER.finest("Cal total pages: " + (double)(System.currentTimeMillis() - checkTotalPages) / 1000.0);
            LOGGER.finest("Total page number: " + this.totalPageNumber);
            this.init();
            this.checkTotalPageNumber = false;
            this.populateTable = false;
            this.out = new StringWriter();
            boolean b = this.exportDHTML();
            LOGGER.finest("Total time: " + (double)(System.currentTimeMillis() - totalTime) / 1000.0);
            return b;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to export to DHTML", ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportDHTML(OutputStream outstream, String filename, int exportPage) throws Exception {
        this.isSliderFeature = false;
        this.leftMargin = this.report.getLeftMargin();
        if (this.styleTable == null) {
            this.getStyleTable(this.report);
        }
        if (filename == null) {
            this.imageName = "TEMPIMG_";
        } else {
            this.prefix = Report.getPrefixFileName(filename);
            this.originalFileName = Report.getFullName(filename, this.getExtension());
            this.lastFileName = Report.getFullName(this.prefix + "_LAST", this.getExtension());
            this.imageName = new FileInfo(this.originalFileName).getAbsolutePath();
            int i = this.imageName.lastIndexOf(46);
            if (i >= 0) {
                this.imageName = this.imageName.substring(0, i);
            }
            this.imageName = this.imageName + "_";
        }
        this.reportUI = new ReportUI(this.report, this.getOffScreenGraphics(), false);
        this.reportGraphics = this.reportUI.getReportGraphics();
        this.pageHeight = this.report.getPageHeight() - this.topMargin - this.bottomMargin - DHTMLReport.getBrowserMargin() - (this.hasNoData(this.report.getPageFooter()) ? 0.0 : this.resizeSection(this.reportGraphics, this.report.getPageFooter(), this.report.getReportTables().elementAt(this.report.getReportTables().size() - 1)).getHeight());
        this.out = new StringWriter();
        this.checkTotalPageNumber = true;
        this.lockObjects = new Vector();
        this.exportDHTML();
        this.totalPageNumber = this.currentPageNumber;
        this.populatePageLookupTable();
        this.init();
        this.checkTotalPageNumber = false;
        this.populateTable = false;
        this.exportSpecificPage = true;
        this.exportPage = exportPage < 1 ? this.totalPageNumber : (exportPage > this.totalPageNumber ? this.totalPageNumber : exportPage);
        this.outStream = outstream;
        this.out = this.exportPage == 1 ? (this.report.getExportEncoding() != null ? new PrintWriter((Writer)new OutputStreamWriter(outstream, this.report.getExportEncoding()), true) : new PrintWriter(outstream, true)) : new StringWriter();
        try {
            return this.exportDHTML();
        }
        catch (FinishedSpecificPageException e) {
            LOGGER.log(Level.FINEST, "DHTMLReport - Finished Specific Page Export", e);
            if (this.lockObjects != null) {
                for (int i = 0; i < this.lockObjects.size(); ++i) {
                    Object obj = this.lockObjects.elementAt(i);
                    if (obj != null) {
                        Object object = obj;
                        synchronized (object) {
                            obj.notifyAll();
                        }
                    }
                    LOGGER.finest("UNLOCK OBJECT[" + i + "]");
                }
            }
            return true;
        }
    }

    protected void populatePageLookupTable() {
        if (this.sectionTotalPages == null || this.sectionStartPage == null || this.sectionTotalPages.size() != this.sectionStartPage.size() || this.sectionTotalPages.size() == 0) {
            return;
        }
        int count = this.sectionTotalPages.size();
        int lastSectionTotalPages = this.sectionTotalPages.elementAt(count - 1);
        int lastSectionStartPage = this.sectionStartPage.elementAt(count - 1);
        for (int i = count - 2; i >= 0; --i) {
            int nextSectionStartPage = this.sectionStartPage.elementAt(i);
            if (nextSectionStartPage == lastSectionStartPage) {
                this.sectionTotalPages.setElementAt(lastSectionTotalPages, i);
            }
            lastSectionTotalPages = this.sectionTotalPages.elementAt(i);
            lastSectionStartPage = this.sectionStartPage.elementAt(i);
        }
        this.pageLookup = new Hashtable();
        int nextStartPage = this.sectionStartPage.elementAt(0);
        int nextTotalPages = this.sectionTotalPages.elementAt(0);
        for (int i = 1; i <= this.totalPageNumber; ++i) {
            if (i < nextStartPage) {
                this.pageLookup.put(i, new int[]{i, i});
                continue;
            }
            if (i != nextStartPage) continue;
            nextTotalPages = this.sectionTotalPages.remove(0);
            nextStartPage = this.sectionStartPage.remove(0);
            boolean flag = false;
            int j = 1;
            while (j <= nextTotalPages) {
                this.pageLookup.put(i, new int[]{j++, nextTotalPages});
                flag = true;
                ++i;
            }
            if (this.sectionTotalPages.size() > 0) {
                nextTotalPages = this.sectionTotalPages.elementAt(0);
                nextStartPage = this.sectionStartPage.elementAt(0);
            }
            if (!flag) continue;
            --i;
        }
    }

    protected boolean exportDHTML() throws Exception {
        this.exportThread = new ExportThread();
        try {
            this.exportThread.start();
            this.exportTime = System.currentTimeMillis();
            boolean ret = this.exportDHTMLHelper();
            this.exportThread.finish();
            this.exportThread.join();
            this.calculated = true;
            int tmpH = QbUtil.toPixel_export(this.topMargin) + QbUtil.toPixel_export(this.elementYPos);
            if (tmpH > this.maxYPos) {
                this.maxYPos = tmpH;
            }
            this.report.setTotalHInPixelForDHTML(this.maxYPos);
            this.setColumnWrap();
            if (this.columnWrapCount > 0) {
                this.report.setTotalWInPixelForDHTML(QbUtil.toPixel_export(this.leftMargin) + (this.columnWrapCount + 1) * QbUtil.toPixel_export(this.report.getMinWidth()));
            } else {
                this.report.setTotalWInPixelForDHTML(QbUtil.toPixel_export(this.leftMargin) + QbUtil.toPixel_export(this.report.getMinWidth()));
            }
            return ret;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "DHTML export failed", ex);
            this.exportThread.kill();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exportDHTMLHelper() throws Exception {
        Vector<ReportTable> vec;
        ReportTable table = null;
        if (this.checkTotalPageNumber || !this.drawBeforeExport) {
            this.formatTable();
        }
        if ((vec = this.report.getReportTables()).size() <= 0) {
            throw new Exception("The report does not contain any table. Please check and try again later.");
        }
        table = vec.elementAt(0);
        this.hTable = vec.elementAt(0);
        this.fTable = vec.elementAt(vec.size() - 1);
        if (this.report.isDynamicExport() && !this.ddBytesSentToServlet) {
            if (this.report.getDynamicReportKeyGenerator() != null) {
                this.ddBytesSentToServlet = true;
            } else {
                this.drilldownDynamicExport(this.report);
            }
        }
        this.writeHeadTag();
        this.writeWaterMark(evalText, true);
        if (this.report.isExportToMultiPages()) {
            this.writeLinks(true);
        }
        this.writeReportContainerDiv(true);
        if (this.writeForm()) {
            this.elementYPos += this.formsHeight;
        }
        if (this.isSliderFeature) {
            this.out.write("<div id=\"EMPTY_SPACE\" style=\"position:relative; height:" + QbUtil.toPixel_export(this.topMargin) + "px\">" + this.writeCloseDivTag());
            if (this.report.getDHTMLTopMargin() > 0.0) {
                this.out.write("<div id=\"EMPTY_SPACE2\" style=\"position:relative; height:" + QbUtil.toPixel_export(this.report.getDHTMLTopMargin()) + "px\">" + this.writeCloseDivTag());
            }
        }
        if (this.report.getInitializeReportError() != null) {
            this.writeSection(ReportUI.createErrorSection(this.getPageWidth(), this.pageHeight, this.report.getInitializeReportError()), table);
        } else {
            this.startToGetData(table);
            this.pageHeaderHeight = this.writeSection(this.report.getPageHeader(), table);
            this.writeSection(this.report.getReportHeader(), table);
            for (int i = 0; i < vec.size(); ++i) {
                table = vec.elementAt(i);
                this.initRepeatSection();
                this.setColumnWrap();
                this.wrapInfo = new double[]{0.0, this.elementYPos, this.elementYPos};
                if (this.doColumnWrap) {
                    this.totalRowCount = table.getRowCount();
                }
                this.rowCount = 0;
                this.writeReportTable(table);
                if (this.doColumnWrap && this.elementYPos < this.curMaxY) {
                    this.elementYPos = this.curMaxY;
                }
                this.resetColumnWrap();
            }
            if (this instanceof DHTMLReportSummary) {
                this.writeSection(this.report.getReportFooter(), this.fTable, ((DHTMLReportSummary)this).footerAggCol, ((DHTMLReportSummary)this).footerResCol);
            } else if (this instanceof DHTMLReportColumnar) {
                this.writeSection(this.report.getReportFooter(), this.fTable, ((DHTMLReportColumnar)this).footerAggCol, ((DHTMLReportColumnar)this).footerResCol);
            } else if (this instanceof DHTMLReportCrossTab) {
                this.writeSection(this.report.getReportFooter(), this.fTable, ((DHTMLReportCrossTab)this).footerAggCol, ((DHTMLReportCrossTab)this).footerResCol);
            } else if (this instanceof DHTMLReportMasterDetails) {
                this.writeSection(this.report.getReportFooter(), this.fTable, ((DHTMLReportMasterDetails)this).footerAggCol, ((DHTMLReportMasterDetails)this).footerResCol);
            } else {
                this.writeSection(this.report.getReportFooter(), this.fTable);
            }
            if (this.report.isExportToMultiPages()) {
                this.elementYPos = this.pageHeight;
            }
            if (this.report.isExportToSingleWPagination()) {
                this.elementYPos = (this.report.getPageHeight() - DHTMLReport.getBrowserMargin()) * (double)(this.currentPageNumber - 1) + this.pageHeight;
            }
            this.writeSection(this.report.getPageFooter(), this.fTable, false);
        }
        this.writeWaterMark(contactText, false);
        this.writeReportContainerDiv(false);
        if (this.report.isExportToMultiPages()) {
            this.writeLinks(false);
        }
        if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage) {
            if (this.originalFileName == null || !this.report.isExportToMultiPages()) {
                this.writeTailTag();
                this.out.flush();
                this.out.close();
            } else {
                block51: {
                    this.writeTailTag();
                    String content = this.out.toString();
                    try {
                        if (this.totalPageNumber > 1) {
                            LOGGER.finest("Export " + this.lastFileName + ": " + (double)(System.currentTimeMillis() - this.exportTime) / 1000.0);
                            if (this.report.getExportEncoding() != null) {
                                byte[] pageData = content.getBytes(this.report.getExportEncoding());
                                if (this.exportThread.isQueueFull(pageData.length)) {
                                    Object tmpLock = this.exportThread.getLockForMainThread();
                                    if (this.lockObjects != null) {
                                        this.lockObjects.add(tmpLock);
                                    }
                                    Object object = tmpLock;
                                    synchronized (object) {
                                        try {
                                            tmpLock.wait();
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                    if (this.lockObjects != null) {
                                        this.lockObjects.remove(tmpLock);
                                    }
                                }
                                this.exportThread.queue(pageData, this.lastFileName);
                            } else {
                                byte[] pageData = content.getBytes();
                                if (this.exportThread.isQueueFull(pageData.length)) {
                                    Object tmpLock = this.exportThread.getLockForMainThread();
                                    if (this.lockObjects != null) {
                                        this.lockObjects.add(tmpLock);
                                    }
                                    Object object = tmpLock;
                                    synchronized (object) {
                                        try {
                                            tmpLock.wait();
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                    if (this.lockObjects != null) {
                                        this.lockObjects.remove(tmpLock);
                                    }
                                }
                                this.exportThread.queue(pageData, this.lastFileName);
                            }
                            this.exportTime = System.currentTimeMillis();
                            break block51;
                        }
                        LOGGER.finest("Export " + Report.getFullName(this.prefix + "_FIRST", this.getExtension()) + ": " + (double)(System.currentTimeMillis() - this.exportTime) / 1000.0);
                        String fname = Report.getFullName(this.prefix + "_FIRST", this.getExtension());
                        if (this.report.getExportEncoding() != null) {
                            new WriteDataFile().output(null, content.getBytes(this.report.getExportEncoding()), fname, this.report.isDHTMLViewerUsed());
                        } else {
                            new WriteDataFile().output(null, content.getBytes(), fname, this.report.isDHTMLViewerUsed());
                        }
                        this.exportTime = System.currentTimeMillis();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "An error occurred while running DHTML export", ex);
                        this.out.close();
                        throw ex;
                    }
                }
                this.out.flush();
                this.out.close();
            }
        }
        return true;
    }

    protected void initRepeatSection() {
        this.sectionList = new Vector();
        this.tableList = new Vector();
    }

    void setColumnWrap() {
        if (this.report.getReportType() != 0 && this.report.getReportType() != 4 && this.report.getReportType() != 1 || this.report.getColumnWrap() == null) {
            this.resetColumnWrap();
            return;
        }
        this.doColumnWrap = true;
        double pageWidth = this.getPageWidth();
        Report temp_report = this.report;
        this.columnWrapWidth = temp_report.getColumnWrap().getX();
        this.columnWrapCount = temp_report.getColumnWrap().getWrapCount();
        int maxWrapCount = (int)Math.floor(pageWidth / temp_report.getColumnWrap().getX()) - 1;
        if (this.columnWrapCount < 0 || this.columnWrapCount > maxWrapCount) {
            this.columnWrapCount = maxWrapCount;
        }
        if (this.columnWrapCount < 0) {
            this.columnWrapCount = 0;
        }
    }

    protected double getPageWidth() {
        return this.report.getActualPageWidth();
    }

    void resetColumnWrap() {
        this.columnWrapWidth = 0.0;
        this.columnWrapCount = 0;
        this.doColumnWrap = false;
        this.resetColumnWrapTableUI();
    }

    void resetColumnWrapTableUI() {
        this.columnWrapInitialRow = 0;
        this.columnWrapDisplayRow = 0;
    }

    void formatTable() throws Exception {
        if (!this.isTableFormatted) {
            if (!this.skipFormatTable) {
                this.report.formatTable();
            }
            this.isTableFormatted = true;
        }
    }

    protected ReportSection resizeSection(ReportGraphics g, ReportSection _sec, ReportTable tbl) throws Exception {
        int i;
        Report temp_report = this.report;
        boolean shift = false;
        ReportSection sec = new ReportSection();
        boolean resize = false;
        boolean copied = false;
        if (this.treeStructure != null) {
            if (_sec.hasFormattedCell(this.treeStructure)) {
                if (!copied) {
                    sec.deepCopy(_sec);
                }
                copied = true;
                Hashtable<Integer, ReportCell> cellTable = sec.getFormattedCells(this.treeStructure);
                ReportCell[] cell = sec.getCells();
                for (int i2 = 0; i2 < cell.length; ++i2) {
                    ReportCell formattedCell;
                    if (!cellTable.containsKey(i2)) continue;
                    cell[i2] = formattedCell = cellTable.get(i2);
                }
                resize = true;
                shift = true;
            }
            if (_sec.hasSectionCells(this.treeStructure)) {
                Vector<ReportCell> sectionCells = _sec.getSectionCells(this.treeStructure);
                if (!copied) {
                    sec.deepCopy(_sec);
                }
                copied = true;
                if (sectionCells != null) {
                    for (int i3 = 0; i3 < sectionCells.size(); ++i3) {
                        sec.addData(sectionCells.elementAt(i3));
                    }
                }
                resize = true;
                shift = true;
            }
            if (_sec.getHeight(this.treeStructure) > 0.0) {
                if (!copied) {
                    sec.deepCopy(_sec);
                }
                copied = true;
                sec.setHeight(_sec.getHeight(this.treeStructure));
                resize = true;
                shift = true;
            }
        }
        for (i = 0; i < _sec.getCellCount() && !resize; ++i) {
            if (!_sec.getData(i).isVisible() || !_sec.getData(i).isResizeToFitContent()) continue;
            if (!copied) {
                sec.deepCopy(_sec);
            }
            copied = true;
            resize = true;
        }
        if (resize) {
            for (i = 0; i < sec.getCellCount(); ++i) {
                ReportCell cell;
                ReportCell element = sec.getData(i);
                if (!element.isResizeToFitContent()) continue;
                if (element instanceof SubReportObject || element instanceof TableOfContents || element instanceof ReportRTFObject) {
                    shift = true;
                }
                if (!(cell = tbl.formatCell(element, this.getPage(), 1, this.getTotalPageNumber(), 1, temp_report)).isVisible()) continue;
                double h = g.getTextHeight(cell.getText(), cell.getRefFontToDraw(this.report.isAdjustFont()), cell.getWidth(), cell.getAlign(), cell.isNoWrap());
                if (cell instanceof ReportRTFObject || cell instanceof TableOfContents || cell instanceof SubReportObject) {
                    h = cell.getHeight();
                }
                if ((cell instanceof ReportRTFObject || cell instanceof TableOfContents || cell instanceof SubReportObject) && _sec.getBgColor() != null) {
                    ReportGraphics temp_rg = this.reportUI.getReportGraphics();
                    double[] res = temp_rg.drawCell(this.report, tbl, null, cell, sec, 0.0, 0.0, 0);
                    h = res[0];
                }
                if (!(h > cell.getHeight())) continue;
                shift = true;
                ReportSection.resizeVerticallyAndShift((ReportElement)element, sec, h - cell.getHeight());
            }
        }
        if (shift) {
            double minH = sec.getMinHeight();
            if (sec.getHeight() < minH) {
                if (sec.isResizeToFitContent()) {
                    double increase = ReportUI.getMaxIncreaseProportion(_sec, sec);
                    for (int i4 = 0; i4 < sec.getCellCount(); ++i4) {
                        if (sec.getData(i4) instanceof ReportLine && ((ReportLine)sec.getData(i4)).isVertical() && ((ReportLine)sec.getData(i4)).next() != null) {
                            sec.getData(i4).setHeight(sec.getMinHeight() - sec.getData(i4).getY());
                            continue;
                        }
                        if (sec.getData(i4) == null && !(sec.getData(i4) instanceof ReportGrid) && !(sec.getData(i4) instanceof ReportLine)) continue;
                        double h1 = _sec.getData(i4).getHeight() * increase;
                        double h2 = sec.getData(i4).getHeight();
                        sec.getData(i4).setHeight(h1 > h2 ? h1 : h2);
                    }
                    minH = sec.getMinHeight();
                }
                sec.setHeight(minH);
            }
            return sec;
        }
        for (i = 0; i < _sec.getCellCount(); ++i) {
            if (!(_sec.getData(i) instanceof ReportLine) || ((ReportLine)_sec.getData(i)).next() == null || !((ReportLine)_sec.getData(i)).isVertical()) continue;
            _sec.getData(i).setHeight(_sec.getHeight() - _sec.getData(i).getY());
        }
        return _sec;
    }

    protected ReportTable resizeTable(ReportGraphics g, ReportTable _tbl, int rowIndex) throws Exception {
        int i;
        boolean resize;
        ReportTable tbl;
        boolean shift;
        Report temp_report;
        block20: {
            int i2;
            FormattedRow row;
            FormattedRowKey key;
            temp_report = this.report;
            shift = false;
            tbl = new ReportTable();
            resize = false;
            this.rowElements = null;
            double rowHeight = 0.0;
            if (this.rows != null && this.rows.containsKey(key = this.treeStructure == null || this.treeStructure.size() == 0 ? new FormattedRowKey(rowIndex, null) : new FormattedRowKey(rowIndex, this.getTreeLevel())) && (row = this.rows.get(key)) != null) {
                rowHeight = row.getRowHeight();
                this.rowElements = row.getRowElements();
                for (int j = 0; j < _tbl.getColumnCount(); ++j) {
                    tbl.addColumn(new ReportColumn());
                }
                tbl.deepCopy(_tbl);
                tbl.setHeight(rowHeight);
                resize = true;
                shift = true;
            }
            if (this.calculated || this.checkFitGroupOnPage) break block20;
            if (this.previousRowValue == null) {
                this.previousRowValue = new Object[_tbl.getColumnCount()];
                this.previousRowIsBGColor2 = new boolean[_tbl.getColumnCount()];
                for (i2 = 0; i2 < _tbl.getColumnCount(); ++i2) {
                    this.previousRowValue[i2] = _tbl.getColumn(i2).getData(rowIndex);
                    this.previousRowIsBGColor2[i2] = false;
                }
            } else {
                for (i2 = 0; i2 < _tbl.getColumnCount(); ++i2) {
                    int[] index = _tbl.getColumn(i2).getDualColorColInfoIndex();
                    if (index == null) continue;
                    boolean different = false;
                    for (int j = 0; j < index.length; ++j) {
                        if (this.previousRowValue[index[j]] == null && _tbl.getColumn(index[j]).getData(rowIndex) == null || (this.previousRowValue[index[j]] != null || _tbl.getColumn(index[j]).getData(rowIndex) == null) && (this.previousRowValue[index[j]].equals(_tbl.getColumn(index[j]).getData(rowIndex)) || "".equals(_tbl.getColumn(index[j]).getData(rowIndex)))) continue;
                        different = true;
                        break;
                    }
                    if (different) {
                        this.previousRowIsBGColor2[i2] = !this.previousRowIsBGColor2[i2];
                    }
                    _tbl.getColumn(i2).setIsBGColor2(rowIndex, this.previousRowIsBGColor2[i2]);
                }
            }
            for (i2 = 0; i2 < _tbl.getColumnCount(); ++i2) {
                this.previousRowValue[i2] = _tbl.getColumn(i2).getData(rowIndex);
            }
        }
        for (i = 0; i < _tbl.getColumnCount() && !resize; ++i) {
            if (!_tbl.getColumn(i).isVisible() || !_tbl.getColumn(i).isResizeToFitContent()) continue;
            tbl.positionCopy(_tbl);
            resize = true;
        }
        if (resize) {
            for (i = 0; i < tbl.getColumnCount(); ++i) {
                if (!tbl.getColumn(i).isResizeToFitContent()) continue;
                ReportCell cell = tbl.formatCell(tbl.getColumn(i), rowIndex, temp_report);
                double h = g.getTextHeight(cell.getText(), cell.getRefFontToDraw(this.report.isAdjustFont()), cell.getWidth(), cell.getAlign(), cell.isNoWrap());
                if (cell instanceof ReportRTFObject && _tbl.getBgColor() != null) {
                    ReportGraphics temp_rg = this.reportUI.getReportGraphics();
                    double[] res = temp_rg.drawCell(this.report, tbl, null, cell, tbl, 0.0, 0.0, 0);
                    h = res[0];
                }
                if (!(h > cell.getHeight()) || !cell.isVisible()) continue;
                shift = true;
                ReportTable.resizeVerticallyAndShift((ReportElement)tbl.getColumn(i), tbl, h - cell.getHeight());
            }
        }
        if (shift) {
            double minH = tbl.getMinHeight();
            if (tbl.getHeight() < minH) {
                double increase = (minH - tbl.getHeight()) / tbl.getHeight() + 1.0;
                if (tbl.isResizeToFitContent()) {
                    int i3;
                    for (i3 = 0; i3 < tbl.getColumnCount(); ++i3) {
                        double h1 = _tbl.getColumn(i3).getHeight() * increase;
                        double h2 = tbl.getColumn(i3).getHeight();
                        tbl.getColumn(i3).setHeight(h1 > h2 ? h1 : h2);
                    }
                    for (i3 = 0; i3 < tbl.getImageCount(); ++i3) {
                        ReportImage image = tbl.getImage(i3);
                        if (!(image instanceof ReportGrid) || !(((ReportGrid)image).getHeight() >= 0.0)) continue;
                        image.setHeight(image.getHeight() * increase);
                    }
                    minH = tbl.getMinHeight();
                }
                for (int i4 = 0; i4 < tbl.getImageCount(); ++i4) {
                    ReportImage image = tbl.getImage(i4);
                    if (!(image instanceof ReportLine) || !((ReportLine)image).isVertical() || ((ReportLine)image).next() == null) continue;
                    image.setHeight(image.getHeight() * increase + 0.01);
                }
                tbl.setHeight(minH);
            }
            return tbl;
        }
        for (i = 0; i < _tbl.getImageCount(); ++i) {
            if (!(_tbl.getImage(i) instanceof ReportLine) || ((ReportLine)_tbl.getImage(i)).next() == null || !((ReportLine)_tbl.getImage(i)).isVertical()) continue;
            _tbl.getImage(i).setHeight(_tbl.getHeight() - _tbl.getImage(i).getY());
        }
        return _tbl;
    }

    protected int[] getTreeLevel() {
        if (this.treeStructure != null && this.treeStructure.size() > 0) {
            int[] values = new int[this.treeStructure.size()];
            for (int i = 0; i < this.treeStructure.size(); ++i) {
                values[i] = this.treeStructure.elementAt(i);
            }
            return values;
        }
        return null;
    }

    protected String getTreeStringKey() {
        if (this.treeStructure != null && this.treeStructure.size() > 0) {
            String str = "Tree_";
            int size = this.treeStructure.size();
            for (int i = 0; i < size - 1; ++i) {
                str = str + this.treeStructure.elementAt(i) + "_";
            }
            str = str + this.treeStructure.elementAt(size - 1);
            return str;
        }
        return null;
    }

    protected int getCurrentSectionID() {
        if (this.treeStructure != null && this.treeStructure.size() > 0) {
            int lastID = this.treeStructure.size();
            return this.treeStructure.elementAt(lastID - 1);
        }
        return 0;
    }

    protected void writeRepeatSection(ReportSection section) throws Exception {
        this.isWriteRepeatSection = true;
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                ReportSection drawingSection = this.sectionList.elementAt(i);
                if (drawingSection == section) {
                    return;
                }
                for (int j = 0; j < drawingSection.getSectionCount(); ++j) {
                    if (drawingSection.getSection(j) != section) continue;
                    return;
                }
                this.writeSection(drawingSection, this.tableList.elementAt(i), true);
            }
        }
        this.isWriteRepeatSection = false;
    }

    protected void addRepeatSection(ReportSection section, ReportTable tbl) {
        this.sectionList.addElement(section);
        this.tableList.addElement(tbl);
    }

    protected void removeRepeatSection() {
        this.sectionList.removeElementAt(this.sectionList.size() - 1);
        this.tableList.removeElementAt(this.tableList.size() - 1);
    }

    protected boolean skipCell(ReportElement cell) {
        if (cell instanceof ColumnWrap) {
            return true;
        }
        if (!this.doColumnWrap) {
            return false;
        }
        return cell.getX() + cell.getWidth() > this.columnWrapWidth;
    }

    protected void pageBreak(ReportSection section) throws Exception {
        this.pageBreak(section, false);
    }

    protected void pageBreak(ReportSection section, boolean isToc) throws Exception {
        if (this.checkVisibility) {
            throw new Exception("Subreport page break.");
        }
        if (this.elementYPos <= this.pageHeaderHeight) {
            return;
        }
        if (this.report.isExportToMultiPages() || this.report.isExportToSingleWPagination()) {
            if (this.doColumnWrap && this.wrapInfo != null) {
                if (this.columnWrapCount <= 0 || this.wrapInfo[0] >= (double)this.columnWrapCount || this.elementYPos == this.wrapInfo[1]) {
                    this.pageBreak2(section, isToc);
                    this.wrapInfo[0] = 0.0;
                    this.wrapInfo[1] = this.elementYPos;
                } else {
                    this.wrapInfo[2] = this.elementYPos;
                    this.elementYPos = this.wrapInfo[1];
                    this.wrapInfo[0] = this.wrapInfo[0] + 1.0;
                    this.pageBreakRowCount = 0;
                }
            } else {
                this.pageBreak2(section, isToc);
            }
        } else {
            this.out.flush();
        }
    }

    private void pageBreak2(ReportSection section, boolean isToc) throws Exception {
        if (this.report.isExportToSingleWPagination()) {
            double pos = (this.report.getPageHeight() - DHTMLReport.getBrowserMargin()) * (double)(this.currentPageNumber - 1);
            if (this.elementYPos <= pos + this.pageHeaderHeight) {
                return;
            }
            pos += this.pageHeight;
            if (section != null ? this.elementYPos + section.getHeight() < pos && !this.forcePageBreak : this.elementYPos + 0.3 < pos && !this.forcePageBreak) {
                return;
            }
        }
        if (this.report.isExportToMultiPages()) {
            this.closeCurrentFileOutput();
            ++this.currentPageNumber;
            ++this.currentPage;
            if (section != null && section.isResetPageNumber()) {
                this.currentPage = 1;
                this.savedStartPage = this.currentPageNumber;
            }
            this.startNewFileOutput();
            if (!isToc) {
                this.writeRepeatSection(section);
            }
            ++this.pagebreaks;
            this.pageBreakRowCount = 0;
        } else if (this.report.isExportToSingleWPagination()) {
            this.endPage();
            ++this.currentPageNumber;
            ++this.currentPage;
            if (section != null && section.isResetPageNumber()) {
                this.currentPage = 1;
                this.savedStartPage = this.currentPageNumber;
            }
            this.startNewPage();
            if (!isToc) {
                this.writeRepeatSection(section);
            }
            ++this.pagebreaks;
            this.pageBreakRowCount = 0;
        }
    }

    private void pageBreak(double requireHeight, ReportSection section) throws Exception {
        double availableHeight = this.pageHeight - this.elementYPos;
        if (this.report.isExportToSingleWPagination()) {
            availableHeight += (this.report.getPageHeight() - DHTMLReport.getBrowserMargin()) * (double)(this.currentPageNumber - 1);
        }
        if (availableHeight >= requireHeight) {
            return;
        }
        this.pageBreak(section);
    }

    protected void pageBreak(double requiredHeight, int rowIndex) throws Exception {
        if (!(this.report.isExportToMultiPages() || this.report.isExportToSingleWPagination() || this.checkVisibility)) {
            if (this.columnWrapCount > 0) {
                if (this.columnWrapDisplayRow == 0) {
                    this.columnWrapDisplayRow = (int)Math.ceil((double)this.totalRowCount / (double)(this.columnWrapCount + 1));
                }
                if ((double)((int)Math.floor((double)(this.rowCount - 1) / (double)this.columnWrapDisplayRow)) > this.wrapInfo[0]) {
                    this.wrapInfo[2] = this.elementYPos;
                    this.elementYPos = this.wrapInfo[1];
                    this.wrapInfo[0] = this.wrapInfo[0] + 1.0;
                    this.pageBreakRowCount = 0;
                }
            }
            this.out.flush();
            return;
        }
        double remain = this.pageHeight - this.elementYPos;
        if (this.report.isExportToSingleWPagination()) {
            remain += (this.report.getPageHeight() - DHTMLReport.getBrowserMargin()) * (double)(this.currentPageNumber - 1);
        }
        if (remain >= requiredHeight) {
            return;
        }
        if (this.wrapInfo != null) {
            if (this.wrapInfo[0] >= (double)this.columnWrapCount || this.elementYPos == this.wrapInfo[1]) {
                this.pageBreak(null);
                this.wrapInfo[0] = 0.0;
                this.wrapInfo[1] = this.elementYPos;
                this.wrapInfo[2] = this.elementYPos;
                this.columnWrapInitialRow = this.columnWrapDisplayRow + this.columnWrapInitialRow;
                this.columnWrapDisplayRow = 0;
                return;
            }
            this.wrapInfo[2] = this.elementYPos;
            this.elementYPos = this.wrapInfo[1];
            if (this.columnWrapDisplayRow == 0) {
                this.columnWrapDisplayRow = rowIndex - this.columnWrapInitialRow * (this.columnWrapCount + 1);
            }
            this.wrapInfo[0] = this.wrapInfo[0] + 1.0;
            this.pageBreakRowCount = 0;
            return;
        }
    }

    protected double writeSection(ReportSection orgSection, ReportTable tbl) throws Exception {
        return this.writeSection(orgSection, tbl, true);
    }

    protected double writeSection(ReportSection section, ReportTable tbl, boolean checkPageBreak) throws Exception {
        return this.writeSection(section, tbl, checkPageBreak, 0, 1);
    }

    private double writeSection(ReportSection section, ReportTable tbl, boolean checkPageBreak, int level, int levelCount) throws Exception {
        if (!this.titleAdjusted) {
            this.titleAdjusted = this.reportUI.adjustReportTitle(this.reportUI.getReportGraphics(), this.report.getReportHeader());
        }
        Writer backupOut = this.out;
        try {
            boolean enableSliderFeature;
            double backupElementYPos = this.elementYPos;
            double initYPos = 0.0;
            boolean bl = enableSliderFeature = this.isSliderFeature && (section.getCustomID().startsWith(SLIDER_PREFIX) || this.report.getPageHeader() == section || this.report.getPageFooter() == section || this.report.getReportHeader() == section || this.report.getReportFooter() == section);
            if (enableSliderFeature) {
                this.out = new StringWriter();
                initYPos = this.elementYPos = 0.0 - this.topMargin - this.report.getDHTMLTopMargin();
            }
            Color bgColor = null;
            boolean printOnNewPage = false;
            boolean visible = false;
            boolean resetPageNumber = false;
            if (section.getScriptObj() != null) {
                bgColor = section.getBgColor();
                printOnNewPage = section.isPrintOnNewPage();
                visible = section.isVisible();
                resetPageNumber = section.isResetPageNumber();
                section.getScriptObj().applyScript(tbl, this.currentPageNumber, 1, this.totalPageNumber, 1, this.report, section);
            }
            double height = this.writeSectionHelper(section, tbl, checkPageBreak, level, levelCount);
            for (int i = 0; i < section.getSectionCount(); ++i) {
                ReportSection child = section.getSection(i);
                child.setRepeatOnEveryPage(section.isRepeatOnEveryPage());
                height += this.writeSection(child, tbl, checkPageBreak);
            }
            if (section.getScriptObj() != null) {
                section.setBgColor(bgColor);
                section.setPrintOnNewPage(printOnNewPage);
                section.setVisible(visible);
                section.setResetPageNumber(resetPageNumber);
            }
            String sectionStr = this.out.toString();
            if (enableSliderFeature) {
                this.elementYPos = backupElementYPos + (this.elementYPos - initYPos);
                this.out = backupOut;
                if (sectionStr.length() > 0 && this.containElt(sectionStr)) {
                    this.out.write("\n<div id=\"" + section.getCustomID() + "\" style=\"position:relative; height: " + QbUtil.toPixel_export(height) + "px\">\n");
                    this.out.write(sectionStr);
                    this.out.write(this.writeCloseDivTag());
                }
                this.out.flush();
            }
            return height;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Error writing report section", ex);
            this.out = backupOut;
            this.out.flush();
            throw ex;
        }
    }

    private boolean containElt(String str) {
        int fromIndex = 0;
        int count = 0;
        String tmp = str.toLowerCase();
        while ((fromIndex = tmp.indexOf("/div", fromIndex) + 1) > 0) {
            if (++count > 1) {
                return true;
            }
            if (tmp.indexOf("div id=\"icon_") != -1) continue;
            return true;
        }
        return false;
    }

    protected boolean isFirstValue() {
        int[] intArray;
        for (int element : intArray = QbUtil.convertVectorToIntArray(this.treeStructure)) {
            if (element == 0) continue;
            return false;
        }
        return true;
    }

    private boolean printOnNewPage(ReportSection section) {
        if (section.isSkipFirstValue()) {
            this.skipFirstValueForToc = true;
        }
        if (section.isResetPageNumber()) {
            if (!(section.isPrintOnNewPage() && this.elementYPos > 0.0 && section.isSkipFirstValue() && this.isFirstValue() || section.isPrintOnNewPage() && this.elementYPos > 0.0 && section.isSkipFirstGroupValue() && this.getCurrentSectionID() == 0)) {
                this.printOnNewPageForToc = true;
                return true;
            }
        } else if (!(!section.isPrintOnNewPage() || section.isSkipFirstValue() && this.elementYPos > 0.0 && this.isFirstValue() || section.isSkipFirstGroupValue() && this.elementYPos > 0.0 && this.getCurrentSectionID() == 0)) {
            this.printOnNewPageForToc = true;
            return true;
        }
        return false;
    }

    private double writeSectionHelper(ReportSection orgSection, ReportTable tbl, boolean checkPageBreak, int level, int levelCount) throws Exception {
        if (orgSection == null || !orgSection.isVisible()) {
            return 0.0;
        }
        if (orgSection.isResetPageNumber()) {
            this.resetPageNumber = true;
            this.treeCopy = this.getTreeStringKey();
            if (this.sectionTotalPagesTable == null) {
                this.sectionTotalPagesTable = new Hashtable();
            }
            if (this.sectionTotalPages == null) {
                this.sectionTotalPages = new Vector();
            }
            if (this.sectionStartPage == null) {
                this.sectionStartPage = new Vector();
            }
        }
        if (!this.isWriteRepeatSection && this.printOnNewPage(orgSection)) {
            this.forcePageBreak = true;
            this.pageBreak(orgSection);
            this.forcePageBreak = false;
        }
        if (this.hasNoData(orgSection)) {
            return 0.0;
        }
        boolean doColumnWrap_BAK = this.doColumnWrap;
        int totalDrawCol = this.columnWrapCount;
        boolean repeatTableHeader = false;
        if (orgSection == this.report.getPageHeader() || orgSection == this.report.getPageFooter() || orgSection == this.report.getReportHeader() || orgSection == this.report.getReportFooter() || orgSection.getID().startsWith("RPT_HDR") || orgSection.getID().startsWith("RPT_FTR") || orgSection.getTOC() != null) {
            this.doColumnWrap = false;
            totalDrawCol = 0;
        } else if (orgSection.getID().equals("TBL0_HDR")) {
            repeatTableHeader = true;
            if ((this.report.isExportToMultiPages() || this.report.isExportToSingleWPagination()) && !this.checkTotalPageNumber && this.totalPageNumber == this.currentPageNumber) {
                totalDrawCol = this.lastDrawCol;
            }
        } else {
            totalDrawCol = 0;
        }
        ReportSection cellArray = this.resizeSection(this.reportGraphics, orgSection, tbl);
        if (checkPageBreak) {
            this.pageBreak(cellArray.getHeight(), orgSection);
        }
        this.writeSectionTag(cellArray);
        if (orgSection == cellArray) {
            cellArray = ReportUI.copySectionForSecuredInvisibleCols(cellArray, tbl, this.report.getPreviewSecurityLevel());
        }
        ReportElement[] cells = cellArray.sortCell(1, true);
        cells = (ReportCell[])ReportUI.takeAwaySecuredInvisibleCols(cells, tbl, this.report.getPreviewSecurityLevel(), this.report.getReportType());
        double bottomY = this.elementYPos + cellArray.getHeight();
        Vector<ISubReportExport> subReports = new Vector<ISubReportExport>();
        for (int curArea = 0; curArea <= totalDrawCol; ++curArea) {
            double delta = 0.0;
            if (repeatTableHeader) {
                delta = (double)curArea * this.columnWrapWidth;
            } else if (this.doColumnWrap && this.wrapInfo != null) {
                delta = this.wrapInfo[0] * this.columnWrapWidth;
            }
            this.elementXPos = delta;
            boolean drawArrowButtonForSlider = orgSection.getCustomID().startsWith(SLIDER_PREFIX);
            boolean isHeader = orgSection.getCustomID().startsWith(SLIDER_PREFIX) && orgSection.getCustomID().indexOf("_HDR_") > 0;
            for (ReportElement cell2 : cells) {
                if (cell2 instanceof ReportLine || cell2 instanceof ReportGrid || this.skipCell(cell2)) continue;
                ReportElement cell = null;
                if (this.exportThisPage() || cell2.isResizeToFitContent() || this.report.isTocEnabled() && !this.report.getTableOfContentsObject().isUseGroups() && cell2.getScript() != null && cell2.getScript().toUpperCase().indexOf("BOOKMARK") >= 0) {
                    cell = tbl.formatCell((ReportCell)cell2, this.getPage(), 1, this.getTotalPageNumber(), 1, this.report);
                }
                if (cell == null || !cell.isVisible()) continue;
                if (cell instanceof SubReportObject || cell instanceof ReportRTFObject || cell instanceof TableOfContents) {
                    if (cellArray.isRepeatOnEveryPage() || orgSection == this.report.getPageHeader() || orgSection == this.report.getPageFooter()) {
                        cell.setResizeToFitContent(false);
                    }
                    if ((this.checkTotalPageNumber || this.checkFitGroupOnPage) && !cell.isResizeToFitContent()) continue;
                    ISubReportExport dhtmlSub = null;
                    if (cell instanceof SubReportObject) {
                        dhtmlSub = this.writeSubReport((SubReportObject)cell, tbl, cellArray);
                        this.report.setNullDataOption(this.report.getNullDataOption(), true);
                    } else if (cell instanceof ReportRTFObject) {
                        dhtmlSub = this.writeRTFObject((ReportRTFObject)cell, tbl, cellArray);
                    } else if (cell instanceof TableOfContents && this.report.isTocEnabled()) {
                        dhtmlSub = this.writeTOCObject((TableOfContents)cell, tbl, cellArray);
                    }
                    if (dhtmlSub != null && dhtmlSub.isFinished()) {
                        if (!(dhtmlSub.getY() > bottomY) || !cell.isResizeToFitContent()) continue;
                        bottomY = dhtmlSub.getY();
                        if (cell instanceof ReportRTFObject && dhtmlSub instanceof DHTMLRTFObject) {
                            cellArray.setHeight(dhtmlSub.getY() - ((DHTMLRTFObject)dhtmlSub).getStartY() + ((ReportRTFObject)cell).getY());
                            continue;
                        }
                        if (cell instanceof TableOfContents && dhtmlSub instanceof DHTMLTOCObject && this.report.isTocEnabled()) {
                            cellArray.setHeight(dhtmlSub.getY() - ((DHTMLTOCObject)dhtmlSub).getStartY() + ((TableOfContents)cell).getY());
                            continue;
                        }
                        if (!(cell instanceof SubReportObject) || !(dhtmlSub instanceof DHTMLSubReport)) continue;
                        cellArray.setHeight(dhtmlSub.getY() - ((DHTMLSubReport)dhtmlSub).getStartY() + ((SubReportObject)cell).getY());
                        continue;
                    }
                    if (dhtmlSub == null) continue;
                    this.elementYPos += dhtmlSub.getY();
                    subReports.insertElementAt(dhtmlSub, 0);
                    cellArray.setHeight(this.pageHeight - ((DHTMLSubReport)dhtmlSub).getStartY() + cell.getY());
                    continue;
                }
                if (drawArrowButtonForSlider && this.isSliderFeature && orgSection.getCustomID().startsWith(SLIDER_PREFIX)) {
                    drawArrowButtonForSlider = this.drawArrowButtonForSlider(orgSection, tbl, level, levelCount, isHeader);
                }
                if ((this.checkTotalPageNumber || this.checkFitGroupOnPage) && (!this.report.isTocEnabled() || this.report.getTableOfContentsObject().isUseGroups() || cell2.getScript() == null || cell2.getScript().toUpperCase().indexOf("BOOKMARK") < 0)) continue;
                this.writeTableDataElement(cell, tbl, cellArray);
            }
            for (int i = 0; i < cells.length; ++i) {
                if (!(cells[i] instanceof ReportLine) && !(cells[i] instanceof ReportGrid) || this.skipCell(cells[i])) continue;
                if ((this.exportThisPage() || cells[i].isResizeToFitContent()) && cells[i] instanceof ReportLine && !((ReportLine)cells[i]).isVertical() && ((ReportLine)cells[i]).isMatchColumnWidths()) {
                    ((ReportLine)cells[i]).setWidth(tbl.getColumnWidths() - cells[i].getX());
                }
                if (cells[i] instanceof ReportGrid && ((ReportGrid)cells[i]).isMatchColumnWidths()) {
                    ((ReportGrid)cells[i]).setWidth(tbl.getColumnWidths() - cells[i].getX());
                }
                if (drawArrowButtonForSlider && this.isSliderFeature && orgSection.getCustomID().startsWith(SLIDER_PREFIX)) {
                    drawArrowButtonForSlider = this.drawArrowButtonForSlider(orgSection, tbl, level, levelCount, isHeader);
                }
                this.writeTableDataElement(tbl.formatCell((ReportCell)cells[i], this.getPage(), 1, this.getTotalPageNumber(), 1, this.report), tbl, cellArray);
            }
        }
        this.writeSectionBgColor(cellArray);
        this.doColumnWrap = doColumnWrap_BAK;
        if (subReports.size() > 0) {
            this.elementYPos = this.writeRemainingSubReports(subReports, orgSection);
        } else {
            this.elementYPos += cellArray.getHeight();
            if (bottomY > this.elementYPos) {
                this.elementYPos = bottomY;
            }
        }
        if (this.doColumnWrap && this.wrapInfo != null) {
            this.curMaxY = bottomY < this.wrapInfo[2] ? this.wrapInfo[2] : bottomY;
            if (repeatTableHeader) {
                this.wrapInfo[1] = this.elementYPos;
            }
        }
        this.elementXPos = 0.0;
        this.closeSectionTag();
        return cellArray.getHeight();
    }

    private boolean drawArrowButtonForSlider(ReportSection orgSection, ReportTable tbl, int level, int levelCount, boolean isHeader) throws IOException {
        int leftPos = QbUtil.toPixel_export(this.leftMargin) - 15 * (levelCount - level);
        String symbol = "&#x25BA;";
        if (this.isExpand(level)) {
            symbol = isHeader ? "&#x25BC;" : "&#x25B2;";
        }
        this.out.write("<div id=\"ICON_" + orgSection.getCustomID() + "\" class=\"links\" onclick=\"myToggle(event, '" + tbl.getCustomID() + "', " + isHeader + ")\" STYLE=\"position:absolute; width:" + 15 + "px; height:19px; left:" + leftPos + "px;\">" + symbol + this.writeCloseDivTag());
        return false;
    }

    protected void writeReportTable(ReportTable tbl) throws Exception {
        this.writeReportTable(tbl, 0);
    }

    protected void writeReportTable(ReportTable tbl, int level) throws Exception {
        this.writeReportTable(tbl, level, this.getLevelCount(tbl));
    }

    private void writeReportTable(ReportTable tbl, int level, int levelCount) throws Exception {
        String backupCustomID_TBL = tbl.getCustomID();
        String backupCustomID_HDR = tbl.getHeader().getCustomID();
        String backupCustomID_FTR = tbl.getFooter().getCustomID();
        try {
            tbl.setCustomID(SLIDER_PREFIX + this.rptName + "_TBL_" + this.tblDivCount);
            tbl.getHeader().setCustomID(SLIDER_PREFIX + this.rptName + "_HDR_" + this.tblDivCount);
            tbl.getFooter().setCustomID(SLIDER_PREFIX + this.rptName + "_FTR_" + this.tblDivCount);
            if (!this.checkFitGroupOnPage) {
                ++this.tblDivCount;
            }
            this.writeSection(tbl.getHeader(), tbl, true, level, levelCount);
            if (tbl.getHeader().isRepeatOnEveryPage()) {
                this.addRepeatSection(tbl.getHeader(), tbl);
            }
            if (this.treeStructure == null) {
                this.treeStructure = new Vector();
            }
            if (tbl instanceof ReportTreeTable) {
                ReportTreeTable sTbl = (ReportTreeTable)tbl;
                if (this.isSliderFeature && !this.checkFitGroupOnPage) {
                    this.out.write("<div id=\"" + sTbl.getCustomID() + "\" style=\"position:relative; \">\n");
                }
                for (int i = 0; i < sTbl.countSubTable(); ++i) {
                    Bookmark entry;
                    int idx;
                    this.treeStructure.addElement(i);
                    int n = idx = sTbl.indexArray == null ? i : sTbl.indexArray[i];
                    if (!(this.checkFitGroupOnPage || this.report.breakColIndex == null || this.report.breakColIndex.length <= level || this.report.colInfo[this.report.breakColIndex[level]].skipFirstValueForFitGroup() && i <= 0 || !this.report.colInfo[this.report.breakColIndex[level]].isFitGroupOnPage())) {
                        this.pagebreaks = 0;
                        double x = this.elementXPos;
                        double y = this.elementYPos;
                        this.checkFitGroupOnPage = true;
                        try {
                            if (!sTbl.getSubTable(idx).isAggregationTable()) {
                                this.writeReportTable(sTbl.getSubTable(idx), level + 1, levelCount);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.FINEST, "Failed to write report table", e);
                        }
                        this.checkFitGroupOnPage = false;
                        this.treeStructure.addElement(i);
                        this.elementXPos = x;
                        this.elementYPos = y;
                        if (this.pagebreaks > 0) {
                            this.currentPageNumber -= this.pagebreaks;
                            this.forcePageBreak = true;
                            this.pageBreak(null);
                            this.forcePageBreak = false;
                        }
                    }
                    if (this.report.isTocEnabled() && (entry = this.report.getTableOfContentsObject().getEntryByTree(this.treeStructure)) != null) {
                        entry.setPageNumber(this.currentPageNumber);
                        entry.setYPos(this.elementYPos);
                        double availableHeight = this.pageHeight - this.elementYPos;
                        if (this.report.isExportToSingleWPagination()) {
                            availableHeight += (this.report.getPageHeight() - DHTMLReport.getBrowserMargin()) * (double)(this.currentPageNumber - 1);
                        }
                        if (availableHeight < this.tableDataCellHeight) {
                            entry.setPageNumber(this.currentPageNumber + 1);
                        }
                        if (!(!this.printOnNewPageForToc || this.skipFirstValueForToc && this.isFirstValue())) {
                            entry.setPageNumber(this.currentPageNumber + 1);
                        }
                        this.writeBookmark(entry.getKey());
                    }
                    if (sTbl.getSubTable(idx).isAggregationTable()) continue;
                    this.writeReportTable(sTbl.getSubTable(idx), level + 1, levelCount);
                }
                if (this.isSliderFeature && !this.checkFitGroupOnPage) {
                    this.out.write(this.writeCloseDivTag());
                }
            } else {
                this.writeCells(tbl);
            }
            this.writeSection(tbl.getFooter(), tbl, true, level, levelCount);
            this.addSectionTotalPagesTableEntry();
            if (this.treeStructure.size() > 1) {
                this.treeStructure.removeElementAt(this.treeStructure.size() - 1);
            } else {
                this.treeStructure.removeAllElements();
            }
            this.addSectionTotalPagesTableEntry();
            if (tbl.getHeader().isRepeatOnEveryPage()) {
                this.removeRepeatSection();
            }
            tbl.setCustomID(backupCustomID_TBL);
            tbl.getHeader().setCustomID(backupCustomID_HDR);
            tbl.getFooter().setCustomID(backupCustomID_FTR);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot write report table", ex);
            tbl.setCustomID(backupCustomID_TBL);
            tbl.getHeader().setCustomID(backupCustomID_HDR);
            tbl.getFooter().setCustomID(backupCustomID_FTR);
            throw ex;
        }
    }

    private int getLevelCount(ReportTable orgTbl) {
        if (orgTbl instanceof ReportMultiSectionTable) {
            return ((ReportMultiSectionTable)orgTbl).dataHeader.length + 1;
        }
        return 1;
    }

    protected void addSectionTotalPagesTableEntry() {
        if (this.sectionTotalPagesTable != null && this.getTreeStringKey() != null && this.treeCopy.equals(this.getTreeStringKey()) && this.populateTable) {
            if (this.sectionTotalPagesTable.containsKey(this.getTreeStringKey())) {
                this.sectionTotalPages.removeElementAt(this.sectionTotalPages.size() - 1);
                this.sectionStartPage.removeElementAt(this.sectionStartPage.size() - 1);
            }
            this.sectionTotalPagesTable.put(this.getTreeStringKey(), this.currentPage);
            this.sectionTotalPages.addElement(this.currentPage);
            this.sectionStartPage.addElement(this.savedStartPage);
        }
    }

    protected void writeCells(ReportTable tbl) throws Exception {
        Color bgColor = null;
        boolean printOnNewPage = false;
        boolean visible = false;
        if (tbl.getScriptObj() != null) {
            bgColor = tbl.getBgColor();
            printOnNewPage = tbl.isPrintOnNewPage();
            visible = tbl.isVisible();
            tbl.getScriptObj().applyScript(tbl, this.currentPageNumber, 1, this.totalPageNumber, 1, this.report, tbl);
        }
        if (!tbl.isVisible()) {
            return;
        }
        Writer backupOut = this.out;
        try {
            double backupElementYPos = this.elementYPos;
            double initYPos = 0.0;
            if (this.isSliderFeature) {
                this.out = new StringWriter();
                initYPos = this.elementYPos = 0.0 - this.topMargin - this.report.getDHTMLTopMargin();
            }
            Report temp_report = this.report;
            int nRow = tbl.getRowCount();
            ReportImage[] chart = tbl.getSortedImages();
            SubReportObject[] subReports = tbl.getSortedSubReports();
            ReportRTFObject[] rtfObjects = tbl.getSortedRTFObjects();
            Vector<ISubReportExport> remainingSubReports = new Vector<ISubReportExport>();
            Vector<ReportCell> oneTime = new Vector<ReportCell>();
            Vector<Double> oneTimeY = new Vector<Double>();
            for (int i = 0; i < chart.length; ++i) {
                if (chart[i] instanceof ReportLine || chart[i] instanceof ReportGrid || this.skipCell(chart[i])) continue;
                oneTime.insertElementAt(chart[i], 0);
                oneTimeY.insertElementAt(chart[i].getY(), 0);
            }
            for (SubReportObject subReportObject : subReports) {
                oneTime.insertElementAt(subReportObject, 0);
                oneTimeY.insertElementAt(subReportObject.getY(), 0);
            }
            for (ReportCell reportCell : rtfObjects) {
                oneTime.insertElementAt(reportCell, 0);
                oneTimeY.insertElementAt(reportCell.getY(), 0);
            }
            double bottomYOfSection = 0.0;
            ReportSection mSection = tbl.getMasterSection();
            double d = 0.0;
            if (this.wrapInfo != null) {
                d = this.wrapInfo[0];
            }
            this.resetColumnWrapTableUI();
            ReportTable orgTable = tbl;
            this.rows = orgTable.getFormattedRows();
            boolean hasVisibleElements = tbl.hasVisibleElements();
            boolean needResizeTable = tbl.hasResizeToFitElement() || tbl.hasDualColorOnColumnChange();
            tbl = ReportUI.copySectionForSecuredInvisibleCols(tbl, this.report.getPreviewSecurityLevel());
            ReportElement[] col = tbl.getSortedVisibleColumns();
            col = (ReportColumn[])ReportUI.takeAwaySecuredInvisibleCols(col, this.report.getPreviewSecurityLevel(), this.report.getReportType());
            for (int i = 0; i < nRow; ++i) {
                int j;
                double delta;
                int ii = i;
                boolean hasVisibleColumn = false;
                ++this.rowCount;
                if (tbl.indexArray != null) {
                    ii = tbl.indexArray[i];
                }
                this.elementXPos = 0.0;
                if (needResizeTable || this.exportThisPage()) {
                    tbl = this.resizeTable(this.reportGraphics, orgTable, ii);
                    if (tbl == orgTable) {
                        tbl = ReportUI.copySectionForSecuredInvisibleCols(tbl, this.report.getPreviewSecurityLevel());
                    }
                    col = tbl.getSortedVisibleColumns();
                    col = (ReportColumn[])ReportUI.takeAwaySecuredInvisibleCols(col, this.report.getPreviewSecurityLevel(), this.report.getReportType());
                }
                chart = tbl.getSortedImages();
                if (this.rowElements == null && !hasVisibleElements && (i > 0 || oneTime.size() == 0 && this.hasNoData(mSection))) continue;
                double tblH = tbl.getHeight();
                if (!this.hasNoData(mSection) && i == 0) {
                    tblH = (mSection = this.resizeSection(this.reportGraphics, mSection, tbl)).getHeight() + mSection.getY() > tblH ? mSection.getHeight() + mSection.getY() : tblH;
                }
                int oldpageN = this.currentPageNumber;
                if (tbl.isPrintOnNewPage(this.pageBreakRowCount)) {
                    this.forcePageBreak = true;
                    this.pageBreak(null);
                    this.forcePageBreak = false;
                } else {
                    this.pageBreak(tblH, ii);
                }
                ++this.pageBreakRowCount;
                if (this.currentPageNumber > oldpageN || i == 0) {
                    bottomYOfSection = this.writeVisibleOneTimeElements(oneTime, oneTimeY, remainingSubReports, tbl);
                }
                if (!this.hasNoData(mSection) && i == 0) {
                    this.writeMasterSection(mSection, tbl);
                    if (bottomYOfSection < this.elementYPos + mSection.getY() + mSection.getHeight()) {
                        bottomYOfSection = this.elementYPos + mSection.getY() + mSection.getHeight();
                    }
                }
                if (this.wrapInfo != null) {
                    d = this.wrapInfo[0];
                }
                if (this.checkTotalPageNumber) {
                    this.lastDrawCol = (int)d;
                }
                this.elementXPos = delta = d * this.columnWrapWidth;
                if (delta == 0.0) {
                    this.writeSectionTag(tbl);
                }
                double tmpYPos = this.elementYPos;
                for (j = 0; j < col.length; ++j) {
                    if (this.skipCell(col[j])) continue;
                    ReportCell cell = tbl.formatCell((ReportColumn)col[j], ii, this.getPage(), 1, this.getTotalPageNumber(), 1, i - this.columnWrapDisplayRow * (int)d - this.columnWrapCount * this.columnWrapInitialRow, temp_report);
                    if (cell.isVisible()) {
                        hasVisibleColumn = true;
                    }
                    if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage || this.report.isTocEnabled() && !this.report.getTableOfContentsObject().isUseGroups() && cell.getBookmark() != null) {
                        this.writeTableDataElement(cell, tbl, ii, tbl);
                    }
                    this.tableDataCellHeight = cell.getHeight();
                }
                if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage) {
                    if (this.rowElements != null) {
                        for (j = 0; j < this.rowElements.size(); ++j) {
                            ReportElement elt = this.rowElements.elementAt(j);
                            this.writeTableDataElement(elt, tbl, ii, tbl);
                        }
                    }
                    for (int k = 0; k < chart.length; ++k) {
                        ReportImage img;
                        if (this.skipCell(chart[k]) || !((img = chart[k]) instanceof ReportLine) && !(img instanceof ReportGrid)) continue;
                        ReportImage newImg = (ReportImage)tbl.formatCell(img, ii, this.getPage(), 1, this.getTotalPageNumber(), 1, this.report, false);
                        this.writeTableDataElement(newImg, tbl, ii, tbl);
                    }
                }
                if (hasVisibleElements && hasVisibleColumn || this.rowElements != null) {
                    this.elementYPos += tbl.getHeight();
                }
                double tmp2YPos = this.elementYPos;
                this.elementYPos = tmpYPos;
                if (delta == 0.0) {
                    this.writeSectionBgColor(tbl);
                }
                this.elementYPos = tmp2YPos;
                if (delta != 0.0) continue;
                this.closeRowTag();
            }
            if (remainingSubReports.size() > 0 || oneTime.size() > 0) {
                this.elementYPos = this.writeRemainingSubReports(remainingSubReports, oneTime, oneTimeY, null, tbl);
            } else if (!this.isSliderFeature && !DHTMLSubReport.class.isInstance(this) && this.elementYPos < bottomYOfSection) {
                this.elementYPos = bottomYOfSection;
            }
            if (this.doColumnWrap) {
                this.curMaxY = this.wrapInfo != null && this.elementYPos < this.wrapInfo[2] ? this.wrapInfo[2] : this.elementYPos;
            }
            this.elementXPos = 0.0;
            if (tbl.getScriptObj() != null) {
                tbl.setBgColor(bgColor);
                tbl.setPrintOnNewPage(printOnNewPage);
                tbl.setVisible(visible);
            }
            String tblStr = this.out.toString();
            if (this.isSliderFeature) {
                int height = QbUtil.toPixel_export(this.elementYPos - initYPos);
                this.elementYPos = backupElementYPos + (this.elementYPos - initYPos);
                this.out = backupOut;
                if (tblStr.length() > 0) {
                    this.out.write("\n<div id=\"" + tbl.getCustomID() + "\" style=\"position:relative; height: " + height + "px\">\n");
                    this.out.write(tblStr);
                    this.out.write(this.writeCloseDivTag());
                }
                this.out.flush();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to write report cells", ex);
            this.out = backupOut;
            this.out.flush();
            throw ex;
        }
    }

    protected String writeBarcode(ReportElement elt) throws IOException, Exception {
        if (elt.getText().equals("")) {
            return "";
        }
        String barcodeFileName = Report.getFullName(this.prefix + "_BARCODE_" + this.barcodeCount, 12);
        BarcodeFormat bf = (BarcodeFormat)((ReportCell)elt).getDataFormat();
        String codeText = BarcodeUtil.getBarcodeString(elt.getText(), bf.getformat());
        int codeType = bf.getformat();
        String imageURL = null;
        int imageXMargin = 0;
        if (!this.report.isDynamicExport()) {
            ExportBarcode eb = new ExportBarcode(barcodeFileName, codeText, codeType, QbUtil.toPixel_export(elt.getWidth()), QbUtil.toPixel_export(elt.getHeight()), BarcodeUtil.getBarcodeLeftMargin(elt), elt.getRefFont(), elt.getBgColor(), elt.getFontColor());
            this.exportThread.queue(eb, null);
            imageURL = this.getRelativeFileName(barcodeFileName);
        } else {
            Object[] res = BarcodeUtil.getBarCodeImage(elt, null);
            byte[] image = (byte[])res[0];
            imageXMargin = (Integer)res[1];
            imageURL = this.doDynamicImageExport(image);
        }
        String str = "<IMG " + this.qt("SRC", imageURL) + " " + this.qt("BORDER", 0) + " " + this.qt("ALIGN", ALIGN[elt.getAlign()]) + " " + this.qt("VALIGN", VALIGN[elt.getVAlign()]) + " " + this.qt("HEIGHT", QbUtil.toPixel_export(elt.getHeight())) + " " + this.qt("WIDTH", QbUtil.toPixel_export(elt.getWidth())) + imageXMargin + ">";
        ++this.barcodeCount;
        return str;
    }

    protected boolean isVisible(ReportElement elt) {
        return elt.isVisible();
    }

    protected void writeTableDataElement(ReportElement elt, ReportTable tbl, ReportTableElement panel) throws Exception {
        this.writeTableDataElement(elt, tbl, 0, panel);
    }

    protected void writeTableDataElement(ReportElement elt, ReportTable tbl, int row, ReportTableElement panel) throws Exception {
        if (elt instanceof ReportCell && ((ReportCell)elt).getBookmark() != null && this.report.isTocEnabled()) {
            Bookmark entry = this.report.getTableOfContentsObject().addBookmark(((ReportCell)elt).getBookmark());
            entry.setPageNumber(this.currentPageNumber);
            entry.setYPos(this.elementYPos);
        }
        if (!this.exportThisPage() || !this.isVisible(elt)) {
            return;
        }
        if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage) {
            if (elt instanceof ReportLine) {
                this.writeReportLine((ReportLine)elt, panel);
            } else if (elt instanceof ReportGrid) {
                this.writeReportGrid((ReportGrid)elt, panel);
            } else {
                int eltW = this.openDivTag(elt);
                if (elt.getBookmark() != null) {
                    this.out.write(this.openAnchor(elt.getBookmark()));
                }
                if (elt instanceof ReportChartObject) {
                    ReportCell[] cells = null;
                    if (panel instanceof ReportSection) {
                        cells = ((ReportSection)panel).getData();
                    }
                    this.out.write(this.writeChart((ReportChartObject)elt, tbl, cells, row));
                } else if (elt instanceof ReportImage) {
                    this.out.write(this.writeImage((ReportImage)elt, tbl, row));
                } else {
                    try {
                        if (((ReportCell)elt).getDataFormat() instanceof BarcodeFormat) {
                            this.out.write(this.writeBarcode(elt));
                        } else {
                            this.writeText(elt, tbl, row, eltW);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Failed to write report cell", ex);
                    }
                }
                if (elt.getBookmark() != null) {
                    this.out.write(this.writeCloseAnchorTag());
                }
                if (elt.getRoundCornerRadius() > 0) {
                    this.out.write(DHTMLReport.writeCloseVMLShapeTag());
                } else {
                    this.out.write(this.writeCloseDivTag());
                }
            }
        }
    }

    protected void writeSectionBgColor(ReportElement section) throws IOException {
        if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage && section.getBgColor() != null) {
            double xx = this.getX(null);
            double yy = this.getY(null);
            double ww = this.maxWidthOfSections;
            double hh = section.getHeight();
            int x = QbUtil.toPixel_export(xx);
            int y = QbUtil.toPixel_export(yy);
            int width = QbUtil.toPixel_export(xx + ww) - QbUtil.toPixel_export(xx);
            int height = QbUtil.toPixel_export(yy + hh) - QbUtil.toPixel_export(yy);
            this.out.write("<div id=\"DivName");
            this.out.write(Integer.toString(this.divnameCount));
            this.out.write("\" style=\"position:absolute; width:");
            this.out.write(Integer.toString(width));
            this.out.write("px; height:");
            this.out.write(Integer.toString(height));
            this.out.write("px; left:");
            this.out.write(Integer.toString(x));
            this.out.write("px; top:");
            this.out.write(Integer.toString(y));
            this.out.write("px; margin:0px; padding:0px; background-color:");
            ColorTable.colorToHTML(section.getBgColor(), this.out);
            this.out.write("; z-index:");
            this.out.write(Integer.toString(this.zIndexOffset));
            this.out.write("\" >\n");
            this.out.write(this.writeCloseDivTag());
            ++this.divnameCount;
        }
    }

    protected String writeCloseDivTag() {
        return "\n</div>\n";
    }

    protected String writeCloseAnchorTag() {
        return "</a>";
    }

    protected boolean hasNoData(ReportSection section) {
        return section == null || section.hasNoDrawableData();
    }

    private boolean hasNoDataExcludeSubReport(ReportSection section) {
        boolean hasNoData = this.hasNoData(section);
        if (hasNoData) {
            return true;
        }
        for (int i = 0; i < section.getCellCount(); ++i) {
            ReportCell cell = section.getData(i);
            if (!cell.isVisible() || cell instanceof SubReportObject || cell instanceof ReportRTFObject || cell instanceof TableOfContents) continue;
            return false;
        }
        return true;
    }

    protected int openDivTag(ReportElement elt) throws IOException {
        CSSStyle style = new CSSStyle(elt);
        if (this.hasValidStyleName(style)) {
            String styleName = this.getStyleName(style);
            if (style.getRoundCornerRadius() > 0) {
                this.out.write(DHTMLReport.writeOpenVMLShapeTag(styleName));
            } else {
                this.out.write("<div class=\"" + styleName + "\" ");
            }
            this.out.write(" style=\"");
            int padding = 0;
            if (!(!(elt instanceof ReportCell) || elt instanceof ReportImage || elt instanceof SubReportObject || elt instanceof ReportRTFObject || elt instanceof ReportDocument || elt.getRefFont().isItalic() || elt.getAlign() != 1 && elt.getAlign() != 2)) {
                padding = 3;
            }
            int eltW = this.writePosition(elt, padding, elt instanceof ReportImage);
            this.out.write("\">\n");
            return eltW;
        }
        int roundCornerRadius = elt.getRoundCornerRadius();
        if (roundCornerRadius > 0) {
            this.out.write(DHTMLReport.writeOpenVMLShape());
        } else {
            this.out.write("<div id=\"DivName");
            this.out.write(Integer.toString(this.divnameCount) + "\" ");
        }
        this.out.write("style=\"position:absolute; ");
        if (roundCornerRadius > 0) {
            this.out.write(DHTMLReport.createRoundCornerRadiusCSSPropertiesString(roundCornerRadius, style.getRoundCornersArray()));
        }
        if (elt.hasBorder() && elt.getBorderColor() != null) {
            this.out.write("border-style:solid; ");
            this.out.write("border-top-width:" + elt.getTopBorder() + "px; ");
            this.out.write("border-right-width:" + elt.getRightBorder() + "px; ");
            this.out.write("border-bottom-width:" + elt.getBottomBorder() + "px; ");
            this.out.write("border-left-width:" + elt.getLeftBorder() + "px; ");
            this.out.write("border-color:");
            this.out.write(ColorTable.colorToHTML(elt.getBorderColor()));
            this.out.write("; \n");
        }
        int rightPadding = 0;
        int leftPadding = 0;
        if (!(!(elt instanceof ReportCell) || elt instanceof ReportImage || elt instanceof SubReportObject || elt instanceof ReportRTFObject || elt instanceof ReportDocument || elt.getRefFont().isItalic())) {
            if (elt.getAlign() == 1) {
                leftPadding = 3;
            } else if (elt.getAlign() == 2) {
                rightPadding = 3;
            }
        }
        int eltW = this.writePosition(elt, leftPadding > rightPadding ? leftPadding : rightPadding, elt instanceof ReportImage);
        this.out.write("margin:0px; padding:0px ");
        this.out.write(Integer.toString(rightPadding));
        this.out.write("px 0px ");
        this.out.write(Integer.toString(leftPadding));
        this.out.write("px; ");
        this.writeFont(elt);
        this.writeAlignment(elt);
        this.out.write("z-index: ");
        this.out.write(Integer.toString(elt.getZ() + this.zIndexOffset + 1));
        this.out.write("; ");
        if (elt.getBgColor() != null) {
            this.out.write("background-color:");
            ColorTable.colorToHTML(elt.getBgColor(), this.out);
            this.out.write("; ");
        }
        this.out.write("\">\n");
        ++this.divnameCount;
        return eltW;
    }

    protected String openAnchor(String bookmark) {
        return "<a name = \"" + bookmark + "\">";
    }

    protected void writeAlignment(ReportElement elt) throws IOException {
        this.out.write("text-align:");
        this.out.write(ALIGN[elt.getAlign()]);
        this.out.write("; ");
    }

    protected void writeRotateStyle(ReportElement elt) throws IOException {
        if (elt.getRotateAngle() == 0.0) {
            return;
        }
        this.out.write(" ");
        if (elt.getRotateAngle() == 90.0) {
            this.out.write("filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=1); display:block; position:absolute; left:" + QbUtil.toPixel_export(elt.getHeight()) + "px; -webkit-transform: rotate(90deg); -moz-transform: rotate(90deg); -o-transform: rotate(90deg); -ms-transform: rotate(90deg); transform: rotate(90deg);");
        } else {
            this.out.write("filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3); display:block; position:absolute; left:-" + QbUtil.toPixel_export(elt.getHeight()) + "px; -webkit-transform: rotate(-90deg); -moz-transform: rotate(-90deg); -o-transform: rotate(-90deg);  -ms-transform: rotate(-90deg); transform: rotate(-90deg);");
        }
    }

    protected void writeFont(ReportElement elt) throws IOException {
        Font font = elt.getRefFont();
        int size = font.getSize();
        this.out.write("color:");
        ColorTable.colorToHTML(elt.getFontColor(), this.out);
        this.out.write("; ");
        this.out.write("font-family:");
        this.out.write(font.getName());
        this.out.write("; ");
        this.out.write("font-size:");
        this.out.write(Integer.toString(QbUtil.resizeExportFont(size, this.report.isAdjustFont())));
        this.out.write("pt; ");
        this.out.write("font-weight:");
        if (font.isBold()) {
            this.out.write("bold; font-style:");
        } else {
            this.out.write("normal; font-style:");
        }
        if (font.isItalic()) {
            this.out.write("italic; ");
        } else {
            this.out.write("normal; ");
        }
        if (elt.isUnderline()) {
            this.out.write("text-decoration:underline; ");
        }
    }

    private int writePosition(ReportElement elt, int padding, boolean image) throws IOException {
        double xx = this.getX(elt);
        double yy = this.getY(elt);
        double ww = elt.getWidth();
        double hh = elt.getHeight();
        int x = QbUtil.toPixel_export(xx);
        int y = QbUtil.toPixel_export(yy);
        int width = QbUtil.toPixel_export(xx + ww) - x;
        int height = QbUtil.toPixel_export(yy + hh) - y;
        int z = elt.getZ();
        if (elt.hasBorder() && elt.getBorderColor() != null) {
            if (elt.getLeftBorder() > 0 || elt.getRightBorder() > 0) {
                width = width + elt.getLeftBorder() + elt.getRightBorder() - (image ? 0 : 1);
            }
            if (elt.getTopBorder() > 0 || elt.getBottomBorder() > 0) {
                height = height + elt.getTopBorder() + elt.getBottomBorder() - (image ? 0 : 1);
            }
        }
        x += Math.round((float)(elt.getLeftBorder() + elt.getRightBorder()) / 2.0f);
        y += Math.round((float)(elt.getTopBorder() + elt.getBottomBorder()) / 2.0f);
        width = this.replaceNegativeValueByZero(width - (elt.getLeftBorder() + elt.getRightBorder()) - padding);
        height = this.replaceNegativeValueByZero(height - (elt.getTopBorder() + elt.getBottomBorder()));
        if (this.useExternalStyleSheet) {
            this.out.write("position:absolute; ");
        }
        this.writeWidthAndHeight(width, height);
        this.out.write("left:");
        this.out.write(Integer.toString(x));
        if (y >= 0) {
            this.out.write("px; top:");
            this.out.write(Integer.toString(y));
        }
        this.out.write("px; ");
        int zIndex = z + this.zIndexOffset + 1;
        if (zIndex != 1) {
            this.out.write("z-index:");
            this.out.write(Integer.toString(zIndex));
            this.out.write("; ");
        }
        int maxH = height + y;
        if (this.maxYPos < maxH) {
            this.maxYPos = maxH;
        }
        return width;
    }

    private void writeWidthAndHeight(int width, int height) throws IOException {
        this.out.write("width:" + width + "px; ");
        this.out.write("height:" + height + "px; ");
    }

    protected void writeReportGridPosition(ReportGrid elt, ReportTableElement panel, int hBorderThickness, int vBorderThickness) throws IOException {
        int yPos;
        int xPos;
        int height;
        int width;
        double gridheight = elt.getHeight();
        if (elt.getHeight() < 0.0) {
            ReportGrid headNode = elt.getHeadNode();
            gridheight = headNode == elt ? panel.getHeight() - elt.getY() : panel.getHeight();
        }
        if (this.getBorderStyle(elt).equals(BORDER_STYLE_DOUBLE)) {
            width = QbUtil.toPixel_export(elt.getWidth()) + elt.getBorderThickness() * 6;
            height = QbUtil.toPixel_export(gridheight) + elt.getBorderThickness() * 6;
            xPos = QbUtil.toPixel_export(this.getX(elt)) - elt.getBorderThickness() * 3;
            yPos = QbUtil.toPixel_export(this.getY(elt)) - elt.getBorderThickness() * 3;
        } else {
            width = QbUtil.toPixel_export(elt.getWidth()) + elt.getBorderThickness() * 2;
            height = QbUtil.toPixel_export(gridheight) + elt.getBorderThickness() * 2;
            xPos = QbUtil.toPixel_export(this.getX(elt)) - elt.getBorderThickness();
            yPos = QbUtil.toPixel_export(this.getY(elt)) - elt.getBorderThickness();
        }
        width = this.replaceNegativeValueByZero(width - hBorderThickness);
        height = this.replaceNegativeValueByZero(height - vBorderThickness);
        this.out.write("width:");
        this.out.write(Integer.toString(width));
        this.out.write("px; ");
        this.out.write("height:");
        this.out.write(Integer.toString(height));
        this.out.write("px; left:");
        this.out.write(Integer.toString(xPos));
        this.out.write("px; top:");
        this.out.write(Integer.toString(yPos));
        this.out.write("px; ");
        this.out.write("z-index:");
        this.out.write(Integer.toString(elt.getZ() + this.zIndexOffset + 1));
        this.out.write("; ");
    }

    protected void writeReportLinePosition(ReportLine elt, ReportTableElement panel, int wDiff, int hDiff) throws IOException {
        boolean toResize = false;
        int multipler = 1;
        if (this.getBorderStyle(elt).equals(BORDER_STYLE_DOUBLE)) {
            multipler = 3;
        }
        if (!elt.isVertical()) {
            this.out.write("width:");
            this.out.write(Integer.toString(this.replaceNegativeValueByZero(QbUtil.toPixel_export(elt.getWidth()) - wDiff)));
            this.out.write("px; height:");
            this.out.write(Integer.toString(this.replaceNegativeValueByZero((QbUtil.toPixel_export(elt.getHeight()) - 2) * multipler - hDiff)));
            this.out.write("px; left:");
            this.out.write(Integer.toString(QbUtil.toPixel_export(this.getX(elt))));
            this.out.write("px; top:");
            this.out.write(Integer.toString(QbUtil.toPixel_export(this.getY(elt))));
            this.out.write("px; ");
            this.out.write("z-index:");
            this.out.write(Integer.toString(elt.getZ() + this.zIndexOffset + 1));
            this.out.write("; ");
        } else {
            if (elt.getHeight() < 0.0) {
                elt.setHeight(panel.getHeight());
                ReportLine headNode = elt.getHeadNode();
                if (headNode == elt) {
                    elt.setHeight(panel.getHeight() - elt.getY());
                } else {
                    elt.setHeight(panel.getHeight());
                }
                toResize = true;
            }
            this.out.write("width:");
            this.out.write(Integer.toString((QbUtil.toPixel_export(elt.getWidth()) - 2) * multipler - wDiff));
            this.out.write("px; height:");
            this.out.write(Integer.toString(QbUtil.toPixel_export(elt.getHeight()) - hDiff));
            this.out.write("px; left:");
            this.out.write(Integer.toString(QbUtil.toPixel_export(this.getX(elt))));
            this.out.write("px; top:");
            this.out.write(Integer.toString(QbUtil.toPixel_export(this.getY(elt))));
            this.out.write("px; ");
            this.out.write("z-index:");
            this.out.write(Integer.toString(elt.getZ() + this.zIndexOffset + 1));
            this.out.write("; ");
            if (toResize) {
                elt.setHeight(-1.0);
            }
        }
    }

    protected String writeImage(ReportImage image, ReportTable tbl, int row) throws Exception {
        String src = this.getImageURL(image);
        String str = "<img " + this.qt("src", src) + " " + this.qt("border", 0) + " " + this.qt("align", ALIGN[image.getAlign()]) + " " + this.qt("valign", VALIGN[image.getVAlign()]) + " " + this.qt("Title", image.getHint()) + " " + this.qt("height", QbUtil.toPixel_export(image.getHeight())) + " " + this.qt("width", QbUtil.toPixel_export(image.getWidth())) + "/>";
        if (tbl != null) {
            str = this.insertLink(str, image, tbl, row);
        }
        return str;
    }

    private String getImageURL(ReportImage image) throws Exception {
        try {
            if (this.report.exportedFiles == null) {
                this.report.exportedFiles = new Vector();
            }
            if (image.isDBImage()) {
                ReadDataFile rdf = new ReadDataFile();
                DataInputStream fstream = rdf.getInputStream(null, image.getRelativePath());
                ByteArrayOutputStream outstream = new ByteArrayOutputStream(2048);
                boolean more = true;
                while (more) {
                    try {
                        outstream.write(fstream.readByte());
                    }
                    catch (EOFException ex) {
                        LOGGER.log(Level.FINEST, "Failed to write/read data", ex);
                        more = false;
                    }
                }
                fstream.close();
                outstream.close();
                byte[] barray = outstream.toByteArray();
                if (!this.report.isDynamicExport()) {
                    String imgPath = this.getExportedImageURL(image);
                    this.report.exportedFiles.addElement(imgPath);
                    new WriteDataFile().output(null, barray, imgPath, this.report.isDHTMLViewerUsed());
                    fstream.close();
                    return QbUtil.getFileName(imgPath);
                }
                return this.doDynamicImageExport(barray);
            }
            if (image.getBytes() != null) {
                if (!this.report.isDynamicExport()) {
                    String imgPath = this.getExportedImageURL(image);
                    this.report.exportedFiles.addElement(imgPath);
                    new WriteDataFile().output(null, image.getBytes(), imgPath, this.report.isDHTMLViewerUsed());
                    return QbUtil.getFileName(imgPath);
                }
                return this.doDynamicImageExport(image.getBytes());
            }
            if (this.report.getSubFilesTable() != null && ReportGraphics.isImageInMemory(this.report.getSubFilesTable(), image.getImageURL())) {
                byte[] ba = null;
                DataInputStream dis = null;
                ReadDataFile rdf = new ReadDataFile();
                dis = rdf.getInputStream(this.report.getSubFilesTable(), ReportGraphics.getFilePath(image.getImageURL()));
                int length = dis.available();
                ba = new byte[length];
                dis.read(ba, 0, length);
                dis.close();
                if (!this.report.isDynamicExport()) {
                    String imgPath = this.getExportedImageURL(image);
                    this.report.exportedFiles.addElement(imgPath);
                    new WriteDataFile().output(null, ba, imgPath, this.report.isDHTMLViewerUsed());
                    return QbUtil.getFileName(imgPath);
                }
                return this.doDynamicImageExport(ba);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, "Cannot get image", e);
        }
        String imagePath = image.getImagePath();
        try {
            if (imagePath != null) {
                if (imagePath.startsWith("http://") || imagePath.startsWith("https://")) {
                    return imagePath;
                }
                imagePath = imagePath.replace('\\', '/');
                if (this.report.isHttpsDynamicExport()) {
                    String prefix = "https://" + this.report.getHttpsServerName() + ":" + this.report.getHttpsServletRunnerPort() + "/" + this.report.getServletDirectory().substring(0, this.report.getServletDirectory().indexOf("servlet"));
                    return prefix + imagePath;
                }
                if (this.report.isDynamicExport) {
                    String prefix = this.report.protocol + this.report.serverName + ":" + this.report.servletRunnerPort + "/" + this.report.getServletDirectory().substring(0, this.report.getServletDirectory().indexOf("servlet"));
                    return prefix + imagePath;
                }
                if (ServerMessage.isWebApp) {
                    return ServerMessage.getServerInfo() + ServerMessage.getContext() + imagePath;
                }
                FileInfo file = new FileInfo(imagePath);
                if (!file.isDirectory() && imagePath.indexOf(58) < 0) {
                    return "file:///" + file.getAbsolutePath();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to get image URL", ex);
        }
        if (image.getImageURL() != null) {
            return QbUtil.fixUrlString(image.getImageURL().toString());
        }
        return image.getImagePath();
    }

    private String getExportedImageURL(ReportImage reportImage) {
        String imagePath = this.imageName + this.imageCount + "." + QbUtil.getExtension(reportImage.getImagePath());
        ++this.imageCount;
        return imagePath;
    }

    protected String writeChart(ReportChartObject chart, ReportTable tbl, ReportCell[] cells, int row) {
        try {
            String imgURL = null;
            String imgPath = null;
            Report temp_report = this.report;
            byte[][] image = null;
            int[] mapping = null;
            String linkPrefix = "";
            if (chart.isSecurityTextScript()) {
                this.writeText(chart, tbl, row);
                return "";
            }
            if (chart.getDrillDownName() != null) {
                try {
                    DrillDownNode node = this.getDrillDownNode(chart);
                    mapping = node.getColumnMapping();
                    linkPrefix = node.getServletLink(this.report, this.ddBytesSentToServlet, this.getExtension());
                    if (this.report.isDHTMLViewerUsed()) {
                        linkPrefix = "#\" onclick=\"moveToPage('" + linkPrefix + "&ExportToMultiPages=" + this.report.isExportToMultiPages() + "&CurrentAction=drillDown";
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINEST, "Failed to get drill-down link prefix", e);
                }
            }
            if (!this.report.isDynamicExport()) {
                imgPath = chart.getSavedFileLocation();
                imgURL = chart.getSavedFileURL();
                if (imgPath == null || imgURL == null) {
                    imgPath = this.imageName + this.imageCount;
                    imgURL = ChartObject.getChartName(this.imageName + this.imageCount, chart.getImageType());
                } else {
                    imgPath = imgPath + this.imageCount;
                    imgURL = ChartObject.addExtension(imgURL + this.imageCount, chart.getImageType());
                }
                if (this.report.exportedFiles == null) {
                    this.report.exportedFiles = new Vector();
                }
                this.report.exportedFiles.addElement(ChartObject.addExtension(imgPath, chart.getImageType()));
                ChartObject.export(imgPath, chart.getImageType(), temp_report, tbl, cells, chart, QbUtil.toPixel_export(chart.getWidth()), QbUtil.toPixel_export(chart.getHeight()), mapping, linkPrefix, this.report.getHTMLTarget());
            } else {
                image = ChartObject.export(chart.getImageType(), temp_report, tbl, cells, chart, QbUtil.toPixel_export(chart.getWidth()), QbUtil.toPixel_export(chart.getHeight()), mapping, linkPrefix, this.report.getHTMLTarget(), ChartObject.getChartName(chart.getText(), false) + this.imageCount);
                imgURL = this.doDynamicImageExport(image[0]);
            }
            StringBuffer str = null;
            if (chart.getImageType() != 15) {
                str = new StringBuffer("<img " + this.qt("src", imgURL) + " " + this.qt("align", ALIGN[chart.getAlign()]) + " " + this.qt("valign", VALIGN[chart.getVAlign()]) + " " + this.qt("title", chart.getHint()) + " " + this.qt("border", 0) + " " + this.qt("height", QbUtil.toPixel_export(chart.getHeight())) + " " + this.qt("width", QbUtil.toPixel_export(chart.getWidth())) + " ");
                String mapFile = null;
                if (!this.report.isDynamicExport()) {
                    mapFile = imgPath + ".map";
                    if (new FileInfo(mapFile).exists()) {
                        str.append(this.qt("usemap", "#" + ChartObject.getChartName(imgPath, false)));
                    } else {
                        mapFile = null;
                    }
                } else if (image != null && image[1] != null) {
                    str.append(this.qt("usemap", "#" + ChartObject.getChartName(chart.getText(), false) + this.imageCount));
                }
                str.append(">");
                InputStream inSt = null;
                ReadDataFile readDataFile = null;
                if (mapFile != null) {
                    readDataFile = new ReadDataFile();
                    inSt = readDataFile.getInputStream(null, mapFile, true);
                } else if (image != null && image[1] != null) {
                    inSt = new ByteArrayInputStream(image[1]);
                }
                if (inSt != null) {
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inSt));
                        String tmp = reader.readLine();
                        while (tmp != null) {
                            str.append(tmp);
                            tmp = reader.readLine();
                        }
                        reader.close();
                        inSt.close();
                        if (readDataFile != null) {
                            readDataFile.close();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Can't read image file", ex);
                    }
                }
                str.append("</IMG>");
            } else {
                str = new StringBuffer();
                LOGGER.finest("Image path: " + imgPath);
                LOGGER.finest("Image URL: " + imgURL);
                String flashFile = null;
                flashFile = imgPath != null ? ChartObject.getChartName(imgPath, false) + this.imageCount + ".swf" : imgURL;
                LOGGER.finest("Flash file: " + flashFile);
                int height = QbUtil.toPixel_export(chart.getHeight());
                int width = QbUtil.toPixel_export(chart.getWidth());
                str.append("<object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" ");
                str.append(" codebase=\"https://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=5,0,0,0\" ");
                str.append(" width=\"" + width + "\" height=\"" + height + "\">");
                str.append("<param name=movie value=\"" + flashFile + "\">");
                str.append("<param name=quality value=high>");
                str.append("<embed src=\"" + flashFile + "\"");
                str.append(" quality=high pluginspage=\"https://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\" ");
                str.append("type=\"application/x-shockwave-flash\" width=\"" + width + "\" height=\"" + height + "\"></embed> </object>");
            }
            ++this.imageCount;
            return this.insertLink(str.toString(), chart, tbl, row);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to write chart", e);
            try {
                this.writeText(chart, tbl, row);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to write text", ex);
            }
            return "";
        }
    }

    protected void writeText(ReportElement elt, ReportTable tbl, int row) throws Exception {
        this.writeText(elt, tbl, row, -1);
    }

    protected void writeText(ReportElement elt, ReportTable tbl, int row, int eltW) throws Exception {
        if (elt.getFontColor() == null) {
            return;
        }
        Font font = elt.getRefFontToDraw(this.report.isAdjustFont());
        String text = elt.getText();
        if (this.reportUI.report.getStringCustomizer() != null) {
            text = this.reportUI.report.getStringCustomizer().encodeString(text);
        }
        FontMetrics fm = this.getFontMetrics(font);
        int w = QbUtil.toPixel_export(elt.getWidth());
        int h = QbUtil.toPixel_export(elt.getHeight());
        short align = elt.getAlign();
        int offset = 3;
        double rotation = elt.getRotateAngle();
        if (rotation != 0.0) {
            if ((rotation %= 360.0) < 0.0) {
                rotation += 360.0;
            }
            if (align == 1 || align == 2) {
                h -= offset;
            }
        } else if (align == 1) {
            w -= offset;
        } else if (align == 2) {
            w -= offset;
        }
        if (w < 1) {
            w = 1;
        }
        String[] strList = rotation != 0.0 ? ReportGraphics.tokenizer(text, fm, h, elt.isNoWrap()) : ReportGraphics.tokenizer(text, fm, w, elt.isNoWrap());
        for (int i = 0; i < strList.length; ++i) {
            strList[i] = QbUtil.escapeHTML(strList[i]);
        }
        StringBuffer strBuf = new StringBuffer();
        int charH = fm.getMaxAscent() + fm.getMaxDescent();
        int txtH = charH * strList.length;
        for (int i = 0; i < strList.length; ++i) {
            if (rotation == 0.0 && i != 0 && charH * (i + 1) > QbUtil.toPixel(elt.getHeight())) {
                i = strList.length;
                txtH = charH * (i + 1);
                continue;
            }
            if (rotation != 0.0 && i != 0 && charH * (i + 1) > QbUtil.toPixel(elt.getWidth())) {
                i = strList.length;
                txtH = charH * (i + 1);
                continue;
            }
            strBuf.append(strList[i]).append(this.writeBrTag());
        }
        String str = QbUtil.replace(strBuf.toString(), "\n", this.writeBrTag());
        str = QbUtil.replace(str, "  ", " &nbsp;");
        str = this.insertLink(str, elt, tbl, row);
        int width = QbUtil.toPixel_export(elt.getWidth());
        int height = QbUtil.toPixel_export(elt.getHeight());
        if (elt.hasBorder() && elt.getBorderColor() != null) {
            --width;
            --height;
        }
        String nowrap = "";
        if (elt.isNoWrap()) {
            nowrap = "NOWRAP";
        }
        if (elt.getAlign() == 1) {
            width -= 4;
        }
        if (eltW > 0) {
            width = eltW;
        }
        this.out.write("<table style=\"height:100%;width:100%;\" cellpadding=\"0\" cellspacing=\"0\">");
        boolean div = false;
        CSSStyle style = new CSSStyle(elt);
        if (this.hasValidStyleName(style)) {
            this.out.write("<tr><td valign=\"" + VALIGN[elt.getVAlign()] + "\" width=\"" + width + "\" " + nowrap + " class=\"");
            this.out.write(this.getStyleName(style) + "\" style=\"padding:0px; border-width:0px; background-color:transparent; ");
            if (elt.getRotateAngle() == 90.0) {
                this.out.write("width:" + height + "px; height:" + width + "px;");
                if (elt.getVAlign() == 0) {
                    this.out.write("\"");
                    div = true;
                    this.out.write("><div style=\"padding:0px; border-width:0px; position: absolute; ");
                    this.out.write("width:" + height + "px; height:" + width + "px;");
                    this.out.write("top: " + (width - txtH) / 2 + "px;");
                } else if (elt.getVAlign() == 2) {
                    this.out.write("\"");
                    div = true;
                    this.out.write("><div style=\"padding:0px; border-width:0px; position: absolute; ");
                    this.out.write("width:" + height + "px; height:" + width + "px;");
                    this.out.write("top: " + (width - txtH) + "px;");
                }
            } else if (elt.getRotateAngle() == -90.0) {
                this.out.write("width:" + height + "px; height:" + width + "px;");
                if (elt.getVAlign() == 0) {
                    this.out.write("left: " + (width - txtH) / 2 + "px;");
                } else if (elt.getVAlign() == 2) {
                    this.out.write("left: " + (width - txtH) + "px;");
                }
            } else if (elt.getVAlign() == 0) {
                this.out.write("top: " + (height - txtH) / 2 + "px;");
            } else if (elt.getVAlign() == 2) {
                this.out.write("top: " + (height - txtH) + "px;");
            }
            this.out.write("\"");
        } else {
            this.out.write("<tr><td valign=\"" + VALIGN[elt.getVAlign()] + "\" " + nowrap + " style=\"");
            this.writeFont(elt);
            this.out.write(" ");
            this.writeAlignment(elt);
            this.writeRotateStyle(elt);
            this.out.write("\"");
        }
        this.out.write(">" + str);
        if (div) {
            this.out.write(this.writeCloseDivTag());
        }
        this.out.write("</td></tr></table>");
    }

    protected String writeBrTag() {
        return "<br/>";
    }

    protected void writeReportGrid(ReportGrid reportgrid, ReportTableElement panel) throws IOException {
        if (!(reportgrid.getBorderColor() != null && reportgrid.hasBorder() || reportgrid.getBgColor() != null)) {
            return;
        }
        CSSStyle style = new CSSStyle(reportgrid);
        String styleName = this.getStyleName(style);
        String div = "<div id=\"DivName" + Integer.toString(this.divnameCount) + "\"";
        if (this.hasValidStyleName(style) || reportgrid.getRoundCornerRadius() > 0) {
            if (style.getRoundCornerRadius() > 0 || reportgrid.getRoundCornerRadius() > 0) {
                this.out.write(DHTMLReport.writeOpenVMLShapeTag(styleName));
            } else {
                this.out.write(div + " class=\"" + styleName + "\" ");
            }
        } else {
            this.out.write(div);
        }
        this.out.write("style=\"position:absolute; ");
        int tk = reportgrid.getBorderThickness();
        if (this.getBorderStyle(reportgrid).equals(BORDER_STYLE_DOUBLE)) {
            tk *= 3;
        }
        int vborderTk = 0;
        if (reportgrid.previous() != null) {
            vborderTk = tk;
        }
        if (reportgrid.next() != null) {
            vborderTk += tk;
        }
        this.writeReportGridPosition(reportgrid, panel, tk * 2, vborderTk);
        this.out.write("margin:0px; padding:0px; ");
        if (reportgrid.getBgColor() != null) {
            this.out.write("background-color:");
            ColorTable.colorToHTML(reportgrid.getBgColor(), this.out);
            this.out.write("; ");
        }
        this.out.write("border-style:");
        String borderStyle = this.getBorderStyle(reportgrid);
        int doubleBorderThicknessModif = BORDER_STYLE_DOUBLE.equals(borderStyle) ? 3 : 1;
        this.out.write(borderStyle);
        this.out.write("; border-color:");
        ColorTable.colorToHTML(reportgrid.getBorderColor(), this.out);
        this.out.write("; ");
        this.out.write("border-width:");
        this.out.write(Integer.toString(reportgrid.previous() != null ? 0 : doubleBorderThicknessModif * reportgrid.getTopBorder()));
        this.out.write("px ");
        this.out.write(Integer.toString(doubleBorderThicknessModif * reportgrid.getRightBorder()));
        this.out.write("px ");
        this.out.write(Integer.toString(reportgrid.next() != null ? 0 : doubleBorderThicknessModif * reportgrid.getBottomBorder()));
        this.out.write("px ");
        this.out.write(Integer.toString(doubleBorderThicknessModif * reportgrid.getLeftBorder()));
        this.out.write("px; \">");
        ++this.divnameCount;
        this.out.write("<img height=1 width=1 border=0 />\n");
        if (reportgrid.getRoundCornerRadius() > 0) {
            this.out.write(DHTMLReport.writeVMLStrokeTag(style));
            this.out.write(DHTMLReport.writeCloseVMLShapeTag());
        } else {
            this.out.write(this.writeCloseDivTag());
        }
    }

    protected void writeReportLine(ReportLine reportline, ReportTableElement panel) throws IOException {
        if (reportline.isVertical() && QbUtil.toPixel_export(reportline.getWidth()) <= 2 || !reportline.isVertical() && QbUtil.toPixel_export(reportline.getHeight()) <= 2 || reportline.getBgColor() == null) {
            return;
        }
        int hDiff = 0;
        int wDiff = 0;
        String borderStyle = this.getBorderStyle(reportline);
        if (!reportline.isVertical()) {
            hDiff = borderStyle.equals(BORDER_STYLE_DOUBLE) ? 3 * (QbUtil.toPixel_export(reportline.getHeight()) - 2) : QbUtil.toPixel_export(reportline.getHeight()) - 2;
        } else {
            wDiff = borderStyle.equals(BORDER_STYLE_DOUBLE) ? 3 * (QbUtil.toPixel_export(reportline.getWidth()) - 2) : QbUtil.toPixel_export(reportline.getWidth()) - 2;
        }
        this.out.write("<div id=\"DivName");
        this.out.write(Integer.toString(this.divnameCount));
        this.out.write("\" style=\"position:absolute; ");
        this.writeReportLinePosition(reportline, panel, wDiff, hDiff);
        this.out.write("margin:0px; padding:0px; border-style:");
        this.out.write(borderStyle);
        this.out.write("; ");
        if (!reportline.isVertical()) {
            if (borderStyle.equals(BORDER_STYLE_DOUBLE)) {
                this.out.write("border-width:");
                this.out.write(Integer.toString(hDiff));
                this.out.write("px 0px 0px 0px; ");
            } else {
                this.out.write("border-width:");
                this.out.write(Integer.toString(hDiff));
                this.out.write("px 0px 0px 0px; ");
            }
        } else {
            this.out.write("border-width:0px 0px 0px ");
            this.out.write(Integer.toString(wDiff));
            this.out.write("px; ");
        }
        this.out.write("border-color:");
        ColorTable.colorToHTML(reportline.getBgColor(), this.out);
        this.out.write("; ");
        this.out.write("\">");
        ++this.divnameCount;
        this.out.write("<img height=1 width=1 border=0>" + this.writeCloseDivTag());
    }

    protected String getBorderStyle(ReportElement reportelement) {
        String s = "";
        if (reportelement instanceof ReportLine) {
            s = ((ReportLine)reportelement).getLineStyle() == 2 ? BORDER_STYLE_DOUBLE : (((ReportLine)reportelement).getLineStyle() == 3 ? "dashed" : "solid");
        } else if (reportelement instanceof ReportGrid) {
            s = ((ReportGrid)reportelement).getGridStyle() == 2 ? BORDER_STYLE_DOUBLE : (((ReportGrid)reportelement).getGridStyle() == 3 ? "dashed" : "solid");
        }
        return s;
    }

    protected String qt(String key, int value) {
        return this.qt(key, value + "");
    }

    protected String qt(String key, String value) {
        return value.equals("") ? "" : key + "=\"" + value + "\"";
    }

    private static String colorFragmentToHTML(int i) {
        String color = "";
        if (i == 0) {
            return "00";
        }
        if (i < 16) {
            color = "0";
        } else if (i > 255) {
            return "ff";
        }
        color = color + Integer.toHexString(i);
        return color;
    }

    public static String colorToHTML(Color c) {
        if (c == null) {
            return "";
        }
        return "#" + DHTMLReport.colorFragmentToHTML(c.getRed()) + DHTMLReport.colorFragmentToHTML(c.getGreen()) + DHTMLReport.colorFragmentToHTML(c.getBlue());
    }

    protected String insertLink(String body, ReportElement elt, ReportTable tbl, int row) {
        if (elt instanceof ReportCell && ((ReportCell)elt).getEntry() != null) {
            Bookmark entry = ((ReportCell)elt).getEntry();
            String filename = this.getRelativeFileName(this.originalFileName);
            if (this.report.isExportToMultiPages() && entry.getPageNumber() > 1) {
                filename = this.getRelativeFileName(DHTMLReport.getFileName(this.prefix, entry.getPageNumber(), 4));
                if (entry.getPageNumber() == this.totalPageNumber) {
                    filename = this.getRelativeFileName(this.lastFileName);
                }
            }
            String anchor = "";
            anchor = !this.report.getTableOfContentsObject().isUseGroups() ? entry.getTitle() : entry.getKey();
            if (this.report.getHTMLLinksProvider() != null) {
                HTMLBlock block = this.report.getHTMLLinksProvider().getTOCLinkForDHTML(entry.getPageNumber(), this.totalPageNumber, body);
                LOGGER.finest("Link: " + block.getText());
                return block.getText();
            }
            if (this.totalPageNumber == 1) {
                return "<a href=\"#" + anchor + "\">" + body + "</a>";
            }
            if (filename == null || filename.startsWith("null")) {
                LOGGER.warning("Filename is null and HTMLLinksProvider not defined => there will be links in TOC.");
                return body;
            }
            return "<a href=\"" + filename + "#" + anchor + "\">" + body + "</a>";
        }
        if (elt.getDrillDownName() == null) {
            if (elt.getLink().trim().equals("") && elt.getHint().trim().equals("")) {
                return body;
            }
            if (elt.getLink().startsWith("#")) {
                return "<a href=\"" + elt.getLink() + "\" title=\"" + elt.getHint() + "\" alt=\"" + elt.getHint() + "\">" + body + "</a>";
            }
            if (!elt.getLink().trim().equals("")) {
                String targetstring = "";
                if (!elt.getTarget().trim().equals("")) {
                    targetstring = "target=\"" + elt.getTarget() + "\"";
                }
                return "<a " + targetstring + " href=\"" + elt.getLink() + "\" title=\"" + elt.getHint() + "\" alt=\"" + elt.getHint() + "\">" + body + "</a>";
            }
            return "<a title=\"" + elt.getHint() + "\" alt=\"" + elt.getHint() + "\">" + body + "</a>";
        }
        if (elt instanceof ReportChartObject) {
            return body;
        }
        try {
            DrillDownNode node = this.getDrillDownNode(elt);
            if (!node.isValidDrillDownNode()) {
                return body;
            }
            node.setSubReportPath(this.report.getSubReportPath());
            int[] mapping = node.getColumnMapping();
            ReportTable tempTable = tbl;
            while (tempTable instanceof ReportTreeTable) {
                tempTable = ((ReportTreeTable)tempTable).getSubTable(0);
            }
            String parameters = "";
            boolean useDHTMLViewer = this.report.isDHTMLViewerUsed();
            String hideParams = "";
            for (int i = 0; i < mapping.length; ++i) {
                Object value;
                block35: {
                    value = null;
                    if (mapping[i] < 0) {
                        if (useDHTMLViewer) continue;
                        value = "UnMapped";
                        parameters = parameters + "&PARAM" + i + "=" + QbUtil.urlEncode(DataType.write(value));
                        continue;
                    }
                    if (mapping[i] >= 1000 && mapping[i] < 2000) {
                        value = this.report.getQueryParameters().elementAt(mapping[i] - 1000).getValue();
                    } else if (mapping[i] >= 2000) {
                        value = this.report.getFormulaParameters().elementAt(mapping[i] - 2000).getValue();
                    } else if (node.isCrossTabDrillDown()) {
                        if (this.report.colInfo[mapping[i]].isColumnBreak() && ((ReportCell)elt).getColumn() instanceof ColumnBreakColumn) {
                            for (ColData element : this.report.colData) {
                                if (!this.report.colInfo[mapping[i]].getName().equals(element.getName())) continue;
                                for (int n = 0; n < element.getSize(); ++n) {
                                    if (!element.getData(n).toString().equalsIgnoreCase(((ColumnBreakColumn)((ReportCell)elt).getColumn()).getText(this.report, mapping[i]).toString())) continue;
                                    value = element.getData(n);
                                    break block35;
                                }
                                break;
                            }
                        } else if (!this.report.getColumnType(this.report.getColInfoIndex(((ReportCell)elt).getColumn())).equalsIgnoreCase("ROW BREAK")) {
                            value = tempTable.getColumn(this.report.getColumnIndex(mapping[i])).getData(0);
                        }
                    } else {
                        value = tempTable.getColumn(this.report.getColumnIndex(mapping[i])).getDrillDownData(row);
                    }
                }
                if (value == null) {
                    return "<A title=\"" + node.getUserObject() + "\" alt=\"" + node.getUserObject() + "\">" + body + "</a>";
                }
                parameters = parameters + "&PARAM" + i + "=" + QbUtil.urlEncode(DataType.write(value));
                hideParams = hideParams + "&HIDE_PARAM" + i + "=true";
            }
            String link = node.getServletLink(this.report, this.ddBytesSentToServlet, this.getExtension());
            if (!parameters.equals("")) {
                link = link + parameters + "&CHARSET=" + (this.report.getHTMLCharset() == null ? "UTF-8" : this.report.getHTMLCharset());
            }
            if (this.report.getDrillDownConnection() != null) {
                link = link + "&DRILLDOWNCONN=true";
            }
            if (this.report.getDrillDownDatabaseInfo() != null) {
                link = link + "&DRILLDOWNDATABASEINFO=true";
            }
            if (this.useExternalStyleSheet) {
                link = link + "&ExternalStyleSheet=" + this.report.getExternalStyleSheetName();
            }
            if (useDHTMLViewer) {
                link = "#\" onclick=\"moveToPage('" + link + "&ExportToMultiPages=" + this.report.isExportToMultiPages() + "&CurrentAction=drillDown";
                link = link + hideParams + "'); return false;";
            }
            return "<A href=\"" + link + "\" title=\"" + node.getUserObject() + "\" target=\"" + this.report.getHTMLTarget() + "\" alt=\"" + node.getUserObject() + "\">" + body + "</a>";
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed to insert drill-down links", e);
            return body;
        }
    }

    private DrillDownNode getDrillDownNode(ReportElement elt) {
        DrillDownNode node = null;
        DrillDownNode parentNode = this.report.currentNode;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            if (!elt.getDrillDownName().equals(parentNode.getChildAt(i).getName())) continue;
            node = parentNode.getChildAt(i);
            i = parentNode.getChildCount();
        }
        return node;
    }

    protected int getPage() {
        if (!this.resetPageNumber) {
            return this.currentPageNumber;
        }
        if (this.pageLookup != null && this.pageLookup.containsKey(this.currentPageNumber)) {
            int[] pages = this.pageLookup.get(this.currentPageNumber);
            if (pages != null && pages.length == 2) {
                return pages[0];
            }
            return this.currentPageNumber;
        }
        return this.currentPageNumber;
    }

    protected int getTotalPageNumber() {
        if (!this.resetPageNumber) {
            return this.totalPageNumber;
        }
        if (this.pageLookup != null && this.pageLookup.containsKey(this.currentPageNumber)) {
            int[] pages = this.pageLookup.get(this.currentPageNumber);
            if (pages != null && pages.length == 2) {
                return pages[1];
            }
            return this.currentPageNumber;
        }
        return this.currentPageNumber;
    }

    protected static String getFileName(String prefix, int fileNumber, int type) {
        String newPrefix = prefix + "_" + fileNumber;
        return Report.getFullName(newPrefix, type);
    }

    protected String getRelativeFileName(String fileName) {
        if (fileName == null) {
            return fileName;
        }
        String name = fileName.replace('\\', '/');
        int index = name.lastIndexOf(47);
        if (index > 0) {
            name = name.substring(index + 1);
        }
        return QbUtil.convertToHTMLFileName(name);
    }

    protected double getX(ReportElement elt) {
        if (elt == null) {
            return this.elementXPos + this.leftMargin;
        }
        return this.elementXPos + this.leftMargin + elt.getX();
    }

    protected double getY(ReportElement elt) {
        double offset = 0.0;
        if (elt != null) {
            offset = elt.getY();
        }
        if (this.report.isExportToMultiPages()) {
            offset += this.linksHeight;
        }
        if (this.currentPageNumber == 1 || this.report.isDHTMLTopMarginRepeatOnEveryPage()) {
            return this.elementYPos + this.topMargin + this.report.getDHTMLTopMargin() + offset;
        }
        return this.elementYPos + this.topMargin + offset;
    }

    private void endPage() throws Exception {
        this.elementXPos = 0.0;
        this.elementYPos = (this.report.getPageHeight() - DHTMLReport.getBrowserMargin()) * (double)(this.currentPageNumber - 1) + this.pageHeight;
        this.writeSection(this.report.getPageFooter(), this.fTable, false);
        this.writeWaterMark(contactText, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCurrentFileOutput() throws Exception {
        this.elementXPos = 0.0;
        this.elementYPos = this.pageHeight;
        this.writeSection(this.report.getPageFooter(), this.fTable, false);
        this.writeWaterMark(contactText, false);
        this.writeReportContainerDiv(false);
        this.writeLinks(false);
        if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage) {
            block25: {
                this.writeTailTag();
                if (this.out instanceof StringWriter && !this.exportSpecificPage) {
                    String content = this.out.toString();
                    try {
                        if (this.currentPageNumber > 1) {
                            LOGGER.finest("Export " + Report.getFullName(this.prefix + this.currentPageNumber, this.getExtension()) + ": " + (double)(System.currentTimeMillis() - this.exportTime) / 1000.0);
                            if (this.report.getExportEncoding() != null) {
                                byte[] pageData = content.getBytes(this.report.getExportEncoding());
                                if (this.exportThread.isQueueFull(pageData.length)) {
                                    Object tmpLock = this.exportThread.getLockForMainThread();
                                    if (this.lockObjects != null) {
                                        this.lockObjects.add(tmpLock);
                                    }
                                    Object object = tmpLock;
                                    synchronized (object) {
                                        try {
                                            tmpLock.wait();
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                    if (this.lockObjects != null) {
                                        this.lockObjects.remove(tmpLock);
                                    }
                                }
                                this.exportThread.queue(pageData, DHTMLReport.getFileName(this.prefix, this.currentPageNumber, this.getExtension()));
                            } else {
                                byte[] pageData = content.getBytes();
                                if (this.exportThread.isQueueFull(pageData.length)) {
                                    Object tmpLock = this.exportThread.getLockForMainThread();
                                    if (this.lockObjects != null) {
                                        this.lockObjects.add(tmpLock);
                                    }
                                    Object object = tmpLock;
                                    synchronized (object) {
                                        try {
                                            tmpLock.wait();
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                    if (this.lockObjects != null) {
                                        this.lockObjects.remove(tmpLock);
                                    }
                                }
                                this.exportThread.queue(pageData, DHTMLReport.getFileName(this.prefix, this.currentPageNumber, this.getExtension()));
                            }
                            this.exportTime = System.currentTimeMillis();
                            break block25;
                        }
                        LOGGER.finest("Export " + Report.getFullName(this.prefix + "_FIRST", this.getExtension()) + ": " + (double)(System.currentTimeMillis() - this.exportTime) / 1000.0);
                        String fname = Report.getFullName(this.prefix + "_FIRST", this.getExtension());
                        if (this.report.getExportEncoding() != null) {
                            new WriteDataFile().output(null, content.getBytes(this.report.getExportEncoding()), fname, this.report.isDHTMLViewerUsed());
                        } else {
                            new WriteDataFile().output(null, content.getBytes(), fname, this.report.isDHTMLViewerUsed());
                        }
                        this.exportTime = System.currentTimeMillis();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Cannot close output file", ex);
                        this.out.close();
                        throw ex;
                    }
                }
            }
            this.out.flush();
            this.out.close();
        }
    }

    private void startNewFileOutput() throws Exception {
        if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage) {
            if (this.exportSpecificPage && this.currentPageNumber == this.exportPage) {
                this.out = this.report.getExportEncoding() != null ? new PrintWriter((Writer)new OutputStreamWriter(this.outStream, this.report.getExportEncoding()), true) : new PrintWriter(this.outStream, true);
            } else {
                if (this.exportSpecificPage && this.currentPageNumber > this.exportPage) {
                    LOGGER.finest("Throw finished specific page exception");
                    throw new FinishedSpecificPageException();
                }
                this.out = new StringWriter();
            }
        }
        this.writeHeadTag();
        this.writeWaterMark(evalText, true);
        this.elementXPos = 0.0;
        this.elementYPos = 0.0;
        this.writeLinks(true);
        this.writeReportContainerDiv(true);
        this.pageHeaderHeight = this.writeSection(this.report.getPageHeader(), this.hTable);
    }

    private void startNewPage() throws Exception {
        this.elementXPos = 0.0;
        this.elementYPos = (this.report.getPageHeight() - DHTMLReport.getBrowserMargin()) * (double)(this.currentPageNumber - 1);
        this.writeWaterMark(evalText, false);
        this.pageHeaderHeight = this.writeSection(this.report.getPageHeader(), this.hTable, false);
    }

    protected void writeHeadTag() throws IOException {
        if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage) {
            if (this.report.isHeadTagIncluded()) {
                if (this.isSliderFeature) {
                    this.out.write(DHTMLReportWithSlider.HEADER_TAG);
                } else {
                    this.out.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
                    this.out.write("<html>\n");
                }
                this.out.write("<head>\n");
                this.out.write("<meta name=\"GENERATOR\" content=\"EspressReport\">\n");
                this.out.write("<meta http-equiv=\"content-type\" content=\"text/css; charset=");
                this.out.write(this.report.getHTMLCharset() == null ? "UTF-8" : this.report.getHTMLCharset());
                this.out.write("\">\n");
                this.out.write("<title>" + QbUtil.escapeHTML(this.report.getHTMLTitle() == null ? this.report.getName() : this.report.getHTMLTitle()) + "</title>\n");
                if (this.isSliderFeature) {
                    this.out.write(DHTMLReportWithSlider.get_JQUERY_SCRIPT_OPEN_TAG(this.report.isAnimationOnForExpandAndCollapse(), this.report.isEmbeddedScriptWithInThePage()));
                    ReportTable tbl = this.report.getReportTables().elementAt(0);
                    this.writeDivTable(tbl);
                    this.out.write(DHTMLReportWithSlider.get_JQUERY_SCRIPT_CLOSE_TAG(this.report.isAnimationOnForExpandAndCollapse()));
                }
                if (this.report.getExternalStyleSheetName() != null) {
                    this.out.write(this.writeExternalStyles());
                }
                this.out.write(this.writeInternalStyles());
                if (this.useVML) {
                    this.out.write("<xml:namespace ns=\"urn:schemas-microsoft-com:vml\" prefix=\"v\" />\n");
                    this.out.write(this.writeJavascriptRoundCornersFunctions());
                }
                this.out.write("</head>\n");
            }
            if (this.report.isBackgroundTagIncluded()) {
                this.writeBackgroundTag(this.out);
            }
        }
    }

    private boolean isExpand(int level) {
        return this.expandAll || level <= this.expandToGroupLevel;
    }

    private void writeDivTable(ReportTable tbl) throws IOException {
        boolean animationOn = this.report.isAnimationOnForExpandAndCollapse();
        if (!animationOn) {
            this.out.write("function initExpandAndCollapse() {\n");
        }
        this.writeDivTable(tbl, 0, 0, this.getLevelCount(tbl));
        if (!animationOn) {
            this.out.write("}\n\n");
        }
    }

    private int writeDivTable(ReportTable tbl, int count, int level, int maxLevel) throws IOException {
        boolean containSect;
        boolean animationOn = this.report.isAnimationOnForExpandAndCollapse();
        boolean bl = containSect = !this.hasNoDataExcludeSubReport(tbl.getFooter()) || !this.hasNoDataExcludeSubReport(tbl.getHeader());
        if (tbl instanceof ReportTreeTable) {
            ReportTreeTable sTbl = (ReportTreeTable)tbl;
            if (sTbl.isVisible()) {
                if (level < maxLevel && containSect && !this.isExpand(level)) {
                    if (animationOn) {
                        this.out.write("animatedcollapse.addDiv('SLIDER_" + this.rptName + "_TBL_" + count + "', 'fade=1,speed=400,hide=1')\n");
                    } else {
                        this.out.write("document.getElementById(\"SLIDER_" + this.rptName + "_TBL_" + count + "\").style.display = \"none\";\n");
                    }
                } else if (animationOn) {
                    this.out.write("animatedcollapse.addDiv('SLIDER_" + this.rptName + "_TBL_" + count + "', 'fade=1,speed=400,hide=0')\n");
                }
                ++count;
                ++level;
                if (this.report.getReportType() == 2 && sTbl.countSubTable() == 1 && !(sTbl.getSubTable(0) instanceof ReportTreeTable)) {
                    return count;
                }
                for (int i = 0; i < sTbl.countSubTable(); ++i) {
                    count = this.writeDivTable(sTbl.getSubTable(i), count, level, maxLevel);
                }
            }
        } else if (tbl.isVisible()) {
            if (this.report.getReportType() != 2) {
                if (level < maxLevel && containSect && !this.isExpand(level)) {
                    if (animationOn) {
                        this.out.write("animatedcollapse.addDiv('SLIDER_" + this.rptName + "_TBL_" + count + "', 'fade=1,speed=400,hide=1')\n");
                    } else {
                        this.out.write("document.getElementById(\"SLIDER_" + this.rptName + "_TBL_" + count + "\").style.display = \"none\";\n");
                    }
                } else if (animationOn) {
                    this.out.write("animatedcollapse.addDiv('SLIDER_" + this.rptName + "_TBL_" + count + "', 'fade=1,speed=400,hide=0')\n");
                }
            }
            ++count;
        }
        return count;
    }

    private String writeJavascriptRoundCornersFunctions() {
        StringBuffer str = new StringBuffer();
        str.append("<script type=\"text/javascript\">\n");
        str.append("function drawPath(type,ltop,rtop,rbot,lbot) {\n");
        str.append("var path = '';\n");
        str.append("var d = document;\n");
        str.append("var shapeTypeEl = d.getElementById(type);\n");
        str.append("if(shapeTypeEl) {\n");
        str.append("var shapes = d.getElementsByTagName(\"shape\");\n");
        str.append("for(var i=0; i<shapes.length; i++) {\n");
        str.append("var shapeEl = shapes[i];\n");
        str.append("if(shapeEl && shapeEl.className == (\"QB-round-\" + type + \" \" + type)) {\n");
        str.append("var w = shapeEl.offsetWidth + parseInt(shapeEl.style.paddingLeft ? shapeEl.style.paddingLeft : 0) + parseInt(shapeEl.style.paddingRight ? shapeEl.style.paddingRight : 0);\n");
        str.append("var h = shapeEl.offsetHeight + parseInt(shapeEl.style.paddingTop ? shapeEl.style.paddingTop : 0) + parseInt(shapeEl.style.paddingBottom ? shapeEl.style.paddingBottom : 0);\n");
        str.append("shapeTypeEl.coordsize = w + ',' + h;\n");
        str.append("var minR = w / 2;\n");
        str.append("if(minR > h/2) {\n");
        str.append("minR = h/2;\n");
        str.append("}\n");
        str.append("minR = Math.round(minR);\n");
        str.append("if (ltop > minR) ltop = minR;\n");
        str.append("if (rtop > minR) rtop = minR;\n");
        str.append("if (lbot > minR) lbot = minR;\n");
        str.append("if (rbot > minR) rbot = minR;\n");
        str.append("path+='m ' + a(ltop,0) + ' l ' + a(w-rtop,0);\n");
        str.append("path+='wa ' + a(w-2*rtop,0) + a(w,2*rtop) + a(w-rtop,0) + a(w,rtop);\n");
        str.append("path+='l ' + a(w,h-rbot);\n");
        str.append("path+='wa ' + a(w,h-2*rbot) + a(w-2*rbot,h) + a(w,h-rbot) + a(w-rbot,h);\n");
        str.append("path+='l ' + a(lbot,h);\n");
        str.append("path+='wa ' + a(2*lbot,h) + a(0,h-2*lbot) + a(lbot,h) + a(0,h-lbot);\n");
        str.append("path+='l ' + a(0,ltop);\n");
        str.append("path+='wa ' + a(0,2*ltop) + a(2*ltop,0) + a(0,ltop) + a(ltop,0) + ' xe';\n");
        str.append("shapeTypeEl.path = path;\n");
        str.append("}\n");
        str.append("}\n");
        str.append("}\n");
        str.append("}\n");
        str.append("function a(b,c) {\n");
        str.append("return ' ' + b + ',' + c + ' ';\n");
        str.append("}\n");
        str.append("function drawRoundCorners() {\n");
        if (this.styleTable != null) {
            Enumeration<CSSStyle> styles = this.styleTable.keys();
            while (styles.hasMoreElements()) {
                CSSStyle style = styles.nextElement();
                if (style.getRoundCornerRadius() <= 0) continue;
                str.append(DHTMLReport.writeJavascriptCallOfDrawPathFunction(style, this.styleTable.get(style)));
            }
        }
        str.append("}\n");
        str.append("</script>\n");
        return str.toString();
    }

    private static String writeJavascriptCallOfDrawPathFunction(CSSStyle style, String styleName) {
        StringBuffer str = new StringBuffer();
        int bRadius = style.getRoundCornerRadius();
        boolean[] rcArray = style.getRoundCornersArray();
        str.append("drawPath(\"" + (styleName.startsWith(".") ? styleName.substring(1) : styleName) + "\"");
        for (boolean element : rcArray) {
            str.append("," + (element ? bRadius : 0));
        }
        str.append(");\n");
        return str.toString();
    }

    private void writeBackgroundTag(Writer out) throws IOException {
        String bgcolor = "#ffffff";
        if (this.report.getBackgroundColor() != null) {
            bgcolor = DHTMLReport.colorToHTML(this.report.getBackgroundColor());
        }
        String bgurl = "";
        ReportImage image = this.report.getBackgroundImage();
        if (image != null && image.getWidth() != 0.0 && image.getHeight() != 0.0 && image.getImageOption() == 2) {
            try {
                bgurl = " background=\"" + this.getImageURL(this.report.getBackgroundImage()) + "\" ";
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Cann't get background URL image", ex);
            }
        }
        String onloadStr = (this.useVML ? "drawRoundCorners();" : "") + (this.isSliderFeature ? "initExpandAndCollapse();" : "");
        out.write("<body  onload=\"" + onloadStr + "\" ");
        if (this.report.getCenterDHTMLReport()) {
            out.write("style=\"text-align:center;\" ");
        }
        out.write("topmargin=0 leftmargin=0 bgcolor=\"" + bgcolor + "\"" + bgurl + ">\n");
        if (this.useVML) {
            out.write(this.writeVMLRoundCornersStyleSheet());
        }
        if (image != null && image.getWidth() != 0.0 && image.getHeight() != 0.0 && image.getImageOption() != 2) {
            double width = image.getWidth();
            double height = image.getHeight();
            double x = (this.report.getPageWidth() - width) / 2.0;
            double y = (this.report.getPageHeight() - height) / 2.0;
            if (image.getImageOption() == 1) {
                x = 0.0;
                y = 0.0;
            }
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
            out.write("<div id=\"DivName");
            out.write(Integer.toString(this.divnameCount));
            out.write("\" style=\"position:absolute; ");
            out.write("px; left:");
            out.write(Integer.toString(QbUtil.toPixel_export(x)));
            out.write("px; top:");
            out.write(Integer.toString(QbUtil.toPixel_export(y)));
            out.write("px; \">\n");
            ++this.divnameCount;
            if (image.getImageOption() == 1) {
                double oldwidth = image.getWidth();
                double oldheight = image.getHeight();
                image.setWidth(this.report.getPageWidth());
                image.setHeight(this.report.getPageHeight());
                try {
                    out.write(this.writeImage(image, null, 0));
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Cannot write image", ex);
                }
                image.setWidth(oldwidth);
                image.setHeight(oldheight);
            } else {
                try {
                    out.write(this.writeImage(image, null, 0));
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Cannot write image", ex);
                }
            }
            out.write("\n" + this.writeCloseDivTag());
        }
    }

    protected void writeTailTag() throws IOException {
        if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage && this.report.isHeadTagIncluded()) {
            this.out.write("\n</body></html>");
        }
    }

    protected void writeWaterMark(String text, boolean top) throws Exception {
        double y = 0.0;
        if (!top) {
            y = this.getY(null);
        }
        if (ServerMessage.isEvalVersion() && !this.checkTotalPageNumber && !this.checkFitGroupOnPage) {
            String str = "<div id=\"DivName" + this.divnameCount + "\" style=\"position:absolute; width:100%; height:20px; left:0px; top:" + QbUtil.toPixel_export(y) + "px; color:" + DHTMLReport.colorToHTML(IOUtil.getRandomColor()) + "; font-family:Arial; font-size:" + QbUtil.resizeExportFont(12, this.report.isAdjustFont()) + "pt; font-weight:bold; font-style:normal; text-align:center;\">";
            str = str + text + this.writeCloseDivTag();
            this.out.write(str);
            ++this.divnameCount;
        }
    }

    protected void writeReportContainerDiv(boolean open) throws Exception {
        if (open) {
            if (this.report.getCenterDHTMLReport()) {
                int width = this.report.getTotalWInPixelForDHTML();
                if (width == 0) {
                    width = QbUtil.toPixel_export(this.leftMargin) + (this.columnWrapCount + 1) * QbUtil.toPixel_export(this.report.getMinWidth());
                }
                this.out.write("<div id=\"reportContainerDiv_" + System.currentTimeMillis() + "\" width: " + (width += 40) + "px; margin: 0 auto; text-align: left;\">\n");
            } else {
                this.out.write("<div id=\"reportContainerDiv_" + System.currentTimeMillis() + "\">\n");
            }
        } else {
            this.out.write(this.writeCloseDivTag());
        }
    }

    public void writeLinks(boolean top) throws IOException {
        if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage) {
            if (this.report.getHTMLLinksProvider() == null && top && !this.exportSpecificPage) {
                this.linksHeight = QbUtil.toInch_export(50.0);
                double y = this.getY(null) - this.linksHeight;
                if (y < 0.0) {
                    y = 0.0;
                }
                this.out.write("<div id=\"DivName" + this.divnameCount + "\" style=\"position:absolute; width:100%; height:50px; left:0px; top:" + QbUtil.toPixel_export(y) + "px; color:#000000; font-family:Arial; font-size:" + QbUtil.resizeExportFont(12, this.report.isAdjustFont()) + "pt; font-style:normal; text-align:CENTER;\" >");
                this.out.write("<a href=\"" + this.getRelativeFileName(this.originalFileName) + "\">FIRST</a> |\n");
                String prevString = null;
                String nextString = null;
                if (this.currentPageNumber > 2) {
                    prevString = this.getRelativeFileName(DHTMLReport.getFileName(this.prefix, this.currentPageNumber - 1, this.getExtension()));
                } else if (this.currentPageNumber == 2) {
                    prevString = this.getRelativeFileName(this.originalFileName);
                }
                if (this.currentPageNumber < this.totalPageNumber - 1) {
                    nextString = this.getRelativeFileName(DHTMLReport.getFileName(this.prefix, this.currentPageNumber + 1, this.getExtension()));
                } else if (this.currentPageNumber == this.totalPageNumber - 1) {
                    nextString = this.getRelativeFileName(this.lastFileName);
                }
                if (prevString != null) {
                    this.out.write("<a href=\"" + prevString + "\">PREV</a> |\n");
                } else {
                    this.out.write("PREV |\n");
                }
                if (nextString != null) {
                    this.out.write("<a href=\"" + nextString + "\">NEXT</a> |\n");
                } else {
                    this.out.write("NEXT |\n");
                }
                if (this.totalPageNumber == 1) {
                    this.out.write(" <a href=\"" + this.getRelativeFileName(this.originalFileName) + "\">LAST</a>\n");
                } else {
                    this.out.write(" <a href=\"" + this.getRelativeFileName(this.lastFileName) + "\">LAST</a>\n");
                }
                this.out.write(this.writeBrTag() + "Page " + this.currentPageNumber + " of " + this.totalPageNumber + "\n");
                this.out.write(this.writeCloseDivTag());
                ++this.divnameCount;
            } else if (this.report.getHTMLLinksProvider() != null) {
                HTMLBlock block = this.report.getHTMLLinksProvider().getLinksForDHTML(this.currentPageNumber, this.totalPageNumber, this.getRelativeFileName(this.prefix), top);
                double y = 0.0;
                double height = QbUtil.toInch_export(block.getHeight());
                if (height < 0.0) {
                    height = 0.0;
                }
                if (top) {
                    this.linksHeight = height;
                    y = this.getY(null) - height;
                } else {
                    y = this.getY(null);
                }
                if (y < 0.0) {
                    y = 0.0;
                }
                this.out.write("<div id=\"DivName" + this.divnameCount + "\" style=\"position:absolute; width:100%; height:" + QbUtil.toPixel_export(height) + "px; left:0px; top:" + QbUtil.toPixel_export(y) + "px;\" >");
                if (block.getText() != null) {
                    this.out.write(block.getText());
                }
                this.out.write(this.writeCloseDivTag());
                ++this.divnameCount;
            }
        }
    }

    private String writeStyleOpenTag() {
        return "<style>\n";
    }

    private String writeStyleCloseTag() {
        return "</style>\n";
    }

    public String writeInternalStyles() {
        StringBuffer str = new StringBuffer();
        str.append(this.writeStyleOpenTag());
        str.append("<!--\n");
        str.append("html { -webkit-text-size-adjust: none; }\n");
        str.append(this.writeStyleSheet());
        str.append("-->\n");
        str.append(this.writeStyleCloseTag());
        if (this.ieStyleString.length() > 0) {
            str.append("<!--[if lt IE 9]>\n" + this.writeStyleOpenTag() + this.ieStyleString + this.writeStyleCloseTag() + "<![endif]-->\n");
        }
        return str.toString();
    }

    public String writeStyleSheet() {
        StringBuffer str = new StringBuffer();
        if (this.isSliderFeature) {
            str.append(DHTMLReportWithSlider.STYLE_TAG);
        }
        if (this.styleTable == null || this.styleTable.size() == 0) {
            this.styleCount = 0;
            this.getStyleTable(this.report);
        }
        Enumeration<CSSStyle> keys = this.styleTable.keys();
        while (keys.hasMoreElements()) {
            CSSStyle style = keys.nextElement();
            String stylename = this.styleTable.get(style);
            str.append(this.writeStyle(stylename, style));
        }
        return str.toString();
    }

    private String writeVMLRoundCornersStyleSheet() {
        StringBuffer str = new StringBuffer();
        str.append("<!--[if lte IE 8]>\n");
        str.append(this.writeStyleOpenTag());
        str.append("v\\:shape, v\\:shapetype, v\\:stroke {\n");
        str.append("behavior:url(#default#VML);\n");
        str.append("background-color:transparent !important;\n");
        str.append("border:0px !important;\n");
        str.append("antialias:false;\n");
        str.append("}\n");
        str.append("v\\:shape:{\n");
        str.append("display:block;\n");
        str.append("}\n");
        str.append(this.writeStyleCloseTag());
        if (this.styleTable != null) {
            Enumeration<CSSStyle> keys = this.styleTable.keys();
            while (keys.hasMoreElements()) {
                CSSStyle style = keys.nextElement();
                if (style.getRoundCornerRadius() == 0) continue;
                str.append(DHTMLReport.writeVMLShapeTypeString(style, this.styleTable.get(style)));
            }
        }
        str.append("<![endif]-->\n");
        return str.toString();
    }

    private static String writeVMLShapeTypeString(CSSStyle style, String styleName) {
        StringBuffer str = new StringBuffer();
        String strokeWeight = style.getBorder() + "px";
        String fillColor = style.getBgColor() != null ? "#" + Integer.toHexString(style.getBgColor().getRGB()).substring(2) : null;
        String strokeColor = style.getBgColor() != null ? "#" + Integer.toHexString(style.getBorderColor().getRGB()).substring(2) : null;
        String id = styleName.startsWith(".") && styleName.length() > 1 ? styleName.substring(1) : styleName;
        str.append("<v:shapetype id=\"" + id + "\" ");
        str.append("stroked=\"" + (style.getBorder() > 0) + "\" ");
        str.append("strokeweight=\"" + strokeWeight + "\" ");
        str.append("filled=\"" + (fillColor != null) + "\" ");
        if (fillColor != null) {
            str.append("fillcolor=\"" + fillColor + "\" ");
        }
        if (strokeColor != null) {
            str.append("strokecolor=\"" + strokeColor + "\" ");
        }
        str.append("coordsize=\"" + QbUtil.toPixel_export(style.getWidth()) + "," + QbUtil.toPixel_export(style.getHeight()) + "\">");
        str.append("</v:shapetype>\n");
        return str.toString();
    }

    private static String writeVMLStrokeTag(CSSStyle style) {
        StringBuffer str = new StringBuffer();
        int borderStyle = style.getBorderStyle();
        if (borderStyle == 2 || borderStyle == 3) {
            str.append("<v:stroke ");
            if (borderStyle == 2) {
                str.append("weight=\"" + (style.getBorder() + 2) + "px\" ");
                str.append("linestyle=\"ThinThin\" ");
            }
            if (borderStyle == 3) {
                str.append("dashstyle=\"LongDash\" ");
            }
            str.append("></v:stroke>\n");
        }
        return str.toString();
    }

    private static String writeOpenVMLShapeTag(String styleName) {
        StringBuffer str = new StringBuffer();
        str.append(DHTMLReport.writeOpenVMLShape());
        str.append("type=\"#" + styleName + "\" ");
        str.append("class=\"QB-round-" + styleName + " " + styleName + "\" ");
        return str.toString();
    }

    private static String writeOpenVMLShape() {
        return "<v:shape ";
    }

    private static String writeCloseVMLShapeTag() {
        return "</v:shape>\n";
    }

    private String writeStyle(String stylename, CSSStyle style) {
        StringBuffer str = new StringBuffer();
        str.append(stylename).append("\n");
        str.append("{\n");
        int rightPadding = 0;
        int leftPadding = 0;
        Font font = style.getFont();
        if (font == null || !font.isItalic()) {
            int padding = 3;
            if (style.getAlign() == 1) {
                leftPadding = padding;
            } else if (style.getAlign() == 2) {
                rightPadding = padding;
            }
        }
        str.append("margin:0px; \n");
        str.append("padding:0px ").append(rightPadding).append("px ").append("0px ").append(leftPadding).append("px; \n");
        str.append("text-align:").append(ALIGN[style.getAlign()]).append("; \n");
        if (style.getFontColor() != null) {
            str.append("color:").append(DHTMLReport.colorToHTML(style.getFontColor())).append("; \n");
        }
        str.append("font-family:").append(font != null ? font.getName() : "").append("; \n");
        str.append("font-size:").append(QbUtil.resizeExportFont(font != null ? font.getSize() : 0, this.report.isAdjustFont())).append("pt; \n");
        str.append("font-weight:");
        if (font != null && font.isBold()) {
            str.append("bold; \nfont-style:");
        } else {
            str.append("normal; \nfont-style:");
        }
        if (font != null && font.isItalic()) {
            str.append("italic; \n");
        } else {
            str.append("normal; \n");
        }
        if (style.isUnderline()) {
            str.append("text-decoration:underline; \n");
        }
        if (style.getBgColor() != null && style.getRoundCornerRadius() == 0) {
            str.append("background-color:").append(DHTMLReport.colorToHTML(style.getBgColor())).append(";\n");
        }
        str.append("z-index:1; \n");
        if (style.hasBorder() && style.getBorderColor() != null) {
            str.append("border-style:solid; ");
            str.append("border-top-width:").append(style.getTopBorder()).append("px; ");
            str.append("border-right-width:").append(style.getRightBorder()).append("px; ");
            str.append("border-bottom-width:").append(style.getBottomBorder()).append("px; ");
            str.append("border-left-width:").append(style.getLeftBorder()).append("px; ");
            str.append("border-color:");
            str.append(ColorTable.colorToHTML(style.getBorderColor()));
            str.append("; \n");
        }
        str.append("}\n");
        str.append("td" + stylename + "\n");
        str.append("{\n");
        if (style.getRotation() == 90.0) {
            str.append("position:absolute;\n");
            str.append("display:block;\n");
            String rotationStr = "rotate(90deg);\n";
            str.append("-webkit-transform: ").append(rotationStr);
            str.append("-webkit-transform-origin: 0 0;\n");
            str.append("-moz-transform: ").append(rotationStr);
            str.append("-moz-transform-origin: 0 0;\n");
            str.append("-o-transform: ").append(rotationStr);
            str.append("-o-transform-origin: 0 0;\n");
            str.append("-ms-transform: ").append(rotationStr);
            str.append("-ms-transform-origin: 0 0;\n");
            str.append("transform: ").append(rotationStr);
            str.append("left:" + QbUtil.toPixel_export(style.getWidth()) + "px\n;");
            this.ieStyleString = this.ieStyleString + "td" + stylename + " {\nfilter: progid:DXImageTransform.Microsoft.BasicImage(rotation=1);\n";
            this.ieStyleString = this.ieStyleString + "-ms-filter: \"progid:DXImageTransform.Microsoft.BasicImage(rotation=1)\";\nleft:0px;\n}\n";
        } else if (style.getRotation() == -90.0) {
            str.append("position:absolute;\n");
            str.append("display:block;\n");
            String rotationStr = "rotate(-90deg);\n";
            str.append("-webkit-transform: ").append(rotationStr);
            str.append("-webkit-transform-origin: 0 0;\n");
            str.append("-moz-transform: ").append(rotationStr);
            str.append("-moz-transform-origin: 0 0;\n");
            str.append("-o-transform: ").append(rotationStr);
            str.append("-o-transform-origin: 0 0;\n");
            str.append("-ms-transform: ").append(rotationStr);
            str.append("-ms-transform-origin: 0 0;\n");
            str.append("transform-origin: 0 0;\n");
            str.append("transform: ").append(rotationStr);
            str.append("top:").append(QbUtil.toPixel_export(style.getHeight())).append("px;\n");
            this.ieStyleString = this.ieStyleString + "td" + stylename + " {\nfilter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);\n";
            this.ieStyleString = this.ieStyleString + "-ms-filter: \"progid:DXImageTransform.Microsoft.BasicImage(rotation=3)\";\ntop:0px;\n}\n";
        }
        str.append("}\n");
        int roundCornerRadius = style.getRoundCornerRadius();
        str.append(roundCornerRadius > 0 ? ".QB-round-" + stylename.substring(1) : "div" + stylename);
        str.append(" {\n");
        str.append("position:absolute;\n");
        if (roundCornerRadius != 0) {
            str.append(DHTMLReport.createRoundCornerRadiusCSSPropertiesString(roundCornerRadius, style.getRoundCornersArray()));
            str.append("background-color:").append(DHTMLReport.colorToHTML(style.getBgColor())).append(";\n");
        }
        str.append("}\n");
        return str.toString();
    }

    private static String createRoundCornerRadiusCSSPropertiesString(int radius, boolean[] corners) {
        StringBuffer str = new StringBuffer();
        String pxFoursome = DHTMLReport.createRoundCornersPixelFoursomeString(radius, corners);
        str.append("-moz-border-radius:").append(pxFoursome).append(";\n");
        str.append("-webkit-border-radius:").append(pxFoursome).append(";\n");
        str.append("-o-border-radius:").append(pxFoursome).append(";\n");
        str.append("-khtml-border-radius:").append(pxFoursome).append(";\n");
        str.append("border-radius:").append(pxFoursome).append(";\n");
        return str.toString();
    }

    private static String createRoundCornersPixelFoursomeString(int radius, boolean[] corners) {
        StringBuffer strBuf = new StringBuffer();
        for (boolean corner : corners) {
            strBuf.append(corner ? radius : 0).append("px ");
        }
        return strBuf.substring(0, strBuf.length() - 1);
    }

    private String writeExternalStyles() {
        StringBuffer str = new StringBuffer();
        str.append("<link rel=\"stylesheet\" href=");
        String externalCSS = this.report.getExternalStyleSheetName();
        str.append("\"" + externalCSS + "\" ");
        str.append("type=\"text/css\" />\n");
        return str.toString();
    }

    protected void writeSection(ReportSection section, ReportTable tbl, Vector preAggCol, Vector resultCol) throws Exception {
        if (!this.titleAdjusted) {
            this.titleAdjusted = this.reportUI.adjustReportTitle(this.reportUI.getReportGraphics(), this.report.getReportHeader());
        }
        Color bgColor = null;
        boolean printOnNewPage = false;
        boolean visible = false;
        boolean resetPageNumber = false;
        if (section.getScriptObj() != null) {
            bgColor = section.getBgColor();
            printOnNewPage = section.isPrintOnNewPage();
            visible = section.isVisible();
            resetPageNumber = section.isResetPageNumber();
            section.getScriptObj().applyScript(tbl, this.currentPageNumber, 1, this.totalPageNumber, 1, this.report, section);
        }
        this.writeSectionHelper(section, tbl, preAggCol, resultCol);
        for (int i = 0; i < section.getSectionCount(); ++i) {
            ReportSection child = section.getSection(i);
            child.setRepeatOnEveryPage(section.isRepeatOnEveryPage());
            this.writeSectionHelper(child, tbl, preAggCol, resultCol);
        }
        if (section.getScriptObj() != null) {
            section.setBgColor(bgColor);
            section.setPrintOnNewPage(printOnNewPage);
            section.setVisible(visible);
            section.setResetPageNumber(resetPageNumber);
        }
    }

    protected void writeSectionHelper(ReportSection orgSection, ReportTable tbl, Vector preAggCol, Vector resultCol) throws Exception {
        if (this.checkVisibility) {
            this.writeSection(orgSection, tbl, true);
            return;
        }
        if (orgSection.isResetPageNumber()) {
            this.resetPageNumber = true;
        }
        if (!this.isWriteRepeatSection && this.printOnNewPage(orgSection)) {
            this.forcePageBreak = true;
            this.pageBreak(orgSection);
            this.forcePageBreak = false;
        }
        if (this.hasNoData(orgSection)) {
            return;
        }
        ReportSection cellArray = this.resizeSection(this.reportGraphics, orgSection, tbl);
        this.pageBreak(cellArray.getHeight(), orgSection);
        this.writeSectionTag(cellArray);
        ReportCell[] cells = cellArray.sortCell(1, true);
        double bottomY = this.elementYPos + cellArray.getHeight();
        Vector<ISubReportExport> subReports = new Vector<ISubReportExport>();
        for (int curArea = 0; curArea <= this.columnWrapCount; ++curArea) {
            double delta;
            this.elementXPos = delta = (double)curArea * this.columnWrapWidth;
            for (ReportCell cell2 : cells) {
                ReportCell cell;
                if (cell2 instanceof ReportLine || cell2 instanceof ReportGrid || this.skipCell(cell2) || (cell = tbl.formatCell(cell2, this.currentPageNumber, 1, this.totalPageNumber, 1, this.report)) == null || !cell.isVisible()) continue;
                if (cell instanceof SubReportObject || cell instanceof ReportRTFObject || cell instanceof TableOfContents) {
                    if (cellArray.isRepeatOnEveryPage() || orgSection == this.report.getPageHeader() || orgSection == this.report.getPageFooter()) {
                        cell.setResizeToFitContent(false);
                    }
                    if ((this.checkTotalPageNumber || this.checkFitGroupOnPage) && !cell.isResizeToFitContent()) continue;
                    ISubReportExport dhtmlSub = null;
                    if (cell instanceof SubReportObject) {
                        dhtmlSub = this.writeSubReport((SubReportObject)cell, tbl, cellArray);
                    } else if (cell instanceof ReportRTFObject) {
                        dhtmlSub = this.writeRTFObject((ReportRTFObject)cell, tbl, cellArray);
                    } else if (cell instanceof TableOfContents && this.report.isTocEnabled()) {
                        dhtmlSub = this.writeTOCObject((TableOfContents)cell, tbl, cellArray);
                    }
                    if (dhtmlSub != null && dhtmlSub.isFinished()) {
                        if (!(dhtmlSub.getY() > bottomY) || !cell.isResizeToFitContent()) continue;
                        bottomY = dhtmlSub.getY();
                        continue;
                    }
                    if (dhtmlSub == null) continue;
                    subReports.insertElementAt(dhtmlSub, 0);
                    continue;
                }
                if ((this.checkTotalPageNumber || this.checkFitGroupOnPage) && (!this.report.isTocEnabled() || this.report.getTableOfContentsObject().isUseGroups() || cell.getBookmark() == null)) continue;
                this.writeTableDataElement(tbl.formatCell(cell2, -1, this.currentPageNumber, 1, this.totalPageNumber, 1, this.report, false, preAggCol, resultCol), tbl, cellArray);
            }
            for (int i = 0; i < cells.length; ++i) {
                if (!(cells[i] instanceof ReportLine) && !(cells[i] instanceof ReportGrid) || this.skipCell(cells[i]) || this.checkTotalPageNumber || this.checkFitGroupOnPage) continue;
                if (cells[i] instanceof ReportLine && !((ReportLine)cells[i]).isVertical() && ((ReportLine)cells[i]).isMatchColumnWidths()) {
                    ((ReportLine)cells[i]).setWidth(tbl.getColumnWidths() - cells[i].getX());
                }
                if (cells[i] instanceof ReportGrid && ((ReportGrid)cells[i]).isMatchColumnWidths()) {
                    ((ReportGrid)cells[i]).setWidth(tbl.getColumnWidths() - cells[i].getX());
                }
                this.writeTableDataElement(tbl.formatCell(cells[i], this.currentPageNumber, 1, this.totalPageNumber, 1, this.report), tbl, cellArray);
            }
        }
        this.writeSectionBgColor(cellArray);
        if (subReports.size() > 0) {
            this.elementYPos = this.writeRemainingSubReports(subReports, orgSection);
        } else {
            this.elementYPos += cellArray.getHeight();
            if (bottomY > this.elementYPos) {
                this.elementYPos = bottomY;
            }
        }
        this.closeSectionTag();
        this.elementXPos = 0.0;
    }

    protected ISubReportExport writeSubReport(SubReportObject subReport, ReportTable tbl) {
        return this.writeSubReport(subReport, tbl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISubReportExport writeSubReport(SubReportObject subReport, ReportTable tbl, ReportSection parentSection) {
        try {
            Object LOCK;
            ReportElement securityLevel = subReport.getSecurityLevel(this.report.getPreviewSecurityLevel());
            if (securityLevel != null && !securityLevel.isVisible()) {
                return null;
            }
            Report sreport = null;
            if (subReport.hasUsableReport()) {
                sreport = subReport.getSubReport().getReportInfo();
                if (sreport.getQueryParams().size() != 0) {
                    sreport = subReport.reloadReportWithParameters(sreport, this.report, tbl);
                } else if (sreport.dbInfo.getDriverName() != null) {
                    sreport = subReport.loadReport(this.report, tbl);
                } else {
                    try {
                        Report temp = ReloadReport.reloadData(new Report(sreport), false);
                        if (temp != null) {
                            sreport = temp;
                        }
                    }
                    catch (Exception ex) {
                        sreport.getReportTables().elementAt(0).setVisible(false);
                        subReport.setHeight(0.0);
                        this.report.setInitializeReportError(LanguageEncoder.getText("Subreport datasource not found!") + "\n" + IOUtil.getStackTrace(ex));
                    }
                }
            } else {
                sreport = subReport.loadReport(this.report, tbl);
            }
            sreport.setSubFilesTable(this.report.getSubFilesTable());
            double pageHeight = -1.0;
            double pageWidth = -1.0;
            if (!subReport.isResizeToFitContent()) {
                pageHeight = subReport.getHeight() + this.elementYPos + subReport.getY();
            }
            if (!subReport.isResizeWidth()) {
                pageWidth = subReport.getWidth();
            }
            sreport.setExternalStyleSheetName(this.report.getExternalStyleSheetName());
            sreport.setExportToMultiPages(this.report.isExportToMultiPages());
            sreport.setExportToSingleWPagination(this.report.isExportToSingleWPagination());
            sreport.setDHTMLTopMargin(this.report.getDHTMLTopMargin());
            sreport.setDHTMLTopMarginRepeatOnEveryPage(this.report.isDHTMLTopMarginRepeatOnEveryPage());
            sreport.setDynamicExport(this.report.isDynamicExport, this.report.serverName, this.report.servletRunnerPort);
            sreport.setDynamicExport(this.report.isDynamicExport, this.report.relativeUrlToServlets());
            sreport.setHttpsDynamicExport(this.report.isHttpsDynamicExport(), this.report.getHttpsServerName(), this.report.getHttpsServletRunnerPort());
            sreport.setServletDirectory(this.report.getServletDirectory());
            sreport.setSubReportPath(this.report.getSubReportPath());
            if (this.report.getDrillDownConnection() != null) {
                sreport.setDrillDownConnection(this.report.getDrillDownConnection());
            }
            if (this.report.getDrillDownDatabaseInfo() != null) {
                sreport.setDrillDownDatabaseInfo(this.report.getDrillDownDatabaseInfo());
            }
            sreport.setDHTMLViewerUsed(this.report.isDHTMLViewerUsed());
            DHTMLSubReport dhtmlSub = new DHTMLSubReport(sreport, this.elementXPos + subReport.getX(), this.elementYPos + subReport.getY(), pageWidth, pageHeight, subReport.getZ(), this);
            dhtmlSub.prefix = this.prefix;
            dhtmlSub.originalFileName = this.originalFileName;
            dhtmlSub.lastFileName = this.lastFileName;
            dhtmlSub.ddBytesSentToServlet = this.ddBytesSentToServlet;
            dhtmlSub.setParentSection(parentSection);
            Object object = LOCK = dhtmlSub.getLOCK();
            synchronized (object) {
                new Thread(dhtmlSub).start();
                try {
                    if (this.lockObjects != null) {
                        this.lockObjects.add(LOCK);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINEST, "Can't add a lock", e);
                }
                try {
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.divnameCount = dhtmlSub.getDivnameCount();
            this.imageCount = dhtmlSub.getImageCount();
            this.barcodeCount = dhtmlSub.getBarcodeCount();
            if (dhtmlSub.maxWidthOfSections > this.maxWidthOfSections) {
                this.maxWidthOfSections = dhtmlSub.maxWidthOfSections;
            }
            for (int i = 0; i < dhtmlSub.report.exportedFiles.size(); ++i) {
                this.report.exportedFiles.add(dhtmlSub.report.exportedFiles.elementAt(i));
            }
            this.report.addTriggeredAlerts(sreport.getTriggeredAlerts(), sreport.getFileNameWithoutPath());
            return dhtmlSub;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to write sub-report", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISubReportExport writeTOCObject(TableOfContents toc, ReportTable tbl, ReportSection section) {
        try {
            Object LOCK;
            ReportElement securityLevel = toc.getSecurityLevel(this.report.getPreviewSecurityLevel());
            if (securityLevel != null && !securityLevel.isVisible()) {
                return null;
            }
            double pageHeight = -1.0;
            if (!toc.isResizeToFitContent()) {
                pageHeight = toc.getHeight() + this.elementYPos + toc.getY();
            }
            DHTMLTOCObject dhtmlSub = new DHTMLTOCObject(toc, tbl, this.elementXPos + toc.getX(), this.elementYPos + toc.getY(), toc.getWidth(), pageHeight, this);
            dhtmlSub.prefix = this.prefix;
            dhtmlSub.originalFileName = this.originalFileName;
            dhtmlSub.lastFileName = this.lastFileName;
            dhtmlSub.setParentSection(section);
            Object object = LOCK = dhtmlSub.getLOCK();
            synchronized (object) {
                new Thread(dhtmlSub).start();
                try {
                    if (this.lockObjects != null) {
                        this.lockObjects.add(LOCK);
                    }
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.divnameCount = dhtmlSub.getDivnameCount();
            this.imageCount = dhtmlSub.getImageCount();
            this.barcodeCount = dhtmlSub.getBarcodeCount();
            return dhtmlSub;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to write TOC object", ex);
            return null;
        }
    }

    protected ISubReportExport writeRTFObject(ReportRTFObject rtfObject, ReportTable tbl) {
        return this.writeRTFObject(rtfObject, tbl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISubReportExport writeRTFObject(ReportRTFObject rtfObject, ReportTable tbl, ReportSection parentSection) {
        try {
            Object LOCK;
            ReportElement securityLevel = rtfObject.getSecurityLevel(this.report.getPreviewSecurityLevel());
            if (securityLevel != null && !securityLevel.isVisible()) {
                return null;
            }
            Vector<Vector<Object[]>> lines = this.reportGraphics.breakRichText(rtfObject, this.report, tbl, QbUtil.toPixel_export(rtfObject.getColumnWidth()), true);
            double pageHeight = -1.0;
            if (!rtfObject.isResizeToFitContent()) {
                pageHeight = rtfObject.getHeight() + this.elementYPos + rtfObject.getY();
            }
            DHTMLRTFObject dhtmlSub = new DHTMLRTFObject(rtfObject, lines, this.elementXPos + rtfObject.getX(), this.elementYPos + rtfObject.getY(), rtfObject.getWidth(), pageHeight, this);
            dhtmlSub.setParentSection(parentSection);
            Object object = LOCK = dhtmlSub.getLOCK();
            synchronized (object) {
                new Thread(dhtmlSub).start();
                try {
                    if (this.lockObjects != null) {
                        this.lockObjects.add(LOCK);
                    }
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.divnameCount = dhtmlSub.getDivnameCount();
            this.imageCount = dhtmlSub.getImageCount();
            this.barcodeCount = dhtmlSub.getBarcodeCount();
            return dhtmlSub;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to write RTF object", ex);
            return null;
        }
    }

    protected void writeMasterSection(ReportSection masterSection, ReportTable tbl) throws Exception {
        if (this.checkTotalPageNumber || this.hasNoData(masterSection)) {
            return;
        }
        if (!(masterSection.getBgColor() == null && masterSection.getBorderThickness() <= 0 || this.checkFitGroupOnPage)) {
            try {
                if (!this.exportSpecificPage || this.currentPageNumber == this.exportPage) {
                    this.openDivTag(masterSection);
                    this.out.write(this.writeCloseDivTag());
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to write master section div tag", ex);
            }
        }
        ReportCell[] cells = masterSection.sortCell(1, true);
        Report temp_report = this.report;
        this.elementXPos = masterSection.getX();
        double old_elementYPos = this.elementYPos;
        this.elementYPos += masterSection.getY();
        for (ReportCell cell : cells) {
            if (cell instanceof ReportLine || cell instanceof ReportGrid || this.skipCell(cell) || !(cell.getX() + cell.getWidth() <= masterSection.getWidth()) || !(cell.getY() + cell.getHeight() <= masterSection.getHeight())) continue;
            this.writeTableDataElement(tbl.formatCell(cell, this.getPage(), 1, this.getTotalPageNumber(), 1, temp_report), tbl, masterSection);
        }
        for (int i = 0; i < cells.length; ++i) {
            if (!(cells[i] instanceof ReportLine) && !(cells[i] instanceof ReportGrid) || this.skipCell(cells[i]) || !(cells[i].getX() + cells[i].getWidth() <= masterSection.getWidth()) || !(cells[i].getY() + cells[i].getHeight() <= masterSection.getHeight())) continue;
            this.writeTableDataElement(tbl.formatCell(cells[i], this.getPage(), 1, this.getTotalPageNumber(), 1, temp_report), tbl, masterSection);
        }
        this.elementXPos = 0.0;
        this.elementYPos = old_elementYPos;
    }

    protected static byte[] replace(byte[] data, String oldString, String newString) {
        try {
            BufferedReader input = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            OutputStreamWriter output = new OutputStreamWriter(outstream);
            boolean doneReplace = false;
            String line = input.readLine();
            while (line != null) {
                if (!line.endsWith(oldString) || doneReplace) {
                    output.write(line + "\n");
                } else {
                    output.write(newString + "\n");
                    doneReplace = true;
                }
                line = input.readLine();
            }
            output.flush();
            output.close();
            outstream.close();
            return outstream.toByteArray();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to replace string in data", ex);
            return data;
        }
    }

    protected double writeRemainingSubReports(Vector<ISubReportExport> remainingSubReports, ReportSection section) throws Exception {
        return this.writeRemainingSubReports(remainingSubReports, null, null, section, null);
    }

    protected double writeRemainingSubReports(Vector<ISubReportExport> remainingSubReports, Vector<ReportCell> oneTime, Vector<Double> oneTimeY, ReportSection section, ReportTable tbl) throws Exception {
        double bottomYOfSection = 0.0;
        while (remainingSubReports != null && remainingSubReports.size() > 0 || oneTime != null && oneTime.size() > 0) {
            this.elementYPos += 1.0;
            boolean old_forcePageBreak = this.forcePageBreak;
            if (remainingSubReports != null) {
                for (int i = 0; i < remainingSubReports.size(); ++i) {
                    if (!((DHTMLSubReport)remainingSubReports.elementAt((int)i)).forcePageBreak) continue;
                    this.forcePageBreak = true;
                }
            }
            this.pageBreak(section);
            this.forcePageBreak = old_forcePageBreak;
            bottomYOfSection = this.writeVisibleOneTimeElements(oneTime, oneTimeY, remainingSubReports, tbl);
        }
        return bottomYOfSection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double writeOnePageOfSubReports(Vector<ISubReportExport> subReports) {
        double bottomY = 0.0;
        for (int i = subReports.size() - 1; i >= 0; --i) {
            Object LOCK;
            ISubReportExport dhtmlSub = subReports.elementAt(i);
            dhtmlSub.setY(this.elementYPos);
            if (!this.checkFitGroupOnPage) {
                dhtmlSub.setOut(this.out);
            }
            dhtmlSub.setDivnameCount(this.divnameCount);
            dhtmlSub.setImageCount(this.imageCount);
            dhtmlSub.setBarcodeCount(this.barcodeCount);
            Object object = LOCK = dhtmlSub.getLOCK();
            synchronized (object) {
                LOCK.notify();
                try {
                    if (this.lockObjects != null) {
                        this.lockObjects.add(LOCK);
                    }
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.divnameCount = dhtmlSub.getDivnameCount();
            this.imageCount = dhtmlSub.getImageCount();
            this.barcodeCount = dhtmlSub.getBarcodeCount();
            if (dhtmlSub.isFinished()) {
                if (dhtmlSub.getY() > bottomY) {
                    bottomY = dhtmlSub.getY();
                }
                subReports.removeElementAt(i);
                continue;
            }
            this.elementYPos += dhtmlSub.getY();
        }
        return bottomY;
    }

    private boolean validPageHeight(ReportCell cell) {
        return !this.report.isExportToMultiPages() && !this.report.isExportToSingleWPagination() && !this.checkVisibility || this.report.isExportToMultiPages() && this.pageHeight - this.elementYPos >= cell.getHeight() || this.report.isExportToSingleWPagination() && (this.report.getPageHeight() - DHTMLReport.getBrowserMargin()) * (double)(this.currentPageNumber - 1) + this.pageHeight - this.elementYPos >= cell.getHeight() || !this.report.isExportToMultiPages() && !this.report.isExportToSingleWPagination() && this.pageHeight * (double)this.currentPageNumber - this.elementYPos >= cell.getHeight();
    }

    protected double writeVisibleOneTimeElements(Vector<ReportCell> oneTime, Vector<Double> oneTimeY, Vector<ISubReportExport> remainingSubReports, ReportTable tbl) throws Exception {
        double bottomYOfSection = 0.0;
        if (remainingSubReports.size() > 0) {
            bottomYOfSection = this.writeOnePageOfSubReports(remainingSubReports);
        }
        if (oneTime == null) {
            return bottomYOfSection;
        }
        for (int j = oneTime.size() - 1; j >= 0; --j) {
            ReportCell cell = tbl.formatCell(oneTime.elementAt(j), this.getPage(), 1, this.getTotalPageNumber(), 1, this.report);
            if (!this.validPageHeight(cell) || !cell.isVisible()) {
                oneTime.removeElementAt(j);
                oneTimeY.removeElementAt(j);
                return bottomYOfSection;
            }
            double yPos = oneTimeY.elementAt(j);
            if (!this.report.isExportToMultiPages() && !this.report.isExportToSingleWPagination() && !this.checkVisibility || this.report.isExportToMultiPages() && this.pageHeight - this.elementYPos >= yPos + cell.getHeight() || this.report.isExportToSingleWPagination() && (this.report.getPageHeight() - DHTMLReport.getBrowserMargin()) * (double)(this.currentPageNumber - 1) + this.pageHeight - this.elementYPos >= yPos + cell.getHeight() || !this.report.isExportToMultiPages() && !this.report.isExportToSingleWPagination() && this.pageHeight * (double)this.currentPageNumber - this.elementYPos >= yPos + cell.getHeight()) {
                double oldY = cell.getY();
                if (this.skipCell(cell)) continue;
                cell.setY(yPos);
                if (cell instanceof SubReportObject || cell instanceof ReportRTFObject) {
                    if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage || cell.isResizeToFitContent()) {
                        ISubReportExport dhtmlSub = null;
                        dhtmlSub = cell instanceof SubReportObject ? this.writeSubReport((SubReportObject)cell, tbl) : this.writeRTFObject((ReportRTFObject)cell, tbl);
                        if (dhtmlSub != null && dhtmlSub.isFinished()) {
                            if (dhtmlSub.getY() > bottomYOfSection && cell.isResizeToFitContent()) {
                                bottomYOfSection = dhtmlSub.getY();
                            }
                        } else if (dhtmlSub != null) {
                            remainingSubReports.insertElementAt(dhtmlSub, 0);
                        }
                    }
                } else if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage) {
                    this.writeTableDataElement(cell, tbl, tbl);
                }
                cell.setY(oldY);
                if (bottomYOfSection < this.elementYPos + yPos + cell.getHeight()) {
                    bottomYOfSection = this.elementYPos + yPos + cell.getHeight();
                }
                oneTime.removeElementAt(j);
                oneTimeY.removeElementAt(j);
                continue;
            }
            if ((yPos = yPos - this.pageHeight * (double)this.currentPageNumber - this.elementYPos) < 0.0) {
                oneTimeY.setElementAt(0.0, j);
                continue;
            }
            oneTimeY.setElementAt(yPos, j);
        }
        return bottomYOfSection;
    }

    protected void closeSectionTag() throws Exception {
    }

    protected void closeRowTag() throws Exception {
    }

    protected int getExtension() {
        return 4;
    }

    private boolean writeForm() {
        DrillDownNode node = this.report.currentNode;
        if (node == null) {
            return false;
        }
        Enumeration<TreeNode> en = node.children();
        if (!en.hasMoreElements()) {
            return false;
        }
        DrillDownNode child = (DrillDownNode)en.nextElement();
        if (!child.isValidDrillDownNode()) {
            return false;
        }
        if (!child.isMultiValueParameter(this.report.getSubFilesTable())) {
            return false;
        }
        if (en.hasMoreElements()) {
            return false;
        }
        int[] mapping = child.getColumnMapping();
        Vector<Vector<Object>> list = new Vector<Vector<Object>>();
        Vector<String> title = new Vector<String>();
        for (int element : mapping) {
            title.addElement(this.report.colData[this.report.colInfo[element].getMapping()].getName());
            Vector<Object> listData = this.report.colData[this.report.colInfo[element].getMapping()].getDistinctValue();
            list.addElement(listData);
        }
        try {
            int i;
            StringBuffer str = new StringBuffer();
            str.append("<div id=\"DivName");
            str.append(this.divnameCount);
            str.append("\" style=\"position:relative; ");
            str.append("width:100%; ");
            str.append("height:180px; ");
            str.append("left:0px; ");
            str.append("top:").append(QbUtil.toPixel_export(this.getY(null))).append("px; ");
            str.append("\">\n");
            this.out.write(str.toString());
            ++this.divnameCount;
            if (this.report.isDHTMLViewerUsed()) {
                String link = "ReportViewer.jsp";
                this.out.write("\n<form method=\"get\" action=\"" + link + "\">" + this.writeBrTag());
                this.out.write("\n<center><table width=100% border=0>");
                this.out.write("\n<tr>");
                for (i = 0; i < title.size(); ++i) {
                    this.out.write("\n<td>");
                    this.out.write("\n<center>" + (String)title.elementAt(i));
                    this.out.write("<center>\n</td>");
                }
                this.out.write("\n</TR>");
                this.out.write("\n<tr>");
                for (i = 0; i < list.size(); ++i) {
                    this.out.write("\n<td>");
                    this.out.write("\n<center><select name=\"PARAM" + i + "\" multiple size=\"5\">" + this.writeBrTag());
                    Vector vec = (Vector)list.elementAt(i);
                    for (int j = 0; j < vec.size(); ++j) {
                        this.out.write("\n<option value=\"" + QbUtil.urlEncode(DataType.write(vec.elementAt(j).toString())) + "\">" + vec.elementAt(j).toString() + "</option>");
                    }
                    this.out.write("</select>");
                    this.out.write("\n<input type=\"hidden\" name=\"HIDE_PARAM" + i + "\" value=\"true\">");
                    this.out.write("<center>\n</td>");
                }
                this.out.write("\n</tr>");
                this.out.write("</center>\n</table>");
                this.out.write("\n<input type=\"hidden\" name=\"ReportPath\" value=\"" + child.getFileName() + "\">");
                this.out.write("\n<input type=\"hidden\" name=\"CurrentAction\" value=\"drillDown\">");
                if (this.report.getPreviewSecurityLevel() != null) {
                    this.out.write("\n<input type=\"hidden\" name=\"SecurityLevel\" value=\"" + QbUtil.urlEncode(this.report.getPreviewSecurityLevel()) + "\">");
                }
                this.out.write("\n<input type=\"hidden\" name=\"USESERVER\" value=\"" + (ServerMessage.useServer ? QbUtil.urlEncode("true") : QbUtil.urlEncode("false")) + "\">");
                if (child.getChartPath() != null) {
                    this.out.write("\n<input type=\"hidden\" name=\"CHARTPATH\" value=\"" + child.getChartPath() + "\">");
                }
                if (child.getImagePath() != null) {
                    this.out.write("\n<input type=\"hidden\" name=\"IMAGEPATH\" value=\"" + child.getImagePath() + "\">");
                }
                if (child.getDrillDownPath() != null) {
                    this.out.write("\n<input type=\"hidden\" name=\"DRILLDOWNPATH\" value=\"" + QbUtil.urlEncode(child.getDrillDownPath()) + "\">");
                }
                if (child.getSubReportPath() != null) {
                    this.out.write("\n<input type=\"hidden\" name=\"SUBREPORTPATH\" value=\"" + QbUtil.urlEncode(child.getSubReportPath()) + "\">");
                }
                if (this.report.relativeUrlToServlets()) {
                    this.out.write("\n<input type=\"hidden\" name=\"RELATIVEURLTOIMGGEN\" value=\"" + QbUtil.urlEncode("true") + "\">");
                }
                if (this.report.isHttpsDynamicExport()) {
                    this.out.write("\n<input type=\"hidden\" name=\"ISHTTPS\" value=\"" + QbUtil.urlEncode("true") + "\">");
                    this.out.write("\n<input type=\"hidden\" name=\"httpsServerName\" value=\"" + QbUtil.urlEncode(this.report.getHttpsServerName()) + "\">");
                    this.out.write("\n<input type=\"hidden\" name=\"httpsPort\" value=\"" + QbUtil.urlEncode(String.valueOf(this.report.getHttpsServletRunnerPort())) + "\">");
                }
                if (!this.report.getServletDirectory().equals("servlet/")) {
                    this.out.write("\n<input type=\"hidden\" name=\"SERVLETDIRECTORY\" value=\"" + QbUtil.urlEncode(this.report.getServletDirectory()) + "\">");
                }
                if (this.report.getReplaceColumnInfoURL() != null) {
                    this.out.write("\n<input type=\"hidden\" name=\"ReplaceColumnXML\" value=\"" + QbUtil.urlEncode(this.report.getReplaceColumnInfoURL()) + "\">");
                }
                this.out.write("\n<input type=\"hidden\" name=\"CHARSET\" value=\"UTF-8\">");
                this.out.write("\n<input type=\"hidden\" name=\"ExportToMultiPages\" value=\"" + this.report.isExportToMultiPages() + "\">");
                this.out.write(this.writeBrTag() + "<center><input type=\"submit\" value=\"Submit\"></center>\n");
                this.out.write("</form>");
            } else {
                String servletName = this.getDrillDownReportServletName();
                this.out.write("\n<form method=\"post\" action=\"" + servletName + "\" target=\"" + this.report.getHTMLTarget() + "\">" + this.writeBrTag());
                this.out.write("\n<center><table width=100% border=0>");
                this.out.write("\n<tr>");
                for (i = 0; i < title.size(); ++i) {
                    this.out.write("\n<td>");
                    this.out.write("\n<center>" + (String)title.elementAt(i));
                    this.out.write("<center>\n</td>");
                }
                this.out.write("\n</TR>");
                this.out.write("\n<tr>");
                for (i = 0; i < list.size(); ++i) {
                    this.out.write("\n<td>");
                    this.out.write("\n<center><select name=\"paramValue_" + i + "\" multiple size=\"5\">" + this.writeBrTag());
                    Vector vec = (Vector)list.elementAt(i);
                    for (int j = 0; j < vec.size(); ++j) {
                        this.out.write("\n<option value=\"" + vec.elementAt(j).toString() + "\">" + vec.elementAt(j).toString());
                    }
                    this.out.write("</select>");
                    this.out.write("<center>\n</td>");
                }
                this.out.write("\n</tr>");
                this.out.write("</center>\n</table>");
                this.out.write("\n<input type=\"hidden\" name=\"paramSetSize\" value=\"" + title.size() + "\">");
                if (this.report.getDynamicReportKeyGenerator() != null) {
                    this.out.write("\n<input type=\"hidden\" name=\"KEY\" value=\"" + this.report.getDynamicReportKeyGenerator().generateReportKey(child.getByteArray()) + "\">");
                } else if (!this.ddBytesSentToServlet) {
                    this.out.write("\n<input type=\"hidden\" name=\"ReportFilePath\" value=\"" + child.getFileName() + "\">");
                } else {
                    this.out.write("\n<input type=\"hidden\" name=\"KEY\" value=\"" + child.getFileName() + "\">");
                }
                this.out.write("\n<input type=\"hidden\" name=\"ReportExportFormat\" value=\"4\">");
                this.out.write("\n<input type=\"hidden\" name=\"DRILLDOWNCONN\" value=\"" + (this.report.getDrillDownConnection() != null) + "\">");
                this.out.write("\n<input type=\"hidden\" name=\"DRILLDOWNDATABASEINFO\" value=\"" + (this.report.getDrillDownDatabaseInfo() != null) + "\">");
                this.out.write("\n<input type=\"hidden\" name=\"USESERVER\" value=\"" + (ServerMessage.useServer ? QbUtil.urlEncode("true") : QbUtil.urlEncode("false")) + "\">");
                if (this.report.serverName != null) {
                    this.out.write("\n<input type=\"hidden\" name=\"ServerName\" value=\"" + this.report.serverName + "\">");
                }
                this.out.write("\n<input type=\"hidden\" name=\"ServletRunnerPort\" value=\"" + this.report.servletRunnerPort + "\">");
                String servletDirectory = this.getServletDirectory();
                if (servletDirectory != null) {
                    this.out.write("\n<input type=\"hidden\" name=\"ServletDirectory\" value=\"" + servletDirectory + "\">");
                }
                if (this.report.getPreviewSecurityLevel() != null) {
                    this.out.write("\n<input type=\"hidden\" name=\"SecurityLevel\" value=\"" + QbUtil.escapeHTML(this.report.getPreviewSecurityLevel()) + "\">");
                }
                this.out.write(this.writeBrTag() + "<center><input type=\"submit\" value=\"Submit\"></center>\n");
                this.out.write("</form>\n");
            }
            this.out.write(this.writeCloseDivTag());
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to write form", ex);
        }
        return true;
    }

    private String getServletDirectory() {
        String servletDirectory = this.report.getServletDirectory();
        if (servletDirectory != null) {
            if (!(servletDirectory = servletDirectory.replace('\\', '/')).startsWith("/")) {
                servletDirectory = "/" + servletDirectory;
            }
            if (!servletDirectory.endsWith("/") && !servletDirectory.endsWith(".")) {
                servletDirectory = servletDirectory + "/";
            }
        } else {
            servletDirectory = "/servlet/";
        }
        return servletDirectory;
    }

    private String getDrillDownReportServletName() {
        String servletName = null;
        String servletDirectory = this.getServletDirectory();
        String paramReportServletName = "ParamReportGeneratorServlet";
        servletName = this.report.isHttpsDynamicExport() ? "https://" + this.report.getHttpsServerName() + ":" + this.report.getHttpsServletRunnerPort() + servletDirectory + paramReportServletName : this.report.protocol + this.report.serverName + ":" + this.report.servletRunnerPort + servletDirectory + paramReportServletName;
        return servletName;
    }

    public static double getBrowserMargin() {
        return browserMargin;
    }

    public static void setBrowserMargin(double margin) {
        browserMargin = margin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doDynamicImageExport(byte[] barray) throws Exception {
        if (this.report.getDynamicImageURLGenerator() == null) {
            String key;
            BufferedReader inFromServlet;
            String imageURL;
            block6: {
                String string;
                URLConnection servletConnection;
                String servletDirectory = this.getServletDirectory();
                LOGGER.finest("Connecting to servlet");
                String servletName = "RPTImageGenerator";
                if (this.report.isHttpsDynamicExport()) {
                    imageURL = "https://" + this.report.getHttpsServerName() + ":" + this.report.getHttpsServletRunnerPort() + servletDirectory + servletName;
                    servletConnection = HttpsIO.openHttpsConnection(new URL(imageURL));
                } else {
                    imageURL = this.report.protocol + this.report.serverName + ":" + this.report.servletRunnerPort + servletDirectory + servletName;
                    URL imageServlet = new URL(imageURL);
                    servletConnection = imageServlet.openConnection();
                }
                LOGGER.finest("Connection created");
                QbUtil.setConnectTimeout(servletConnection, this.report.dynamicExportTimeout);
                servletConnection.setDoInput(true);
                servletConnection.setDoOutput(true);
                servletConnection.setUseCaches(false);
                servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
                LOGGER.finest("Sending image to servlet");
                ObjectOutputStream outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
                outputToServlet.writeInt(barray.length);
                outputToServlet.write(barray);
                outputToServlet.flush();
                outputToServlet.close();
                LOGGER.finest("Sent");
                inFromServlet = null;
                try {
                    inFromServlet = new BufferedReader(new InputStreamReader(servletConnection.getInputStream()));
                    key = inFromServlet.readLine();
                    LOGGER.finest("Key = " + key);
                    if (!this.report.relativeUrlToServlets()) break block6;
                    string = servletDirectory + servletName + "?ID=" + key;
                    LOGGER.finest("Close");
                }
                catch (Throwable throwable) {
                    LOGGER.finest("Close");
                    CloseUtils.close(inFromServlet);
                    throw throwable;
                }
                CloseUtils.close(inFromServlet);
                return string;
            }
            String string = imageURL + "?ID=" + key;
            LOGGER.finest("Close");
            CloseUtils.close(inFromServlet);
            return string;
        }
        return this.report.getDynamicImageURLGenerator().generateImageURL(barray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doDynamicReportExport(byte[] barray, String fileName, String servletName) throws Exception {
        String string;
        URLConnection servletConnection;
        String servletDirectory = this.getServletDirectory();
        LOGGER.finest("Connecting to servlet");
        if (this.report.isHttpsDynamicExport()) {
            String reportURL = "https://" + this.report.getHttpsServerName() + ":" + this.report.getHttpsServletRunnerPort() + servletDirectory + servletName;
            servletConnection = HttpsIO.openHttpsConnection(new URL(reportURL));
        } else {
            String reportURL = this.report.protocol + this.report.serverName + ":" + this.report.servletRunnerPort + servletDirectory + servletName;
            URL drilldownServlet = new URL(reportURL);
            servletConnection = drilldownServlet.openConnection();
        }
        LOGGER.finest("Connection created");
        QbUtil.setConnectTimeout(servletConnection, this.report.dynamicExportTimeout);
        servletConnection.setDoInput(true);
        servletConnection.setDoOutput(true);
        servletConnection.setUseCaches(false);
        servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
        LOGGER.finest("Sending image to servlet");
        ObjectOutputStream outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
        IOUtil.writeString(outputToServlet, fileName);
        outputToServlet.writeInt(barray.length);
        outputToServlet.write(barray);
        outputToServlet.flush();
        outputToServlet.close();
        LOGGER.finest("Sent");
        BufferedReader inFromServlet = null;
        try {
            inFromServlet = new BufferedReader(new InputStreamReader(servletConnection.getInputStream()));
            String key = inFromServlet.readLine();
            LOGGER.finest("Key = " + key);
            string = key;
            LOGGER.finest("Close");
        }
        catch (Throwable throwable) {
            LOGGER.finest("Close");
            CloseUtils.close(inFromServlet);
            throw throwable;
        }
        CloseUtils.close(inFromServlet);
        return string;
    }

    private void drilldownDynamicExport(Report report) throws Exception {
        if (report == null) {
            return;
        }
        if (report.currentNode != null) {
            for (int i = 0; i < report.currentNode.getChildCount(); ++i) {
                boolean isPAK;
                DrillDownNode node = report.currentNode.getChildAt(i);
                LoadReport lr = new LoadReport();
                lr.setBackupDataUsed(true);
                lr.setRelativeDomainPath(node.getDomainPath());
                Report r = null;
                FileInMemTable subFilesTable = report.getSubFilesTable();
                lr.setSubFilesTable(subFilesTable);
                boolean bl = isPAK = subFilesTable != null && (subFilesTable.getTopName() != null && SaveReport.isPAKFile(subFilesTable.getTopName()) || subFilesTable.size() > 0);
                if (SaveReport.isRPTFile(node.getFileName()) && isPAK) {
                    node.setFileName(SaveReport.getPakFileName(node.getFileName()));
                }
                try {
                    r = node.getByteArray() != null ? lr.loadReportFromByteArray(node.getByteArray()) : (subFilesTable != null && subFilesTable.containsKey(node.getFileName()) ? lr.loadReportFromByteArray(subFilesTable.get(node.getFileName())) : lr.loadReportFromFile(node.getFileName()));
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Cannot read report", ex);
                }
                if (r == null) continue;
                this.drilldownDynamicExport(node);
                for (int j = 0; j < node.getChildCount(); ++j) {
                    r.currentNode.getChildAt(j).setFileName(node.getChildAt(j).getFileName());
                }
                this.drilldownDynamicExport(r);
            }
        }
        if (report.subReports != null && report.subReports.size() > 0) {
            Report[] subReport;
            for (Report element : subReport = report.getSubReportArray(true)) {
                this.drilldownDynamicExport(element);
            }
        }
    }

    private void drilldownDynamicExport(DrillDownNode node) throws Exception {
        LOGGER.finest("Drill-down node: " + node.getFileName());
        if (node.getByteArray() == null) {
            if (this.report.getSubFilesTable().containsKey(node.getFileName())) {
                node.setByteArray(this.report.getSubFilesTable().get(node.getFileName()));
            } else {
                node.setByteArray(node.getNotPackedByteArray());
            }
        }
        if (node.getByteArray() != null) {
            FileInMemTable subFilesTable = this.report.getSubFilesTable();
            String currentNodeFileName = this.report.currentNode.getFileName(subFilesTable);
            if (this.report.rootNode == null || this.report.rootNode.getFileName(subFilesTable).equals(currentNodeFileName) || subFilesTable != null && subFilesTable.getTopName() != null && subFilesTable.getTopName().equals(currentNodeFileName)) {
                this.doDynamicReportExport(node.getByteArray(), node.getFileName(subFilesTable), "DrillDownReportServlet");
            }
            if (this.report.getDrillDownReportHashtable() != null && (this.report.rootNode == null || this.report.rootNode.getFileName(this.report.getSubFilesTable()).equals(currentNodeFileName))) {
                this.report.getDrillDownReportHashtable().put(node.getFileName(), node.getByteArray());
            }
            this.doDynamicReportExport(node.getByteArray(), node.getFileName(), "ParamReportGeneratorServlet");
            this.doDynamicReportExport(node.getByteArray(), node.getFileName(), "UnmappedParameterServlet");
            this.ddBytesSentToServlet = true;
        }
    }

    protected Graphics getOffScreenGraphics() {
        if (this.offScreenGraphics == null) {
            this.offScreenGraphics = IOUtil.getOffScreenGraphics();
        }
        return this.offScreenGraphics;
    }

    protected FontMetrics getFontMetrics(Font f) {
        FontMetrics fm = this.fontMetricsTable.get(f);
        if (fm != null) {
            return fm;
        }
        fm = this.getOffScreenGraphics().getFontMetrics(f);
        this.fontMetricsTable.put(f, fm);
        return fm;
    }

    protected void getStyleTable(Report report) {
        if (this.styleTable == null) {
            this.styleTable = new Hashtable();
        }
        this.getSectionStyles(report.getPageHeader());
        this.getSectionStyles(report.getReportHeader());
        Vector<ReportTable> reportTables = report.getReportTables();
        for (int i = 0; i < reportTables.size(); ++i) {
            this.getTableStyles(reportTables.elementAt(i));
        }
        this.getSectionStyles(report.getReportFooter());
        this.getSectionStyles(report.getPageFooter());
    }

    private void getSectionStyles(ReportSection section) {
        int i;
        int cellCt = section.getCellCount();
        ReportCell[] cells = section.getData();
        for (i = 0; i < cellCt; ++i) {
            this.getReportCellStyle(cells[i]);
        }
        for (i = 0; i < section.getSectionCount(); ++i) {
            try {
                this.getSectionStyles(section.getSection(i));
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to get section styles", ex);
            }
        }
    }

    private void getTableStyles(ReportTable table) {
        this.getSectionStyles(table.getHeader());
        if (table instanceof ReportMultiSectionTable) {
            ReportMultiSectionTable mTable = (ReportMultiSectionTable)table;
            for (int i = 0; i < mTable.dataHeader.length; ++i) {
                this.getSectionStyles(mTable.dataHeader[i]);
                this.getSectionStyles(mTable.dataFooter[i]);
            }
            this.getCellsStyles(mTable);
        } else {
            this.getCellsStyles(table);
        }
        this.getSectionStyles(table.getFooter());
    }

    private void getCellsStyles(ReportTable table) {
        SubReportObject[] subReports;
        ReportImage[] sortedImages;
        ReportColumn[] col;
        for (ReportColumn element : col = table.getSortedVisibleColumns()) {
            this.getReportCellStyle(element);
        }
        for (ReportImage image : sortedImages = table.getSortedImages()) {
            if (!(image instanceof ReportGrid)) continue;
            this.getReportCellStyle(image);
        }
        for (SubReportObject subReport : subReports = table.getAllSubReports()) {
            this.getReportCellStyle(subReport);
        }
    }

    protected void getReportCellStyle(ReportElement elt) {
        CSSStyle style;
        if (elt instanceof SubReportObject) {
            try {
                Report subReport = ((SubReportObject)elt).getSubReport(true, false, this.report.useBackupData, null).getReportInfo();
                subReport.setDHTMLViewerUsed(this.report.isDHTMLViewerUsed());
                DHTMLSubReport exportSubReport = new DHTMLSubReport(subReport, this.elementXPos + elt.getX(), this.elementYPos + elt.getY(), elt.getWidth(), this.pageHeight, elt.getZ(), this);
                exportSubReport.getStyleTable(subReport);
                this.styleCount = exportSubReport.getStyleCount();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Can't get report cell style", e);
            }
        }
        if ((style = new CSSStyle(elt)).getRoundCornerRadius() > 0) {
            this.useVML = true;
        }
        if (!this.styleTable.containsKey(style)) {
            this.styleTable.put(style, "." + this.report.getInternalStyleSheetName() + "_" + this.styleCount++);
        }
        if (elt instanceof ReportColumn) {
            ReportColumn col = (ReportColumn)elt;
            if (!this.hasDualColor(col)) {
                return;
            }
            CSSStyle newStyle = new CSSStyle(col);
            newStyle.setFont(col.getFont2());
            newStyle.setFontColor(col.getFontColor2());
            newStyle.setBgColor(col.getBgColor2());
            newStyle.setStyleName(col.getStyleName2());
            newStyle.setUnderline(col.isUnderline2());
            if (newStyle.getRoundCornerRadius() > 0) {
                this.useVML = true;
            }
            if (!this.styleTable.containsKey(newStyle)) {
                this.styleTable.put(newStyle, "." + this.report.getInternalStyleSheetName() + "_" + this.styleCount++);
            }
        }
    }

    protected boolean hasDualColor(ReportColumn col) {
        return col.getAlternateRow() > 0 || col.isDualColorOnRowBreak() || col.getDualColorColInfoIndex() != null && col.getDualColorColInfoCount() > 0;
    }

    private String getStyleName(CSSStyle style) {
        if (style == null) {
            return null;
        }
        if (this.useExternalStyleSheet && style.getStyleName() != null && !style.getStyleName().equals("")) {
            return style.getStyleName();
        }
        if (this.styleTable != null && this.styleTable.containsKey(style)) {
            return this.getStyleName(this.styleTable.get(style));
        }
        return null;
    }

    private String getStyleName(String value) {
        if (value != null && value.length() > 0) {
            if (value.startsWith("#") || value.startsWith(".")) {
                return value.substring(1);
            }
            if (value.toLowerCase().startsWith("div.")) {
                return value.substring(4);
            }
        }
        return null;
    }

    private boolean hasValidStyleName(CSSStyle style) {
        if (style == null) {
            return false;
        }
        if (this.styleTable != null && this.styleTable.containsKey(style) && this.getStyleName(this.styleTable.get(style)) != null) {
            return true;
        }
        if (this.useExternalStyleSheet) {
            return !style.getStyleName().equals("");
        }
        return false;
    }

    private int replaceNegativeValueByZero(int value) {
        return value < 0 ? 0 : value;
    }

    protected void writeSectionTag(ReportElement section) throws IOException {
    }

    private boolean exportThisPage() {
        if (this.checkTotalPageNumber) {
            return false;
        }
        return !this.exportSpecificPage || this.currentPageNumber == this.exportPage;
    }

    public void setWriter(Writer out) {
        this.out = out;
    }

    private void writeBookmark(String s) throws Exception {
        this.out.write("<div id=\"DivName" + this.divnameCount + "\" style=\"position:absolute; top:" + QbUtil.toPixel_export(this.elementYPos + this.topMargin) + "px;\" >");
        this.out.write("<a name=\"" + s + "\">&nbsp</a>");
        this.out.write(this.writeCloseDivTag());
        ++this.divnameCount;
    }

    public void startToGetData(ReportTable table) throws Exception {
    }

    protected class ExportThread
    extends Thread {
        private boolean stop = false;
        private Vector<Object> content = new Vector();
        private Vector<Object> location = new Vector();
        private Object lock = new Object();
        private static final int IO_MEM = 5000000;
        private int maxItem = -1;
        private Object lockMainThread = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                this.export();
                if (this.stop) continue;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.export();
        }

        public boolean isQueueFull(int pageSize) {
            if (this.maxItem == -1) {
                this.maxItem = 5000000 / pageSize;
                if (this.maxItem <= 0) {
                    this.maxItem = 1;
                }
            }
            LOGGER.finest("Number of content: " + this.content.size());
            return this.content.size() >= this.maxItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queue(Object c, Object l) {
            this.content.addElement(c);
            this.location.addElement(l);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public Object getLockForMainThread() {
            this.lockMainThread = new Object();
            return this.lockMainThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            this.stop = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void export() {
            while (this.content.size() > 0) {
                int i = 0;
                for (i = 0; i < this.content.size(); ++i) {
                    Object obj = this.content.elementAt(i);
                    if (obj != null) {
                        if (obj instanceof ExportBarcode) {
                            try {
                                ((ExportBarcode)obj).export();
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.FINE, "Failed to export barcode", ex);
                            }
                        } else {
                            try {
                                byte[] barray = (byte[])obj;
                                new WriteDataFile().output(null, barray, (String)this.location.elementAt(i), DHTMLReport.this.report.isDHTMLViewerUsed());
                                LOGGER.finest("Memory paging: write data file: " + (String)this.location.elementAt(i));
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.WARNING, "Cannot write data file", ex);
                            }
                        }
                    }
                    if (i < this.content.size()) {
                        this.content.setElementAt(null, i);
                    }
                    if (i >= this.location.size()) continue;
                    this.location.setElementAt(null, i);
                }
                --i;
                while (i >= 0) {
                    if (i < this.content.size()) {
                        this.content.removeElementAt(i);
                    }
                    if (i < this.location.size()) {
                        this.location.removeElementAt(i);
                    }
                    --i;
                }
                if (this.lockMainThread == null || this.maxItem == -1 || this.content.size() >= this.maxItem) continue;
                Object object = this.lockMainThread;
                synchronized (object) {
                    this.lockMainThread.notify();
                    this.lockMainThread = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill() {
            this.content.removeAllElements();
            this.location.removeAllElements();
            this.stop = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
    }
}

