/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.FileInfo;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.report.Aggregation;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.ColDataBuffer;
import quadbase.reportdesigner.report.DHTMLReport;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.ISubReportExport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.report.WriteDataFile;
import quadbase.reportdesigner.util.HTMLBlock;

public class DHTMLReportColumnar
extends DHTMLReport {
    private static final Logger LOGGER = Logger.getLogger(DHTMLReportColumnar.class.getName());
    Vector<int[]> footerAggCol;
    Vector<Object> footerResCol;
    private ColDataBuffer colDataBuffer;
    int startIndex = 0;
    int displayRow = Report.getInputDataBlockSize();

    public DHTMLReportColumnar(Report report) throws Exception {
        super(report);
    }

    @Override
    public boolean exportDHTML(OutputStream outstream, String filename) throws Exception {
        if (filename == null) {
            this.imageName = "TEMPIMG_";
            if (this.report.isExportToMultiPages()) {
                throw new Exception("In order to export to multiple pages, you have to specify the file name");
            }
        } else {
            this.prefix = Report.getPrefixFileName(filename);
            this.originalFileName = Report.getFullName(filename, 4);
            this.lastFileName = Report.getFullName(this.prefix + "_LAST", 4);
            this.imageName = new FileInfo(this.originalFileName).getAbsolutePath();
            int i = this.imageName.lastIndexOf(46);
            if (i >= 0) {
                this.imageName = this.imageName.substring(0, i);
            }
            this.imageName = this.imageName + "_";
        }
        this.reportUI = new ReportUI(this.report, IOUtil.getOffScreenGraphics(), false);
        this.reportGraphics = this.reportUI.getReportGraphics();
        this.pageHeight = this.report.getPageHeight() - this.topMargin - this.bottomMargin - (this.hasNoData(this.report.getPageFooter()) ? 0.0 : this.resizeSection(this.reportGraphics, this.report.getPageFooter(), this.report.getReportTables().elementAt(this.report.getReportTables().size() - 1)).getHeight());
        this.out = !this.report.isExportToMultiPages() ? (this.report.getExportEncoding() != null ? new PrintWriter((Writer)new OutputStreamWriter(outstream, this.report.getExportEncoding()), true) : new PrintWriter(outstream, true)) : (filename == null ? (this.report.getExportEncoding() != null ? new PrintWriter((Writer)new OutputStreamWriter(outstream, this.report.getExportEncoding()), true) : new PrintWriter(outstream, true)) : new StringWriter());
        this.checkTotalPageNumber = false;
        boolean success = this.exportDHTML();
        this.colDataBuffer.join();
        return success;
    }

    @Override
    protected boolean exportDHTMLHelper() throws Exception {
        ReportTable table = null;
        this.formatTable();
        Vector<ReportTable> vec = this.report.getReportTables();
        if (vec.size() <= 0) {
            throw new Exception("The report does not contain any table. Please check and try again later.");
        }
        table = vec.elementAt(0);
        this.hTable = vec.elementAt(0);
        this.fTable = vec.elementAt(vec.size() - 1);
        this.writeHeadTag();
        this.writeWaterMark("Evaluation copy by Quadbase Systems Inc.", true);
        this.startToGetData(table);
        if (this.report.isExportToMultiPages()) {
            this.writeLinks(true);
        }
        this.pageHeaderHeight = this.writeSection(this.report.getPageHeader(), table);
        this.writeSection(this.report.getReportHeader(), table);
        for (int i = 0; i < vec.size(); ++i) {
            table = vec.elementAt(i);
            this.initRepeatSection();
            this.setColumnWrap();
            this.wrapInfo = new double[]{0.0, this.elementYPos, this.elementYPos};
            this.writeReportTable(table);
            if (this.doColumnWrap && this.elementYPos < this.curMaxY) {
                this.elementYPos = this.curMaxY;
            }
            this.resetColumnWrap();
        }
        this.writeSection(this.report.getReportFooter(), table, this.footerAggCol, this.footerResCol);
        if (this.report.isExportToMultiPages()) {
            this.elementYPos = this.pageHeight;
        }
        this.writeSection(this.report.getPageFooter(), this.fTable, false);
        if (this.report.isExportToMultiPages()) {
            this.writeLinks(false);
        }
        this.writeWaterMark("Please contact sales@quadbase.com for purchasing information.", false);
        if (this.originalFileName == null || !this.report.isExportToMultiPages()) {
            this.writeTailTag();
            this.out.flush();
            this.out.close();
        } else {
            this.writeTailTag();
            byte[] data = this.out.toString().getBytes();
            data = DHTMLReportColumnar.replace(data, ">NEXT</a> |", "NEXT |");
            if (this.currentPageNumber <= 1) {
                data = DHTMLReportColumnar.replace(data, ">LAST</a>", "LAST");
            }
            try {
                if (this.currentPageNumber > 1) {
                    String redirect = "<HTML><HEAD><META HTTP-EQUIV=\"REFRESH\" CONTENT=\"0; URL=" + this.getRelativeFileName(this.lastFileName) + "\"></HEAD></HTML>";
                    this.exportThread.queue(data, this.lastFileName);
                    this.exportThread.queue(redirect.getBytes(), DHTMLReportColumnar.getFileName(this.prefix, this.currentPageNumber, 4));
                } else {
                    new WriteDataFile().output(null, data, Report.getFullName(this.prefix + "_FIRST", 4));
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Export failed", ex);
                this.out.close();
                throw ex;
            }
            this.out.flush();
            this.out.close();
        }
        return true;
    }

    @Override
    protected void formatTable() throws Exception {
        if (this.checkVisibility) {
            super.formatTable();
        }
    }

    protected void formatTable(ReportTable tbl, int startIndex) throws Exception {
        while (!this.colDataBuffer.isDataReady(startIndex)) {
            Thread.sleep(100L);
        }
        ColData[] colData = this.colDataBuffer.getData(startIndex);
        this.colDataBuffer.clearDataBuffer(startIndex);
        for (int i = 0; i < this.report.colInfo.length; ++i) {
            int m = this.report.colInfo[i].getMapping();
            if (m >= 0) {
                tbl.getColumn(i).setDataSet(colData[m].getDataSet());
                continue;
            }
            Formula formulaObj = this.report.colInfo[i].getFormulaObj();
            if (formulaObj == null) continue;
            int rowCt = tbl.getRowCount();
            Object obj = null;
            for (int j = 0; j < rowCt; ++j) {
                obj = formulaObj.getValue(tbl, j, 1, 1, 1, 1, this.report, null, null, false, null, null, colData);
                tbl.getColumn(i).addData(obj);
            }
        }
    }

    @Override
    public void startToGetData(ReportTable tbl) throws Exception {
        this.colDataBuffer = new ColDataBuffer(this.report.dbInfo, this.report.originalIResultSet, this.startIndex, this.displayRow);
        this.colDataBuffer.start();
        this.formatTable(tbl, this.startIndex);
    }

    @Override
    protected void writeReportTable(ReportTable tbl) throws Exception {
        if (this.checkVisibility) {
            super.writeReportTable(tbl);
            return;
        }
        this.writeSection(tbl.getHeader(), tbl);
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.addRepeatSection(tbl.getHeader(), tbl);
        }
        this.footerAggCol = new Vector();
        this.footerResCol = new Vector();
        Aggregation.getAggrColumn(tbl.getFooter(), tbl, this.footerAggCol, this.footerResCol);
        Aggregation.getAggrColumn(this.report.getReportFooter(), tbl, this.footerAggCol, this.footerResCol);
        this.writeCells(tbl);
        this.writeSection(tbl.getFooter(), tbl, this.footerAggCol, this.footerResCol);
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.removeRepeatSection();
        }
    }

    @Override
    protected void writeCells(ReportTable tbl) throws Exception {
        if (!tbl.isVisible()) {
            return;
        }
        if (this.checkVisibility) {
            super.writeCells(tbl);
            return;
        }
        int nRow = 0;
        ReportImage[] chart = tbl.getSortedImages();
        SubReportObject[] subReports = tbl.getSortedSubReports();
        ReportRTFObject[] rtfObjects = tbl.getSortedRTFObjects();
        Vector<ISubReportExport> remainingSubReports = new Vector<ISubReportExport>();
        Vector<ReportCell> oneTime = new Vector<ReportCell>();
        Vector<Double> oneTimeY = new Vector<Double>();
        for (int i = 0; i < chart.length; ++i) {
            if (chart[i] instanceof ReportLine || chart[i] instanceof ReportGrid || this.skipCell(chart[i])) continue;
            oneTime.insertElementAt(chart[i], 0);
            oneTimeY.insertElementAt(chart[i].getY(), 0);
        }
        for (SubReportObject subReportObject : subReports) {
            oneTime.insertElementAt(subReportObject, 0);
            oneTimeY.insertElementAt(subReportObject.getY(), 0);
        }
        for (ReportCell reportCell : rtfObjects) {
            oneTime.insertElementAt(reportCell, 0);
            oneTimeY.insertElementAt(reportCell.getY(), 0);
        }
        double bottomYOfSection = 0.0;
        double wrapIndex = 0.0;
        if (this.wrapInfo != null) {
            wrapIndex = this.wrapInfo[0];
        }
        this.resetColumnWrapTableUI();
        int rowIdx = 0;
        ReportTable orgTable = tbl;
        boolean firstTime = true;
        do {
            if (!firstTime) {
                this.formatTable(tbl, this.startIndex);
            }
            firstTime = false;
            nRow = tbl.getRowCount();
            if (nRow <= 0) break;
            this.startIndex += nRow;
            for (int i = 0; i < nRow; ++i) {
                double delta;
                this.elementXPos = 0.0;
                tbl = this.resizeTable(this.reportGraphics, orgTable, i);
                chart = tbl.getSortedImages();
                ReportColumn[] col = tbl.getSortedVisibleColumns();
                ReportColumn[] originalCol = tbl.getVisibleColumnList();
                double tblH = tbl.getHeight();
                int oldpageN = this.currentPageNumber;
                if (tbl.isPrintOnNewPage() && i != 0) {
                    this.pageBreak(null);
                } else {
                    this.pageBreak(tblH, rowIdx);
                }
                if (this.currentPageNumber > oldpageN || rowIdx == 0) {
                    bottomYOfSection = this.writeVisibleOneTimeElements(oneTime, oneTimeY, remainingSubReports, tbl);
                }
                if (this.wrapInfo != null) {
                    wrapIndex = this.wrapInfo[0];
                }
                this.elementXPos = delta = wrapIndex * this.columnWrapWidth;
                if (delta == 0.0) {
                    this.writeSectionBgColor(tbl);
                }
                if (!this.checkTotalPageNumber) {
                    for (int j = 0; j < col.length; ++j) {
                        if (this.skipCell(col[j])) continue;
                        ReportCell cell = tbl.formatCell(col[j], i, rowIdx - this.columnWrapDisplayRow * (int)wrapIndex - this.columnWrapCount * this.columnWrapInitialRow, this.report);
                        this.writeTableDataElement(cell, tbl, i, tbl);
                        Aggregation.calculateAggregation(originalCol[j].getData(i), j, this.footerAggCol, this.footerResCol);
                    }
                    for (int k = 0; k < chart.length; ++k) {
                        ReportImage img;
                        if (this.skipCell(chart[k]) || !((img = chart[k]) instanceof ReportLine) && !(img instanceof ReportGrid)) continue;
                        this.writeTableDataElement(chart[k], tbl, i, tbl);
                    }
                }
                this.elementYPos += tbl.getHeight();
                ++rowIdx;
            }
        } while (this.displayRow == nRow);
        if (remainingSubReports.size() > 0) {
            this.elementYPos = this.writeRemainingSubReports(remainingSubReports, oneTime, oneTimeY, null, tbl);
        } else if (this.elementYPos < bottomYOfSection) {
            this.elementYPos = bottomYOfSection;
        }
        if (this.doColumnWrap) {
            this.curMaxY = this.wrapInfo != null && this.elementYPos < this.wrapInfo[2] ? this.wrapInfo[2] : this.elementYPos;
        }
        this.elementXPos = 0.0;
    }

    @Override
    public void writeLinks(boolean top) throws IOException {
        if (!this.checkTotalPageNumber) {
            if (this.report.getHTMLLinksProvider() == null && top) {
                this.linksHeight = QbUtil.toInch_export(50.0);
                double y = this.getY(null) - this.linksHeight;
                if (y < 0.0) {
                    y = 0.0;
                }
                this.out.write("<DIV ID=\"DivName" + this.divnameCount + "\" STYLE=\"position:absolute; width:100%; height:50px; left:0px; top:" + QbUtil.toPixel_export(y) + "px; color:#000000; font-family:Dialog; font-size:" + QbUtil.resizeExportFont(12, this.report.isAdjustFont()) + "pt; font-style:normal; text-align:CENTER;\" >");
                this.out.write("<a href=\"" + this.getRelativeFileName(this.originalFileName) + "\">FIRST</a> |\n");
                String prevString = null;
                if (this.currentPageNumber > 2) {
                    prevString = this.getRelativeFileName(DHTMLReportColumnar.getFileName(this.prefix, this.currentPageNumber - 1, 4));
                } else if (this.currentPageNumber == 2) {
                    prevString = this.getRelativeFileName(this.originalFileName);
                }
                if (prevString != null) {
                    this.out.write("<a href=\"" + prevString + "\">PREV</a> |\n");
                } else {
                    this.out.write("PREV |\n");
                }
                this.out.write("<a href=\"" + this.getRelativeFileName(DHTMLReportColumnar.getFileName(this.prefix, this.currentPageNumber + 1, 4)) + "\">NEXT</a> |\n");
                this.out.write(" <a href=\"" + this.getRelativeFileName(this.lastFileName) + "\">LAST</a>\n");
                this.out.write("<br>Page " + this.currentPageNumber + "\n");
                this.out.write("</DIV>\n");
                ++this.divnameCount;
            } else if (this.report.getHTMLLinksProvider() != null) {
                HTMLBlock block = this.report.getHTMLLinksProvider().getLinksForDHTML(this.currentPageNumber, -1, this.getRelativeFileName(this.prefix), top);
                double y = 0.0;
                double height = QbUtil.toInch_export(block.getHeight());
                if (height < 0.0) {
                    height = 0.0;
                }
                if (top) {
                    this.linksHeight = height;
                    y = this.getY(null) - height;
                } else {
                    y = this.getY(null);
                }
                if (y < 0.0) {
                    y = 0.0;
                }
                this.out.write("<DIV ID=\"DivName" + this.divnameCount + "\" STYLE=\"position:absolute; width:100%; height:" + QbUtil.toPixel_export(height) + "px; left:0px; top:" + y + "px;\" >");
                if (block.getText() != null) {
                    this.out.write(block.getText());
                }
                this.out.write("</DIV>\n");
                ++this.divnameCount;
            }
        }
    }

    @Override
    protected void pageBreak(double requiredHeight, int rowIndex) throws Exception {
        if (!this.report.isExportToMultiPages() && !this.checkVisibility) {
            if (this.report.getReportType() != 0 && this.report.getReportType() != 4 && this.report.getReportType() != 1 || this.report.getColumnWrap() == null) {
                return;
            }
            super.pageBreak(requiredHeight, rowIndex);
        } else {
            super.pageBreak(requiredHeight, rowIndex);
        }
    }
}

