/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.FileInfo;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.Aggregation;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.ColDataBuffer;
import quadbase.reportdesigner.report.DHTMLReport;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.MasterDetailsTable;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.report.TransformQuery;
import quadbase.reportdesigner.report.WriteDataFile;
import quadbase.reportdesigner.util.HTMLBlock;
import quadbase.reportdesigner.util.IAggregateConstants;

public class DHTMLReportMasterDetails
extends DHTMLReport
implements IAggregateConstants {
    private static final Logger LOGGER = Logger.getLogger(DHTMLReportMasterDetails.class.getName());
    Vector<int[]> footerAggCol;
    Vector<Object> footerResCol;
    private Vector[] preAggCol;
    private Vector<Object>[] resultCol;
    private ColDataBuffer colDataBuffer;

    public DHTMLReportMasterDetails(Report report) {
        super(report);
    }

    @Override
    public boolean exportDHTML(OutputStream outstream, String filename) throws Exception {
        if (filename == null) {
            this.imageName = "TEMPIMG_";
            if (this.report.isExportToMultiPages()) {
                throw new Exception("In order to export to multiple pages, you have to specify the file name");
            }
        } else {
            this.prefix = Report.getPrefixFileName(filename);
            this.originalFileName = Report.getFullName(filename, 4);
            this.lastFileName = Report.getFullName(this.prefix + "_LAST", 4);
            this.imageName = new FileInfo(this.originalFileName).getAbsolutePath();
            int i = this.imageName.lastIndexOf(46);
            if (i >= 0) {
                this.imageName = this.imageName.substring(0, i);
            }
            this.imageName = this.imageName + "_";
        }
        this.reportUI = new ReportUI(this.report, IOUtil.getOffScreenGraphics(), false);
        this.reportGraphics = this.reportUI.getReportGraphics();
        this.pageHeight = this.report.getPageHeight() - this.topMargin - this.bottomMargin - (this.hasNoData(this.report.getPageFooter()) ? 0.0 : this.resizeSection(this.reportGraphics, this.report.getPageFooter(), this.report.getReportTables().elementAt(this.report.getReportTables().size() - 1)).getHeight());
        this.out = !this.report.isExportToMultiPages() ? (this.report.getExportEncoding() != null ? new PrintWriter((Writer)new OutputStreamWriter(outstream, this.report.getExportEncoding()), true) : new PrintWriter(outstream, true)) : (filename == null ? (this.report.getExportEncoding() != null ? new PrintWriter((Writer)new OutputStreamWriter(outstream, this.report.getExportEncoding()), true) : new PrintWriter(outstream, true)) : new StringWriter());
        this.checkTotalPageNumber = false;
        boolean success = this.exportDHTML();
        this.colDataBuffer.join();
        return success;
    }

    @Override
    protected boolean exportDHTMLHelper() throws Exception {
        ReportTable table = null;
        this.formatTable();
        Vector<ReportTable> vec = this.report.getReportTables();
        if (vec.size() <= 0) {
            throw new Exception("The report does not contain any table. Please check and try again later.");
        }
        table = vec.elementAt(0);
        this.hTable = vec.elementAt(0);
        this.fTable = vec.elementAt(vec.size() - 1);
        this.writeHeadTag();
        this.writeWaterMark("Evaluation copy by Quadbase Systems Inc.", true);
        if (this.report.isExportToMultiPages()) {
            this.writeLinks(true);
        }
        this.pageHeaderHeight = this.writeSection(this.report.getPageHeader(), table);
        this.writeSection(this.report.getReportHeader(), table);
        for (int i = 0; i < vec.size(); ++i) {
            table = vec.elementAt(i);
            this.initRepeatSection();
            this.setColumnWrap();
            this.writeReportTable(table);
            this.resetColumnWrap();
        }
        this.writeSection(this.report.getReportFooter(), table, this.footerAggCol, this.footerResCol);
        if (this.report.isExportToMultiPages()) {
            this.elementYPos = this.pageHeight;
        }
        this.writeSection(this.report.getPageFooter(), this.fTable, false);
        if (this.report.isExportToMultiPages()) {
            this.writeLinks(false);
        }
        this.writeWaterMark("Please contact sales@quadbase.com for purchasing information.", false);
        if (this.originalFileName == null || !this.report.isExportToMultiPages()) {
            this.writeTailTag();
            this.out.flush();
            this.out.close();
        } else {
            this.writeTailTag();
            byte[] data = this.out.toString().getBytes();
            data = DHTMLReportMasterDetails.replace(data, ">NEXT</a> |", "NEXT |");
            if (this.currentPageNumber <= 1) {
                data = DHTMLReportMasterDetails.replace(data, ">LAST</a>", "LAST");
            }
            try {
                if (this.currentPageNumber > 1) {
                    String redirect = "<HTML><HEAD><META HTTP-EQUIV=\"REFRESH\" CONTENT=\"0; URL=" + this.getRelativeFileName(this.lastFileName) + "\"></HEAD></HTML>";
                    this.exportThread.queue(data, this.lastFileName);
                    this.exportThread.queue(redirect.getBytes(), DHTMLReportMasterDetails.getFileName(this.prefix, this.currentPageNumber, 4));
                } else {
                    new WriteDataFile().output(null, data, Report.getFullName(this.prefix + "_FIRST", 4));
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Export failed", ex);
                this.out.close();
                throw ex;
            }
            this.out.flush();
            this.out.close();
        }
        return true;
    }

    @Override
    protected void formatTable() throws Exception {
        if (this.checkVisibility) {
            super.formatTable();
        }
    }

    @Override
    protected void writeReportTable(ReportTable tbl) throws Exception {
        if (this.checkVisibility) {
            super.writeReportTable(tbl);
            return;
        }
        this.writeSection(tbl.getHeader(), tbl);
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.addRepeatSection(tbl.getHeader(), tbl);
        }
        this.footerAggCol = new Vector();
        this.footerResCol = new Vector();
        Aggregation.getAggrColumn(tbl.getFooter(), tbl, this.footerAggCol, this.footerResCol);
        Aggregation.getAggrColumn(this.report.getReportFooter(), tbl, this.footerAggCol, this.footerResCol);
        this.writeMasterDetailsTable((MasterDetailsTable)tbl);
        this.writeSection(tbl.getFooter(), tbl, this.footerAggCol, this.footerResCol);
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.removeRepeatSection();
        }
    }

    private void writeMasterDetailsTable(MasterDetailsTable tbl) throws Exception {
        if (tbl == null || tbl.mData == null) {
            return;
        }
        Report report = tbl.mData.report;
        int numBreakCol = report.breakColInfo.length;
        int nRow = 0;
        int startIndex = 0;
        int displayRow = Report.getInputDataBlockSize();
        if (report.dbInfo != null) {
            DBInfoBasic dbinfo = report.dbInfo;
            String sqlstr = dbinfo.getQuery();
            sqlstr = TransformQuery.transformMasterDetails(sqlstr, report.colInfo);
            DBInfoBasic tempdbInfo = null;
            tempdbInfo = dbinfo.isUseJNDIDataSource() ? new DBInfoBasic(dbinfo.getJNDIName(), sqlstr, dbinfo.getEnvProperties()) : new DBInfoBasic(dbinfo.getConnection(), dbinfo.getURLString(), dbinfo.getDriverName(), dbinfo.getUserID(), dbinfo.getPassword(), sqlstr);
            this.colDataBuffer = new ColDataBuffer(tempdbInfo, startIndex, displayRow, dbinfo.getQuery());
        } else {
            this.colDataBuffer = new ColDataBuffer(report.originalIResultSet, startIndex, displayRow);
        }
        this.colDataBuffer.start();
        ReportTable stbl = this.createTable(tbl);
        int loop = 0;
        this.preAggCol = new Vector[tbl.dataHeader.length];
        this.resultCol = new Vector[tbl.dataHeader.length];
        for (int i = 0; i < tbl.dataHeader.length; ++i) {
            this.preAggCol[i] = new Vector();
            this.resultCol[i] = new Vector();
            Aggregation.getAggrColumn(tbl.dataFooter[i], stbl, this.preAggCol[i], this.resultCol[i]);
            ++loop;
        }
        Object[] oldvalue = new Object[numBreakCol];
        Object[] newvalue = new Object[numBreakCol];
        boolean init = false;
        int recNo = 0;
        while (true) {
            if (!this.colDataBuffer.isDataReady(startIndex)) {
                Thread.sleep(100L);
                continue;
            }
            ColData[] colData = this.colDataBuffer.getData(startIndex);
            this.colDataBuffer.clearDataBuffer(startIndex);
            nRow = colData[0].getSize();
            startIndex = nRow + startIndex;
            recNo = 0;
            if (!init) {
                for (int i = 0; i < numBreakCol; ++i) {
                    int cMap = report.breakColInfo[i].getMapping();
                    oldvalue[i] = colData[cMap].getData(0);
                }
                this.addRow(report, colData, stbl, recNo);
                init = true;
                recNo = 1;
                for (ReportSection element : tbl.dataHeader) {
                    this.writeSection(element, stbl);
                    if (!element.isRepeatOnEveryPage()) continue;
                    this.addRepeatSection(element, stbl);
                }
            }
            while (recNo < nRow) {
                int i;
                boolean doSwap = false;
                for (i = 0; i < numBreakCol; ++i) {
                    int k;
                    int cMap = report.breakColInfo[i].getMapping();
                    newvalue[i] = colData[cMap].getData(recNo);
                    if (doSwap) continue;
                    if (oldvalue[i] == null && newvalue[i] == null || oldvalue[i] != null && newvalue[i] != null && oldvalue[i].equals(newvalue[i])) {
                        colData[cMap].setData(recNo, "");
                        continue;
                    }
                    LOGGER.finest("Swap");
                    doSwap = true;
                    this.writeCells(stbl);
                    for (k = tbl.dataFooter.length - 1; i <= k; --k) {
                        this.writeSection(tbl.dataFooter[k], stbl, this.preAggCol[--loop], this.resultCol[loop]);
                        if (tbl.dataHeader[k].isRepeatOnEveryPage()) {
                            this.removeRepeatSection();
                        }
                        this.resultCol[loop] = this.resetResultCol(this.preAggCol[loop]);
                    }
                    stbl = this.createTable(tbl);
                    if (recNo < nRow - 1) {
                        this.addRow(report, colData, stbl, recNo);
                        ++recNo;
                        for (k = i; k < tbl.dataHeader.length; ++k) {
                            this.writeSection(tbl.dataHeader[k], stbl);
                            if (tbl.dataHeader[k].isRepeatOnEveryPage()) {
                                this.addRepeatSection(tbl.dataHeader[k], stbl);
                            }
                            ++loop;
                        }
                        continue;
                    }
                    init = false;
                    for (k = i; k < tbl.dataHeader.length; ++k) {
                        ++loop;
                    }
                }
                for (i = 0; i < numBreakCol; ++i) {
                    oldvalue[i] = newvalue[i];
                }
                this.addRow(report, colData, stbl, recNo);
                ++recNo;
            }
            this.out.flush();
            if (displayRow != nRow) break;
        }
        this.writeCells(stbl);
        for (int k = loop - 1; k >= 0; --k) {
            this.writeSection(tbl.dataFooter[k], stbl, this.preAggCol[k], this.resultCol[k]);
            if (!tbl.dataHeader[k].isRepeatOnEveryPage()) continue;
            this.removeRepeatSection();
        }
        this.preAggCol = null;
        this.resultCol = null;
    }

    private Vector<Object> resetResultCol(Vector<Object> vec) {
        Vector<Object> res = new Vector<Object>();
        for (int i = 0; i < vec.size(); ++i) {
            res.addElement(null);
        }
        return res;
    }

    private ReportTable createTable(ReportTable tbl) {
        ReportTable newTbl = new ReportTable(tbl);
        int ct = tbl.getColumnCount();
        for (int i = 0; i < ct; ++i) {
            newTbl.addColumn(new ReportColumn(tbl.getColumn(i)));
        }
        return newTbl;
    }

    private void addRow(Report report, ColData[] colData, ReportTable stbl, int recNo) throws Exception {
        for (int j = 0; j < report.colInfo.length; ++j) {
            Object obj = null;
            if (report.colInfo[j].getMapping() != -1) {
                obj = colData[report.colInfo[j].getMapping()].getData(recNo);
            } else {
                Formula formulaObj = report.colInfo[j].getFormulaObj();
                obj = formulaObj.getValue(stbl, recNo, 1, 1, 1, 1, report, null, null, false, null, null, colData);
            }
            Aggregation.calculateAggregation(obj, j, this.preAggCol, this.resultCol);
            Aggregation.calculateAggregation(obj, j, this.footerAggCol, this.footerResCol);
            stbl.getColumn(j).addData(obj);
        }
    }

    @Override
    public void writeLinks(boolean top) throws IOException {
        if (!this.checkTotalPageNumber) {
            if (this.report.getHTMLLinksProvider() == null && top) {
                this.linksHeight = QbUtil.toInch_export(50.0);
                double y = this.getY(null) - this.linksHeight;
                if (y < 0.0) {
                    y = 0.0;
                }
                this.out.write("<DIV ID=\"DivName" + this.divnameCount + "\" STYLE=\"position:absolute; width:100%; height:50px; left:0px; top:" + QbUtil.toPixel_export(y) + "px; color:#000000; font-family:Dialog; font-size:" + QbUtil.resizeExportFont(12, this.report.isAdjustFont()) + "pt; font-style:normal; text-align:CENTER;\" >");
                this.out.write("<a href=\"" + this.getRelativeFileName(this.originalFileName) + "\">FIRST</a> |\n");
                String prevString = null;
                if (this.currentPageNumber > 2) {
                    prevString = this.getRelativeFileName(DHTMLReportMasterDetails.getFileName(this.prefix, this.currentPageNumber - 1, 4));
                } else if (this.currentPageNumber == 2) {
                    prevString = this.getRelativeFileName(this.originalFileName);
                }
                if (prevString != null) {
                    this.out.write("<a href=\"" + prevString + "\">PREV</a> |\n");
                } else {
                    this.out.write("PREV |\n");
                }
                this.out.write("<a href=\"" + this.getRelativeFileName(DHTMLReportMasterDetails.getFileName(this.prefix, this.currentPageNumber + 1, 4)) + "\">NEXT</a> |\n");
                this.out.write(" <a href=\"" + this.getRelativeFileName(this.lastFileName) + "\">LAST</a>\n");
                this.out.write("<br>Page " + this.currentPageNumber + "\n");
                this.out.write("</DIV>\n");
                ++this.divnameCount;
            } else if (this.report.getHTMLLinksProvider() != null) {
                HTMLBlock block = this.report.getHTMLLinksProvider().getLinksForDHTML(this.currentPageNumber, -1, this.getRelativeFileName(this.prefix), top);
                double y = 0.0;
                double height = QbUtil.toInch_export(block.getHeight());
                if (height < 0.0) {
                    height = 0.0;
                }
                if (top) {
                    this.linksHeight = height;
                    y = this.getY(null) - height;
                } else {
                    y = this.getY(null);
                }
                if (y < 0.0) {
                    y = 0.0;
                }
                this.out.write("<DIV ID=\"DivName" + this.divnameCount + "\" STYLE=\"position:absolute; width:100%; height:" + QbUtil.toPixel_export(height) + "px; left:0px; top:" + y + "px;\" >");
                if (block.getText() != null) {
                    this.out.write(block.getText());
                }
                this.out.write("</DIV>\n");
                ++this.divnameCount;
            }
        }
    }
}

