/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.DHTMLReport;
import quadbase.reportdesigner.report.ISubReportExport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.report.SubReportUI;
import quadbase.reportdesigner.util.CSSStyle;

public class DHTMLSubReport
extends DHTMLReport
implements ISubReportExport {
    private static final Logger LOGGER = Logger.getLogger(DHTMLSubReport.class.getName());
    protected boolean finish = false;
    private Object LOCK = new Object();
    private boolean writePageFooter = false;
    double reportWidth;
    private boolean parentCheckFitGroupOnPage;
    protected double pageTopY;
    protected DHTMLReport parent;
    protected ReportSection parentSection;

    public DHTMLSubReport(Report subreport, double x, double y, double reportWidth, double reportHeight, int zIndexOffset, DHTMLReport parent) {
        super(subreport);
        this.isSliderFeature = false;
        this.parent = parent;
        this.pageTopY = y;
        this.rptName = "SUB" + this.reportIndex;
        ++this.reportIndex;
        this.parentCheckFitGroupOnPage = parent.checkFitGroupOnPage;
        this.imageCount = parent.imageCount;
        this.imageName = parent.imageName;
        this.divnameCount = parent.divnameCount;
        this.barcodeCount = parent.barcodeCount;
        this.leftMargin = parent.leftMargin + x;
        this.topMargin = parent.topMargin;
        this.linksHeight = parent.linksHeight;
        this.reportGraphics = parent.reportGraphics;
        if (reportHeight < 0.0) {
            this.pageHeight = parent.pageHeight;
            double footerHeight = 0.0;
            try {
                footerHeight = this.hasNoData(this.report.getPageFooter()) ? 0.0 : this.resizeSection(this.reportGraphics, this.report.getPageFooter(), this.report.getReportTables().elementAt(this.report.getReportTables().size() - 1)).getHeight();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Cannot get footer height", ex);
            }
            this.pageHeight -= footerHeight;
        } else {
            this.checkVisibility = true;
            this.pageHeight = reportHeight;
        }
        this.pageHeaderHeight = parent.pageHeaderHeight;
        this.reportWidth = reportWidth;
        this.maxWidthOfSections = reportWidth;
        this.elementYPos = y;
        this.elementXPos = 0.0;
        this.fontFraction = parent.fontFraction;
        this.currentPageNumber = parent.currentPageNumber;
        this.totalPageNumber = parent.totalPageNumber;
        this.exportPage = parent.exportPage;
        if (parent.reportUI != null) {
            try {
                this.reportUI = new SubReportUI(subreport, QbUtil.pointsToInch((float)x), QbUtil.pointsToInch((float)y), QbUtil.pointsToInch((float)reportWidth), QbUtil.pointsToInch((float)reportHeight), parent.reportUI);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Can't create SubReport UI", ex);
            }
        }
        this.styleTable = parent.styleTable;
        this.styleCount = parent.styleCount;
        this.out = parent.checkFitGroupOnPage ? new StringWriter() : parent.out;
        this.checkTotalPageNumber = parent.checkTotalPageNumber;
        this.exportThread = parent.exportThread;
        this.zIndexOffset = zIndexOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ReportTable table;
            this.formatTable();
            Vector<ReportTable> vec = this.report.getReportTables();
            this.hTable = table = vec.elementAt(0);
            this.fTable = vec.elementAt(vec.size() - 1);
            if (this.report.getInitializeReportError() != null) {
                this.writeSection(ReportUI.createErrorSection(this.getPageWidth(), this.pageHeight, this.report.getInitializeReportError()), table);
            } else {
                this.initRepeatSection();
                this.writeSection(this.report.getPageHeader(), table);
                this.writePageFooter = true;
                this.writeSection(this.report.getReportHeader(), table);
                for (int i = 0; i < vec.size(); ++i) {
                    table = (ReportTable)vec.elementAt(i);
                    this.initRepeatSection();
                    this.setColumnWrap();
                    this.wrapInfo = new double[]{0.0, this.elementYPos, this.elementYPos};
                    this.writeReportTable(table);
                    this.resetColumnWrap();
                }
                table = (ReportTable)vec.elementAt(vec.size() - 1);
                this.writeSection(this.report.getReportFooter(), table);
                this.writeSection(this.report.getPageFooter(), table, this.checkVisibility);
                this.writeMultiPageSectionColor();
            }
        }
        catch (Exception ex) {
            if (!"Subreport page break.".equals(ex.getMessage()) && !"stop writing because of one page export".equals(ex.getMessage())) {
                LOGGER.log(Level.WARNING, "Error running DHTMLSubReport", ex);
            } else {
                LOGGER.log(Level.FINEST, "Stop writing: page break or one page export", ex);
            }
        }
        catch (Error err) {
            LOGGER.log(Level.WARNING, "Error running DHTMLSubReport", err);
        }
        finally {
            this.finish = true;
            Object ex = this.LOCK;
            synchronized (ex) {
                this.LOCK.notify();
            }
        }
    }

    @Override
    public boolean isFinished() {
        return this.finish;
    }

    @Override
    protected double getPageWidth() {
        return this.maxWidthOfSections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pageBreak(ReportSection section, boolean isToc) throws Exception {
        if (this.checkVisibility) {
            throw new Exception("Subreport page break.");
        }
        if (this.elementYPos <= this.pageHeaderHeight) {
            return;
        }
        if (this.report.isExportToSingleWPagination()) {
            double pos = (this.report.getPageHeight() - DHTMLSubReport.getBrowserMargin()) * (double)(this.currentPageNumber - 1);
            if (this.elementYPos <= pos + this.pageHeaderHeight) {
                return;
            }
            pos += this.pageHeight;
            if (section != null ? this.elementYPos + section.getHeight() < pos && !this.forcePageBreak : this.elementYPos + 0.3 < pos && !this.forcePageBreak) {
                return;
            }
        }
        if (this.report.isExportToMultiPages() || this.report.isExportToSingleWPagination()) {
            this.writeMultiPageSectionColor();
            if (this.writePageFooter) {
                this.writeSection(this.report.getPageFooter(), this.fTable, false);
            }
            ++this.currentPageNumber;
            ++this.pagebreaks;
            this.pageBreakRowCount = 0;
            if (this.checkFitGroupOnPage) {
                throw new Exception("stop writing because of fit group on page");
            }
            Object object = this.LOCK;
            synchronized (object) {
                this.LOCK.notify();
                try {
                    this.LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            LOGGER.finest("Export page: " + this.exportPage);
            LOGGER.finest("Current page number: " + this.currentPageNumber);
            if (this.exportPage > 0 && this.currentPageNumber > this.exportPage) {
                throw new Exception("stop writing because of one page export");
            }
            this.pageTopY = this.elementYPos;
            this.elementXPos = 0.0;
            if (this.writePageFooter) {
                this.writeSection(this.report.getPageHeader(), this.hTable);
            }
            this.writeRepeatSection(section);
        }
    }

    @Override
    protected boolean isVisible(ReportElement elt) {
        if (!elt.isVisible()) {
            return false;
        }
        if (this.reportWidth < 0.0) {
            if (this.elementXPos + elt.getX() + elt.getWidth() > this.maxWidthOfSections) {
                this.maxWidthOfSections = this.elementXPos + elt.getX() + elt.getWidth();
            }
            return true;
        }
        return !(this.elementXPos + elt.getX() + elt.getWidth() > this.reportWidth);
    }

    @Override
    public Object getLOCK() {
        return this.LOCK;
    }

    @Override
    public double getY() {
        return this.elementYPos;
    }

    @Override
    public void setY(double y) {
        this.elementYPos = y;
    }

    @Override
    public void setOut(Writer o) {
        this.out = o;
    }

    @Override
    public void setDivnameCount(int dcount) {
        this.divnameCount = dcount;
    }

    @Override
    public int getDivnameCount() {
        return this.divnameCount;
    }

    @Override
    public void setImageCount(int icount) {
        this.imageCount = icount;
    }

    @Override
    public int getImageCount() {
        return this.imageCount;
    }

    @Override
    public void setBarcodeCount(int bcount) {
        this.barcodeCount = bcount;
    }

    @Override
    public int getBarcodeCount() {
        return this.barcodeCount;
    }

    public void setStyleCount(int bcount) {
        this.styleCount = bcount;
    }

    public int getStyleCount() {
        return this.styleCount;
    }

    @Override
    protected void getReportCellStyle(ReportElement elt) {
        CSSStyle style = new CSSStyle(elt);
        if (!this.styleTable.containsKey(style)) {
            this.styleTable.put(style, ".style_" + this.styleCount++);
        }
        if (elt instanceof ReportColumn) {
            ReportColumn col = (ReportColumn)elt;
            if (!this.hasDualColor(col)) {
                return;
            }
            CSSStyle newStyle = new CSSStyle(col);
            newStyle.setFont(col.getFont2());
            newStyle.setFontColor(col.getFontColor2());
            newStyle.setBgColor(col.getBgColor2());
            newStyle.setStyleName(col.getStyleName2());
            if (!this.styleTable.containsKey(newStyle)) {
                this.styleTable.put(newStyle, ".style_" + this.styleCount++);
            }
        }
    }

    @Override
    protected String writeChart(ReportChartObject chart, ReportTable tbl, ReportCell[] cells, int row) {
        try {
            if (!this.parentCheckFitGroupOnPage) {
                return super.writeChart(chart, tbl, cells, row);
            }
            return "";
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Cannot run chart", e);
            return "";
        }
    }

    double getStartY() {
        return this.pageTopY;
    }

    void setParentSection(ReportSection parentSection) {
        this.parentSection = parentSection;
    }

    void writeMultiPageSectionColor() throws IOException {
        if (this.report.isExportToMultiPages() && this.parentSection != null) {
            double d = this.parentSection.getHeight();
            this.parentSection.setHeight(this.getY() - this.pageTopY);
            this.parent.writeSectionBgColor(this.parentSection);
            this.parentSection.setHeight(d);
        }
    }
}

