/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.Bookmark;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.report.DHTMLReport;
import quadbase.reportdesigner.report.DHTMLSubReport;

public class DHTMLTOCObject
extends DHTMLSubReport {
    private static final Logger LOGGER = Logger.getLogger(DHTMLTOCObject.class.getName());
    private TableOfContents toc;
    private ReportTable tbl;
    private boolean drawTop = true;
    private boolean drawBottom = false;

    public DHTMLTOCObject(TableOfContents toc, ReportTable tbl, double x, double y, double reportWidth, double reportHeight, DHTMLReport parent) {
        super(parent.report, x, y, reportWidth, reportHeight, toc.getZ(), parent);
        if (reportHeight < 0.0) {
            this.pageHeight = parent.pageHeight;
        } else {
            this.checkVisibility = true;
            this.pageHeight = reportHeight;
        }
        this.toc = toc;
        this.tbl = tbl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            double lineSpace = 0.0;
            double miniSpacer = 0.2;
            double old_elementYPos = this.elementYPos;
            double old_elementXPos = this.elementXPos;
            this.elementYPos += this.toc.getY();
            for (int i = 0; i < this.toc.getBookmarks().size(); ++i) {
                Bookmark entry = this.toc.getBookmarks().elementAt(i);
                double indentWidth = this.toc.getIndentInInches(entry);
                ReportCell numberingElt = this.toc.getFormattedNumbering(entry);
                double numberingWidth = 0.1;
                if (numberingElt != null) {
                    numberingWidth = numberingElt.getWidth();
                }
                ReportCell pageNumberElt = this.toc.getFormattedPageNumber(entry);
                double pageNumberWidth = pageNumberElt.getWidth();
                double maxTitleWidth = this.toc.getWidth() - indentWidth - numberingWidth - miniSpacer - pageNumberWidth;
                double entryHeight = this.toc.getEntryHeight(entry, maxTitleWidth);
                if (!this.toc.isResizeToFitContent() && this.elementYPos + entryHeight > old_elementYPos + this.toc.getHeight()) break;
                this.pageBreak(null, entryHeight);
                this.elementXPos += indentWidth;
                if (this.toc.isShowNumbering()) {
                    if (numberingElt == null) {
                        numberingElt = new ReportGrid();
                        numberingElt.setWidth(0.02);
                        numberingElt.setHeight(0.02);
                        numberingElt.setBorderThickness(1);
                        numberingElt.setY(entryHeight / 2.0 - 0.02);
                        numberingElt.setBgColor(Color.darkGray);
                    }
                    this.writeTableDataElement(numberingElt, this.tbl, null);
                    this.elementXPos += numberingElt.getWidth();
                }
                ReportCell titleElt = this.toc.getFormattedTitle(entry, maxTitleWidth);
                titleElt.setWidth(titleElt.getWidth() * 1.2);
                this.writeTableDataElement(titleElt, this.tbl, null);
                this.elementXPos += titleElt.getWidth();
                if (this.toc.isShowPageNumber() && (this.report.isExportToMultiPages() || this.report.isExportToSingleWPagination())) {
                    if (this.toc.isShowSpacer()) {
                        double spacerWidth = old_elementXPos + this.toc.getWidth() - this.elementXPos - pageNumberWidth - 0.001;
                        ReportCell line = this.toc.getSpacer(spacerWidth, entryHeight, entry);
                        this.writeTableDataElement(line, this.tbl, null);
                        this.elementXPos += line.getWidth();
                    }
                    this.toc.setCellHeight(pageNumberElt, entryHeight, entry);
                    this.writeTableDataElement(pageNumberElt, this.tbl, null);
                }
                this.elementXPos = old_elementXPos;
                this.elementYPos = this.elementYPos + entryHeight + lineSpace;
            }
            this.drawBottom = true;
            this.drawBorder();
            this.writeMultiPageSectionColor();
        }
        catch (Exception ex) {
            if (!"Subreport page break.".equals(ex.getMessage())) {
                LOGGER.log(Level.WARNING, "Error running DHTMLTOCObject", ex);
            } else {
                LOGGER.log(Level.FINEST, "Stop running DHTMLTOCObject: subreport page break", ex);
            }
        }
        catch (Error err) {
            LOGGER.log(Level.WARNING, "Error running DHTMLTOCObject", err);
        }
        finally {
            Object LOCK;
            this.finish = true;
            Object object = LOCK = this.getLOCK();
            synchronized (object) {
                LOCK.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pageBreak(ReportSection section, double requireHeight) throws Exception {
        double availableHeight = this.pageHeight - this.elementYPos;
        if (availableHeight >= requireHeight) {
            return;
        }
        if (this.checkVisibility) {
            throw new Exception("Subreport page break.");
        }
        if (this.elementYPos <= this.pageHeaderHeight) {
            return;
        }
        this.drawBorder();
        if (this.report.isExportToMultiPages()) {
            Object LOCK;
            this.writeMultiPageSectionColor();
            ++this.currentPageNumber;
            Object object = LOCK = this.getLOCK();
            synchronized (object) {
                LOCK.notify();
                try {
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.pageTopY = this.elementYPos;
            this.elementXPos = 0.0;
        }
    }

    private void drawBorder() throws Exception {
        int x = QbUtil.toPixel_export(this.getX(null));
        int y = QbUtil.toPixel_export(this.getY(null) - (this.elementYPos - this.pageTopY));
        int width = QbUtil.toPixel_export(this.maxWidthOfSections);
        int height = QbUtil.toPixel_export(this.elementYPos - this.pageTopY);
        if (this.checkVisibility) {
            height = QbUtil.toPixel_export(this.toc.getHeight());
        }
        if (this.toc.getBorderThickness() > 0 && this.toc.getBorderColor() != null) {
            x -= this.toc.getBorderThickness();
            y -= this.toc.getBorderThickness();
            width = width + this.toc.getBorderThickness() * 2 - 1;
            height = height + this.toc.getBorderThickness() * 2 - 1;
        }
        if (this.toc.getBorderThickness() > 0 && this.toc.getBorderColor() != null || this.toc.getBgColor() != null) {
            StringBuffer dhtml = new StringBuffer();
            dhtml.append("<DIV ID=\"DivName");
            dhtml.append(this.divnameCount);
            dhtml.append("\" STYLE=\"position:absolute; ");
            dhtml.append("left:" + x + "px; ");
            dhtml.append("top:" + y + "px; ");
            dhtml.append("width:" + width + "px; height:").append(height).append("px; ");
            dhtml.append("margin:0px 0px 0px 0px; padding:0px 0px 0xp 0px; ");
            if (this.toc.getBgColor() != null) {
                dhtml.append("background-color:").append(DHTMLTOCObject.colorToHTML(this.toc.getBgColor())).append("; ");
            }
            if (this.toc.getBorderThickness() > 0 && this.toc.getBorderColor() != null) {
                dhtml.append("border-style:solid; ");
                dhtml.append("border-width:");
                dhtml.append(this.drawTop ? this.toc.getBorderThickness() : 0).append("px ");
                dhtml.append(this.toc.getBorderThickness()).append("px ");
                dhtml.append(this.drawBottom || this.checkVisibility ? this.toc.getBorderThickness() : 0).append("px ");
                dhtml.append(this.toc.getBorderThickness()).append("px; ");
                dhtml.append("border-color:").append(DHTMLTOCObject.colorToHTML(this.toc.getBorderColor())).append("; ");
            }
            dhtml.append("z-index: " + (this.toc.getZ() + this.parent.zIndexOffset + 1));
            dhtml.append("\">");
            dhtml.append("</DIV>\n");
            ++this.divnameCount;
            this.out.write(dhtml.toString());
        }
        if (this.drawTop) {
            this.drawTop = false;
        }
    }
}

