/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.DataInput;
import java.io.DataInputStream;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.ClassFileUtil;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DBAccess;
import quadbase.reportdesigner.report.FilterInfo;
import quadbase.reportdesigner.report.PreprocInfo;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.util.IResultSet;
import quadbase.reportdesigner.util.StreamResultSet;

public class DataFileInput {
    public static final int TEXTFILE = 2;
    public static final int XMLFILE = 4;
    public static final int OLAPRESULTSET = 10;
    public static final int CLASSFILE = 6;
    public static final int XMLFILEQUERY = 7;

    public ColData[] readProcessedData(String filename, boolean isTransposed, boolean[] transposeCol, PreprocInfo procInfo) throws Exception {
        return this.readProcessedData(filename, isTransposed, transposeCol, null, procInfo, 0, -1, null, 0);
    }

    public ColData[] readProcessedData(String filename, boolean isTransposed, boolean[] transposeCol, PreprocInfo procInfo, int dataType) throws Exception {
        return this.readProcessedData(filename, isTransposed, transposeCol, null, procInfo, 0, -1, null, dataType);
    }

    public synchronized ColData[] readProcessedData(String filename, boolean isTransposed, boolean[] transposeCol, FilterInfo filterInfo, PreprocInfo procInfo, int startIndex, int displayRow, XMLFileQueryInfo xmlInfo, int dataType) throws Exception {
        return this.readProcessedData(filename, isTransposed, transposeCol, filterInfo, procInfo, startIndex, displayRow, xmlInfo, dataType, null);
    }

    public synchronized ColData[] readProcessedData(String filename, boolean isTransposed, boolean[] transposeCol, FilterInfo filterInfo, PreprocInfo procInfo, int startIndex, int displayRow, XMLFileQueryInfo xmlInfo, int dataType, String encoding) throws Exception {
        if ((ServerMessage.useServer || !ServerMessage.isLoadBalancer) && filename != null) {
            int message = xmlInfo != null ? 24327 : (filterInfo != null ? 28816 : 32415);
            DataInputStream din = ReadDataFile.getFromServer(filename, isTransposed, transposeCol, filterInfo, procInfo, message, false, xmlInfo, dataType, encoding);
            return DataFileInput.getColDataFromStream(din);
        }
        ReadDataFile readfile = new ReadDataFile();
        IResultSet rs = dataType == 7 ? readfile.createXMLQueryResultSet(xmlInfo) : (IOUtil.isXMLFormat(filename) || dataType == 4 ? readfile.createXMLResultSet(filename) : (dataType == 6 ? readfile.getClassResultSet(filename) : new StreamResultSet(readfile.getInputStream(null, filename), encoding)));
        rs = DBAccess.processResultSet(rs, false, isTransposed, transposeCol, filterInfo, procInfo);
        return ColData.getColData(rs, startIndex, displayRow);
    }

    public static ColData[] getColDataFromStream(DataInput din) throws Exception {
        int i;
        int nRow = din.readInt();
        int nCol = din.readInt();
        ColData[] colData = new ColData[nCol + 1];
        for (i = 0; i < nCol; ++i) {
            String colName = IOUtil.readString(din, true);
            String tblName = IOUtil.readString(din, true);
            int dtype = din.readInt();
            colData[i] = new ColData(colName, tblName, dtype, nRow, colData.length);
        }
        colData[nCol] = new ColData("qbCount", 4, nRow, colData.length);
        for (i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                Object x = DataType.read(din, colData[j].getOriginalDataType(), 7004, true);
                colData[j].add(x);
            }
            colData[nCol].add(i);
        }
        return colData;
    }

    public synchronized ColData[] readProcessedData(String filename, boolean isTransposed, boolean[] transposeCol, FilterInfo filterInfo, PreprocInfo procInfo, int startIndex, int displayRow, QueryInParamSet paramSet) throws Exception {
        if (ServerMessage.useServer || !ServerMessage.isLoadBalancer) {
            DataInput din = ReadDataFile.getFromServer(filename, isTransposed, transposeCol, filterInfo, procInfo, startIndex, displayRow, paramSet);
            return DataFileInput.getColDataFromStream(din);
        }
        IResultSet rs = (IResultSet)ClassFileUtil.getResultSet(filename, paramSet);
        rs = DBAccess.processResultSet(rs, false, isTransposed, transposeCol, filterInfo, procInfo);
        return ColData.getColData(rs, startIndex, displayRow);
    }

    public static IResultSet getClassResultSet(String filename, QueryInParamSet paramSet) throws Exception {
        if (ServerMessage.useServer || !ServerMessage.isLoadBalancer) {
            DataInput din = ReadDataFile.getFromServer(filename, false, null, null, null, 0, -1, paramSet);
            return ColData.getResultSet(DataFileInput.getColDataFromStream(din));
        }
        return (IResultSet)ClassFileUtil.getResultSet(filename, paramSet);
    }
}

