/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.applet.Applet;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportAPI.DrillDownReport;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.SaveReport;
import quadbase.reportdesigner.util.IQueryInParam;
import quadbase.reportdesigner.util.IQueryMultiValueInParam;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class DrillDownNode
extends DefaultMutableTreeNode
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(DrillDownNode.class.getName());
    public static final String DRILLDOWN_DIR = "DrillDown/";
    String filename = "";
    private boolean useAbsolutePath = false;
    private byte[] bytearray;
    private byte[] notPackedBytearray;
    private String domainPath = "";
    private boolean saved = true;
    private DrillDownReport report = null;
    private boolean sentThisNodeToServlet = false;
    private String key = null;
    private int[] mapping = new int[0];
    private boolean crossTabDrillDown = false;
    public static final Enumeration<DrillDownNode> EMPTY_ENUMERATION = new Enumeration<DrillDownNode>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public DrillDownNode nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };
    protected DrillDownNode parent = null;
    protected transient String userObject;
    private boolean selected = false;
    private String chartPath = null;
    private String imagePath = null;
    private String subReportPath = null;
    private String drillDownPath = null;
    private String saveDir = null;
    private String saveURL = null;

    public DrillDownNode() {
        this(null);
    }

    public DrillDownNode(String userObject) {
        this.userObject = userObject;
    }

    public String getFileName() {
        return this.getFileName(null);
    }

    public String getFileName(FileInMemTable subFilesTable) {
        if (this.filename == null || this.filename.length() == 0) {
            return this.filename;
        }
        String str = this.filename;
        if (this.domainPath != null && !this.domainPath.equals("")) {
            String filename2 = str.replaceAll("\\\\", "/");
            if (filename2.indexOf("/ReportFiles/") > -1) {
                return this.domainPath + filename2.substring(filename2.lastIndexOf("/ReportFiles/") + 1);
            }
            if (filename2.indexOf("/SubReport/") > -1) {
                return this.domainPath + filename2.substring(filename2.lastIndexOf("/SubReport/") + 1);
            }
            if (filename2.indexOf("/DrillDown/") > -1) {
                return this.domainPath + filename2.substring(filename2.lastIndexOf("/DrillDown/") + 1);
            }
            return this.domainPath + this.filename;
        }
        try {
            if (subFilesTable != null) {
                if (!Report.fileExistsInMemoryTable(subFilesTable, this.filename)) {
                    String filename2 = str.replaceAll("\\\\", "/");
                    if (filename2.indexOf("/SubReport/") > -1) {
                        return filename2.substring(filename2.lastIndexOf("/SubReport/") + 1);
                    }
                    if (filename2.indexOf("/DrillDown/") > -1) {
                        return filename2.substring(filename2.lastIndexOf("/DrillDown/") + 1);
                    }
                }
            } else if (!new FileInfo(this.filename).exists()) {
                String filename2 = str.replaceAll("\\\\", "/");
                if (filename2.indexOf("/SubReport/") > -1) {
                    return filename2.substring(filename2.lastIndexOf("/SubReport/") + 1);
                }
                if (filename2.indexOf("/DrillDown/") > -1) {
                    return filename2.substring(filename2.lastIndexOf("/DrillDown/") + 1);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed to get filename", e);
        }
        return str;
    }

    public void setFileName(String qf) {
        this.filename = this.domainPath != null && !this.domainPath.equals("") && qf.indexOf(this.domainPath) >= 0 ? qf.substring(qf.indexOf(this.domainPath) + this.domainPath.length()) : qf;
    }

    public int[] getColumnMapping() {
        return this.mapping;
    }

    public void setColumnMapping(int[] m) {
        if (m != null) {
            this.mapping = m;
        }
    }

    public void setCrossTabDrillDown(boolean state) {
        this.crossTabDrillDown = state;
    }

    public boolean isCrossTabDrillDown() {
        return this.crossTabDrillDown;
    }

    public void setHTMLParameters(String dirLocation, String url) {
        this.saveDir = dirLocation;
        this.saveURL = url;
        if (this.saveURL == null || this.saveDir == null) {
            return;
        }
        if (!this.saveDir.endsWith("/") && !this.saveDir.endsWith("\\")) {
            this.saveDir = this.saveDir + File.separator;
        }
        if (!this.saveURL.endsWith("/")) {
            this.saveURL = this.saveURL + "/";
        }
    }

    public void setChartPath(String path) {
        this.chartPath = path;
    }

    public void setImagePath(String path) {
        this.imagePath = path;
    }

    public String getChartPath() {
        return this.chartPath;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setSubReportPath(String path) {
        this.subReportPath = path;
    }

    public String getSubReportPath() {
        return this.subReportPath;
    }

    public void setDrillDownPath(String path) {
        this.drillDownPath = path;
    }

    public String getDrillDownPath() {
        return this.drillDownPath;
    }

    @Override
    public DrillDownNode getChildAt(int index) {
        return (DrillDownNode)super.getChildAt(index);
    }

    @Override
    public DrillDownNode getRoot() {
        return (DrillDownNode)super.getRoot();
    }

    public DrillDownNode createNewChild(String name, FileInMemTable subFilesTable) {
        DrillDownNode newChild = new DrillDownNode(name);
        newChild.domainPath = this.domainPath;
        this.add(newChild);
        boolean useXML = false;
        boolean usePAK = true;
        String newFile = this.getRoot().filename;
        newFile = newFile.substring(newFile.lastIndexOf(92) + 1);
        newFile = newFile.substring(newFile.lastIndexOf(47) + 1);
        if (newFile.toUpperCase().endsWith(".PAK")) {
            newFile = newFile.substring(0, newFile.length() - 4);
            usePAK = true;
        } else if (newFile.toUpperCase().endsWith(".XML")) {
            newFile = newFile.substring(0, newFile.length() - 4);
            useXML = true;
            usePAK = false;
        } else if (newFile.toUpperCase().endsWith(".RPT")) {
            newFile = newFile.substring(0, newFile.length() - 4);
            usePAK = false;
        }
        newFile = newFile.replace(' ', '_');
        newFile = DRILLDOWN_DIR + newFile;
        Applet applet = ServerMessage.getApplet();
        newFile = this.useAbsolutePath ? (ServerMessage.useServer || !ServerMessage.isLoadBalancer || applet == null ? IOUtil.getWorkingDirectory() + File.separator + newFile + "_lvl" + newChild.getLevel() + this.getChildCount() : IOUtil.getCodeBase(applet) + newFile + "_lvl" + newChild.getLevel() + this.getChildCount()) : newFile + "_lvl" + newChild.getLevel() + this.getChildCount();
        int ct = 0;
        String tmp = this.domainPath == null ? newFile : this.domainPath + newFile;
        String fName = tmp + (usePAK ? ".pak" : (useXML ? ".xml" : ".rpt"));
        if (usePAK && subFilesTable != null) {
            try {
                while (Report.fileExists(subFilesTable, fName)) {
                    fName = tmp + "_" + ct++ + (usePAK ? ".pak" : (useXML ? ".xml" : ".rpt"));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, "DrillDown - File in memory exist check - Failed: ", e);
            }
        } else {
            try {
                while (new FileInfo(fName).exists()) {
                    fName = tmp + "_" + ct++ + (usePAK ? ".pak" : (useXML ? ".xml" : ".rpt"));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, "DrillDown - File exist check - Failed: ", e);
            }
        }
        newChild.setFileName(fName);
        return newChild;
    }

    public void changeFileName(String newName) {
        LOGGER.finest("Old file name: " + this.filename);
        LOGGER.finest("New file name: " + newName);
        newName = newName.substring(newName.lastIndexOf(92) + 1);
        newName = newName.substring(newName.lastIndexOf(47) + 1);
        newName = newName.substring(0, newName.length() - 4);
        String path = this.filename.substring(0, this.filename.lastIndexOf(92) + 1);
        path = this.filename.substring(0, this.filename.lastIndexOf(47) + 1);
        if (newName.indexOf("_lvl") > 0) {
            String f = this.filename.substring(this.filename.indexOf("_lvl"));
            f = f.lastIndexOf(95) > 0 ? f.substring(0, f.lastIndexOf(95)) : f.substring(0, f.indexOf(".rpt"));
            String n = newName.substring(newName.indexOf("_lvl"));
            if (n.lastIndexOf(95) > 0) {
                n = n.substring(0, n.lastIndexOf(95));
            } else if (n.endsWith(".rpt") || n.endsWith(".pak")) {
                n = n.substring(0, n.length() - 4);
            }
            newName = newName.replaceFirst(n, f) + ".rpt";
        } else {
            newName = this.filename.indexOf("_lvl") > 0 ? newName + this.filename.substring(this.filename.indexOf("_lvl")) : newName + ".rpt";
        }
        this.setFileName(path + newName);
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean state) {
        this.saved = state;
    }

    public DrillDownReport getDrillDownReport() {
        return this.report;
    }

    public void setDrillDownReport(DrillDownReport r) {
        this.report = r;
        if (this.report.getFileName() == null) {
            this.report.setFileName(this.getFileName());
        }
    }

    public boolean equals(DrillDownNode _node) {
        return this.filename.equals(_node.filename);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    public void setName(String userObject) {
        this.userObject = userObject;
    }

    public String getName() {
        return this.userObject;
    }

    @Override
    public void removeFromParent() {
        DrillDownNode parent = (DrillDownNode)this.getParent();
        if (parent != null) {
            parent.remove(this);
        }
    }

    public void remove(DrillDownNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.remove(this.getIndex(aChild));
    }

    @Override
    public void removeAllChildren() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public void add(DrillDownNode newChild) {
        if (newChild != null && newChild.getParent() == this) {
            this.insert(newChild, this.getChildCount() - 1);
        } else {
            this.insert(newChild, this.getChildCount());
        }
    }

    public boolean isNodeAncestor(DrillDownNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        DrillDownNode ancestor = this;
        do {
            if (ancestor != anotherNode) continue;
            return true;
        } while ((ancestor = (DrillDownNode)ancestor.getParent()) != null);
        return false;
    }

    public boolean isNodeDescendant(DrillDownNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        return anotherNode.isNodeAncestor(this);
    }

    public DrillDownNode getSharedAncestor(DrillDownNode aNode) {
        DrillDownNode node2;
        DrillDownNode node1;
        int diff;
        if (aNode == this) {
            return this;
        }
        if (aNode == null) {
            return null;
        }
        int level1 = this.getLevel();
        int level2 = aNode.getLevel();
        if (level2 > level1) {
            diff = level2 - level1;
            node1 = aNode;
            node2 = this;
        } else {
            diff = level1 - level2;
            node1 = this;
            node2 = aNode;
        }
        while (diff > 0) {
            node1 = (DrillDownNode)node1.getParent();
            --diff;
        }
        do {
            if (node1 == node2) {
                return node1;
            }
            node1 = (DrillDownNode)node1.getParent();
            node2 = (DrillDownNode)node2.getParent();
        } while (node1 != null);
        if (node2 != null) {
            throw new Error("nodes should be null");
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.userObject == null) {
            return null;
        }
        if (this.selected) {
            return "** " + this.userObject + " **";
        }
        return this.userObject;
    }

    @Override
    public Object clone() {
        DrillDownNode newNode = null;
        newNode = (DrillDownNode)super.clone();
        newNode.removeAllChildren();
        newNode.removeFromParent();
        return newNode;
    }

    @Override
    public String getUserObject() {
        return this.userObject;
    }

    public void setSelected(boolean state) {
        this.selected = state;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setByteArray(byte[] barray) {
        this.bytearray = barray;
    }

    public byte[] getByteArray() {
        return this.bytearray;
    }

    public byte[] getNotPackedByteArray() {
        if (this.notPackedBytearray == null) {
            if (this.bytearray != null) {
                try {
                    Report rpt = new LoadReport().loadReportFromByteArray(this.getByteArray());
                    ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
                    DataOutputStream out = new DataOutputStream(fstream);
                    SaveReport sr = new SaveReport(rpt);
                    sr.generatePAKFile(false);
                    sr.saveToFile(this.filename, out);
                    out.close();
                    fstream.close();
                    this.notPackedBytearray = fstream.toByteArray();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Can't get report byte array", ex);
                }
            } else {
                ByteArrayOutputStream bytestream = new ByteArrayOutputStream(2048);
                ReadDataFile readfile = new ReadDataFile();
                try {
                    String fname = LoadReport.generateFullName(this.getFileName());
                    DataInputStream in = readfile.getInputStream(null, fname);
                    int c = in.read();
                    while (c != -1) {
                        bytestream.write(c);
                        c = in.read();
                    }
                    in.close();
                    bytestream.close();
                    this.notPackedBytearray = bytestream.toByteArray();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Can't get report byte array", ex);
                }
            }
        }
        return this.notPackedBytearray;
    }

    public boolean isValidDrillDownNode() {
        try {
            if (this.getByteArray() == null && (this.getFileName() == null || this.getFileName().equals(""))) {
                return false;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Can't check for valid drill-down node", ex);
        }
        return true;
    }

    public boolean isMultiValueParameter() {
        return this.isMultiValueParameter(null);
    }

    public boolean isMultiValueParameter(FileInMemTable subFilesTable) {
        try {
            LoadReport lr = new LoadReport();
            lr.setBackupDataUsed(true);
            lr.setRelativeDomainPath(this.domainPath);
            Report rpt = null;
            byte[] bytes = null;
            if (subFilesTable != null) {
                lr.setSubFilesTable(subFilesTable);
                bytes = subFilesTable.get(this.getFileName());
            }
            rpt = this.getByteArray() != null ? lr.loadReportFromByteArray(this.getByteArray()) : (bytes != null ? lr.loadReportFromByteArray(bytes) : lr.loadReportFromFile(this.getFileName()));
            if (rpt.dbInfo != null && rpt.dbInfo instanceof IQueryFileInfo) {
                IQueryInParam[] queryParamSet = ReportUtil.getInParam(rpt.dbInfo);
                for (int i = 0; i < queryParamSet.length; ++i) {
                    if (queryParamSet[i] instanceof IQueryMultiValueInParam) continue;
                    return false;
                }
                return true;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Can't check for multi value parameter", ex);
        }
        return false;
    }

    public String getServletLink(Report rpt, boolean ddBytesSentToServlet, int exportType) {
        String link;
        String servletDirectory = rpt.getServletDirectory();
        if (servletDirectory != null) {
            if (!(servletDirectory = servletDirectory.replace('\\', '/')).startsWith("/")) {
                servletDirectory = "/" + servletDirectory;
            }
            if (!servletDirectory.endsWith("/") && !servletDirectory.endsWith(".")) {
                servletDirectory = servletDirectory + "/";
            }
        } else {
            servletDirectory = "/servlet/";
        }
        String security = "";
        if (rpt.getPreviewSecurityLevel() != null) {
            security = "&SECURITYLEVEL=" + QbUtil.urlEncode(rpt.getPreviewSecurityLevel());
        }
        if (rpt.isDHTMLViewerUsed()) {
            link = "ReportViewer.jsp?";
            if (rpt.getPreviewSecurityLevel() != null) {
                security = "&SecurityLevel=" + QbUtil.urlEncode(rpt.getPreviewSecurityLevel());
            }
            link = link + "ReportPath=" + QbUtil.urlEncode(this.getFileName(rpt.getSubFilesTable())) + security;
        } else {
            String val;
            String drillDownServletName;
            String string = drillDownServletName = rpt.isForDeploy() ? "DrillDownReportServletDeployed?" : "DrillDownReportServlet?";
            link = rpt.relativeUrlToServlets() ? servletDirectory + drillDownServletName : (rpt.isHttpsDynamicExport() ? "https://" + rpt.getHttpsServerName() + ":" + rpt.getHttpsServletRunnerPort() + servletDirectory + drillDownServletName : rpt.protocol + rpt.serverName + ":" + rpt.servletRunnerPort + servletDirectory + drillDownServletName);
            if (rpt.getDynamicReportKeyGenerator() != null) {
                if (!ddBytesSentToServlet || !this.sentThisNodeToServlet) {
                    this.key = rpt.getDynamicReportKeyGenerator().generateReportKey(this.getByteArray());
                    this.sentThisNodeToServlet = true;
                }
                link = link + "KEY=" + this.key;
            } else if (!ddBytesSentToServlet) {
                String root_fileName;
                if (!this.getRoot().getFileName().equals("") && this.getRoot().getFileName().toLowerCase().endsWith(".pak") && rpt.parentNode == null) {
                    val = root_fileName = this.getRoot().getFileName();
                    if (new File(root_fileName).isAbsolute()) {
                        val = QbUtil.createRelativePath(root_fileName, ServerMessage.getMainPath());
                    }
                    link = link + "ROOT_FILENAME=" + QbUtil.urlEncode(val) + "&";
                } else if (rpt.parentNode != null && rpt.parentNode.getFileName() != null && !rpt.parentNode.getFileName().equals("") && rpt.parentNode.getFileName().toLowerCase().endsWith(".pak")) {
                    val = root_fileName = rpt.parentNode.getFileName();
                    if (new File(root_fileName).isAbsolute()) {
                        val = QbUtil.createRelativePath(root_fileName, ServerMessage.getMainPath());
                    }
                    link = link + "ROOT_FILENAME=" + QbUtil.urlEncode(val) + "&";
                }
                if (this.getRoot() != null && this.getRoot().getFileName() != null && SaveReport.isPAKFile(this.getRoot().getFileName())) {
                    this.setFileName(SaveReport.getPakFileName(this.getFileName()));
                }
                link = link + "FILENAME=" + QbUtil.urlEncode(this.getFileName());
            } else {
                link = link + "KEY=" + QbUtil.urlEncode(this.getFileName());
            }
            link = link + "&FORMAT=" + exportType + security;
            link = link + "&USESERVER=" + (ServerMessage.useServer ? QbUtil.urlEncode("true") : QbUtil.urlEncode("false"));
            if (this.getChartPath() != null) {
                String theChartPath;
                val = theChartPath = this.getChartPath();
                if (new File(theChartPath).isAbsolute()) {
                    val = QbUtil.createRelativePath(theChartPath, ServerMessage.getMainPath());
                }
                link = link + "&CHARTPATH=" + QbUtil.urlEncode(val);
            }
            if (this.getImagePath() != null) {
                link = link + "&IMAGEPATH=" + QbUtil.urlEncode(this.getImagePath());
            }
            if (this.getDrillDownPath() != null) {
                link = link + "&DRILLDOWNPATH=" + QbUtil.urlEncode(this.getDrillDownPath());
            }
            if (this.getSubReportPath() != null) {
                String theSubRptPath;
                val = theSubRptPath = this.getSubReportPath();
                if (new File(theSubRptPath).isAbsolute()) {
                    val = QbUtil.createRelativePath(theSubRptPath, ServerMessage.getMainPath());
                }
                link = link + "&SUBREPORTPATH=" + QbUtil.urlEncode(this.getSubReportPath());
            }
            if (rpt.relativeUrlToServlets()) {
                link = link + "&RELATIVEURLTOIMGGEN=" + QbUtil.urlEncode("true");
            }
            if (rpt.isHttpsDynamicExport()) {
                link = link + "&ISHTTPS=" + QbUtil.urlEncode("true");
                link = link + "&httpsServerName=" + QbUtil.urlEncode(rpt.getHttpsServerName());
                link = link + "&httpsPort=" + QbUtil.urlEncode(String.valueOf(rpt.getHttpsServletRunnerPort()));
            }
            if (!rpt.getServletDirectory().equals("servlet/")) {
                link = link + "&SERVLETDIRECTORY=" + QbUtil.urlEncode(rpt.getServletDirectory());
            }
        }
        if (rpt.getReplaceColumnInfoURL() != null) {
            link = link + "&ReplaceColumnXML=" + QbUtil.urlEncode(rpt.getReplaceColumnInfoURL());
        }
        return link;
    }

    public void setDomainPath(String path) {
        this.domainPath = path;
    }

    public String getDomainPath() {
        return this.domainPath;
    }
}

