/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.EJBUtil;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.ColMetaData;
import quadbase.reportdesigner.report.IOUtil2;

public class EJBAccess {
    private static final Logger LOGGER = Logger.getLogger(EJBAccess.class.getName());

    public static ColData[] retrieveResult(String jndiName, String homeName, String remoteName, String selectedMethodName, Object[] param, Hashtable environment) {
        if (!ServerMessage.useServer) {
            try {
                Class<?> homeClass = Class.forName(homeName);
                Class<?> remoteClass = Class.forName(remoteName);
                InitialContext initial = new InitialContext(environment);
                Object objref = initial.lookup(jndiName);
                Object home = PortableRemoteObject.narrow((Object)objref, homeClass);
                Method[] getters = EJBAccess.retrieveGetters(remoteClass);
                Method method = EJBAccess.getMethod(homeClass, selectedMethodName);
                return EJBAccess.getColData(getters, method, home, param);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Can't retrieve result", e);
                return null;
            }
        }
        return EJBAccess.retrieveResultFromServer(jndiName, homeName, remoteName, selectedMethodName, param, environment);
    }

    private static ColData[] retrieveResultFromServer(String jndiName, String homeName, String remoteName, String selectedMethodName, Object[] param, Hashtable environment) {
        IConnection socket = null;
        ByteArrayOutputStream bstream = null;
        DataOutputStream dout = null;
        try {
            socket = ServerMessage.createConnection();
            bstream = new ByteArrayOutputStream(50);
            dout = new DataOutputStream(bstream);
            dout.writeShort(32416);
            IOUtil.writeString(dout, jndiName);
            IOUtil.writeString(dout, homeName);
            IOUtil.writeString(dout, remoteName);
            IOUtil.writeString(dout, selectedMethodName);
            dout.writeInt(param.length);
            for (Object element : param) {
                IOUtil.writeString(dout, element.getClass().getName());
                IOUtil.writeString(dout, element.toString());
            }
            int envsize = 0;
            if (environment != null) {
                envsize = environment.size();
            }
            dout.writeInt(envsize);
            if (envsize > 0) {
                Enumeration e = environment.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    IOUtil.writeString(dout, (String)key);
                    IOUtil.writeString(dout, (String)environment.get(key));
                }
            }
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil2.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int len = dstream.readInt();
            byte[] indata = new byte[len];
            dstream.readFully(indata, 0, len);
            dstream.close();
            socket.close();
            return EJBAccess.getColDataFromStream(new DataInputStream(new ByteArrayInputStream(indata)));
        }
        catch (Exception ex) {
            try {
                LOGGER.log(Level.FINE, "Communication failure", ex);
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
        }
        catch (Error err) {
            try {
                LOGGER.log(Level.FINE, "Communication failure", err);
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
        }
        return null;
    }

    private static ColData[] getColDataFromStream(DataInput din) throws Exception {
        int i;
        int nRow = din.readInt();
        int nCol = din.readInt();
        ColData[] colData = new ColData[nCol + 1];
        String[] returnType = new String[nCol];
        for (i = 0; i < nCol; ++i) {
            returnType[i] = IOUtil.readString(din, true);
            colData[i] = new ColData(IOUtil.readString(din, true), din.readInt(), nRow, colData.length);
        }
        colData[nCol] = new ColData("qbCount", 4, nRow, colData.length);
        for (i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                colData[j].add(EJBUtil.getInputValue(returnType[j], IOUtil.readString(din, true)));
            }
            colData[nCol].add(i);
        }
        return colData;
    }

    public static Vector<ColMetaData> getColMetaData(String remoteName) {
        if (!ServerMessage.useServer) {
            try {
                Class<?> remoteClass = Class.forName(remoteName);
                Method[] getters = EJBAccess.retrieveGetters(remoteClass);
                Vector<ColMetaData> metaData = new Vector<ColMetaData>();
                for (Method getter : getters) {
                    String colName = getter.getName().substring(3);
                    String retTypeName = getter.getReturnType().getName();
                    int type = EJBUtil.mapFieldType(retTypeName);
                    metaData.addElement(new ColMetaData(colName, type));
                }
                return metaData;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to get column meta data", e);
                return null;
            }
        }
        return EJBAccess.getColMetaDataFromServer(remoteName);
    }

    private static Vector getColMetaDataFromServer(String remoteName) {
        IConnection socket = null;
        ByteArrayOutputStream bstream = null;
        DataOutputStream dout = null;
        try {
            socket = ServerMessage.createConnection();
            bstream = new ByteArrayOutputStream(50);
            dout = new DataOutputStream(bstream);
            dout.writeShort(32417);
            IOUtil.writeString(dout, remoteName);
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil2.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int nCol = dstream.readInt();
            Vector<ColMetaData> metaData = new Vector<ColMetaData>();
            for (int i = 0; i < nCol; ++i) {
                String colName = IOUtil.readString(dstream, true);
                int type = dstream.readInt();
                metaData.addElement(new ColMetaData(colName, type));
            }
            dstream.close();
            socket.close();
            return metaData;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Communication failure", ex);
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
        }
        catch (Error err) {
            try {
                LOGGER.log(Level.FINE, "Communication failure", err);
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
        }
        return null;
    }

    private static Method[] retrieveGetters(Class remoteClass) {
        Method[] remoteMethods = remoteClass.getDeclaredMethods();
        Vector<Method> temp = new Vector<Method>();
        for (Method remoteMethod : remoteMethods) {
            String methodName = remoteMethod.getName();
            if (!methodName.startsWith("get")) continue;
            temp.addElement(remoteMethod);
        }
        Method[] getters = new Method[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            getters[i] = (Method)temp.elementAt(i);
        }
        return getters;
    }

    private static Method getMethod(Class homeClass, String selectedMethodName) {
        Method[] homeMethods = homeClass.getDeclaredMethods();
        Method method = null;
        for (Method homeMethod : homeMethods) {
            if (!homeMethod.getName().equals(selectedMethodName)) continue;
            method = homeMethod;
            break;
        }
        if (method == null) {
            throw new RuntimeException("Method not found!");
        }
        return method;
    }

    private static ColData[] initColData(Method[] getters) {
        ColData[] colData = new ColData[getters.length + 1];
        for (int i = 0; i < getters.length; ++i) {
            String colName = getters[i].getName().substring(3);
            String retTypeName = getters[i].getReturnType().getName();
            int type = EJBUtil.mapFieldType(retTypeName);
            colData[i] = new ColData(colName, type, -1, colData.length);
        }
        colData[getters.length] = new ColData("qbCount", 4, -1, colData.length);
        return colData;
    }

    private static ColData[] getColData(Method[] getters, Method method, Object home, Object[] param) {
        ColData[] colData = EJBAccess.initColData(getters);
        try {
            Object result = method.invoke(home, param);
            Object[] ret = null;
            if (result instanceof Collection) {
                ret = ((Collection)result).toArray();
            } else if (result instanceof Enumeration) {
                LOGGER.warning("Unsupported EJB version. Only EJB 2.0 is supported.");
            } else {
                LOGGER.warning("Wrong return type after infoking the method");
            }
            if (ret != null) {
                for (Object element : ret) {
                    for (int j = 0; j < getters.length; ++j) {
                        Object objResult = getters[j].invoke(element, new Object[0]);
                        colData[j].add(objResult);
                    }
                }
            }
            return colData;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get column data", e);
            return null;
        }
    }
}

