/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.ArraySet;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ScriptReportElement;

public class Expression
extends Operand {
    String operator;
    Operand left;
    Operand right;

    public Expression() {
    }

    public Expression(String operator, Operand left, Operand right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Operand getLeftOperand() {
        return this.left;
    }

    public void setLeftOperand(Operand operand) {
        this.left = operand;
    }

    public Operand getRightOperand() {
        return this.right;
    }

    public void setRightOperand(Operand operand) {
        this.right = operand;
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound) throws Exception {
        return this.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, null, null);
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report report, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol) throws Exception {
        return this.getValue(table, index, page, section, totalpages, totalsections, report, cell, dataobj, secondRound, preAggCol, resultCol, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report report, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol, ColData[] colData) throws Exception {
        Object leftObj = this.left.getValue(table, index, page, section, totalpages, totalsections, report, cell, dataobj, secondRound, preAggCol, resultCol, colData);
        int leftType = this.left.getDatatype(report);
        if (this.operator.equals("AND") && leftObj instanceof Boolean && !((Boolean)leftObj).booleanValue()) {
            return Boolean.FALSE;
        }
        if (this.operator.equals("OR") && leftObj instanceof Boolean && ((Boolean)leftObj).booleanValue()) {
            return Boolean.TRUE;
        }
        Object rightObj = this.right.getValue(table, index, page, section, totalpages, totalsections, report, cell, dataobj, secondRound, preAggCol, resultCol, colData);
        int rightType = this.right.getDatatype(report);
        if (!(leftObj != null && rightObj != null || this.operator.equals("==") || this.operator.equals("<>") || this.operator.equals("+") && leftType == 1 && rightType == 1)) {
            if (this.getDatatype(report) == 0) {
                return 0.0;
            }
            if (this.getDatatype(report) == 1) {
                return "";
            }
            if (this.getDatatype(report) != 2) return null;
            return Boolean.FALSE;
        }
        Number number1 = null;
        Number number2 = null;
        String string1 = null;
        String string2 = null;
        Date date1 = null;
        Date date2 = null;
        Boolean b1 = null;
        Boolean b2 = null;
        if (!(leftObj instanceof ArraySet)) {
            if (leftType == 0) {
                number1 = leftObj instanceof String ? (Number)Double.valueOf((String)leftObj) : (Number)((Number)leftObj);
            } else if (leftType == 1) {
                string1 = (String)leftObj;
            } else if (leftType == 3 || leftType == 4 || leftType == 5) {
                date1 = (Date)leftObj;
            } else if (leftType == 2) {
                b1 = (Boolean)leftObj;
            }
        } else if (leftType == 0) {
            number1 = (Number)((ArraySet)leftObj).value[0];
        } else if (leftType == 1) {
            string1 = (String)((ArraySet)leftObj).value[0];
        } else if (leftType == 3 || leftType == 4 || leftType == 5) {
            date1 = (Date)((ArraySet)leftObj).value[0];
        } else if (leftType == 2) {
            b1 = (Boolean)((ArraySet)leftObj).value[0];
        }
        if (!(rightObj instanceof ArraySet)) {
            if (rightType == 0) {
                number2 = (Number)rightObj;
            } else if (rightType == 1) {
                string2 = (String)rightObj;
            } else if (rightType == 3 || rightType == 4 || rightType == 5) {
                date2 = (Date)rightObj;
            } else if (rightType == 2) {
                b2 = (Boolean)rightObj;
            }
        } else if (rightType == 0) {
            number2 = (Number)((ArraySet)rightObj).value[0];
        } else if (rightType == 1) {
            string2 = (String)((ArraySet)rightObj).value[0];
        } else if (rightType == 3 || rightType == 4 || rightType == 5) {
            date2 = (Date)((ArraySet)rightObj).value[0];
        } else if (rightType == 2) {
            b2 = (Boolean)((ArraySet)rightObj).value[0];
        }
        if (this.operator.equals("+")) {
            if (leftType == 0 && rightType == 0) {
                this.datatype = 0;
                return number1.doubleValue() + number2.doubleValue();
            }
            this.datatype = 1;
            if (leftObj != null && rightObj != null) {
                return leftObj.toString() + rightObj.toString();
            }
            if (leftObj == null && rightObj != null) {
                return rightObj.toString();
            }
            if (leftObj == null || rightObj != null) return null;
            return leftObj.toString();
        }
        if (this.operator.equals("-")) {
            if (leftType == 0 && rightType == 0) {
                this.datatype = 0;
                return number1.doubleValue() - number2.doubleValue();
            }
            if (!(leftType != 3 && leftType != 4 && leftType != 5 || rightType != 3 && rightType != 4 && rightType != 5)) {
                this.datatype = 0;
                long diff = date1.getTime() - date2.getTime();
                long abs = Math.abs(diff);
                int diffDay = (int)Math.floor((abs + 3600000L) / 86400000L);
                if (diff >= 0L) return (double)diffDay;
                diffDay = -1 * diffDay;
                return (double)diffDay;
            }
            String msg = LanguageEncoder.getText("Operands of \"-\" have to be two numbers or two dates");
            throw new Exception(msg);
        }
        if (this.operator.equals("*")) {
            if (leftType == 0 && rightType == 0) {
                this.datatype = 0;
                return number1.doubleValue() * number2.doubleValue();
            }
            String msg = LanguageEncoder.getText("Operands of \"*\" have to be two numbers");
            throw new Exception(msg);
        }
        if (this.operator.equals("/")) {
            if (leftType == 0 && rightType == 0) {
                this.datatype = 0;
                return number1.doubleValue() / number2.doubleValue();
            }
            String msg = LanguageEncoder.getText("Operands of \"/\" have to be two numbers");
            throw new Exception(msg);
        }
        if (this.operator.equals("==")) {
            this.datatype = 2;
            if (leftObj == null && rightObj == null) {
                return Boolean.TRUE;
            }
            if (leftObj == null || rightObj == null) {
                return Boolean.FALSE;
            }
            if (leftObj instanceof ArraySet) {
                if (rightObj instanceof ArraySet) {
                    return ((ArraySet)leftObj).equals(rightObj);
                }
                if (rightType == 0) {
                    return ((ArraySet)leftObj).equals(number2);
                }
                if (rightType == 1) {
                    return ((ArraySet)leftObj).equals(string2);
                }
                if (rightType == 3 || rightType == 4 || rightType == 5) {
                    return ((ArraySet)leftObj).equals(date2);
                }
                if (rightType != 2) throw new Exception(LanguageEncoder.getText("Operator not recognized"));
                return ((ArraySet)leftObj).equals(b2);
            }
            if (rightObj instanceof ArraySet) {
                if (leftObj instanceof ArraySet) {
                    return ((ArraySet)leftObj).equals(leftObj);
                }
                if (leftType == 0) {
                    return ((ArraySet)rightObj).equals(number1);
                }
                if (leftType == 1) {
                    return ((ArraySet)rightObj).equals(string1);
                }
                if (leftType == 3 || leftType == 4 || leftType == 5) {
                    return ((ArraySet)rightObj).equals(date1);
                }
                if (leftType != 2) throw new Exception(LanguageEncoder.getText("Operator not recognized"));
                return ((ArraySet)rightObj).equals(b1);
            }
            if (leftType == 0 && rightType == 0) {
                return number1.doubleValue() == number2.doubleValue();
            }
            if (leftType == 1 && rightType == 1) {
                return string1.equals(string2);
            }
            if (leftType == 2 && rightType == 2) {
                return b1.booleanValue() == b2.booleanValue();
            }
            if (this.isDate(leftType) && this.isDate(rightType)) {
                return date1.equals(date2);
            }
            String msg = LanguageEncoder.getText("Operands of \"==\" have to be of the same datatype");
            throw new Exception(msg);
        }
        if (this.operator.equals("<>")) {
            this.datatype = 2;
            if (leftObj == null && rightObj == null) {
                return Boolean.FALSE;
            }
            if (leftObj == null || rightObj == null) {
                return Boolean.TRUE;
            }
            if (leftObj instanceof ArraySet) {
                return !((ArraySet)leftObj).equals(rightObj);
            }
            if (rightObj instanceof ArraySet) {
                return !((ArraySet)rightObj).equals(leftObj);
            }
            if (leftType == 0 && rightType == 0) {
                return number1.doubleValue() != number2.doubleValue();
            }
            if (leftType == 1 && rightType == 1) {
                return !string1.equals(string2);
            }
            if (leftType == 2 && rightType == 2) {
                return b1.booleanValue() != b2.booleanValue();
            }
            if (this.isDate(leftType) && this.isDate(rightType)) {
                return !date1.equals(date2);
            }
            String msg = LanguageEncoder.getText("Operands of \"<>\" have to be of the same datatype");
            throw new Exception(msg);
        }
        if (this.operator.equals("<=")) {
            this.datatype = 2;
            if (leftType == 0 && rightType == 0) {
                return number1.doubleValue() <= number2.doubleValue();
            }
            if (leftType == 1 && rightType == 1) {
                return string1.compareTo(string2) <= 0;
            }
            if (this.isDate(leftType) && this.isDate(rightType)) {
                if (date1 instanceof Timestamp && !(date2 instanceof Timestamp)) return date2.compareTo(date1) > 0;
                return date1.compareTo(date2) <= 0;
            }
            String msg = LanguageEncoder.getText("Operands of \"<=\" have to be of the same datatype");
            throw new Exception(msg);
        }
        if (this.operator.equals("<")) {
            this.datatype = 2;
            if (leftType == 0 && rightType == 0) {
                return number1.doubleValue() < number2.doubleValue();
            }
            if (leftType == 1 && rightType == 1) {
                return string1.compareTo(string2) < 0;
            }
            if (this.isDate(leftType) && this.isDate(rightType)) {
                if (date1 instanceof Timestamp && !(date2 instanceof Timestamp)) return date2.compareTo(date1) >= 0;
                return date1.compareTo(date2) < 0;
            }
            String msg = LanguageEncoder.getText("Operands of \"<\" have to be of the same datatype");
            throw new Exception(msg);
        }
        if (this.operator.equals(">")) {
            this.datatype = 2;
            if (leftType == 0 && rightType == 0) {
                return number1.doubleValue() > number2.doubleValue();
            }
            if (leftType == 1 && rightType == 1) {
                return string1.compareTo(string2) > 0;
            }
            if (this.isDate(leftType) && this.isDate(rightType)) {
                if (date1 instanceof Timestamp && !(date2 instanceof Timestamp)) return date2.compareTo(date1) <= 0;
                return date1.compareTo(date2) > 0;
            }
            String msg = LanguageEncoder.getText("Operands of \">\" have to be of the same datatype");
            throw new Exception(msg);
        }
        if (this.operator.equals(">=")) {
            this.datatype = 2;
            if (leftType == 0 && rightType == 0) {
                return number1.doubleValue() >= number2.doubleValue();
            }
            if (leftType == 1 && rightType == 1) {
                return string1.compareTo(string2) >= 0;
            }
            if (this.isDate(leftType) && this.isDate(rightType)) {
                if (date1 instanceof Timestamp && !(date2 instanceof Timestamp)) return date2.compareTo(date1) < 0;
                return date1.compareTo(date2) >= 0;
            }
            String msg = LanguageEncoder.getText("Operands of \">=\" have to be of the same datatype");
            throw new Exception(msg);
        }
        if (this.operator.equals("AND")) {
            this.datatype = 2;
            if (leftType == 2 && rightType == 2) {
                return b1 != false && b2 != false;
            }
            String msg = LanguageEncoder.getText("Boolean value is missing for \"AND\"");
            throw new Exception(msg);
        }
        if (!this.operator.equals("OR")) throw new Exception(LanguageEncoder.getText("Operator not recognized"));
        this.datatype = 2;
        if (leftType == 2 && rightType == 2) {
            return b1 != false || b2 != false;
        }
        String msg = LanguageEncoder.getText("Boolean value is missing for \"OR\"");
        throw new Exception(msg);
    }

    public String toString() {
        return this.left.toString() + this.operator + this.right.toString();
    }

    @Override
    public int getDatatype(Report report) {
        if (this.datatype >= 0) {
            return this.datatype;
        }
        if (this.operator.equals("+")) {
            this.datatype = this.left.getDatatype(report);
        } else if (this.operator.equals("-")) {
            this.datatype = this.left.getDatatype(report);
        } else if (this.operator.equals("*")) {
            this.datatype = 0;
        } else if (this.operator.equals("/")) {
            this.datatype = 0;
        } else if (this.operator.equals("==")) {
            this.datatype = 2;
        } else if (this.operator.equals("<>")) {
            this.datatype = 2;
        } else if (this.operator.equals("<=")) {
            this.datatype = 2;
        } else if (this.operator.equals("<")) {
            this.datatype = 2;
        } else if (this.operator.equals(">=")) {
            this.datatype = 2;
        } else if (this.operator.equals(">")) {
            this.datatype = 2;
        } else if (this.operator.equals("AND")) {
            this.datatype = 2;
        } else if (this.operator.equals("OR")) {
            this.datatype = 2;
        }
        return this.datatype;
    }

    @Override
    public void setDatatype(int datatype) {
        if (this.left instanceof ScriptReportElement) {
            ((ScriptReportElement)this.left).setThisDataType(datatype);
        }
        if (this.right instanceof ScriptReportElement) {
            ((ScriptReportElement)this.right).setThisDataType(datatype);
        }
    }

    public void setThisDatatype(int datatype) {
        this.left.setThisDataType(datatype);
        this.right.setThisDataType(datatype);
    }
}

