/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.ParseException;
import quadbase.reportdesigner.report.Report;

public class Formula
extends Operand
implements Comparable<Formula> {
    private static final Logger LOGGER = Logger.getLogger(Formula.class.getName());
    private Vector<Vector<Formula>> formulas;
    private Vector queryParams;
    private Vector formulaParams;
    String name;
    String text;
    Operand formula;
    public boolean calculated = false;
    int subReportIndex = -1;

    public Formula() {
    }

    public Formula(String name) {
        this.name = name;
    }

    public Formula(String name, String text) {
        this.name = name;
        this.text = text;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.formula = null;
    }

    public Operand getFormula() {
        return this.formula;
    }

    public void setFormula(Operand op) {
        this.formula = op;
    }

    public int getSubReportIndex() {
        return this.subReportIndex;
    }

    public void setSubReportIndex(int index) {
        this.subReportIndex = index;
    }

    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj) throws Exception {
        return this.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, false, null, null);
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound) throws Exception {
        return this.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, null, null);
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol) throws Exception {
        return this.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, null);
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol, ColData[] colData) throws Exception {
        return this.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData, false);
    }

    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol, ColData[] colData, boolean errorChecking) throws Exception {
        ReportTable aggrTbl = null;
        if (table instanceof ReportTreeTable) {
            aggrTbl = ((ReportTreeTable)table).getAggregationTable();
        }
        if (aggrTbl != null) {
            LOGGER.finest("Formula: " + this.text);
            try {
                int strIdx = -1;
                if (this.text.startsWith("SUM(COL(")) {
                    strIdx = 8;
                } else if (this.text.startsWith("MAX(COL(")) {
                    strIdx = 8;
                } else if (this.text.startsWith("MIN(COL(")) {
                    strIdx = 8;
                } else if (this.text.startsWith("COUNT(COL(")) {
                    strIdx = 10;
                } else if (this.text.startsWith("AVG(COL(")) {
                    strIdx = 8;
                } else if (this.text.startsWith("FIRST(COL(")) {
                    strIdx = 10;
                } else if (this.text.startsWith("LAST(COL(")) {
                    strIdx = 9;
                } else if (this.text.startsWith("SUMSQUARE(COL(")) {
                    strIdx = 14;
                } else if (this.text.startsWith("VARIANCE(COL(")) {
                    strIdx = 13;
                } else if (this.text.startsWith("STDDEV(COL(")) {
                    strIdx = 11;
                } else if (this.text.startsWith("COUNTDISTINCT(COL(")) {
                    strIdx = 18;
                }
                int endIdx = -1;
                if (this.text.endsWith("))")) {
                    endIdx = this.text.length() - 2;
                }
                if (strIdx != -1 && endIdx != -1) {
                    int colIdx = Integer.parseInt(this.text.substring(strIdx, endIdx));
                    return aggrTbl.getColumn(colIdx).getData(0);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Unknown aggregation type", ex);
            }
        }
        try {
            this.calculated = true;
            if (this.text != null && (this.text.indexOf("getPage") >= 0 || this.text.indexOf("getTotalPages") >= 0 || this.text.indexOf("getTotalSections") >= 0 || this.text.indexOf("getScriptValue") >= 0)) {
                this.calculated = false;
            }
            if (this.subReportIndex >= 0) {
                r = r.subReports.elementAt(this.subReportIndex).loadReport(r, table);
                r.formatTable();
                table = r.getReportTables().elementAt(0);
            }
            if (this.formula != null && this.formula != this) {
                Object object = this.formula.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                this.datatype = this.formula.getDatatype(r);
                return object;
            }
            if (this.name != null) {
                for (int i = 0; i < r.formulas.size(); ++i) {
                    Formula f = r.formulas.elementAt(i);
                    if (!f.getName().equals(this.name) || this.formula == f) continue;
                    this.formula = f;
                    Object obj = this.formula.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                    this.datatype = this.formula.getDatatype(r);
                    return obj;
                }
            }
            if (this.text != null) {
                try {
                    Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
                    formulaVec.add(r.formulas);
                    for (int i = 0; r.subReports != null && i < r.subReports.size(); ++i) {
                        Report rpt = r.getSubReportArray()[i];
                        if (rpt == null) continue;
                        formulaVec.add(rpt.formulas);
                    }
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(this.text.getBytes("UTF-8"));
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                    this.formula = parser.parse(formulaVec, r.getQueryParameters(), r.getFormulaParameters(), this.name);
                    Object obj = this.formula.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                    this.datatype = this.formula.getDatatype(r);
                    return obj;
                }
                catch (Exception e) {
                    LOGGER.finest("Cannot determine formula data type, using String");
                    this.datatype = 1;
                    return this.text;
                }
            }
        }
        catch (Exception ex) {
            if (ex.getMessage() != null && ex.getMessage().equals("can not calculate at this time")) {
                LOGGER.log(Level.FINEST, "can not calculate at this time", ex);
                this.calculated = false;
            }
            if (errorChecking) {
                LOGGER.log(Level.FINEST, "Error checking: error getting formula value", ex);
                throw ex;
            }
            LOGGER.log(Level.FINEST, "Error getting formula value", ex);
        }
        return null;
    }

    public void write(DataOutput out) throws IOException {
        IOUtil.writeStr(out, this.name);
        IOUtil.writeStr(out, this.text);
    }

    public void read(DataInput in, int version, Vector<Vector<Formula>> formulas, Vector queryParams, Vector formulaParams) throws Exception {
        try {
            this.name = IOUtil.readStr(in);
            this.text = IOUtil.readStr(in);
            if (version >= 71 && version <= 74) {
                int len = in.readInt();
                for (int i = 0; i < len; ++i) {
                    Parameter param = new Parameter();
                    param.read(in, version);
                }
            }
            this.formulas = formulas;
            this.queryParams = queryParams;
            this.formulaParams = formulaParams;
            LOGGER.finest("Formula: " + this.text);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot read data", ex);
            throw ex;
        }
    }

    public void parseThisFormula() throws UnsupportedEncodingException, ParseException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.text.getBytes("UTF-8"));
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
        NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
        this.formula = parser.parse(this.formulas, this.queryParams, this.formulaParams, this.name);
    }

    public void writeXML(Writer out) throws Exception {
        out.write("<FORMULA>\n");
        out.write("<FORMULA_NAME>" + XMLUtil.encodeCDATA(this.getName()) + "</FORMULA_NAME>\n");
        out.write("<FORMULA_TEXT>" + XMLUtil.encodeCDATA(this.getText()) + "</FORMULA_TEXT>\n");
        out.write("</FORMULA>\n");
    }

    public void readXML(Node node, int version, Vector<Vector<Formula>> formulas, Vector queryParams, Vector formulaParams) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("FORMULA_NAME")) {
                this.name = LoadXMLReportHelper.readCDATA(child);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("FORMULA_TEXT")) {
                this.text = LoadXMLReportHelper.readCDATA(child);
                continue;
            }
            if (!child.getNodeName().equals("PARAMETER")) continue;
            Parameter param = new Parameter();
            param.readXML(child, version);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.text.getBytes("UTF-8"));
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
        NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
        this.formula = parser.parse(formulas, queryParams, formulaParams, this.name);
    }

    public String toString() {
        return "formula:" + this.text;
    }

    public boolean formulaReferenced(Formula f) {
        return this.text.indexOf("@" + f.getName()) >= 0;
    }

    @Override
    public int getDatatype(Report report) {
        if (this.datatype >= 0) {
            return this.datatype;
        }
        if (this.formula != null) {
            try {
                this.datatype = this.formula.getDatatype(report);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Cannot determine data type", ex);
            }
        }
        return this.datatype;
    }

    public Formula copy() {
        Formula f = new Formula(this.name, this.text);
        f.calculated = this.calculated;
        f.datatype = this.datatype;
        f.formula = this.formula;
        f.subReportIndex = this.subReportIndex;
        return f;
    }

    public boolean equals(Formula f) {
        if (f == this) {
            return true;
        }
        if (f.calculated != this.calculated) {
            return false;
        }
        if (f.datatype != this.datatype) {
            return false;
        }
        if (f.formula != this.formula) {
            return false;
        }
        return f.subReportIndex == this.subReportIndex;
    }

    @Override
    public int compareTo(Formula o) {
        return QbUtil.emptyStringIfNull(this.name).compareToIgnoreCase(QbUtil.emptyStringIfNull(o.name));
    }
}

