/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.report.Aggregation;
import quadbase.reportdesigner.report.IOUtil2;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.util.IAggregateConstants;
import quadbase.reportdesigner.util.IQueryInParam;
import quadbase.reportdesigner.util.NumericFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.reportdesigner.util.internal.ReportUtil;
import quadbase.util.IFunctionConstants;

public class FormulaParser
implements IFunctionConstants {
    private static final Logger LOGGER = Logger.getLogger(FormulaParser.class.getName());
    ReportTable table;
    int row = -1;
    private Locale locale;
    private TimeZone timeZone;
    private int page = 1;
    private int section = 1;
    private int totalPages = 1;
    private int totalSections = 1;
    protected Vector preAggCol;
    protected Vector resultCol;
    protected Report report;

    public FormulaParser(ReportTable table, Report r) {
        this(table, 1, 1, 1, 1, r);
    }

    public FormulaParser(ReportTable table, int page, int section, int totalPages, int totalSections, Report r) {
        this.table = table;
        if (this.report != null) {
            this.locale = this.report.getLocale();
            this.timeZone = this.report.getTimeZone();
        }
        this.page = page;
        this.section = section;
        this.totalPages = totalPages;
        this.totalSections = totalSections;
        this.report = r;
    }

    public String parse(String exp, int sqlType) throws Exception {
        return FormatUtil.createFormat(DataType.mapType(sqlType), this.locale, this.timeZone).format(this.parse(exp, sqlType, -1));
    }

    public Object parse(String exp, int sqlType, int row) throws Exception {
        return this.parse(exp, sqlType, row, null, null);
    }

    public Object parse(String exp, int sqlType, int row, Vector preAggCol, Vector resultCol) throws Exception {
        this.preAggCol = preAggCol;
        this.resultCol = resultCol;
        int dataType = DataType.mapType(sqlType);
        this.row = row;
        return this.parseExp(exp, dataType);
    }

    private Object parseExp(String exp, int dataType) throws Exception {
        try {
            switch (dataType) {
                case 9: {
                    return this.newTime(this.parseDate(exp));
                }
                case 8: {
                    return this.newDate(this.parseDate(exp));
                }
                case 10: {
                    return this.newTimestamp(this.parseDate(exp));
                }
                case 0: {
                    return this.parseBoolean(exp);
                }
                case 2: 
                case 11: 
                case 12: {
                    return (int)this.parseDouble(exp);
                }
                case 1: {
                    return (long)this.parseDouble(exp);
                }
                case 3: 
                case 4: 
                case 5: 
                case 13: {
                    return this.parseDouble(exp);
                }
                case 15: {
                    Object bindata = this.parseBinary(exp);
                    if (bindata == null || !(bindata instanceof ReportImage)) break;
                    ReportImage image = new ReportImage();
                    image.copy((ReportImage)bindata);
                    return image;
                }
            }
            return this.parseString(exp);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot parse formula", ex);
            String tmpEXP = exp.trim();
            if (tmpEXP.startsWith("\"") && tmpEXP.endsWith("\"")) {
                return tmpEXP.substring(1, tmpEXP.length() - 1);
            }
            return exp;
        }
    }

    private Object parseDeclaration(short key, String exp) throws Exception {
        LOGGER.finest("Expression: " + exp);
        switch (key) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                String[] param = this.getParam(exp);
                if (param.length < 2) {
                    return this.getValue(this.row, (int)this.parseDouble(param[0]));
                }
                return this.getValue(this.row, (int)this.parseDouble(param[0]), this.parseAggregation(param[1]));
            }
            case 9: {
                String[] param = this.getParam(exp);
                if (param.length < 2) {
                    return this.getValue(this.row, this.parseString(param[0]));
                }
                return this.getValue(this.row, this.parseString(param[0]), this.parseAggregation(param[1]));
            }
            case 4: {
                return Double.valueOf(exp.trim());
            }
            case 5: {
                int sIdx = exp.indexOf(34);
                int eIdx = exp.lastIndexOf(34);
                return QbUtil.replace(exp.substring(sIdx + 1, eIdx), "\\\"", "\"");
            }
            case 6: {
                String str;
                try {
                    str = this.parseString(exp);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Cannot parse string", ex);
                    str = exp;
                }
                int[] time = this.getTime(str);
                if (time.length == 6) {
                    return new Timestamp(time[2] - 1900, time[0] - 1, time[1], time[3], time[4], time[5], 0);
                }
                if (time.length == 7) {
                    return new Timestamp(time[2] - 1900, time[0] - 1, time[1], time[3], time[4], time[5], time[6]);
                }
                if (str.indexOf(58) >= 0) {
                    return new Time(time[0], time[1], time[2]);
                }
                return new Date(time[2] - 1900, time[0] - 1, time[1]);
            }
            case 7: {
                return exp.trim().equalsIgnoreCase("true");
            }
            case 11: {
                String[] param = this.getParam(exp);
                if (param.length <= 0) break;
                return this.getQueryParameter((int)this.parseDouble(param[0]));
            }
        }
        return null;
    }

    private int[] getTime(String exp) throws Exception {
        StringTokenizer st = new StringTokenizer(exp, "/ :");
        int[] val = new int[st.countTokens()];
        for (int i = 0; i < val.length; ++i) {
            val[i] = Integer.parseInt(st.nextToken().trim());
        }
        return val;
    }

    private boolean parseBoolean(String exp) throws Exception {
        LOGGER.finest("Expression: " + exp);
        int sIdx = exp.indexOf(40);
        if (sIdx == -1) {
            return exp.trim().equalsIgnoreCase("true");
        }
        int eIdx = exp.lastIndexOf(41);
        String prefix = exp.substring(0, sIdx).trim();
        exp = exp.substring(sIdx + 1, eIdx);
        short key = this.getDeclaration(prefix);
        if (key >= 0) {
            return (Boolean)this.parseDeclaration(key, exp);
        }
        key = this.getBooleanFunction(prefix);
        switch (key) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                String[] param = this.getParam(exp);
                return this.compare(key, this.getType(param[0]), param);
            }
            case 6: {
                return !this.parseBoolean(exp);
            }
            case 7: {
                String[] param = this.getParam(exp);
                boolean x = this.parseBoolean(param[0]);
                boolean y = this.parseBoolean(param[1]);
                return x && y || !x && !y;
            }
            case 8: {
                String[] param = this.getParam(exp);
                boolean x = this.parseBoolean(param[0]);
                boolean y = this.parseBoolean(param[1]);
                return x && !y || !x && y;
            }
            case 9: {
                String[] param = this.getParam(exp);
                boolean x = this.parseBoolean(param[0]);
                boolean y = this.parseBoolean(param[1]);
                return !x || !y;
            }
            case 10: {
                String[] param = this.getParam(exp);
                boolean x = this.parseBoolean(param[0]);
                boolean y = this.parseBoolean(param[1]);
                return !x && !y;
            }
            case 11: {
                String[] param;
                boolean val = true;
                for (String element : param = this.getParam(exp)) {
                    val = val && this.parseBoolean(element);
                }
                return val;
            }
            case 12: {
                String[] param;
                boolean val = false;
                for (String element : param = this.getParam(exp)) {
                    val = val || this.parseBoolean(element);
                }
                return val;
            }
            case 13: {
                String[] param = this.getParam(exp);
                return this.parseBoolean(param[0]) ? this.parseBoolean(param[1]) : this.parseBoolean(param[2]);
            }
        }
        return this.parseBoolean(exp);
    }

    private boolean compare(short sign, short type, String[] param) throws Exception {
        try {
            switch (type) {
                case 4: {
                    double a = this.parseDouble(param[0]);
                    double b = this.parseDouble(param[1]);
                    switch (sign) {
                        case 0: {
                            double c = this.parseDouble(param[2]);
                            return c >= a && c <= b;
                        }
                        case 1: {
                            return a >= b;
                        }
                        case 2: {
                            return a <= b;
                        }
                        case 3: {
                            return a == b;
                        }
                        case 4: {
                            return a > b;
                        }
                        case 5: {
                            return a < b;
                        }
                    }
                }
                case 6: {
                    java.util.Date date1 = this.parseDate(param[0]);
                    java.util.Date date2 = this.parseDate(param[1]);
                    switch (sign) {
                        case 0: {
                            java.util.Date date3 = this.parseDate(param[2]);
                            return !date3.before(date1) && !date3.after(date2);
                        }
                        case 1: {
                            return date1.after(date2) || date1.equals(date2);
                        }
                        case 2: {
                            return date1.before(date2) || date1.equals(date2);
                        }
                        case 3: {
                            return date1.equals(date2);
                        }
                        case 4: {
                            return date1.after(date2);
                        }
                        case 5: {
                            return date1.before(date2);
                        }
                    }
                }
                case 5: {
                    String str1 = this.parseString(param[0]);
                    String str2 = this.parseString(param[1]);
                    switch (sign) {
                        case 0: {
                            String str3 = this.parseString(param[2]);
                            return str3.compareTo(str1) >= 0 && str3.compareTo(str2) <= 0;
                        }
                        case 1: {
                            return str1.compareTo(str2) >= 0;
                        }
                        case 2: {
                            return str1.compareTo(str2) <= 0;
                        }
                        case 3: {
                            return str1.equals(str2);
                        }
                        case 4: {
                            return str1.compareTo(str2) > 0;
                        }
                        case 5: {
                            return str1.compareTo(str2) < 0;
                        }
                    }
                }
                case 7: {
                    switch (sign) {
                        case 3: {
                            return this.parseBoolean(param[0]) == this.parseBoolean(param[1]);
                        }
                        case 0: 
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: {
                            throw new Exception("Cannot compare boolean object!");
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Compare objects must have same data type", ex);
            throw new Exception("Compare object must have same data type : " + IOUtil.getStackTrace(ex));
        }
        throw new Exception("Unknown compare type!");
    }

    private java.util.Date parseDate(String exp) throws Exception {
        LOGGER.finest("Expression: " + exp);
        int sIdx = exp.indexOf(40);
        if (sIdx == -1) {
            throw new Exception("FormulaParser: invalid DateTime function!");
        }
        int eIdx = exp.lastIndexOf(41);
        String prefix = exp.substring(0, sIdx).trim();
        exp = exp.substring(sIdx + 1, eIdx);
        short key = this.getDeclaration(prefix);
        if (key >= 0) {
            return (java.util.Date)this.parseDeclaration(key, exp);
        }
        key = this.getDateTimeFunction(prefix);
        switch (key) {
            case 0: {
                return this.newTimestamp(new java.util.Date());
            }
            case 1: {
                return this.newDate(new java.util.Date());
            }
            case 2: {
                return this.newTime(new java.util.Date());
            }
            case 3: {
                String[] param = this.getParam(exp);
                Calendar cal = this.createCalendar(this.locale, this.timeZone);
                cal.setTime(this.parseDate(param[0]));
                cal.add(this.parseCalendarField(param[1]), (int)this.parseDouble(param[2]));
                return cal.getTime();
            }
            case 4: {
                String[] param = this.getParam(exp);
                Calendar cal = this.createCalendar(this.locale, this.timeZone);
                cal.setTime(this.parseDate(param[0]));
                int field = this.parseCalendarField(param[1]);
                int amt = (int)this.parseDouble(param[2]);
                boolean up = amt > 0;
                amt = (int)Math.abs((double)amt);
                for (int i = 0; i < amt; ++i) {
                    cal.roll(field, up);
                }
                return cal.getTime();
            }
            case 5: {
                String[] param = this.getParam(exp);
                return this.parseBoolean(param[0]) ? this.parseDate(param[1]) : this.parseDate(param[2]);
            }
            case 6: {
                String[] param = this.getParam(exp);
                return new Timestamp((long)this.parseDouble(param[0]));
            }
        }
        return this.parseDate(exp);
    }

    private String parseString(String exp) throws Exception {
        LOGGER.finest("Expression: " + exp);
        int sIdx = exp.indexOf(40);
        if (sIdx == -1) {
            int qsIdx = exp.indexOf(34);
            int qeIdx = exp.lastIndexOf(34);
            if (qsIdx < 0 || qeIdx == qsIdx) {
                return exp;
            }
            return QbUtil.replace(exp.substring(qsIdx + 1, qeIdx), "\\\"", "\"");
        }
        int eIdx = exp.lastIndexOf(41);
        String prefix = exp.substring(0, sIdx).trim();
        exp = exp.substring(sIdx + 1, eIdx);
        short key = this.getDeclaration(prefix);
        if (key >= 0) {
            Object obj = this.parseDeclaration(key, exp);
            if (obj == null) {
                return "";
            }
            return obj.toString();
        }
        key = this.getStringFunction(prefix);
        switch (key) {
            case 0: {
                return this.parseString(exp).toUpperCase();
            }
            case 1: {
                return this.parseString(exp).toLowerCase();
            }
            case 2: {
                String[] param = this.getParam(exp);
                String str = this.parseString(param[0]);
                int val = (int)this.parseDouble(param[1]);
                if (val < 0 || str.length() <= val) {
                    return str;
                }
                return str.substring(0, val);
            }
            case 3: {
                String[] param = this.getParam(exp);
                if (param.length == 2) {
                    return this.parseString(param[0]).substring((int)this.parseDouble(param[1]));
                }
                return this.parseString(param[0]).substring((int)this.parseDouble(param[1]), (int)this.parseDouble(param[2]));
            }
            case 4: {
                String[] param = this.getParam(exp);
                String str = "";
                for (String element : param) {
                    str = str + this.parseString(element);
                }
                return str;
            }
            case 5: {
                String[] param = this.getParam(exp);
                if (param.length == 3) {
                    return QbUtil.replace(this.parseString(param[0]), this.parseString(param[1]), this.parseString(param[2]));
                }
                String tmp = this.parseString(param[0]);
                return tmp.substring(0, (int)this.parseDouble(param[1])) + this.parseString(param[3]) + tmp.substring((int)this.parseDouble(param[2]));
            }
            case 6: {
                String[] param = this.getParam(exp);
                return new StringBuffer(this.parseString(param[0])).insert((int)this.parseDouble(param[1]), this.parseString(param[2])).toString();
            }
            case 7: {
                return this.totalSections > 1 ? this.page + "-" + this.section : this.page + "";
            }
            case 8: {
                return this.totalPages + "";
            }
            case 9: {
                return this.totalSections + "";
            }
            case 10: {
                String[] param = this.getParam(exp);
                if (param.length == 1) {
                    double tmp = this.parseDouble(param[0]);
                    if (tmp % 1.0 == 0.0) {
                        return (int)tmp + "";
                    }
                    return tmp + "";
                }
                double tmp = this.parseDouble(param[0]);
                int decPt = (int)this.parseDouble(param[1]);
                if (decPt < 0) {
                    decPt = 0;
                }
                if (param.length > 2 && decPt > 0 && !this.parseBoolean(param[2])) {
                    tmp = Math.floor(tmp * Math.pow(10.0, decPt)) / Math.pow(10.0, decPt);
                }
                NumericFormat numFormat = new NumericFormat();
                numFormat.decimal = decPt;
                return numFormat.format(tmp);
            }
            case 11: {
                return this.getDateTimeText(this.locale, this.timeZone, "EEEEE", this.parseDate(exp));
            }
            case 12: {
                return this.getDateTimeText(this.locale, this.timeZone, "MMMMM", this.parseDate(exp));
            }
            case 13: {
                return this.getDateTimeText(this.locale, this.timeZone, "a", this.parseDate(exp));
            }
            case 14: {
                return this.getDateTimeText(this.locale, this.timeZone, "G", this.parseDate(exp));
            }
            case 15: {
                String[] param = this.getParam(exp);
                Timestamp date = this.newTimestamp(this.parseDate(param[0]), this.locale, this.timeZone);
                if (param.length == 1) {
                    return ((java.util.Date)date).toString();
                }
                return this.getDateTimeText(this.locale, this.timeZone, this.parseString(param[1]), date);
            }
            case 16: {
                String[] param = this.getParam(exp);
                Time date = this.newTime(this.parseDate(param[0]), this.locale, this.timeZone);
                if (param.length == 1) {
                    return ((java.util.Date)date).toString();
                }
                return this.getDateTimeText(this.locale, this.timeZone, this.parseString(param[1]), date);
            }
            case 17: {
                String[] param = this.getParam(exp);
                Date date = this.newDate(this.parseDate(param[0]), this.locale, this.timeZone);
                if (param.length == 1) {
                    return ((java.util.Date)date).toString();
                }
                return this.getDateTimeText(this.locale, this.timeZone, this.parseString(param[1]), date);
            }
            case 18: {
                String[] param = this.getParam(exp);
                return this.parseBoolean(param[0]) ? this.parseString(param[1]) : this.parseString(param[2]);
            }
        }
        return this.parseString(exp);
    }

    private Object parseBinary(String exp) throws Exception {
        LOGGER.finest("Expression: " + exp);
        int sIdx = exp.indexOf(40);
        if (sIdx == -1) {
            int qsIdx = exp.indexOf(34);
            int qeIdx = exp.lastIndexOf(34);
            if (qsIdx < 0 || qeIdx == qsIdx) {
                throw new Exception("FormulaParser: invalid binary function!");
            }
            return QbUtil.replace(exp.substring(qsIdx + 1, qeIdx), "\\\"", "\"");
        }
        int eIdx = exp.lastIndexOf(41);
        String prefix = exp.substring(0, sIdx).trim();
        exp = exp.substring(sIdx + 1, eIdx);
        short key = this.getDeclaration(prefix);
        if (key >= 0) {
            return this.parseDeclaration(key, exp);
        }
        return null;
    }

    private String getDateTimeText(Locale locale, TimeZone zone, String pattern, java.util.Date date) {
        SimpleDateFormat dateFormat = locale == null ? new SimpleDateFormat(pattern) : new SimpleDateFormat(pattern, locale);
        if (zone != null) {
            dateFormat.setTimeZone(zone);
        }
        return dateFormat.format(date);
    }

    private Calendar createCalendar(Locale locale, TimeZone zone) {
        Calendar cal = locale == null ? Calendar.getInstance() : Calendar.getInstance(locale);
        if (zone != null) {
            cal.setTimeZone(zone);
        }
        return cal;
    }

    private Timestamp newTimestamp(java.util.Date date) {
        return this.newTimestamp(date, null, null);
    }

    private Timestamp newTimestamp(java.util.Date date, Locale locale, TimeZone zone) {
        Calendar cal = this.createCalendar(locale, zone);
        cal.setTime(date);
        return new Timestamp(cal.get(1) - 1900, cal.get(2), cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }

    private Time newTime(java.util.Date date) {
        return this.newTime(date, null, null);
    }

    private Time newTime(java.util.Date date, Locale locale, TimeZone zone) {
        Calendar cal = this.createCalendar(locale, zone);
        cal.setTime(date);
        return new Time(cal.get(11), cal.get(12), cal.get(13));
    }

    private Date newDate(java.util.Date date) {
        return this.newDate(date, null, null);
    }

    private Date newDate(java.util.Date date, Locale locale, TimeZone zone) {
        Calendar cal = this.createCalendar(locale, zone);
        cal.setTime(date);
        return new Date(cal.get(1) - 1900, cal.get(2), cal.get(5));
    }

    private double parseDouble(String exp) throws Exception {
        LOGGER.finest("Expression: " + exp);
        int sIdx = exp.indexOf(40);
        if (sIdx == -1) {
            try {
                return Double.valueOf(exp);
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Formula parser: Invalid number", ex);
                throw new Exception("FormulaParser: invalid numeric function!");
            }
        }
        int eIdx = exp.lastIndexOf(41);
        String prefix = exp.substring(0, sIdx).trim();
        exp = exp.substring(sIdx + 1, eIdx);
        short key = this.getDeclaration(prefix);
        if (key >= 0) {
            return IOUtil2.getValue(this.parseDeclaration(key, exp));
        }
        key = this.getNumericFunction(prefix);
        switch (key) {
            case 0: {
                String[] param;
                double val = 0.0;
                for (String element : param = this.getParam(exp)) {
                    val += this.parseDouble(element);
                }
                return val;
            }
            case 1: {
                double val = 0.0;
                String[] param = this.getParam(exp);
                for (int i = 0; i < param.length; ++i) {
                    if (i == 0) {
                        val = this.parseDouble(param[0]);
                        continue;
                    }
                    val -= this.parseDouble(param[i]);
                }
                return val;
            }
            case 2: {
                String[] param;
                double val = 1.0;
                for (String element : param = this.getParam(exp)) {
                    val *= this.parseDouble(element);
                }
                return val;
            }
            case 3: {
                String[] param = this.getParam(exp);
                return this.parseDouble(param[0]) / this.parseDouble(param[1]);
            }
            case 4: {
                String[] param = this.getParam(exp);
                return this.parseDouble(param[0]) % this.parseDouble(param[1]);
            }
            case 5: {
                String[] param = this.getParam(exp);
                return Math.IEEEremainder(this.parseDouble(param[0]), this.parseDouble(param[1]));
            }
            case 6: {
                return Math.acos(this.parseDouble(exp));
            }
            case 7: {
                return Math.cos(this.parseDouble(exp));
            }
            case 8: {
                return Math.asin(this.parseDouble(exp));
            }
            case 9: {
                return Math.sin(this.parseDouble(exp));
            }
            case 10: {
                return Math.atan(this.parseDouble(exp));
            }
            case 11: {
                String[] param = this.getParam(exp);
                return Math.atan2(this.parseDouble(param[0]), this.parseDouble(param[1]));
            }
            case 12: {
                return Math.tan(this.parseDouble(exp));
            }
            case 13: {
                return Math.ceil(this.parseDouble(exp));
            }
            case 14: {
                return Math.exp(this.parseDouble(exp));
            }
            case 15: {
                return Math.floor(this.parseDouble(exp));
            }
            case 16: {
                return Math.log(this.parseDouble(exp));
            }
            case 17: {
                return this.parseDouble(exp) * 180.0 / Math.PI;
            }
            case 18: {
                return this.parseDouble(exp) * Math.PI / 180.0;
            }
            case 19: {
                String[] param = this.getParam(exp);
                return Math.pow(this.parseDouble(param[0]), this.parseDouble(param[1]));
            }
            case 20: {
                return Math.random();
            }
            case 21: {
                return Math.rint(this.parseDouble(exp));
            }
            case 22: {
                return Math.sqrt(this.parseDouble(exp));
            }
            case 23: {
                return Math.abs(this.parseDouble(exp));
            }
            case 24: {
                String[] param = this.getParam(exp);
                double val = this.parseDouble(param[0]);
                for (int i = 1; i < param.length; ++i) {
                    val = Math.max(val, this.parseDouble(param[i]));
                }
                return val;
            }
            case 25: {
                String[] param = this.getParam(exp);
                double val = this.parseDouble(param[0]);
                for (int i = 1; i < param.length; ++i) {
                    val = Math.min(val, this.parseDouble(param[i]));
                }
                return val;
            }
            case 26: {
                return Math.PI;
            }
            case 27: {
                return Math.E;
            }
            case 28: {
                return this.getParam(exp).length;
            }
            case 29: {
                return Aggregation.sumSquare(this.parseDoubleArray(exp));
            }
            case 30: {
                return Aggregation.average(this.parseDoubleArray(exp));
            }
            case 31: {
                return Aggregation.variance(this.parseDoubleArray(exp));
            }
            case 32: {
                return Aggregation.standardDeviation(this.parseDoubleArray(exp));
            }
            case 33: {
                double val = this.parseDouble(exp);
                if (val == 0.0) {
                    return 1.0;
                }
                double val2 = 1.0;
                int i = 2;
                while ((double)i <= val) {
                    val2 *= (double)i;
                    ++i;
                }
                return val2;
            }
            case 34: {
                return this.parseString(exp).length();
            }
            case 35: {
                String[] param = this.getParam(exp);
                if (param.length == 2) {
                    return this.parseString(param[0]).lastIndexOf(this.parseString(param[1]));
                }
                return this.parseString(param[0]).lastIndexOf(this.parseString(param[1]), (int)this.parseDouble(param[2]));
            }
            case 36: {
                String[] param = this.getParam(exp);
                if (param.length == 2) {
                    return this.parseString(param[0]).indexOf(this.parseString(param[1]));
                }
                return this.parseString(param[0]).indexOf(this.parseString(param[1]), (int)this.parseDouble(param[2]));
            }
            case 37: {
                return Double.valueOf(this.parseString(exp));
            }
            case 38: {
                String[] param = this.getParam(exp);
                Calendar cal = this.createCalendar(this.locale, this.timeZone);
                cal.setTime(this.parseDate(param[0]));
                return cal.get(this.parseCalendarField(param[1]));
            }
            case 39: {
                String[] param = this.getParam(exp);
                return Math.floor((this.parseDate(param[0]).getTime() - this.parseDate(param[1]).getTime()) / 86400000L);
            }
            case 40: {
                String[] param = this.getParam(exp);
                return this.parseBoolean(param[0]) ? this.parseDouble(param[1]) : this.parseDouble(param[2]);
            }
        }
        return this.parseDouble(exp);
    }

    private short getType(String exp) throws Exception {
        LOGGER.finest("Expression: " + exp);
        int sIdx = exp.indexOf(40);
        if (sIdx == -1) {
            throw new Exception("FormulaParser: invalid function!");
        }
        int eIdx = exp.lastIndexOf(41);
        String prefix = exp.substring(0, sIdx).trim();
        exp = exp.substring(sIdx + 1, eIdx);
        short key = this.getDeclaration(prefix);
        if (key > 0) {
            switch (key) {
                case 0: {
                    return 4;
                }
                case 1: {
                    return 5;
                }
                case 3: {
                    return 7;
                }
                case 2: {
                    return 6;
                }
                case 8: {
                    return this.getColumnType(exp);
                }
                case 9: {
                    return this.getIDType(exp);
                }
                case 11: {
                    return this.getParameterType(exp);
                }
            }
            return key;
        }
        key = this.getBooleanFunction(prefix);
        if (key >= 0) {
            return 7;
        }
        key = this.getDateTimeFunction(prefix);
        if (key >= 0) {
            return 6;
        }
        key = this.getNumericFunction(prefix);
        if (key >= 0) {
            return 4;
        }
        key = this.getStringFunction(prefix);
        if (key >= 0) {
            return 5;
        }
        return this.getType(exp);
    }

    private short getIDType(String exp) throws Exception {
        String[] param = this.getParam(exp);
        Object tmp = param.length < 2 ? this.getValue(this.row, this.parseString(param[0])) : this.getValue(this.row, this.parseString(param[0]), this.parseAggregation(param[1]));
        if (tmp instanceof Boolean) {
            return 7;
        }
        if (tmp instanceof String) {
            return 5;
        }
        if (tmp instanceof java.util.Date) {
            return 6;
        }
        return 4;
    }

    private short getColumnType(String exp) throws Exception {
        String[] param = this.getParam(exp);
        Object tmp = param.length < 2 ? this.getValue(this.row, (int)this.parseDouble(param[0])) : this.getValue(this.row, (int)this.parseDouble(param[0]), this.parseAggregation(param[1]));
        if (tmp instanceof Boolean) {
            return 7;
        }
        if (tmp instanceof String) {
            return 5;
        }
        if (tmp instanceof java.util.Date) {
            return 6;
        }
        return 4;
    }

    private short getDeclaration(String prefix) {
        for (int i = 0; i < DECL.length; ++i) {
            if (!prefix.equalsIgnoreCase(DECL[i])) continue;
            return (short)i;
        }
        return -1;
    }

    private short getDateTimeFunction(String prefix) {
        for (int i = 0; i < DATE_FUNC.length; ++i) {
            if (!prefix.equalsIgnoreCase(DATE_FUNC[i])) continue;
            return (short)i;
        }
        return -1;
    }

    private short getStringFunction(String prefix) {
        for (int i = 0; i < STR_FUNC.length; ++i) {
            if (!prefix.equalsIgnoreCase(STR_FUNC[i])) continue;
            return (short)i;
        }
        return -1;
    }

    private short getNumericFunction(String prefix) {
        for (int i = 0; i < NUM_FUNC.length; ++i) {
            if (!prefix.equalsIgnoreCase(NUM_FUNC[i])) continue;
            return (short)i;
        }
        return -1;
    }

    private short getBooleanFunction(String prefix) {
        for (int i = 0; i < BOOL_FUNC.length; ++i) {
            if (!prefix.equalsIgnoreCase(BOOL_FUNC[i])) continue;
            return (short)i;
        }
        return -1;
    }

    private short parseAggregation(String exp) {
        exp = exp.trim();
        for (int i = 0; i < IAggregateConstants.AGGR.length; ++i) {
            if (!exp.equalsIgnoreCase(IAggregateConstants.AGGR[i])) continue;
            return (short)i;
        }
        return 0;
    }

    private int parseCalendarField(String exp) {
        exp = exp.trim();
        for (int i = 0; i < CALENDAR_CONST.length; ++i) {
            if (!exp.equalsIgnoreCase(CALENDAR_CONST[i])) continue;
            return i;
        }
        return 0;
    }

    private Double[] parseDoubleArray(String exp) throws Exception {
        String[] param = this.getParam(exp);
        Double[] res = new Double[param.length];
        for (int i = 0; i < param.length; ++i) {
            res[i] = this.parseDouble(param[i]);
        }
        return res;
    }

    private String[] getParam(String exp) {
        boolean nonString = true;
        int funcCount = 0;
        Vector<String> vec = new Vector<String>();
        String s2 = "";
        for (int i = 0; i < exp.length(); ++i) {
            char c;
            if (nonString && (c = exp.charAt(i)) == '(') {
                s2 = s2 + c;
                ++funcCount;
                continue;
            }
            if (nonString && (c = exp.charAt(i)) == ')') {
                s2 = s2 + c;
                --funcCount;
                continue;
            }
            c = exp.charAt(i);
            if (c == '\"' && (i <= 0 || exp.charAt(i - 1) != '\\')) {
                s2 = s2 + c;
                nonString = !nonString;
                continue;
            }
            if (nonString && (c = exp.charAt(i)) == ',' && funcCount == 0) {
                vec.addElement(s2);
                s2 = "";
                continue;
            }
            s2 = s2 + c;
        }
        vec.addElement(s2);
        String[] tmp = new String[vec.size()];
        for (int j = 0; j < vec.size(); ++j) {
            tmp[j] = (String)vec.elementAt(j);
        }
        return tmp;
    }

    public Object getValue(int row, String id) throws Exception {
        return this.getValue(row, id, (short)0);
    }

    private Object getValue(int row, String id, short agg) throws Exception {
        int idx = this.getColumnIndex(id);
        if (idx > -1) {
            return this.getValue(row, idx, agg);
        }
        return this.getValue(id);
    }

    private Object getValue(int row, int col) throws Exception {
        return this.getValue(row, col, (short)0);
    }

    private Object getValue(int row, int col, short agg) throws Exception {
        if (row >= 0 && agg == 0) {
            return this.table.getColumn(col).getData(row);
        }
        if (row < 0 && agg == 0) {
            agg = (short)6;
        }
        return this.getComputedValue(agg, col);
    }

    private Object getComputedValue(short agg, int col) {
        Object[] obj;
        if (this.preAggCol != null) {
            for (int i = 0; i < this.preAggCol.size(); ++i) {
                int[] tmp = (int[])this.preAggCol.elementAt(i);
                if (tmp[0] != col || (short)tmp[1] != agg) continue;
                switch (agg) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        return this.formatValue(this.resultCol.elementAt(i));
                    }
                    case 5: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        Vector tmpV = (Vector)this.resultCol.elementAt(i);
                        return this.formatValue(Aggregation.getComputedValue(agg, QbUtil.toArray(tmpV)));
                    }
                }
            }
        }
        if (this.table instanceof ReportTreeTable) {
            Vector list = new Vector();
            int size = this.collectData((ReportTreeTable)this.table, list, col);
            obj = new Object[size];
            int cur = 0;
            for (int i = 0; i < list.size(); ++i) {
                Object[] tmp;
                for (Object element : tmp = (Object[])list.elementAt(i)) {
                    obj[cur++] = element;
                }
            }
        } else {
            obj = new Object[this.table.getColumn(col).getActualDataCount()];
            for (int i = 0; i < obj.length; ++i) {
                obj[i] = this.table.getColumn(col).getActualData(i);
            }
        }
        return this.formatValue(Aggregation.getComputedValue(agg, obj));
    }

    private Object formatValue(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj;
    }

    private int collectData(ReportTreeTable table, Vector list, int col) {
        int count = 0;
        for (int i = 0; i < table.countSubTable(); ++i) {
            ReportTable tmp = table.getSubTable(i);
            if (tmp instanceof ReportTreeTable) {
                count += this.collectData((ReportTreeTable)tmp, list, col);
                continue;
            }
            if (tmp.getColumn(col).getActualDataCount() == -1) continue;
            Object[] obj = new Object[table.getColumn(col).getActualDataCount()];
            for (int j = 0; j < obj.length; ++j) {
                obj[j] = table.getColumn(col).getActualData(j);
            }
            list.addElement(obj);
            count += tmp.getColumn(col).getActualDataCount();
        }
        return count;
    }

    private int getColumnIndex(String id) {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if (!id.equals(this.table.getColumn(i).getID())) continue;
            return i;
        }
        return -1;
    }

    private Object getValue(String id) {
        try {
            ReportElement element;
            ReportCell cell = this.table.getHeader().getData(id);
            if (cell == null) {
                cell = this.table.getFooter().getData(id);
            }
            if (cell == null && this.table instanceof ReportMultiSectionTable) {
                int ct = this.table.countRowBreakHeader();
                for (int i = 0; i < ct && (cell = this.table.getRowBreakHeader(i).getData(id)) == null && (cell = this.table.getRowBreakFooter(i).getData(id)) == null; ++i) {
                }
            }
            if (cell == null && this.report != null && (element = this.report.getData(id)) instanceof ReportCell) {
                cell = (ReportCell)element;
            }
            if (cell == null) {
                return null;
            }
            return this.table.getValue(cell, 1, 1, 1, 1, this.report);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot get value", ex);
            return null;
        }
    }

    private Object getQueryParameter(int index) {
        IQueryInParam[] params;
        if (this.report != null && this.report.dbInfo != null && this.report.dbInfo instanceof IQueryFileInfo && (params = ReportUtil.getInParam(this.report.dbInfo)) != null && index >= 0 && index < params.length) {
            return params[index].getValue();
        }
        return null;
    }

    private short getParameterType(String exp) {
        IQueryInParam[] params;
        String[] param = this.getParam(exp);
        int index = -1;
        try {
            if (param.length > 0) {
                index = (int)this.parseDouble(param[0]);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Invalid number", ex);
        }
        if (this.report != null && this.report.dbInfo != null && this.report.dbInfo instanceof IQueryFileInfo && (params = ReportUtil.getInParam(this.report.dbInfo)) != null && index >= 0 && index < params.length) {
            Object value = params[index].getValue();
            if (value instanceof Boolean) {
                return 7;
            }
            if (value instanceof String) {
                return 5;
            }
            if (value instanceof java.util.Date) {
                return 6;
            }
        }
        return 4;
    }
}

