/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DataSet;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.report.Aggregation;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ScriptReportElement;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.ICustomDefinedFunctions;
import quadbase.reportdesigner.util.NumericFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.util.IFunctionConstants;

public class Function
extends Operand
implements IFunctionConstants {
    private static final Logger LOGGER = Logger.getLogger(Function.class.getName());
    String functionName;
    Vector args = new Vector();
    private ReportTable table = null;
    private int index;
    private int page;
    private int section;
    private int totalpages;
    private int totalsections;
    private Report report;
    private ReportCell cell;
    private Object dataobj;
    private boolean secondRound;
    private boolean found;
    private Vector preAggCol;
    private Vector resultCol;
    private ColData[] colData;
    private int uniqueNumber = QbUtil.nextNumber();
    private String address;
    private int charLen = ServerMessage.getMaxFieldSize();

    public Function(String name, Vector args) {
        this.functionName = name;
        this.args = args;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String name) {
        this.functionName = name;
    }

    public Vector getArgs() {
        return this.args;
    }

    public void setArgs(Vector args) {
        this.args = args;
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound) throws Exception {
        return this.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, null, null);
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol) throws Exception {
        return this.getValue(table, index, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, preAggCol, resultCol, null);
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol, ColData[] colData) throws Exception {
        short agg;
        int i;
        this.table = table;
        this.index = index;
        this.page = page;
        this.section = section;
        this.totalpages = totalpages;
        this.totalsections = totalsections;
        this.report = r;
        this.cell = cell;
        this.dataobj = dataobj;
        this.secondRound = secondRound;
        this.preAggCol = preAggCol;
        this.resultCol = resultCol;
        this.colData = colData;
        boolean nullFound = false;
        for (i = 0; this.args != null && i < this.args.size(); ++i) {
            if (this.args.elementAt(i) != null) continue;
            nullFound = true;
        }
        if (nullFound) {
            if (this.datatype == -1) {
                this.datatype = this.getDatatype(r);
            }
            if (this.datatype == 0) {
                return 0.0;
            }
            if (this.datatype == 1) {
                return "";
            }
            if (this.datatype == 2) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (this.functionName.equalsIgnoreCase("average") || this.functionName.equalsIgnoreCase("AVG")) {
            agg = 5;
            this.datatype = 0;
            return this.computeAggregation(table, agg);
        }
        if (this.functionName.equalsIgnoreCase("median")) {
            agg = 12;
            Object object = this.computeAggregation(table, agg);
            this.datatype = object instanceof Timestamp ? 5 : (object instanceof Time ? 4 : (object instanceof Date ? 3 : (object instanceof String ? 1 : 0)));
            return object;
        }
        if (this.functionName.equalsIgnoreCase("count")) {
            agg = 4;
            this.datatype = 0;
            return this.computeAggregation(table, agg);
        }
        if (this.functionName.equalsIgnoreCase("countdistinct")) {
            agg = 11;
            this.datatype = 0;
            return this.computeAggregation(table, agg);
        }
        if (this.functionName.equalsIgnoreCase("max")) {
            agg = 2;
            Object object = this.computeAggregation(table, agg);
            this.datatype = object instanceof Timestamp ? 5 : (object instanceof Time ? 4 : (object instanceof Date ? 3 : (object instanceof String ? 1 : 0)));
            return object;
        }
        if (this.functionName.equalsIgnoreCase("min")) {
            agg = 3;
            Object object = this.computeAggregation(table, agg);
            this.datatype = object instanceof Timestamp ? 5 : (object instanceof Time ? 4 : (object instanceof Date ? 3 : (object instanceof String ? 1 : 0)));
            return object;
        }
        if (this.functionName.equalsIgnoreCase("stddev")) {
            agg = 10;
            this.datatype = 0;
            return this.computeAggregation(table, agg);
        }
        if (this.functionName.equalsIgnoreCase("sum")) {
            agg = 1;
            this.datatype = 0;
            return this.computeAggregation(table, agg);
        }
        if (this.functionName.equalsIgnoreCase("sumsquare")) {
            agg = 8;
            this.datatype = 0;
            return this.computeAggregation(table, agg);
        }
        if (this.functionName.equalsIgnoreCase("variance")) {
            agg = 9;
            this.datatype = 0;
            return this.computeAggregation(table, agg);
        }
        if (this.functionName.equalsIgnoreCase("first")) {
            agg = 6;
            return this.computeAggregation(table, agg);
        }
        if (this.functionName.equalsIgnoreCase("last")) {
            agg = 7;
            return this.computeAggregation(table, agg);
        }
        if (this.functionName.equalsIgnoreCase("none")) {
            agg = 0;
            return this.computeAggregation(table, agg);
        }
        if (this.functionName.equalsIgnoreCase("getColumnCount")) {
            this.datatype = 0;
            return (double)table.getColumnCount();
        }
        if (this.functionName.equalsIgnoreCase("getGroupIndex")) {
            this.datatype = 0;
            return (double)this.findGroupIndex(r.getReportTables().elementAt(0), table, 0);
        }
        if (this.functionName.equalsIgnoreCase("getRowIndex")) {
            this.datatype = 0;
            return (double)this.findIndex(r.getReportTables().elementAt(0), table, index);
        }
        if (this.functionName.equalsIgnoreCase("getRowIndexOfCurrentTable")) {
            this.datatype = 0;
            return (double)this.findIndex(table, table, index);
        }
        if (this.functionName.equalsIgnoreCase("getTotalRowIndex")) {
            this.datatype = 0;
            return (double)this.findTotalIndex(r.getReportTables().elementAt(0));
        }
        if (this.functionName.equalsIgnoreCase("getTotalRowIndexOfCurrentTable")) {
            this.datatype = 0;
            return (double)this.findTotalIndex(table);
        }
        if (this.functionName.equalsIgnoreCase("getSiblingCount")) {
            this.datatype = 0;
            int siblingCount = 0;
            ReportTable parent = r.getParentTable(table);
            if (parent instanceof ReportTreeTable) {
                siblingCount = ((ReportTreeTable)parent).getSubTable().size();
            }
            return (double)siblingCount;
        }
        if (this.functionName.equalsIgnoreCase("getChildCount")) {
            this.datatype = 0;
            int childCount = 0;
            if (table instanceof ReportTreeTable) {
                childCount = ((ReportTreeTable)table).getSubTable().size();
            }
            return (double)childCount;
        }
        if (this.functionName.equalsIgnoreCase("abs")) {
            this.datatype = 0;
            return this.computeMath1((short)23);
        }
        if (this.functionName.equalsIgnoreCase("acos")) {
            this.datatype = 0;
            return this.computeMath1((short)6);
        }
        if (this.functionName.equalsIgnoreCase("asin")) {
            this.datatype = 0;
            return this.computeMath1((short)8);
        }
        if (this.functionName.equalsIgnoreCase("atan")) {
            this.datatype = 0;
            return this.computeMath1((short)10);
        }
        if (this.functionName.equalsIgnoreCase("atan2")) {
            this.datatype = 0;
            return this.computeMath2((short)11);
        }
        if (this.functionName.equalsIgnoreCase("ceil")) {
            this.datatype = 0;
            return this.computeMath1((short)13);
        }
        if (this.functionName.equalsIgnoreCase("cos")) {
            this.datatype = 0;
            return this.computeMath1((short)7);
        }
        if (this.functionName.equalsIgnoreCase("e")) {
            this.datatype = 0;
            return Math.E;
        }
        if (this.functionName.equalsIgnoreCase("exp")) {
            this.datatype = 0;
            return this.computeMath1((short)14);
        }
        if (this.functionName.equalsIgnoreCase("factorial")) {
            this.datatype = 0;
            return this.computeMath1((short)33);
        }
        if (this.functionName.equalsIgnoreCase("floor")) {
            this.datatype = 0;
            return this.computeMath1((short)15);
        }
        if (this.functionName.equalsIgnoreCase("log")) {
            this.datatype = 0;
            return this.computeMath1((short)16);
        }
        if (this.functionName.equalsIgnoreCase("mod")) {
            this.datatype = 0;
            return this.computeMath2((short)4);
        }
        if (this.functionName.equalsIgnoreCase("pi")) {
            this.datatype = 0;
            return Math.PI;
        }
        if (this.functionName.equalsIgnoreCase("pow")) {
            this.datatype = 0;
            return this.computeMath2((short)19);
        }
        if (this.functionName.equalsIgnoreCase("random")) {
            this.datatype = 0;
            return Math.random();
        }
        if (this.functionName.equalsIgnoreCase("rint")) {
            this.datatype = 0;
            return this.computeMath1((short)21);
        }
        if (this.functionName.equalsIgnoreCase("sin")) {
            this.datatype = 0;
            return this.computeMath1((short)9);
        }
        if (this.functionName.equalsIgnoreCase("sqrt")) {
            this.datatype = 0;
            return this.computeMath1((short)22);
        }
        if (this.functionName.equalsIgnoreCase("tan")) {
            this.datatype = 0;
            return this.computeMath1((short)12);
        }
        if (this.functionName.equalsIgnoreCase("toDegrees")) {
            this.datatype = 0;
            return this.computeMath1((short)17);
        }
        if (this.functionName.equalsIgnoreCase("toRadians")) {
            this.datatype = 0;
            return this.computeMath1((short)18);
        }
        if (this.functionName.equalsIgnoreCase("toString")) {
            this.datatype = 1;
            this.checkNumberOfArgs(new int[]{1, 2, 3});
            if (this.args.size() == 1) {
                return this.getNumber(this.args.elementAt(0)).toString();
            }
            double tmp = this.getdouble(this.args.elementAt(0));
            int decPt = this.getDouble(this.args.elementAt(1)).intValue();
            if (decPt < 0) {
                decPt = 0;
            }
            String s = Double.valueOf(tmp).toString();
            int noDec = s.length() - s.indexOf(46) - 1;
            if (this.args.size() == 3 && decPt > 0 && !this.getboolean(this.args.elementAt(2)) && noDec > decPt) {
                boolean positive = tmp >= 0.0;
                tmp = Math.abs(tmp);
                tmp = Math.floor(tmp * Math.pow(10.0, decPt)) / Math.pow(10.0, decPt);
                if (!positive) {
                    tmp *= -1.0;
                }
            }
            NumericFormat numFormat = new NumericFormat();
            numFormat.decimal = decPt;
            return numFormat.format(tmp);
        }
        if (this.functionName.equalsIgnoreCase("getHeader")) {
            this.datatype = 1;
            this.checkNumberOfArgs(1);
            if ((Operand)this.args.elementAt(0) instanceof ScriptReportElement) {
                return ((ScriptReportElement)this.args.elementAt(0)).getHeader(table);
            }
            String msg = LanguageEncoder.getText("Wrong argument type, expecting a Column Field");
            throw new Exception(msg);
        }
        if (this.functionName.equalsIgnoreCase("getPage")) {
            this.datatype = 1;
            return totalsections > 1 ? page + "-" + section : page + "";
        }
        if (this.functionName.equalsIgnoreCase("getTotalPages")) {
            this.datatype = 1;
            if (totalpages == -1) {
                return "#TP";
            }
            return totalpages + "";
        }
        if (this.functionName.equalsIgnoreCase("getTotalSections")) {
            this.datatype = 1;
            return totalsections + "";
        }
        if (this.functionName.equalsIgnoreCase("indexOf")) {
            this.datatype = 0;
            this.checkNumberOfArgs(new int[]{2, 3});
            String string = this.getString(this.args.elementAt(0));
            String pattern = this.getString(this.args.elementAt(1));
            if (string == null) {
                return -1.0;
            }
            if (this.args.size() == 2) {
                return (double)string.indexOf(pattern);
            }
            int start = this.getDouble(this.args.elementAt(2)).intValue();
            return (double)string.indexOf(pattern, start);
        }
        if (this.functionName.equalsIgnoreCase("insert")) {
            this.datatype = 1;
            this.checkNumberOfArgs(3);
            String string = this.getString(this.args.elementAt(0));
            int charNum = this.getDouble(this.args.elementAt(1)).intValue();
            String newChars = this.getString(this.args.elementAt(2));
            return new StringBuffer(string).insert(charNum, newChars).toString();
        }
        if (this.functionName.equalsIgnoreCase("lastIndexOf")) {
            this.datatype = 0;
            this.checkNumberOfArgs(new int[]{2, 3});
            String string = this.getString(this.args.elementAt(0));
            String pattern = this.getString(this.args.elementAt(1));
            if (this.args.size() == 2) {
                return (double)string.lastIndexOf(pattern);
            }
            int start = this.getDouble(this.args.elementAt(2)).intValue();
            return (double)string.lastIndexOf(pattern, start);
        }
        if (this.functionName.equalsIgnoreCase("replace")) {
            this.datatype = 1;
            this.checkNumberOfArgs(new int[]{3, 4});
            if (this.args.size() == 3) {
                String string = this.getString(this.args.elementAt(0));
                String oldStr = this.getString(this.args.elementAt(1));
                String newStr = this.getString(this.args.elementAt(2));
                return QbUtil.replace(string, oldStr, newStr);
            }
            String string = this.getString(this.args.elementAt(0));
            int start = this.getDouble(this.args.elementAt(1)).intValue();
            int end = this.getDouble(this.args.elementAt(2)).intValue();
            String newStr = this.getString(this.args.elementAt(3));
            return string.substring(0, start) + newStr + string.substring(end);
        }
        if (this.functionName.equalsIgnoreCase("setMaxLength")) {
            this.datatype = 1;
            this.checkNumberOfArgs(2);
            String string = this.getString(this.args.elementAt(0));
            int val = this.getDouble(this.args.elementAt(1)).intValue();
            if (val < 0 || string.length() <= val) {
                return string;
            }
            return string.substring(0, val);
        }
        if (this.functionName.equalsIgnoreCase("strcmp")) {
            this.datatype = 0;
            this.checkNumberOfArgs(2);
            String string1 = this.getString(this.args.elementAt(0));
            String string2 = this.getString(this.args.elementAt(1));
            return (double)string1.compareTo(string2);
        }
        if (this.functionName.equalsIgnoreCase("strcmpIgnoreCase")) {
            this.datatype = 0;
            this.checkNumberOfArgs(2);
            String string1 = this.getString(this.args.elementAt(0));
            String string2 = this.getString(this.args.elementAt(1));
            return (double)string1.compareToIgnoreCase(string2);
        }
        if (this.functionName.equalsIgnoreCase("strcat")) {
            this.datatype = 1;
            StringBuffer strBuf = new StringBuffer();
            for (int i2 = 0; i2 < this.args.size(); ++i2) {
                int type = ((Operand)this.args.elementAt(i2)).getDatatype(this.report);
                if (type == 1) {
                    strBuf.append(this.getString(this.args.elementAt(i2)));
                    continue;
                }
                if (type == 0) {
                    strBuf.append(this.getDouble(this.args.elementAt(i2)).toString());
                    continue;
                }
                if (type == 3) {
                    strBuf.append(FormatUtil.getDateTimeText(r.getLocale(), r.getTimeZone(), "MMM dd,yyyy", this.getDate(this.args.elementAt(i2))));
                    continue;
                }
                if (type == 4) {
                    strBuf.append(FormatUtil.getDateTimeText(r.getLocale(), r.getTimeZone(), "hh:mm:ss", this.getDate(this.args.elementAt(i2))));
                    continue;
                }
                if (type == 5) {
                    strBuf.append(FormatUtil.getDateTimeText(r.getLocale(), r.getTimeZone(), "MMM dd,yyyy hh:mm:ss", this.getDate(this.args.elementAt(i2))));
                    continue;
                }
                if (type == 2) {
                    strBuf.append(this.getBoolean(this.args.elementAt(i2)).toString());
                    continue;
                }
                strBuf.append(this.getString(this.args.elementAt(i2)));
            }
            return strBuf.toString();
        }
        if (this.functionName.equalsIgnoreCase("strlen")) {
            this.datatype = 0;
            this.checkNumberOfArgs(1);
            return (double)this.getString(this.args.elementAt(0)).length();
        }
        if (this.functionName.equalsIgnoreCase("substring")) {
            this.datatype = 1;
            this.checkNumberOfArgs(new int[]{2, 3});
            if (this.args.size() == 2) {
                return this.getString(this.args.elementAt(0)).substring(this.getDouble(this.args.elementAt(1)).intValue());
            }
            return this.getString(this.args.elementAt(0)).substring(this.getDouble(this.args.elementAt(1)).intValue(), this.getDouble(this.args.elementAt(2)).intValue());
        }
        if (this.functionName.equalsIgnoreCase("trim")) {
            this.datatype = 1;
            this.checkNumberOfArgs(1);
            String str = this.getString(this.args.elementAt(0));
            return str == null ? null : str.trim();
        }
        if (this.functionName.equalsIgnoreCase("toLowerCase")) {
            this.datatype = 1;
            this.checkNumberOfArgs(1);
            String str = this.getString(this.args.elementAt(0));
            return str == null ? null : str.toLowerCase();
        }
        if (this.functionName.equalsIgnoreCase("getAllRowData")) {
            this.datatype = 1;
            i = this.findIndex(table, table, index);
            return this.getAllRowData(table, i);
        }
        if (this.functionName.equalsIgnoreCase("toNumeric")) {
            this.datatype = 0;
            this.checkNumberOfArgs(1);
            return Double.valueOf(this.getString(this.args.elementAt(0)));
        }
        if (this.functionName.equalsIgnoreCase("toUpperCase")) {
            this.datatype = 1;
            this.checkNumberOfArgs(1);
            String str = this.getString(this.args.elementAt(0));
            return str == null ? null : str.toUpperCase();
        }
        if (this.functionName.equalsIgnoreCase("addTime")) {
            try {
                this.datatype = ((Operand)this.args.elementAt(0)).getDatatype(r);
                this.checkNumberOfArgs(3);
                Calendar cal = this.createCalendar(r.getLocale(), r.getTimeZone());
                cal.setTime(this.getDate(this.args.elementAt(0)));
                cal.add(this.getCalendarField(this.args.elementAt(1)), this.getDouble(this.args.elementAt(2)).intValue());
                java.util.Date date = cal.getTime();
                if (this.datatype < 0) {
                    this.datatype = 3;
                }
                if (this.datatype == 3) {
                    return date;
                }
                if (this.datatype == 4) {
                    return new Time(date.getTime());
                }
                if (this.datatype == 5) {
                    return new Timestamp(date.getTime());
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Invalid date/time value", ex);
            }
        } else {
            if (this.functionName.equalsIgnoreCase("getAmPm")) {
                this.datatype = 1;
                this.checkNumberOfArgs(1);
                return FormatUtil.getDateTimeText(r.getLocale(), r.getTimeZone(), "a", this.getDate(this.args.elementAt(0)));
            }
            if (this.functionName.equalsIgnoreCase("getCurrentDate") || this.functionName.equalsIgnoreCase("currentDate")) {
                this.datatype = 3;
                return this.newDate(new java.util.Date(), r.getLocale(), r.getTimeZone());
            }
            if (this.functionName.equalsIgnoreCase("getCurrentDateTime") || this.functionName.equalsIgnoreCase("currentDateTime")) {
                this.datatype = 5;
                return this.newTimestamp(new java.util.Date(), r.getLocale(), r.getTimeZone());
            }
            if (this.functionName.equalsIgnoreCase("getCurrentTime") || this.functionName.equalsIgnoreCase("currentTime")) {
                this.datatype = 4;
                return this.newTime(new java.util.Date(), r.getLocale(), r.getTimeZone());
            }
            if (this.functionName.equalsIgnoreCase("getDateTime")) {
                this.datatype = 0;
                this.checkNumberOfArgs(2);
                Calendar cal = this.createCalendar(r.getLocale(), r.getTimeZone());
                cal.setTime(this.getDate(this.args.elementAt(0)));
                return (double)cal.get(this.getCalendarField(this.args.elementAt(1)));
            }
            if (this.functionName.equalsIgnoreCase("getDayDifference")) {
                this.datatype = 0;
                this.checkNumberOfArgs(2);
                long diff = this.getDate(this.args.elementAt(0)).getTime() - this.getDate(this.args.elementAt(1)).getTime();
                long abs = Math.abs(diff);
                int diffDay = (int)Math.floor((abs + 3600000L) / 86400000L);
                if (diff < 0L) {
                    diffDay = -1 * diffDay;
                }
                return (double)diffDay;
            }
            if (this.functionName.equalsIgnoreCase("getDayOfWeek")) {
                this.datatype = 1;
                this.checkNumberOfArgs(1);
                return FormatUtil.getDateTimeText(r.getLocale(), r.getTimeZone(), "EEEEE", this.getDate(this.args.elementAt(0)));
            }
            if (this.functionName.equalsIgnoreCase("getWeekOfYear")) {
                this.datatype = 0;
                this.checkNumberOfArgs(1);
                Calendar cal = this.createCalendar(r.getLocale(), r.getTimeZone());
                cal.setTime(this.getDate(this.args.elementAt(0)));
                return (double)cal.get(3);
            }
            if (this.functionName.equalsIgnoreCase("getEra")) {
                this.datatype = 1;
                this.checkNumberOfArgs(1);
                return FormatUtil.getDateTimeText(r.getLocale(), r.getTimeZone(), "G", this.getDate(this.args.elementAt(0)));
            }
            if (this.functionName.equalsIgnoreCase("getMonth")) {
                this.datatype = 1;
                this.checkNumberOfArgs(1);
                return FormatUtil.getDateTimeText(r.getLocale(), r.getTimeZone(), "MMMMM", this.getDate(this.args.elementAt(0)));
            }
            if (this.functionName.equalsIgnoreCase("rollTime")) {
                this.datatype = ((Operand)this.args.elementAt(0)).getDatatype(r);
                Calendar cal = this.createCalendar(r.getLocale(), r.getTimeZone());
                cal.setTime(this.getDate(this.args.elementAt(0)));
                int field = this.getCalendarField(this.args.elementAt(1));
                int amt = this.getDouble(this.args.elementAt(2)).intValue();
                boolean up = amt > 0;
                amt = (int)Math.abs((double)amt);
                for (int i3 = 0; i3 < amt; ++i3) {
                    cal.roll(field, up);
                }
                java.util.Date date = cal.getTime();
                if (this.datatype < 0) {
                    this.datatype = 3;
                }
                if (this.datatype == 3) {
                    return date;
                }
                if (this.datatype == 4) {
                    return new Time(date.getTime());
                }
                if (this.datatype == 5) {
                    return new Timestamp(date.getTime());
                }
            } else {
                boolean b1;
                boolean b;
                if (this.functionName.equalsIgnoreCase("printDate")) {
                    this.datatype = 1;
                    this.checkNumberOfArgs(new int[]{1, 2});
                    Date date = this.newDate(this.getDate(this.args.elementAt(0)), r.getLocale(), r.getTimeZone());
                    if (this.args.size() == 1) {
                        return ((java.util.Date)date).toString();
                    }
                    return FormatUtil.getDateTimeText(r.getLocale(), r.getTimeZone(), this.getString(this.args.elementAt(1)), date);
                }
                if (this.functionName.equalsIgnoreCase("printDateTime")) {
                    this.datatype = 1;
                    this.checkNumberOfArgs(new int[]{1, 2});
                    Timestamp date = this.newTimestamp(this.getDate(this.args.elementAt(0)), r.getLocale(), r.getTimeZone());
                    if (this.args.size() == 1) {
                        return ((java.util.Date)date).toString();
                    }
                    return FormatUtil.getDateTimeText(r.getLocale(), r.getTimeZone(), this.getString(this.args.elementAt(1)), date);
                }
                if (this.functionName.equalsIgnoreCase("printTime")) {
                    this.datatype = 1;
                    this.checkNumberOfArgs(new int[]{1, 2});
                    Time date = this.newTime(this.getDate(this.args.elementAt(0)), r.getLocale(), r.getTimeZone());
                    if (this.args.size() == 1) {
                        return ((java.util.Date)date).toString();
                    }
                    return FormatUtil.getDateTimeText(r.getLocale(), r.getTimeZone(), this.getString(this.args.elementAt(1)), date);
                }
                if (this.functionName.equalsIgnoreCase("toDate")) {
                    this.datatype = 5;
                    return new Timestamp((long)this.getdouble(this.args.elementAt(0)));
                }
                if (this.functionName.equalsIgnoreCase("add")) {
                    this.datatype = 0;
                    double number = this.getdouble(this.args.elementAt(0));
                    for (int i4 = 1; i4 < this.args.size(); ++i4) {
                        number += this.getdouble(this.args.elementAt(i4));
                    }
                    return number;
                }
                if (this.functionName.equalsIgnoreCase("subtract")) {
                    this.datatype = 0;
                    double number = this.getdouble(this.args.elementAt(0));
                    for (int i5 = 1; i5 < this.args.size(); ++i5) {
                        number -= this.getdouble(this.args.elementAt(i5));
                    }
                    return number;
                }
                if (this.functionName.equalsIgnoreCase("multiply")) {
                    this.datatype = 0;
                    double number = this.getdouble(this.args.elementAt(0));
                    for (int i6 = 1; i6 < this.args.size(); ++i6) {
                        number *= this.getdouble(this.args.elementAt(i6));
                    }
                    return number;
                }
                if (this.functionName.equalsIgnoreCase("divide")) {
                    this.datatype = 0;
                    double number1 = this.getdouble(this.args.elementAt(0));
                    double number2 = this.getdouble(this.args.elementAt(1));
                    return number1 / number2;
                }
                if (this.functionName.equalsIgnoreCase("and")) {
                    this.datatype = 2;
                    for (i = 0; i < this.args.size(); ++i) {
                        boolean b2 = this.getboolean(this.args.elementAt(i));
                        if (b2) continue;
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                }
                if (this.functionName.equalsIgnoreCase("or")) {
                    this.datatype = 2;
                    for (i = 0; i < this.args.size(); ++i) {
                        boolean b3 = this.getboolean(this.args.elementAt(i));
                        if (!b3) continue;
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                if (this.functionName.equalsIgnoreCase("not")) {
                    return !this.getboolean(this.args.elementAt(0));
                }
                if (this.functionName.equalsIgnoreCase("nand")) {
                    this.datatype = 2;
                    b = this.getboolean(this.args.elementAt(0));
                    for (int i7 = 1; i7 < this.args.size(); ++i7) {
                        b = b && this.getboolean(this.args.elementAt(i7));
                    }
                    return !b;
                }
                if (this.functionName.equalsIgnoreCase("nor")) {
                    this.datatype = 2;
                    b = this.getboolean(this.args.elementAt(0));
                    for (int i8 = 1; i8 < this.args.size(); ++i8) {
                        b = b || this.getboolean(this.args.elementAt(i8));
                    }
                    return !b;
                }
                if (this.functionName.equalsIgnoreCase("xnor")) {
                    this.datatype = 2;
                    b1 = this.getboolean(this.args.elementAt(0));
                    boolean b2 = this.getboolean(this.args.elementAt(1));
                    return b1 && b2 || !b1 && !b2;
                }
                if (this.functionName.equalsIgnoreCase("xor")) {
                    this.datatype = 2;
                    b1 = this.getboolean(this.args.elementAt(0));
                    boolean b2 = this.getboolean(this.args.elementAt(1));
                    return b1 && !b2 || !b1 && b2;
                }
                if (this.functionName.equalsIgnoreCase("within")) {
                    this.datatype = 2;
                    return this.compare((short)0);
                }
                if (this.functionName.equalsIgnoreCase("greaterThanEqualTo")) {
                    this.datatype = 2;
                    return this.compare((short)1);
                }
                if (this.functionName.equalsIgnoreCase("lessThanEqualTo")) {
                    this.datatype = 2;
                    return this.compare((short)2);
                }
                if (this.functionName.equalsIgnoreCase("equals")) {
                    this.datatype = 2;
                    return this.compare((short)3);
                }
                if (this.functionName.equalsIgnoreCase("greaterThan")) {
                    this.datatype = 2;
                    return this.compare((short)4);
                }
                if (this.functionName.equalsIgnoreCase("lessThan")) {
                    this.datatype = 2;
                    return this.compare((short)5);
                }
                if (this.functionName.equalsIgnoreCase("ifElse")) {
                    this.datatype = 1;
                    if (this.getboolean(this.args.elementAt(0))) {
                        return this.getString(this.args.elementAt(1));
                    }
                    return this.getString(this.args.elementAt(2));
                }
                if (this.functionName.equalsIgnoreCase("ifElse_Bool")) {
                    this.datatype = 2;
                    if (this.getboolean(this.args.elementAt(0))) {
                        return this.getBoolean(this.args.elementAt(1));
                    }
                    return this.getBoolean(this.args.elementAt(2));
                }
                if (this.functionName.equalsIgnoreCase("ifElse_Date")) {
                    this.datatype = 3;
                    if (this.getboolean(this.args.elementAt(0))) {
                        return this.getDate(this.args.elementAt(1));
                    }
                    return this.getDate(this.args.elementAt(2));
                }
                if (this.functionName.equalsIgnoreCase("ifElse_Num")) {
                    this.datatype = 0;
                    if (this.getboolean(this.args.elementAt(0))) {
                        return this.getDouble(this.args.elementAt(1));
                    }
                    return this.getDouble(this.args.elementAt(2));
                }
                if (this.functionName.equalsIgnoreCase("NUM") || this.functionName.equalsIgnoreCase("DBL")) {
                    this.datatype = 0;
                    return this.getDouble(this.args.elementAt(0));
                }
                if (this.functionName.equalsIgnoreCase("STR")) {
                    this.datatype = 1;
                    return this.getString(this.args.elementAt(0));
                }
                if (this.functionName.equalsIgnoreCase("DATE")) {
                    this.datatype = ((Operand)this.args.elementAt(0)).getDatatype(r);
                    return this.getDate(this.args.elementAt(0));
                }
                if (this.functionName.equalsIgnoreCase("BOOL")) {
                    this.datatype = 2;
                    return this.getBoolean(this.args.elementAt(0));
                }
                if (this.isCustomDefinedFunction()) {
                    ICustomDefinedFunctions funcList = Report.getCustomDefinedFunctions();
                    this.datatype = funcList.getReturnType(this.functionName);
                    int[] paramType = funcList.getParamTypes(this.functionName);
                    this.checkNumberOfArgs(paramType.length);
                    Object[] obj = new Object[paramType.length];
                    for (int i9 = 0; i9 < paramType.length; ++i9) {
                        Operand operand = (Operand)this.args.elementAt(i9);
                        Object object = operand.getValue(table, index, page, section, totalpages, totalsections, this.report, cell, dataobj, secondRound, preAggCol, resultCol, colData);
                        if (paramType[i9] == 0) {
                            obj[i9] = object;
                            continue;
                        }
                        if (paramType[i9] == 1) {
                            obj[i9] = object;
                            continue;
                        }
                        if (paramType[i9] == 2) {
                            obj[i9] = object;
                            continue;
                        }
                        if (paramType[i9] == 5) {
                            obj[i9] = this.newTimestamp((java.util.Date)object);
                            continue;
                        }
                        if (paramType[i9] == 4) {
                            obj[i9] = this.newTime((java.util.Date)object);
                            continue;
                        }
                        if (paramType[i9] != 3) continue;
                        obj[i9] = this.newDate((java.util.Date)object);
                    }
                    return funcList.getValue(this.functionName, obj);
                }
            }
        }
        throw new Exception(LanguageEncoder.getText("Function name not recognized"));
    }

    private String getAllRowData(ReportTable table, int index) {
        StringBuffer sb = new StringBuffer();
        boolean isCrosstab = false;
        if (this.report.getReportType() == 2) {
            isCrosstab = true;
        }
        boolean isSummary = false;
        if (index == -1 || this.cell != null && isCrosstab && index >= table.getRowCount()) {
            isSummary = true;
        }
        ColInfo[] reportMapping = this.report.colInfo;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            ReportColumn col = table.getColumn(i);
            String value = "";
            if (!isCrosstab && reportMapping[i].isRowBreak()) {
                value = this.getLastRowBreakValue(this.report.getReportTables().elementAt(0), table, i);
                if (value == null) {
                    value = "";
                }
            } else {
                if (isSummary) continue;
                if (this.cell != null && this.cell.getID().equals(table.getColumn(i).getID())) {
                    value = this.dataobj != null ? this.dataobj.toString() : "";
                } else {
                    Object obj = table.getFirstColumnScriptedValue(i);
                    if (obj != null) {
                        value = obj.toString();
                    }
                }
            }
            sb.append("(" + col.getText() + ") ");
            sb.append(value);
            if (i >= table.getColumnCount() - 1 && (i != table.getColumnCount() - 1 || index <= -1)) continue;
            sb.append("  ");
        }
        if (this.dataobj != null && isSummary) {
            if (isCrosstab) {
                sb.append(this.dataobj.toString());
            } else {
                sb.append("(" + this.cell.getFormulaName() + ") " + this.dataobj.toString());
            }
        }
        return sb.toString();
    }

    private String getLastRowBreakValue(ReportTable currentTbl, ReportTable table, int col) {
        if (!(currentTbl instanceof ReportTreeTable)) {
            if (currentTbl == table) {
                ReportColumn rcol = currentTbl.getColumn(col);
                if (rcol.hasScriptedData(0) && rcol.getScriptedData(0) != null) {
                    return rcol.getScriptedData(0).toString();
                }
                if (rcol.getData(0) != null) {
                    return rcol.getData(0).toString();
                }
                return "";
            }
            return null;
        }
        ReportTreeTable rtt = (ReportTreeTable)currentTbl;
        Vector<ReportTable> subTables = rtt.getSubTable();
        for (int i = 0; i < subTables.size(); ++i) {
            String val = this.getLastRowBreakValue(subTables.get(i), table, col);
            if (val != null && val.equals("")) {
                Object obj = rtt.getFirstColumnScriptedValue(col);
                if (obj != null) {
                    return obj.toString();
                }
                return "";
            }
            if (val == null) continue;
            return val;
        }
        return null;
    }

    @Override
    public int getDatatype(Report report) {
        if (this.datatype >= 0) {
            return this.datatype;
        }
        if (this.functionName.equalsIgnoreCase("average") || this.functionName.equalsIgnoreCase("AVG")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("count")) {
            this.datatype = 0;
        } else if (this.functionName.equals("countdistinct")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("max")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("min")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("stddev")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("sum")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("sumsquare")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("variance")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("first")) {
            this.datatype = ((Operand)this.args.elementAt(0)).getDatatype(report);
        } else if (this.functionName.equalsIgnoreCase("last")) {
            this.datatype = ((Operand)this.args.elementAt(this.args.size() - 1)).getDatatype(report);
        } else if (this.functionName.equalsIgnoreCase("none")) {
            this.datatype = ((Operand)this.args.elementAt(0)).getDatatype(report);
        } else if (this.functionName.equalsIgnoreCase("getColumnCount")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("getRowIndex")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("getTotalRowIndex")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("getRowIndexOfCurrentTable")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("getTotalRowIndexOfCurrentTable")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("getGroupIndex")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("abs")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("acos")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("asin")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("atan")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("atan2")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("ceil")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("cos")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("e")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("exp")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("factorial")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("floor")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("log")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("mod")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("pi")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("pow")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("random")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("rint")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("sin")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("sqrt")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("tan")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("toDegrees")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("toRadians")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("toString")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("getHeader")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("getPage")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("getTotalPages")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("getTotalSections")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("indexOf")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("insert")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("lastIndexOf")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("replace")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("setMaxLength")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("strcmp")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("strcmpIgnoreCase")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("strcat")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("strlen")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("substring")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("trim")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("toLowerCase")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("toNumeric")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("toUpperCase")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("getAllRowData")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("addTime")) {
            this.datatype = ((Operand)this.args.elementAt(0)).getDatatype(report);
        } else if (this.functionName.equalsIgnoreCase("getAmPm")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("getCurrentDate")) {
            this.datatype = 3;
        } else if (this.functionName.equalsIgnoreCase("getCurrentDateTime")) {
            this.datatype = 5;
        } else if (this.functionName.equalsIgnoreCase("getCurrentTime")) {
            this.datatype = 4;
        } else if (this.functionName.equalsIgnoreCase("getDateTime")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("getDayDifference")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("getDayOfWeek")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("getEra")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("getMonth")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("rollTime")) {
            this.datatype = ((Operand)this.args.elementAt(0)).getDatatype(report);
        } else if (this.functionName.equalsIgnoreCase("printDate")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("printDateTime")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("printTime")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("toDate")) {
            this.datatype = 5;
        } else if (this.functionName.equalsIgnoreCase("add")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("subtract")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("multiply")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("divide")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("and")) {
            this.datatype = 2;
        } else if (this.functionName.equalsIgnoreCase("or")) {
            this.datatype = 2;
        } else if (this.functionName.equalsIgnoreCase("not")) {
            this.datatype = 2;
        } else if (this.functionName.equalsIgnoreCase("nand")) {
            this.datatype = 2;
        } else if (this.functionName.equalsIgnoreCase("nor")) {
            this.datatype = 2;
        } else if (this.functionName.equalsIgnoreCase("xnor")) {
            this.datatype = 2;
        } else if (this.functionName.equalsIgnoreCase("xor")) {
            this.datatype = 2;
        } else if (this.functionName.equalsIgnoreCase("within")) {
            this.datatype = 2;
        } else if (this.functionName.equalsIgnoreCase("greaterThanEqualTo")) {
            this.datatype = 2;
        } else if (this.functionName.equalsIgnoreCase("lessThanEqualTo")) {
            this.datatype = 2;
        } else if (this.functionName.equalsIgnoreCase("equals")) {
            this.datatype = 2;
        } else if (this.functionName.equalsIgnoreCase("greaterThan")) {
            this.datatype = 2;
        } else if (this.functionName.equalsIgnoreCase("lessThan")) {
            this.datatype = 2;
        } else if (this.functionName.equalsIgnoreCase("ifElse")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("ifElse_Bool")) {
            this.datatype = 2;
        } else if (this.functionName.equalsIgnoreCase("ifElse_Date")) {
            this.datatype = 3;
        } else if (this.functionName.equalsIgnoreCase("ifElse_Num")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("NUM") || this.functionName.equalsIgnoreCase("DBL")) {
            this.datatype = 0;
        } else if (this.functionName.equalsIgnoreCase("STR")) {
            this.datatype = 1;
        } else if (this.functionName.equalsIgnoreCase("DATE")) {
            this.datatype = ((Operand)this.args.elementAt(0)).getDatatype(report);
        } else if (this.functionName.equalsIgnoreCase("BOOL")) {
            this.datatype = 2;
        } else if (this.isCustomDefinedFunction()) {
            ICustomDefinedFunctions funcList = Report.getCustomDefinedFunctions();
            this.datatype = funcList.getReturnType(this.functionName);
        }
        return this.datatype;
    }

    private boolean isCustomDefinedFunction() {
        boolean found = false;
        ICustomDefinedFunctions funcList = Report.getCustomDefinedFunctions();
        if (funcList != null) {
            String[] funcNames;
            for (String funcName : funcNames = funcList.getAllFunctionNames()) {
                if (!this.functionName.equals(funcName)) continue;
                found = true;
            }
        }
        return found;
    }

    private String getAddress() {
        if (this.address == null) {
            this.address = String.valueOf(this.uniqueNumber);
        }
        return this.address;
    }

    private Object computeAggregation(ReportTable table, short agg) throws Exception {
        if (this.args.size() == 1) {
            if ((Operand)this.args.elementAt(0) instanceof ScriptReportElement) {
                ScriptReportElement elt = (ScriptReportElement)this.args.elementAt(0);
                if (elt.getSubReportIndex() != -1) {
                    String msg = LanguageEncoder.getText("Aggregation on Sub Report columns are not supported! Please create a formula and insert the formula as a column in the main report, then apply aggregation on the column.");
                    throw new Exception(msg);
                }
                int col = elt.getColumnIndex(table);
                Object object = this.getComputedValue(agg, col);
                if (object != null) {
                    return object;
                }
                if (elt.getColumnIndex(table) >= 0 && table.getAggrValue(agg + " " + elt.toString() + " " + table.getColumn(elt.getColumnIndex(table)).getScript()) != null) {
                    return table.getAggrValue(agg + " " + elt.toString() + " " + table.getColumn(elt.getColumnIndex(table)).getScript());
                }
                int reportType = this.report.getReportType();
                Properties treeProp = new Properties();
                DataSet obj = new DataSet("FUNC_" + this.getAddress(), this.charLen, table.getColumnCount(), reportType == 1 || reportType == 2 || reportType == 3, treeProp);
                if (col >= 0) {
                    if (table instanceof ReportTreeTable) {
                        Vector list = new Vector();
                        int size = this.collectActualData((ReportTreeTable)table, list, col);
                        if (size == 0) {
                            size = this.collectData((ReportTreeTable)table, list, col);
                        }
                        for (int i = 0; i < list.size(); ++i) {
                            DataSet tmp = (DataSet)list.elementAt(i);
                            for (int j = 0; j < tmp.size(); ++j) {
                                obj.addElement(tmp.elementAt(j));
                            }
                        }
                    } else {
                        obj = table.getColumn(col).getScriptedData(table, this.report, col);
                    }
                } else {
                    elt.getValue(table, 0, 1, 1, 1, 1, this.report, null, null, this.secondRound, this.preAggCol, this.resultCol, this.colData);
                    if (elt.dbColumn != null) {
                        for (int i = 0; i < elt.dbColumn.size(); ++i) {
                            obj.addElement(((Vector)elt.dbColumn.elementAt(i)).elementAt(0));
                        }
                    }
                }
                object = Aggregation.getComputedValue(agg, obj, table);
                if (object != null) {
                    table.addAggrValue(agg + " " + elt.toString() + " " + table.getColumn(col).getScript(), object);
                }
                return object;
            }
            if ((Operand)this.args.elementAt(0) instanceof Formula) {
                Object object;
                int col = -1;
                for (int i = 0; i < this.report.colInfo.length; ++i) {
                    if (this.report.colInfo[i].getFormulaName() == null || !this.report.colInfo[i].getFormulaName().equals(((Formula)this.args.elementAt(0)).getName())) continue;
                    col = i;
                    break;
                }
                if (col >= 0 && (object = this.getComputedValue(agg, col)) != null) {
                    return object;
                }
                if (table.getAggrValue(agg + " " + ((Formula)this.args.elementAt(0)).getName()) != null) {
                    return table.getAggrValue(agg + " " + ((Formula)this.args.elementAt(0)).getName());
                }
                if (col >= 0) {
                    int reportType = this.report.getReportType();
                    DataSet obj = new DataSet("AGGR2_" + this.getAddress(), this.charLen, table.getColumnCount(), reportType == 1 || reportType == 2 || reportType == 3, null);
                    if (table instanceof ReportTreeTable) {
                        Vector list = new Vector();
                        int size = this.collectActualData((ReportTreeTable)table, list, col);
                        if (size == 0) {
                            size = this.collectData((ReportTreeTable)table, list, col);
                        }
                        for (int i = 0; i < list.size(); ++i) {
                            DataSet tmp = (DataSet)list.elementAt(i);
                            for (int j = 0; j < tmp.size(); ++j) {
                                obj.addElement(tmp.elementAt(j));
                            }
                        }
                    } else {
                        obj = table.getColumn(col).getScriptedData(table, this.report, col);
                    }
                    Object object2 = Aggregation.getComputedValue(agg, obj, table);
                    table.addAggrValue(agg + " " + ((Formula)this.args.elementAt(0)).getName(), object2);
                    return object2;
                }
                String msg = LanguageEncoder.getText("This formula is not a column in the report");
                throw new Exception(msg);
            }
            String msg = LanguageEncoder.getText("Wrong argument type, expecting a Column Field");
            throw new Exception(msg);
        }
        Object[] obj = new Double[this.args.size()];
        for (int i = 0; i < this.args.size(); ++i) {
            obj[i] = this.getDouble(this.args.elementAt(i));
        }
        return Aggregation.getComputedValue(agg, obj);
    }

    private int collectActualData(ReportTreeTable table, Vector list, int col) {
        int count = 0;
        for (int i = 0; i < table.countSubTable(); ++i) {
            ReportTable tmp = table.getSubTable(i);
            if (tmp.isAggregationTable()) continue;
            if (tmp instanceof ReportTreeTable) {
                count += this.collectActualData((ReportTreeTable)tmp, list, col);
                continue;
            }
            if (tmp.getColumn(col) == null || tmp.getColumn(col).getActualDataCount() == -1) continue;
            list.addElement(tmp.getColumn(col).getScriptedData(tmp, this.report, col));
            count += tmp.getColumn(col).getActualDataCount();
        }
        return count;
    }

    private int collectData(ReportTreeTable table, Vector list, int col) {
        int count = 0;
        for (int i = 0; i < table.countSubTable(); ++i) {
            ReportTable tmp = table.getSubTable(i);
            if (tmp.isAggregationTable()) continue;
            if (tmp instanceof ReportTreeTable) {
                count += this.collectData((ReportTreeTable)tmp, list, col);
                continue;
            }
            if (tmp.getColumn(col) == null || tmp.getColumn(col).getDataCount() == -1) continue;
            list.addElement(tmp.getColumn(col).getScriptedData(tmp, this.report, col));
            count += tmp.getColumn(col).getDataCount();
        }
        return count;
    }

    private Double computeMath1(short func) throws Exception {
        this.checkNumberOfArgs(1);
        double number = this.getdouble(this.args.elementAt(0));
        switch (func) {
            case 23: {
                return Math.abs(number);
            }
            case 6: {
                return Math.acos(number);
            }
            case 8: {
                return Math.asin(number);
            }
            case 10: {
                return Math.atan(number);
            }
            case 13: {
                return Math.ceil(number);
            }
            case 7: {
                return Math.cos(number);
            }
            case 14: {
                return Math.exp(number);
            }
            case 33: {
                double val = this.getdouble(this.args.elementAt(0));
                double val2 = 1.0;
                int i = 2;
                while ((double)i <= val) {
                    val2 *= (double)i;
                    ++i;
                }
                return val2;
            }
            case 15: {
                return Math.floor(number);
            }
            case 16: {
                return Math.log(number);
            }
            case 21: {
                return Math.rint(number);
            }
            case 9: {
                return Math.sin(number);
            }
            case 22: {
                return Math.sqrt(number);
            }
            case 12: {
                return Math.tan(number);
            }
            case 17: {
                return Math.toDegrees(number);
            }
            case 18: {
                return Math.toRadians(number);
            }
        }
        return null;
    }

    private Double computeMath2(short func) throws Exception {
        this.checkNumberOfArgs(2);
        double number1 = this.getdouble(this.args.elementAt(0));
        double number2 = this.getdouble(this.args.elementAt(1));
        switch (func) {
            case 11: {
                return Math.atan2(number1, number2);
            }
            case 4: {
                return number1 % number2;
            }
            case 19: {
                return Math.pow(number1, number2);
            }
        }
        return null;
    }

    private Number getNumber(Object arg) throws Exception {
        Operand operand = (Operand)arg;
        Object object = operand.getValue(this.table, this.index, this.page, this.section, this.totalpages, this.totalsections, this.report, this.cell, this.dataobj, this.secondRound, this.preAggCol, this.resultCol, this.colData);
        if (object == null) {
            return 0;
        }
        int type = operand.getDatatype(this.report);
        if (operand instanceof ScriptReportElement) {
            if (object instanceof Number) {
                return (Number)object;
            }
            return 0.0;
        }
        if (type == 0) {
            return (Number)object;
        }
        throw new Exception(LanguageEncoder.getText(arg.toString() + " is of wrong datatype, NUMBER expected"));
    }

    private Double getDouble(Object arg) throws Exception {
        return this.getdouble(arg);
    }

    private double getdouble(Object arg) throws Exception {
        Operand operand = (Operand)arg;
        Object object = operand.getValue(this.table, this.index, this.page, this.section, this.totalpages, this.totalsections, this.report, this.cell, this.dataobj, this.secondRound, this.preAggCol, this.resultCol, this.colData);
        if (object == null) {
            return 0.0;
        }
        int type = operand.getDatatype(this.report);
        if (operand instanceof ScriptReportElement) {
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            return 0.0;
        }
        if (type == 0) {
            return ((Number)object).doubleValue();
        }
        throw new Exception(LanguageEncoder.getText(arg.toString() + " is of wrong datatype, NUMBER expected"));
    }

    private String getString(Object arg) throws Exception {
        Operand operand = (Operand)arg;
        Object object = operand.getValue(this.table, this.index, this.page, this.section, this.totalpages, this.totalsections, this.report, this.cell, this.dataobj, this.secondRound, this.preAggCol, this.resultCol, this.colData);
        int type = operand.getDatatype(this.report);
        if (type == 1 || operand instanceof ScriptReportElement) {
            return (String)object;
        }
        throw new Exception(LanguageEncoder.getText(arg.toString() + " is of wrong datatype, STRING expected"));
    }

    private Boolean getBoolean(Object arg) throws Exception {
        Operand operand = (Operand)arg;
        Object object = operand.getValue(this.table, this.index, this.page, this.section, this.totalpages, this.totalsections, this.report, this.cell, this.dataobj, this.secondRound, this.preAggCol, this.resultCol, this.colData);
        int type = operand.getDatatype(this.report);
        if (operand instanceof ScriptReportElement) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return Boolean.FALSE;
        }
        if (type == 2) {
            return (Boolean)object;
        }
        throw new Exception(LanguageEncoder.getText(arg.toString() + " is of wrong datatype, BOOLEAN expected"));
    }

    private boolean getboolean(Object arg) throws Exception {
        return this.getBoolean(arg);
    }

    private java.util.Date getDate(Object arg) throws Exception {
        Operand operand = (Operand)arg;
        Object object = operand.getValue(this.table, this.index, this.page, this.section, this.totalpages, this.totalsections, this.report, this.cell, this.dataobj, this.secondRound, this.preAggCol, this.resultCol, this.colData);
        int type = operand.getDatatype(this.report);
        if (operand instanceof ScriptReportElement) {
            if (object instanceof java.util.Date) {
                return this.newTimestamp((java.util.Date)object);
            }
            return new java.util.Date();
        }
        if (type == 3) {
            return this.newDate((java.util.Date)object);
        }
        if (type == 4) {
            return this.newTime((java.util.Date)object);
        }
        if (type == 5) {
            return this.newTimestamp((java.util.Date)object);
        }
        throw new Exception(LanguageEncoder.getText(arg.toString() + " is of wrong datatype, DATE expected"));
    }

    private int getCalendarField(Object arg) throws Exception {
        Operand operand = (Operand)arg;
        Object object = operand.getValue(this.table, this.index, this.page, this.section, this.totalpages, this.totalsections, this.report, this.cell, this.dataobj, this.secondRound, this.preAggCol, this.resultCol, this.colData);
        int type = operand.getDatatype(this.report);
        if (type == 6) {
            String s = (String)object;
            for (int i = 0; i < CALENDAR_CONST.length; ++i) {
                if (!s.equalsIgnoreCase(CALENDAR_CONST[i])) continue;
                return i;
            }
            return 0;
        }
        throw new Exception(LanguageEncoder.getText(arg.toString() + " is of wrong datatype, CALENDARFIELD expected"));
    }

    private void checkNumberOfArgs(int number) throws Exception {
        if (this.args == null || this.args.size() != number) {
            throw new Exception(LanguageEncoder.getText(this.functionName + " has wrong number of arguments"));
        }
    }

    private void checkNumberOfArgs(int[] number) throws Exception {
        boolean ok = false;
        for (int element : number) {
            if (this.args.size() != element) continue;
            ok = true;
        }
        if (!ok) {
            throw new Exception(LanguageEncoder.getText(this.functionName + " has wrong number of arguments"));
        }
    }

    private Calendar createCalendar(Locale locale, TimeZone zone) {
        Calendar cal = locale == null ? Calendar.getInstance() : Calendar.getInstance(locale);
        if (zone != null) {
            cal.setTimeZone(zone);
        }
        return cal;
    }

    private Date newDate(java.util.Date date) {
        return this.newDate(date, null, null);
    }

    private Date newDate(java.util.Date date, Locale locale, TimeZone zone) {
        Calendar cal = this.createCalendar(locale, zone);
        cal.setTime(date);
        return new Date(cal.get(1) - 1900, cal.get(2), cal.get(5));
    }

    private Timestamp newTimestamp(java.util.Date date) {
        return this.newTimestamp(date, null, null);
    }

    private Timestamp newTimestamp(java.util.Date date, Locale locale, TimeZone zone) {
        Calendar cal = this.createCalendar(locale, zone);
        cal.setTime(date);
        return new Timestamp(cal.get(1) - 1900, cal.get(2), cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }

    private Time newTime(java.util.Date date) {
        return this.newTime(date, null, null);
    }

    private Time newTime(java.util.Date date, Locale locale, TimeZone zone) {
        Calendar cal = this.createCalendar(locale, zone);
        cal.setTime(date);
        return new Time(cal.get(11), cal.get(12), cal.get(13));
    }

    private int findGroupIndex(ReportTable parent, ReportTable child, int index) {
        if (parent == child) {
            return index;
        }
        if (parent instanceof ReportTreeTable) {
            int result = 0;
            Vector<ReportTable> subTables = ((ReportTreeTable)parent).getSubTable();
            for (int i = 0; i < subTables.size(); ++i) {
                result = this.findGroupIndex(subTables.elementAt(i), child, i);
                if (result < 0) continue;
                return result;
            }
        }
        return -1;
    }

    private int findIndex(ReportTable parent, ReportTable child, int index) {
        this.found = false;
        if (parent instanceof ReportTreeTable) {
            int sum = 0;
            Vector<ReportTable> subTables = ((ReportTreeTable)parent).getSubTable();
            LOGGER.finest("ReportTreeTable size: " + subTables.size());
            for (int i = 0; i < subTables.size() && !this.found; ++i) {
                sum += this.findIndex(subTables.elementAt(i), child, index);
            }
            return sum;
        }
        if (parent == child) {
            this.found = true;
            return index;
        }
        this.found = true;
        try {
            for (int i = 0; i < parent.getColumnCount(); ++i) {
                if (parent.getColumn(i).getData(0) == null) {
                    if (child.getColumn(i).getData(0) == null) continue;
                    this.found = false;
                    continue;
                }
                if (parent.getColumn(i).getData(0).equals(child.getColumn(i).getData(0))) continue;
                this.found = false;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to check for duplicite columns", ex);
        }
        if (this.found) {
            return index;
        }
        return parent.getColumn(0).getDataCount();
    }

    private int findTotalIndex(ReportTable table) {
        if (table instanceof ReportTreeTable) {
            int sum = 0;
            Vector<ReportTable> subTables = ((ReportTreeTable)table).getSubTable();
            for (int i = 0; i < subTables.size(); ++i) {
                sum += this.findTotalIndex(subTables.elementAt(i));
            }
            return sum;
        }
        return table.getColumn(0).getDataCount();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean compare(short sign) throws Exception {
        Operand operand = (Operand)this.args.elementAt(0);
        operand.getValue(this.table, this.index, this.page, this.section, this.totalpages, this.totalsections, this.report, this.cell, this.dataobj, this.secondRound, this.preAggCol, this.resultCol, this.colData);
        int type = operand.getDatatype(this.report);
        if (type == 0) {
            double a = this.getdouble(this.args.elementAt(0));
            double b = this.getdouble(this.args.elementAt(1));
            switch (sign) {
                case 0: {
                    double c = this.getdouble(this.args.elementAt(2));
                    if (!(c >= a)) return false;
                    if (!(c <= b)) return false;
                    return true;
                }
                case 1: {
                    if (!(a >= b)) return false;
                    return true;
                }
                case 2: {
                    if (!(a <= b)) return false;
                    return true;
                }
                case 3: {
                    if (a != b) return false;
                    return true;
                }
                case 4: {
                    if (!(a > b)) return false;
                    return true;
                }
                case 5: {
                    if (!(a < b)) return false;
                    return true;
                }
            }
            return false;
        }
        if (type == 1) {
            String s1 = this.getString(this.args.elementAt(0));
            String s2 = this.getString(this.args.elementAt(1));
            if (s1 == null && s2 == null) {
                return true;
            }
            if (s1 == null) return false;
            if (s2 == null) {
                return false;
            }
            switch (sign) {
                case 0: {
                    String s3 = this.getString(this.args.elementAt(2));
                    if (s3.compareTo(s1) < 0) return false;
                    if (s3.compareTo(s2) > 0) return false;
                    return true;
                }
                case 1: {
                    if (s1.compareTo(s2) < 0) return false;
                    return true;
                }
                case 2: {
                    if (s1.compareTo(s2) > 0) return false;
                    return true;
                }
                case 3: {
                    return s1.equals(s2);
                }
                case 4: {
                    if (s1.compareTo(s2) <= 0) return false;
                    return true;
                }
                case 5: {
                    if (s1.compareTo(s2) >= 0) return false;
                    return true;
                }
            }
            return false;
        }
        if (type != 3 && type != 4 && type != 5) {
            if (type != 2) return false;
            throw new Exception("Cannot compare boolean objects");
        }
        java.util.Date d1 = this.getDate(this.args.elementAt(0));
        java.util.Date d2 = this.getDate(this.args.elementAt(1));
        if (d1 != null && d2 != null) {
            switch (sign) {
                case 0: {
                    java.util.Date d3 = this.getDate(this.args.elementAt(2));
                    if (d3.before(d1)) return false;
                    if (d3.after(d2)) return false;
                    return true;
                }
                case 1: {
                    if (d1.after(d2)) return true;
                    if (d1.equals(d2)) return true;
                    return false;
                }
                case 2: {
                    if (d1.before(d2)) return true;
                    if (d1.equals(d2)) return true;
                    return false;
                }
                case 3: {
                    return d1.equals(d2);
                }
                case 4: {
                    return d1.after(d2);
                }
                case 5: {
                    return d1.before(d2);
                }
            }
            return false;
        }
        if (d1 != null) return false;
        if (d2 != null) return false;
        return true;
    }

    public String toString() {
        String s = this.functionName + "(";
        if (this.args == null) {
            return s + ")";
        }
        for (int i = 0; i < this.args.size() - 1; ++i) {
            s = s + ((Operand)this.args.elementAt(i)).toString() + ",";
        }
        return s + ((Operand)this.args.elementAt(this.args.size() - 1)).toString() + ")";
    }

    @Override
    public void setDatatype(int datatype) {
        if (this.args == null) {
            return;
        }
        for (int i = 0; i < this.args.size(); ++i) {
            if (!(this.args.elementAt(i) instanceof ScriptReportElement)) continue;
            ((ScriptReportElement)this.args.elementAt(i)).setThisDataType(datatype);
        }
    }

    @Override
    public void setThisDataType(int datatype) {
        if (this.args == null) {
            return;
        }
        for (int i = 0; i < this.args.size(); ++i) {
            ((Operand)this.args.elementAt(i)).setThisDataType(datatype);
        }
    }

    public short getAggregation() {
        if (this.functionName.equalsIgnoreCase("average") || this.functionName.equalsIgnoreCase("AVG")) {
            return 5;
        }
        if (this.functionName.equalsIgnoreCase("count")) {
            return 4;
        }
        if (this.functionName.equalsIgnoreCase("countdistinct")) {
            return 11;
        }
        if (this.functionName.equalsIgnoreCase("max")) {
            return 2;
        }
        if (this.functionName.equalsIgnoreCase("min")) {
            return 3;
        }
        if (this.functionName.equalsIgnoreCase("stddev")) {
            return 10;
        }
        if (this.functionName.equalsIgnoreCase("sum")) {
            return 1;
        }
        if (this.functionName.equalsIgnoreCase("sumsquare")) {
            return 8;
        }
        if (this.functionName.equalsIgnoreCase("variance")) {
            return 9;
        }
        if (this.functionName.equalsIgnoreCase("first")) {
            return 6;
        }
        if (this.functionName.equalsIgnoreCase("last")) {
            return 7;
        }
        if (this.functionName.equalsIgnoreCase("none")) {
            return 0;
        }
        return -1;
    }

    private Object getComputedValue(short agg, int col) {
        if (this.preAggCol != null) {
            for (int i = 0; i < this.preAggCol.size(); ++i) {
                int[] tmp = (int[])this.preAggCol.elementAt(i);
                if (tmp[0] != col || (short)tmp[1] != agg) continue;
                switch (agg) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        return this.resultCol.elementAt(i);
                    }
                    case 5: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        Vector tmpV = (Vector)this.resultCol.elementAt(i);
                        return Aggregation.getComputedValue(agg, QbUtil.toArray(tmpV));
                    }
                }
            }
        }
        return null;
    }
}

