/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.awt.Font;
import java.lang.reflect.Array;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.report.DataFormat;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.util.BarcodeFormat;
import quadbase.reportdesigner.util.DateTimeFormat;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.ImageURLFormat;
import quadbase.reportdesigner.util.LocaleDateTimeFormat;
import quadbase.reportdesigner.util.LocaleNumericFormat;
import quadbase.reportdesigner.util.LogicalFormat;
import quadbase.reportdesigner.util.NumericFormat;
import quadbase.reportdesigner.util.StringFormat;
import quadbase.reportdesigner.util.TextURLFormat;

public class GlobalFormat {
    private static final Logger LOGGER = Logger.getLogger(GlobalFormat.class.getName());
    public static final int DUAL_COLOR_CHANGE_ON_NOTHING = 0;
    public static final int DUAL_COLOR_CHANGE_ON_ROW_INDEX = 1;
    public static final int DUAL_COLOR_CHANGE_ON_GROUP = 2;
    public static final int DUAL_COLOR_CHANGE_ON_COLUMN = 3;
    Vector<ReportTableElement> sections = null;
    Report report;

    public GlobalFormat(Report report) {
        this.report = report;
    }

    public Vector<ReportTableElement> getSections() {
        if (this.sections != null) {
            return this.sections;
        }
        Vector<ReportTableElement> vec = new Vector<ReportTableElement>();
        vec = this.addSection(vec, this.report.getReportHeader());
        vec = this.addSection(vec, this.report.getPageHeader());
        vec = this.addSection(vec, this.report.getReportFooter());
        vec = this.addSection(vec, this.report.getPageFooter());
        ReportTable table = this.report.getReportTables().elementAt(0);
        this.sections = this.addTable(vec, table);
        return this.sections;
    }

    private Vector<ReportTableElement> addSection(Vector<ReportTableElement> vec, ReportSection section) {
        vec.addElement(section);
        for (int i = 0; i < section.getSectionCount(); ++i) {
            try {
                vec.addElement(section.getSection(i));
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Can't add section", ex);
            }
        }
        return vec;
    }

    private Vector<ReportTableElement> addTable(Vector<ReportTableElement> vec, ReportTable table) {
        vec = this.addSection(vec, table.getHeader());
        vec = this.addSection(vec, table.getFooter());
        if (table instanceof ReportMultiSectionTable) {
            ReportMultiSectionTable mTbl = (ReportMultiSectionTable)table;
            for (int i = 0; i < mTbl.countRowBreakHeader(); ++i) {
                vec = this.addSection(vec, mTbl.getRowBreakHeader(i));
                vec = this.addSection(vec, mTbl.getRowBreakFooter(i));
            }
            vec.addElement(mTbl);
        } else {
            vec.addElement(table);
        }
        return vec;
    }

    public void setLabelAttr(Font font, boolean isUnderline, short hAlign, short vAlign, Color fontColor, Color bgColor, int borderThickness, Color borderColor) {
        Vector<ReportTableElement> vec = this.getSections();
        int size = vec.size();
        for (int i = 0; i < size; ++i) {
            ReportElement relt = vec.elementAt(i);
            if (!(relt instanceof ReportSection)) continue;
            ReportElement[] rc = ((ReportSection)relt).getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Label");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                GlobalFormat.setAttributes(t, font, isUnderline, hAlign, vAlign, fontColor, bgColor, borderThickness, borderColor);
            }
        }
        GlobalFormat.setAttributes(this.report.labelSetting, font, isUnderline, hAlign, vAlign, fontColor, bgColor, borderThickness, borderColor);
    }

    public void setColumnHeaderAttr(Font font, boolean isUnderline, short hAlign, short vAlign, Color fontColor, Color bgColor, int borderThickness, Color borderColor) {
        ReportTable table = this.report.getReportTables().elementAt(0);
        ReportSection section = table.getHeader();
        ReportElement[] rc = section.getData();
        Vector<Object> temp = new Vector();
        temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
        for (int j = 0; j < temp.size(); ++j) {
            ReportElement t = (ReportElement)temp.elementAt(j);
            GlobalFormat.setAttributes(t, font, isUnderline, hAlign, vAlign, fontColor, bgColor, borderThickness, borderColor);
        }
        if (this.report.getReportType() == 3 || this.report.getReportType() == 1) {
            ReportElement t;
            Vector<ReportTable> subTables = ((ReportTreeTable)table).getSubTable();
            if (subTables.size() > 0) {
                section = ((ReportTreeTable)table).getSubTable(0).getHeader();
                rc = section.getData();
                temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
                for (int j = 0; j < temp.size(); ++j) {
                    t = (ReportElement)temp.elementAt(j);
                    GlobalFormat.setAttributes(t, font, isUnderline, hAlign, vAlign, fontColor, bgColor, borderThickness, borderColor);
                }
            }
            if ((section = table.getMasterSection()) != null) {
                rc = section.getData();
                temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "ColumnHeader");
                for (int j = 0; j < temp.size(); ++j) {
                    t = (ReportElement)temp.elementAt(j);
                    GlobalFormat.setAttributes(t, font, isUnderline, hAlign, vAlign, fontColor, bgColor, borderThickness, borderColor);
                }
            }
        }
        GlobalFormat.setAttributes(this.report.columnHeaderSetting, font, isUnderline, hAlign, vAlign, fontColor, bgColor, borderThickness, borderColor);
    }

    public void setFormulaAttr(Font font, boolean isUnderline, short hAlign, short vAlign, Color fontColor, Color bgColor, DataFormat dataFormat, int borderThickness, Color borderColor) {
        Vector<ReportTableElement> vec = this.getSections();
        int size = vec.size();
        for (int i = 0; i < size; ++i) {
            ReportSection rs;
            ReportElement relt = vec.elementAt(i);
            if (relt instanceof ReportSection) {
                ReportElement[] rc = ((ReportSection)relt).getData();
                Vector<Object> temp = new Vector();
                temp = ReportElement.findSpecificElements(rc, "Formula");
                for (int j = 0; j < temp.size(); ++j) {
                    ReportElement t = (ReportElement)temp.elementAt(j);
                    GlobalFormat.setAttributes(t, font, isUnderline, hAlign, vAlign, fontColor, bgColor, borderThickness, borderColor);
                    if (!(t instanceof ReportCell)) continue;
                    GlobalFormat.formatData((ReportCell)t, dataFormat);
                }
                continue;
            }
            if (!(relt instanceof ReportTable) || (rs = ((ReportTable)relt).getMasterSection()) == null) continue;
            ReportElement[] rc = rs.getData();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Formula");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                GlobalFormat.setAttributes(t, font, isUnderline, hAlign, vAlign, fontColor, bgColor, borderThickness, borderColor);
                if (!(t instanceof ReportCell)) continue;
                GlobalFormat.formatData((ReportCell)t, dataFormat);
            }
        }
        ReportCell[] formula = this.report.formula;
        for (int j = 0; j < Array.getLength(this.report.formula); ++j) {
            GlobalFormat.setAttributes(formula[j], font, isUnderline, hAlign, vAlign, fontColor, bgColor, borderThickness, borderColor);
            GlobalFormat.formatData(formula[j], dataFormat);
        }
    }

    public void setColumnAttr(Font font, boolean isUnderline, short hAlign, short vAlign, Color fontColor, Color bgColor, DataFormat dataFormat, int borderThickness, Color borderColor) {
        Vector<ReportTableElement> vec = this.getSections();
        int size = vec.size();
        for (int i = 0; i < size; ++i) {
            ReportElement elt = vec.elementAt(i);
            if (elt == null || elt instanceof ReportSection) continue;
            ReportTable relt = (ReportTable)elt;
            ReportElement[] rc = relt.getColumn();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Column");
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement t = (ReportElement)temp.elementAt(j);
                GlobalFormat.setAttributes(t, font, isUnderline, hAlign, vAlign, fontColor, bgColor, borderThickness, borderColor);
                if (!(t instanceof ReportColumn)) continue;
                GlobalFormat.formatData((ReportColumn)t, dataFormat);
            }
        }
        ReportColumn[] column = this.report.column;
        for (int j = 0; j < Array.getLength(this.report.column); ++j) {
            GlobalFormat.setAttributes(column[j], font, isUnderline, hAlign, vAlign, fontColor, bgColor, borderThickness, borderColor);
            GlobalFormat.formatData(column[j], dataFormat);
        }
    }

    public void setColumnDualColors(Font font, Color fontColor, Color bgColor, int changeOn, int rowIndex, int[] colInfoIndex) {
        Vector<ReportTableElement> vec = this.getSections();
        int size = vec.size();
        for (int i = 0; i < size; ++i) {
            ReportElement elt = vec.elementAt(i);
            if (elt instanceof ReportSection) continue;
            ReportTable relt = (ReportTable)elt;
            ReportElement[] rc = relt.getColumn();
            Vector<Object> temp = new Vector();
            temp = ReportElement.findSpecificElements(rc, "Column");
            block11: for (int j = 0; j < temp.size(); ++j) {
                Object tempObj = temp.elementAt(j);
                if (!(tempObj instanceof ReportColumn)) continue;
                ReportColumn t = (ReportColumn)tempObj;
                switch (changeOn) {
                    case 1: {
                        t.setAlternateRow(rowIndex);
                        t.setDualColorOnRowBreak(false);
                        t.setDualColorColInfoIndex(null);
                        break;
                    }
                    case 3: {
                        t.setAlternateRow(0);
                        t.setDualColorColInfoIndex(colInfoIndex);
                        t.setDualColorOnRowBreak(false);
                        break;
                    }
                    case 2: {
                        t.setDualColorOnRowBreak(true);
                        t.setAlternateRow(0);
                        t.setDualColorColInfoIndex(null);
                        break;
                    }
                    default: {
                        t.setAlternateRow(0);
                        t.setDualColorOnRowBreak(false);
                        t.setDualColorColInfoIndex(null);
                        continue block11;
                    }
                }
                t.setFont2(font);
                t.setFontColor2(fontColor);
                t.setBgColor2(bgColor);
            }
        }
        ReportColumn[] column = this.report.column;
        block12: for (int j = 0; j < Array.getLength(this.report.column); ++j) {
            switch (changeOn) {
                case 1: {
                    column[j].setAlternateRow(rowIndex);
                    column[j].setDualColorColInfoIndex(null);
                    column[j].setDualColorOnRowBreak(false);
                    break;
                }
                case 3: {
                    column[j].setDualColorColInfoIndex(colInfoIndex);
                    column[j].setAlternateRow(0);
                    column[j].setDualColorOnRowBreak(false);
                    break;
                }
                case 2: {
                    column[j].setDualColorOnRowBreak(true);
                    column[j].setAlternateRow(0);
                    column[j].setDualColorColInfoIndex(null);
                    break;
                }
                default: {
                    column[j].setAlternateRow(0);
                    column[j].setDualColorOnRowBreak(false);
                    column[j].setDualColorColInfoIndex(null);
                    continue block12;
                }
            }
            column[j].setFont2(font);
            column[j].setFontColor2(fontColor);
            column[j].setBgColor2(bgColor);
        }
    }

    private static void formatData(ReportCell formula, DataFormat df) {
        if (df == null) {
            return;
        }
        IFormat format = formula.getDataFormat();
        if (GlobalFormat.isNumericData(format)) {
            if (df.numericFormat != null) {
                formula.setDataFormat(df.numericFormat);
            }
        } else if (GlobalFormat.isStringData(format)) {
            if (df.stringFormat != null) {
                formula.setDataFormat(df.stringFormat);
            }
        } else if (GlobalFormat.isLogicData(format)) {
            if (df.logicFormat != null) {
                formula.setDataFormat(df.logicFormat);
            }
        } else if (GlobalFormat.isDateTimeData(format)) {
            formula.setDataFormat(GlobalFormat.pickDateFormat(format, df));
        }
    }

    private static void formatData(ReportColumn rc, DataFormat df) {
        if (df == null) {
            return;
        }
        IFormat format = rc.getDataFormat();
        if (GlobalFormat.isNumericData(format)) {
            if (df.numericFormat != null) {
                rc.setDataFormat(df.numericFormat);
            }
        } else if (GlobalFormat.isStringData(format)) {
            if (df.stringFormat != null) {
                rc.setDataFormat(df.stringFormat);
            }
        } else if (GlobalFormat.isLogicData(format)) {
            if (df.logicFormat != null) {
                rc.setDataFormat(df.logicFormat);
            }
        } else if (GlobalFormat.isDateTimeData(format)) {
            rc.setDataFormat(GlobalFormat.pickDateFormat(format, df));
        }
    }

    private static IFormat pickDateFormat(IFormat match, DataFormat df) {
        if (!GlobalFormat.isDateTimeData(match)) {
            return match;
        }
        if (df.standardDateTimeFormat == null) {
            int instanceType = ((LocaleDateTimeFormat)match).getInstanceType();
            if (instanceType == LocaleDateTimeFormat.DATE && df.localeDateFormat != null) {
                return df.localeDateFormat;
            }
            if (instanceType == LocaleDateTimeFormat.TIME && df.localeTimeFormat != null) {
                return df.localeTimeFormat;
            }
            if (df.localeDateTimeFormat != null) {
                return df.localeDateTimeFormat;
            }
        } else {
            return df.standardDateTimeFormat;
        }
        return match;
    }

    private static boolean isNumericData(IFormat format) {
        if (format instanceof LocaleNumericFormat || format instanceof NumericFormat) {
            return true;
        }
        if (format instanceof BarcodeFormat) {
            BarcodeFormat bf = (BarcodeFormat)format;
            int barcode = bf.getformat();
            return barcode == 6 || barcode == 11 || barcode == 10;
        }
        return false;
    }

    private static boolean isStringData(IFormat format) {
        if (format instanceof StringFormat || format instanceof ImageURLFormat || format instanceof TextURLFormat) {
            return true;
        }
        if (format instanceof BarcodeFormat) {
            BarcodeFormat bf = (BarcodeFormat)format;
            int barcode = bf.getformat();
            return barcode == 0 || barcode == 4 || barcode == 2;
        }
        return false;
    }

    private static boolean isLogicData(IFormat format) {
        return format instanceof LogicalFormat;
    }

    private static boolean isDateTimeData(IFormat format) {
        return format instanceof LocaleDateTimeFormat || format instanceof DateTimeFormat;
    }

    public static void setAttributes(ReportElement re, Font font, boolean isUnderline, short hAlign, short vAlign, Color fontColor, Color bgColor, int borderThickness, Color borderColor) {
        re.setFont(font);
        re.setUnderline(isUnderline);
        re.setAlign(hAlign);
        re.setVAlign(vAlign);
        re.setFontColor(fontColor);
        re.setBgColor(bgColor);
        re.setBorderThickness(borderThickness);
        re.setBorderColor(borderColor);
    }
}

