/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.util.SimpleSpreadSheet;
import quadbase.reportdesigner.util.StreamResultSet;

public final class IOUtil2 {
    private static final Logger LOGGER = Logger.getLogger(IOUtil2.class.getName());

    public static final String getErrorString(int code) {
        String scode;
        if (code == 0) {
            return null;
        }
        switch (code) {
            case 5: {
                scode = "Access Denied.";
                break;
            }
            case 2: {
                scode = "Server out of memory.\n Please try again later.";
                break;
            }
            case 1: 
            case 3: {
                scode = "";
                break;
            }
            case 4: {
                scode = "Too many users logged onto the server. \n Please try again later.";
                break;
            }
            default: {
                scode = LanguageEncoder.getText("Unknown error code") + " " + code + "!";
            }
        }
        return scode;
    }

    public static ColData[] getColData(String s) throws Exception {
        String s2 = "";
        boolean outside = true;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                outside = !outside;
            } else if (c == '|' && outside) {
                c = '\n';
            }
            s2 = s2 + c;
        }
        StreamTokenizer st = new StreamTokenizer(new StringReader(s2));
        return IOUtil2.readRecord(st);
    }

    public static ColData[] readRecord(StreamTokenizer st) throws Exception {
        st.eolIsSignificant(true);
        Vector vec1 = new Vector();
        do {
            if (StreamResultSet.readLine(st, vec1, true) != 0) continue;
            throw new IOException("Premature EOF encountered when reading column types!");
        } while (vec1.size() == 0);
        if (IOUtil2.isTypeHeader(vec1)) {
            return IOUtil2.readColumnFormat(st, vec1);
        }
        return IOUtil2.readSpreadSheetFormat(st, vec1);
    }

    private static boolean isTypeHeader(Vector vec1) {
        int nCol = vec1.size();
        for (int i = 0; i < nCol; ++i) {
            Object current = vec1.elementAt(i);
            if (current instanceof Number) {
                return false;
            }
            try {
                DataType.findType((String)current);
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Invalid data type name", ex);
                return false;
            }
        }
        return true;
    }

    private static ColData[] readColumnFormat(StreamTokenizer st, Vector vec1) throws Exception {
        int i;
        Vector vec2 = new Vector();
        do {
            if (StreamResultSet.readLine(st, vec2, false) != 0) continue;
            throw new IOException("Premature EOF encountered when reading column names!");
        } while (vec2.size() == 0);
        int nCol = vec1.size();
        if (vec2.size() != nCol) {
            throw new IOException("The number of column names must be = " + nCol);
        }
        ColData[] colData = new ColData[nCol + 1];
        for (i = 0; i < nCol; ++i) {
            colData[i] = new ColData((String)vec2.elementAt(i), DataType.findType((String)vec1.elementAt(i)), colData.length);
        }
        while (!ServerMessage.exceedLimit(colData[0].getSize()) && StreamResultSet.readLine(st, vec1, true) == 1) {
            if (vec1.size() == 0) continue;
            if (vec1.size() != nCol) {
                throw new IOException("Insufficient fields for record on line " + st.lineno());
            }
            for (i = 0; i < nCol; ++i) {
                colData[i].add(StreamResultSet.createObject(colData[i].getDataType(), vec1.elementAt(i), st));
            }
        }
        colData[nCol] = new ColData("qbCount", 4, colData.length);
        for (i = 0; i < colData[0].getSize(); ++i) {
            colData[nCol].add(i);
        }
        return colData;
    }

    private static ColData[] readSpreadSheetFormat(StreamTokenizer st, Vector vec1) throws Exception {
        int i;
        int currentType;
        Vector<Object> columnHeaderObject = new Vector<Object>();
        Object temp = DataType.makeDefaultObject(vec1.elementAt(0));
        int columnHeaderType = DataType.findType(temp);
        columnHeaderObject.addElement(temp);
        int nCol = vec1.size();
        for (int i2 = 1; i2 < nCol; ++i2) {
            temp = DataType.makeDefaultObject(vec1.elementAt(i2));
            currentType = DataType.findType(temp);
            if (currentType != columnHeaderType) {
                throw new IllegalArgumentException("All values on the column header must use the same data type.\nThe first column header type detected is " + DataType.getTypeName(columnHeaderType) + ", but the type of " + temp + " is " + DataType.getTypeName(currentType) + ".");
            }
            columnHeaderObject.addElement(temp);
        }
        Vector[] arrayBuffer = new Vector[nCol];
        for (int i3 = 0; i3 < nCol; ++i3) {
            arrayBuffer[i3] = new Vector();
        }
        Vector<Object> rowHeaderObject = new Vector<Object>();
        int rowHeaderType = 14;
        Vector rowBuffer = new Vector();
        while (StreamResultSet.readLine(st, rowBuffer, true) == 1) {
            if (rowBuffer.size() == 0) continue;
            if (rowBuffer.size() != nCol + 1) {
                throw new IOException("Insufficient fields for record on line " + st.lineno());
            }
            temp = DataType.makeDefaultObject(rowBuffer.elementAt(0));
            if (rowHeaderType == 14) {
                rowHeaderType = DataType.findType(temp);
            } else {
                currentType = DataType.findType(temp);
                if (currentType != rowHeaderType) {
                    throw new IllegalArgumentException("All values on the row header must have the same data type.\nThe first row header type detected is " + DataType.getTypeName(rowHeaderType) + ", but the type of " + temp + " is " + DataType.getTypeName(currentType) + ".");
                }
            }
            rowHeaderObject.addElement(temp);
            for (i = 1; i <= nCol; ++i) {
                temp = DataType.makeDefaultObject(rowBuffer.elementAt(i));
                int arrayDataType = DataType.mapType(DataType.findType(temp));
                if (!DataType.isNumeric(arrayDataType) || arrayDataType == 0) {
                    throw new IllegalArgumentException("All values in the array must be numeric");
                }
                arrayBuffer[i - 1].addElement(temp);
            }
        }
        Object[] columnHeaderArray = new Object[nCol];
        for (i = 0; i < nCol; ++i) {
            columnHeaderArray[i] = columnHeaderObject.elementAt(i);
        }
        int nRow = rowHeaderObject.size();
        Object[] rowHeaderArray = new Object[nRow];
        for (int i4 = 0; i4 < nRow; ++i4) {
            rowHeaderArray[i4] = rowHeaderObject.elementAt(i4);
        }
        Object[][] valueArray = new Object[nRow][nCol];
        for (int i5 = 0; i5 < nRow; ++i5) {
            for (int j = 0; j < nCol; ++j) {
                temp = arrayBuffer[j].elementAt(i5);
                valueArray[i5][j] = temp instanceof Double ? temp : Double.valueOf(((Number)temp).doubleValue());
            }
        }
        SimpleSpreadSheet sss = new SimpleSpreadSheet(rowHeaderArray, columnHeaderArray, valueArray);
        return ColData.getColData(sss);
    }

    public static final double getValue(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof Boolean) {
            if (((Boolean)obj).booleanValue()) {
                return 1.0;
            }
            return 0.0;
        }
        if (obj instanceof String) {
            try {
                return NumberFormat.getInstance(Locale.US).parse((String)obj).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return 0.0;
    }
}

