/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.report.ERStatement;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.Script;

public class IfStatement
implements ERStatement {
    private static final Logger LOGGER = Logger.getLogger(IfStatement.class.getName());
    Operand condition;
    Vector thenStmts;
    Vector elseStmts;

    public IfStatement(Operand cnd, Vector thenStmts) {
        this.condition = cnd;
        this.thenStmts = thenStmts;
    }

    public IfStatement(Operand cnd, Vector thenStmts, Vector elseStmts) {
        this.condition = cnd;
        this.thenStmts = thenStmts;
        this.elseStmts = elseStmts;
    }

    public Operand getCondition() {
        return this.condition;
    }

    public void setCondition(Operand cnd) {
        this.condition = cnd;
    }

    public Vector getThenStmts() {
        return this.thenStmts;
    }

    public void setThenStmts(Vector thenStmts) {
        this.thenStmts = thenStmts;
    }

    public Vector getElseStmts() {
        return this.elseStmts;
    }

    public void setElseStmts(Vector elseStmts) {
        this.elseStmts = elseStmts;
    }

    @Override
    public void execute(Script script) throws Exception {
        block4: {
            block3: {
                Object object = this.condition.getValue(script.table, script.index, script.page, script.section, script.totalPages, script.totalSections, script.report, script.cell, script.dataobj, true);
                if (this.condition.getDatatype(script.report) != 2) {
                    throw new Exception(LanguageEncoder.getText("if condition has to have a boolean value"));
                }
                if (!((Boolean)object).booleanValue()) break block3;
                for (int i = 0; i < this.thenStmts.size(); ++i) {
                    ((ERStatement)this.thenStmts.elementAt(i)).execute(script);
                }
                break block4;
            }
            if (this.elseStmts == null) break block4;
            for (int i = 0; i < this.elseStmts.size(); ++i) {
                ((ERStatement)this.elseStmts.elementAt(i)).execute(script);
            }
        }
    }

    @Override
    public void testExecute(Script script) throws Exception {
        int i;
        Object object = this.condition.getValue(script.table, script.index, script.page, script.section, script.totalPages, script.totalSections, script.report, script.cell, script.dataobj, true);
        if (this.condition.getDatatype(script.report) != 2) {
            throw new Exception(LanguageEncoder.getText("if condition has to have a boolean value"));
        }
        if (this.thenStmts != null) {
            for (i = 0; i < this.thenStmts.size(); ++i) {
                try {
                    ((ERStatement)this.thenStmts.elementAt(i)).execute(script);
                    continue;
                }
                catch (NullPointerException ex) {
                    if (!((Boolean)object).booleanValue()) {
                        LOGGER.log(Level.FINEST, "Error executing script: object is not boolean, continue", ex);
                        continue;
                    }
                    LOGGER.log(Level.FINEST, "Error executing script", ex);
                    throw ex;
                }
            }
        }
        if (this.elseStmts != null) {
            for (i = 0; i < this.elseStmts.size(); ++i) {
                try {
                    ((ERStatement)this.elseStmts.elementAt(i)).execute(script);
                    continue;
                }
                catch (NullPointerException ex) {
                    if (((Boolean)object).booleanValue()) {
                        LOGGER.log(Level.FINEST, "Error executing script: boolean value, continue", ex);
                        continue;
                    }
                    LOGGER.log(Level.FINEST, "Error executing script", ex);
                    throw ex;
                }
            }
        }
    }

    @Override
    public void setThisDataType(int datatype) {
        int i;
        this.condition.setThisDataType(datatype);
        for (i = 0; this.thenStmts != null && i < this.thenStmts.size(); ++i) {
            ((ERStatement)this.thenStmts.elementAt(i)).setThisDataType(datatype);
        }
        for (i = 0; this.elseStmts != null && i < this.elseStmts.size(); ++i) {
            ((ERStatement)this.elseStmts.elementAt(i)).setThisDataType(datatype);
        }
    }
}

