/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.awt.Arc;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.report.Report;

public class ImageMapNode {
    private static final Logger LOGGER = Logger.getLogger(ImageMapNode.class.getName());
    private Object obj;
    private String link;
    private String target;
    private String hint = null;
    private byte[] bytearray;
    private Report ddReport;
    private int pageNumber = 1;
    private int section = 1;
    private double y;
    private String parentFile;
    private Object[] parameters = null;
    private boolean drillDownLink = false;
    private int drillDownNodeIndex = 0;
    private static int VERSION = 1;

    public ImageMapNode(Object obj, String link, String target) {
        this.obj = obj;
        this.link = link;
        this.target = target;
    }

    public ImageMapNode(Object obj, String link, String target, String hint) {
        this(obj, link, target);
        this.hint = hint == null || hint.equals("") ? link : hint;
    }

    public ImageMapNode(Object obj, Report report, byte[] bytearray, String link, String hint, Object[] params, int nodeIndex) {
        this.obj = obj;
        this.ddReport = report;
        this.bytearray = bytearray;
        this.link = link;
        this.parameters = params;
        this.target = "";
        this.drillDownNodeIndex = nodeIndex;
        this.drillDownLink = true;
        this.hint = hint == null || hint.equals("") ? link : hint;
    }

    public ImageMapNode(Object obj, Report report, byte[] bytearray, String link, String hint, Object[] params, int nodeIndex, String parentFile) {
        this.obj = obj;
        this.ddReport = report;
        this.bytearray = bytearray;
        this.link = link;
        this.parameters = params;
        this.target = "";
        this.drillDownNodeIndex = nodeIndex;
        this.drillDownLink = true;
        this.hint = hint == null || hint.equals("") ? link : hint;
        this.parentFile = parentFile;
    }

    public ImageMapNode(Object obj, int pageNumber, int section, double y) {
        this.obj = obj;
        this.pageNumber = pageNumber;
        this.section = section;
        this.y = y;
    }

    public Object getObject() {
        return this.obj;
    }

    public String getLink() {
        return this.link;
    }

    public String getTarget() {
        return this.target;
    }

    public String getHint() {
        return this.hint;
    }

    public byte[] getByteArray() {
        return this.bytearray;
    }

    public Report getDrillReport() {
        return this.ddReport;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getSection() {
        return this.section;
    }

    public double getY() {
        return this.y;
    }

    public boolean isBookmark() {
        return this.pageNumber > 1 || this.y > 0.0;
    }

    public boolean isDrillDownLink() {
        return this.drillDownLink;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public int getDrillDownNodeIndex() {
        return this.drillDownNodeIndex;
    }

    public String getParentFile() {
        return this.parentFile;
    }

    public void write(DataOutput out, boolean forPageViewer, Report report) throws IOException {
        out.writeInt(VERSION);
        if (this.obj instanceof Rectangle) {
            out.writeInt(1);
            Rectangle rec = (Rectangle)this.obj;
            out.writeInt((int)rec.getX());
            out.writeInt((int)rec.getY());
            out.writeInt((int)rec.getWidth());
            out.writeInt((int)rec.getHeight());
        } else if (this.obj instanceof Polygon) {
            out.writeInt(2);
            Polygon p = (Polygon)this.obj;
            this.writeArray(out, p.xpoints);
            this.writeArray(out, p.ypoints);
            out.writeInt(p.npoints);
        } else if (this.obj instanceof Arc) {
            Arc ar = (Arc)this.obj;
            out.writeInt(3);
            out.writeInt(ar.x);
            out.writeInt(ar.y);
            out.writeInt(ar.w);
            out.writeInt(ar.h);
            out.writeInt(ar.startangle);
            out.writeInt(ar.angle);
        } else {
            out.writeInt(0);
        }
        ImageMapNode.writeStr(out, this.link);
        ImageMapNode.writeStr(out, this.target);
        ImageMapNode.writeStr(out, this.hint);
        out.writeInt(this.pageNumber);
        out.writeInt(this.section);
        if (forPageViewer) {
            out.writeDouble(QbUtil.toPixel(this.y + report.getTopMargin()));
        } else {
            out.writeDouble(this.y);
        }
        if (this.parameters != null) {
            out.writeBoolean(true);
            out.writeInt(this.parameters.length);
            for (Object parameter : this.parameters) {
                ImageMapNode.writeStr(out, DataType.write(parameter));
            }
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.drillDownLink);
        out.writeInt(this.drillDownNodeIndex);
        ImageMapNode.writeStr(out, this.parentFile);
        if (this.bytearray != null) {
            out.writeInt(this.bytearray.length);
            out.write(this.bytearray);
        } else {
            out.writeInt(0);
        }
    }

    private static int[] readArray(DataInput in) throws IOException {
        int count = in.readInt();
        int[] tmp = new int[count];
        for (int i = 0; i < count; ++i) {
            tmp[i] = in.readInt();
        }
        return tmp;
    }

    public static ImageMapNode read(DataInput in) throws IOException {
        boolean hasParameter;
        int version = in.readInt();
        int type = in.readInt();
        Object obj = null;
        if (type == 1) {
            obj = new Rectangle(in.readInt(), in.readInt(), in.readInt(), in.readInt());
        } else if (type == 2) {
            int[] xpts = ImageMapNode.readArray(in);
            int[] ypts = ImageMapNode.readArray(in);
            int count = in.readInt();
            obj = new Polygon(xpts, ypts, count);
        } else if (type == 3) {
            obj = new Arc(in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt());
        }
        String link = ImageMapNode.readStr(in);
        String target = ImageMapNode.readStr(in);
        String hint = ImageMapNode.readStr(in);
        ImageMapNode node = new ImageMapNode(obj, link, target, hint);
        if (version >= 1) {
            node.pageNumber = in.readInt();
            node.section = in.readInt();
            node.y = in.readDouble();
        }
        if (hasParameter = in.readBoolean()) {
            node.parameters = new Object[in.readInt()];
            for (int i = 0; i < node.parameters.length; ++i) {
                node.parameters[i] = DataType.read(ImageMapNode.readStr(in));
            }
        } else {
            node.parameters = null;
        }
        node.drillDownLink = in.readBoolean();
        node.drillDownNodeIndex = in.readInt();
        node.parentFile = ImageMapNode.readStr(in);
        int count = in.readInt();
        if (count > 0) {
            node.bytearray = new byte[count];
            in.readFully(node.bytearray);
        }
        return node;
    }

    private static void writeStr(DataOutput out, String string) throws IOException {
        if (string == null) {
            out.writeBoolean(true);
        } else {
            out.writeBoolean(false);
            out.writeUTF(string);
        }
    }

    private static String readStr(DataInput in) throws IOException {
        if (in.readBoolean()) {
            return null;
        }
        return in.readUTF();
    }

    private void writeArray(DataOutput out, int[] array) {
        try {
            if (array == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(array.length);
            for (int element : array) {
                out.writeInt(element);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to write array", ex);
        }
    }
}

