/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.report.ReadDataFile;

public class ImportFontMappingHelper {
    private static final Logger LOGGER = Logger.getLogger(ImportFontMappingHelper.class.getName());

    public byte[] getInputStream(String path) throws IOException {
        if (path == null || path.trim().equals("")) {
            throw new IOException("No file name selected !");
        }
        try (InputStream istream = null;){
            istream = new ReadDataFile().getInputStream(null, path);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(istream);
            byte[] byArray = this.importXMLDocument(document);
            return byArray;
        }
    }

    private byte[] importXMLDocument(Document document) throws Exception {
        String key;
        Hashtable<String, String> fontMapping = new Hashtable<String, String>();
        if (document != null) {
            NodeList nlist = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < nlist.getLength(); ++i) {
                Node eltNode = nlist.item(i);
                if (eltNode == null || !eltNode.getNodeName().equalsIgnoreCase("PDFFONTMAPPING")) continue;
                NamedNodeMap attrmap = eltNode.getAttributes();
                key = null;
                String value = null;
                for (int j = 0; j < attrmap.getLength(); ++j) {
                    if (attrmap.item(j).getNodeName().equalsIgnoreCase("Key")) {
                        key = attrmap.item(j).getNodeValue();
                        continue;
                    }
                    if (!attrmap.item(j).getNodeName().equalsIgnoreCase("Value")) continue;
                    value = attrmap.item(j).getNodeValue();
                }
                if (key != null && value != null) {
                    fontMapping.put(key, value);
                    continue;
                }
                if (key == null) {
                    throw new Exception("Invalid 'PDFFONTMAPPING' element. Missing 'Key' attribute.");
                }
                throw new Exception("Invalid 'PDFFONTMAPPING' element. Missing 'Value' attribute.");
            }
        }
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        out.writeInt(7004);
        int fontMappingSize = fontMapping.size();
        out.writeInt(fontMappingSize);
        Enumeration e = fontMapping.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            IOUtil.writeString(out, Coder.encode(key));
            IOUtil.writeString(out, Coder.encode((String)fontMapping.get(key)));
        }
        out.flush();
        out.close();
        fstream.close();
        return fstream.toByteArray();
    }
}

