/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.param.OrderedParameterSet;
import quadbase.common.param.Param;
import quadbase.common.param.ParamUtil;
import quadbase.common.paramquery.EnterParamDialog;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.internal.ClassFileUtil;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.EJBUtil;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.VersioningDataInput;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTitle;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.CrossTabTable;
import quadbase.reportdesigner.report.DBAccess;
import quadbase.reportdesigner.report.DataFileInput;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.EJBAccess;
import quadbase.reportdesigner.report.ExcelAccess;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.LoadXMLReport;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.OLAPAccess;
import quadbase.reportdesigner.report.PaginationSettings;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.report.SOAPAccess;
import quadbase.reportdesigner.report.SalesForceAccess;
import quadbase.reportdesigner.report.SaveReport;
import quadbase.reportdesigner.report.Script;
import quadbase.reportdesigner.report.TokenMgrError;
import quadbase.reportdesigner.report.TransformQuery;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class LoadReport {
    private static final Logger LOGGER = Logger.getLogger(LoadReport.class.getName());
    DBInfoBasic dbInfo;
    protected String filename = null;
    int version;
    private Vector parameters;
    int sourceData;
    int originalSourceData = -1;
    String sourceFile;
    XMLFileQueryInfo xmlFileQueryInfo;
    String jndiName;
    String homeName;
    String remoteName;
    String selectedMethodName;
    Object[] selectedMethodParamVal;
    private Hashtable<String, String> environment;
    SOAPQueryFileInfo soapInfo;
    SalesForceQueryFileInfo sfQueryInfo;
    ExcelFileInfo excelInfo;
    String mondrianConnectionString;
    String MDXQuery;
    String xmlaURI;
    String xmlaDataSource;
    String xmlaCatalog;
    boolean[] rowBreakAggrIncluded;
    boolean[] colBreakAggrIncluded;
    boolean keepDataSourceOrder = false;
    private Hashtable<String, String> fontMapping = null;
    ColData[] originalColDataFromMemSource;
    ColData[] backupColData;
    Object[] sourceList;
    ColInfo[] colInfo;
    int[] sourceType;
    boolean[] doTranspose;
    Object[] transposeColList;
    boolean isTransposed = false;
    boolean[] transposeCol = null;
    String queryFilename;
    QueryFileInfo queryFileInfo;
    String[] modDataSourceArr;
    Boolean modTranspose;
    boolean[] modTransposeCol;
    boolean[] modTransposeArr;
    Object[] modTransposeColArr;
    boolean fromReportDesigner = false;
    boolean getSubReportParameter = false;
    boolean promptParamValue = false;
    public boolean useDefaults = false;
    boolean isPacked = false;
    public boolean saveAllData = false;
    protected DrillDownNode drillDownNode = null;
    protected DrillDownNode nodeForUnmappedDrillDown = null;
    protected Vector<SubReportObject> subReports = null;
    protected Vector<DrillDownNode> childDrillDownNodes = null;
    private boolean optimizeMemory = false;
    private boolean applyFormula = false;
    private boolean usingBackupData = false;
    private boolean reOrderColumns = true;
    private boolean showRowAggregationGrandTotal = true;
    private boolean crossTabFreeForm = true;
    private boolean showRowAggregationSubtotal = true;
    private boolean rowAggregationSubtotalOnLeft = false;
    private boolean rowAggregationGrandTotalOnLeft = false;
    private boolean columnAggregationInHeader = false;
    private boolean showColumnAggregation = true;
    private boolean alignCrossTabColBkValHori = true;
    boolean retrieveColInfoOnly = false;
    private String securityLevel = null;
    private QueryFileInfo tempDbInfo = null;
    private IQueryInParam[] securityParams = null;
    private boolean[] isParamMapped = null;
    private boolean copyEmptySection = true;
    private Hashtable<String, byte[]> drillDownReportTable = null;
    private String relativeDomainPath = "";
    public boolean readOnly = false;
    private boolean isDesignerDesignMode = false;
    private String errorMessage = null;
    private boolean showWarningDialog = true;
    private FileInMemTable subFilesTable = new FileInMemTable();
    private boolean loadNewOnly = false;

    public LoadReport() {
    }

    public LoadReport(boolean fromReportDesigner) {
        this(fromReportDesigner, false);
    }

    public LoadReport(boolean fromReportDesigner, boolean optimizeMemory) {
        this.fromReportDesigner = fromReportDesigner;
        this.optimizeMemory = ServerMessage.performOptimizeMemory(optimizeMemory);
    }

    public LoadReport(int version) {
        this.version = version;
    }

    public void setBackupDataUsed(boolean b) {
        this.usingBackupData = b;
        if (b) {
            this.promptParamValue = false;
        }
    }

    public void setPromptParamValue(boolean b) {
        this.promptParamValue = b;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setRowBreakAggrIncluded(boolean[] b) {
        this.rowBreakAggrIncluded = b;
    }

    public void setSecurityLevel(String level) {
        this.securityLevel = level;
    }

    public void setCopyEmptySection(boolean b) {
        this.copyEmptySection = b;
    }

    public void setDesignerDesignMode(boolean b) {
        this.isDesignerDesignMode = b;
    }

    public FileInMemTable getSubFilesTable() {
        return this.subFilesTable;
    }

    public void setSubFilesTable(FileInMemTable subFilesTable) {
        this.subFilesTable = subFilesTable;
    }

    public boolean isBackupDataUsed() {
        return this.usingBackupData;
    }

    public boolean isSecurityQueryReport() {
        return this.securityLevel != null && this.securityParams != null;
    }

    public boolean[] getSecurityQueryParamMap() {
        return this.isParamMapped;
    }

    public Report loadReportFromFile(String urlname) throws Exception {
        return this.loadReportFromFile(urlname, null);
    }

    public static ColInfo[] getColInfo(String urlname) throws Exception {
        if (urlname == null) {
            return null;
        }
        LoadReport loadRpt = new LoadReport();
        loadRpt.retrieveColInfoOnly = true;
        loadRpt.loadReportFromFile(urlname);
        return loadRpt.colInfo;
    }

    public static DBInfoBasic getDBInfoBasic(String urlname) throws Exception {
        if (urlname == null) {
            return null;
        }
        LoadReport loadRpt = new LoadReport();
        loadRpt.retrieveColInfoOnly = true;
        loadRpt.loadReportFromFile(urlname);
        return loadRpt.dbInfo;
    }

    public Report loadReportFromFile(String urlname, boolean defaults) throws Exception {
        this.useDefaults = defaults;
        return this.loadReportFromFile(urlname, null);
    }

    public Report loadReportFromFile(String urlname, Vector<QueryInParamSet> params) throws Exception {
        return this.loadReportFromFile(urlname, params, false);
    }

    public Report loadReportFromFile(String urlname, Vector<QueryInParamSet> params, boolean isEntpServer) throws Exception {
        return this.loadReportFromFile(urlname, params, isEntpServer, !this.fromReportDesigner);
    }

    public Report loadReportFromFile(String urlname, Vector<QueryInParamSet> params, boolean isEntpServer, boolean api) throws Exception {
        return this.loadReportFromFile(urlname, params, null, isEntpServer, api);
    }

    public Report loadReportFromFile(String urlname, Vector<QueryInParamSet> params, Vector formulaParams, boolean isEntpServer, boolean api) throws Exception {
        ReadDataFile readfile = new ReadDataFile();
        Report newreport = null;
        this.promptParamValue = api && !this.getSubReportParameter;
        this.filename = urlname;
        if (IOUtil.isXMLFormat(this.filename)) {
            LoadXMLReport xmlReport = new LoadXMLReport(this.fromReportDesigner);
            xmlReport.setDesignerDesignMode(this.isDesignerDesignMode);
            xmlReport.setCopyEmptySection(this.copyEmptySection);
            xmlReport.setBackupDataUsed(this.usingBackupData);
            xmlReport.useDefaults = this.useDefaults;
            xmlReport.retrieveColInfoOnly = this.retrieveColInfoOnly;
            xmlReport.setSecurityLevel(this.securityLevel);
            xmlReport.isEntServer = isEntpServer;
            newreport = xmlReport.loadReportFromFile(this.filename, params, formulaParams, isEntpServer, this.promptParamValue);
            if (this.retrieveColInfoOnly) {
                if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
                    this.colInfo = xmlReport.helper.colInfo;
                    this.dbInfo = xmlReport.helper.dbInfo;
                    this.queryFileInfo = xmlReport.helper.queryFileInfo;
                } else {
                    this.colInfo = xmlReport.colInfo;
                    this.dbInfo = xmlReport.dbInfo;
                    this.queryFileInfo = xmlReport.queryFileInfo;
                }
                return null;
            }
            this.subReports = xmlReport.getSubReports();
            this.drillDownNode = xmlReport.getDrillDownNode();
            this.childDrillDownNodes = xmlReport.getChildNodes();
            this.filename = xmlReport.getFullFilename();
            this.saveAllData = xmlReport.isSaveAllData();
            newreport.domainPath = this.relativeDomainPath;
            newreport.saveAllData = this.saveAllData;
            newreport.useBackupData = this.isBackupDataUsed();
            return newreport;
        }
        if (this.filename.endsWith(".pak")) {
            if (this.subFilesTable != null && this.subFilesTable.getTopName() == null) {
                this.subFilesTable.setTopName(this.filename);
            }
            if ((newreport = this.loadReport(readfile.getInputStream(this.subFilesTable, this.filename, this.readOnly), params, formulaParams, isEntpServer)) != null) {
                newreport.resetSourceData();
            }
            readfile.close();
            if (this.fromReportDesigner) {
                SaveReport saveReport = new SaveReport(newreport);
                saveReport.setSubFilesTable(this.subFilesTable);
                saveReport.setDrillDownNode(this.drillDownNode);
                saveReport.setSubReports(this.subReports);
                saveReport.generatePAKFile(true);
                this.filename = ServerMessage.getSaveFileLink(this.filename);
                saveReport.saveToOutput(this.filename, false, true);
                newreport = this.loadReport(readfile.getInputStream(this.subFilesTable, this.filename, this.readOnly), params, formulaParams, isEntpServer);
            }
        } else {
            newreport = this.loadReport(readfile.getInputStream(this.subFilesTable, this.filename, this.readOnly), params, formulaParams, isEntpServer);
            if (this.isPacked && this.fromReportDesigner) {
                String newName = this.filename;
                newName = newName.substring(newName.lastIndexOf(92) + 1);
                newName = newName.substring(newName.lastIndexOf(47) + 1);
                newName = newName.substring(0, newName.length() - 4);
                SaveReport saveReport = new SaveReport(newreport);
                saveReport.setDrillDownNode(this.drillDownNode);
                saveReport.setSubReports(this.subReports);
                saveReport.generatePAKFile(false);
                saveReport.setSubFilesTable(this.subFilesTable);
                saveReport.saveToFile(this.filename);
            }
        }
        readfile.close();
        if (!this.retrieveColInfoOnly && newreport != null) {
            newreport.domainPath = this.relativeDomainPath;
        }
        if (newreport != null) {
            newreport.useBackupData = this.isBackupDataUsed();
            newreport.mergeSubFilesTable(this.subFilesTable);
        }
        return newreport;
    }

    public Report loadReportFromByteArray(byte[] bytearray) throws Exception {
        ByteArrayInputStream bstream = new ByteArrayInputStream(bytearray);
        DataInputStream inputstream = new DataInputStream(bstream);
        Report newReport = this.loadReport(inputstream, null, null, false);
        newReport.useBackupData = this.isBackupDataUsed();
        return newReport;
    }

    public Report loadPakReportFromByteArray(String filename, byte[] bytearray) throws Exception {
        ByteArrayInputStream bstream = new ByteArrayInputStream(bytearray);
        DataInputStream inputstream = new DataInputStream(bstream);
        Report newReport = this.loadReport(inputstream, null, null, false);
        newReport.useBackupData = this.isBackupDataUsed();
        if (!this.subFilesTable.containsKey(filename)) {
            this.subFilesTable.put(filename, bytearray);
        }
        return newReport;
    }

    public Report loadTemplateFromFile(String templatename, Report report) throws Exception {
        return this.loadTemplateFromFile(templatename, false, report);
    }

    public Report loadTemplateFromFile(String templatename, boolean applyFormula, Report report) throws Exception {
        ReadDataFile readfile = new ReadDataFile();
        Report newreport = null;
        if (IOUtil.isXMLFormat(templatename = LoadReport.generateFullName(templatename))) {
            LoadXMLReport xmlReport = new LoadXMLReport();
            xmlReport.setCopyEmptySection(this.copyEmptySection);
            newreport = xmlReport.loadTemplateFromFile(templatename, applyFormula, report);
        } else {
            newreport = this.loadTemplate(report, readfile.getInputStream(this.subFilesTable, templatename, true), applyFormula);
            readfile.close();
        }
        readfile.close();
        newreport.useBackupData = this.isBackupDataUsed();
        return newreport;
    }

    public void loadDataHeaderOnly(String urlname) throws Exception {
        ReadDataFile readfile = new ReadDataFile();
        if (IOUtil.isXMLFormat(urlname = LoadReport.generateFullName(urlname))) {
            LoadXMLReport xmlReport = new LoadXMLReport(this.fromReportDesigner);
            xmlReport.setCopyEmptySection(this.copyEmptySection);
            xmlReport.isEntServer = true;
            xmlReport.loadReportFromFile(urlname);
            this.subReports = xmlReport.getSubReports();
            this.drillDownNode = xmlReport.getDrillDownNode();
            this.dbInfo = xmlReport.getDBInfo();
            this.version = xmlReport.version;
            this.setParameters(xmlReport.parameters);
            this.sourceData = xmlReport.getSourceDataType();
            this.sourceFile = xmlReport.sourceFile;
            this.xmlFileQueryInfo = xmlReport.xmlFileQueryInfo;
            this.sfQueryInfo = xmlReport.sfQueryInfo;
            this.soapInfo = xmlReport.soapInfo;
            this.excelInfo = xmlReport.excelInfo;
            this.jndiName = xmlReport.jndiName;
            this.homeName = xmlReport.homeName;
            this.remoteName = xmlReport.remoteName;
            this.selectedMethodName = xmlReport.selectedMethodName;
            this.selectedMethodParamVal = xmlReport.selectedMethodParamVal;
            this.setEnvironment(xmlReport.getEnvironment());
            this.mondrianConnectionString = xmlReport.mondrianConnectionString;
            this.MDXQuery = xmlReport.MDXQuery;
            this.xmlaURI = xmlReport.xmlaURI;
            this.xmlaDataSource = xmlReport.xmlaDataSource;
            this.xmlaCatalog = xmlReport.xmlaCatalog;
            this.setFontMapping(xmlReport.getFontMapping());
            this.originalColDataFromMemSource = xmlReport.originalColDataFromMemSource;
            this.sourceList = xmlReport.sourceList;
            this.sourceType = xmlReport.sourceType;
            this.queryFilename = xmlReport.queryFilename;
            this.queryFileInfo = xmlReport.queryFileInfo;
            this.modDataSourceArr = xmlReport.modDataSourceArr;
            readfile.close();
        } else {
            DataInputStream orgIn = readfile.getInputStream(this.subFilesTable, urlname, this.readOnly);
            this.version = orgIn.readInt();
            DataInput in = orgIn;
            if (this.version >= 288) {
                in = new VersioningDataInput(orgIn, 7004);
            }
            if (this.version >= 135) {
                String registryID = IOUtil.readString(in, true);
                String dataSourceID = IOUtil.readString(in, true);
                String string = IOUtil.readString(in, true);
            }
            if (this.version >= 132) {
                this.isPacked = in.readBoolean();
            }
            if (this.version >= 179) {
                this.saveAllData = in.readBoolean();
            }
            if (!this.isPacked) {
                if (this.version > 20) {
                    this.loadTree(in);
                } else {
                    this.drillDownNode = new DrillDownNode("ROOT");
                }
            } else {
                this.loadDrillDownTreeByteArrays(in);
            }
            if (!this.isPacked) {
                if (this.version > 21) {
                    this.loadSubReports(in);
                } else {
                    this.subReports = new Vector();
                }
            } else {
                this.loadSubReportsByteArrays(in);
            }
            this.loadDataHeader(in);
            readfile.close();
        }
    }

    public void loadDataHeaderOnly(DataInput orgIn) throws Exception {
        this.version = orgIn.readInt();
        DataInput in = orgIn;
        if (this.version >= 288 && !(orgIn instanceof VersioningDataInput)) {
            in = new VersioningDataInput(orgIn, 7004);
        }
        if (this.version >= 135) {
            String registryID = IOUtil.readString(in, true);
            String dataSourceID = IOUtil.readString(in, true);
            String string = IOUtil.readString(in, true);
        }
        if (this.version >= 132) {
            this.isPacked = in.readBoolean();
        }
        if (this.version >= 179) {
            this.saveAllData = in.readBoolean();
        }
        if (!this.isPacked) {
            if (this.version > 20) {
                this.loadTree(in);
            } else {
                this.drillDownNode = new DrillDownNode("ROOT");
            }
        } else {
            this.loadDrillDownTreeByteArrays(in);
        }
        if (!this.isPacked) {
            if (this.version > 21) {
                this.loadSubReports(in);
            } else {
                this.subReports = new Vector();
            }
        } else {
            this.loadSubReportsByteArrays(in);
        }
        this.loadDataHeader(in);
    }

    public Report loadTemplate(Report report, DataInputStream in) throws Exception {
        return this.loadData(in, report.colData, report, true, null, null, false);
    }

    public Report loadTemplate(Report report, DataInputStream in, boolean applyFormula) throws Exception {
        this.applyFormula = applyFormula;
        return this.loadData(in, report.colData, report, true, null, null, false);
    }

    public Report loadReport(DataInputStream in, Vector<QueryInParamSet> params) throws Exception {
        return this.loadReport(in, params, false);
    }

    public Report loadReport(DataInputStream in, Vector<QueryInParamSet> params, boolean isEntpServer) throws Exception {
        return this.loadReport(in, params, null, isEntpServer);
    }

    public Report loadReport(DataInputStream in, Vector<QueryInParamSet> params, Vector formulaParams, boolean isEntpServer) throws Exception {
        return this.loadData(in, null, null, false, params, formulaParams, isEntpServer);
    }

    private void loadDataHeader(DataInput in) throws IOException {
        this.sourceData = in.readInt();
        this.backupColData = null;
        if (this.version >= 43 && this.sourceData != 0) {
            this.backupColData = this.createColData(in, this.version);
        }
        if (this.sourceData == 1) {
            this.dbInfo = DBInfoBasic.read(in, this.version);
            if (this.modDataSourceArr != null) {
                this.dbInfo.setQuery(this.modDataSourceArr[0]);
            }
            if (in.readBoolean()) {
                this.queryFilename = Coder.decode(IOUtil.readString(in, true));
            } else if (this.version > 19) {
                int n = in.readInt();
                QueryInParam[] params = new QueryInParam[n];
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        params[i] = QueryInParam.read(in, 0);
                    }
                    QueryInParamSet inset = new QueryInParamSet(params);
                    if (this.version >= 251 && in.readBoolean()) {
                        int j;
                        int size = in.readInt();
                        String[][] s = new String[size][size];
                        for (int i = 0; i < size; ++i) {
                            int count = in.readInt();
                            for (j = 0; j < count; ++j) {
                                s[i][j] = IOUtil.readString(in, true);
                            }
                        }
                        QueryInParam[][] parameterInPromptSequence = new QueryInParam[size][size];
                        for (int i = 0; i < s.length; ++i) {
                            for (j = 0; j < s[i].length; ++j) {
                                if (s[i][j] == null) continue;
                                parameterInPromptSequence[i][j] = inset.getParameter(s[i][j]);
                            }
                        }
                        inset.setParameterInPromptSequence(parameterInPromptSequence);
                    }
                    this.dbInfo = new QueryFileInfo("", 0, this.dbInfo, inset);
                }
                this.queryFileInfo = null;
                this.queryFilename = null;
            }
            if (this.queryFilename != null && !this.queryFilename.equals("")) {
                this.queryFileInfo = QueryFileInfo.readFile(this.queryFilename);
                this.dbInfo = this.queryFileInfo;
            }
        } else if (this.sourceData == 2 || this.sourceData == 6 || this.sourceData == 4) {
            this.sourceFile = Coder.decode(IOUtil.readString(in, true));
            if (this.modDataSourceArr != null) {
                this.sourceFile = this.modDataSourceArr[0];
            }
            this.dbInfo = null;
            if (this.version >= 106) {
                boolean isParamClass = in.readBoolean();
                if (isParamClass) {
                    this.dbInfo = new QueryClassFileInfo(this.sourceFile);
                } else if (this.sourceData == 6 && ClassFileUtil.isParameterized(this.sourceFile)) {
                    QueryClassFileInfo infoTMP = new QueryClassFileInfo(this.sourceFile);
                    infoTMP.getInSet();
                    this.dbInfo = infoTMP;
                }
            }
        } else if (this.sourceData == 7) {
            boolean isParamQuery;
            boolean soap;
            if (this.version >= 276 && (soap = in.readBoolean())) {
                Coder.decode(IOUtil.readString(in, true));
                Coder.decode(IOUtil.readString(in, true));
                Coder.decode(IOUtil.readString(in, true));
                if (this.version >= 287 && this.version <= 300 || this.version >= 305) {
                    Coder.decode(IOUtil.readString(in, true));
                    boolean hasBytes = in.readBoolean();
                    if (hasBytes) {
                        int len = in.readInt();
                        byte[] soapTemplateBytes = new byte[len];
                        in.readFully(soapTemplateBytes);
                    }
                    int propCount = in.readInt();
                    for (int i = 0; i < propCount; ++i) {
                        Coder.decode(IOUtil.readString(in, true));
                        Coder.decode(IOUtil.readString(in, true));
                    }
                }
                this.sourceData = 9;
            }
            this.xmlFileQueryInfo = XMLFileQueryInfo.read(in);
            this.sourceFile = this.xmlFileQueryInfo.getFileName();
            if (this.version >= 202 && (isParamQuery = in.readBoolean())) {
                this.dbInfo = new QueryXMLFileInfo(this.xmlFileQueryInfo);
            }
        } else if (this.sourceData == 9) {
            Coder.decode(IOUtil.readString(in, true));
            Coder.decode(IOUtil.readString(in, true));
            Coder.decode(IOUtil.readString(in, true));
        } else if (this.sourceData == 12) {
            this.soapInfo = SOAPQueryFileInfo.readSOAPQueryFileInfo(new VersioningDataInput(in, 7004));
            if (this.soapInfo.isParameterized()) {
                this.dbInfo = this.soapInfo;
            }
        } else if (this.sourceData == 11) {
            this.sfQueryInfo = SalesForceQueryFileInfo.readSalesForceQueryInfo(in, this.version);
            if (this.sfQueryInfo.isParameterized()) {
                this.dbInfo = this.sfQueryInfo;
            }
        } else if (this.sourceData == 13) {
            this.excelInfo = ExcelFileInfo.read(in, this.version);
        } else if (this.sourceData == 10) {
            this.mondrianConnectionString = Coder.decode(IOUtil.readString(in, true));
            this.MDXQuery = Coder.decode(IOUtil.readString(in, true));
            this.xmlaURI = Coder.decode(IOUtil.readString(in, true));
            this.xmlaDataSource = Coder.decode(IOUtil.readString(in, true));
            this.xmlaCatalog = Coder.decode(IOUtil.readString(in, true));
        } else if (this.sourceData == 5) {
            int envsize;
            int ejbversion = in.readInt();
            this.jndiName = Coder.decode(IOUtil.readString(in, true));
            this.homeName = Coder.decode(IOUtil.readString(in, true));
            this.remoteName = Coder.decode(IOUtil.readString(in, true));
            this.selectedMethodName = Coder.decode(IOUtil.readString(in, true));
            int count = in.readInt();
            this.selectedMethodParamVal = new Object[count];
            for (int i = 0; i < count; ++i) {
                String paramType = Coder.decode(IOUtil.readString(in, true));
                this.selectedMethodParamVal[i] = EJBUtil.getRuntimeInputValue(paramType, Coder.decode(IOUtil.readString(in, true)));
            }
            if (ejbversion >= 2 && (envsize = in.readInt()) > 0) {
                if (this.getEnvironment() == null) {
                    this.setEnvironment(new Hashtable<String, String>());
                }
                for (int i = 0; i < envsize; ++i) {
                    String key = Coder.decode(IOUtil.readString(in, true));
                    String val = Coder.decode(IOUtil.readString(in, true));
                    this.getEnvironment().put(key, val);
                }
            }
        } else if (this.sourceData == 3) {
            int count = in.readInt();
            this.sourceList = new Object[count];
            this.sourceType = new int[count];
            this.doTranspose = new boolean[count];
            this.transposeColList = new Object[count];
            for (int i = 0; i < count; ++i) {
                int type;
                this.sourceType[i] = type = in.readInt();
                if (type == 1) {
                    this.sourceList[i] = DBInfoBasic.read(in, this.version);
                    if (this.modDataSourceArr != null) {
                        ((DBInfoBasic)this.sourceList[i]).setQuery(this.modDataSourceArr[i]);
                    }
                } else if (type == 2 || type == 6 || type == 4) {
                    this.sourceList[i] = Coder.decode(IOUtil.readString(in, true));
                    if (this.modDataSourceArr != null) {
                        this.sourceList[i] = this.modDataSourceArr[i];
                    }
                } else if (type == 7) {
                    XMLFileQueryInfo xmlFileQueryInfo = XMLFileQueryInfo.read(in);
                    this.sourceList[i] = xmlFileQueryInfo;
                } else if (type == 5) {
                    int ejbversion = in.readInt();
                    String thisJNDIName = Coder.decode(IOUtil.readString(in, true));
                    String thisHomeName = Coder.decode(IOUtil.readString(in, true));
                    String thisRemoteName = Coder.decode(IOUtil.readString(in, true));
                    String thisSelectedMethodName = Coder.decode(IOUtil.readString(in, true));
                    int paramCount = in.readInt();
                    Object[] thisSelectedMethodParamVal = new Object[paramCount];
                    for (int k = 0; k < paramCount; ++k) {
                        String paramType = Coder.decode(IOUtil.readString(in, true));
                        thisSelectedMethodParamVal[k] = EJBUtil.getRuntimeInputValue(paramType, Coder.decode(IOUtil.readString(in, true)));
                    }
                    Hashtable<String, String> thisEnvironment = null;
                    if (ejbversion >= 2) {
                        int envsize = in.readInt();
                        if (envsize > 0) {
                            thisEnvironment = new Hashtable<String, String>();
                        }
                        if (thisEnvironment != null) {
                            for (int k = 0; k < envsize; ++k) {
                                String key = Coder.decode(IOUtil.readString(in, true));
                                String val = Coder.decode(IOUtil.readString(in, true));
                                thisEnvironment.put(key, val);
                            }
                        }
                    }
                    this.sourceList[i] = new EJBInfo(thisJNDIName, thisHomeName, thisRemoteName, thisSelectedMethodName, thisSelectedMethodParamVal, thisEnvironment);
                }
                if (this.version <= 18) {
                    in.readBoolean();
                    if (this.version >= 9) {
                        IOUtil.readBooleans(in);
                    }
                }
                if (this.version < 213) continue;
                this.doTranspose[i] = in.readBoolean();
                this.transposeColList[i] = IOUtil.readBooleans(in);
                if (this.modTransposeArr != null) {
                    this.doTranspose[i] = this.modTransposeArr[i];
                }
                if (this.modTransposeColArr == null) continue;
                this.transposeColList[i] = this.modTransposeColArr[i];
            }
        } else if (this.sourceData == 0 && in.readBoolean()) {
            this.originalColDataFromMemSource = this.createColData(in, this.version);
        }
        if (this.version <= 18) {
            in.readBoolean();
            if (this.version >= 9) {
                IOUtil.readBooleans(in);
            }
        }
        if (this.version >= 213) {
            this.isTransposed = in.readBoolean();
            if (this.modTranspose != null) {
                this.isTransposed = this.modTranspose;
            }
            this.transposeCol = IOUtil.readBooleans(in);
            if (this.modTransposeCol != null) {
                this.transposeCol = this.modTransposeCol;
            }
        }
    }

    public static String[] loadDataSourceID(String filename) throws Exception {
        String[] result;
        if (!IOUtil.isXMLFormat(filename)) {
            ReadDataFile readfile = new ReadDataFile();
            result = LoadReport.loadDataSourceID(readfile.getInputStream(null, filename));
            readfile.close();
        } else {
            LoadXMLReport loadXMLReport = new LoadXMLReport();
            Report report = loadXMLReport.loadReportFromFile(filename, null, true);
            result = new String[]{report.registryID, report.dataSourceID, report.dataSourceLoc};
        }
        return result;
    }

    public static String[] loadDataSourceID(DataInput in) throws Exception {
        String[] result = null;
        int version = in.readInt();
        if (version >= 135) {
            if (version >= 288 && !(in instanceof VersioningDataInput)) {
                in = new VersioningDataInput(in, 7004);
            }
            result = new String[]{IOUtil.readString(in, true), IOUtil.readString(in, true), IOUtil.readString(in, true)};
        }
        return result;
    }

    private Report loadData(DataInput orgIn, ColData[] colData, Report report, boolean template, Vector params, Vector formulaParams, boolean isEntpServer) throws Exception {
        Object object;
        long start;
        boolean isAdjustFont;
        double cmGridStepSize;
        double gridStepSize;
        boolean snapToGrid;
        boolean ascending;
        int topN;
        int reportType;
        Vector<Script> scripts;
        Vector<Formula> formulas;
        boolean isPrevParamPrompt;
        boolean limitSubReportQueryExecution;
        Vector<Parameter> queryParameters;
        Vector<Object> parameter;
        Hashtable<String, QueryInParam[]> securityQueryParameterMap;
        Vector<Parameter> formulaParameters;
        DataInput in;
        boolean isApplyTemplateForDHTMLViewer;
        String dataSourceLoc;
        String dataSourceID;
        String registryID;
        boolean sorteddata;
        block272: {
            int fontMappingSize;
            block271: {
                int pair_count;
                Parameter param;
                int i;
                sorteddata = false;
                registryID = null;
                dataSourceID = null;
                dataSourceLoc = null;
                isApplyTemplateForDHTMLViewer = false;
                if (template && report != null && report.isApplyTemplateForDHTMLViewer()) {
                    isApplyTemplateForDHTMLViewer = true;
                }
                this.version = orgIn.readInt();
                in = orgIn;
                if (this.version >= 288 && !(orgIn instanceof VersioningDataInput)) {
                    in = new VersioningDataInput(orgIn, 7004);
                }
                if (this.version >= 135) {
                    registryID = IOUtil.readString(in, true);
                    dataSourceID = IOUtil.readString(in, true);
                    dataSourceLoc = IOUtil.readString(in, true);
                }
                if (this.version >= 132) {
                    this.isPacked = in.readBoolean();
                }
                if (this.version >= 179) {
                    this.saveAllData = in.readBoolean();
                }
                LOGGER.finest("Is packed: " + this.isPacked);
                if (!this.isPacked) {
                    if (this.version > 20) {
                        this.loadTree(in);
                    } else {
                        this.drillDownNode = new DrillDownNode("ROOT");
                    }
                } else {
                    this.loadDrillDownTreeByteArrays(in);
                }
                if (!this.isPacked) {
                    if (this.version > 21) {
                        this.loadSubReports(in);
                    } else {
                        this.subReports = new Vector();
                    }
                } else {
                    this.loadSubReportsByteArrays(in);
                }
                this.loadDataHeader(in);
                formulaParameters = new Vector<Parameter>();
                if (this.version >= 75) {
                    int size = in.readInt();
                    for (i = 0; i < size; ++i) {
                        param = new Parameter();
                        param.read(in, this.version);
                        formulaParameters.addElement(param);
                    }
                }
                if (formulaParams != null) {
                    Object[] values = (Object[])formulaParams.elementAt(0);
                    for (i = 0; values != null && i < values.length; ++i) {
                        param = (Parameter)formulaParameters.elementAt(i);
                        param.setValue(values[i]);
                    }
                }
                securityQueryParameterMap = null;
                if (this.version >= 136 && (pair_count = in.readInt()) > 0) {
                    securityQueryParameterMap = new Hashtable<String, QueryInParam[]>();
                    for (int i2 = 0; i2 < pair_count; ++i2) {
                        String levelname = IOUtil.readStr(in);
                        int param_count = in.readInt();
                        if (param_count <= 0) continue;
                        QueryInParam[] security_params = new QueryInParam[param_count];
                        for (int j = 0; j < param_count; ++j) {
                            security_params[j] = QueryInParam.read(in, 0);
                        }
                        securityQueryParameterMap.put(levelname, security_params);
                    }
                }
                parameter = null;
                if (!template && colData == null) {
                    try {
                        QueryInParam[] ps;
                        if (this.queryFileInfo != null) {
                            this.optimizeMemory = false;
                            boolean changeValue = false;
                            for (QueryInParam element : ps = this.queryFileInfo.getInSet().getParameter()) {
                                if (!(element instanceof QueryMultiValueInParam)) continue;
                                changeValue = true;
                            }
                            parameter = QueryFileInfo.getParameter(this.queryFileInfo, true, true, false, this.usingBackupData, changeValue);
                            break block271;
                        }
                        if (!(this.dbInfo instanceof QueryFileInfo)) break block271;
                        this.optimizeMemory = false;
                        this.tempDbInfo = (QueryFileInfo)this.dbInfo;
                        if (this.securityLevel != null && securityQueryParameterMap != null) {
                            QueryInParam[] masterParams = ((QueryFileInfo)this.dbInfo).getInSet().getParameter();
                            this.isParamMapped = new boolean[masterParams.length];
                            for (int i3 = 0; i3 < this.isParamMapped.length; ++i3) {
                                this.isParamMapped[i3] = true;
                            }
                            this.securityParams = QueryParser.verifyParameters(masterParams, (IQueryInParam[])securityQueryParameterMap.get(this.securityLevel));
                            Vector unselected = new Vector();
                            if (this.securityParams != null) {
                                for (int i4 = 0; i4 < masterParams.length; ++i4) {
                                    boolean isMulti = false;
                                    Vector<Object> obj = null;
                                    if (masterParams[i4] instanceof QueryMultiValueInParam) {
                                        isMulti = true;
                                        obj = ((QueryMultiValueInParam)this.securityParams[i4]).getValues();
                                        ((QueryMultiValueInParam)masterParams[i4]).setValues(obj);
                                    } else {
                                        obj = this.securityParams[i4].getValue();
                                        masterParams[i4].setValue(obj);
                                    }
                                    if (obj != null) continue;
                                    if (params != null && params.size() >= 1) {
                                        if (params.elementAt(0) instanceof QueryInParamSet) {
                                            QueryInParam[] qset = ((QueryInParamSet)params.elementAt(0)).getParameter();
                                            if (isMulti) {
                                                ((QueryMultiValueInParam)masterParams[i4]).setValues(((QueryMultiValueInParam)qset[i4]).getValues());
                                                continue;
                                            }
                                            masterParams[i4].setValue(qset[i4].getValue());
                                            continue;
                                        }
                                        Object[] values = (Object[])params.elementAt(0);
                                        if (isMulti && values[i4] instanceof Vector) {
                                            ((QueryMultiValueInParam)masterParams[i4]).setValues((Vector)values[i4]);
                                            continue;
                                        }
                                        masterParams[i4].setValue(values[i4]);
                                        continue;
                                    }
                                    unselected.addElement(masterParams[i4]);
                                    this.isParamMapped[i4] = false;
                                }
                                if (unselected.size() == 0) {
                                    parameter = new Vector();
                                    parameter.addElement(((QueryFileInfo)this.dbInfo).getInSet());
                                } else {
                                    QueryInParam[] unselectedParams = new QueryInParam[unselected.size()];
                                    for (int i5 = 0; i5 < unselectedParams.length; ++i5) {
                                        unselectedParams[i5] = (QueryInParam)unselected.elementAt(i5);
                                    }
                                    DBInfoBasic newDBInfo = this.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.dbInfo.getJNDIName(), this.dbInfo.getQuery(), this.dbInfo.getEnvProperties()) : new DBInfoBasic(this.dbInfo.getURLString(), this.dbInfo.getDriverName(), this.dbInfo.getUserID(), this.dbInfo.getPassword(), this.dbInfo.getQuery(), this.dbInfo.getAdditionalDb());
                                    this.tempDbInfo = new QueryFileInfo(this.tempDbInfo.getProductName(), this.tempDbInfo.getVersion(), newDBInfo, new QueryInParamSet(unselectedParams));
                                }
                            }
                        }
                        if (params == null || params.size() < 1) {
                            if (parameter == null && (this.drillDownNode == null || this.useDefaults)) {
                                try {
                                    QueryInParam[] pArray = this.tempDbInfo.getInSet().getParameter();
                                    for (QueryInParam element : pArray) {
                                        element.setValue(element.getDefaultValue(this.tempDbInfo));
                                    }
                                    parameter = new Vector<QueryInParamSet>();
                                    parameter.addElement(((QueryFileInfo)this.dbInfo).getInSet());
                                }
                                catch (Exception ex) {
                                    LOGGER.log(Level.FINEST, "Error getting param values", ex);
                                }
                            }
                            if (parameter == null) {
                                boolean changeValue = false;
                                for (QueryInParam element : ps = this.tempDbInfo.getInSet().getParameter()) {
                                    if (!(element instanceof QueryMultiValueInParam)) continue;
                                    changeValue = true;
                                }
                                parameter = QueryFileInfo.getParameter(this.tempDbInfo, true, true, false, this.usingBackupData, changeValue);
                                parameter = new Vector();
                                parameter.addElement(((QueryFileInfo)this.dbInfo).getInSet());
                            }
                            break block271;
                        }
                        if (parameter == null) {
                            if (params.elementAt(0) instanceof QueryInParamSet) {
                                if (params.size() > 0) {
                                    ((QueryFileInfo)this.dbInfo).setInSet((QueryInParamSet)params.elementAt(0));
                                }
                                parameter = params;
                            } else {
                                Object[] values = (Object[])params.elementAt(0);
                                ps = ((QueryFileInfo)this.dbInfo).getInSet().getParameter();
                                for (int i6 = 0; i6 < ps.length; ++i6) {
                                    if (values[i6] instanceof Vector && ps[i6] instanceof QueryMultiValueInParam) {
                                        ((QueryMultiValueInParam)ps[i6]).setValues((Vector)values[i6]);
                                        continue;
                                    }
                                    if ("UnMapped".equals(values[i6])) {
                                        ps[i6].setValue(ps[i6].getDefaultValue((QueryFileInfo)this.dbInfo));
                                        continue;
                                    }
                                    ps[i6].setValue(values[i6]);
                                }
                                parameter = new Vector();
                                parameter.addElement(((QueryFileInfo)this.dbInfo).getInSet());
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (this.backupColData != null) {
                            LOGGER.log(Level.WARNING, "Cannot get data from data source, using backup data", ex);
                            colData = this.backupColData;
                            this.originalColDataFromMemSource = colData;
                            this.originalSourceData = this.sourceData;
                            this.sourceData = 0;
                            this.promptParamValue = false;
                        }
                        LOGGER.log(Level.FINEST, "Failed to get data from data source", ex);
                        throw new IOException("Failed to get data from data source:\n" + ex.getMessage());
                    }
                }
            }
            queryParameters = new Vector<Parameter>();
            if (this.dbInfo != null && this.dbInfo instanceof IQueryFileInfo) {
                quadbase.reportdesigner.util.IQueryInParam[] inParams;
                for (quadbase.reportdesigner.util.IQueryInParam inParam : inParams = ReportUtil.getInParam(this.dbInfo)) {
                    Parameter param = new Parameter(inParam);
                    queryParameters.addElement(param);
                }
                QueryInParam[] ps = ((QueryFileInfo)this.dbInfo).getInSet().getParameter();
                if (ps != null) {
                    for (int i = 0; i < ps.length; ++i) {
                        Parameter param = (Parameter)queryParameters.elementAt(i);
                        param.setValue(ps[i].getValue());
                    }
                }
            }
            if (this.version >= 176) {
                int size = in.readInt();
                for (int i = 0; i < size; ++i) {
                    if (i < queryParameters.size()) {
                        ((Parameter)queryParameters.elementAt(i)).readShareInfo(in, this.version);
                        continue;
                    }
                    new Parameter().readShareInfo(in, this.version);
                }
            }
            limitSubReportQueryExecution = false;
            if (this.version >= 212) {
                limitSubReportQueryExecution = in.readBoolean();
            }
            isPrevParamPrompt = true;
            if (this.version >= 277) {
                isPrevParamPrompt = in.readBoolean();
            }
            formulas = new Vector<Formula>();
            Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
            formulaVec.add(formulas);
            Report[] subReportArray = null;
            subReportArray = Report.getSubReportArray(this.subReports, true, this.subFilesTable, this.loadNewOnly, this.isPacked);
            for (int i = 0; subReportArray != null && i < subReportArray.length; ++i) {
                Report rpt = subReportArray[i];
                if (rpt == null) continue;
                formulaVec.add(rpt.formulas);
            }
            if (this.version >= 70) {
                int size = in.readInt();
                for (int i = 0; i < size; ++i) {
                    Formula formula = new Formula();
                    try {
                        formula.read(in, this.version, formulaVec, queryParameters, formulaParameters);
                        formulas.addElement(formula);
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINEST, "Cannot read formula", e);
                    }
                }
            }
            for (Formula f : formulas) {
                try {
                    f.parseThisFormula();
                }
                catch (Exception e) {
                    if (!this.fromReportDesigner) continue;
                    String msg = e.getMessage();
                    JOptionPane.showMessageDialog(null, "Please fix it!\n" + msg, "Error in Formula:  " + f.getName(), 0);
                }
            }
            scripts = new Vector<Script>();
            if (this.version >= 70) {
                int size = in.readInt();
                for (int i = 0; i < size; ++i) {
                    Script script = new Script();
                    script.read(in, this.version, formulaVec, queryParameters, formulaParameters);
                    scripts.addElement(script);
                }
            }
            if (this.fromReportDesigner) {
                for (Parameter sp : formulaParameters) {
                    String fpStr = "?" + sp.name;
                    boolean found = false;
                    for (Formula f : formulas) {
                        if (f.text.indexOf(fpStr) < 0) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    for (Script s : scripts) {
                        if (s.text.indexOf(fpStr) < 0) continue;
                        String msg = "Script [" + s.name + "] references a formula parameter [" + fpStr + "], which is NOT existing in Formulas any more.";
                        JOptionPane.showMessageDialog(null, "Please fix it!\n" + msg, "Error in Script:  " + s.getName(), 0);
                    }
                }
            }
            this.colInfo = new ColInfo[in.readInt()];
            for (int i = 0; i < this.colInfo.length; ++i) {
                this.colInfo[i] = ColInfo.read(in, this.version);
            }
            for (ColInfo element : this.colInfo) {
                if (this.version >= 70) {
                    Formula formula;
                    for (int j = 0; j < formulas.size(); ++j) {
                        formula = (Formula)formulas.elementAt(j);
                        if (element.getFormulaName() == null || !element.getFormulaName().equals(formula.getName())) continue;
                        LOGGER.finest("LoadReport: found formula");
                        element.setFormulaObj(formula);
                        break;
                    }
                    if (element.getFormulaObj() != null || element.getFormulaName() == null) continue;
                    String text = element.getFormulaName();
                    formula = new Formula("formula" + (formulas.size() + 1), text);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                    try {
                        formula.setFormula(parser.parse(formulaVec, null, null, null));
                        element.setFormulaObj(formula);
                        formulas.addElement(formula);
                    }
                    catch (TokenMgrError err) {
                        LOGGER.log(Level.WARNING, "Syntax error: " + text, err);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINE, "Can't parse formula", ex);
                    }
                    continue;
                }
                if (element.getFormula() == null) continue;
                Formula formula = new Formula("formula" + (formulas.size() + 1), element.getFormula());
                ByteArrayInputStream inputStream = new ByteArrayInputStream(element.getFormula().getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                try {
                    formula.setFormula(parser.parse(formulas, null, null, null));
                    element.setFormulaObj(formula);
                    formulas.addElement(formula);
                }
                catch (TokenMgrError err) {
                    LOGGER.log(Level.WARNING, "Syntax error: " + element.getFormula(), err);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Cannot parse formula", ex);
                }
            }
            if (this.retrieveColInfoOnly) {
                return null;
            }
            reportType = in.readInt();
            if (this.version >= 130 && (fontMappingSize = in.readInt()) > 0) {
                if (this.getFontMapping() == null) {
                    this.setFontMapping(new Hashtable<String, String>());
                }
                for (int i = 0; i < fontMappingSize; ++i) {
                    String key = Coder.decode(IOUtil.readString(in, true));
                    String val = Coder.decode(IOUtil.readString(in, true));
                    this.getFontMapping().put(key, val);
                }
            }
            topN = 0;
            ascending = true;
            if (this.version >= 100) {
                topN = in.readInt();
            }
            if (this.version >= 102) {
                ascending = in.readBoolean();
            }
            snapToGrid = false;
            gridStepSize = 0.1;
            cmGridStepSize = 0.25;
            if (this.version >= 137) {
                snapToGrid = in.readBoolean();
                gridStepSize = in.readDouble();
                cmGridStepSize = in.readDouble();
            }
            isAdjustFont = false;
            if (this.version >= 145 && this.version < 160 || this.version >= 163) {
                isAdjustFont = in.readBoolean();
            }
            if (this.version >= 282) {
                this.rowBreakAggrIncluded = IOUtil.readBooleans(in);
                this.colBreakAggrIncluded = IOUtil.readBooleans(in);
            }
            if (this.version >= 6604) {
                this.keepDataSourceOrder = in.readBoolean();
            }
            if (this.usingBackupData && this.backupColData != null && (reportType != 2 || this.dbInfo instanceof QueryFileInfo || this.saveAllData)) {
                colData = this.backupColData;
                this.originalColDataFromMemSource = colData;
                this.originalSourceData = this.sourceData;
                this.sourceData = 0;
                this.promptParamValue = false;
            }
            if (this.isTransposed) {
                this.optimizeMemory = false;
            }
            boolean isValidForExportOnly = report != null && report.isValidForExportOnly();
            LOGGER.finer("Getting data started");
            start = System.currentTimeMillis();
            if (this.queryFileInfo != null || !template && colData == null) {
                try {
                    if (this.sourceData == 1) {
                        ColData[] colData2;
                        DBInfoBasic tempdbInfo;
                        String sqlstr;
                        if (!(this.keepDataSourceOrder || reportType != 1 && reportType != 2 && reportType != 3 || this.isTransposed)) {
                            sqlstr = this.dbInfo.getQuery();
                            sqlstr = TransformQuery.transform(sqlstr, this.colInfo);
                            tempdbInfo = this.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.dbInfo.getJNDIName(), sqlstr, this.dbInfo.getEnvProperties()) : new DBInfoBasic(this.dbInfo.getURLString(), this.dbInfo.getDriverName(), this.dbInfo.getUserID(), this.dbInfo.getPassword(), sqlstr);
                            if (this.dbInfo instanceof QueryFileInfo) {
                                tempdbInfo = new QueryFileInfo("", 0, tempdbInfo, ((QueryFileInfo)this.dbInfo).getInSet());
                            }
                            try {
                                colData2 = null;
                                colData2 = this.fromReportDesigner && reportType == 1 ? DBAccess.retrieveResult(parameter, tempdbInfo, true, false, null, null, null, 0, 20, false) : (this.optimizeMemory && isValidForExportOnly ? DBAccess.retrieveResult(parameter, tempdbInfo, true, false, null, null, null, 0, 0, true) : DBAccess.retrieveResult(parameter, tempdbInfo, true, false, null, null, null, false));
                                colData = colData2;
                                sorteddata = true;
                                if (this.optimizeMemory && !isValidForExportOnly) {
                                    sorteddata = false;
                                }
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.WARNING, "LoadReport failed to retrieve sorted data! Using original query to try again.", ex);
                            }
                        }
                        if (!sorteddata) {
                            colData = this.fromReportDesigner && reportType != 2 ? DBAccess.retrieveResult(parameter, this.dbInfo, true, this.isTransposed, this.transposeCol, null, null, 0, 20, false) : (this.optimizeMemory && reportType == 0 ? DBAccess.retrieveResult(parameter, this.dbInfo, true, false, null, null, null, 0, 0, true) : DBAccess.retrieveResult(parameter, this.dbInfo, true, this.isTransposed, this.transposeCol, null, null, false));
                            break block272;
                        }
                        if (reportType != 1 && reportType != 2) break block272;
                        try {
                            sqlstr = this.dbInfo.getQuery();
                            tempdbInfo = null;
                            sqlstr = TransformQuery.transform(sqlstr, this.colInfo);
                            colData2 = null;
                            tempdbInfo = this.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.dbInfo.getJNDIName(), sqlstr, this.dbInfo.getEnvProperties()) : new DBInfoBasic(this.dbInfo.getURLString(), this.dbInfo.getDriverName(), this.dbInfo.getUserID(), this.dbInfo.getPassword(), sqlstr);
                            if (this.dbInfo instanceof QueryFileInfo) {
                                tempdbInfo = new QueryFileInfo("", 0, tempdbInfo, ((QueryFileInfo)this.dbInfo).getInSet());
                            }
                            colData2 = this.optimizeMemory && isValidForExportOnly ? DBAccess.retrieveResult(parameter, tempdbInfo, true, false, null, null, null, 0, 0, this.optimizeMemory) : DBAccess.retrieveResult(parameter, tempdbInfo, true, this.isTransposed, this.transposeCol, null, null, 0, -1, this.optimizeMemory);
                            if (this.usingBackupData && this.backupColData != null && reportType == 2 && colData2.length > 0 && colData2[0].getSize() == 0) {
                                colData = this.backupColData;
                                this.originalColDataFromMemSource = colData;
                                this.originalSourceData = this.sourceData;
                                this.sourceData = 0;
                                this.promptParamValue = false;
                            } else {
                                colData = colData2;
                            }
                            sorteddata = true;
                            if (this.optimizeMemory && !isValidForExportOnly) {
                                sorteddata = false;
                            }
                            break block272;
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Failed to retrieve data", e);
                        }
                        break block272;
                    }
                    if (this.sourceData == 2) {
                        colData = new DataFileInput().readProcessedData(this.sourceFile, this.isTransposed, this.transposeCol, null);
                        break block272;
                    }
                    if (this.sourceData == 4) {
                        colData = new DataFileInput().readProcessedData(this.sourceFile, this.isTransposed, this.transposeCol, null, 4);
                        break block272;
                    }
                    if (this.sourceData == 6) {
                        colData = this.dbInfo != null && this.dbInfo instanceof QueryClassFileInfo ? new DataFileInput().readProcessedData(this.sourceFile, this.isTransposed, this.transposeCol, null, null, 0, reportType == 2 || !this.fromReportDesigner ? -1 : 20, ((QueryClassFileInfo)this.dbInfo).getInSet()) : new DataFileInput().readProcessedData(this.sourceFile, this.isTransposed, this.transposeCol, null, 6);
                        break block272;
                    }
                    if (this.sourceData == 3) {
                        colData = ColData.getColData(this.sourceList, this.sourceType, this.doTranspose, this.transposeColList, this.isTransposed, this.transposeCol, false);
                        break block272;
                    }
                    if (this.sourceData == 7) {
                        colData = new DataFileInput().readProcessedData(this.sourceFile, this.isTransposed, this.transposeCol, null, null, 0, -1, this.xmlFileQueryInfo, this.sourceData);
                        break block272;
                    }
                    if (this.sourceData == 12) {
                        colData = SOAPAccess.retrieveResult(this.soapInfo);
                        break block272;
                    }
                    if (this.sourceData == 9) {
                        colData = this.backupColData;
                        break block272;
                    }
                    if (this.sourceData == 11) {
                        colData = SalesForceAccess.getColData(this.sfQueryInfo);
                        break block272;
                    }
                    if (this.sourceData == 13) {
                        colData = ExcelAccess.getColData(this.excelInfo, this.isTransposed, this.transposeCol);
                        break block272;
                    }
                    if (this.sourceData == 10) {
                        OLAPAccess olapAccess = new OLAPAccess(null, this.mondrianConnectionString, this.MDXQuery, this.xmlaURI, this.xmlaDataSource, this.xmlaCatalog);
                        colData = olapAccess.retrieveResult(reportType);
                        this.rowBreakAggrIncluded = olapAccess.isRowBreakAggrIncluded(this.rowBreakAggrIncluded);
                        this.colBreakAggrIncluded = olapAccess.isColBreakAggrIncluded(this.colBreakAggrIncluded);
                        break block272;
                    }
                    if (this.sourceData == 5) {
                        colData = EJBAccess.retrieveResult(this.jndiName, this.homeName, this.remoteName, this.selectedMethodName, this.selectedMethodParamVal, this.getEnvironment());
                        break block272;
                    }
                    if (this.sourceData == 0 && this.originalColDataFromMemSource != null) {
                        colData = ColData.getColData(DBAccess.processResultSet(ColData.getResultSet(this.originalColDataFromMemSource), false, this.isTransposed, this.transposeCol, null, null));
                        break block272;
                    }
                    throw new IOException("No plotting data and no data source available !");
                }
                catch (Exception ex) {
                    this.errorMessage = "Failed to get data from data source:\n" + ex.getMessage() + " Use backup data!";
                    if (this.backupColData != null) {
                        LOGGER.log(Level.FINE, "Failed to get data from data source, using backup data", ex);
                        colData = this.backupColData;
                        this.originalColDataFromMemSource = colData;
                        this.originalSourceData = this.sourceData;
                        this.sourceData = 0;
                        this.promptParamValue = false;
                    }
                    LOGGER.log(Level.FINEST, "Failed to get data from data source, no backup data found", ex);
                    this.errorMessage = "Failed to get data from data source:\n" + ex.getMessage();
                    throw new IOException(this.errorMessage);
                }
            }
        }
        LOGGER.finer("Getting data finished in " + (System.currentTimeMillis() - start) + " ms");
        if (this.version >= 180) {
            this.showRowAggregationGrandTotal = in.readBoolean();
        }
        if (this.version >= 271) {
            this.crossTabFreeForm = in.readBoolean();
        }
        if (this.version >= 274) {
            this.showRowAggregationSubtotal = in.readBoolean();
        }
        if (this.version >= 6603) {
            this.rowAggregationSubtotalOnLeft = in.readBoolean();
        }
        if (this.version >= 7003) {
            this.rowAggregationGrandTotalOnLeft = in.readBoolean();
        }
        if (this.version >= 7004) {
            this.reOrderColumns = in.readBoolean();
        }
        if (this.version >= 284) {
            this.showColumnAggregation = in.readBoolean();
        }
        if (this.version >= 275) {
            this.columnAggregationInHeader = in.readBoolean();
        }
        if (this.version >= 279) {
            this.alignCrossTabColBkValHori = in.readBoolean();
        }
        if (report == null) {
            report = new Report(colData, this.optimizeMemory);
            report.domainPath = this.relativeDomainPath;
            report.colDataSorted = sorteddata;
            report.setShowRowAggregationGrandTotal(this.showRowAggregationGrandTotal);
            report.setReOrderColumns(this.reOrderColumns);
            report.crossTabFreeForm = this.crossTabFreeForm;
            report.setShowRowAggregationSubtotal(this.showRowAggregationSubtotal);
            report.setRowAggregationSubtotalOnLeft(this.rowAggregationSubtotalOnLeft);
            report.setRowAggregationGrandTotalOnLeft(this.rowAggregationGrandTotalOnLeft);
            report.rowBreakAggrIncluded = this.rowBreakAggrIncluded;
            report.colBreakAggrIncluded = this.colBreakAggrIncluded;
            report.setKeepDataSourceOrder(this.keepDataSourceOrder);
            report.setShowColumnAggregation(this.showColumnAggregation);
            report.setColumnAggregationInHeader(this.columnAggregationInHeader);
            report.setAlignCrossTabColBkValHori(this.alignCrossTabColBkValHori);
            report.createTable(reportType, this.colInfo, false, this.isDesignerDesignMode);
            report.sourceData = this.sourceData;
            report.originalSourceData = this.originalSourceData;
            report.dbInfo = this.dbInfo;
            report.sourceFile = this.sourceFile;
            report.xmlFileQueryInfo = this.xmlFileQueryInfo;
            report.jndiName = this.jndiName;
            report.homeName = this.homeName;
            report.remoteName = this.remoteName;
            report.selectedMethodName = this.selectedMethodName;
            report.selectedMethodParamVal = this.selectedMethodParamVal;
            report.environment = this.getEnvironment();
            report.soapInfo = this.soapInfo;
            report.sfQueryInfo = this.sfQueryInfo;
            report.excelInfo = this.excelInfo;
            report.fontMapping = this.getFontMapping();
            report.mondrianConnectionString = this.mondrianConnectionString;
            report.MDXQuery = this.MDXQuery;
            report.xmlaURI = this.xmlaURI;
            report.xmlaDataSource = this.xmlaDataSource;
            report.xmlaCatalog = this.xmlaCatalog;
            report.originalColDataFromMemSource = this.originalColDataFromMemSource;
            report.sourceList = this.sourceList;
            report.sourceType = this.sourceType;
            report.doTranspose = this.doTranspose;
            report.transposeColList = this.transposeColList;
            report.queryFilename = this.queryFilename;
            report.setFontMapping(this.getFontMapping());
            report.setTopN(topN);
            report.setAscending(ascending);
            report.registryID = registryID;
            report.dataSourceID = dataSourceID;
            report.dataSourceLoc = dataSourceLoc;
            report.setSecurityQueryParameterMap(securityQueryParameterMap);
            report.setPreviewSecurityLevel(this.securityLevel);
            report.snapToGrid = snapToGrid;
            report.gridStepSize = gridStepSize;
            report.cmGridStepSize = cmGridStepSize;
            report.isAdjustFont = isAdjustFont;
            report.saveAllData = this.saveAllData;
            report.limitSubReportQueryExecution = limitSubReportQueryExecution;
            report.isPrevParamPrompt = isPrevParamPrompt;
        } else if (template && this.applyFormula) {
            report = report.updateColInfo(report.addFormulaColumn(this.colInfo), true);
        }
        report.mergeSubFilesTable(this.subFilesTable);
        if (!template) {
            report.subReports = this.subReports;
            report.currentNode = this.drillDownNode;
            if (report.currentNode == null) {
                report.currentNode = this.nodeForUnmappedDrillDown;
            }
            report.setQueryFileInfo(this.queryFileInfo);
            if (this.queryFileInfo != null) {
                report.getQueryFileInfo().setParameter(parameter);
            }
        } else {
            report.copyFitGroupColInfo(report.colInfo, this.colInfo);
        }
        if (this.version >= 243 && !template) {
            report.setTransposed(this.isTransposed, this.transposeCol);
        }
        this.loadColDataAttr(in, report.colData);
        report.setName(Coder.decode(IOUtil.readString(in, true)));
        report.setPageWidth(in.readDouble());
        report.setPageHeight(in.readDouble());
        report.setLeftMargin(in.readDouble());
        report.setRightMargin(in.readDouble());
        report.setTopMargin(in.readDouble());
        report.setBottomMargin(in.readDouble());
        if (this.version >= 103) {
            report.setOrientation(in.readInt());
        }
        String columnWrapID = null;
        if (this.version >= 31) {
            columnWrapID = IOUtil.readStr(in);
        }
        if (this.version >= 96) {
            report.hasTitle = in.readBoolean();
            report.hasLogo = in.readBoolean();
            report.hasPageNumber = in.readBoolean();
            report.hasDate = in.readBoolean();
            report.reportTitle = IOUtil.readStr(in);
            report.logofile = IOUtil.readStr(in);
            report.logoPos = in.readInt();
            report.pageNumberFormat = in.readInt();
            report.pageNumberPos = in.readInt();
            report.dateFormat = in.readInt();
            report.datePos = in.readInt();
            report.reportStyle = in.readInt();
            if (this.version >= 211) {
                report.customStyleFile = IOUtil.readStr(in);
            }
        }
        if ((this.version >= 110 && this.version <= 127 || this.version >= 143 && this.version < 160 || this.version >= 161) && in.readBoolean()) {
            report.setHTMLTitle(IOUtil.readStr(in));
        }
        if (this.version >= 168) {
            in.readBoolean();
            if (in.readBoolean()) {
                report.setExternalStyleSheetName(IOUtil.readStr(in));
            }
        }
        if (this.version >= 174) {
            if (in.readBoolean()) {
                report.setExportEncoding(IOUtil.readStr(in));
            }
            if (in.readBoolean()) {
                report.setHTMLCharset(IOUtil.readStr(in));
            }
        }
        if (this.version >= 183 && in.readBoolean()) {
            report.setRTFEncoding(IOUtil.readStr(in));
        }
        if (!template) {
            report.setPageHeader(ReportSection.createSection(in, this.version, this.isPacked, this.fromReportDesigner, this.subFilesTable, this.relativeDomainPath));
            report.setReportHeader(ReportSection.createSection(in, this.version, this.isPacked, this.fromReportDesigner, this.subFilesTable, this.relativeDomainPath));
            if (report.hasTitle) {
                report.getReportHeader().createReportTitle(report.reportTitle);
            }
        } else {
            report.getPageHeader().copyTemplate(ReportSection.createSection(in, this.version, this.isPacked, this.fromReportDesigner, this.subFilesTable, this.relativeDomainPath), this.copyEmptySection);
            report.getReportHeader().copyTemplate(ReportSection.createSection(in, this.version, this.isPacked, this.fromReportDesigner, this.subFilesTable, this.relativeDomainPath), this.copyEmptySection);
        }
        report.setPackedSubReportByteArray(this.subReports);
        int len = in.readInt();
        ReportTable[] table = new ReportTable[len];
        for (int i = 0; i < len; ++i) {
            table[i] = this.createTable(reportType, in, this.version);
        }
        if (!template) {
            report.setReportFooter(ReportSection.createSection(in, this.version, this.isPacked, this.fromReportDesigner, this.subFilesTable, this.relativeDomainPath));
            report.setPageFooter(ReportSection.createSection(in, this.version, this.isPacked, this.fromReportDesigner, this.subFilesTable, this.relativeDomainPath));
        } else {
            report.getReportFooter().copyTemplate(ReportSection.createSection(in, this.version, this.isPacked, this.fromReportDesigner, this.subFilesTable, this.relativeDomainPath), this.copyEmptySection);
            report.getPageFooter().copyTemplate(ReportSection.createSection(in, this.version, this.isPacked, this.fromReportDesigner, this.subFilesTable, this.relativeDomainPath), this.copyEmptySection);
        }
        report.updateFormulas(formulas);
        report.updateScripts(scripts);
        report.updateQueryParameters(queryParameters);
        report.updateFormulaParameters(formulaParameters);
        if (this.version >= 15) {
            boolean hasImage;
            boolean existed;
            ReportTitle titleSetting;
            ColumnHeader columnHeaderSetting;
            ReportGrid gridSetting;
            ReportLine lineSetting;
            ReportColumn barcodeColumnSetting;
            Vector<Object> temp = new Vector<Object>();
            ReportCell labelSetting = ReportCell.createCell(in, this.version);
            ReportChartObject chartSetting = ReportChartObject.createChartObject(in, this.version, false, this.subFilesTable, "");
            ReportImage imageSetting = ReportImage.createImage(in, this.version);
            temp.addElement(labelSetting);
            temp.addElement(chartSetting);
            temp.addElement(imageSetting);
            ReportCell stringFormulaSetting = ReportCell.createCell(in, this.version);
            ReportCell logicFormulaSetting = ReportCell.createCell(in, this.version);
            ReportCell numericFormulaSetting = ReportCell.createCell(in, this.version);
            QueryInParam[] timeFormulaSetting = ReportCell.createCell(in, this.version);
            temp.addElement(stringFormulaSetting);
            temp.addElement(logicFormulaSetting);
            temp.addElement(numericFormulaSetting);
            temp.addElement(timeFormulaSetting);
            ReportColumn stringColumnSetting = ReportColumn.createColumn(in, this.version);
            ReportColumn logicColumnSetting = ReportColumn.createColumn(in, this.version);
            ReportColumn numericColumnSetting = ReportColumn.createColumn(in, this.version);
            ReportColumn timeColumnSetting = ReportColumn.createColumn(in, this.version);
            temp.addElement(stringColumnSetting);
            temp.addElement(logicColumnSetting);
            temp.addElement(numericColumnSetting);
            temp.addElement(timeColumnSetting);
            if (this.version >= 30) {
                LOGGER.finest("LoadReport: create barcode column");
                barcodeColumnSetting = ReportColumn.createColumn(in, this.version);
                temp.addElement(barcodeColumnSetting);
            } else {
                LOGGER.finest("LoadReport: create empty column");
                barcodeColumnSetting = new ReportColumn();
                temp.addElement(barcodeColumnSetting);
            }
            if (this.version >= 33) {
                lineSetting = ReportLine.createLine(in, this.version);
                temp.addElement(lineSetting);
                gridSetting = ReportGrid.createGrid(in, this.version);
                temp.addElement(gridSetting);
            } else {
                lineSetting = new ReportLine(false);
                gridSetting = new ReportGrid();
                temp.addElement(lineSetting);
                temp.addElement(gridSetting);
            }
            if (this.version >= 95) {
                columnHeaderSetting = ColumnHeader.createColumnHeader(in, this.version);
                temp.addElement(columnHeaderSetting);
            } else {
                columnHeaderSetting = new ColumnHeader();
                columnHeaderSetting.setDataFormat(FormatUtil.createFormat(7));
                temp.addElement(columnHeaderSetting);
            }
            if (this.version >= 206) {
                titleSetting = ReportTitle.createReportTitle(in, this.version);
                temp.addElement(titleSetting);
            } else {
                titleSetting = new ReportTitle();
                titleSetting.setDataFormat(FormatUtil.createFormat(7));
                temp.addElement(titleSetting);
            }
            report.setSetting(temp);
            Vector<ReportTable> vec = report.getReportTables();
            len = table.length <= vec.size() ? table.length : vec.size();
            ReportCell[] globalFormatTemplates = new ReportCell[]{stringFormulaSetting, columnHeaderSetting, logicFormulaSetting, numericFormulaSetting, timeFormulaSetting};
            int columnCountMismatch = 0;
            int separatingIndex = -1;
            Vector<ReportColumn> columns = null;
            for (int i = 0; i < len; ++i) {
                if (i == 0) {
                    try {
                        if (report.reportType == 2) {
                            ReportTable tbl = vec.elementAt(i);
                            columnCountMismatch = tbl.getColumnCount() - table[i].getColumnCount();
                            separatingIndex = tbl.getStartOfColumnBreakColumn() + tbl.getColumnBreakColumnCount() - columnCountMismatch;
                            columns = table[i].getColumns();
                            table[i].getFooter().createFormulaObjectFromName(report);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Failed to load crosstab report specific parameters", ex);
                    }
                }
                if (vec.elementAt(i) instanceof ReportMultiSectionTable) {
                    CrossTabTable crossTabTable;
                    ReportMultiSectionTable mTable = (ReportMultiSectionTable)vec.elementAt(i);
                    if (!template) {
                        mTable.applyGlobalFormatToColumns(report.column);
                        mTable.loadTable(table[i], true, separatingIndex, this.showRowAggregationGrandTotal, true, true, globalFormatTemplates, -1);
                        if (separatingIndex >= 0 && !this.saveAllData || report.reportType == 2) {
                            mTable.adjustColumnXPos(table[i], separatingIndex, report);
                        }
                        if (mTable instanceof CrossTabTable) {
                            crossTabTable = (CrossTabTable)mTable;
                            if (this.isDesignerDesignMode) {
                                crossTabTable.getCrossTabHeader().copyExtraCells(table[i].getHeader());
                            }
                            crossTabTable.getCrossTabHeader().copy(table[i].getHeader(), columnCountMismatch, separatingIndex, columns, globalFormatTemplates, false, false, true, true, false, crossTabTable.getFieldsCount(), report.isRowAggregationSubtotalOnLeft(), report.isShowRowAggregationSubtotal(), null, mTable.getColumns());
                            if (this.isDesignerDesignMode) {
                                ((CrossTabTable)mTable).getCrossTabFooter().copyExtraCells(table[i].getFooter());
                            }
                            crossTabTable.getCrossTabFooter().copy(table[i].getFooter(), columnCountMismatch, separatingIndex, columns, globalFormatTemplates, false, false, true, true, false, crossTabTable.getFieldsCount(), report.isRowAggregationSubtotalOnLeft(), report.isShowRowAggregationSubtotal(), null, mTable.getColumns());
                            continue;
                        }
                        mTable.getHeader().copy(table[i].getHeader(), columnCountMismatch, separatingIndex, columns, globalFormatTemplates, false);
                        mTable.getFooter().copy(table[i].getFooter(), columnCountMismatch, separatingIndex, columns, globalFormatTemplates, false);
                        continue;
                    }
                    mTable.applyGlobalFormatToColumns(report.column);
                    mTable.copyTemplate(table[i], this.applyFormula, this.copyEmptySection, false, isApplyTemplateForDHTMLViewer);
                    if (mTable instanceof CrossTabTable) {
                        crossTabTable = (CrossTabTable)mTable;
                        crossTabTable.getCrossTabHeader().copyTemplate(table[i].getHeader(), this.copyEmptySection, true, columns, crossTabTable.getFieldsCount(), report.isRowAggregationSubtotalOnLeft(), report.isShowRowAggregationSubtotal());
                        crossTabTable.getCrossTabFooter().copyTemplate(table[i].getFooter(), this.copyEmptySection, true, columns, crossTabTable.getFieldsCount(), report.isRowAggregationSubtotalOnLeft(), report.isShowRowAggregationSubtotal());
                        continue;
                    }
                    mTable.getHeader().copyTemplate(table[i].getHeader(), this.copyEmptySection);
                    if (isApplyTemplateForDHTMLViewer) {
                        mTable.getFooter().applyStyleForDHTMLViewer(table[i].getFooter());
                        continue;
                    }
                    mTable.getFooter().copyTemplate(table[i].getFooter(), this.copyEmptySection);
                    continue;
                }
                if (!template) {
                    vec.elementAt(i).loadTable(table[i]);
                    if (!(table[i] instanceof ReportMultiSectionTable) || ((ReportMultiSectionTable)table[i]).getRowBreakHeader(0) == null) continue;
                    vec.elementAt(i).getHeader().copy(((ReportMultiSectionTable)table[i]).getHeader());
                    vec.elementAt(i).getFooter().copy(((ReportMultiSectionTable)table[i]).getFooter());
                    continue;
                }
                vec.elementAt(i).applyGlobalFormatToColumns(report.column);
                vec.elementAt(i).copyTemplate(table[i], this.applyFormula, this.copyEmptySection);
                if (!(table[i] instanceof ReportMultiSectionTable) || ((ReportMultiSectionTable)table[i]).getRowBreakHeader(0) == null) continue;
                vec.elementAt(i).getHeader().copyTemplate(((ReportMultiSectionTable)table[i]).getHeader(), this.copyEmptySection);
                vec.elementAt(i).getFooter().copyTemplate(((ReportMultiSectionTable)table[i]).getFooter(), this.copyEmptySection);
            }
            if (report.colInfo.length != this.colInfo.length || columnCountMismatch != 0) {
                report.adjustHeaderFormulas();
                report.adjustFooterFormulas();
            }
            if (this.version >= 18) {
                report.setIsApplyBoundSelected(in.readBoolean());
            }
            if (this.version >= 25) {
                this.readDrillDownNodes(in, this.version, this.isPacked);
                if (report.currentNode == null) {
                    try {
                        DrillDownNode root = new DrillDownNode("ROOT");
                        root.setDomainPath(this.relativeDomainPath);
                        if (this.childDrillDownNodes != null) {
                            for (int i = 0; i < this.childDrillDownNodes.size(); ++i) {
                                root.add(this.childDrillDownNodes.elementAt(i));
                            }
                        }
                        report.currentNode = root;
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Failed to set drill-down currentNode", ex);
                    }
                }
            }
            if (this.version >= 207 && (existed = in.readBoolean())) {
                report.parentNode = this.loadTreeNode(in, false);
                if (report.parentNode == null || this.subFilesTable.getTopName() != null) {
                    // empty if block
                }
            }
            if (this.version >= 208 && (existed = in.readBoolean())) {
                report.rootNode = this.loadTreeNode(in, false);
            }
            if (this.version >= 28) {
                boolean sideBySide = in.readBoolean();
                if (!template) {
                    report.setSideBySideLayout(sideBySide);
                }
            }
            if (this.version >= 72) {
                boolean hasBytes;
                int dbSourceType = in.readInt();
                if (!template) {
                    report.setDBSourceType(dbSourceType);
                }
                if (!(hasBytes = in.readBoolean())) {
                    if (!template) {
                        report.setQueryFileBytes(null);
                    }
                } else {
                    int count = in.readInt();
                    byte[][] bytes = new byte[count][];
                    for (int i = 0; i < bytes.length; ++i) {
                        hasBytes = in.readBoolean();
                        if (!hasBytes) {
                            bytes[i] = null;
                            continue;
                        }
                        count = in.readInt();
                        bytes[i] = new byte[count];
                        in.readFully(bytes[i]);
                    }
                    if (!template) {
                        report.setQueryFileBytes(bytes);
                    }
                }
            }
            if (this.version >= 74) {
                report.setBackgroundColor(IOUtil.readColor(in));
            }
            if (this.version >= 133 && (hasImage = in.readBoolean())) {
                report.setBackgroundImage(ReportImage.createImage(in, this.version, this.isPacked, this.subFilesTable));
            }
            if (this.version >= 7001 && in.readBoolean()) {
                PaginationSettings paginationSettings = new PaginationSettings();
                paginationSettings.setPaginationModeStr(IOUtil.readStr(in));
                paginationSettings.setSize(in.readInt());
                if (paginationSettings.getPaginationMode().equals((Object)PaginationSettings.PaginationMode.PAGINATION)) {
                    paginationSettings.setPaginatorPositionStr(IOUtil.readStr(in));
                }
                report.setPaginationSettings(paginationSettings);
            }
            if (this.version >= 7002 && in.readBoolean()) {
                report.setEasyReportStyle(IOUtil.readStr(in));
            }
            if (this.version >= 144 && this.version < 160 || this.version >= 162) {
                GuideLine gl;
                int i;
                int count = in.readInt();
                if (count > 0) {
                    report.vGuideLines = new Vector();
                }
                for (i = 0; i < count; ++i) {
                    String id = IOUtil.readStr(in);
                    if (template || (gl = (GuideLine)report.getData(id)) == null) continue;
                    report.vGuideLines.addElement(gl);
                    gl.linkSnappedElements(report);
                }
                count = in.readInt();
                if (count > 0) {
                    report.hGuideLines = new Vector();
                }
                for (i = 0; i < count; ++i) {
                    String id = IOUtil.readStr(in);
                    if (template || (gl = (GuideLine)report.getData(id)) == null) continue;
                    report.hGuideLines.addElement(gl);
                    gl.linkSnappedElements(report);
                }
            }
            if (this.version >= 17) {
                String str = in.readLine();
                if (str == null) {
                    str = "";
                }
                if (template) {
                    report.setNullDataOption(str, true);
                } else {
                    report.setNullDataOption(str, false);
                }
            }
        }
        if (this.version <= 25) {
            report.setID();
        }
        if (this.version >= 29) {
            report.setGridLineLink();
        }
        if (this.version >= 31 && columnWrapID != null) {
            report.setColumnWrap((ColumnWrap)report.getData(columnWrapID));
        }
        if (this.version < 70) {
            report.buildFormulaList();
        } else {
            report.createFormulaObjectFromName();
        }
        if (this.version < 70) {
            report.buildScriptList();
        } else {
            report.createScriptObjectFromName();
        }
        if (this.subReports != null && this.subReports.size() > 0 && this.version >= 130 && this.version <= 160) {
            Vector<Parameter> mainQueryParam = report.getQueryParameters();
            Vector<Parameter> mainFormulaParam = report.getFormulaParameters();
            Report[] srArray = report.getSubReportArray();
            for (int i = 0; i < srArray.length; ++i) {
                Parameter mainParam;
                Parameter param;
                int j;
                if (srArray[i] == null) continue;
                Vector<Parameter> queryParam = srArray[i].getQueryParameters();
                Vector<Parameter> formulaParam = srArray[i].getFormulaParameters();
                for (j = 0; j < queryParam.size(); ++j) {
                    param = queryParam.elementAt(j);
                    for (int k = 0; k < mainQueryParam.size(); ++k) {
                        mainParam = mainQueryParam.elementAt(k);
                        if (!param.getName().equals(mainParam.getName())) continue;
                        param.setShared(true);
                        param.setSharedReportName("MAIN_REPORT");
                        param.setSharedParamName(mainParam.getName());
                        mainParam.incReferenceDegree();
                        srArray[i].modified = true;
                    }
                }
                for (j = 0; j < formulaParam.size(); ++j) {
                    param = formulaParam.elementAt(j);
                    for (int k = 0; k < mainFormulaParam.size(); ++k) {
                        mainParam = mainFormulaParam.elementAt(k);
                        if (!param.getName().equals(mainParam.getName())) continue;
                        param.setShared(true);
                        param.setSharedReportName("MAIN_REPORT");
                        param.setSharedParamName(mainParam.getName());
                        mainParam.incReferenceDegree();
                        srArray[i].modified = true;
                    }
                }
                if (!srArray[i].modified) continue;
                SaveReport sr = new SaveReport(srArray[i]);
                sr.setSubFilesTable(this.subFilesTable);
                SubReportObject sro = this.subReports.elementAt(i);
                try {
                    sr.saveToFile(sro.getFileName());
                    continue;
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINEST, "Can't save to file", ex);
                    ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
                    DataOutputStream out = new DataOutputStream(fstream);
                    sr.saveToFile(sro.getFileName(), out);
                    out.close();
                    fstream.close();
                    sro.setByteArray(fstream.toByteArray());
                }
            }
        }
        boolean containsSubReportParam = false;
        try {
            containsSubReportParam = this.containsParameterInSubReport(report);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to check for 'containsParameterInSubReport'", ex);
        }
        int paramCt = 0;
        paramCt = report.getParametersInSequence().size();
        int paramValueCt = 0;
        int unMappedCt = 0;
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                object = params.elementAt(i);
                if (object instanceof Object[]) {
                    for (int j = 0; j < ((Object[])object).length; ++j) {
                        if (!"UnMapped".equals(((Object[])object)[j])) {
                            ++paramValueCt;
                            continue;
                        }
                        ++unMappedCt;
                    }
                    continue;
                }
                if (!"UnMapped".equals(object)) {
                    ++paramValueCt;
                    continue;
                }
                ++unMappedCt;
            }
        }
        if (formulaParams != null) {
            for (int i = 0; i < formulaParams.size(); ++i) {
                object = formulaParams.elementAt(i);
                if (object instanceof Object[]) {
                    paramValueCt += ((Object[])object).length;
                    continue;
                }
                ++paramValueCt;
            }
        }
        if (this.promptParamValue && !this.useDefaults && !isEntpServer && paramCt > 0 && paramValueCt < paramCt) {
            EnterParamDialog dialog = null;
            if (this.dbInfo != null && this.dbInfo instanceof QueryFileInfo) {
                QueryFileInfo queryFileInfo = (QueryFileInfo)this.dbInfo;
                if (unMappedCt > 0 || report.rootNode != null && containsSubReportParam) {
                    QueryInParam[] queryInParam = queryFileInfo.getInSet().getParameter();
                    if (report.isPrevParamPrompt) {
                        QueryInParam[][] paramInPromptSequence = new QueryInParam[paramCt][paramCt];
                        OrderedParameterSet ops = report.getParametersInSequence(report.currentNode, true);
                        for (int i = 0; i < ops.getOrderCount(); ++i) {
                            for (int j = 0; j < ops.getParamsAt(i).size(); ++j) {
                                for (QueryInParam element : queryInParam) {
                                    if (!element.getParamName().equals(ops.get(i, j).name())) continue;
                                    paramInPromptSequence[i][j] = element;
                                }
                            }
                        }
                        DBInfoBasic newDBInfo = this.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.dbInfo.getJNDIName(), this.dbInfo.getQuery(), this.dbInfo.getEnvProperties()) : new DBInfoBasic(this.dbInfo.getURLString(), this.dbInfo.getDriverName(), this.dbInfo.getUserID(), this.dbInfo.getPassword(), this.dbInfo.getQuery());
                        QueryFileInfo qfi = new QueryFileInfo(queryFileInfo.getProductName(), queryFileInfo.getVersion(), newDBInfo, new QueryInParamSet(queryInParam, paramInPromptSequence));
                        report.dbInfo = qfi;
                        if (containsSubReportParam) {
                            Vector<Parameter> ps = report.getQueryParameters();
                            if (report.currentNode.getColumnMapping() != null && report.currentNode.getColumnMapping().length > 0) {
                                int[] ddmap = report.currentNode.getColumnMapping();
                                for (int i = 0; i < ddmap.length; ++i) {
                                    Report[] subs;
                                    Parameter mainParam;
                                    if (ddmap[i] == -1 || ps.get(i) == null || (mainParam = ps.get(i)).getReferenceDegree() <= 0) continue;
                                    for (Report sub : subs = report.getSubReportArray(true)) {
                                        IQueryInParam qip = new ParamUtil().findSharedParamsInSubReport("MAIN_REPORT", mainParam, sub);
                                        if (qip == null) continue;
                                        if (mainParam.isMultiValueParam && qip instanceof IQueryMultiValueInParam) {
                                            ((IQueryMultiValueInParam)qip).setValues(mainParam.getValues());
                                            continue;
                                        }
                                        qip.setValue(mainParam.getValue());
                                    }
                                }
                            }
                        }
                        dialog = QueryFileInfo.getParentDialog() != null ? new EnterParamDialog(QueryFileInfo.getParentDialog(), report, queryFileInfo, formulaParameters, 1, true, null, null, true) : new EnterParamDialog(QueryFileInfo.getParentFrame(), report, queryFileInfo, formulaParameters, 1, true, null, null);
                        report.dbInfo = this.dbInfo;
                    } else if (params != null) {
                        for (int i = 0; i < ((Object[])params.elementAt(0)).length; ++i) {
                            if (!"UnMapped".equals(((Object[])params.elementAt(0))[i]) || !"UnMapped".equals(queryInParam[i].getValue())) continue;
                            queryInParam[i].setValue(queryInParam[i].getDefaultValue(queryFileInfo));
                        }
                    }
                } else {
                    dialog = QueryFileInfo.getParentDialog() != null ? new EnterParamDialog(QueryFileInfo.getParentDialog(), report, queryFileInfo, formulaParameters, true) : new EnterParamDialog(QueryFileInfo.getParentFrame(), report, queryFileInfo, formulaParameters, true);
                }
            } else {
                dialog = QueryFileInfo.getParentDialog() != null ? new EnterParamDialog(QueryFileInfo.getParentDialog(), report, null, formulaParameters, true) : new EnterParamDialog(QueryFileInfo.getParentFrame(), report, null, formulaParameters, true);
            }
            if (dialog != null) {
                dialog.setVisible(true);
                if (dialog.isCancelled()) {
                    return null;
                }
                if (dialog.queryParamHasChanged() || unMappedCt > 0) {
                    report = ReloadReport.reloadData(report, true, null, 0, -1);
                    report.setInitializeReportError(this.errorMessage);
                    return report;
                }
            }
        } else if (unMappedCt > 0) {
            QueryFileInfo queryFileInfo = (QueryFileInfo)report.dbInfo;
            QueryInParam[] queryInParam = queryFileInfo.getInSet().getParameter();
            if (params != null) {
                for (int i = 0; i < ((Object[])params.elementAt(0)).length; ++i) {
                    if (!"UnMapped".equals(((Object[])params.elementAt(0))[i]) || !"UnMapped".equals(queryInParam[i].getValue())) continue;
                    queryInParam[i].setValue(queryInParam[i].getDefaultValue(queryFileInfo));
                }
            }
            report = ReloadReport.reloadData(report, true, null, 0, -1);
            report.setInitializeReportError(this.errorMessage);
            return report;
        }
        report.mergeSubFilesTable(this.subFilesTable);
        if (report.getTableOfContentsObject() != null) {
            report.getTableOfContentsObject().setReport(report);
        }
        report.setSnapToGrid(snapToGrid, gridStepSize, cmGridStepSize);
        report.setAdjustFont(isAdjustFont);
        report.setPackedSubReportByteArray(this.subReports);
        ReportTable tbl = report.getReportTables().elementAt(0);
        for (int j = 0; j < tbl.getColumnCount(); ++j) {
            if (!report.colInfo[report.getColInfoIndex(tbl.getColumn(j))].isColumnBreak() || tbl.getColumn(j).getDrillDownName() != null) continue;
            tbl.getColumn(j).setDrillDownName(report.colInfo[report.getColInfoIndex(tbl.getColumn(j))].getDrillDownName());
        }
        report.setInitializeReportError(this.errorMessage);
        return report;
    }

    private ReportTable createTable(int reportType, DataInput in, int version) throws Exception {
        switch (reportType) {
            case 0: 
            case 4: {
                return ReportTable.createTable(in, version, this.isPacked, this.fromReportDesigner, this.subFilesTable, this.relativeDomainPath);
            }
            case 1: 
            case 3: {
                return ReportMultiSectionTable.createMultiSectionTable(in, version, this.isPacked, this.fromReportDesigner, this.subFilesTable, this.relativeDomainPath);
            }
            case 2: {
                return CrossTabTable.createMultiSectionTable(in, version, this.isPacked, this.fromReportDesigner, this.subFilesTable, this.relativeDomainPath);
            }
        }
        return null;
    }

    private ColData[] createColData(DataInput in, int version) throws IOException {
        int i;
        byte[] encrypb = new byte[in.readInt()];
        in.readFully(encrypb, 0, encrypb.length);
        DataInputStream newin = new DataInputStream(new ByteArrayInputStream(IOUtil.decode(encrypb)));
        int nCol = newin.readInt();
        int nRow = newin.readInt();
        ColData[] colData = new ColData[nCol + 1];
        for (i = 0; i < nCol; ++i) {
            String name = IOUtil.readString(newin, true);
            int dtype = newin.readInt();
            colData[i] = new ColData(name, dtype, nRow, colData.length);
            for (int j = 0; j < nRow; ++j) {
                colData[i].add(DataType.read(newin, dtype, version, true));
            }
        }
        colData[nCol] = new ColData("qbCount", 4, colData.length);
        for (i = 0; i < nRow; ++i) {
            colData[nCol].add(i);
        }
        return colData;
    }

    private void loadColDataAttr(DataInput in, ColData[] colData) throws IOException {
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            int type = in.readInt();
            IFormat format = FormatUtil.readDataFormat(in, this.version);
            if (colData == null || i >= colData.length || colData[i].getOriginalDataType() != type) continue;
            colData[i].dataFormat = format;
        }
    }

    protected void loadTree(DataInput in) throws IOException {
        boolean existed = in.readBoolean();
        if (!existed) {
            this.drillDownNode = null;
            return;
        }
        this.drillDownNode = this.loadTreeNode(in, true);
    }

    private DrillDownNode loadTreeNode(DataInput in, boolean loadChildren) throws IOException {
        int i;
        DrillDownNode node = new DrillDownNode(IOUtil.readString(in, true));
        node.setDomainPath(this.relativeDomainPath);
        String filename = IOUtil.readString(in, true);
        node.setFileName(filename);
        if (this.drillDownReportTable != null) {
            node.setByteArray(this.drillDownReportTable.get(node.getFileName()));
        }
        int count = in.readInt();
        int[] mapping = new int[count];
        for (i = 0; i < count; ++i) {
            mapping[i] = in.readInt();
        }
        node.setColumnMapping(mapping);
        if (this.version >= 203) {
            node.setCrossTabDrillDown(in.readBoolean());
        }
        if (loadChildren) {
            count = in.readInt();
            for (i = 0; i < count; ++i) {
                node.add(this.loadTreeNode(in, true));
            }
        }
        return node;
    }

    protected void loadDrillDownTreeByteArrays(DataInput in) throws Exception {
        boolean existed = in.readBoolean();
        if (!existed) {
            this.drillDownNode = null;
            return;
        }
        this.drillDownNode = this.loadDrillDownNodeByteArray(in, true);
    }

    private DrillDownNode loadDrillDownNodeByteArray(DataInput in, boolean loadChildren) throws Exception {
        int i;
        int count;
        DrillDownNode node = new DrillDownNode(IOUtil.readString(in, true));
        node.setDomainPath(this.relativeDomainPath);
        node.setFileName(SaveReport.getPakPath(IOUtil.readString(in, true)));
        boolean hasByteArray = in.readBoolean();
        if (hasByteArray) {
            count = in.readInt();
            byte[] barray = new byte[count];
            in.readFully(barray);
            String fNameKey = node.getFileName();
            if (SaveReport.isPAKFile(fNameKey) && !this.subFilesTable.containsKey(fNameKey)) {
                this.subFilesTable.put(fNameKey, barray);
            }
        }
        count = in.readInt();
        int[] mapping = new int[count];
        for (i = 0; i < count; ++i) {
            mapping[i] = in.readInt();
        }
        node.setColumnMapping(mapping);
        if (this.version >= 203) {
            node.setCrossTabDrillDown(in.readBoolean());
        }
        if (loadChildren) {
            count = in.readInt();
            for (i = 0; i < count; ++i) {
                node.add(this.loadDrillDownNodeByteArray(in, true));
            }
        }
        return node;
    }

    protected void loadSubReports(DataInput in) throws IOException {
        boolean existed = in.readBoolean();
        if (!existed) {
            return;
        }
        this.subReports = new Vector();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            try {
                SubReportObject sro = SubReportObject.createSubReportObject(in, this.version);
                sro.setDomainPath(this.relativeDomainPath);
                this.subReports.addElement(sro);
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Can't process sub-report objects", ex);
                throw new IOException(ex.getMessage());
            }
        }
    }

    protected void loadSubReportsByteArrays(DataInput in) throws IOException {
        boolean existed = in.readBoolean();
        if (!existed) {
            return;
        }
        this.subReports = new Vector();
        int count = in.readInt();
        LOGGER.finest("LoadReport, subreport count: " + count);
        for (int i = 0; i < count; ++i) {
            try {
                SubReportObject sro = SubReportObject.createSubReportObject(in, this.version, true, this.fromReportDesigner, this.subFilesTable, false, this.relativeDomainPath);
                this.subReports.addElement(sro);
                LoadReport loadReport = new LoadReport(this.fromReportDesigner);
                loadReport.setRelativeDomainPath(sro.getDomainPath());
                loadReport.setBackupDataUsed(true);
                loadReport.subFilesTable = this.subFilesTable;
                if (this.fromReportDesigner) {
                    if (this.isPacked) {
                        loadReport.loadReportFromByteArray(sro.getByteArray());
                        continue;
                    }
                    loadReport.loadReportFromFile(sro.getFileName());
                    continue;
                }
                loadReport.loadReportFromByteArray(sro.getByteArray());
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Can't process sub-report objects", ex);
                this.errorMessage = ex.getMessage();
                throw new IOException(ex.getMessage());
            }
        }
    }

    public DrillDownNode getDrillDownNode() {
        return this.drillDownNode;
    }

    public Vector<SubReportObject> getSubReports() {
        return this.subReports;
    }

    public int getSourceDataType() {
        return this.sourceData;
    }

    public DBInfoBasic getDBInfo() {
        return this.dbInfo;
    }

    private void readDrillDownNodes(DataInput in, int version, boolean isPacked) throws Exception {
        boolean existed = in.readBoolean();
        if (!existed) {
            this.childDrillDownNodes = null;
        } else {
            this.childDrillDownNodes = new Vector();
            int count = in.readInt();
            for (int i = 0; i < count; ++i) {
                if ((version >= 148 && version < 160 || version >= 167) && isPacked) {
                    this.childDrillDownNodes.addElement(this.loadDrillDownNodeByteArray(in, false));
                    continue;
                }
                this.childDrillDownNodes.addElement(this.loadTreeNode(in, false));
            }
        }
    }

    public Vector<DrillDownNode> getChildNodes() {
        return this.childDrillDownNodes;
    }

    public static String generateFullName(String file) {
        String fullname = null;
        if (file == null) {
            return null;
        }
        if (!(SaveReport.isRPTFile(file) || SaveReport.isXMLFile(file) || SaveReport.isPAKFile(file) || SaveReport.isQRPFile(file))) {
            FileInfo fInfo = new FileInfo(file + ".xml");
            try {
                if (fInfo.exists()) {
                    fullname = file + ".xml";
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Can't determine file extension (checking for .xml failed)", ex);
            }
            fInfo = new FileInfo(file + ".pak");
            try {
                if (fInfo.exists()) {
                    fullname = file + ".pak";
                    return fullname;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Can't determine file extension (checking for .pak failed)", ex);
            }
            fInfo = new FileInfo(file + ".rpt");
            try {
                if (fInfo.exists() || fullname == null) {
                    fullname = file + ".pak";
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Can't determine file extension (checking for .xml failed), using .pak anyway", ex);
                fullname = file + ".pak";
            }
            return fullname;
        }
        return file;
    }

    public int getVersion() {
        return this.version;
    }

    private boolean containsParameterInSubReport(Report report) {
        Vector<Param> vec = report.getNonSharedAvailableSubReportParamsAsParam(this.usingBackupData);
        return vec != null && vec.size() > 0;
    }

    public void setDrillDownReportTable(Hashtable<String, byte[]> rptTable) {
        this.drillDownReportTable = rptTable;
    }

    public ColData[] loadColData(String fName) throws Exception {
        ReadDataFile readfile = new ReadDataFile();
        DataInputStream in = readfile.getInputStream(this.subFilesTable, fName, this.readOnly);
        ColData[] colData = this.createColData(in, 7004);
        this.loadColDataAttr(in, colData);
        in.close();
        readfile.close();
        return colData;
    }

    public void setRelativeDomainPath(String path) {
        this.relativeDomainPath = path;
    }

    public void setShowWarningDialog(boolean state) {
        this.showWarningDialog = state;
    }

    public boolean getShowWarningDialog() {
        return this.showWarningDialog;
    }

    public void setNodeForUnmappedDrillDown(DrillDownNode node) {
        this.nodeForUnmappedDrillDown = node;
    }

    public void setLoadNewOnly(boolean b) {
        this.loadNewOnly = b;
    }

    public boolean getLoadNewOnly() {
        return this.loadNewOnly;
    }

    public Hashtable<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Hashtable<String, String> environment) {
        this.environment = environment;
    }

    public Hashtable<String, String> getFontMapping() {
        return this.fontMapping;
    }

    public void setFontMapping(Hashtable<String, String> fontMapping) {
        this.fontMapping = fontMapping;
    }

    public Vector getParameters() {
        return this.parameters;
    }

    public void setParameters(Vector parameters) {
        this.parameters = parameters;
    }
}

