/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTitle;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.util.ColInfo;

public class LoadReportStyle {
    int version;
    String filename;

    public Report loadReportFromFile(String urlname) throws Exception {
        ReadDataFile readfile = new ReadDataFile();
        Report newreport = this.loadReport(readfile.getInputStream(null, urlname));
        readfile.close();
        return newreport;
    }

    public Report loadReport(DataInputStream in) throws Exception {
        return this.loadData(in);
    }

    private Report loadData(DataInput in) throws Exception {
        boolean hasImage;
        this.version = in.readInt();
        ColData[] colData = this.createColData(in, this.version);
        ColInfo[] colInfo = new ColInfo[in.readInt()];
        for (int i = 0; i < colInfo.length; ++i) {
            colInfo[i] = ColInfo.read(in, this.version);
        }
        int reportType = in.readInt();
        Report report = new Report(colData);
        report.createTable(reportType, colInfo);
        ReportSection pageHeader = new ReportSection();
        pageHeader.readSTL(in, this.version);
        ReportSection reportHeader = new ReportSection();
        reportHeader.readSTL(in, this.version);
        int len = in.readInt();
        ReportTable[] table = new ReportTable[len];
        for (int i = 0; i < len; ++i) {
            table[i] = this.createTable(reportType, in, this.version);
        }
        ReportSection reportFooter = new ReportSection();
        reportFooter.readSTL(in, this.version);
        ReportSection pageFooter = new ReportSection();
        pageFooter.readSTL(in, this.version);
        Vector<ReportElement> temp = new Vector<ReportElement>();
        ReportCell labelSetting = ReportCell.createCell(in, this.version);
        ReportChartObject chartSetting = ReportChartObject.createChartObject(in, this.version);
        ReportImage imageSetting = ReportImage.createImage(in, this.version);
        temp.addElement(labelSetting);
        temp.addElement(chartSetting);
        temp.addElement(imageSetting);
        ReportCell stringFormulaSetting = ReportCell.createCell(in, this.version);
        ReportCell logicFormulaSetting = ReportCell.createCell(in, this.version);
        ReportCell numericFormulaSetting = ReportCell.createCell(in, this.version);
        ReportCell timeFormulaSetting = ReportCell.createCell(in, this.version);
        temp.addElement(stringFormulaSetting);
        temp.addElement(logicFormulaSetting);
        temp.addElement(numericFormulaSetting);
        temp.addElement(timeFormulaSetting);
        ReportColumn stringColumnSetting = ReportColumn.createColumn(in, this.version);
        ReportColumn logicColumnSetting = ReportColumn.createColumn(in, this.version);
        ReportColumn numericColumnSetting = ReportColumn.createColumn(in, this.version);
        ReportColumn timeColumnSetting = ReportColumn.createColumn(in, this.version);
        ReportColumn barcodeColumnSetting = ReportColumn.createColumn(in, this.version);
        temp.addElement(stringColumnSetting);
        temp.addElement(logicColumnSetting);
        temp.addElement(numericColumnSetting);
        temp.addElement(timeColumnSetting);
        temp.addElement(barcodeColumnSetting);
        ReportLine lineSetting = ReportLine.createLine(in, this.version);
        ReportGrid gridSetting = ReportGrid.createGrid(in, this.version);
        ColumnHeader columnHeaderSetting = ColumnHeader.createColumnHeader(in, this.version);
        ReportTitle titleSetting = ReportTitle.createReportTitle(in, this.version);
        temp.addElement(lineSetting);
        temp.addElement(gridSetting);
        temp.addElement(columnHeaderSetting);
        temp.addElement(titleSetting);
        report.setSetting(temp);
        report.applyStyle(report);
        report.getReportHeader().loadStyle(report, reportHeader);
        report.getPageHeader().loadStyle(report, pageHeader);
        ReportTable originalTable = report.getReportTables().elementAt(0);
        ReportTable styleTable = table[0];
        originalTable.loadStyle(report, styleTable);
        report.getPageFooter().loadStyle(report, pageFooter);
        report.getReportFooter().loadStyle(report, reportFooter);
        if (this.version >= 285) {
            report.setBackgroundColor(IOUtil.readColor(in));
        }
        if (this.version >= 285 && (hasImage = in.readBoolean())) {
            report.setBackgroundImage(ReportImage.createImage(in, this.version, true, null));
        }
        return report;
    }

    private ReportTable createTable(int reportType, DataInput in, int version) throws Exception {
        switch (reportType) {
            case 0: 
            case 4: {
                ReportTable table = new ReportTable();
                table.readSTL(in, version);
                return table;
            }
            case 1: 
            case 2: 
            case 3: {
                ReportMultiSectionTable mtable = new ReportMultiSectionTable();
                mtable.readSTL(in, version);
                return mtable;
            }
        }
        return null;
    }

    private ColData[] createColData(DataInput in, int version) throws IOException {
        int i;
        byte[] encrypb = new byte[in.readInt()];
        in.readFully(encrypb, 0, encrypb.length);
        DataInputStream newin = new DataInputStream(new ByteArrayInputStream(IOUtil.decode(encrypb)));
        int nCol = newin.readInt();
        int nRow = newin.readInt();
        ColData[] colData = new ColData[nCol + 1];
        for (i = 0; i < nCol; ++i) {
            String name = IOUtil.readString(newin, true);
            int dtype = newin.readInt();
            colData[i] = new ColData(name, dtype, nRow, colData.length);
            for (int j = 0; j < nRow; ++j) {
                colData[i].add(DataType.read(newin, dtype, version, true));
            }
        }
        colData[nCol] = new ColData("qbCount", 4, colData.length);
        for (i = 0; i < nRow; ++i) {
            colData[nCol].add(i);
        }
        return colData;
    }
}

