/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.ColInfo;

public class LoadXMLReport {
    private static final Logger LOGGER = Logger.getLogger(LoadXMLReport.class.getName());
    protected DBInfoBasic dbInfo;
    protected String filename = null;
    protected int version;
    protected String registryID;
    protected String dataSourceID;
    protected String dataSourceLoc;
    protected Vector parameters;
    protected int sourceData;
    protected int originalSourceData = -1;
    String sourceFile;
    XMLFileQueryInfo xmlFileQueryInfo;
    SalesForceQueryFileInfo sfQueryInfo;
    SOAPQueryFileInfo soapInfo;
    ExcelFileInfo excelInfo;
    String jndiName;
    String homeName;
    String remoteName;
    String selectedMethodName;
    Object[] selectedMethodParamVal;
    private Hashtable<String, String> environment;
    String mondrianConnectionString;
    String MDXQuery;
    String xmlaURI;
    String xmlaDataSource;
    String xmlaCatalog;
    private Hashtable<String, String> fontMapping;
    ColData[] originalColDataFromMemSource;
    ColInfo[] colInfo;
    boolean retrieveColInfoOnly;
    Object[] sourceList;
    int[] sourceType;
    boolean[] doTranspose;
    Object[] transposeColList;
    boolean isTransposed = false;
    boolean[] transposeCol = null;
    String queryFilename;
    QueryFileInfo queryFileInfo;
    String[] modDataSourceArr;
    Boolean modTranspose;
    boolean[] modTransposeCol;
    boolean[] modTransposeArr;
    Object[] modTransposeColArr;
    boolean isDesignerDesignMode;
    protected DrillDownNode drillDownNode = null;
    protected Vector<SubReportObject> subReports = null;
    protected Vector childDrillDownNodes = null;
    protected boolean inServer = false;
    LoadXMLReportHelper helper = null;
    protected boolean useDefaults = false;
    protected boolean applyFormula = false;
    protected boolean usingBackupData = false;
    protected boolean isEntServer = false;
    private boolean fromReportDesigner = false;
    protected String securityLevel = null;
    protected boolean copyEmptySection = true;
    String errorMessage = null;
    protected boolean saveAllData = false;

    public LoadXMLReport() {
    }

    public LoadXMLReport(boolean fromReportDesigner) {
        this.fromReportDesigner = fromReportDesigner;
    }

    public void setSecurityLevel(String level) {
        this.securityLevel = level;
    }

    public void setCopyEmptySection(boolean b) {
        this.copyEmptySection = b;
    }

    public Report loadReportFromFile(String urlname) throws Exception {
        return this.loadReportFromFile(urlname, null);
    }

    public Report loadReportFromFile(String urlname, Vector<QueryInParamSet> params) throws Exception {
        return this.loadReportFromFile(urlname, params, this.isEntServer);
    }

    public Report loadReportFromFile(String urlname, Vector<QueryInParamSet> params, boolean isEntServer) throws Exception {
        return this.loadReportFromFile(urlname, params, isEntServer, !this.fromReportDesigner);
    }

    public Report loadReportFromFile(String urlname, Vector<QueryInParamSet> params, boolean isEntServer, boolean promptParamValue) throws Exception {
        return this.loadReportFromFile(urlname, params, null, isEntServer, promptParamValue);
    }

    public Report loadReportFromFile(String urlname, Vector<QueryInParamSet> params, Vector formulaParams, boolean isEntServer, boolean promptParamValue) throws Exception {
        if (!urlname.toUpperCase().endsWith(".XML")) {
            urlname = urlname + ".xml";
        }
        this.filename = urlname;
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            ReadDataFile readfile = new ReadDataFile();
            Report newreport = null;
            this.helper = new LoadXMLReportHelper(this);
            this.helper.promptParamValue = promptParamValue;
            newreport = this.helper.loadReport(readfile.getInputStream(null, urlname), params, formulaParams, isEntServer);
            if (newreport != null) {
                newreport.saveAllData = this.helper.isSaveAllData();
            }
            readfile.close();
            return newreport;
        }
        return this.loadReportFromServer(urlname, params, formulaParams, isEntServer, promptParamValue);
    }

    private Report loadReportFromServer(String file, Vector<QueryInParamSet> params, Vector formulaParams, boolean isEntServer, boolean promptParamValue) throws Exception {
        DataInputStream in = this.getInputStreamFromServer(file);
        LoadReport lr = new LoadReport(this.fromReportDesigner);
        lr.setSecurityLevel(this.securityLevel);
        lr.setBackupDataUsed(this.usingBackupData);
        lr.setCopyEmptySection(this.copyEmptySection);
        lr.useDefaults = this.useDefaults;
        lr.retrieveColInfoOnly = this.retrieveColInfoOnly;
        lr.promptParamValue = promptParamValue;
        lr.setDesignerDesignMode(this.isDesignerDesignMode);
        Report report = lr.loadReport(in, params, formulaParams, isEntServer);
        this.dbInfo = lr.dbInfo;
        this.colInfo = lr.colInfo;
        this.version = lr.version;
        this.parameters = lr.getParameters();
        this.sourceData = lr.getSourceDataType();
        this.sourceFile = lr.sourceFile;
        this.xmlFileQueryInfo = lr.xmlFileQueryInfo;
        this.sfQueryInfo = lr.sfQueryInfo;
        this.soapInfo = lr.soapInfo;
        this.excelInfo = lr.excelInfo;
        this.jndiName = lr.jndiName;
        this.homeName = lr.homeName;
        this.remoteName = lr.remoteName;
        this.selectedMethodName = lr.selectedMethodName;
        this.selectedMethodParamVal = lr.selectedMethodParamVal;
        this.setEnvironment(lr.getEnvironment());
        this.setFontMapping(lr.getFontMapping());
        this.mondrianConnectionString = lr.mondrianConnectionString;
        this.MDXQuery = lr.MDXQuery;
        this.xmlaURI = lr.xmlaURI;
        this.xmlaDataSource = lr.xmlaDataSource;
        this.xmlaCatalog = lr.xmlaCatalog;
        this.originalColDataFromMemSource = lr.originalColDataFromMemSource;
        this.sourceList = lr.sourceList;
        this.sourceType = lr.sourceType;
        this.doTranspose = lr.doTranspose;
        this.transposeColList = lr.transposeColList;
        this.isTransposed = lr.isTransposed;
        this.transposeCol = lr.transposeCol;
        this.queryFilename = lr.queryFilename;
        this.queryFileInfo = lr.queryFileInfo;
        this.modDataSourceArr = lr.modDataSourceArr;
        this.modTranspose = lr.modTranspose;
        this.modTransposeCol = lr.modTransposeCol;
        this.modTransposeArr = lr.modTransposeArr;
        this.modTransposeColArr = lr.modTransposeColArr;
        this.drillDownNode = lr.getDrillDownNode();
        this.subReports = lr.getSubReports();
        return report;
    }

    public Report loadTemplateFromFile(String templatename, Report report) throws Exception {
        return this.loadTemplateFromFile(templatename, false, report);
    }

    public Report loadTemplateFromFile(String templatename, boolean applyFormula, Report report) throws Exception {
        if (!templatename.toUpperCase().endsWith(".XML")) {
            templatename = templatename + ".xml";
        }
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            ReadDataFile readfile = new ReadDataFile();
            Report newreport = null;
            this.helper = new LoadXMLReportHelper(this);
            newreport = this.helper.loadTemplate(report, readfile.getInputStream(null, templatename, true), applyFormula);
            readfile.close();
            return newreport;
        }
        return this.loadTemplateFromServer(templatename, report);
    }

    public void setDesignerDesignMode(boolean b) {
        this.isDesignerDesignMode = b;
    }

    public Report loadTemplateFromByteArray(byte[] data, Report report) throws Exception {
        Report newreport = null;
        if (!(!ServerMessage.useServer && ServerMessage.isLoadBalancer || IOUtil.isXMLIncluded())) {
            return this.loadTemplateFromServer(data, report);
        }
        this.helper = new LoadXMLReportHelper(this);
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(in);
        newreport = this.helper.loadTemplate(report, din);
        din.close();
        in.close();
        return newreport;
    }

    public void setBackupDataUsed(boolean b) {
        this.usingBackupData = b;
    }

    public boolean isBackupDataUsed() {
        return this.usingBackupData;
    }

    public DrillDownNode getDrillDownNode() {
        if (this.helper == null) {
            return this.drillDownNode;
        }
        return this.helper.getDrillDownNode();
    }

    public Vector<SubReportObject> getSubReports() {
        if (this.helper == null) {
            return this.subReports;
        }
        return this.helper.getSubReports();
    }

    public int getSourceDataType() {
        if (this.helper == null) {
            return this.sourceData;
        }
        return this.helper.getSourceDataType();
    }

    public int getOriginalSourceDataType() {
        if (this.helper == null) {
            return this.originalSourceData;
        }
        return this.helper.getOriginalSourceDataType();
    }

    public DBInfoBasic getDBInfo() {
        if (this.helper == null) {
            return this.dbInfo;
        }
        return this.helper.getDBInfo();
    }

    public Vector getChildNodes() {
        if (this.helper == null) {
            return this.childDrillDownNodes;
        }
        return this.helper.getChildNodes();
    }

    private Report loadTemplateFromServer(String file, Report report) throws Exception {
        DataInputStream in = this.getInputStreamFromServer(file);
        LoadReport loadReport = new LoadReport(this.fromReportDesigner);
        loadReport.setCopyEmptySection(this.copyEmptySection);
        return loadReport.loadTemplate(report, in);
    }

    private Report loadTemplateFromServer(byte[] data, Report report) throws Exception {
        DataInputStream in = this.getInputStreamFromServer(data);
        LoadReport loadReport = new LoadReport(this.fromReportDesigner);
        loadReport.setCopyEmptySection(this.copyEmptySection);
        return loadReport.loadTemplate(report, in);
    }

    private DataInputStream getInputStreamFromServer(String file) throws Exception {
        byte[] indata;
        file = file.replace('\\', '/');
        IConnection socket = ServerMessage.createConnection();
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(25578);
        dout.writeBoolean(false);
        IOUtil.writeString(dout, file);
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to send data", ex);
            socket.close();
            throw ex;
        }
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int len = dstream.readInt();
            indata = new byte[len];
            dstream.readFully(indata, 0, len);
            dstream.close();
            socket.close();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot read data", ex);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
            }
            throw ex;
        }
        catch (Error err) {
            LOGGER.log(Level.FINEST, "Cannot read data", err);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
            }
            throw new Exception(err.getMessage());
        }
        return new DataInputStream(new ByteArrayInputStream(indata));
    }

    public DataInputStream getInputStreamFromServer(byte[] data) throws Exception {
        byte[] indata;
        IConnection socket = ServerMessage.createConnection();
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(25993);
        dout.writeInt(data.length);
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length + data.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().write(data);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Error sending data", ex);
            socket.close();
            throw ex;
        }
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int len = dstream.readInt();
            indata = new byte[len];
            dstream.readFully(indata, 0, len);
            dstream.close();
            socket.close();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to read data", ex);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
            }
            throw ex;
        }
        catch (Error err) {
            LOGGER.log(Level.FINEST, "Failed to read data", err);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
            }
            throw new Exception(err.getMessage());
        }
        return new DataInputStream(new ByteArrayInputStream(indata));
    }

    public void setInServer(boolean state) {
        this.inServer = state;
    }

    public String getFullFilename() {
        return this.filename;
    }

    public Hashtable<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Hashtable<String, String> environment) {
        this.environment = environment;
    }

    public Hashtable<String, String> getFontMapping() {
        return this.fontMapping;
    }

    public void setFontMapping(Hashtable<String, String> fontMapping) {
        this.fontMapping = fontMapping;
    }

    public boolean isSaveAllData() {
        return this.saveAllData;
    }

    public void setSaveAllData(boolean saveAllData) {
        this.saveAllData = saveAllData;
    }
}

