/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.param.ParameterGrabber;
import quadbase.common.paramquery.EnterParamDialog;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.EJBUtil;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTitle;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.CrossTabTable;
import quadbase.reportdesigner.report.DBAccess;
import quadbase.reportdesigner.report.DataFileInput;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.EJBAccess;
import quadbase.reportdesigner.report.ExcelAccess;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.LoadXMLReport;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.OLAPAccess;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.report.SOAPAccess;
import quadbase.reportdesigner.report.SalesForceAccess;
import quadbase.reportdesigner.report.SaveReport;
import quadbase.reportdesigner.report.Script;
import quadbase.reportdesigner.report.TokenMgrError;
import quadbase.reportdesigner.report.TransformQuery;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class LoadXMLReportHelper
extends LoadXMLReport {
    private static final Logger LOGGER = Logger.getLogger(LoadXMLReportHelper.class.getName());
    protected boolean promptParamValue = false;

    public LoadXMLReportHelper(LoadXMLReport loadReport) {
        this.dbInfo = loadReport.dbInfo;
        this.filename = loadReport.filename;
        this.version = loadReport.version;
        this.parameters = loadReport.parameters;
        this.sourceData = loadReport.sourceData;
        this.originalSourceData = loadReport.originalSourceData;
        this.sourceFile = loadReport.sourceFile;
        this.xmlFileQueryInfo = loadReport.xmlFileQueryInfo;
        this.sfQueryInfo = loadReport.sfQueryInfo;
        this.soapInfo = loadReport.soapInfo;
        this.jndiName = loadReport.jndiName;
        this.homeName = loadReport.homeName;
        this.remoteName = loadReport.remoteName;
        this.selectedMethodName = loadReport.selectedMethodName;
        this.selectedMethodParamVal = loadReport.selectedMethodParamVal;
        this.setEnvironment(loadReport.getEnvironment());
        this.mondrianConnectionString = loadReport.mondrianConnectionString;
        this.MDXQuery = loadReport.MDXQuery;
        this.xmlaURI = loadReport.xmlaURI;
        this.xmlaDataSource = loadReport.xmlaDataSource;
        this.xmlaCatalog = loadReport.xmlaCatalog;
        this.setFontMapping(loadReport.getFontMapping());
        this.originalColDataFromMemSource = loadReport.originalColDataFromMemSource;
        this.sourceList = loadReport.sourceList;
        this.sourceType = loadReport.sourceType;
        this.doTranspose = loadReport.doTranspose;
        this.transposeColList = loadReport.transposeColList;
        this.isTransposed = loadReport.isTransposed;
        this.transposeCol = loadReport.transposeCol;
        this.queryFilename = loadReport.queryFilename;
        this.queryFileInfo = loadReport.queryFileInfo;
        this.modDataSourceArr = loadReport.modDataSourceArr;
        this.modTranspose = loadReport.modTranspose;
        this.modTransposeCol = loadReport.modTransposeCol;
        this.modTransposeArr = loadReport.modTransposeArr;
        this.modTransposeColArr = loadReport.modTransposeColArr;
        this.drillDownNode = loadReport.drillDownNode;
        this.subReports = loadReport.subReports;
        this.childDrillDownNodes = loadReport.childDrillDownNodes;
        this.isDesignerDesignMode = loadReport.isDesignerDesignMode;
        this.inServer = loadReport.inServer;
        this.applyFormula = loadReport.applyFormula;
        this.usingBackupData = loadReport.usingBackupData;
        if (this.usingBackupData) {
            this.promptParamValue = false;
        }
        this.retrieveColInfoOnly = loadReport.retrieveColInfoOnly;
        this.setSecurityLevel(loadReport.securityLevel);
        this.setCopyEmptySection(loadReport.copyEmptySection);
    }

    @Override
    public Report loadReportFromFile(String urlname) throws Exception {
        return this.loadReportFromFile(urlname, null);
    }

    @Override
    public Report loadReportFromFile(String urlname, Vector<QueryInParamSet> params) throws Exception {
        if (!urlname.toUpperCase().endsWith(".XML")) {
            urlname = urlname + ".xml";
        }
        this.filename = urlname;
        ReadDataFile readfile = new ReadDataFile();
        Report newreport = null;
        newreport = this.loadReport(readfile.getInputStream(null, urlname), params);
        readfile.close();
        return newreport;
    }

    @Override
    public Report loadTemplateFromFile(String templatename, Report report) throws Exception {
        return this.loadTemplateFromFile(templatename, false, report);
    }

    @Override
    public Report loadTemplateFromFile(String templatename, boolean applyFormula, Report report) throws Exception {
        if (!templatename.toUpperCase().endsWith(".xml")) {
            templatename = templatename + ".xml";
        }
        ReadDataFile readfile = new ReadDataFile();
        Report newreport = null;
        newreport = this.loadTemplate(report, readfile.getInputStream(null, templatename, true), applyFormula);
        readfile.close();
        return newreport;
    }

    public Report loadTemplate(Report report, DataInputStream in) throws Exception {
        return this.loadData(in, report.colData, report, true, null, null, false);
    }

    public Report loadTemplate(Report report, DataInputStream in, boolean applyFormula) throws Exception {
        this.applyFormula = applyFormula;
        return this.loadData(in, report.colData, report, true, null, null, false);
    }

    public Report loadReport(DataInputStream in, Vector params) throws Exception {
        return this.loadReport(in, params, null, false);
    }

    public Report loadReport(DataInputStream in, Vector params, Vector formulaParams, boolean isEntServer) throws Exception {
        return this.loadData(in, null, null, false, params, formulaParams, isEntServer);
    }

    private void loadDataHeader(Vector datasources) throws Exception {
        if (datasources.size() > 1) {
            this.sourceData = 3;
            this.sourceList = new Object[datasources.size()];
            this.sourceType = new int[datasources.size()];
            for (int k = 0; k < datasources.size(); ++k) {
                Node node;
                int i;
                Node node2;
                Node source = (Node)datasources.elementAt(k);
                NamedNodeMap map = source.getAttributes();
                for (int i2 = 0; i2 <= map.getLength(); ++i2) {
                    if (i2 == map.getLength()) {
                        throw new Exception("Missing 'Type' attribute.");
                    }
                    Node node3 = map.item(i2);
                    if (!node3.getNodeName().equalsIgnoreCase("Type")) continue;
                    if (node3.getNodeValue().equalsIgnoreCase("database")) {
                        this.sourceType[k] = 1;
                        break;
                    }
                    if (node3.getNodeValue().equalsIgnoreCase("file")) {
                        this.sourceType[k] = 2;
                        break;
                    }
                    if (node3.getNodeValue().equalsIgnoreCase("xml")) {
                        this.sourceType[k] = 4;
                        break;
                    }
                    if (node3.getNodeValue().equalsIgnoreCase("class")) {
                        this.sourceType[k] = 6;
                        break;
                    }
                    if (node3.getNodeValue().equalsIgnoreCase("xmlfilequery")) {
                        this.sourceType[k] = 7;
                        break;
                    }
                    if (node3.getNodeValue().equalsIgnoreCase("ejb")) {
                        this.sourceType[k] = 5;
                        break;
                    }
                    throw new Exception("Invalid datasource type: '" + node3.getNodeValue() + "'.");
                }
                if (this.sourceType[k] == 1) {
                    NodeList nodeList = source.getChildNodes();
                    DBInfoBasic db = null;
                    for (int i3 = 0; i3 < nodeList.getLength(); ++i3) {
                        node2 = nodeList.item(i3);
                        if (this.dbInfo == null && node2.getNodeName().equalsIgnoreCase("DATABASE") && (db = DBInfoBasic.readXML(node2, this.version)) != null) break;
                    }
                    if (db == null) {
                        throw new Exception("Missing or invalid 'DATABASE' element.");
                    }
                    if (this.modDataSourceArr != null) {
                        db.setQuery(this.modDataSourceArr[k]);
                    }
                    this.sourceList[k] = db;
                    continue;
                }
                if (this.sourceType[k] == 2 || this.sourceType[k] == 4 || this.sourceType[k] == 6) {
                    String file = LoadXMLReportHelper.readCDATA(source);
                    if (this.modDataSourceArr != null) {
                        file = this.modDataSourceArr[k];
                    }
                    this.sourceList[k] = file;
                    continue;
                }
                if (this.sourceType[k] == 7) {
                    NodeList nodeList = source.getChildNodes();
                    XMLFileQueryInfo xmlInfo = null;
                    for (int i4 = 0; i4 < nodeList.getLength(); ++i4) {
                        node2 = nodeList.item(i4);
                        if (xmlInfo != null || !node2.getNodeName().equalsIgnoreCase("XMLFILEQUERYINFO") || (xmlInfo = XMLFileQueryInfo.readXML(node2, this.version)) == null) continue;
                        return;
                    }
                    this.sourceList[k] = xmlInfo;
                    continue;
                }
                if (this.sourceType[k] != 5) continue;
                NamedNodeMap attrMap = source.getAttributes();
                Object[] vals = null;
                String[] paramTypes = null;
                int valSize = 0;
                int envsize = 0;
                String[] envKeys = null;
                String[] envValues = null;
                String thisJNDIName = null;
                String thisHomeName = null;
                String thisRemoteName = null;
                String thisSelectedMethodName = null;
                Object[] thisSelectedMethodParamVal = null;
                Hashtable<String, String> thisEnvironment = null;
                for (i = 0; i < attrMap.getLength(); ++i) {
                    Node node4 = attrMap.item(i);
                    if (node4.getNodeName().equalsIgnoreCase("Type")) {
                        if (node4.getNodeValue().equalsIgnoreCase("ejb")) continue;
                        LOGGER.warning("Wrong data source");
                        continue;
                    }
                    if (node4.getNodeName().equalsIgnoreCase("jndiName")) {
                        thisJNDIName = node4.getNodeValue();
                        continue;
                    }
                    if (node4.getNodeName().equalsIgnoreCase("homeName")) {
                        thisHomeName = node4.getNodeValue();
                        continue;
                    }
                    if (node4.getNodeName().equalsIgnoreCase("remoteName")) {
                        thisRemoteName = node4.getNodeValue();
                        continue;
                    }
                    if (node4.getNodeName().equalsIgnoreCase("selectedMethodName")) {
                        thisSelectedMethodName = node4.getNodeValue();
                        continue;
                    }
                    if (node4.getNodeName().equalsIgnoreCase("paramSize")) {
                        valSize = Integer.parseInt(node4.getNodeValue());
                        if (vals == null) {
                            vals = new Object[valSize];
                        }
                        if (paramTypes != null) continue;
                        paramTypes = new String[valSize];
                        continue;
                    }
                    if (!node4.getNodeName().equalsIgnoreCase("envsize")) continue;
                    envsize = Integer.parseInt(node4.getNodeValue());
                    if (envKeys == null) {
                        envKeys = new String[envsize];
                    }
                    if (envValues != null) continue;
                    envValues = new String[envsize];
                }
                for (i = 0; i < attrMap.getLength(); ++i) {
                    for (int j = 1; j <= valSize; ++j) {
                        node = attrMap.item(i);
                        if (node.getNodeName().equalsIgnoreCase("paramValType_" + j)) {
                            paramTypes[j - 1] = node.getNodeValue();
                            continue;
                        }
                        if (!node.getNodeName().equalsIgnoreCase("paramValValue_" + j)) continue;
                        vals[j - 1] = EJBUtil.getRuntimeInputValue(paramTypes[j - 1], node.getNodeValue());
                    }
                }
                thisSelectedMethodParamVal = vals;
                for (i = 0; i < attrMap.getLength(); ++i) {
                    for (int j = 1; j <= envsize; ++j) {
                        node = attrMap.item(i);
                        if (node.getNodeName().equalsIgnoreCase("envKey_" + j)) {
                            envKeys[j - 1] = node.getNodeValue();
                            continue;
                        }
                        if (!node.getNodeName().equalsIgnoreCase("envValue_" + j)) continue;
                        envValues[j - 1] = node.getNodeValue();
                    }
                }
                for (i = 0; i < envsize; ++i) {
                    if (thisEnvironment == null) {
                        thisEnvironment = new Hashtable<String, String>();
                    }
                    thisEnvironment.put((String)envKeys[i], (String)envValues[i]);
                }
                EJBInfo ejbInfo = new EJBInfo(thisJNDIName, thisHomeName, thisRemoteName, thisSelectedMethodName, thisSelectedMethodParamVal, thisEnvironment);
                this.sourceList[k] = ejbInfo;
            }
        } else if (datasources.size() == 1) {
            Node source = (Node)datasources.elementAt(0);
            NamedNodeMap map = source.getAttributes();
            for (int i = 0; i <= map.getLength(); ++i) {
                if (i == map.getLength()) {
                    throw new Exception("Missing 'Type' attribute.");
                }
                Node node = map.item(i);
                if (!node.getNodeName().equalsIgnoreCase("Type")) continue;
                if (node.getNodeValue().equalsIgnoreCase("database")) {
                    this.sourceData = 1;
                    break;
                }
                if (node.getNodeValue().equalsIgnoreCase("file")) {
                    this.sourceData = 2;
                    break;
                }
                if (node.getNodeValue().equalsIgnoreCase("xml")) {
                    this.sourceData = 4;
                    break;
                }
                if (node.getNodeValue().equalsIgnoreCase("xmlfilequery")) {
                    this.sourceData = 7;
                    break;
                }
                if (node.getNodeValue().equalsIgnoreCase("class")) {
                    this.sourceData = 6;
                    break;
                }
                if (node.getNodeValue().equalsIgnoreCase("ejb")) {
                    this.sourceData = 5;
                    break;
                }
                if (node.getNodeValue().equalsIgnoreCase("soap")) {
                    this.sourceData = 12;
                    break;
                }
                if (node.getNodeValue().equalsIgnoreCase("salesforce")) {
                    this.sourceData = 11;
                    break;
                }
                if (node.getNodeValue().equalsIgnoreCase("excel")) {
                    this.sourceData = 13;
                    break;
                }
                if (node.getNodeValue().equalsIgnoreCase("olap")) {
                    this.sourceData = 10;
                    break;
                }
                if (!node.getNodeValue().equalsIgnoreCase("none")) continue;
                this.sourceData = 0;
                break;
            }
            if (this.sourceData == 1) {
                NodeList nodeList = source.getChildNodes();
                this.dbInfo = null;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (this.dbInfo != null || !node.getNodeName().equalsIgnoreCase("DATABASE")) continue;
                    this.dbInfo = DBInfoBasic.readXML(node, this.version);
                    if (this.dbInfo != null) break;
                }
                if (this.dbInfo == null) {
                    throw new Exception("Missing or invalid 'DATABASE' element.");
                }
                if (this.modDataSourceArr != null) {
                    this.dbInfo.setQuery(this.modDataSourceArr[0]);
                }
                Vector<QueryInParam> params = new Vector<QueryInParam>();
                Vector vect2 = new Vector();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeName().equalsIgnoreCase("QUERYFILE")) {
                        this.queryFilename = LoadXMLReportHelper.readCDATA(node);
                        break;
                    }
                    if (node.getNodeName().equalsIgnoreCase("PARAMETER")) {
                        QueryInParam p = QueryInParam.readXML(node, 0);
                        if (p == null) continue;
                        params.addElement(p);
                        continue;
                    }
                    if (!node.getNodeName().equalsIgnoreCase("PARAM_ORDER")) continue;
                    Vector<String> paramName = new Vector<String>();
                    NodeList nodeList2 = node.getChildNodes();
                    for (int j = 0; nodeList2 != null && j < nodeList2.getLength(); ++j) {
                        Node child2 = nodeList2.item(j);
                        if (!child2.getNodeName().equalsIgnoreCase("PARAM_NAME")) continue;
                        paramName.addElement(XMLUtil.readText(child2));
                    }
                    vect2.addElement(paramName);
                }
                if (this.queryFilename == null && params.size() > 0) {
                    this.queryFileInfo = null;
                    QueryInParam[] pArray = new QueryInParam[params.size()];
                    for (int i = 0; i < pArray.length; ++i) {
                        pArray[i] = (QueryInParam)params.elementAt(i);
                    }
                    QueryInParamSet inSet = new QueryInParamSet(pArray);
                    if (vect2.size() > 0) {
                        QueryInParam[][] paramInSequence = new QueryInParam[vect2.size()][vect2.size()];
                        for (int i = 0; i < vect2.size(); ++i) {
                            Vector paramName = (Vector)vect2.elementAt(i);
                            for (int j = 0; j < paramName.size(); ++j) {
                                paramInSequence[i][j] = inSet.getParameter((String)paramName.elementAt(j));
                            }
                        }
                        inSet.setParameterInPromptSequence(paramInSequence);
                    }
                    this.dbInfo = new QueryFileInfo("", 0, this.dbInfo, inSet);
                } else if (this.queryFilename != null && !this.queryFilename.equals("")) {
                    this.queryFileInfo = QueryFileInfo.readFile(this.queryFilename);
                    this.dbInfo = this.queryFileInfo;
                }
            } else if (this.sourceData == 2 || this.sourceData == 4 || this.sourceData == 6) {
                this.sourceFile = LoadXMLReportHelper.readCDATA(source);
                if (this.modDataSourceArr != null) {
                    this.sourceFile = this.modDataSourceArr[0];
                }
                boolean isParameterized = false;
                Node attr = map.getNamedItem("isParameterized");
                if (attr != null) {
                    isParameterized = Boolean.valueOf(attr.getNodeValue());
                }
                if (isParameterized) {
                    this.dbInfo = new QueryClassFileInfo(this.sourceFile);
                }
            } else if (this.sourceData == 7) {
                NodeList nodeList = source.getChildNodes();
                XMLFileQueryInfo xmlInfo = null;
                Vector vect2 = new Vector();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (xmlInfo == null && node.getNodeName().equalsIgnoreCase("XMLFILEQUERYINFO")) {
                        xmlInfo = XMLFileQueryInfo.readXML(node, this.version);
                        continue;
                    }
                    if (node.getNodeName().equalsIgnoreCase("ISPARAMQUERY")) {
                        boolean isParamQuery = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(node));
                        if (xmlInfo == null || !isParamQuery) continue;
                        this.dbInfo = new QueryXMLFileInfo(xmlInfo);
                        continue;
                    }
                    if (!node.getNodeName().equalsIgnoreCase("PARAM_ORDER")) continue;
                    Vector<String> paramName = new Vector<String>();
                    NodeList nodeList2 = node.getChildNodes();
                    for (int j = 0; nodeList2 != null && j < nodeList2.getLength(); ++j) {
                        Node child2 = nodeList2.item(j);
                        if (!child2.getNodeName().equalsIgnoreCase("PARAM_NAME")) continue;
                        paramName.addElement(XMLUtil.readText(child2));
                    }
                    vect2.addElement(paramName);
                }
                if (vect2.size() > 0 && xmlInfo != null) {
                    QueryInParam[][] paramInSequence = new QueryInParam[vect2.size()][vect2.size()];
                    for (int i = 0; i < vect2.size(); ++i) {
                        Vector paramName = (Vector)vect2.elementAt(i);
                        for (int j = 0; j < paramName.size(); ++j) {
                            paramInSequence[i][j] = xmlInfo.getInSet().getParameter((String)paramName.elementAt(j));
                        }
                    }
                    xmlInfo.getInSet().setParameterInPromptSequence(paramInSequence);
                }
                this.sourceFile = xmlInfo.getFileName();
                this.xmlFileQueryInfo = xmlInfo;
            } else if (this.sourceData == 12) {
                this.soapInfo = SOAPQueryFileInfo.readSOAPQueryFileInfoXML(source);
                if (this.soapInfo.isParameterized()) {
                    this.dbInfo = this.soapInfo;
                }
            } else if (this.sourceData == 11) {
                this.sfQueryInfo = SalesForceQueryFileInfo.readSalesForceQueryInfoXML(source);
                if (this.sfQueryInfo.isParameterized()) {
                    this.dbInfo = this.sfQueryInfo;
                }
            } else if (this.sourceData == 13) {
                this.excelInfo = ExcelFileInfo.readXML(source);
            } else if (this.sourceData == 10) {
                NamedNodeMap attrMap = source.getAttributes();
                for (int i = 0; i < attrMap.getLength(); ++i) {
                    Node node = attrMap.item(i);
                    if (node.getNodeName().equalsIgnoreCase("MondrianConnectionString")) {
                        this.mondrianConnectionString = node.getNodeValue();
                        continue;
                    }
                    if (node.getNodeName().equalsIgnoreCase("MDXQuery")) {
                        this.MDXQuery = node.getNodeValue();
                        continue;
                    }
                    if (node.getNodeName().equalsIgnoreCase("XmlaURI")) {
                        this.xmlaURI = node.getNodeValue();
                        continue;
                    }
                    if (node.getNodeName().equalsIgnoreCase("XmlaDataSource")) {
                        this.xmlaDataSource = node.getNodeValue();
                        continue;
                    }
                    if (!node.getNodeName().equalsIgnoreCase("XmlaCatalog")) continue;
                    this.xmlaCatalog = node.getNodeValue();
                }
            } else if (this.sourceData == 5) {
                Node node;
                int i;
                NamedNodeMap attrMap = source.getAttributes();
                Object[] vals = null;
                String[] paramTypes = null;
                int valSize = 0;
                int envsize = 0;
                String[] envKeys = null;
                String[] envValues = null;
                for (i = 0; i < attrMap.getLength(); ++i) {
                    Node node5 = attrMap.item(i);
                    if (node5.getNodeName().equalsIgnoreCase("Type")) {
                        if (node5.getNodeValue().equalsIgnoreCase("ejb")) continue;
                        LOGGER.warning("Wrong data source");
                        continue;
                    }
                    if (node5.getNodeName().equalsIgnoreCase("jndiName")) {
                        this.jndiName = node5.getNodeValue();
                        continue;
                    }
                    if (node5.getNodeName().equalsIgnoreCase("homeName")) {
                        this.homeName = node5.getNodeValue();
                        continue;
                    }
                    if (node5.getNodeName().equalsIgnoreCase("remoteName")) {
                        this.remoteName = node5.getNodeValue();
                        continue;
                    }
                    if (node5.getNodeName().equalsIgnoreCase("selectedMethodName")) {
                        this.selectedMethodName = node5.getNodeValue();
                        continue;
                    }
                    if (node5.getNodeName().equalsIgnoreCase("paramSize")) {
                        valSize = Integer.parseInt(node5.getNodeValue());
                        if (vals == null) {
                            vals = new Object[valSize];
                        }
                        if (paramTypes != null) continue;
                        paramTypes = new String[valSize];
                        continue;
                    }
                    if (!node5.getNodeName().equalsIgnoreCase("envsize")) continue;
                    envsize = Integer.parseInt(node5.getNodeValue());
                    if (envKeys == null) {
                        envKeys = new String[envsize];
                    }
                    if (envValues != null) continue;
                    envValues = new String[envsize];
                }
                for (i = 0; i < attrMap.getLength(); ++i) {
                    for (int j = 1; j <= valSize; ++j) {
                        node = attrMap.item(i);
                        if (node.getNodeName().equalsIgnoreCase("paramValType_" + j)) {
                            paramTypes[j - 1] = node.getNodeValue();
                            continue;
                        }
                        if (!node.getNodeName().equalsIgnoreCase("paramValValue_" + j)) continue;
                        vals[j - 1] = EJBUtil.getRuntimeInputValue(paramTypes[j - 1], node.getNodeValue());
                    }
                }
                this.selectedMethodParamVal = vals;
                for (i = 0; i < attrMap.getLength(); ++i) {
                    for (int j = 1; j <= envsize; ++j) {
                        node = attrMap.item(i);
                        if (node.getNodeName().equalsIgnoreCase("envKey_" + j)) {
                            envKeys[j - 1] = node.getNodeValue();
                            continue;
                        }
                        if (!node.getNodeName().equalsIgnoreCase("envValue_" + j)) continue;
                        envValues[j - 1] = node.getNodeValue();
                    }
                }
                for (i = 0; i < envsize; ++i) {
                    if (this.getEnvironment() == null) {
                        this.setEnvironment(new Hashtable<String, String>());
                    }
                    this.getEnvironment().put((String)envKeys[i], (String)envValues[i]);
                }
            } else if (this.sourceData == 0) {
                this.originalColDataFromMemSource = this.createColData(source, this.version);
            }
        }
    }

    private Report loadData(DataInput in, ColData[] colData, Report report, boolean template, Vector params, Vector formulaParams, boolean isEntServer) throws Exception {
        if (!(in instanceof InputStream)) {
            throw new IllegalArgumentException("DataInput must be a sub-class of java.io.InputStream.");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse((InputStream)((Object)in));
        return this.readReport(document, colData, report, template, params, formulaParams, isEntServer);
    }

    private Report readReport(Node domNode, ColData[] colData, Report report, boolean template, Vector params, Vector formulaParams, boolean isEntServer) throws Exception {
        NodeList nodeList = domNode.getChildNodes();
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new Exception(LanguageEncoder.getText("Document does not contain a 'REPORT' element."));
        }
        Node node = nodeList.item(0);
        if (node.getNodeName().equalsIgnoreCase("REPORT")) {
            return this.parseReportNode(node, colData, report, template, params, formulaParams, isEntServer);
        }
        return this.readReport(node, colData, report, template, params, formulaParams, isEntServer);
    }

    private Report parseReportNode(Node reportNode, ColData[] colData, Report report, boolean template, Vector params, Vector formulaParams, boolean isEntServer) throws Exception {
        Object object;
        int i;
        GuideLine gl;
        String id;
        int i2;
        Vector<QueryInParamSet> parameter;
        Hashtable<String, QueryInParam[]> securityQueryParameterMap;
        Vector<Parameter> queryParameters;
        int reportStyle;
        int datePos;
        int dateFormat;
        int pageNumberPos;
        int pageNumberFormat;
        int logoPos;
        boolean isPrevParamPrompt;
        boolean limitSubReportQueryExecution;
        String rtfEncoding;
        String htmlCharset;
        String exportEncoding;
        String externalCSS;
        String htmlTitle;
        String logofile;
        String reportTitle;
        boolean hasDate;
        boolean hasPageNumber;
        boolean hasLogo;
        boolean hasTitle;
        boolean keepDataSourceOrder;
        boolean isAdjustFont;
        double cmGridStepSize;
        double gridStepSize;
        boolean snapToGrid;
        boolean ascending;
        int topN;
        Vector<Parameter> formulaParameters;
        Vector<Script> scripts;
        Vector<Formula> formulas;
        String columnWrapID;
        NodeList nodeList;
        NamedNodeMap attrmap;
        int orientation;
        boolean alignCrossTabColBkValHori;
        boolean columnAggregationInHeader;
        boolean showColumnAggregation;
        boolean rowAggregationGrandTotalOnLeft;
        boolean rowAggregationSubtotalOnLeft;
        boolean showRowAggregationSubtotal;
        boolean crossTabFreeForm;
        boolean showRowAggregationGrandTotal;
        boolean sideBySide;
        double bottomMargin;
        double topMargin;
        double rightMargin;
        double leftMargin;
        double pageHeight;
        double pageWidth;
        int reportType;
        String reportName;
        boolean sorteddata;
        block294: {
            ColData[] backupColData;
            boolean[] colBreakAggrIncluded;
            boolean[] rowBreakAggrIncluded;
            block293: {
                int i3;
                quadbase.reportdesigner.util.IQueryInParam[] inParams;
                int j2;
                Node node;
                int i4;
                Node node2;
                int i5;
                sorteddata = false;
                reportName = null;
                reportType = -1;
                pageWidth = -1.0;
                pageHeight = -1.0;
                leftMargin = -1.0;
                rightMargin = -1.0;
                topMargin = -1.0;
                bottomMargin = -1.0;
                sideBySide = false;
                showRowAggregationGrandTotal = true;
                rowBreakAggrIncluded = null;
                colBreakAggrIncluded = null;
                crossTabFreeForm = false;
                showRowAggregationSubtotal = true;
                rowAggregationSubtotalOnLeft = false;
                rowAggregationGrandTotalOnLeft = false;
                showColumnAggregation = true;
                columnAggregationInHeader = false;
                alignCrossTabColBkValHori = true;
                orientation = 0;
                backupColData = null;
                attrmap = reportNode.getAttributes();
                for (int i6 = 0; i6 < attrmap.getLength(); ++i6) {
                    String nodeName = attrmap.item(i6).getNodeName();
                    if (nodeName.equalsIgnoreCase("Name")) {
                        reportName = attrmap.item(i6).getNodeValue();
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("Type")) {
                        String typeString = attrmap.item(i6).getNodeValue().trim();
                        if (typeString.equalsIgnoreCase("columnar")) {
                            reportType = 0;
                            continue;
                        }
                        if (typeString.equalsIgnoreCase("summary break")) {
                            reportType = 1;
                            continue;
                        }
                        if (typeString.equalsIgnoreCase("crosstab")) {
                            reportType = 2;
                            continue;
                        }
                        if (typeString.equalsIgnoreCase("master details")) {
                            reportType = 3;
                            continue;
                        }
                        if (typeString.equalsIgnoreCase("mailing labels")) {
                            reportType = 4;
                            continue;
                        }
                        Exception ex = new Exception("Unrecognizable report type.");
                        this.errorMessage = IOUtil.getStackTrace(ex);
                        throw ex;
                    }
                    if (nodeName.equalsIgnoreCase("PageWidth")) {
                        pageWidth = Double.parseDouble(attrmap.item(i6).getNodeValue());
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("PageHeight")) {
                        pageHeight = Double.parseDouble(attrmap.item(i6).getNodeValue());
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("LeftMargin")) {
                        leftMargin = Double.parseDouble(attrmap.item(i6).getNodeValue());
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("RightMargin")) {
                        rightMargin = Double.parseDouble(attrmap.item(i6).getNodeValue());
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("TopMargin")) {
                        topMargin = Double.parseDouble(attrmap.item(i6).getNodeValue());
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("BottomMargin")) {
                        bottomMargin = Double.parseDouble(attrmap.item(i6).getNodeValue());
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("SideBySideLayout")) {
                        sideBySide = LoadXMLReportHelper.parseBoolean(attrmap.item(i6).getNodeValue());
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("CrossTabRowSummaryColumn")) {
                        showRowAggregationGrandTotal = LoadXMLReportHelper.parseBoolean(attrmap.item(i6).getNodeValue());
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("CrossTabFixedField")) {
                        crossTabFreeForm = !LoadXMLReportHelper.parseBoolean(attrmap.item(i6).getNodeValue());
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("AddCrossTabSubTotalColumn")) {
                        showRowAggregationSubtotal = LoadXMLReportHelper.parseBoolean(attrmap.item(i6).getNodeValue());
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("CrossTabSummaryColumnToLeft")) {
                        rowAggregationSubtotalOnLeft = LoadXMLReportHelper.parseBoolean(attrmap.item(i6).getNodeValue());
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("ShowRowAggregationGrandTotalOnLeft")) {
                        rowAggregationGrandTotalOnLeft = LoadXMLReportHelper.parseBoolean(attrmap.item(i6).getNodeValue());
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("CrossTabFormulaIncluded")) {
                        showColumnAggregation = LoadXMLReportHelper.parseBoolean(attrmap.item(i6).getNodeValue());
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("PlaceCrossTabFormulaOnHeader")) {
                        columnAggregationInHeader = LoadXMLReportHelper.parseBoolean(attrmap.item(i6).getNodeValue());
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("AlignColBkValColHori")) {
                        alignCrossTabColBkValHori = LoadXMLReportHelper.parseBoolean(attrmap.item(i6).getNodeValue());
                        continue;
                    }
                    if (!nodeName.equalsIgnoreCase("Orientation") || !attrmap.item(i6).getNodeValue().equals("LANDSCAPE")) continue;
                    orientation = 1;
                }
                if (reportName == null || reportType == -1 || pageWidth == -1.0 || pageHeight == -1.0 || leftMargin == -1.0 || rightMargin == -1.0 || topMargin == -1.0 || bottomMargin == -1.0) {
                    Exception ex = new Exception("Invalid 'REPORT' element. Missing attributes.");
                    this.errorMessage = IOUtil.getStackTrace(ex);
                    throw ex;
                }
                this.version = -1;
                nodeList = reportNode.getChildNodes();
                for (i5 = 0; i5 < nodeList.getLength(); ++i5) {
                    node2 = nodeList.item(i5);
                    if (!node2.getNodeName().equalsIgnoreCase("VERSION")) continue;
                    this.version = Integer.parseInt(LoadXMLReportHelper.readText(node2).trim());
                    break;
                }
                if (this.version == -1) {
                    Exception ex = new Exception("Invalid 'REPORT' element. 'REPORT' element must contain the 'VERSION' element.");
                    this.errorMessage = IOUtil.getStackTrace(ex);
                    throw ex;
                }
                if (this.version >= 135) {
                    for (i5 = 0; i5 < nodeList.getLength(); ++i5) {
                        node2 = nodeList.item(i5);
                        if (node2.getNodeName().equalsIgnoreCase("REGISTRYID")) {
                            this.registryID = LoadXMLReportHelper.readText(node2);
                            continue;
                        }
                        if (node2.getNodeName().equalsIgnoreCase("DATASOURCEID")) {
                            this.dataSourceID = LoadXMLReportHelper.readText(node2);
                            continue;
                        }
                        if (!node2.getNodeName().equalsIgnoreCase("DATASOURCELOC")) continue;
                        this.dataSourceLoc = LoadXMLReportHelper.readText(node2);
                    }
                }
                if (this.version >= 46) {
                    for (i5 = 0; i5 < nodeList.getLength(); ++i5) {
                        node2 = nodeList.item(i5);
                        if (node2.getNodeName().equalsIgnoreCase("DATABACKUP")) {
                            try {
                                backupColData = this.createColData(node2, this.version);
                                continue;
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.FINEST, "Invalid 'DATABACKUP' element", ex);
                                Exception ex2 = new Exception("Invalid 'DATABACKUP' element. " + ex.getMessage());
                                this.errorMessage = IOUtil.getStackTrace(ex2);
                                throw ex2;
                            }
                        }
                        if (!node2.getNodeName().equalsIgnoreCase("SAVE_ALL_DATA")) continue;
                        this.saveAllData = Boolean.valueOf(LoadXMLReportHelper.readText(node2));
                    }
                }
                Vector<Node> datasources = new Vector<Node>();
                Vector<Node> multiTranspose = new Vector<Node>();
                for (i4 = 0; i4 < nodeList.getLength(); ++i4) {
                    node = nodeList.item(i4);
                    if (node.getNodeName().equalsIgnoreCase("DATASOURCE")) {
                        datasources.addElement(node);
                        continue;
                    }
                    if (node.getNodeName().equalsIgnoreCase("MULTI_TRANSPOSE")) {
                        multiTranspose.addElement(node);
                        continue;
                    }
                    if (node.getNodeName().equalsIgnoreCase("TRANSPOSE")) {
                        attrmap = node.getAttributes();
                        for (j2 = 0; j2 < attrmap.getLength(); ++j2) {
                            if (attrmap.item(j2).getNodeName().equalsIgnoreCase("transpose")) {
                                this.isTransposed = Boolean.valueOf(attrmap.item(j2).getNodeValue());
                                continue;
                            }
                            if (!attrmap.item(j2).getNodeName().equalsIgnoreCase("transposeColumn")) continue;
                            this.transposeCol = this.getTransposeColumn(attrmap.item(j2).getNodeValue());
                        }
                        continue;
                    }
                    if (!node.getNodeName().equalsIgnoreCase("PDFFONTMAPPINGTABLE") || this.version < 130) continue;
                    NodeList j2 = node.getChildNodes();
                }
                if (datasources.size() <= 0) {
                    Exception ex2 = new Exception("Invalid 'REPORT' element. 'REPORT' element must contain one or more 'DATASOURCE' elements.");
                    this.errorMessage = IOUtil.getStackTrace(ex2);
                    throw ex2;
                }
                try {
                    this.loadDataHeader(datasources);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Invalid 'DATASOURCE' element", ex);
                    Exception ex2 = new Exception("Invalid 'DATASOURCE' element. " + ex.getMessage());
                    this.errorMessage = IOUtil.getStackTrace(ex2);
                    throw ex2;
                }
                if (multiTranspose.size() > 0) {
                    this.doTranspose = new boolean[multiTranspose.size()];
                    this.transposeColList = new Object[multiTranspose.size()];
                    this.transposeCol = new boolean[multiTranspose.size()];
                    for (i4 = 0; i4 < multiTranspose.size(); ++i4) {
                        node = (Node)multiTranspose.elementAt(i4);
                        attrmap = node.getAttributes();
                        for (j2 = 0; j2 < attrmap.getLength(); ++j2) {
                            if (attrmap.item(j2).getNodeName().equalsIgnoreCase("transpose")) {
                                this.doTranspose[i4] = Boolean.valueOf(attrmap.item(j2).getNodeValue());
                                continue;
                            }
                            if (!attrmap.item(j2).getNodeName().equalsIgnoreCase("transposeColumn")) continue;
                            this.transposeColList[i4] = this.getTransposeColumn(attrmap.item(j2).getNodeValue());
                        }
                    }
                }
                if (this.version <= 20) {
                    this.drillDownNode = new DrillDownNode("ROOT");
                }
                if (this.version <= 21) {
                    this.subReports = new Vector();
                }
                columnWrapID = null;
                Vector<ColInfo> colInfoVector = new Vector<ColInfo>();
                formulas = new Vector<Formula>();
                scripts = new Vector<Script>();
                formulaParameters = new Vector<Parameter>();
                topN = 0;
                ascending = true;
                snapToGrid = false;
                gridStepSize = 0.1;
                cmGridStepSize = 0.25;
                isAdjustFont = false;
                keepDataSourceOrder = false;
                hasTitle = false;
                hasLogo = false;
                hasPageNumber = false;
                hasDate = false;
                reportTitle = null;
                logofile = null;
                htmlTitle = null;
                externalCSS = null;
                exportEncoding = "UTF-8";
                htmlCharset = null;
                rtfEncoding = null;
                limitSubReportQueryExecution = false;
                isPrevParamPrompt = true;
                logoPos = 0;
                pageNumberFormat = 0;
                pageNumberPos = 0;
                dateFormat = 0;
                datePos = 0;
                reportStyle = 0;
                Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
                formulaVec.add(formulas);
                Report[] subReportArray = Report.getSubReportArray(this.subReports, true, new FileInMemTable());
                for (int i7 = 0; subReportArray != null && i7 < subReportArray.length; ++i7) {
                    Report rpt = subReportArray[i7];
                    if (rpt == null) continue;
                    formulaVec.add(rpt.formulas);
                }
                queryParameters = null;
                if (this.dbInfo != null && this.dbInfo instanceof IQueryFileInfo && (inParams = ReportUtil.getInParam(this.dbInfo)) != null && inParams.length > 0) {
                    queryParameters = new Vector<Parameter>();
                    for (quadbase.reportdesigner.util.IQueryInParam inParam : inParams) {
                        Parameter param = new Parameter(inParam);
                        queryParameters.addElement(param);
                    }
                    QueryInParam[] ps = ((QueryFileInfo)this.dbInfo).getInSet().getParameter();
                    if (ps != null) {
                        for (i3 = 0; i3 < ps.length; ++i3) {
                            Parameter param = (Parameter)queryParameters.elementAt(i3);
                            param.setValue(ps[i3].getValue());
                        }
                    }
                }
                int ct = 0;
                securityQueryParameterMap = null;
                for (i3 = 0; i3 < nodeList.getLength(); ++i3) {
                    Node node3 = nodeList.item(i3);
                    if (node3.getNodeName().equalsIgnoreCase("DrillDownTree") && this.version > 20 && this.drillDownNode == null) {
                        this.loadTree(node3);
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("SubReportVector") && this.version > 21 && this.subReports == null) {
                        this.loadSubReports(node3);
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("COLUMN_INFO")) {
                        ColInfo cinfo = ColInfo.readXML(node3, this.version);
                        colInfoVector.addElement(cinfo);
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("COLUMN_ATTRIBUTE")) continue;
                    if (node3.getNodeName().equalsIgnoreCase("COLUMNWRAP_HANDLE") && this.version >= 31) {
                        attrmap = node3.getAttributes();
                        for (int j3 = 0; j3 <= attrmap.getLength(); ++j3) {
                            if (j3 == attrmap.getLength()) {
                                Exception ex2 = new Exception("Invalid 'COLUMNWRAP_HANDLE' element. Missing 'ID' attribute.");
                                this.errorMessage = IOUtil.getStackTrace(ex2);
                                throw ex2;
                            }
                            if (!attrmap.item(j3).getNodeName().equalsIgnoreCase("ID")) continue;
                            columnWrapID = attrmap.item(j3).getNodeValue();
                            j3 = attrmap.getLength() + 1;
                        }
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("PDFFONTMAPPINGTABLE") && this.version >= 130) {
                        NodeList fontNodeList = node3.getChildNodes();
                        for (int k = 0; k < fontNodeList.getLength(); ++k) {
                            Node eltNode = fontNodeList.item(k);
                            if (!eltNode.getNodeName().equalsIgnoreCase("PDFFONTMAPPING")) continue;
                            if (this.getFontMapping() == null) {
                                this.setFontMapping(new Hashtable<String, String>());
                            }
                            attrmap = eltNode.getAttributes();
                            String key = null;
                            String value = null;
                            for (int j4 = 0; j4 < attrmap.getLength(); ++j4) {
                                if (attrmap.item(j4).getNodeName().equalsIgnoreCase("Key")) {
                                    key = attrmap.item(j4).getNodeValue();
                                    continue;
                                }
                                if (!attrmap.item(j4).getNodeName().equalsIgnoreCase("Value")) continue;
                                value = attrmap.item(j4).getNodeValue();
                            }
                            if (key != null && value != null) {
                                this.getFontMapping().put(key, value);
                                continue;
                            }
                            Exception ex2 = new Exception("Invalid 'PDFFONTMAPPING' element. Missing 'Key' or 'Value' attribute.");
                            this.errorMessage = IOUtil.getStackTrace(ex2);
                            throw ex2;
                        }
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("TOP_N_REPORT")) {
                        topN = Integer.parseInt(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("TOP_N_ORDER")) {
                        ascending = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("SNAP_TO_GRID")) {
                        snapToGrid = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("GRID_STEP_SIZE")) {
                        gridStepSize = Double.parseDouble(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("CM_GRID_STEP_SIZE")) {
                        cmGridStepSize = Double.parseDouble(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("ADJUST_VIEWER_FONT")) {
                        isAdjustFont = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("KEEP_DATA_SOURCE_ORDER")) {
                        keepDataSourceOrder = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("hasTitle")) {
                        hasTitle = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("hasLogo")) {
                        hasLogo = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("hasPageNumber")) {
                        hasPageNumber = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("hasDate")) {
                        hasDate = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("reportTitle")) {
                        reportTitle = LoadXMLReportHelper.readCDATA(node3);
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("logofile")) {
                        logofile = LoadXMLReportHelper.readCDATA(node3);
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("logoPos")) {
                        logoPos = Integer.parseInt(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("pageNumberFormat")) {
                        pageNumberFormat = Integer.parseInt(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("pageNumberPos")) {
                        pageNumberPos = Integer.parseInt(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("dateFormat")) {
                        dateFormat = Integer.parseInt(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("datePos")) {
                        datePos = Integer.parseInt(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("reportStyle")) {
                        reportStyle = Integer.parseInt(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("htmlTitle")) {
                        htmlTitle = LoadXMLReportHelper.readCDATA(node3);
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("ExternalStyleSheetName")) {
                        externalCSS = LoadXMLReportHelper.readCDATA(node3);
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("ExportEncoding")) {
                        exportEncoding = LoadXMLReportHelper.readCDATA(node3);
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("HTMLCharset")) {
                        htmlCharset = LoadXMLReportHelper.readCDATA(node3);
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("RTFEncoding")) {
                        rtfEncoding = LoadXMLReportHelper.readCDATA(node3);
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("FORMULA") && this.version >= 70) {
                        try {
                            Formula formula = new Formula();
                            formula.readXML(node3, this.version, formulaVec, queryParameters, formulaParameters);
                            formulas.addElement(formula);
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINEST, "Failed to read formula", ex);
                        }
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("SCRIPT") && this.version >= 70) {
                        try {
                            Script script = new Script();
                            script.readXML(node3, this.version, formulaVec, queryParameters, formulaParameters);
                            scripts.addElement(script);
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINEST, "Failed to read script", ex);
                        }
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("PARAMETER") && this.version >= 75) {
                        try {
                            Parameter param = new Parameter();
                            param.readXML(node3, this.version);
                            formulaParameters.addElement(param);
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINEST, "Failed to read parameter", ex);
                        }
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("PARAMETER_SHAREINFO")) {
                        try {
                            ((Parameter)queryParameters.elementAt(ct)).readXMLShareInfo(node3, this.version);
                            ++ct;
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINEST, "Failed to read parameter share info", ex);
                        }
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("LIMITSUBREPORTQUERYEXECUTION")) {
                        limitSubReportQueryExecution = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("ISPREVIEWPARAMETERPROMPT")) {
                        isPrevParamPrompt = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(node3));
                        continue;
                    }
                    if (!node3.getNodeName().equalsIgnoreCase("SECURITY_QUERY_PARAMETER_MAP")) continue;
                    securityQueryParameterMap = new Hashtable<String, QueryInParam[]>();
                    NodeList nlist = node3.getChildNodes();
                    for (int j5 = 0; j5 < nlist.getLength(); ++j5) {
                        Node grandchild = nlist.item(j5);
                        if (!grandchild.getNodeName().equalsIgnoreCase("MAPPING")) continue;
                        String levelname = grandchild.getAttributes().getNamedItem("LevelName").getNodeValue();
                        Vector gnlist = this.sort(grandchild.getChildNodes());
                        Vector<QueryInParam> sparams = new Vector<QueryInParam>();
                        for (int k = 0; k < gnlist.size(); ++k) {
                            Node ggchild = (Node)gnlist.elementAt(k);
                            if (!ggchild.getNodeName().equalsIgnoreCase("PARAMETER")) continue;
                            sparams.add(QueryInParam.readXML(ggchild, this.version));
                        }
                        QueryInParam[] security_params = new QueryInParam[sparams.size()];
                        for (int k = 0; k < sparams.size(); ++k) {
                            security_params[k] = (QueryInParam)sparams.elementAt(k);
                        }
                        securityQueryParameterMap.put(levelname, security_params);
                    }
                }
                if (formulaParams != null) {
                    Object[] values = (Object[])formulaParams.elementAt(0);
                    for (int i8 = 0; values != null && i8 < values.length; ++i8) {
                        Parameter param = (Parameter)formulaParameters.elementAt(i8);
                        param.setValue(values[i8]);
                    }
                }
                this.colInfo = new ColInfo[colInfoVector.size()];
                for (int i9 = 0; i9 < this.colInfo.length; ++i9) {
                    this.colInfo[i9] = (ColInfo)colInfoVector.elementAt(i9);
                }
                for (ColInfo element : this.colInfo) {
                    if (this.version >= 70) {
                        Formula formula;
                        for (int j6 = 0; j6 < formulas.size(); ++j6) {
                            formula = (Formula)formulas.elementAt(j6);
                            if (element.getFormulaName() == null || !element.getFormulaName().equals(formula.getName())) continue;
                            element.setFormulaObj(formula);
                            break;
                        }
                        if (element.getFormulaObj() != null || element.getFormulaName() == null) continue;
                        String text = element.getFormulaName();
                        formula = new Formula(null, text);
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                        NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                        try {
                            formula.setFormula(parser.parse(formulaVec, null, null, null));
                            element.setFormulaObj(formula);
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINEST, "Cannot parse formula", ex);
                        }
                        continue;
                    }
                    if (element.getFormula() == null) continue;
                    Formula formula = new Formula("formula" + (formulas.size() + 1), element.getFormula());
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(element.getFormula().getBytes("UTF-8"));
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                    try {
                        formula.setFormula(parser.parse(formulaVec, null, null, null));
                        formulas.addElement(formula);
                        element.setFormulaObj(formula);
                    }
                    catch (TokenMgrError err) {
                        LOGGER.log(Level.WARNING, "Syntax error: " + element.getFormula(), err);
                    }
                }
                if (this.retrieveColInfoOnly) {
                    return null;
                }
                parameter = null;
                if (!template && colData == null) {
                    try {
                        if (this.queryFileInfo != null) {
                            parameter = QueryFileInfo.getParameter(this.queryFileInfo, false, true, false);
                            break block293;
                        }
                        if (!(this.dbInfo instanceof QueryFileInfo)) break block293;
                        QueryFileInfo tempDbInfo = (QueryFileInfo)this.dbInfo;
                        if (this.securityLevel != null && securityQueryParameterMap != null) {
                            QueryInParam[] masterParams = ((QueryFileInfo)this.dbInfo).getInSet().getParameter();
                            IQueryInParam[] securityParams = QueryParser.verifyParameters(masterParams, (IQueryInParam[])securityQueryParameterMap.get(this.securityLevel));
                            Vector<QueryInParam> unselected = new Vector<QueryInParam>();
                            if (securityParams != null) {
                                for (int i10 = 0; i10 < masterParams.length; ++i10) {
                                    boolean isMulti = false;
                                    Vector<Object> obj = null;
                                    if (masterParams[i10] instanceof QueryMultiValueInParam) {
                                        isMulti = true;
                                        obj = ((QueryMultiValueInParam)securityParams[i10]).getValues();
                                        ((QueryMultiValueInParam)masterParams[i10]).setValues(obj);
                                    } else {
                                        obj = securityParams[i10].getValue();
                                        masterParams[i10].setValue(obj);
                                    }
                                    if (obj != null) continue;
                                    if (params != null && params.size() >= 1) {
                                        if (params.elementAt(0) instanceof QueryInParamSet) {
                                            QueryInParam[] qset = ((QueryInParamSet)params.elementAt(0)).getParameter();
                                            if (isMulti) {
                                                ((QueryMultiValueInParam)masterParams[i10]).setValues(((QueryMultiValueInParam)qset[i10]).getValues());
                                                continue;
                                            }
                                            masterParams[i10].setValue(qset[i10].getValue());
                                            continue;
                                        }
                                        Object[] values = (Object[])params.elementAt(0);
                                        if (isMulti) {
                                            ((QueryMultiValueInParam)masterParams[i10]).setValues((Vector)values[i10]);
                                            continue;
                                        }
                                        masterParams[i10].setValue(values[i10]);
                                        continue;
                                    }
                                    unselected.addElement(masterParams[i10]);
                                }
                                if (unselected.size() == 0) {
                                    parameter = new Vector();
                                    parameter.addElement(((QueryFileInfo)this.dbInfo).getInSet());
                                } else {
                                    QueryInParam[] unselectedParams = new QueryInParam[unselected.size()];
                                    for (int i11 = 0; i11 < unselectedParams.length; ++i11) {
                                        unselectedParams[i11] = (QueryInParam)unselected.elementAt(i11);
                                    }
                                    DBInfoBasic newDBInfo = this.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.dbInfo.getJNDIName(), this.dbInfo.getQuery(), this.dbInfo.getEnvProperties()) : new DBInfoBasic(this.dbInfo.getURLString(), this.dbInfo.getDriverName(), this.dbInfo.getUserID(), this.dbInfo.getPassword(), this.dbInfo.getQuery(), this.dbInfo.getAdditionalDb());
                                    tempDbInfo = new QueryFileInfo(tempDbInfo.getProductName(), tempDbInfo.getVersion(), newDBInfo, new QueryInParamSet(unselectedParams));
                                }
                            }
                        }
                        if (params == null || params.size() < 1) {
                            if (parameter == null && (this.drillDownNode == null || this.useDefaults)) {
                                try {
                                    QueryInParam[] pArray;
                                    for (QueryInParam element : pArray = tempDbInfo.getInSet().getParameter()) {
                                        element.setValue(element.getDefaultValue());
                                    }
                                    parameter = new Vector();
                                    parameter.addElement(((QueryFileInfo)this.dbInfo).getInSet());
                                }
                                catch (Exception ex) {
                                    LOGGER.log(Level.FINEST, "Can't get parameter values", ex);
                                }
                            }
                            if (parameter == null) {
                                parameter = QueryFileInfo.getParameter(tempDbInfo, true, true, false, this.usingBackupData);
                                parameter = new Vector<QueryInParamSet>();
                                parameter.addElement(((QueryFileInfo)this.dbInfo).getInSet());
                            }
                            break block293;
                        }
                        if (parameter == null) {
                            if (params.elementAt(0) instanceof QueryInParamSet) {
                                if (params.size() > 0) {
                                    ((QueryFileInfo)this.dbInfo).setInSet((QueryInParamSet)params.elementAt(0));
                                }
                                parameter = params;
                            } else {
                                Object[] values = (Object[])params.elementAt(0);
                                QueryInParam[] ps = ((QueryFileInfo)this.dbInfo).getInSet().getParameter();
                                for (int i12 = 0; i12 < ps.length; ++i12) {
                                    if (values[i12] instanceof Vector && ps[i12] instanceof QueryMultiValueInParam) {
                                        ((QueryMultiValueInParam)ps[i12]).setValues((Vector)values[i12]);
                                        continue;
                                    }
                                    ps[i12].setValue(values[i12]);
                                }
                                parameter = new Vector();
                                parameter.addElement(((QueryFileInfo)this.dbInfo).getInSet());
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (backupColData != null) {
                            LOGGER.log(Level.FINE, "Failed to get data from data source, using backup data", ex);
                            colData = backupColData;
                            this.originalColDataFromMemSource = colData;
                            this.originalSourceData = this.sourceData;
                            this.sourceData = 0;
                            this.promptParamValue = false;
                        }
                        LOGGER.log(Level.FINEST, "Failed to get data from data source", ex);
                        IOException ex2 = new IOException("Failed to get data from data source:\n" + ex.getMessage());
                        this.errorMessage = IOUtil.getStackTrace(ex2);
                        throw ex2;
                    }
                }
            }
            if (this.usingBackupData && backupColData != null) {
                colData = backupColData;
                this.originalColDataFromMemSource = colData;
                this.originalSourceData = this.sourceData;
                this.sourceData = 0;
                this.promptParamValue = false;
            }
            if (this.queryFileInfo != null || !template && colData == null) {
                try {
                    if (this.sourceData == 1) {
                        if (!(keepDataSourceOrder || reportType != 1 && reportType != 2 && reportType != 3 || this.isTransposed)) {
                            String sqlstr = this.dbInfo.getQuery();
                            sqlstr = TransformQuery.transform(sqlstr, this.colInfo);
                            DBInfoBasic tempdbInfo = this.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.dbInfo.getJNDIName(), sqlstr, this.dbInfo.getEnvProperties()) : new DBInfoBasic(this.dbInfo.getURLString(), this.dbInfo.getDriverName(), this.dbInfo.getUserID(), this.dbInfo.getPassword(), sqlstr);
                            if (this.dbInfo instanceof QueryFileInfo) {
                                tempdbInfo = new QueryFileInfo("", 0, tempdbInfo, ((QueryFileInfo)this.dbInfo).getInSet());
                            }
                            try {
                                ColData[] colData2 = null;
                                colData2 = DBAccess.retrieveResult(parameter, tempdbInfo, true, false, null, null, null, 0, reportType == 2 || !this.inServer ? -1 : 20, report != null ? report.isForExportOnly() : false);
                                colData = colData2;
                                sorteddata = true;
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.WARNING, "LoadReport failed to retreive sorted data! Using original query to try again", ex);
                            }
                        }
                        if (!sorteddata) {
                            colData = DBAccess.retrieveResult(parameter, this.dbInfo, true, this.isTransposed, this.transposeCol, null, null, 0, reportType == 2 || !this.inServer ? -1 : 20, report != null ? report.isForExportOnly() : false);
                        }
                        break block294;
                    }
                    if (this.sourceData == 2) {
                        colData = new DataFileInput().readProcessedData(this.sourceFile, this.isTransposed, this.transposeCol, null);
                        break block294;
                    }
                    if (this.sourceData == 4) {
                        colData = new DataFileInput().readProcessedData(this.sourceFile, this.isTransposed, this.transposeCol, null, 4);
                        break block294;
                    }
                    if (this.sourceData == 9) {
                        throw new Exception("Old SOAP data source is no longer supported. Please update your data source.");
                    }
                    if (this.sourceData == 12) {
                        colData = SOAPAccess.retrieveResult(this.soapInfo);
                        break block294;
                    }
                    if (this.sourceData == 11) {
                        colData = SalesForceAccess.getColData(this.sfQueryInfo);
                        break block294;
                    }
                    if (this.sourceData == 13) {
                        colData = ExcelAccess.getColData(this.excelInfo, this.isTransposed, this.transposeCol);
                        break block294;
                    }
                    if (this.sourceData == 10) {
                        OLAPAccess olapAccess = new OLAPAccess(null, this.mondrianConnectionString, this.MDXQuery, this.xmlaURI, this.xmlaDataSource, this.xmlaCatalog);
                        colData = olapAccess.retrieveResult(reportType);
                        rowBreakAggrIncluded = olapAccess.isRowBreakAggrIncluded(rowBreakAggrIncluded);
                        colBreakAggrIncluded = olapAccess.isColBreakAggrIncluded(colBreakAggrIncluded);
                        break block294;
                    }
                    if (this.sourceData == 6) {
                        colData = this.dbInfo != null && this.dbInfo instanceof QueryClassFileInfo ? new DataFileInput().readProcessedData(this.sourceFile, this.isTransposed, this.transposeCol, null, null, 0, reportType == 2 || !this.inServer ? -1 : 20, ((QueryClassFileInfo)this.dbInfo).getInSet()) : new DataFileInput().readProcessedData(this.sourceFile, this.isTransposed, this.transposeCol, null, 6);
                        break block294;
                    }
                    if (this.sourceData == 7) {
                        colData = new DataFileInput().readProcessedData(this.sourceFile, this.isTransposed, this.transposeCol, null, null, 0, -1, this.xmlFileQueryInfo, 7);
                        break block294;
                    }
                    if (this.sourceData == 5) {
                        colData = EJBAccess.retrieveResult(this.jndiName, this.homeName, this.remoteName, this.selectedMethodName, this.selectedMethodParamVal, this.getEnvironment());
                        break block294;
                    }
                    if (this.sourceData == 3) {
                        colData = ColData.getColData(this.sourceList, this.sourceType, this.doTranspose, this.transposeColList, this.isTransposed, this.transposeCol, false);
                        break block294;
                    }
                    if (this.sourceData == 0 && this.originalColDataFromMemSource != null) {
                        colData = ColData.getColData(DBAccess.processResultSet(ColData.getResultSet(this.originalColDataFromMemSource), false, this.isTransposed, this.transposeCol, null, null));
                        break block294;
                    }
                    IOException ex2 = new IOException("No plotting data and no data source available !");
                    this.errorMessage = IOUtil.getStackTrace(ex2);
                    throw ex2;
                }
                catch (Exception ex) {
                    this.errorMessage = IOUtil.getStackTrace(ex);
                    if (backupColData != null) {
                        LOGGER.log(Level.FINE, "Failed to get data from data source, using backup data", ex);
                        colData = backupColData;
                        this.originalColDataFromMemSource = colData;
                        this.originalSourceData = this.sourceData;
                        this.sourceData = 0;
                        this.promptParamValue = false;
                    }
                    LOGGER.log(Level.FINEST, "Failed to get data from data source", ex);
                    IOException ex2 = new IOException("Failed to get data from data source:\n" + ex.getMessage());
                    this.errorMessage = IOUtil.getStackTrace(ex2);
                    throw ex2;
                }
            }
        }
        if (report == null) {
            report = new Report(colData);
            report.colDataSorted = sorteddata;
            report.setShowRowAggregationGrandTotal(showRowAggregationGrandTotal);
            report.crossTabFreeForm = crossTabFreeForm;
            report.setShowRowAggregationSubtotal(showRowAggregationSubtotal);
            report.setRowAggregationSubtotalOnLeft(rowAggregationSubtotalOnLeft);
            report.setRowAggregationGrandTotalOnLeft(rowAggregationGrandTotalOnLeft);
            report.setColumnAggregationInHeader(columnAggregationInHeader);
            report.setShowColumnAggregation(showColumnAggregation);
            report.setAlignCrossTabColBkValHori(alignCrossTabColBkValHori);
            report.createTable(reportType, this.colInfo, false, this.isDesignerDesignMode);
            report.sourceData = this.sourceData;
            report.originalSourceData = this.originalSourceData;
            report.dbInfo = this.dbInfo;
            report.sourceFile = this.sourceFile;
            report.registryID = this.registryID;
            report.dataSourceID = this.dataSourceID;
            report.dataSourceLoc = this.dataSourceLoc;
            report.xmlFileQueryInfo = this.xmlFileQueryInfo;
            report.sfQueryInfo = this.sfQueryInfo;
            report.soapInfo = this.soapInfo;
            report.excelInfo = this.excelInfo;
            report.jndiName = this.jndiName;
            report.homeName = this.homeName;
            report.remoteName = this.remoteName;
            report.selectedMethodName = this.selectedMethodName;
            report.selectedMethodParamVal = this.selectedMethodParamVal;
            report.environment = this.getEnvironment();
            report.mondrianConnectionString = this.mondrianConnectionString;
            report.MDXQuery = this.MDXQuery;
            report.xmlaURI = this.xmlaURI;
            report.xmlaDataSource = this.xmlaDataSource;
            report.xmlaCatalog = this.xmlaCatalog;
            report.fontMapping = this.getFontMapping();
            report.originalColDataFromMemSource = this.originalColDataFromMemSource;
            report.sourceList = this.sourceList;
            report.sourceType = this.sourceType;
            report.doTranspose = this.doTranspose;
            report.setKeepDataSourceOrder(keepDataSourceOrder);
            report.transposeColList = this.transposeColList;
            report.queryFilename = this.queryFilename;
            report.parameters = this.parameters;
            report.setTopN(topN);
            report.setAscending(ascending);
            report.snapToGrid = snapToGrid;
            report.gridStepSize = gridStepSize;
            report.cmGridStepSize = cmGridStepSize;
            report.isAdjustFont = isAdjustFont;
            report.setKeepDataSourceOrder(keepDataSourceOrder);
            report.hasTitle = hasTitle;
            report.hasLogo = hasLogo;
            report.hasPageNumber = hasPageNumber;
            report.hasDate = hasDate;
            report.reportTitle = reportTitle;
            report.logofile = logofile;
            report.logoPos = logoPos;
            report.pageNumberFormat = pageNumberFormat;
            report.pageNumberPos = pageNumberPos;
            report.dateFormat = dateFormat;
            report.datePos = datePos;
            report.reportStyle = reportStyle;
            report.setHTMLTitle(htmlTitle);
            report.setExternalStyleSheetName(externalCSS);
            report.setExportEncoding(exportEncoding);
            report.setHTMLCharset(htmlCharset);
            report.setRTFEncoding(rtfEncoding);
            report.setSecurityQueryParameterMap(securityQueryParameterMap);
            report.setPreviewSecurityLevel(this.securityLevel);
            report.limitSubReportQueryExecution = limitSubReportQueryExecution;
            report.isPrevParamPrompt = isPrevParamPrompt;
        } else if (template && this.applyFormula) {
            report = report.updateColInfo(report.addFormulaColumn(this.colInfo), true);
        }
        if (!template) {
            report.setTransposed(this.isTransposed, this.transposeCol);
        }
        if (!template) {
            report.subReports = this.subReports;
            report.currentNode = this.drillDownNode;
            report.setQueryFileInfo(this.queryFileInfo);
            if (this.queryFileInfo != null) {
                report.getQueryFileInfo().setParameter(parameter);
            }
        } else {
            report.copyFitGroupColInfo(report.colInfo, this.colInfo);
        }
        int index = 0;
        for (int i13 = 0; i13 < nodeList.getLength(); ++i13) {
            if (!nodeList.item(i13).getNodeName().equalsIgnoreCase("COLUMN_ATTRIBUTE")) continue;
            int dtype = -1;
            attrmap = nodeList.item(i13).getAttributes();
            for (int j = 0; j <= attrmap.getLength(); ++j) {
                if (j == attrmap.getLength()) {
                    Exception ex2 = new Exception("Invalid 'COLUMN_ATTRIBUTE' element. Missing 'Type' attribute.");
                    this.errorMessage = IOUtil.getStackTrace(ex2);
                    throw ex2;
                }
                if (!attrmap.item(j).getNodeName().equalsIgnoreCase("Type")) continue;
                dtype = DataType.findType(attrmap.item(j).getNodeValue());
                j = attrmap.getLength() + 1;
            }
            if (report.colData != null && index < report.colData.length && report.colData[index].getOriginalDataType() == dtype) {
                NodeList children = nodeList.item(i13).getChildNodes();
                IFormat format = null;
                for (int j = 0; j <= children.getLength(); ++j) {
                    if (j == children.getLength()) {
                        Exception ex2 = new Exception("Invalid 'COLUMN_ATTRIBUTE' element. Missing data format element.");
                        this.errorMessage = IOUtil.getStackTrace(ex2);
                        throw ex2;
                    }
                    format = FormatUtil.readXMLDataFormat(children.item(j), this.version);
                    if (format != null) break;
                }
                report.colData[index].dataFormat = format;
            }
            ++index;
        }
        report.setName(reportName);
        report.setPageWidth(pageWidth);
        report.setPageHeight(pageHeight);
        report.setLeftMargin(leftMargin);
        report.setRightMargin(rightMargin);
        report.setTopMargin(topMargin);
        report.setBottomMargin(bottomMargin);
        report.setOrientation(orientation);
        this.childDrillDownNodes = null;
        boolean check9 = false;
        boolean check8 = false;
        boolean check7 = false;
        boolean check6 = false;
        boolean check5 = false;
        boolean check4 = false;
        boolean check3 = false;
        boolean check2 = false;
        boolean check1 = false;
        boolean check18 = false;
        boolean check17 = false;
        boolean check16 = false;
        boolean check15 = false;
        boolean check14 = false;
        boolean check13 = false;
        boolean check12 = false;
        boolean check11 = false;
        boolean check10 = false;
        Object[] settingsArray = new Object[16];
        settingsArray[12] = new ReportLine(false);
        settingsArray[13] = new ReportGrid();
        settingsArray[14] = new ColumnHeader();
        ((ColumnHeader)settingsArray[14]).setDataFormat(FormatUtil.createFormat(7));
        settingsArray[15] = new ReportTitle();
        Vector<ReportTable> tablevector = new Vector<ReportTable>();
        Vector<String> vGuideLineIDs = new Vector<String>();
        Vector<String> hGuideLineIDs = new Vector<String>();
        for (int i14 = 0; i14 < nodeList.getLength(); ++i14) {
            int j;
            String id2;
            Node child = nodeList.item(i14);
            if (child.getNodeName().equalsIgnoreCase("PAGEHEADER")) {
                if (!template) {
                    report.setPageHeader(ReportSection.createSection(LoadXMLReportHelper.getFirstElement(child), this.version));
                } else {
                    report.getPageHeader().copyTemplate(ReportSection.createSection(LoadXMLReportHelper.getFirstElement(child), this.version), this.copyEmptySection, this.applyFormula);
                }
                check1 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTHEADER")) {
                if (!template) {
                    report.setReportHeader(ReportSection.createSection(LoadXMLReportHelper.getFirstElement(child), this.version));
                } else {
                    report.getReportHeader().copyTemplate(ReportSection.createSection(LoadXMLReportHelper.getFirstElement(child), this.version), this.copyEmptySection, this.applyFormula);
                }
                check2 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("DATATABLE")) {
                tablevector.addElement(this.createTable(reportType, LoadXMLReportHelper.getFirstElement(child), this.version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("PAGEFOOTER")) {
                if (!template) {
                    report.setPageFooter(ReportSection.createSection(LoadXMLReportHelper.getFirstElement(child), this.version));
                } else {
                    report.getPageFooter().copyTemplate(ReportSection.createSection(LoadXMLReportHelper.getFirstElement(child), this.version), this.copyEmptySection, this.applyFormula);
                }
                check3 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTFOOTER")) {
                if (!template) {
                    report.setReportFooter(ReportSection.createSection(LoadXMLReportHelper.getFirstElement(child), this.version));
                } else {
                    report.getReportFooter().copyTemplate(ReportSection.createSection(LoadXMLReportHelper.getFirstElement(child), this.version), this.copyEmptySection, this.applyFormula);
                }
                check4 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("LABEL_SETTING")) {
                settingsArray[0] = ReportCell.createCell(LoadXMLReportHelper.getFirstElement(child), this.version);
                check5 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("CHART_SETTING")) {
                settingsArray[1] = ReportChartObject.createChartObject(LoadXMLReportHelper.getFirstElement(child), this.version);
                check6 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("IMAGE_SETTING")) {
                settingsArray[2] = ReportImage.createImage(LoadXMLReportHelper.getFirstElement(child), this.version);
                check7 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("STRING_FORMULA_SETTING")) {
                settingsArray[3] = ReportCell.createCell(LoadXMLReportHelper.getFirstElement(child), this.version);
                check8 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("LOGIC_FORMULA_SETTING")) {
                settingsArray[4] = ReportCell.createCell(LoadXMLReportHelper.getFirstElement(child), this.version);
                check9 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("NUMERIC_FORMULA_SETTING")) {
                settingsArray[5] = ReportCell.createCell(LoadXMLReportHelper.getFirstElement(child), this.version);
                check10 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("TIME_FORMULA_SETTING")) {
                settingsArray[6] = ReportCell.createCell(LoadXMLReportHelper.getFirstElement(child), this.version);
                check11 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("STRING_COLUMN_SETTING")) {
                settingsArray[7] = ReportColumn.createColumn(LoadXMLReportHelper.getFirstElement(child), this.version);
                check12 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("LOGIC_COLUMN_SETTING")) {
                settingsArray[8] = ReportColumn.createColumn(LoadXMLReportHelper.getFirstElement(child), this.version);
                check13 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("NUMERIC_COLUMN_SETTING")) {
                settingsArray[9] = ReportColumn.createColumn(LoadXMLReportHelper.getFirstElement(child), this.version);
                check14 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("TIME_COLUMN_SETTING")) {
                settingsArray[10] = ReportColumn.createColumn(LoadXMLReportHelper.getFirstElement(child), this.version);
                check15 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("BARCODE_COLUMN_SETTING")) {
                settingsArray[11] = ReportColumn.createColumn(LoadXMLReportHelper.getFirstElement(child), this.version);
                check16 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("LINE_SETTING")) {
                settingsArray[12] = ReportLine.createLine(LoadXMLReportHelper.getFirstElement(child), this.version);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("GRID_SETTING")) {
                settingsArray[13] = ReportGrid.createGrid(LoadXMLReportHelper.getFirstElement(child), this.version);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("COLUMNHEADER_SETTING")) {
                settingsArray[14] = ColumnHeader.createColumnHeader(LoadXMLReportHelper.getFirstElement(child), this.version);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORT_TITLE")) {
                settingsArray[15] = ReportTitle.createReportTitle(LoadXMLReportHelper.getFirstElement(child), this.version);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("APPLY_BOUND")) {
                report.setIsApplyBoundSelected(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                check17 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("VGUIDELINE")) {
                id2 = LoadXMLReportHelper.readText(child);
                vGuideLineIDs.addElement(id2);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("HGUIDELINE")) {
                id2 = LoadXMLReportHelper.readText(child);
                hGuideLineIDs.addElement(id2);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("NULL_DATA_HANDLER")) {
                if (template) {
                    report.setNullDataOption(LoadXMLReportHelper.readCDATA(child), true);
                } else {
                    report.setNullDataOption(LoadXMLReportHelper.readCDATA(child), false);
                }
                check18 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("PARENT_NODE")) {
                report.parentNode = this.loadTreeNode(child.getChildNodes().item(0), false);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("ROOT_NODE")) {
                report.rootNode = this.loadTreeNode(child.getChildNodes().item(0), false);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("CHILD_DRILLDOWNNODES") && report.currentNode == null) {
                this.readDrillDownNodes(child);
                try {
                    DrillDownNode root = new DrillDownNode("ROOT");
                    if (this.childDrillDownNodes != null) {
                        for (j = 0; j < this.childDrillDownNodes.size(); ++j) {
                            root.add((DrillDownNode)this.childDrillDownNodes.elementAt(j));
                        }
                    }
                    report.currentNode = root;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to create drill-down tree", ex);
                }
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("DATASOURCE_DETAIL")) {
                NamedNodeMap attrMap = child.getAttributes();
                try {
                    report.setDBSourceType(Integer.parseInt(attrMap.getNamedItem("Type").getNodeValue()));
                }
                catch (NumberFormatException ex) {
                    LOGGER.log(Level.FINEST, "Invalid number", ex);
                }
                report.setQueryFileBytes(this.getFileBytes(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("BACKGROUNDCOLOR")) {
                report.setBackgroundColor(new Color(Integer.parseInt(LoadXMLReportHelper.readText(child))));
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("BACKGROUNDIMAGE")) continue;
            NodeList nList = child.getChildNodes();
            for (j = 0; j < nList.getLength(); ++j) {
                Node child1 = nList.item(j);
                if (!child1.getNodeName().equalsIgnoreCase("REPORTIMAGE")) continue;
                report.setBackgroundImage(ReportImage.createImage(child1, this.version));
            }
        }
        if (!(check1 && check2 && check3 && check4 && check5 && check6 && check7 && check8 && check9 && check10 && check11 && check12 && check13 && check14 && check15 && check16 && check17 && check18)) {
            Exception ex2 = new Exception("Invalid XML format. Missing one or more elements.");
            this.errorMessage = IOUtil.getStackTrace(ex2);
            throw ex2;
        }
        ReportTable[] table = new ReportTable[tablevector.size()];
        for (int i15 = 0; i15 < tablevector.size(); ++i15) {
            table[i15] = (ReportTable)tablevector.elementAt(i15);
        }
        report.updateFormulas(formulas);
        report.updateScripts(scripts);
        report.updateQueryParameters(queryParameters);
        report.updateFormulaParameters(formulaParameters);
        Vector<Object> temp = new Vector<Object>();
        for (Object element : settingsArray) {
            temp.addElement(element);
        }
        report.setSetting(temp);
        Vector<ReportTable> vec = report.getReportTables();
        int len = table.length <= vec.size() ? table.length : vec.size();
        ReportCell[] globalFormatTemplates = new ReportCell[]{(ReportCell)settingsArray[3], (ReportCell)settingsArray[14]};
        int columnCountMismatch = 0;
        int separatingIndex = -1;
        Vector<ReportColumn> columns = null;
        for (i2 = 0; i2 < len; ++i2) {
            if (i2 == 0) {
                try {
                    if (report.reportType == 2) {
                        ReportTable tbl = vec.elementAt(i2);
                        columnCountMismatch = tbl.getColumnCount() - table[i2].getColumnCount();
                        separatingIndex = tbl.getStartOfColumnBreakColumn() + tbl.getColumnBreakColumnCount() - columnCountMismatch;
                        columns = table[i2].getColumns();
                        table[i2].getFooter().createFormulaObjectFromName(report);
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to load crosstab specific parameters", ex);
                }
            }
            if (vec.elementAt(i2) instanceof ReportMultiSectionTable) {
                CrossTabTable crossTabTable;
                ReportMultiSectionTable mTable = (ReportMultiSectionTable)vec.elementAt(i2);
                if (!template) {
                    mTable.applyGlobalFormatToColumns(report.column);
                    mTable.loadTable(table[i2], true, separatingIndex, showRowAggregationGrandTotal);
                    if (separatingIndex >= 0 || report.isCrossTabFixedField()) {
                        mTable.adjustColumnXPos(table[i2], separatingIndex, report);
                    }
                    if (mTable instanceof CrossTabTable) {
                        crossTabTable = (CrossTabTable)mTable;
                        if (this.isDesignerDesignMode) {
                            ((CrossTabTable)mTable).getCrossTabHeader().copyExtraCells(table[i2].getHeader());
                        }
                        crossTabTable.getCrossTabHeader().copy(table[i2].getHeader(), columnCountMismatch, separatingIndex, columns, globalFormatTemplates, false, false, true, true, false, ((CrossTabTable)mTable).getFieldsCount(), report.isRowAggregationSubtotalOnLeft(), report.isShowRowAggregationSubtotal(), null, mTable.getColumns());
                        if (this.isDesignerDesignMode) {
                            crossTabTable.getCrossTabFooter().copyExtraCells(table[i2].getFooter());
                        }
                        crossTabTable.getCrossTabFooter().copy(table[i2].getFooter(), columnCountMismatch, separatingIndex, columns, globalFormatTemplates, false, false, true, true, false, ((CrossTabTable)mTable).getFieldsCount(), report.isRowAggregationSubtotalOnLeft(), report.isShowRowAggregationSubtotal(), null, mTable.getColumns());
                        continue;
                    }
                    mTable.getHeader().copy(table[i2].getHeader(), columnCountMismatch, separatingIndex, columns, globalFormatTemplates, false);
                    mTable.getFooter().copy(table[i2].getFooter(), columnCountMismatch, separatingIndex, columns, globalFormatTemplates, false);
                    continue;
                }
                mTable.applyGlobalFormatToColumns(report.column);
                mTable.copyTemplate(table[i2], this.applyFormula, this.copyEmptySection, false, false);
                if (mTable instanceof CrossTabTable) {
                    crossTabTable = (CrossTabTable)mTable;
                    crossTabTable.getCrossTabHeader().copyTemplate(table[i2].getHeader(), this.copyEmptySection, true, columns, crossTabTable.getFieldsCount(), report.isRowAggregationSubtotalOnLeft(), report.isShowRowAggregationSubtotal());
                    crossTabTable.getCrossTabFooter().copyTemplate(table[i2].getFooter(), this.copyEmptySection, true, columns, crossTabTable.getFieldsCount(), report.isRowAggregationSubtotalOnLeft(), report.isShowRowAggregationSubtotal());
                    continue;
                }
                mTable.getHeader().copyTemplate(table[i2].getHeader(), this.copyEmptySection);
                mTable.getFooter().applyStyleForDHTMLViewer(table[i2].getFooter());
                mTable.getFooter().copyTemplate(table[i2].getFooter(), this.copyEmptySection);
                continue;
            }
            if (!template) {
                vec.elementAt(i2).loadTable(table[i2]);
                if (!(table[i2] instanceof ReportMultiSectionTable) || ((ReportMultiSectionTable)table[i2]).getRowBreakHeader(0) == null) continue;
                vec.elementAt(i2).getHeader().copy(((ReportMultiSectionTable)table[i2]).getHeader());
                vec.elementAt(i2).getFooter().copy(((ReportMultiSectionTable)table[i2]).getFooter());
                continue;
            }
            vec.elementAt(i2).applyGlobalFormatToColumns(report.column);
            vec.elementAt(i2).copyTemplate(table[i2], this.applyFormula, this.copyEmptySection);
            if (!(table[i2] instanceof ReportMultiSectionTable) || ((ReportMultiSectionTable)table[i2]).getRowBreakHeader(0) == null) continue;
            vec.elementAt(i2).getHeader().copyTemplate(((ReportMultiSectionTable)table[i2]).getHeader(), this.copyEmptySection, this.applyFormula);
            vec.elementAt(i2).getFooter().copyTemplate(((ReportMultiSectionTable)table[i2]).getFooter(), this.copyEmptySection, this.applyFormula);
        }
        if (report.colInfo.length != this.colInfo.length || columnCountMismatch != 0) {
            report.adjustHeaderFormulas();
            report.adjustFooterFormulas();
        }
        for (i2 = 0; i2 < vGuideLineIDs.size(); ++i2) {
            id = (String)vGuideLineIDs.elementAt(i2);
            gl = (GuideLine)report.getData(id);
            if (report.vGuideLines == null) {
                report.vGuideLines = new Vector();
            }
            report.vGuideLines.addElement(gl);
            gl.linkSnappedElements(report);
        }
        for (i2 = 0; i2 < hGuideLineIDs.size(); ++i2) {
            id = (String)hGuideLineIDs.elementAt(i2);
            gl = (GuideLine)report.getData(id);
            if (report.hGuideLines == null) {
                report.hGuideLines = new Vector();
            }
            report.hGuideLines.addElement(gl);
            gl.linkSnappedElements(report);
        }
        if (!template) {
            report.setSideBySideLayout(sideBySide);
        }
        report.setGridLineLink();
        if (columnWrapID != null) {
            report.setColumnWrap((ColumnWrap)report.getData(columnWrapID));
        }
        if (this.version < 70) {
            report.buildFormulaList();
        } else {
            report.createFormulaObjectFromName();
        }
        if (this.version < 70) {
            report.buildScriptList();
        } else {
            report.createScriptObjectFromName();
        }
        if (this.subReports != null && this.subReports.size() > 0 && this.version >= 130 && this.version <= 160) {
            Vector<Parameter> mainQueryParam = report.getQueryParameters();
            Vector<Parameter> mainFormulaParam = report.getFormulaParameters();
            Report[] srArray = report.getSubReportArray();
            for (i = 0; i < srArray.length; ++i) {
                Parameter mainParam;
                int k;
                Parameter param;
                int j;
                Vector<Parameter> queryParam = srArray[i].getQueryParameters();
                Vector<Parameter> formulaParam = srArray[i].getFormulaParameters();
                for (j = 0; j < queryParam.size(); ++j) {
                    param = queryParam.elementAt(j);
                    for (k = 0; k < mainQueryParam.size(); ++k) {
                        mainParam = mainQueryParam.elementAt(k);
                        if (!param.getName().equals(mainParam.getName())) continue;
                        param.setShared(true);
                        param.setSharedReportName("MAIN_REPORT");
                        param.setSharedParamName(mainParam.getName());
                        mainParam.incReferenceDegree();
                        srArray[i].modified = true;
                    }
                }
                for (j = 0; j < formulaParam.size(); ++j) {
                    param = formulaParam.elementAt(j);
                    for (k = 0; k < mainFormulaParam.size(); ++k) {
                        mainParam = mainFormulaParam.elementAt(k);
                        if (!param.getName().equals(mainParam.getName())) continue;
                        param.setShared(true);
                        param.setSharedReportName("MAIN_REPORT");
                        param.setSharedParamName(mainParam.getName());
                        mainParam.incReferenceDegree();
                        srArray[i].modified = true;
                    }
                }
                if (!srArray[i].modified) continue;
                SaveReport sr = new SaveReport(srArray[i]);
                sr.saveToFile(((SubReportObject)this.subReports.elementAt(i)).getFileName());
            }
        }
        int paramCt = ParameterGrabber.getParameters(report).size();
        int paramValueCt = 0;
        int unMappedCt = 0;
        if (params != null) {
            for (i = 0; i < params.size(); ++i) {
                object = params.elementAt(i);
                if (object instanceof Object[]) {
                    for (int j = 0; j < ((Object[])object).length; ++j) {
                        if (!"UnMapped".equals(((Object[])object)[j])) {
                            ++paramValueCt;
                            continue;
                        }
                        ++unMappedCt;
                    }
                    continue;
                }
                if (!"UnMapped".equals(object)) {
                    ++paramValueCt;
                    continue;
                }
                ++unMappedCt;
            }
        }
        if (formulaParams != null) {
            for (i = 0; i < formulaParams.size(); ++i) {
                object = formulaParams.elementAt(i);
                if (object instanceof Object[]) {
                    paramValueCt += ((Object[])object).length;
                    continue;
                }
                ++paramValueCt;
            }
        }
        if (this.promptParamValue && !this.useDefaults && !isEntServer && paramCt > 0 && paramValueCt < paramCt) {
            EnterParamDialog dialog = null;
            if (this.dbInfo != null && this.dbInfo instanceof QueryFileInfo) {
                QueryFileInfo queryFileInfo = (QueryFileInfo)this.dbInfo;
                if (unMappedCt > 0) {
                    QueryInParam[] queryInParam = queryFileInfo.getInSet().getParameter();
                    if (report.isPrevParamPrompt) {
                        QueryInParam[][] paramInPromptSequence = new QueryInParam[paramCt][paramCt];
                        unMappedCt = 0;
                        for (int i16 = 0; i16 < ((Object[])params.elementAt(0)).length; ++i16) {
                            if ("UnMapped".equals(((Object[])params.elementAt(0))[i16])) {
                                paramInPromptSequence[1][unMappedCt++] = queryInParam[i16];
                                continue;
                            }
                            paramInPromptSequence[0][i16 - unMappedCt] = queryInParam[i16];
                        }
                        DBInfoBasic newDBInfo = this.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.dbInfo.getJNDIName(), this.dbInfo.getQuery(), this.dbInfo.getEnvProperties()) : new DBInfoBasic(this.dbInfo.getURLString(), this.dbInfo.getDriverName(), this.dbInfo.getUserID(), this.dbInfo.getPassword(), this.dbInfo.getQuery());
                        QueryFileInfo qfi = new QueryFileInfo(queryFileInfo.getProductName(), queryFileInfo.getVersion(), newDBInfo, new QueryInParamSet(queryInParam, paramInPromptSequence));
                        report.dbInfo = qfi;
                        dialog = QueryFileInfo.getParentDialog() != null ? new EnterParamDialog(QueryFileInfo.getParentDialog(), report, qfi, formulaParameters, 1, true, null, null, true) : new EnterParamDialog(QueryFileInfo.getParentFrame(), report, qfi, formulaParameters, 1, true, null, null);
                        report.dbInfo = this.dbInfo;
                    } else {
                        for (int i17 = 0; i17 < ((Object[])params.elementAt(0)).length; ++i17) {
                            if (!"UnMapped".equals(((Object[])params.elementAt(0))[i17]) || !"UnMapped".equals(queryInParam[i17].getValue())) continue;
                            queryInParam[i17].setValue(queryInParam[i17].getDefaultValue());
                        }
                    }
                } else {
                    dialog = QueryFileInfo.getParentDialog() != null ? new EnterParamDialog(QueryFileInfo.getParentDialog(), report, queryFileInfo, formulaParameters, true) : new EnterParamDialog(QueryFileInfo.getParentFrame(), report, queryFileInfo, formulaParameters, true);
                }
            } else {
                dialog = QueryFileInfo.getParentDialog() != null ? new EnterParamDialog(QueryFileInfo.getParentDialog(), report, null, formulaParameters, true) : new EnterParamDialog(QueryFileInfo.getParentFrame(), report, null, formulaParameters, true);
            }
            if (dialog != null) {
                dialog.setVisible(true);
                if (dialog.isCancelled()) {
                    return null;
                }
                if (dialog.queryParamHasChanged() || unMappedCt > 0) {
                    report = ReloadReport.reloadData(report, true, null, 0, -1);
                    report.setInitializeReportError(this.errorMessage);
                    return report;
                }
            }
        } else if (unMappedCt > 0) {
            QueryFileInfo queryFileInfo = (QueryFileInfo)report.dbInfo;
            QueryInParam[] queryInParam = queryFileInfo.getInSet().getParameter();
            for (int i18 = 0; i18 < ((Object[])params.elementAt(0)).length; ++i18) {
                if (!"UnMapped".equals(((Object[])params.elementAt(0))[i18]) || !"UnMapped".equals(queryInParam[i18].getValue())) continue;
                queryInParam[i18].setValue(queryInParam[i18].getDefaultValue());
            }
            report = ReloadReport.reloadData(report, true, null, 0, -1);
            report.setInitializeReportError(this.errorMessage);
            return report;
        }
        if (report.getTableOfContentsObject() != null) {
            report.getTableOfContentsObject().setReport(report);
        }
        report.setSnapToGrid(snapToGrid, gridStepSize, cmGridStepSize);
        report.setAdjustFont(isAdjustFont);
        report.setKeepDataSourceOrder(keepDataSourceOrder);
        report.setPackedSubReportByteArray(this.subReports);
        ReportTable tbl = report.getReportTables().elementAt(0);
        for (int j = 0; j < tbl.getColumnCount(); ++j) {
            if (!report.colInfo[report.getColInfoIndex(tbl.getColumn(j))].isColumnBreak() || tbl.getColumn(j).getDrillDownName() != null) continue;
            tbl.getColumn(j).setDrillDownName(report.colInfo[report.getColInfoIndex(tbl.getColumn(j))].getDrillDownName());
        }
        report.setInitializeReportError(this.errorMessage);
        return report;
    }

    private ReportTable createTable(int reportType, Node node, int version) throws Exception {
        switch (reportType) {
            case 0: 
            case 4: {
                return ReportTable.createTable(node, version);
            }
            case 1: 
            case 2: 
            case 3: {
                return ReportMultiSectionTable.createMultiSectionTable(node, version);
            }
        }
        return null;
    }

    private ColData[] createColData(Node dnode, int version) throws Exception {
        int i;
        NodeList nodeList = dnode.getChildNodes();
        Vector<ColData> colDataVector = new Vector<ColData>();
        int nRow = -1;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            if (!nodeList.item(i2).getNodeName().equalsIgnoreCase("COLUMN")) continue;
            Node child = nodeList.item(i2);
            NamedNodeMap attrmap = child.getAttributes();
            int dtype = -1;
            String name = null;
            boolean typecheck = false;
            for (int j = 0; j < attrmap.getLength(); ++j) {
                Node attr = attrmap.item(j);
                if (attr.getNodeName().equalsIgnoreCase("Type")) {
                    dtype = DataType.findType(attr.getNodeValue());
                    typecheck = true;
                    break;
                }
                if (!attr.getNodeName().equalsIgnoreCase("Name")) continue;
                name = attr.getNodeValue();
            }
            if (!typecheck || name == null) continue;
            Vector<Object> data = new Vector<Object>();
            NodeList dataList = child.getChildNodes();
            for (int j = 0; j < dataList.getLength(); ++j) {
                if (!dataList.item(j).getNodeName().equalsIgnoreCase("DATA")) continue;
                String datatext = LoadXMLReportHelper.readCDATA(dataList.item(j));
                if (datatext.equals("")) {
                    datatext = LoadXMLReportHelper.readText(dataList.item(j));
                }
                data.addElement(DataType.read(datatext));
            }
            if (nRow == -1) {
                nRow = data.size();
            } else if (nRow != data.size()) {
                throw new Exception("The number of rows does not match for each column.");
            }
            ColData cData = new ColData(name, dtype, data.size(), nodeList.getLength());
            for (int j = 0; j < data.size(); ++j) {
                cData.add(data.elementAt(j));
            }
            colDataVector.addElement(cData);
        }
        if (nRow == -1) {
            return null;
        }
        ColData[] colData = new ColData[colDataVector.size() + 1];
        for (i = 0; i < colDataVector.size(); ++i) {
            colData[i] = (ColData)colDataVector.elementAt(i);
        }
        colData[colDataVector.size()] = new ColData("qbCount", 4, colData.length);
        for (i = 0; i < nRow; ++i) {
            colData[colDataVector.size()].add(i);
        }
        return colData;
    }

    private void loadTree(Node node) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase("DRILLDOWNTREE")) {
            return;
        }
        this.drillDownNode = this.loadTreeNode(LoadXMLReportHelper.getFirstElement(node), true);
    }

    private DrillDownNode loadTreeNode(Node node, boolean loadChildren) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase("DRILLDOWNNODE")) {
            return null;
        }
        String nodename = null;
        String filename = null;
        NamedNodeMap map = node.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            if (map.item(i).getNodeName().equalsIgnoreCase("Name")) {
                nodename = map.item(i).getNodeValue();
                continue;
            }
            if (!map.item(i).getNodeName().equalsIgnoreCase("Filename")) continue;
            filename = map.item(i).getNodeValue();
        }
        if (nodename == null || filename == null) {
            throw new Exception("Invalid 'DRILLDOWNNODE' element. Missing 'Name' or 'Filename' attributes.");
        }
        DrillDownNode drilldownnode = new DrillDownNode(nodename);
        drilldownnode.setFileName(filename);
        Vector<Integer> mappingvector = new Vector<Integer>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("MAPPING")) {
                mappingvector.addElement(Integer.valueOf(LoadXMLReportHelper.readText(nodeList.item(i))));
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("DRILLDOWNNODE") && loadChildren) {
                drilldownnode.add(this.loadTreeNode(nodeList.item(i), true));
                continue;
            }
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase("CROSSTABDRILLDOWN")) continue;
            drilldownnode.setCrossTabDrillDown(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(nodeList.item(i))));
        }
        int[] mapping = new int[mappingvector.size()];
        for (int i = 0; i < mappingvector.size(); ++i) {
            mapping[i] = (Integer)mappingvector.elementAt(i);
        }
        drilldownnode.setColumnMapping(mapping);
        return drilldownnode;
    }

    private boolean[] getTransposeColumn(String s) {
        try {
            int ttype;
            if (s == null || s.equals("")) {
                return null;
            }
            Vector<Integer> vec = new Vector<Integer>();
            int max = -1;
            StreamTokenizer st = new StreamTokenizer(new StringReader(s));
            while ((ttype = st.nextToken()) != 10 && ttype != -1) {
                if (ttype == -2) {
                    if (st.nval > (double)max) {
                        max = (int)st.nval;
                    }
                    vec.addElement((int)st.nval);
                    continue;
                }
                throw new IllegalArgumentException("Format shall be \"n1 n2 n3 n4 ...\" where n1, n2..  . are integers");
            }
            if (max < 0) {
                return null;
            }
            boolean[] tmp = new boolean[max + 1];
            for (int j = 0; j < vec.size(); ++j) {
                tmp[((Integer)vec.elementAt((int)j)).intValue()] = true;
            }
            return tmp;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to get transpose column", ex);
            return null;
        }
    }

    private void loadSubReports(Node node) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase("SUBREPORTVECTOR")) {
            return;
        }
        this.subReports = new Vector();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (!child.getNodeName().equalsIgnoreCase("SUBREPORTOBJECT")) continue;
            this.subReports.addElement(SubReportObject.createSubReportObject(child, this.version));
        }
    }

    private void readDrillDownNodes(Node node) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase("CHILD_DRILLDOWNNODES")) {
            return;
        }
        this.childDrillDownNodes = new Vector();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase("DRILLDOWNNODE")) continue;
            this.childDrillDownNodes.addElement(this.loadTreeNode(nodeList.item(i), false));
        }
    }

    public static String readCDATA(Node node) throws Exception {
        return XMLUtil.readCDATA(node);
    }

    public static String readText(Node node) throws Exception {
        return XMLUtil.readText(node);
    }

    public static boolean parseBoolean(String b) {
        return (b = b.trim()).equalsIgnoreCase("t") || b.equalsIgnoreCase("true") || b.equalsIgnoreCase("y") || b.equalsIgnoreCase("yes");
    }

    public static Node getFirstElement(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            return nodeList.item(i);
        }
        return null;
    }

    private byte[][] getFileBytes(Node node) {
        Vector children = this.sort(node.getChildNodes());
        if (children.size() < 1) {
            return null;
        }
        Vector<byte[]> list = new Vector<byte[]>();
        for (int i = 0; i < children.size(); ++i) {
            Node child = (Node)children.elementAt(i);
            if (!child.getNodeName().equalsIgnoreCase("FILE")) continue;
            try {
                String text = LoadXMLReportHelper.readCDATA(child);
                list.addElement(IOUtil.textToBytes(text));
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to process byte data", ex);
            }
        }
        if (list.size() == 0) {
            return null;
        }
        byte[][] bytes = new byte[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            bytes[i] = (byte[])list.elementAt(i);
        }
        return bytes;
    }

    private Vector sort(NodeList nodeList) {
        int i;
        if (nodeList == null) {
            return new Vector();
        }
        Vector<Object> list = new Vector<Object>();
        for (i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            int insertIndex = 0;
            int weight = 0;
            NamedNodeMap attrMap = node.getAttributes();
            if (attrMap != null) {
                for (int j = 0; j < attrMap.getLength(); ++j) {
                    if (!attrMap.item(j).getNodeName().equalsIgnoreCase("OrderIndex")) continue;
                    try {
                        weight = Integer.parseInt(attrMap.item(j).getNodeValue());
                        for (int k = list.size() - 1; k >= -1; ++k) {
                            if (k == -1) {
                                insertIndex = 0;
                                continue;
                            }
                            if (((IndexNode)list.elementAt(k)).getWeight() > weight) continue;
                            insertIndex = k + 1;
                            k = list.size() + 1;
                        }
                        j = attrMap.getLength();
                        continue;
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Invalid number", ex);
                    }
                }
            }
            IndexNode iNode = new IndexNode(weight, node);
            list.insertElementAt(iNode, insertIndex);
        }
        for (i = 0; i < list.size(); ++i) {
            list.setElementAt(((IndexNode)list.elementAt(i)).getNode(), i);
        }
        return list;
    }

    private class IndexNode {
        private int weight = 0;
        private Node node = null;

        public IndexNode(int w, Node n) {
            this.weight = w;
            this.node = n;
        }

        public int getWeight() {
            return this.weight;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

