/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.report.ColumnarTable;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.ColInfo;

public class MailingLabelsTable
extends ColumnarTable {
    private static final Logger LOGGER = Logger.getLogger(MailingLabelsTable.class.getName());

    public MailingLabelsTable(Report report) {
        this(report, true);
    }

    MailingLabelsTable(Report report, boolean createLabel) {
        super(report, false);
        this.getHeader().setVisible(false);
        this.getFooter().setVisible(false);
        this.formatColumn(createLabel);
    }

    public MailingLabelsTable(MailingLabelsTable _table) {
        super(_table);
    }

    @Override
    public void formatColumn() {
        this.formatColumn(true);
    }

    @Override
    public void formatColumn(boolean createLabel) {
        if (createLabel) {
            this.formatLabelColumn();
        } else {
            for (int i = 0; i < this.report.colInfo.length; ++i) {
                ReportColumn rCol = this.report.createColumn(i, this.report.colInfo.length);
                rCol.setVisible(this.report.colInfo[i].isVisible());
                this.addColumn(rCol);
            }
        }
    }

    private void formatLabelColumn() {
        int nCol = this.report.colInfo.length;
        ColInfo[] colInfo = this.report.colInfo;
        this.report.colInfo = new ColInfo[nCol * 2];
        double y = 0.0;
        ReportColumn[] cols = new ReportColumn[nCol * 2];
        Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
        formulaVec.add(this.report.formulas);
        for (int j = 0; this.report.subReports != null && j < this.report.subReports.size(); ++j) {
            Report rpt = this.report.getSubReportArray()[j];
            if (rpt == null) continue;
            formulaVec.add(rpt.formulas);
        }
        for (int i = 0; i < nCol; ++i) {
            this.report.colInfo[i] = colInfo[i];
            ReportColumn rCol = this.report.createColumn(i, nCol);
            rCol.setVisible(this.report.colInfo[i].isVisible());
            String text = "\"" + rCol.getText() + " : \"";
            Formula form = new Formula("ML_Generated_Formula" + i, text);
            this.report.colInfo[i + nCol] = new ColInfo(form, text, 12);
            this.report.colInfo[i + nCol].setVisible(this.report.colInfo[i].isVisible());
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                form.setFormula(parser.parse(formulaVec, null, null, "ML_Generated_Formula" + i));
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to read formula", ex);
            }
            this.report.formulas.addElement(form);
            ReportColumn colLbl = this.report.createColumn(i + nCol, nCol);
            colLbl.setVisible(this.report.colInfo[i].isVisible());
            if (rCol.isVisible()) {
                colLbl.setX(0.0);
                colLbl.setY(y);
                colLbl.setWidth(2.0);
                rCol.setX(2.0);
                rCol.setY(y);
                y += rCol.getHeight();
            }
            cols[i] = rCol;
            cols[i + nCol] = colLbl;
        }
        for (ReportColumn col : cols) {
            this.addColumn(col);
        }
        this.setHeight(y);
        ColumnWrap colWrapH = new ColumnWrap(3.0);
        ColumnWrap colWrap = new ColumnWrap(3.0);
        ColumnWrap colWrapF = new ColumnWrap(3.0);
        colWrapH.setNextLine(colWrap);
        colWrap.setNextLine(colWrapF);
        colWrap.setWrapCount(-1);
        this.getHeader().addData(colWrapH);
        this.addImage(colWrap);
        this.getHeader().addData(colWrapF);
        this.report.setColumnWrap(colWrapH);
    }
}

