/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DataSet;
import quadbase.common.util.internal.DataSetColumn;
import quadbase.common.util.internal.IDataSet;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.MultiDimData;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.report.SummaryTable;

public class MasterDetailsTable
extends ReportMultiSectionTable {
    private static final Logger LOGGER = Logger.getLogger(MasterDetailsTable.class.getName());
    MultiDimData mData;
    int count;

    public MasterDetailsTable(Report report) {
        super(report.getLocale(), report.getTimeZone());
        this.setWidth(report.getActualPageWidth());
        for (int i = 0; i < report.colInfo.length; ++i) {
            ReportColumn rCol = report.createColumn(i, report.colInfo.length);
            rCol.setVisible(report.colInfo[i].isVisible());
            this.addColumn(rCol);
        }
        this.mData = this.createMultiDimData(report);
        this.dataHeader = new ReportSection[1];
        this.dataFooter = new ReportSection[1];
        this.dataHeader[0] = new ReportSection(this);
        this.dataFooter[0] = new ReportSection(this);
        this.formatColumn();
    }

    public MasterDetailsTable(MasterDetailsTable _table) {
        super(_table);
        this.mData = _table.mData;
        this.count = _table.count;
        this.header = _table.header;
        this.footer = _table.footer;
        for (int i = 0; i < _table.getColumnCount(); ++i) {
            ReportColumn tcol = new ReportColumn(_table.getColumn(i));
            tcol.resetData();
            this.addColumn(tcol);
        }
    }

    @Override
    public void formatColumn() {
        if (this.mData.report.isSideBySideLayout()) {
            this.formatColumnForSideBySideLayout();
        } else {
            this.formatColumnForRegularLayout();
        }
    }

    private void formatColumnForRegularLayout() {
        int visibleColCount = this.getVisibleColumnCount();
        ReportCell[] cells = new ReportCell[visibleColCount + this.mData.report.masterIndex.length * 2];
        int ct = 0;
        int ic = 0;
        int mt = 0;
        double invisibleColOffset = 0.0;
        double masterSlaveOffset = 0.0;
        if (this.getColumnCount() > 0) {
            invisibleColOffset = (double)visibleColCount * this.getColumn(0).getWidth();
            masterSlaveOffset = (double)this.mData.report.masterIndex.length * this.getColumn(0).getHeight();
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            NewFormulaParser parser;
            InputStreamReader inputStreamReader;
            ByteArrayInputStream inputStream;
            Formula formulaObj;
            String text;
            if (this.mData.report.colInfo[i].isMaster()) {
                cells[ct + mt] = new ColumnHeader();
                text = "getHeader(COL(" + i + "))+ \" :\"";
                formulaObj = new Formula(null, text);
                try {
                    inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                    inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    parser = new NewFormulaParser(inputStreamReader);
                    formulaObj.setFormula(parser.parse(new Vector(), null, null, null));
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Cannot read formula", ex);
                }
                cells[ct + mt].setFormulaObj(formulaObj);
                cells[ct + mt].setY((double)(mt / 2) * cells[ct + mt].getHeight());
                cells[ct + mt].setWidth(2.0);
                cells[ct + mt].setAlign((short)1);
                cells[ct + mt + 1] = new ReportCell();
                text = "{" + this.getColumn(i).getText() + "}";
                formulaObj = new Formula(null, text);
                try {
                    inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                    inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    parser = new NewFormulaParser(inputStreamReader);
                    formulaObj.setFormula(parser.parse(new Vector(), null, null, null));
                    formulaObj.getDatatype(this.mData.report);
                    cells[ct + mt + 1].setFormulaObj(formulaObj);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Failed to read formula", e);
                }
                cells[ct + mt + 1].setY((double)(mt / 2) * cells[ct + mt].getHeight());
                cells[ct + mt + 1].setX(2.0);
                cells[ct + mt + 1].setWidth(2.0);
                cells[ct + mt + 1].setAlign((short)1);
                mt += 2;
            }
            if (this.getColumn(i).isVisible()) {
                this.getColumn(i).setX((double)ct * this.getColumn(i).getWidth());
                cells[ct + mt] = new ColumnHeader();
                text = "getHeader(COL(" + i + "))";
                formulaObj = new Formula(null, text);
                try {
                    inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                    inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    parser = new NewFormulaParser(inputStreamReader);
                    formulaObj.setFormula(parser.parse(new Vector(), null, null, null));
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Cannot read formula", ex);
                }
                cells[ct + mt].setFormulaObj(formulaObj);
                cells[ct + mt].setX((double)ct * cells[ct + mt].getWidth());
                cells[ct + mt].setY(masterSlaveOffset);
                ++ct;
                continue;
            }
            this.getColumn(i).setX((double)ic * this.getColumn(i).getWidth() + invisibleColOffset);
            ++ic;
        }
        if (cells.length > 0) {
            this.dataHeader[0].setData(cells);
            this.dataHeader[0].setHeight((double)(this.mData.report.masterIndex.length + 1) * cells[0].getHeight());
        }
    }

    private void formatColumnForSideBySideLayout() {
        int visibleColCount = this.getVisibleColumnCount();
        ReportCell[] headerCells = new ReportCell[visibleColCount];
        ReportCell[] masterCells = new ReportCell[this.mData.report.masterIndex.length * 2];
        int ct = 0;
        int ic = 0;
        int mt = 0;
        double invisibleColOffset = 0.0;
        if (this.getColumnCount() > 0) {
            invisibleColOffset = (double)visibleColCount * this.getColumn(0).getWidth();
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            NewFormulaParser parser;
            InputStreamReader inputStreamReader;
            ByteArrayInputStream inputStream;
            Formula formulaObj;
            String text;
            if (this.mData.report.colInfo[i].isMaster()) {
                masterCells[mt] = new ColumnHeader();
                text = "getHeader(COL(" + i + "))+ \" :\"";
                formulaObj = new Formula(null, text);
                try {
                    inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                    inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    parser = new NewFormulaParser(inputStreamReader);
                    formulaObj.setFormula(parser.parse(new Vector(), null, null, null));
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Cannot read formula", ex);
                }
                masterCells[mt].setFormulaObj(formulaObj);
                masterCells[mt].setY((double)(mt / 2) * masterCells[mt].getHeight());
                masterCells[mt].setWidth(1.0);
                masterCells[mt].setAlign((short)1);
                masterCells[mt + 1] = new ReportCell();
                text = "{" + this.getColumn(i).getText() + "}";
                formulaObj = new Formula(null, text);
                try {
                    inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                    inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    parser = new NewFormulaParser(inputStreamReader);
                    formulaObj.setFormula(parser.parse(new Vector(), null, null, null));
                    formulaObj.getDatatype(this.mData.report);
                    masterCells[mt + 1].setFormulaObj(formulaObj);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Cannot read formula", e);
                }
                masterCells[mt + 1].setY((double)(mt / 2) * masterCells[mt].getHeight());
                masterCells[mt + 1].setX(1.0);
                masterCells[mt + 1].setWidth(1.0);
                masterCells[mt + 1].setAlign((short)1);
                mt += 2;
            }
            if (this.getColumn(i).isVisible()) {
                this.getColumn(i).setX((double)ct * this.getColumn(i).getWidth() + 2.0);
                headerCells[ct] = new ColumnHeader();
                text = "getHeader(COL(" + i + "))";
                formulaObj = new Formula(null, text);
                try {
                    inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                    inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    parser = new NewFormulaParser(inputStreamReader);
                    formulaObj.setFormula(parser.parse(new Vector(), null, null, null));
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Cannot read formula", ex);
                }
                headerCells[ct].setFormulaObj(formulaObj);
                headerCells[ct].setX((double)ct * headerCells[ct].getWidth() + 2.0);
                headerCells[ct].setY(0.0);
                ++ct;
                continue;
            }
            this.getColumn(i).setX((double)ic * this.getColumn(i).getWidth() + invisibleColOffset);
            ++ic;
        }
        if (headerCells.length > 0) {
            this.dataHeader[0].setData(headerCells);
            this.dataHeader[0].setHeight(headerCells[0].getHeight());
        }
        if (masterCells.length > 0) {
            ReportSection masterSection = new ReportSection("MTR_SEC", "Master Section");
            masterSection.setData(masterCells);
            masterSection.setID("MTR_SEC");
            double masterH = (double)this.mData.report.masterIndex.length * masterCells[0].getHeight();
            masterH = Math.ceil((double)QbUtil.getPixelPerInch() * masterH) / (double)QbUtil.getPixelPerInch();
            masterSection.setHeight(masterH);
            masterSection.setWidth(2.0);
            this.setMasterSection(masterSection);
        }
    }

    private MultiDimData createMultiDimData(Report report) {
        MultiDimData mData = new MultiDimData(report);
        for (int i = 0; i < report.colData[0].getSize(); ++i) {
            mData.addRecNo(i);
        }
        mData.build(0);
        if (!report.isColDataSorted() && mData.report.recIndex == null) {
            mData.report.recIndex = new int[report.colData[0].getSize()];
            this.count = 0;
            this.traversMultiDataTree(mData, mData.report.recIndex);
            for (ColData element : mData.report.colData) {
                element.setRecIndex(report.recIndex);
            }
        }
        return mData;
    }

    private void traversMultiDataTree(MultiDimData multiData, int[] recIndex) {
        block4: {
            if (multiData == null) break block4;
            if (multiData.multiData != null) {
                for (MultiDimData element : multiData.multiData) {
                    this.traversMultiDataTree(element, recIndex);
                }
            } else {
                for (int i = 0; i < multiData.recNoVec.size(); ++i) {
                    recIndex[this.count++] = multiData.recNoVec.elementAt(i);
                }
            }
        }
    }

    @Override
    public void formatTable() throws Exception {
        int i;
        Vector<ReportTable> _subTables = this.getSubTable();
        this.reformat();
        int nCol = this.mData.report.colInfo.length;
        IDataSet[] dataSetTree = new DataSet[nCol];
        for (int j = 0; j < nCol; ++j) {
            dataSetTree[j] = new DataSetColumn(MasterDetailsTable.getColumnAddress(j), ServerMessage.getMaxFieldSize(), nCol, true, null);
        }
        this.createTable(this.mData, this, dataSetTree);
        if (this.countSubTable() == 0) {
            ReportTable rTbl = new ReportTable(this);
            for (i = 0; i < this.mData.report.colInfo.length; ++i) {
                ReportColumn rCol = new ReportColumn(this.getColumn(i));
                rTbl.addColumn(rCol);
            }
            this.addSubTable(rTbl);
            if (this.dataHeader.length > 0) {
                rTbl.setHeader(this.dataHeader[0]);
                rTbl.setFooter(this.dataFooter[0]);
            }
        }
        if (this.mData.report.getTopN() > 0) {
            this.topN(this, this.mData.report, 0);
        }
        this.setTableNumber(this);
        Vector<ReportTable> subTables = this.getSubTable();
        if (_subTables.size() != subTables.size()) {
            this.releaseDiskBuffer();
            ColData.releaseDiskBuffer(this.mData.report.colData);
            return;
        }
        for (i = 0; i < _subTables.size(); ++i) {
            ReportTable _tbl = _subTables.elementAt(i);
            ReportTable tbl = subTables.elementAt(i);
            tbl.copySortingInfo(_tbl, 0, true, this.mData.report);
            tbl.setTableNumber(_tbl.getTableNumber());
        }
        this.setTableID();
        this.releaseDiskBuffer();
        ColData.releaseDiskBuffer(this.mData.report.colData);
    }

    private ReportTable createTable(MultiDimData data, ReportTreeTable cTbl, IDataSet[] dataSetTree) throws Exception {
        int i;
        if (data.report.isColDataSorted() || data.report.recIndex != null) {
            return SummaryTable.createTableFromSortedData(this, data, cTbl);
        }
        int nCol = data.report.colInfo.length;
        if (data.multiData != null) {
            for (MultiDimData element : data.multiData) {
                Properties treeProp = new Properties();
                treeProp.put("DataSetTreeArray", dataSetTree);
                ReportTable subTbl = this.createTable(element, new ReportTreeTable(this, nCol, treeProp), dataSetTree);
                if (subTbl == null) continue;
                cTbl.addSubTable(subTbl);
            }
            if (cTbl.countSubTable() == 0) {
                return null;
            }
            if (data.level <= this.dataHeader.length && data.level > 0) {
                cTbl.setHeader(this.dataHeader[data.level - 1]);
                cTbl.setFooter(this.dataFooter[data.level - 1]);
                cTbl.getFirstTable().getColumn(data.report.breakColIndex[data.level - 1]).setData(0, data.getFieldName());
                cTbl.setDrillDownData(data.report.breakColIndex[data.level - 1], data.getFieldName());
            }
            return cTbl;
        }
        if (data.plotData == null) {
            return null;
        }
        if (data.plotData.isEmpty()) {
            return null;
        }
        int nRow = data.getValueCount();
        int vIndex = 0;
        ReportTable rTbl = new ReportTable(this);
        for (i = 0; i < nCol; ++i) {
            int j;
            ReportColumn rCol = new ReportColumn(this.getColumn(i), null);
            rCol.resetData();
            Object tblCol = null;
            Object drillDownValue = null;
            Vector<Object> aData = new Vector<Object>();
            if (data.report.colInfo[i].isRowBreak()) {
                for (j = 0; j < nRow; ++j) {
                    tblCol = "";
                    if (j == 0 && i == data.report.breakColIndex[data.level - 1]) {
                        drillDownValue = tblCol = data.getFieldName();
                        aData.addElement(tblCol);
                    }
                    rCol.addData(tblCol);
                }
            } else if (data.report.colInfo[i].getFormulaObj() == null) {
                for (j = 0; j < nRow; ++j) {
                    tblCol = data.getValue(j, vIndex);
                    rCol.addData(tblCol);
                }
                data.getValueList(vIndex, aData);
                ++vIndex;
            }
            int aDataSize = aData.size();
            for (int j2 = 0; j2 < aDataSize; ++j2) {
                rCol.addActualData(aData.elementAt(j2));
            }
            rCol.setDrillDownData(drillDownValue);
            rTbl.addColumn(rCol);
        }
        for (i = 0; i < nCol; ++i) {
            Formula formulaObj = data.report.colInfo[i].getFormulaObj();
            if (formulaObj == null) {
                String name = data.report.colInfo[i].getFormulaName();
                String text = data.report.colInfo[i].getFormula();
                if (text == null) continue;
                formulaObj = new Formula(name, text);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                formulaObj.setFormula(parser.parse(new Vector(), null, null, null));
                Object obj = null;
                for (int j = 0; j < nRow; ++j) {
                    try {
                        obj = formulaObj.getValue(rTbl, j, 1, 1, 1, 1, data.report, null, null);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Failed to get formula value", ex);
                        obj = null;
                    }
                    rTbl.getColumn(i).addData(obj);
                }
                continue;
            }
            Object obj = null;
            for (int j = 0; j < nRow; ++j) {
                try {
                    obj = formulaObj.getValue(rTbl, j, 1, 1, 1, 1, data.report, null, null);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to get formula value", ex);
                    obj = null;
                }
                rTbl.getColumn(i).addData(obj);
            }
        }
        if (data.level <= this.dataHeader.length && data.level > 0) {
            rTbl.setHeader(this.dataHeader[data.level - 1]);
            rTbl.setFooter(this.dataFooter[data.level - 1]);
        }
        return rTbl;
    }

    private static String getColumnAddress(int j) {
        return "MDCOL_" + j + "_" + QbUtil.nextNumber();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.reformat();
        super.write(out);
        try {
            this.formatTable();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to format table", ex);
        }
    }

    private void setTableNumber(ReportTreeTable cTbl) {
        for (int i = 0; i < cTbl.getSubTable().size(); ++i) {
            cTbl.getSubTable(i).setTableNumber(i);
        }
    }

    public void topN(ReportTable table, Report report, int level) {
        block12: {
            block10: {
                Vector<ReportTable> subTable;
                block11: {
                    if (!(table instanceof ReportTreeTable)) break block10;
                    subTable = ((ReportTreeTable)table).getSubTable();
                    if (!report.breakColInfo[level].isTopN()) break block11;
                    int colIndex = 0;
                    for (int i = 0; i < report.colInfo.length; ++i) {
                        if (report.colInfo[i] != report.breakColInfo[level]) continue;
                        colIndex = i;
                    }
                    int[] sortedIndex = ((ReportTreeTable)table).sort(colIndex, true);
                    if (sortedIndex == null) break block12;
                    int size = report.getTopN() < sortedIndex.length ? report.getTopN() : sortedIndex.length;
                    int[] sortedTopNIndex = new int[size];
                    for (int i = 0; i < size; ++i) {
                        sortedTopNIndex[i] = sortedIndex[i];
                    }
                    ((ReportTreeTable)table).setTopNTable(sortedTopNIndex);
                    break block12;
                }
                for (int i = 0; i < subTable.size(); ++i) {
                    this.topN(subTable.elementAt(i), report, level + 1);
                }
                break block12;
            }
            int colIndex = 0;
            for (int i = 0; i < report.colInfo.length; ++i) {
                if (!report.colInfo[i].isTopN()) continue;
                colIndex = i;
            }
            ReportColumn column = table.getColumn(colIndex);
            int[] sortedIndex = null;
            sortedIndex = !report.isAggregationOn() ? column.sort(report.isAscending()) : column.sortActualdata(report.isAscending());
            if (sortedIndex == null) {
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    table.getColumn(i).setTopNData(null, false, (short)0);
                }
            } else {
                int i;
                int size = report.getTopN() < sortedIndex.length ? report.getTopN() : sortedIndex.length;
                int[] sortedTopNIndex = new int[size];
                for (i = 0; i < size; ++i) {
                    sortedTopNIndex[i] = sortedIndex[i];
                }
                for (i = 0; i < table.getColumnCount(); ++i) {
                    short aggr = 0;
                    if (report.colInfo[i].isAggregatedColumn()) {
                        aggr = report.colInfo[i].getAggregation();
                    }
                    table.getColumn(i).setTopNData(sortedTopNIndex, report.colInfo[i].isRowBreak(), aggr);
                }
            }
        }
    }

    @Override
    public void createFormulaObject(Report report) {
        super.createFormulaObject(report);
        if (this.masterSection != null) {
            this.masterSection.createFormulaObject(report);
        }
    }

    @Override
    public void createFormulaObjectFromName(Report report) {
        super.createFormulaObjectFromName(report);
        if (this.masterSection != null) {
            this.masterSection.createFormulaObjectFromName(report);
        }
    }
}

