/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.report.Aggregation;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.PlotData;
import quadbase.reportdesigner.report.Report;

public class MultiDimData {
    private static final Logger LOGGER = Logger.getLogger(MultiDimData.class.getName());
    public MultiDimData[] multiData;
    public MultiDimData aggrData;
    public MultiDimData parent;
    PlotData plotData;
    HashMap hashmap;
    Vector<Integer> recNoVec = new Vector();
    private int colDataMapping;
    private int fieldMapping;
    Report report;
    int level;

    MultiDimData(Report _report) {
        this.report = _report;
    }

    public Report getReport() {
        return this.report;
    }

    public void build(int level) {
        if (!this.report.isColDataSorted() && this.report.recIndex == null && level < this.report.breakColInfo.length) {
            int recNo;
            int i;
            this.hashmap = new HashMap();
            ColData colData = this.report.colData[this.report.breakColInfo[level].getMapping()];
            colData.recIndex = null;
            for (i = 0; i < this.recNoVec.size(); ++i) {
                recNo = this.recNoVec.elementAt(i);
                if (this.hashmap.get(colData.getData(recNo)) != null) continue;
                this.hashmap.put(colData.getData(recNo), this.hashmap.size());
            }
            this.multiData = new MultiDimData[this.hashmap.size()];
            for (i = 0; i < this.multiData.length; ++i) {
                this.multiData[i] = new MultiDimData(this.report);
            }
            for (i = 0; i < this.recNoVec.size(); ++i) {
                recNo = this.recNoVec.elementAt(i);
                int index = (Integer)this.hashmap.get(colData.getData(recNo));
                this.multiData[index].addRecNo(recNo);
            }
            ++level;
            for (MultiDimData element : this.multiData) {
                element.build(level);
            }
        }
    }

    private MultiDimData(int lv, Report _report, MultiDimData p, int colMap, int fieldMap, MultiDimData[] children) {
        this.report = _report;
        this.parent = p;
        this.level = lv;
        this.colDataMapping = colMap;
        this.fieldMapping = fieldMap;
        if (children != null) {
            this.multiData = children;
        } else {
            this.plotData = new PlotData(this.report);
        }
    }

    public void createTreeFromSortedData() {
        int i;
        LOGGER.finest("Create tree from sorted data");
        int numBreakCol = this.report.breakColInfo.length;
        int numRow = this.report.colData[0].getSize();
        MultiDimData[] currentMDD = new MultiDimData[numBreakCol];
        Vector[] storedMDD = new Vector[numBreakCol];
        MultiDimData p = this;
        for (i = 0; i < numBreakCol; ++i) {
            int cMap = this.report.breakColInfo[i].getMapping();
            int fieldMap = this.report.colData[cMap].mapHashTable(0);
            if (i < numBreakCol - 1) {
                MultiDimData[] children = new MultiDimData[this.report.colData[this.report.breakColInfo[i + 1].getMapping()].getNumField()];
                currentMDD[i] = new MultiDimData(i + 1, this.report, p, cMap, fieldMap, children);
                p = currentMDD[i];
            } else {
                currentMDD[i] = new MultiDimData(i + 1, this.report, p, cMap, fieldMap, null);
                currentMDD[i].plotData.add(0);
            }
            storedMDD[i] = new Vector();
        }
        for (int recNo = 1; recNo < numRow; ++recNo) {
            for (int i2 = 0; i2 < numBreakCol; ++i2) {
                int cMap = this.report.breakColInfo[i2].getMapping();
                Object oldvalue = this.report.colData[cMap].getData(recNo - 1);
                Object newvalue = this.report.colData[cMap].getData(recNo);
                if (oldvalue == null && newvalue == null || oldvalue != null && newvalue != null && oldvalue.equals(newvalue)) {
                    if (i2 != numBreakCol - 1) continue;
                    currentMDD[i2].plotData.add(recNo);
                    continue;
                }
                for (int j = i2; j < numBreakCol; ++j) {
                    int jcMap = this.report.breakColInfo[j].getMapping();
                    int jfieldMap = this.report.colData[jcMap].mapHashTable(recNo);
                    if (j == i2) {
                        storedMDD[j].addElement(currentMDD[j]);
                    }
                    if (j < numBreakCol - 1) {
                        storedMDD[j + 1].addElement(currentMDD[j + 1]);
                        Vector cVect = storedMDD[j + 1];
                        for (int k = 0; k < cVect.size(); ++k) {
                            MultiDimData tempmdd = (MultiDimData)cVect.elementAt(k);
                            int tempFieldMap = tempmdd.fieldMapping;
                            if (tempFieldMap < 0 || tempFieldMap >= currentMDD[j].multiData.length) continue;
                            currentMDD[j].multiData[tempFieldMap] = tempmdd;
                        }
                        cVect.removeAllElements();
                        MultiDimData parentmdd = this;
                        if (j > 0) {
                            parentmdd = currentMDD[j - 1];
                        }
                        MultiDimData[] children = new MultiDimData[this.report.colData[this.report.breakColInfo[j + 1].getMapping()].getNumField()];
                        currentMDD[j] = new MultiDimData(j + 1, this.report, parentmdd, jcMap, jfieldMap, children);
                        continue;
                    }
                    MultiDimData parentmdd = this;
                    if (j > 0) {
                        parentmdd = currentMDD[j - 1];
                    }
                    currentMDD[j] = new MultiDimData(j + 1, this.report, parentmdd, jcMap, jfieldMap, null);
                    currentMDD[j].plotData.add(recNo);
                }
                i2 = numBreakCol;
            }
        }
        for (i = numBreakCol - 1; i >= -1; --i) {
            if (i > -1) {
                storedMDD[i].addElement(currentMDD[i]);
            }
            if (i >= numBreakCol - 1) continue;
            MultiDimData pmdd = this;
            if (i > -1) {
                pmdd = currentMDD[i];
            }
            Vector cVect = storedMDD[i + 1];
            for (int k = 0; k < cVect.size(); ++k) {
                MultiDimData tempmdd = (MultiDimData)cVect.elementAt(k);
                int tempFieldMap = tempmdd.fieldMapping;
                if (tempFieldMap < 0 || pmdd.multiData == null || tempFieldMap >= pmdd.multiData.length) continue;
                pmdd.multiData[tempFieldMap] = tempmdd;
            }
            cVect.removeAllElements();
        }
    }

    public void addRecNo(Integer integer) {
        this.recNoVec.addElement(integer);
    }

    Object getValue(int row, int col) {
        if (!this.report.isAggregationOn()) {
            return this.plotData.getValue(row, col);
        }
        return this.plotData.getComputedValue(col);
    }

    Object getComputedValue(int col) {
        if (!this.report.isAggregationOn()) {
            return null;
        }
        Vector<Object> list = new Vector<Object>();
        this.getValueList(col, list);
        return Aggregation.getComputedValue(this.report.valColInfo[col].getAggregation(), QbUtil.toArray(list));
    }

    public void getValueList(int col, Vector<Object> elt) {
        if (this.aggrData != null) {
            this.aggrData.getValueList(col, elt);
        } else if (this.multiData != null) {
            for (MultiDimData element : this.multiData) {
                if (element == null) continue;
                element.getValueList(col, elt);
            }
        } else {
            Object[] list;
            for (Object element : list = this.plotData.getColumnValue(col)) {
                elt.addElement(element);
            }
        }
    }

    int getValueCount() {
        if (this.plotData.isEmpty()) {
            return 0;
        }
        if (this.report.isAggregationOn()) {
            return 1;
        }
        return this.plotData.countElement();
    }

    Object getFieldName() {
        return this.report.colData[this.colDataMapping].getFieldName()[this.fieldMapping];
    }

    void setAggrDataForMultiDimData(boolean[] rowBreakAggrIncluded, boolean[] colBreakAggrIncluded) {
        if (rowBreakAggrIncluded == null || colBreakAggrIncluded == null) {
            return;
        }
        boolean[] aggrIncluded = new boolean[rowBreakAggrIncluded.length + colBreakAggrIncluded.length];
        boolean isAggrDataIncluded = false;
        for (int i = 0; i < rowBreakAggrIncluded.length; ++i) {
            aggrIncluded[i] = rowBreakAggrIncluded[i];
            if (!rowBreakAggrIncluded[i]) continue;
            isAggrDataIncluded = true;
        }
        for (boolean element : colBreakAggrIncluded) {
            aggrIncluded[i++] = element;
            if (!element) continue;
            isAggrDataIncluded = true;
        }
        if (isAggrDataIncluded) {
            this.setAggrDataForMultiDimData(0, aggrIncluded);
        }
    }

    private void setAggrDataForMultiDimData(int level, boolean[] aggrIncluded) {
        if (level >= aggrIncluded.length) {
            return;
        }
        if (aggrIncluded[level]) {
            if (this.multiData.length > 1) {
                MultiDimData[] newMultiData = new MultiDimData[this.multiData.length - 1];
                this.aggrData = this.multiData[0];
                for (int i = 1; i < this.multiData.length; ++i) {
                    newMultiData[i - 1] = this.multiData[i];
                }
                this.multiData = newMultiData;
            } else {
                LOGGER.warning("Cannot perform OLAP aggregation: need more than 1 distinct object in break level");
            }
        }
        if (this.multiData != null) {
            for (MultiDimData element : this.multiData) {
                if (element == null) continue;
                element.setAggrDataForMultiDimData(level + 1, aggrIncluded);
            }
        }
        if (this.aggrData != null) {
            this.aggrData.setAggrDataForMultiDimData(level + 1, aggrIncluded);
        }
    }
}

