/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import quadbase.common.util.IOLAPResultSet;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.util.ColInfo;

public class OLAPAccess {
    IOLAPResultSet olapRS;
    String connectionString;
    String MDXQuery;
    String uri;
    String datasource;
    String catalog;

    public OLAPAccess(IOLAPResultSet olapRS, String connectionString, String MDXQuery, String uri, String datasource, String catalog) {
        this.olapRS = olapRS;
        this.connectionString = connectionString;
        this.MDXQuery = MDXQuery;
        this.uri = uri;
        this.datasource = datasource;
        this.catalog = catalog;
    }

    public boolean[] isRowBreakAggrIncluded(boolean[] rowBreakAggrIncluded) throws Exception {
        if (this.olapRS == null) {
            this.olapRS = this.connectionString != null && !this.connectionString.equals("") ? new ReadDataFile().createMondrianResultSetInstance(this.connectionString, this.MDXQuery) : new ReadDataFile().createXMLAResultSetInstance(this.uri, this.datasource, this.catalog, this.MDXQuery);
        }
        if (rowBreakAggrIncluded != null && this.olapRS.getRowBreakCount() == rowBreakAggrIncluded.length) {
            return rowBreakAggrIncluded;
        }
        boolean[] tmp = new boolean[this.olapRS.getRowBreakCount()];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = rowBreakAggrIncluded != null && rowBreakAggrIncluded.length > i ? rowBreakAggrIncluded[i] : false;
        }
        return tmp;
    }

    public boolean[] isColBreakAggrIncluded(boolean[] colBreakAggrIncluded) throws Exception {
        if (this.olapRS == null) {
            this.olapRS = this.connectionString != null && !this.connectionString.equals("") ? new ReadDataFile().createMondrianResultSetInstance(this.connectionString, this.MDXQuery) : new ReadDataFile().createXMLAResultSetInstance(this.uri, this.datasource, this.catalog, this.MDXQuery);
        }
        if (colBreakAggrIncluded != null && this.olapRS.getColumnBreakCount() == colBreakAggrIncluded.length) {
            return colBreakAggrIncluded;
        }
        boolean[] tmp = new boolean[this.olapRS.getRowBreakCount()];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = colBreakAggrIncluded != null && colBreakAggrIncluded.length > i ? colBreakAggrIncluded[i] : false;
        }
        return tmp;
    }

    public ColInfo[] getMapping(int reportType, short aggrValForValueCol) throws Exception {
        ColInfo[] mapping = null;
        if (this.olapRS == null) {
            this.olapRS = this.connectionString != null && !this.connectionString.equals("") ? new ReadDataFile().createMondrianResultSetInstance(this.connectionString, this.MDXQuery) : new ReadDataFile().createXMLAResultSetInstance(this.uri, this.datasource, this.catalog, this.MDXQuery);
        }
        if (reportType == 2) {
            mapping = OLAPAccess.getColInfoForCrossTab(this.olapRS, aggrValForValueCol);
        } else if (reportType == 1) {
            mapping = OLAPAccess.getColInfoForSummary(this.olapRS, aggrValForValueCol);
        } else if (reportType == 0) {
            mapping = OLAPAccess.getColInfoForColumnar(this.olapRS);
        }
        return mapping;
    }

    public ColData[] retrieveResult(int reportType) throws Exception {
        ColData[] colData = null;
        if (this.olapRS == null) {
            this.olapRS = this.connectionString != null && !this.connectionString.equals("") ? new ReadDataFile().createMondrianResultSetInstance(this.connectionString, this.MDXQuery) : new ReadDataFile().createXMLAResultSetInstance(this.uri, this.datasource, this.catalog, this.MDXQuery);
        }
        if (reportType == 2) {
            colData = ColData.getColDataForCrossTab(this.olapRS);
        } else if (reportType == 1) {
            colData = ColData.getColDataForSummary(this.olapRS);
        } else if (reportType == 0) {
            colData = ColData.getColDataForSummary(this.olapRS);
        }
        return colData;
    }

    private static final ColInfo[] getColInfoForCrossTab(IOLAPResultSet rs, short aggrValForValueCol) throws Exception {
        int i;
        int rowLength = rs.getRowBreakCount() + rs.getColumnBreakCount() + 1;
        ColInfo[] colInfo = new ColInfo[rowLength];
        for (i = 0; i < rowLength; ++i) {
            colInfo[i] = new ColInfo(i);
        }
        for (i = 0; i < rs.getRowBreakCount(); ++i) {
            colInfo[i].setRowBreak(true);
        }
        for (int j = 0; j < rs.getColumnBreakCount(); ++j) {
            colInfo[i].setColumnBreak(true);
            ++i;
        }
        colInfo[i].setColumnBreakValue(true);
        if (aggrValForValueCol != 0) {
            colInfo[i].setAggregation(aggrValForValueCol);
        } else {
            colInfo[i].setAggregation((short)6);
        }
        return colInfo;
    }

    private static final ColInfo[] getColInfoForSummary(IOLAPResultSet rs, short aggrValForValueCol) throws Exception {
        int i;
        int colLength = rs.getRowBreakCount() + rs.getColumnCount();
        ColInfo[] colInfo = new ColInfo[colLength];
        for (i = 0; i < colLength; ++i) {
            colInfo[i] = new ColInfo(i);
        }
        for (i = 0; i < rs.getRowBreakCount(); ++i) {
            colInfo[i].setRowBreak(true);
        }
        for (int j = 0; j < rs.getColumnCount(); ++j) {
            if (aggrValForValueCol != 0) {
                colInfo[i + j].setAggregation(aggrValForValueCol);
                continue;
            }
            colInfo[i + j].setAggregation((short)0);
        }
        return colInfo;
    }

    private static final ColInfo[] getColInfoForColumnar(IOLAPResultSet rs) throws Exception {
        int colLength = rs.getRowBreakCount() + rs.getColumnCount();
        ColInfo[] colInfo = new ColInfo[colLength];
        for (int i = 0; i < colLength; ++i) {
            colInfo[i] = new ColInfo(i);
        }
        return colInfo;
    }
}

