/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.CastUtil;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.ColDataResultSet;
import quadbase.reportdesigner.util.IRSMetaData;
import quadbase.reportdesigner.util.IResultSet;

public class OneWayResultSet {
    private static final Logger LOGGER = Logger.getLogger(OneWayResultSet.class.getName());
    IResultSet rs;
    Vector data;
    int curRow = 0;
    int totalRows = -1;
    int totalCols = -1;
    int displayRow;
    DBInfoBasic dbInfo;
    Connection conn;
    Statement stat;

    public OneWayResultSet(Connection conn, DBInfoBasic dbInfo, IResultSet rs, Statement stat) throws Exception {
        this.dbInfo = dbInfo;
        this.stat = stat;
        this.conn = conn;
        this.data = new Vector();
        this.rs = rs;
        this.totalCols = rs.getMetaData().getColumnCount();
    }

    boolean equals(DBInfoBasic dbInfo2) {
        return this.dbInfo.equals(dbInfo2);
    }

    void close() {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to close OneWayResultSet", ex);
        }
        this.rs = null;
        try {
            if (this.stat != null) {
                this.stat.close();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to close statement", ex);
        }
        this.stat = null;
        try {
            if (this.conn != null && this.dbInfo.isCloseConnectionEnabled()) {
                this.conn.close();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to close connection", ex);
        }
        this.conn = null;
    }

    ColDataResultSet getResultSet(int displayRows) throws Exception {
        IRSMetaData md = this.rs.getMetaData();
        ColData[] bufferData = new ColData[this.totalCols + 1];
        for (int i = 1; i <= this.totalCols; ++i) {
            String columnName = md.getColumnName(i);
            int columnType = md.getColumnType(i);
            bufferData[i - 1] = new ColData(columnName, "", columnType, -1, CastUtil.getColumnDisplaySize(md, i), this.totalCols + 1);
        }
        this.displayRow = displayRows;
        if (this.totalCols <= 0) {
            return null;
        }
        int endIndex = this.curRow + this.displayRow;
        while (this.curRow < endIndex && this.totalRows == -1) {
            if (!this.rs.next()) {
                this.totalRows = this.curRow;
                break;
            }
            for (int i = 1; i <= this.totalCols; ++i) {
                bufferData[i - 1].add(this.rs.getObject(i));
            }
            ++this.curRow;
        }
        return (ColDataResultSet)ColData.getResultSet(bufferData);
    }
}

