/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Image;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.output.pdf.BaseFont;
import quadbase.common.util.output.pdf.PdfContentByte;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.report.PDFReport;
import quadbase.reportdesigner.report.PDFSubReport;
import quadbase.reportdesigner.util.rtf.RTFUtil;

public class PDFRTFObject
extends PDFSubReport {
    private static final Logger LOGGER = Logger.getLogger(PDFRTFObject.class.getName());
    private Vector lines = null;
    private ReportRTFObject rtfObject = null;
    private boolean firstLine = true;
    private float bottomY = 0.0f;
    private int currentColumnCount = 1;
    private boolean isAdjustFont = true;

    public PDFRTFObject(ReportRTFObject rtfObject, Vector l, float x, float y, float reportWidth, float reportHeight, PDFReport parent) {
        this.report = null;
        this.parent = parent;
        this.leftMargin = parent.getAbsoluteX(x);
        this.rightMargin = parent.rightMargin;
        this.topMargin = parent.topMargin;
        this.bottomMargin = parent.bottomMargin;
        this.reportGraphics = parent.reportGraphics;
        this.pageFooterHeight = parent.pageFooterHeight;
        if (reportHeight < 0.0f) {
            this.pageHeight = parent.pageHeight;
            float footerHeight = 0.0f;
            try {
                footerHeight = this.hasNoData(this.report.getPageFooter()) ? 0.0f : this.resizeSection(this.reportGraphics, this.report.getPageFooter(), this.report.getReportTables().elementAt(this.report.getReportTables().size() - 1)).getHeightToPoints();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Can't set footer height", ex);
            }
            this.pageHeight -= footerHeight;
            this.pageFooterHeight += footerHeight;
        } else {
            this.checkVisibility = true;
            this.pageHeight = reportHeight;
            this.bottomMargin = parent.pageHeight - this.pageHeight + parent.bottomMargin;
        }
        this.pageWidth = reportWidth;
        this.elementXPos = 0.0f;
        this.elementYPos = y;
        this.pageHeaderHeight = parent.pageHeaderHeight;
        this.currentPageNumber = parent.currentPageNumber;
        this.totalPageNumber = parent.totalPageNumber;
        this.currentSection = parent.currentSection;
        this.totalSections = parent.totalSections;
        this.fontMapping = parent.fontMapping;
        this.reportUI = parent.reportUI;
        this.checkTotalPageNumber = parent.checkTotalPageNumber;
        this.templates = new PdfContentByte[1];
        this.templateIndex = parent.getContentByteIndex(x);
        this.templates[0] = parent.checkFitGroupOnPage ? parent.templates[0].createTemplate(parent.document.getPageSize().width(), parent.document.getPageSize().height()) : parent.templates[this.templateIndex];
        this.document = parent.document;
        this.language = parent.language;
        if (reportHeight < 0.0f) {
            this.pageHeight = parent.pageHeight;
        }
        this.isAdjustFont = parent.report.isAdjustFont();
        this.rtfObject = rtfObject;
        this.lines = l;
        this.pageTopY = this.elementYPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            for (int i = 0; i < this.lines.size(); ++i) {
                float border;
                Vector segments = (Vector)this.lines.elementAt(i);
                int ascent = 0;
                int descent = 0;
                for (int j = 0; j < segments.size(); ++j) {
                    Object[] seg = (Object[])segments.elementAt(j);
                    if (seg[0] != null && seg[0] instanceof Image) {
                        int iHeight = (Integer)seg[2];
                        if (iHeight <= ascent) continue;
                        ascent = iHeight;
                        continue;
                    }
                    FontMetrics fontMetrics = QbUtil.getViewerFontMetrics((FontMetrics)seg[1], this.isAdjustFont);
                    if (fontMetrics.getMaxAscent() <= ascent) continue;
                    ascent = fontMetrics.getMaxAscent();
                    descent = fontMetrics.getMaxDescent();
                }
                this.pageBreak(this.pixelToPoints(ascent + descent), null);
                this.elementYPos += this.pixelToPoints(ascent);
                float sx = 0.0f;
                if (!this.checkVisibility && this.currentColumnCount == 1) {
                    if (this.rtfObject.getBgColor() != null) {
                        this.writeFilledRectangle(sx, this.pageHeight - (this.elementYPos + this.pixelToPoints(descent)), sx + this.pageWidth, this.pageHeight - (this.elementYPos - this.pixelToPoints(ascent)), this.rtfObject.getBgColor());
                    }
                    if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
                        float topY = this.pageHeight - (this.elementYPos - this.pixelToPoints(ascent));
                        float bY = this.pageHeight - (this.elementYPos + this.pixelToPoints(descent));
                        border = this.pixelToPoints(this.rtfObject.getBorderThickness());
                        if (this.firstLine) {
                            this.writeRectangle(0, sx - border, topY + 0.5f * border, sx + this.pageWidth + border, topY + 0.5f * border, border, this.rtfObject.getBorderColor(), 2);
                        }
                        this.writeRectangle(0, sx - 0.5f * border, bY, sx - 0.5f * border, topY, border, this.rtfObject.getBorderColor(), 4);
                        this.writeRectangle(0, sx + this.pageWidth + 0.5f * border, bY, sx + this.pageWidth + 0.5f * border, topY, border, this.rtfObject.getBorderColor(), 4);
                    }
                } else if (!this.checkVisibility && this.currentColumnCount > 1 && this.bottomY < this.elementYPos + this.pixelToPoints(descent)) {
                    if (this.rtfObject.getBgColor() != null) {
                        this.writeFilledRectangle(sx, this.pageHeight - (this.elementYPos + this.pixelToPoints(descent)), sx + this.pageWidth, this.pageHeight - this.bottomY, this.rtfObject.getBgColor());
                    }
                    if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
                        float topY = this.pageHeight - this.bottomY;
                        float bY = this.pageHeight - (this.elementYPos + this.pixelToPoints(descent));
                        border = this.pixelToPoints(this.rtfObject.getBorderThickness());
                        this.writeRectangle(0, sx - 0.5f * border, bY, sx - 0.5f * border, topY, border, this.rtfObject.getBorderColor(), 4);
                        this.writeRectangle(0, sx + this.pageWidth + 0.5f * border, bY, sx + this.pageWidth + 0.5f * border, topY, border, this.rtfObject.getBorderColor(), 4);
                    }
                } else if (i == 0) {
                    if (this.rtfObject.getBgColor() != null) {
                        this.writeFilledRectangle(sx, this.pageHeight - (this.elementYPos - this.pixelToPoints(ascent) + this.rtfObject.getHeightToPoints()), sx + this.pageWidth, this.pageHeight - (this.elementYPos - this.pixelToPoints(ascent)), this.rtfObject.getBgColor());
                    }
                    if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
                        this.writeBorder(sx, this.pageHeight - (this.elementYPos - this.pixelToPoints(ascent)), this.pageWidth, this.rtfObject.getHeightToPoints(), this.pixelToPoints(this.rtfObject.getBorderThickness()), this.rtfObject.getBorderColor(), "solid");
                    }
                }
                sx = QbUtil.toPixel((this.rtfObject.getColumnWidth() + this.rtfObject.getColumnSpacing()) * (double)(this.currentColumnCount - 1));
                sx = RTFUtil.getXForSingleRow(this.parent.report, this.reportGraphics.g, (int)sx, QbUtil.toPixel(this.rtfObject.getWidth()), segments, this.rtfObject.getAlign());
                sx = this.pixelToPoints((int)sx);
                for (int j = 0; j < segments.size(); ++j) {
                    Object[] seg = (Object[])segments.elementAt(j);
                    if (seg[0] != null && seg[0] instanceof Image) {
                        int iWidth = (Integer)seg[1];
                        int iHeight = (Integer)seg[2];
                        try {
                            Color color = Color.white;
                            if (this.rtfObject.getBgColor() != null) {
                                color = this.rtfObject.getBgColor();
                            }
                            quadbase.common.util.output.Image img = quadbase.common.util.output.Image.getInstance((Image)seg[0], color);
                            img.setAbsolutePosition(this.getAbsoluteX(sx), this.getAbsoluteY(this.pageHeight - this.elementYPos));
                            img.scaleAbsolute(this.pixelToPoints(iWidth), this.pixelToPoints(iHeight));
                            img.setInterpolation(true);
                            this.templates[0].addImage(img);
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINEST, "Can't add image", ex);
                        }
                        sx += this.pixelToPoints(iWidth);
                        continue;
                    }
                    FontMetrics fontMetrics = (FontMetrics)seg[1];
                    String text = (String)seg[0];
                    Color fontColor = (Color)seg[2];
                    BaseFont baseFont = this.mapToPDFFont(fontMetrics.getFont(), IOUtil.containsUnicode(text));
                    float size = this.mapFontSize(fontMetrics.getFont().getSize(), this.isAdjustFont);
                    this.writeText(this.templates[0], text, sx, this.pageHeight - this.elementYPos, baseFont, size, fontColor, 0.0, (short)1);
                    float textwidth = baseFont.getWidthPoint(text, size);
                    if (((Boolean)seg[3]).booleanValue()) {
                        this.writeRectangle(0, sx, this.pageHeight - this.elementYPos - 1.5f, sx + textwidth, this.pageHeight - this.elementYPos - 1.5f, 1.0f, fontColor, 2);
                    }
                    sx += textwidth;
                }
                this.firstLine = false;
                this.elementYPos += this.pixelToPoints(descent);
            }
            if (this.bottomY > this.elementYPos) {
                this.elementYPos = this.bottomY;
            }
            if (!this.checkVisibility && this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
                float border = this.pixelToPoints(this.rtfObject.getBorderThickness());
                float y = this.pageHeight - this.elementYPos - 0.5f * border;
                this.writeRectangle(0, 0.0f - border, y, 0.0f + this.pageWidth + border, y, border, this.rtfObject.getBorderColor(), 2);
            }
            if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
                this.elementYPos += this.pixelToPoints(this.rtfObject.getBorderThickness());
            }
        }
        catch (Exception ex) {
            if (!"Subreport page break.".equals(ex.getMessage())) {
                LOGGER.log(Level.WARNING, "Failed to run PDFRTFObject", ex);
            } else {
                LOGGER.log(Level.FINEST, "PDFRTFObject - page break", ex);
            }
        }
        catch (Error err) {
            LOGGER.log(Level.WARNING, "Failed to run PDFRTFObject", err);
        }
        finally {
            this.finish = true;
            Object ex = this.LOCK;
            synchronized (ex) {
                this.LOCK.notify();
            }
        }
    }

    @Override
    protected void pageBreak(ReportSection section) throws Exception {
        this.pageBreak(section, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pageBreak(ReportSection section, boolean isToc) throws Exception {
        if (this.currentColumnCount < this.rtfObject.getActualColumnCount()) {
            if (this.elementYPos > this.bottomY) {
                this.bottomY = this.elementYPos;
            }
            this.elementYPos = this.pageTopY;
            ++this.currentColumnCount;
            return;
        }
        if (this.checkVisibility) {
            throw new Exception("Subreport page break.");
        }
        if (!this.firstLine && this.rtfObject.isBorderClosed()) {
            float border = this.pixelToPoints(this.rtfObject.getBorderThickness());
            this.writeRectangle(0, -border, this.pageHeight - this.elementYPos - 0.5f * border, this.pageWidth + border, this.pageHeight - this.elementYPos - 0.5f * border, border, this.rtfObject.getBorderColor(), 2);
        }
        ++this.currentPageNumber;
        Object border = this.LOCK;
        synchronized (border) {
            this.LOCK.notify();
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.writeSectionColor();
        this.elementXPos = 0.0f;
        this.bottomY = 0.0f;
        this.pageTopY = this.elementYPos;
        this.currentColumnCount = 1;
        if (!this.firstLine && this.rtfObject.isBorderClosed()) {
            float border2 = this.pixelToPoints(this.rtfObject.getBorderThickness());
            this.writeRectangle(0, -border2, this.pageHeight - this.elementYPos + 0.5f * border2, this.pageWidth + border2, this.pageHeight - this.elementYPos + 0.5f * border2, border2, this.rtfObject.getBorderColor(), 2);
        }
    }

    @Override
    protected boolean isVisible(ReportElement elt) {
        return !(this.elementXPos + elt.getXToPoints() + elt.getWidthToPoints() > this.pageWidth);
    }
}

