/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import quadbase.chart.Chart;
import quadbase.common.awt.Arc;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.flash.Pictures;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.DoNothingOutputStream;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.HttpsIO;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.Java2DUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.UserLanguage;
import quadbase.common.util.output.Document;
import quadbase.common.util.output.DocumentException;
import quadbase.common.util.output.Font;
import quadbase.common.util.output.Image;
import quadbase.common.util.output.Jpeg;
import quadbase.common.util.output.Phrase;
import quadbase.common.util.output.Rectangle;
import quadbase.common.util.output.pdf.BaseFont;
import quadbase.common.util.output.pdf.ColumnText;
import quadbase.common.util.output.pdf.PdfAction;
import quadbase.common.util.output.pdf.PdfContentByte;
import quadbase.common.util.output.pdf.PdfDestination;
import quadbase.common.util.output.pdf.PdfOutline;
import quadbase.common.util.output.pdf.PdfTemplate;
import quadbase.common.util.output.pdf.PdfWriter;
import quadbase.common.util.output.pdf.QbFontMapper;
import quadbase.reportdesigner.ReportElements.Bookmark;
import quadbase.reportdesigner.ReportElements.ColumnBreakColumn;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.FormattedRow;
import quadbase.reportdesigner.ReportElements.FormattedRowKey;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.report.ChartObject;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.ImageMapNode;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.PDFRTFObject;
import quadbase.reportdesigner.report.PDFReportColumnar;
import quadbase.reportdesigner.report.PDFReportCrossTab;
import quadbase.reportdesigner.report.PDFReportMasterDetails;
import quadbase.reportdesigner.report.PDFReportSummary;
import quadbase.reportdesigner.report.PDFSubReport;
import quadbase.reportdesigner.report.PDFTOCObject;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportGraphics;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.util.BarcodeFormat;
import quadbase.reportdesigner.util.internal.BarcodeUtil;
import quadbase.util.internal.ImageEncoder;

public class PDFReport {
    private static final Logger LOGGER = Logger.getLogger(PDFReport.class.getName());
    private static final Pattern RTL_CHARS_PATTERN = Pattern.compile("[\u0591-\u07ff\ufb1d-\ufdfd\ufe70-\ufefc]");
    private boolean isSectionResizeToFitContent = false;
    public static boolean pdfEncStrength = true;
    private boolean j2DRotateEnabled;
    private float dashInterval = 2.0f;
    protected Report report;
    protected float leftMargin;
    protected float rightMargin;
    protected float topMargin;
    protected float bottomMargin;
    protected float pageWidth;
    protected float pageHeight;
    protected float pageHeaderHeight;
    protected float pageFooterHeight;
    protected float elementXPos;
    protected float elementYPos;
    protected float oldElementYPos;
    private String fontName = "Times-Roman";
    private String encoding = "Cp1252";
    protected ReportTable hTable = null;
    protected ReportTable fTable = null;
    private String evalString = "Evaluation copy by Quadbase Systems Inc.";
    private String contactString = "Please contact sales@quadbase.com for purchasing information.";
    Object[] previousRowValue;
    boolean[] previousRowIsBGColor2;
    boolean calculated = false;
    protected String language = "en";
    protected String os = "Windows";
    protected int columnWrapCount = 0;
    protected int columnWrapInitialRow = 0;
    protected int columnWrapDisplayRow = 0;
    protected int lastDrawCol = 0;
    protected float columnWrapWidth = 0.0f;
    protected boolean doColumnWrap = false;
    float[] wrapInfo;
    float curMaxY;
    protected int currentPageNumber = 1;
    protected int totalPageNumber = 1;
    protected int totalSections = 1;
    protected int currentSection = 1;
    protected boolean inPageSection = false;
    protected Document document;
    protected PdfContentByte[] templates = null;
    protected PdfTemplate[] background_templates = null;
    protected PdfTemplate backgroundImage_template = null;
    protected PdfOutline rootOutline = null;
    protected Vector<PdfOutline> outlineStack = null;
    protected ReportUI reportUI = null;
    protected ReportGraphics reportGraphics = null;
    protected Vector<Integer> treeStructure = null;
    protected Vector<ReportElement> rowElements = null;
    protected Hashtable<FormattedRowKey, FormattedRow> rows = null;
    protected Vector<ReportTableElement> sectionList;
    protected Vector<ReportTable> tableList;
    protected boolean checkTotalPageNumber = false;
    protected int pagebreaks = 0;
    protected boolean checkFitGroupOnPage = false;
    protected boolean resetPageNumber = false;
    protected Hashtable<String, Integer> sectionTotalPagesTable = null;
    protected String treeCopy = "";
    protected boolean populateTable = true;
    protected int pageCt = 1;
    protected int savedStartPage = 1;
    protected Vector<Integer> sectionTotalPages = null;
    protected Vector<Integer> sectionStartPage = null;
    protected Hashtable<Integer, int[]> pageLookup = null;
    protected Hashtable<String, String> fontMapping = null;
    protected boolean debugMode = false;
    private Vector<ReportElement> frontOneTime;
    private Vector<Float> frontOneTimeY;
    private float[] shifts;
    private float[] rowShifts;
    float tableDataCellHeight = QbUtil.toPoints(0.3);
    private Graphics offScreenGraphics = null;
    Hashtable<java.awt.Font, FontMetrics> fontMetricsTable = new Hashtable(10);
    BaseFontHash baseFontHash = new BaseFontHash();
    Hashtable<java.awt.Font, BaseFont> englishFontHash = new Hashtable();
    Hashtable<java.awt.Font, BaseFont> japanFontHash = new Hashtable();
    Hashtable<java.awt.Font, BaseFont> koreanFontHash = new Hashtable();
    Hashtable<java.awt.Font, BaseFont> chineseFontHash = new Hashtable();
    boolean ddBytesSentToServlet = false;
    boolean isWriteRepeatSection = false;
    boolean isTableFormatted = false;
    boolean titleAdjusted = false;
    int rowCount = 0;
    boolean skipFormatTable = false;

    public PDFReport() {
        this.getOffScreenGraphics();
    }

    public PDFReport(Report report) throws IOException, DocumentException, Exception {
        this.report = report;
        this.fontMapping = report.getFontMapping();
        this.init();
    }

    public PDFReport(Report report, boolean skipFormatTable) throws IOException, DocumentException, Exception {
        this(report);
        this.skipFormatTable = skipFormatTable;
    }

    private void init() throws Exception {
        this.leftMargin = this.report.getLeftMarginToPoints();
        this.rightMargin = this.report.getRightMarginToPoints();
        this.topMargin = this.report.getTopMarginToPoints();
        this.bottomMargin = this.report.getBottomMarginToPoints();
        this.pageWidth = this.report.getActualPageWidthToPoints();
        this.elementXPos = 0.0f;
        this.elementYPos = 0.0f;
        this.document = new Document(new Rectangle(this.report.getPageWidthToPoints(), this.report.getPageHeightToPoints()));
        this.rootOutline = null;
        this.outlineStack = null;
        this.currentPageNumber = 1;
        this.treeCopy = "";
        this.currentSection = 1;
        this.treeStructure = new Vector();
        this.pageCt = 1;
        this.savedStartPage = 1;
        this.isWriteRepeatSection = false;
        this.rowCount = 0;
        this.getOffScreenGraphics();
    }

    protected int getSection() {
        return this.currentSection;
    }

    protected int getTotalSections() {
        return this.totalSections;
    }

    protected int getCurrentPageNumber() {
        if (!this.resetPageNumber) {
            return this.currentPageNumber;
        }
        if (this.pageLookup != null && this.pageLookup.containsKey(this.pageCt)) {
            int[] pages = this.pageLookup.get(this.pageCt);
            if (pages != null && pages.length == 2) {
                return pages[0];
            }
            return this.currentPageNumber;
        }
        return this.currentPageNumber;
    }

    protected int getTotalPageNumber() {
        if (!this.resetPageNumber) {
            return this.totalPageNumber;
        }
        if (this.pageLookup != null && this.pageLookup.containsKey(this.pageCt)) {
            int[] pages = this.pageLookup.get(this.pageCt);
            if (pages != null && pages.length == 2) {
                return pages[1];
            }
            return this.currentPageNumber;
        }
        return this.currentPageNumber;
    }

    protected ReportSection resizeSection(ReportGraphics g, ReportSection _sec, ReportTable tbl) throws Exception {
        int i;
        Report temp_report = this.report;
        boolean shift = false;
        ReportSection sec = new ReportSection();
        boolean resize = false;
        boolean copied = false;
        if (this.treeStructure != null) {
            if (_sec.hasFormattedCell(this.treeStructure)) {
                if (!copied) {
                    sec.deepCopy(_sec);
                }
                copied = true;
                Hashtable<Integer, ReportCell> cellTable = sec.getFormattedCells(this.treeStructure);
                ReportCell[] cell = sec.getCells();
                for (int i2 = 0; i2 < cell.length; ++i2) {
                    ReportCell formattedCell;
                    if (!cellTable.containsKey(i2)) continue;
                    cell[i2] = formattedCell = cellTable.get(i2);
                }
                resize = true;
                shift = true;
            }
            if (_sec.hasSectionCells(this.treeStructure)) {
                Vector<ReportCell> sectionCells = _sec.getSectionCells(this.treeStructure);
                if (!copied) {
                    sec.deepCopy(_sec);
                }
                copied = true;
                if (sectionCells != null) {
                    for (int i3 = 0; i3 < sectionCells.size(); ++i3) {
                        sec.addData(sectionCells.elementAt(i3));
                    }
                }
                resize = true;
                shift = true;
            }
            if (_sec.getHeight(this.treeStructure) > 0.0) {
                if (!copied) {
                    sec.deepCopy(_sec);
                }
                copied = true;
                sec.setHeight(_sec.getHeight(this.treeStructure));
                resize = true;
                shift = true;
            }
        }
        for (i = 0; i < _sec.getCellCount() && !resize; ++i) {
            if (!_sec.getData(i).isVisible() || !_sec.getData(i).isResizeToFitContent()) continue;
            if (!copied) {
                sec.deepCopy(_sec);
            }
            copied = true;
            resize = true;
        }
        if (resize) {
            for (i = 0; i < sec.getCellCount(); ++i) {
                ReportCell element = sec.getData(i);
                if (!element.isResizeToFitContent()) continue;
                if (element instanceof SubReportObject || element instanceof ReportRTFObject || element instanceof TableOfContents) {
                    shift = true;
                }
                ReportCell cell = tbl.formatCell(element, this.getCurrentPageNumber(), this.currentSection, this.getTotalPageNumber(), this.totalSections, temp_report);
                double h = g.getTextHeight(cell.getText(), cell.getRefFontToDraw(this.report.isAdjustFont()), cell.getWidth(), cell.getAlign(), cell.isNoWrap());
                if (cell instanceof ReportRTFObject || cell instanceof TableOfContents || cell instanceof SubReportObject) {
                    h = cell.getHeight();
                }
                if ((cell instanceof ReportRTFObject || cell instanceof SubReportObject || cell instanceof TableOfContents) && _sec.getBgColor() != null) {
                    ReportGraphics temp_rg = this.reportUI.getReportGraphics();
                    double[] res = temp_rg.drawCell(this.report, tbl, null, cell, sec, 0.0, 0.0, 0);
                    h = res[0];
                }
                if (!(h > cell.getHeight()) || !cell.isVisible()) continue;
                shift = true;
                ReportSection.resizeVerticallyAndShift((ReportElement)element, sec, h - cell.getHeight());
            }
        }
        if (shift) {
            double minH = sec.getMinHeight();
            if (sec.getHeight() < minH) {
                if (sec.isResizeToFitContent()) {
                    double increase = ReportUI.getMaxIncreaseProportion(_sec, sec);
                    for (int i4 = 0; i4 < sec.getCellCount(); ++i4) {
                        if (sec.getData(i4) instanceof ReportLine && ((ReportLine)sec.getData(i4)).isVertical() && ((ReportLine)sec.getData(i4)).next() != null) {
                            sec.getData(i4).setHeight(sec.getMinHeight() - sec.getData(i4).getY());
                            continue;
                        }
                        if (sec.getData(i4) == null || sec.getData(i4) instanceof ReportLine) continue;
                        double h1 = _sec.getData(i4).getHeight() * increase;
                        double h2 = sec.getData(i4).getHeight();
                        sec.getData(i4).setHeight(h1 > h2 ? h1 : h2);
                    }
                    minH = sec.getMinHeight();
                }
                sec.setHeight(minH);
            }
            return sec;
        }
        for (i = 0; i < _sec.getCellCount(); ++i) {
            if (!(_sec.getData(i) instanceof ReportLine) || ((ReportLine)_sec.getData(i)).next() == null || !((ReportLine)_sec.getData(i)).isVertical()) continue;
            _sec.getData(i).setHeight(_sec.getHeight() - _sec.getData(i).getY());
        }
        return _sec;
    }

    private void resetDualColor() {
        this.previousRowValue = null;
    }

    protected ReportTable resizeTable(ReportGraphics g, ReportTable _tbl, int rowIndex) throws Exception {
        int i;
        boolean resize;
        ReportTable tbl;
        boolean shift;
        Report temp_report;
        block20: {
            int i2;
            FormattedRow row;
            FormattedRowKey key;
            temp_report = this.report;
            shift = false;
            tbl = new ReportTable();
            resize = false;
            this.rowElements = null;
            double rowHeight = 0.0;
            if (this.rows != null && this.rows.containsKey(key = this.treeStructure == null || this.treeStructure.size() == 0 ? new FormattedRowKey(rowIndex, null) : new FormattedRowKey(rowIndex, this.getTreeLevel())) && (row = this.rows.get(key)) != null) {
                rowHeight = row.getRowHeight();
                this.rowElements = row.getRowElements();
                for (int j = 0; j < _tbl.getColumnCount(); ++j) {
                    tbl.addColumn(new ReportColumn());
                }
                tbl.deepCopy(_tbl);
                tbl.setHeight(rowHeight);
                resize = true;
                shift = true;
            }
            if (this.calculated || this.checkFitGroupOnPage) break block20;
            if (this.previousRowValue == null) {
                this.previousRowValue = new Object[_tbl.getColumnCount()];
                this.previousRowIsBGColor2 = new boolean[_tbl.getColumnCount()];
                for (i2 = 0; i2 < _tbl.getColumnCount(); ++i2) {
                    this.previousRowValue[i2] = _tbl.getColumn(i2).getData(rowIndex);
                    this.previousRowIsBGColor2[i2] = false;
                }
            } else {
                for (i2 = 0; i2 < _tbl.getColumnCount(); ++i2) {
                    int[] index = _tbl.getColumn(i2).getDualColorColInfoIndex();
                    if (index == null) continue;
                    boolean different = false;
                    for (int element : index) {
                        if ((this.previousRowValue[element] != null || _tbl.getColumn(element).getData(rowIndex) == null) && (this.previousRowValue[element] == null || this.previousRowValue[element].equals(_tbl.getColumn(element).getData(rowIndex)) || "".equals(_tbl.getColumn(element).getData(rowIndex)))) continue;
                        different = true;
                        break;
                    }
                    if (different) {
                        this.previousRowIsBGColor2[i2] = !this.previousRowIsBGColor2[i2];
                    }
                    _tbl.getColumn(i2).setIsBGColor2(rowIndex, this.previousRowIsBGColor2[i2]);
                }
            }
            for (i2 = 0; i2 < _tbl.getColumnCount(); ++i2) {
                this.previousRowValue[i2] = _tbl.getColumn(i2).getData(rowIndex);
            }
        }
        for (i = 0; i < _tbl.getColumnCount() && !resize; ++i) {
            if (!_tbl.getColumn(i).isVisible() || !_tbl.getColumn(i).isResizeToFitContent()) continue;
            tbl.positionCopy(_tbl);
            resize = true;
        }
        if (resize) {
            for (i = 0; i < tbl.getColumnCount(); ++i) {
                if (!tbl.getColumn(i).isResizeToFitContent()) continue;
                ReportCell cell = tbl.formatCell(tbl.getColumn(i), rowIndex, temp_report);
                double h = g.getTextHeight(cell.getText(), cell.getRefFontToDraw(this.report.isAdjustFont()), cell.getWidth(), cell.getAlign(), cell.isNoWrap());
                if (cell instanceof ReportRTFObject && _tbl.getBgColor() != null) {
                    ReportGraphics temp_rg = this.reportUI.getReportGraphics();
                    double[] res = temp_rg.drawCell(this.report, tbl, null, cell, tbl, 0.0, 0.0, 0);
                    h = res[0];
                }
                if (!(h > cell.getHeight()) || !cell.isVisible()) continue;
                shift = true;
                ReportTable.resizeVerticallyAndShift((ReportElement)tbl.getColumn(i), tbl, h - cell.getHeight());
            }
        }
        if (shift) {
            double minH = tbl.getMinHeight();
            if (tbl.getHeight() < minH) {
                double increase = (minH - tbl.getHeight()) / tbl.getHeight() + 1.0;
                if (tbl.isResizeToFitContent()) {
                    int i3;
                    for (i3 = 0; i3 < tbl.getColumnCount(); ++i3) {
                        double h1 = _tbl.getColumn(i3).getHeight() * increase;
                        double h2 = tbl.getColumn(i3).getHeight();
                        tbl.getColumn(i3).setHeight(h1 > h2 ? h1 : h2);
                    }
                    for (i3 = 0; i3 < tbl.getImageCount(); ++i3) {
                        ReportImage image = tbl.getImage(i3);
                        if (!(image instanceof ReportGrid) || !(((ReportGrid)image).getHeight() >= 0.0)) continue;
                        image.setHeight(image.getHeight() * increase);
                    }
                    minH = tbl.getMinHeight();
                }
                for (int i4 = 0; i4 < tbl.getImageCount(); ++i4) {
                    ReportImage image = tbl.getImage(i4);
                    if (!(image instanceof ReportLine) || !((ReportLine)image).isVertical() || ((ReportLine)image).next() == null) continue;
                    image.setHeight(image.getHeight() * increase + 0.01);
                }
                tbl.setHeight(minH);
            }
            return tbl;
        }
        for (i = 0; i < _tbl.getImageCount(); ++i) {
            if (!(_tbl.getImage(i) instanceof ReportLine) || ((ReportLine)_tbl.getImage(i)).next() == null || !((ReportLine)_tbl.getImage(i)).isVertical()) continue;
            _tbl.getImage(i).setHeight(_tbl.getHeight() - _tbl.getImage(i).getY());
        }
        return _tbl;
    }

    protected int[] getTreeLevel() {
        if (this.treeStructure != null && this.treeStructure.size() > 0) {
            int[] values = new int[this.treeStructure.size()];
            for (int i = 0; i < this.treeStructure.size(); ++i) {
                values[i] = this.treeStructure.elementAt(i);
            }
            return values;
        }
        return null;
    }

    protected String getTreeStringKey() {
        if (this.treeStructure != null && this.treeStructure.size() > 0) {
            String str = "Tree_";
            int size = this.treeStructure.size();
            for (int i = 0; i < size - 1; ++i) {
                str = str + this.treeStructure.elementAt(i) + "_";
            }
            str = str + this.treeStructure.elementAt(size - 1);
            return str;
        }
        return null;
    }

    protected int getCurrentSectionID() {
        if (this.treeStructure != null && this.treeStructure.size() > 0) {
            int lastID = this.treeStructure.size();
            return this.treeStructure.elementAt(lastID - 1);
        }
        return 0;
    }

    public void exportPDF(OutputStream out, String fileName, String userPass, String ownerPass, int permissions, String javaScript) throws Exception {
        try {
            DoNothingOutputStream temp;
            long totalTime = System.currentTimeMillis();
            long newreportUI = System.currentTimeMillis();
            this.reportUI = new ReportUI(this.report, this.offScreenGraphics, false);
            this.reportUI.preCalcTotalSections();
            if (this.debugMode) {
                System.out.println("REPORT UI: " + (double)(System.currentTimeMillis() - newreportUI) / 1000.0);
            }
            this.totalSections = this.reportUI.getTotalSections();
            this.reportGraphics = this.reportUI.getReportGraphics();
            this.pageFooterHeight = this.hasNoData(this.report.getPageFooter()) ? 0.0f : this.resizeSection(this.reportGraphics, this.report.getPageFooter(), this.report.getReportTables().elementAt(this.report.getReportTables().size() - 1)).getHeightToPoints();
            this.pageHeight = this.report.getPageHeightToPoints() - this.topMargin - this.bottomMargin - this.pageFooterHeight;
            long totalPTime = System.currentTimeMillis();
            if (this.report.hasFormulaExp("getTotalPages(") || this.report.hasScriptExp("getTotalPages(") || this.report.drawBeforeDisplay || this.report.isTocEnabled() || this.report.getColumnWrap() != null) {
                if (this.debugMode) {
                    System.out.println("CONTAINS TOTAL PAGES.....");
                }
                temp = new DoNothingOutputStream();
                this.checkTotalPageNumber = true;
                this.exportPDF(temp, userPass, ownerPass, permissions, javaScript);
                temp.flush();
                temp.close();
                this.totalPageNumber = this.currentPageNumber;
                this.populatePageLookupTable();
                this.init();
            }
            if (this.report.isTocEnabled()) {
                temp = new DoNothingOutputStream();
                this.exportPDF(temp, userPass, ownerPass, permissions, javaScript);
                temp.flush();
                temp.close();
                this.totalPageNumber = this.currentPageNumber;
                this.populatePageLookupTable();
                this.init();
            }
            if (this.debugMode) {
                System.out.println("CAL TOTAL PAGE: " + (double)(System.currentTimeMillis() - totalPTime) / 1000.0);
            }
            this.checkTotalPageNumber = false;
            this.populateTable = false;
            this.exportPDF(out, userPass, ownerPass, permissions, javaScript);
            if (this.debugMode) {
                System.out.println("TOTAL TIME: " + (double)(System.currentTimeMillis() - totalTime) / 1000.0);
            }
            this.calculated = true;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to export PDF", ex);
        }
    }

    protected void populatePageLookupTable() {
        if (this.sectionTotalPages == null || this.sectionStartPage == null) {
            return;
        }
        if (this.sectionTotalPages.size() != this.sectionStartPage.size()) {
            return;
        }
        if (this.sectionTotalPages.size() == 0) {
            return;
        }
        int count = this.sectionTotalPages.size();
        int lastSectionTotalPages = this.sectionTotalPages.elementAt(count - 1);
        int lastSectionStartPage = this.sectionStartPage.elementAt(count - 1);
        for (int i = count - 2; i >= 0; --i) {
            int nextSectionStartPage = this.sectionStartPage.elementAt(i);
            if (nextSectionStartPage == lastSectionStartPage) {
                this.sectionTotalPages.setElementAt(lastSectionTotalPages, i);
            }
            lastSectionTotalPages = this.sectionTotalPages.elementAt(i);
            lastSectionStartPage = this.sectionStartPage.elementAt(i);
        }
        this.pageLookup = new Hashtable();
        int nextStartPage = this.sectionStartPage.elementAt(0);
        int nextTotalPages = this.sectionTotalPages.elementAt(0);
        for (int i = 1; i <= this.pageCt; ++i) {
            if (i < nextStartPage) {
                this.pageLookup.put(i, new int[]{i, i});
                continue;
            }
            if (i != nextStartPage) continue;
            nextTotalPages = this.sectionTotalPages.remove(0);
            nextStartPage = this.sectionStartPage.remove(0);
            boolean flag = false;
            int j = 1;
            while (j <= nextTotalPages) {
                this.pageLookup.put(i, new int[]{j++, nextTotalPages});
                flag = true;
                ++i;
            }
            if (this.sectionTotalPages.size() > 0) {
                nextTotalPages = this.sectionTotalPages.elementAt(0);
                nextStartPage = this.sectionStartPage.elementAt(0);
            }
            if (!flag) continue;
            --i;
        }
    }

    protected void exportPDF(OutputStream out, String userPass, String ownerPass, int permissions, String javaScript) throws Exception {
        try {
            Vector<ReportTable> vec;
            if (this.report.isDynamicExport() && !this.ddBytesSentToServlet) {
                if (this.report.getDynamicReportKeyGenerator() != null) {
                    this.ddBytesSentToServlet = true;
                } else {
                    this.drilldownDynamicExport(this.report);
                }
            }
            this.language = new UserLanguage().getUserLanguage();
            this.os = new UserLanguage().getSystemProperty("os.name");
            PdfWriter writer = PdfWriter.getInstance(this.document, out);
            if (userPass != null && userPass.equals("")) {
                userPass = null;
            }
            if (ownerPass != null && ownerPass.equals("")) {
                ownerPass = null;
            }
            if (userPass != null || ownerPass != null) {
                writer.setEncryption(pdfEncStrength, userPass, ownerPass, permissions);
            }
            this.document.open();
            this.templates = new PdfContentByte[this.totalSections];
            this.templates[0] = writer.getDirectContent();
            this.templates[0].pageNumber = this.currentPageNumber;
            ReportImage image = this.report.getBackgroundImage();
            if (image != null && image.getWidth() != 0.0 && image.getHeight() != 0.0) {
                float w = image.getWidthToPoints();
                float h = image.getHeightToPoints();
                if (image.getImageOption() == 1) {
                    w = this.report.getPageWidthToPoints();
                    h = this.report.getPageHeightToPoints();
                }
                this.backgroundImage_template = this.templates[0].createTemplate(w, h);
                this.writeReportImageHelper(image, this.report.getBackgroundColor(), this.backgroundImage_template, 0.0f, 0.0f, w, h);
            }
            for (int i = 1; i < this.templates.length; ++i) {
                this.templates[i] = this.templates[0].createTemplate(this.document.getPageSize().width(), this.document.getPageSize().height());
                this.templates[i].pageNumber = this.currentPageNumber;
            }
            ReportTable table = null;
            if (this.report.getInitializeReportError() == null && this.checkTotalPageNumber) {
                this.formatTable();
            }
            if ((vec = this.report.getReportTables()).size() <= 0) {
                throw new Exception("The report does not contain any table. Please check and try again later.");
            }
            table = vec.elementAt(0);
            this.hTable = vec.elementAt(0);
            this.fTable = vec.elementAt(vec.size() - 1);
            this.startToGetData(table);
            if (this.report.getInitializeReportError() != null) {
                this.writeSection(ReportUI.createErrorSection(this.report.getActualPageWidth(), this.report.getActualPageHeight(), this.report.getInitializeReportError()), table);
            } else {
                this.writePageSections(true);
                this.writeSection(this.report.getReportHeader(), table);
                for (int i = 0; i < vec.size(); ++i) {
                    table = vec.elementAt(i);
                    this.initRepeatSection();
                    this.setColumnWrap();
                    this.wrapInfo = new float[]{0.0f, this.elementYPos, this.elementYPos};
                    this.writeReportTable(table);
                    if (!this.doColumnWrap || this.wrapInfo == null) continue;
                    if (this.elementYPos < this.curMaxY) {
                        this.elementYPos = this.curMaxY;
                    }
                    this.resetColumnWrap();
                }
                if (this instanceof PDFReportSummary) {
                    this.writeSection(this.report.getReportFooter(), this.fTable, ((PDFReportSummary)this).footerAggCol, ((PDFReportSummary)this).footerResCol);
                } else if (this instanceof PDFReportColumnar) {
                    this.writeSection(this.report.getReportFooter(), this.fTable, ((PDFReportColumnar)this).footerAggCol, ((PDFReportColumnar)this).footerResCol);
                } else if (this instanceof PDFReportCrossTab) {
                    this.writeSection(this.report.getReportFooter(), this.fTable, ((PDFReportCrossTab)this).footerAggCol, ((PDFReportCrossTab)this).footerResCol);
                } else if (this instanceof PDFReportMasterDetails) {
                    this.writeSection(this.report.getReportFooter(), this.fTable, ((PDFReportMasterDetails)this).footerAggCol, ((PDFReportMasterDetails)this).footerResCol);
                } else {
                    this.writeSection(this.report.getReportFooter(), this.fTable);
                }
                this.elementYPos = this.pageHeight;
                this.writePageSections(false);
            }
            this.writeWaterMark();
            this.addAllTemplates();
            if (javaScript != null) {
                writer.addJavaScript(javaScript);
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.FINER, "Failed to export PDF", ioe);
            this.document.close();
            throw ioe;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to export PDF", ex);
        }
        try {
            this.document.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed to close document", e);
        }
    }

    private void writePageSections(boolean header) throws Exception {
        this.currentSection = 1;
        PdfContentByte first = this.templates[0];
        float old_elementYPos = this.elementYPos;
        this.inPageSection = true;
        for (int i = 0; i < this.templates.length; ++i) {
            this.templates[0] = this.templates[i];
            this.elementYPos = old_elementYPos;
            if (header) {
                if (!this.checkFitGroupOnPage) {
                    ReportImage image;
                    Rectangle rect = new Rectangle(0.0f, 0.0f, this.document.getPageSize().width(), this.document.getPageSize().height());
                    rect.setBorder(0);
                    rect.setBackgroundColor(this.report.getBackgroundColor());
                    this.templates[i].rectangle(rect);
                    if (this.backgroundImage_template != null && (image = this.report.getBackgroundImage()) != null && image.getWidth() != 0.0 && image.getHeight() != 0.0) {
                        if (image.getImageOption() == 1) {
                            this.templates[i].addTemplate(this.backgroundImage_template, 0.0f, 0.0f);
                        } else if (this.report.getBackgroundImage().getImageOption() == 2) {
                            float x = 0.0f;
                            for (float y = this.report.getPageHeightToPoints(); y > 0.0f; y -= image.getHeightToPoints()) {
                                for (x = 0.0f; x < this.report.getPageWidthToPoints(); x += image.getWidthToPoints()) {
                                    this.templates[i].addTemplate(this.backgroundImage_template, x, y - image.getHeightToPoints());
                                }
                            }
                        } else {
                            this.templates[i].addTemplate(this.backgroundImage_template, (this.report.getPageWidthToPoints() - image.getWidthToPoints()) / 2.0f, (this.report.getPageHeightToPoints() - image.getHeightToPoints()) / 2.0f);
                        }
                    }
                }
                this.pageHeaderHeight = this.writeSection(this.report.getPageHeader(), this.hTable);
            } else {
                this.writeSection(this.report.getPageFooter(), this.fTable, false);
            }
            ++this.currentSection;
        }
        this.templates[0] = first;
        this.currentSection = 1;
        this.inPageSection = false;
    }

    protected void addAllTemplates() throws DocumentException, Exception {
        for (int i = 1; i < this.templates.length; ++i) {
            this.document.newPage();
            if (!(this.templates[i] instanceof PdfTemplate)) continue;
            this.templates[0].addTemplate((PdfTemplate)this.templates[i], 0.0f, 0.0f);
        }
    }

    protected void resetAllTemplates() {
        int i;
        for (i = 1; i < this.templates.length; ++i) {
            this.templates[i] = this.templates[0].createTemplate(this.document.getPageSize().width(), this.document.getPageSize().height());
        }
        if (this.background_templates != null) {
            this.background_templates = new PdfTemplate[this.templates.length];
            for (i = 0; i < this.templates.length; ++i) {
                this.background_templates[i] = this.templates[0].createTemplate(this.document.getPageSize().width(), this.document.getPageSize().height());
                this.templates[i].addTemplate(this.background_templates[i], 0.0f, 0.0f);
            }
        }
    }

    void setColumnWrap() {
        this.setColumnWrap(this.pageWidth);
    }

    void setColumnWrap(float pWidth) {
        if (this.report.getReportType() != 0 && this.report.getReportType() != 4 && this.report.getReportType() != 1 || this.report.getColumnWrap() == null) {
            this.resetColumnWrap();
            return;
        }
        this.doColumnWrap = true;
        this.columnWrapWidth = this.report.getColumnWrap().getXToPoints();
        this.columnWrapCount = this.report.getColumnWrap().getWrapCount();
        int maxWrapCount = (int)Math.floor(pWidth / this.columnWrapWidth) - 1;
        if (this.columnWrapCount < 0 || this.columnWrapCount > maxWrapCount) {
            this.columnWrapCount = maxWrapCount;
        }
        if (this.columnWrapCount < 0) {
            this.columnWrapCount = 0;
        }
    }

    void resetColumnWrap() {
        this.columnWrapWidth = 0.0f;
        this.columnWrapCount = 0;
        this.doColumnWrap = false;
        this.resetColumnWrapTableUI();
    }

    void resetColumnWrapTableUI() {
        this.columnWrapInitialRow = 0;
        this.columnWrapDisplayRow = 0;
    }

    void formatTable() throws Exception {
        if (!this.isTableFormatted) {
            if (!this.skipFormatTable) {
                this.report.formatTable();
            }
            this.isTableFormatted = true;
        }
    }

    protected void writeSectionBgColor(ReportElement section) {
        if (section.getBgColor() != null && !this.checkFitGroupOnPage) {
            float heightPoints = section.getHeightToPoints();
            if (heightPoints > this.pageHeight) {
                heightPoints = this.pageHeight;
            }
            float lly = this.getY(section) - heightPoints;
            float ury = this.getY(section);
            for (int i = 0; i < this.templates.length; ++i) {
                this.writeFilledRectangle(this.pageWidth * (float)i, lly, this.pageWidth * (float)(i + 1), ury, section.getBgColor());
            }
        }
    }

    protected void writeSection(ReportSection section, ReportTable tbl, Vector preAggCol, Vector resultCol) throws Exception, IOException, MalformedURLException {
        if (!this.titleAdjusted) {
            this.titleAdjusted = this.reportUI.adjustReportTitle(this.reportUI.getReportGraphics(), this.report.getReportHeader());
        }
        Color bgColor = null;
        boolean printOnNewPage = false;
        boolean visible = false;
        boolean resetPageNumber = false;
        if (section.getScriptObj() != null) {
            bgColor = section.getBgColor();
            printOnNewPage = section.isPrintOnNewPage();
            visible = section.isVisible();
            resetPageNumber = section.isResetPageNumber();
            section.getScriptObj().applyScript(tbl, this.currentPageNumber, this.currentSection, this.totalPageNumber, this.totalSections, this.report, section);
        }
        this.writeSectionHelper(section, tbl, preAggCol, resultCol);
        for (int i = 0; i < section.getSectionCount(); ++i) {
            ReportSection child = section.getSection(i);
            child.setRepeatOnEveryPage(section.isRepeatOnEveryPage());
            this.writeSectionHelper(child, tbl, preAggCol, resultCol);
        }
        if (section.getScriptObj() != null) {
            section.setBgColor(bgColor);
            section.setPrintOnNewPage(printOnNewPage);
            section.setVisible(visible);
            section.setResetPageNumber(resetPageNumber);
        }
    }

    protected void writeSectionHelper(ReportSection orgSection, ReportTable tbl, Vector preAggCol, Vector resultCol) throws Exception, IOException, MalformedURLException {
        int i;
        if (orgSection == null || !orgSection.isVisible()) {
            return;
        }
        if (orgSection.isResetPageNumber()) {
            this.resetPageNumber = true;
        }
        if (this.hasNoData(orgSection)) {
            return;
        }
        boolean doColumnWrap_BAK = this.doColumnWrap;
        int totalDrawCol = this.columnWrapCount;
        boolean repeatTableHeader = false;
        if (orgSection == this.report.getPageHeader() || orgSection == this.report.getPageFooter() || orgSection == this.report.getReportHeader() || orgSection == this.report.getReportFooter() || orgSection.getID().startsWith("RPT_HDR") || orgSection.getID().startsWith("RPT_FTR") || orgSection.getTOC() != null) {
            this.doColumnWrap = false;
            totalDrawCol = 0;
        } else if (orgSection.getID().equals("TBL0_HDR")) {
            repeatTableHeader = true;
            if (!this.checkTotalPageNumber && this.totalPageNumber == this.currentPageNumber) {
                totalDrawCol = this.lastDrawCol;
            }
        } else {
            totalDrawCol = 0;
        }
        if (!this.isWriteRepeatSection && this.printOnNewPage(orgSection)) {
            this.pageBreak(orgSection);
        }
        ReportSection cellArray = this.resizeSection(this.reportGraphics, orgSection, tbl);
        this.pageBreak(cellArray.getHeightToPoints(), orgSection);
        ReportElement[] cells = cellArray.sortCell(1, true);
        if (this instanceof PDFSubReport) {
            this.reportUI.setCurX(QbUtil.pointsToInch(this.elementXPos + ((PDFSubReport)this).offsetX));
        } else {
            this.reportUI.setCurX(QbUtil.pointsToInch(this.elementXPos));
        }
        double[] temp = null;
        double[] tempRowShifts = null;
        if (this.report.isCrossTabFixedField()) {
            double oldX = this.reportUI.curX;
            cells = this.reportUI.splitCells(cells);
            cells = (ReportCell[])ReportElement.sortElement(cells, 1, true);
            Object[] objs = this.reportUI.calculateRowShifts(cells, tbl);
            this.reportUI.setCurX(oldX);
            cells = (ReportCell[])objs[0];
            tempRowShifts = (double[])objs[1];
            temp = this.reportUI.calculateShifts(cells, tbl);
        } else {
            tempRowShifts = temp = this.reportUI.calculateShifts(cells, tbl);
        }
        this.shifts = new float[temp.length];
        for (i = 0; i < temp.length; ++i) {
            this.shifts[i] = QbUtil.toPoints(temp[i]);
        }
        this.rowShifts = new float[tempRowShifts.length];
        for (i = 0; i < tempRowShifts.length; ++i) {
            this.rowShifts[i] = QbUtil.toPoints(tempRowShifts[i]);
        }
        if (!(this instanceof PDFSubReport)) {
            this.writeSectionBgColor(cellArray);
        } else {
            ((PDFSubReport)this).shift = 0.0f;
            for (float shift : this.shifts) {
                ((PDFSubReport)this).shift += shift;
            }
            this.writeSectionBgColor(cellArray);
            ((PDFSubReport)this).shift = 0.0f;
        }
        float bottomY = this.elementYPos + cellArray.getHeightToPoints();
        Vector<PDFSubReport> subReports = new Vector<PDFSubReport>();
        boolean hasToc = false;
        for (int curArea = 0; curArea <= totalDrawCol; ++curArea) {
            float delta = 0.0f;
            if (repeatTableHeader) {
                delta = (float)curArea * this.columnWrapWidth;
            } else if (this.doColumnWrap && this.wrapInfo != null) {
                delta = this.wrapInfo[0] * this.columnWrapWidth;
            }
            for (int i2 = 0; i2 < cells.length; ++i2) {
                this.elementXPos = 0.0f;
                for (int l = 0; l < i2; ++l) {
                    if (!this.reportUI.isWithIn(cells[i2], cells[l])) continue;
                    this.incElementXPos(this.rowShifts[l]);
                }
                if (cells[i2] instanceof SubReportObject) {
                    cells[i2].setDrawX(cells[i2].getXToPoints() + this.elementXPos);
                    this.incElementXPos(this.rowShifts[i2]);
                    continue;
                }
                this.incElementXPos(this.rowShifts[i2]);
                cells[i2].setDrawX(cells[i2].getXToPoints() + this.elementXPos);
            }
            for (ReportElement cell2 : cells = (ReportCell[])ReportElement.sortElement(cells, 2, true)) {
                this.elementXPos = delta + (float)cell2.getDrawX() - cell2.getXToPoints();
                if (this.skipCell(cell2) || (orgSection == this.report.getPageHeader() || orgSection == this.report.getPageFooter()) && cell2.getXToPoints() + cell2.getWidthToPoints() > this.pageWidth) continue;
                if (cell2 instanceof ReportLine || cell2 instanceof ReportGrid) {
                    if (cell2 instanceof ReportLine && !((ReportLine)cell2).isVertical() && ((ReportLine)cell2).isMatchColumnWidths()) {
                        ((ReportLine)cell2).setWidth(tbl.getColumnWidths() - cell2.getX());
                    }
                    if (cell2 instanceof ReportGrid && ((ReportGrid)cell2).isMatchColumnWidths()) {
                        ((ReportGrid)cell2).setWidth(tbl.getColumnWidths() - cell2.getX());
                    }
                    this.writeTableDataElement(tbl.formatCell((ReportCell)cell2, this.currentPageNumber, this.currentSection, this.totalPageNumber, this.totalSections, this.report), tbl, cellArray);
                    continue;
                }
                ReportCell cell = tbl.formatCell((ReportCell)cell2, this.currentPageNumber, this.currentSection, this.totalPageNumber, this.totalSections, this.report);
                if (cell == null || !cell.isVisible()) continue;
                if (cell instanceof SubReportObject || cell instanceof ReportRTFObject || cell instanceof TableOfContents && this.report.isTocEnabled()) {
                    if (cellArray.isRepeatOnEveryPage() || orgSection == this.report.getPageHeader() || orgSection == this.report.getPageFooter()) {
                        cell.setResizeToFitContent(false);
                    }
                    if ((this.checkTotalPageNumber || this.checkFitGroupOnPage) && !cell.isResizeToFitContent()) continue;
                    PDFSubReport pdfSub = null;
                    if (cell instanceof SubReportObject) {
                        pdfSub = this.writeSubReport((SubReportObject)cell, tbl, cellArray);
                    } else if (cell instanceof ReportRTFObject) {
                        pdfSub = this.writeRTFObject((ReportRTFObject)cell, tbl, cellArray);
                    } else if (cell instanceof TableOfContents) {
                        pdfSub = this.writeTOCObject((TableOfContents)cell, tbl, cellArray);
                    }
                    if (pdfSub != null && pdfSub.isFinished()) {
                        if (!(pdfSub.elementYPos > bottomY) || !cell.isResizeToFitContent()) continue;
                        bottomY = pdfSub.elementYPos;
                        cellArray.setHeight(QbUtil.pointsToInch(this.pageHeight) - QbUtil.pointsToInch(pdfSub.pageTopY) + ((SubReportObject)cell).getY());
                        continue;
                    }
                    if (pdfSub == null) continue;
                    subReports.insertElementAt(pdfSub, 0);
                    cellArray.setHeight(QbUtil.pointsToInch(this.pageHeight) - QbUtil.pointsToInch(pdfSub.pageTopY) + ((SubReportObject)cell).getY());
                    continue;
                }
                if ((this.checkTotalPageNumber || this.checkFitGroupOnPage) && (!this.report.isTocEnabled() || this.report.getTableOfContentsObject().isUseGroups() || cell2.getScript() == null || cell2.getScript().toUpperCase().indexOf("BOOKMARK") < 0)) continue;
                this.writeTableDataElement(tbl.formatCell((ReportCell)cell2, -1, this.currentPageNumber, this.currentSection, this.totalPageNumber, this.totalSections, this.report, false, preAggCol, resultCol), tbl, cellArray);
            }
        }
        this.doColumnWrap = doColumnWrap_BAK;
        if (subReports.size() > 0) {
            this.elementYPos = this.writeRemainingSubReports(subReports, orgSection);
        } else if (!hasToc) {
            this.elementYPos += cellArray.getHeightToPoints();
            if (bottomY > this.elementYPos) {
                this.elementYPos = bottomY;
            }
        }
        if (this.doColumnWrap && this.wrapInfo != null) {
            this.curMaxY = bottomY < this.wrapInfo[2] ? this.wrapInfo[2] : bottomY;
            if (repeatTableHeader) {
                this.wrapInfo[1] = this.elementYPos;
            }
        }
        this.elementXPos = 0.0f;
    }

    protected void pageBreak(ReportSection section) throws Exception {
        this.pageBreak(section, false);
    }

    protected void pageBreak(ReportSection section, boolean isToc) throws Exception {
        if (this.elementYPos <= this.pageHeaderHeight) {
            return;
        }
        if (this.doColumnWrap && this.wrapInfo != null) {
            if (this.columnWrapCount <= 0 || this.wrapInfo[0] >= (float)this.columnWrapCount || this.elementYPos == this.wrapInfo[1]) {
                this.pageBreak2(section, isToc);
                this.wrapInfo[0] = 0.0f;
                this.wrapInfo[1] = this.elementYPos;
            } else {
                this.wrapInfo[2] = this.elementYPos;
                this.elementYPos = this.wrapInfo[1];
                this.wrapInfo[0] = this.wrapInfo[0] + 1.0f;
                this.rowCount = 0;
            }
        } else {
            this.pageBreak2(section, isToc);
        }
    }

    protected void pageBreak2(ReportSection section) throws Exception {
        this.pageBreak2(section, false);
    }

    protected void pageBreak2(ReportSection section, boolean isToc) throws Exception {
        this.elementXPos = 0.0f;
        this.elementYPos = this.pageHeight;
        if (!isToc) {
            this.writePageSections(false);
        }
        this.writeWaterMark();
        this.elementXPos = 0.0f;
        this.elementYPos = this.oldElementYPos;
        this.addAllTemplates();
        if (!this.checkFitGroupOnPage && this.pagebreaks == 0 || !this.checkFitGroupOnPage && this.pagebreaks > 0 && this.totalSections == 1) {
            this.document.newPage();
        }
        ++this.currentPageNumber;
        ++this.pageCt;
        this.rowCount = 0;
        if (this.checkFitGroupOnPage) {
            ++this.pagebreaks;
        }
        if (section != null && section.isResetPageNumber()) {
            this.currentPageNumber = 1;
            this.savedStartPage = this.pageCt;
        }
        this.resetAllTemplates();
        this.elementXPos = 0.0f;
        this.elementYPos = 0.0f;
        if (!isToc) {
            this.writePageSections(true);
        }
        if (!isToc) {
            this.writeRepeatSection(section);
        }
    }

    protected void pageBreak(float requireHeight, ReportSection section) throws Exception {
        this.pageBreak(requireHeight, section, false);
    }

    protected void pageBreak(float requireHeight, ReportSection section, boolean isToc) throws Exception {
        float availableHeight = this.pageHeight - this.elementYPos;
        if (availableHeight >= requireHeight) {
            return;
        }
        this.pageBreak(section, isToc);
    }

    protected void pageBreak(float requiredHeight, int rowIndex) throws Exception {
        float remain = this.pageHeight - this.elementYPos;
        if (remain >= requiredHeight) {
            return;
        }
        if (this.wrapInfo[0] >= (float)this.columnWrapCount || this.elementYPos == this.wrapInfo[1]) {
            this.pageBreak(null);
            this.wrapInfo[0] = 0.0f;
            this.wrapInfo[1] = this.elementYPos;
            this.wrapInfo[2] = this.elementYPos;
            this.columnWrapInitialRow = this.columnWrapDisplayRow + this.columnWrapInitialRow;
            this.columnWrapDisplayRow = 0;
            return;
        }
        this.wrapInfo[2] = this.elementYPos;
        this.elementYPos = this.wrapInfo[1];
        if (this.columnWrapDisplayRow == 0) {
            this.columnWrapDisplayRow = rowIndex - this.columnWrapInitialRow * (this.columnWrapCount + 1);
        }
        this.wrapInfo[0] = this.wrapInfo[0] + 1.0f;
        this.rowCount = 0;
    }

    protected void initRepeatSection() {
        this.sectionList = new Vector();
        this.tableList = new Vector();
    }

    protected void addRepeatSection(ReportSection section, ReportTable tbl) {
        this.sectionList.addElement(section);
        this.tableList.addElement(tbl);
    }

    protected void removeRepeatSection() {
        this.sectionList.removeElementAt(this.sectionList.size() - 1);
        this.tableList.removeElementAt(this.tableList.size() - 1);
    }

    protected void writeRepeatSection(ReportSection section) throws Exception {
        this.isWriteRepeatSection = true;
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                ReportSection drawingSection = (ReportSection)this.sectionList.elementAt(i);
                if (drawingSection == section) {
                    return;
                }
                for (int j = 0; j < drawingSection.getSectionCount(); ++j) {
                    if (drawingSection.getSection(j) != section) continue;
                    return;
                }
                this.writeSection(drawingSection, this.tableList.elementAt(i), true);
            }
        }
        this.isWriteRepeatSection = false;
    }

    protected float writeSection(ReportSection orgSection, ReportTable tbl) throws Exception {
        return this.writeSection(orgSection, tbl, true);
    }

    protected float writeSection(ReportSection section, ReportTable tbl, boolean checkPageBreak) throws Exception, IOException, MalformedURLException {
        if (!this.titleAdjusted) {
            this.titleAdjusted = this.reportUI.adjustReportTitle(this.reportUI.getReportGraphics(), this.report.getReportHeader());
        }
        Color bgColor = null;
        boolean printOnNewPage = false;
        boolean visible = false;
        boolean resetPageNumber = false;
        if (section.getScriptObj() != null) {
            bgColor = section.getBgColor();
            printOnNewPage = section.isPrintOnNewPage();
            visible = section.isVisible();
            resetPageNumber = section.isResetPageNumber();
            section.getScriptObj().applyScript(tbl, this.currentPageNumber, this.currentSection, this.totalPageNumber, this.totalSections, this.report, section);
        }
        float height = this.writeSectionHelper(section, tbl, checkPageBreak);
        for (int i = 0; i < section.getSectionCount(); ++i) {
            ReportSection child = section.getSection(i);
            child.setRepeatOnEveryPage(section.isRepeatOnEveryPage());
            this.writeSection(child, tbl, checkPageBreak);
        }
        if (section.getScriptObj() != null) {
            section.setBgColor(bgColor);
            section.setPrintOnNewPage(printOnNewPage);
            section.setVisible(visible);
            section.setResetPageNumber(resetPageNumber);
        }
        return height;
    }

    protected boolean isFirstValue() {
        int[] intArray;
        for (int element : intArray = QbUtil.convertVectorToIntArray(this.treeStructure)) {
            if (element == 0) continue;
            return false;
        }
        return true;
    }

    private boolean printOnNewPage(ReportSection section) {
        return section.isResetPageNumber() ? !(section.isPrintOnNewPage() && this.elementYPos > 0.0f && section.isSkipFirstValue() && this.isFirstValue() || section.isPrintOnNewPage() && this.elementYPos > 0.0f && section.isSkipFirstGroupValue() && this.getCurrentSectionID() == 0) : !(!section.isPrintOnNewPage() || section.isSkipFirstValue() && this.elementYPos > 0.0f && this.isFirstValue() || section.isSkipFirstGroupValue() && this.elementYPos > 0.0f && this.getCurrentSectionID() == 0);
    }

    protected float writeSectionHelper(ReportSection orgSection, ReportTable tbl, boolean checkPageBreak) throws Exception, IOException, MalformedURLException {
        int i;
        if (orgSection == null || !orgSection.isVisible()) {
            return 0.0f;
        }
        if (orgSection.isResetPageNumber()) {
            this.resetPageNumber = true;
            this.treeCopy = this.getTreeStringKey();
            if (this.sectionTotalPagesTable == null) {
                this.sectionTotalPagesTable = new Hashtable();
            }
            if (this.sectionTotalPages == null) {
                this.sectionTotalPages = new Vector();
            }
            if (this.sectionStartPage == null) {
                this.sectionStartPage = new Vector();
            }
        }
        if (!this.isWriteRepeatSection && this.printOnNewPage(orgSection)) {
            this.pageBreak(orgSection);
        }
        if (this.hasNoData(orgSection)) {
            return 0.0f;
        }
        boolean doColumnWrap_BAK = this.doColumnWrap;
        int totalDrawCol = this.columnWrapCount;
        boolean repeatTableHeader = false;
        if (orgSection == this.report.getPageHeader() || orgSection == this.report.getPageFooter() || orgSection == this.report.getReportHeader() || orgSection == this.report.getReportFooter() || orgSection.getID().startsWith("RPT_HDR") || orgSection.getID().startsWith("RPT_FTR") || orgSection.getTOC() != null) {
            this.doColumnWrap = false;
            totalDrawCol = 0;
        } else if (orgSection.getID().equals("TBL0_HDR")) {
            repeatTableHeader = true;
            if (!this.checkTotalPageNumber && this.totalPageNumber == this.currentPageNumber) {
                totalDrawCol = this.lastDrawCol;
            }
        } else {
            totalDrawCol = 0;
        }
        ReportSection cellArray = this.resizeSection(this.reportGraphics, orgSection, tbl);
        if (checkPageBreak) {
            this.pageBreak(cellArray.getHeightToPoints(), orgSection);
        }
        if (orgSection == cellArray) {
            cellArray = ReportUI.copySectionForSecuredInvisibleCols(cellArray, tbl, this.report.getPreviewSecurityLevel());
        }
        ReportElement[] cells = cellArray.sortCell(1, true);
        cells = (ReportCell[])ReportUI.takeAwaySecuredInvisibleCols(cells, tbl, this.report.getPreviewSecurityLevel(), this.report.getReportType());
        if (this instanceof PDFSubReport) {
            this.reportUI.setCurX(QbUtil.pointsToInch(this.elementXPos + ((PDFSubReport)this).offsetX));
        } else {
            this.reportUI.setCurX(QbUtil.pointsToInch(this.elementXPos));
        }
        double[] tempRowShifts = null;
        double[] temp = null;
        double oldX = this.reportUI.curX;
        if (this.report.isCrossTabFixedField()) {
            cells = this.reportUI.splitCells(cells);
            cells = (ReportCell[])ReportElement.sortElement(cells, 1, true);
            Object[] objs = this.reportUI.calculateRowShifts(cells, tbl);
            this.reportUI.setCurX(oldX);
            cells = (ReportCell[])objs[0];
            tempRowShifts = (double[])objs[1];
            temp = this.reportUI.calculateShifts(cells, tbl);
            this.reportUI.setCurX(oldX);
        } else {
            tempRowShifts = temp = this.reportUI.calculateShifts(cells, tbl);
            this.reportUI.setCurX(oldX);
        }
        this.shifts = new float[temp.length];
        for (i = 0; i < temp.length; ++i) {
            this.shifts[i] = QbUtil.toPoints(temp[i]);
        }
        this.rowShifts = new float[tempRowShifts.length];
        for (i = 0; i < tempRowShifts.length; ++i) {
            this.rowShifts[i] = QbUtil.toPoints(tempRowShifts[i]);
        }
        if (!(this instanceof PDFSubReport)) {
            this.writeSectionBgColor(cellArray);
        } else {
            ((PDFSubReport)this).shift = 0.0f;
            for (float shift : this.shifts) {
                ((PDFSubReport)this).shift += shift;
            }
            this.writeSectionBgColor(cellArray);
            ((PDFSubReport)this).shift = 0.0f;
        }
        float bottomY = this.elementYPos + cellArray.getHeightToPoints();
        Vector<PDFSubReport> subReports = new Vector<PDFSubReport>();
        boolean hasToc = false;
        for (int curArea = 0; curArea <= totalDrawCol; ++curArea) {
            float delta = 0.0f;
            if (repeatTableHeader) {
                delta = (float)curArea * this.columnWrapWidth;
            } else if (this.doColumnWrap && this.wrapInfo != null) {
                delta = this.wrapInfo[0] * this.columnWrapWidth;
            }
            for (int i2 = 0; i2 < cells.length; ++i2) {
                this.elementXPos = 0.0f;
                for (int l = 0; l < i2; ++l) {
                    if (!this.reportUI.isWithIn(cells[i2], cells[l])) continue;
                    this.incElementXPos(this.rowShifts[l]);
                }
                if (cells[i2] instanceof SubReportObject) {
                    cells[i2].setDrawX(cells[i2].getXToPoints() + this.elementXPos);
                    this.incElementXPos(this.rowShifts[i2]);
                    continue;
                }
                this.incElementXPos(this.rowShifts[i2]);
                cells[i2].setDrawX(cells[i2].getXToPoints() + this.elementXPos);
            }
            for (ReportElement cell2 : cells = (ReportCell[])ReportElement.sortElement(cells, 2, true)) {
                this.elementXPos = delta + (float)cell2.getDrawX() - cell2.getXToPoints();
                if (this.skipCell(cell2) || (orgSection == this.report.getPageHeader() || orgSection == this.report.getPageFooter()) && cell2.getXToPoints() + cell2.getWidthToPoints() > this.pageWidth) continue;
                if (cell2 instanceof ReportLine || cell2 instanceof ReportGrid) {
                    if (cell2 instanceof ReportLine && !((ReportLine)cell2).isVertical() && ((ReportLine)cell2).isMatchColumnWidths()) {
                        ((ReportLine)cell2).setWidth(tbl.getColumnWidths() - cell2.getX());
                    }
                    if (cell2 instanceof ReportGrid && ((ReportGrid)cell2).isMatchColumnWidths()) {
                        ((ReportGrid)cell2).setWidth(tbl.getColumnWidths() - cell2.getX());
                    }
                    this.writeTableDataElement(tbl.formatCell((ReportCell)cell2, this.currentPageNumber, this.currentSection, this.totalPageNumber, this.totalSections, this.report), tbl, cellArray);
                    continue;
                }
                ReportCell cell = tbl.formatCell((ReportCell)cell2, this.getCurrentPageNumber(), this.currentSection, this.getTotalPageNumber(), this.totalSections, this.report);
                if (cell == null || !cell.isVisible()) continue;
                if (cell instanceof SubReportObject || cell instanceof ReportRTFObject || cell instanceof TableOfContents && this.report.isTocEnabled()) {
                    if (cellArray.isRepeatOnEveryPage() || orgSection == this.report.getPageHeader() || orgSection == this.report.getPageFooter()) {
                        cell.setResizeToFitContent(false);
                    }
                    if ((this.checkTotalPageNumber || this.checkFitGroupOnPage) && !cell.isResizeToFitContent()) continue;
                    PDFSubReport pdfSub = null;
                    if (cell instanceof SubReportObject) {
                        pdfSub = this.writeSubReport((SubReportObject)cell, tbl, cellArray);
                    } else if (cell instanceof ReportRTFObject) {
                        pdfSub = this.writeRTFObject((ReportRTFObject)cell, tbl, cellArray);
                    } else if (cell instanceof TableOfContents) {
                        pdfSub = this.writeTOCObject((TableOfContents)cell, tbl, cellArray);
                    }
                    if (pdfSub != null && pdfSub.isFinished()) {
                        if (!(pdfSub.elementYPos > bottomY) || !cell.isResizeToFitContent()) continue;
                        bottomY = pdfSub.elementYPos;
                        cellArray.setHeight(QbUtil.pointsToInch(bottomY) - QbUtil.pointsToInch(pdfSub.pageTopY) + cell.getY());
                        continue;
                    }
                    if (pdfSub == null) continue;
                    subReports.insertElementAt(pdfSub, 0);
                    cellArray.setHeight(QbUtil.pointsToInch(this.pageHeight) - QbUtil.pointsToInch(pdfSub.pageTopY) + cell.getY());
                    continue;
                }
                if ((this.checkTotalPageNumber || this.checkFitGroupOnPage) && (!this.report.isTocEnabled() || this.report.getTableOfContentsObject().isUseGroups() || cell2.getScript() == null || cell2.getScript().toUpperCase().indexOf("BOOKMARK") < 0)) continue;
                this.writeTableDataElement(cell, tbl, cellArray);
            }
        }
        this.doColumnWrap = doColumnWrap_BAK;
        if (subReports.size() > 0) {
            this.elementYPos = this.writeRemainingSubReports(subReports, orgSection);
        } else if (!hasToc) {
            this.elementYPos += cellArray.getHeightToPoints();
            if (bottomY > this.elementYPos) {
                this.elementYPos = bottomY;
            }
        }
        if (this.doColumnWrap && this.wrapInfo != null) {
            this.curMaxY = bottomY < this.wrapInfo[2] ? this.wrapInfo[2] : bottomY;
            if (repeatTableHeader) {
                this.wrapInfo[1] = this.elementYPos;
            }
        }
        this.elementXPos = 0.0f;
        return cellArray.getHeightToPoints();
    }

    protected void writeReportTable(ReportTable tbl) throws Exception {
        this.resetDualColor();
        this.writeReportTable(tbl, 0);
    }

    protected void writeReportTable(ReportTable tbl, int level) throws Exception {
        this.writeSection(tbl.getHeader(), tbl);
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.addRepeatSection(tbl.getHeader(), tbl);
        }
        if (this.treeStructure == null) {
            this.treeStructure = new Vector();
        }
        if (tbl instanceof ReportTreeTable) {
            ReportTreeTable sTbl = (ReportTreeTable)tbl;
            for (int i = 0; i < sTbl.countSubTable(); ++i) {
                int idx;
                this.treeStructure.addElement(i);
                int n = idx = sTbl.indexArray == null ? i : sTbl.indexArray[i];
                if (!(this.checkFitGroupOnPage || this.report.breakColIndex == null || this.report.breakColIndex.length <= level || this.report.colInfo[this.report.breakColIndex[level]].skipFirstValueForFitGroup() && i <= 0 || !this.report.colInfo[this.report.breakColIndex[level]].isFitGroupOnPage())) {
                    this.pagebreaks = 0;
                    float x = this.elementXPos;
                    float y = this.elementYPos;
                    this.checkFitGroupOnPage = true;
                    try {
                        if (!sTbl.getSubTable(idx).isAggregationTable()) {
                            this.writeReportTable(sTbl.getSubTable(idx), level + 1);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINEST, "Failed to write report table", e);
                    }
                    this.checkFitGroupOnPage = false;
                    this.treeStructure.addElement(i);
                    this.elementXPos = x;
                    this.elementYPos = y;
                    if (this.pagebreaks > 0) {
                        this.currentPageNumber -= this.pagebreaks;
                        this.pageCt -= this.pagebreaks;
                        this.pageBreak(null);
                        this.pagebreaks = 0;
                    }
                }
                if (this.report.isTocEnabled() && this.report.getTableOfContentsObject().isUseGroups()) {
                    Bookmark entry = this.report.getTableOfContentsObject().getEntryByTree(this.treeStructure);
                    if (entry != null) {
                        entry.setPageNumber(this.currentPageNumber);
                        entry.setYPos(this.elementYPos);
                        float availableHeight = this.pageHeight - this.elementYPos;
                        ReportSection sectionHeader = sTbl.getSubTable(idx).getHeader();
                        boolean printOnNewPageForToc = this.printOnNewPage(sectionHeader) && this.elementYPos > this.pageHeaderHeight;
                        boolean bookmarkOnNewPage = false;
                        if (availableHeight < this.tableDataCellHeight) {
                            entry.setPageNumber(this.currentPageNumber + 1);
                            entry.setYPos(0.0);
                            bookmarkOnNewPage = true;
                        }
                        if (printOnNewPageForToc) {
                            entry.setPageNumber(this.currentPageNumber + 1);
                            bookmarkOnNewPage = true;
                        }
                        if (this.outlineStack == null) {
                            this.outlineStack = new Vector();
                            PdfDestination rootDestination = new PdfDestination(0, this.report.getPageWidthToPoints(), this.report.getPageHeightToPoints(), 0.0f);
                            PdfOutline root = new PdfOutline(this.templates[0].getRootOutline(), rootDestination, "Bookmarks");
                            this.outlineStack.addElement(root);
                        }
                        PdfOutline newOutline = this.writeBookmark(entry.getTitle(), this.outlineStack.elementAt(level), bookmarkOnNewPage);
                        this.outlineStack.addElement(newOutline);
                    } else if (this.outlineStack != null && this.outlineStack.size() > 0) {
                        this.outlineStack.addElement(this.outlineStack.elementAt(this.outlineStack.size() - 1));
                    }
                }
                if (sTbl.getSubTable(idx).isAggregationTable()) continue;
                this.writeReportTable(sTbl.getSubTable(idx), level + 1);
            }
        } else {
            this.writeCells(tbl);
        }
        this.writeSection(tbl.getFooter(), tbl);
        this.addSectionTotalPagesTableEntry();
        if (this.treeStructure.size() > 1) {
            this.treeStructure.removeElementAt(this.treeStructure.size() - 1);
        } else {
            this.treeStructure.removeAllElements();
        }
        if (this.outlineStack != null && this.outlineStack.size() > 1) {
            this.outlineStack.removeElementAt(this.outlineStack.size() - 1);
        }
        this.addSectionTotalPagesTableEntry();
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.removeRepeatSection();
        }
    }

    protected void addSectionTotalPagesTableEntry() {
        if (this.sectionTotalPagesTable != null && this.getTreeStringKey() != null && this.treeCopy.equals(this.getTreeStringKey()) && this.populateTable) {
            if (this.sectionTotalPagesTable.containsKey(this.getTreeStringKey())) {
                this.sectionTotalPages.removeElementAt(this.sectionTotalPages.size() - 1);
                this.sectionStartPage.removeElementAt(this.sectionStartPage.size() - 1);
            }
            this.sectionTotalPagesTable.put(this.getTreeStringKey(), this.currentPageNumber);
            this.sectionTotalPages.addElement(this.currentPageNumber);
            this.sectionStartPage.addElement(this.savedStartPage);
        }
    }

    protected void writeCells(ReportTable tbl) throws Exception {
        float delta;
        int i;
        boolean mSecWritten = false;
        Color bgColor = null;
        boolean printOnNewPage = false;
        boolean visible = false;
        if (tbl.getScriptObj() != null) {
            bgColor = tbl.getBgColor();
            printOnNewPage = tbl.isPrintOnNewPage();
            visible = tbl.isVisible();
            tbl.getScriptObj().applyScript(tbl, this.currentPageNumber, this.currentSection, this.totalPageNumber, this.totalSections, this.report, tbl);
        }
        if (!tbl.isVisible()) {
            return;
        }
        int nRow = tbl.getRowCount();
        Vector<PDFSubReport> remainingSubReports = new Vector<PDFSubReport>();
        this.background_templates = new PdfTemplate[this.templates.length];
        for (int i2 = 0; i2 < this.templates.length; ++i2) {
            this.background_templates[i2] = this.templates[0].createTemplate(this.document.getPageSize().width(), this.document.getPageSize().height());
            this.templates[i2].addTemplate(this.background_templates[i2], 0.0f, 0.0f);
        }
        ReportElement[] relts = tbl.getXSortedVisibleElements();
        if (this instanceof PDFSubReport) {
            this.reportUI.setCurX(QbUtil.pointsToInch(this.elementXPos + ((PDFSubReport)this).offsetX));
        } else {
            this.reportUI.setCurX(QbUtil.pointsToInch(this.elementXPos));
        }
        double[] tempRowShifts = null;
        double[] temp = null;
        double oldX = this.reportUI.curX;
        if (this.report.isCrossTabFixedField()) {
            Object[] objs = this.reportUI.calculateRowShiftsForColumns(relts, tbl);
            this.reportUI.setCurX(oldX);
            relts = (ReportElement[])objs[0];
            tempRowShifts = (double[])objs[1];
            temp = this.reportUI.calculateShifts(relts, tbl);
            this.reportUI.setCurX(oldX);
        } else {
            tempRowShifts = temp = this.reportUI.calculateShifts(relts, tbl);
            this.reportUI.setCurX(oldX);
        }
        this.shifts = new float[temp.length];
        for (i = 0; i < temp.length; ++i) {
            this.shifts[i] = QbUtil.toPoints(temp[i]);
        }
        this.rowShifts = new float[tempRowShifts.length];
        for (i = 0; i < tempRowShifts.length; ++i) {
            this.rowShifts[i] = QbUtil.toPoints(tempRowShifts[i]);
        }
        Vector<ReportElement> oneTime = new Vector<ReportElement>();
        Vector<Float> oneTimeY = new Vector<Float>();
        for (int i3 = 0; i3 < relts.length; ++i3) {
            if (relts[i3] instanceof ReportImage && !(relts[i3] instanceof ReportLine) && !(relts[i3] instanceof ReportGrid)) {
                oneTime.insertElementAt(relts[i3], 0);
                oneTimeY.insertElementAt(Float.valueOf(relts[i3].getYToPoints()), 0);
                continue;
            }
            if (relts[i3] instanceof SubReportObject) {
                oneTime.insertElementAt(relts[i3], 0);
                oneTimeY.insertElementAt(Float.valueOf(relts[i3].getYToPoints()), 0);
                continue;
            }
            if (!(relts[i3] instanceof ReportRTFObject)) continue;
            oneTime.insertElementAt(relts[i3], 0);
            oneTimeY.insertElementAt(Float.valueOf(relts[i3].getYToPoints()), 0);
        }
        ReportElement[] elts = tbl.getZSortedVisibleElements();
        ReportColumn[] col = tbl.getSortedVisibleColumns();
        this.frontOneTime = new Vector();
        this.frontOneTimeY = new Vector();
        if (col != null && col.length > 0) {
            for (int i4 = elts.length - 1; i4 >= 0; --i4) {
                if (elts[i4] instanceof ReportColumn || elts[i4] instanceof ReportLine || elts[i4] instanceof ReportGrid || elts[i4].getZ() <= col[0].getZ() && (elts[i4].getZ() != col[0].getZ() || tbl.getBgColor() == null)) continue;
                ReportCell tmp = null;
                if (elts[i4] instanceof ReportChartObject) {
                    tmp = new ReportChartObject();
                    tmp.copy(elts[i4]);
                } else if (elts[i4] instanceof ReportImage) {
                    tmp = new ReportImage();
                    tmp.copy(elts[i4]);
                } else if (elts[i4] instanceof SubReportObject) {
                    tmp = new SubReportObject();
                    tmp.copy(elts[i4]);
                } else if (elts[i4] instanceof ReportRTFObject) {
                    tmp = new ReportRTFObject();
                    tmp.copy(elts[i4]);
                }
                this.frontOneTime.addElement(tmp);
                this.frontOneTimeY.addElement(Float.valueOf(elts[i4].getYToPoints()));
            }
        }
        float bottomYOfSection = 0.0f;
        ReportSection mSection = tbl.getMasterSection();
        float wrapIndex = 0.0f;
        if (this.wrapInfo != null) {
            wrapIndex = this.wrapInfo[0];
        }
        if (this.checkTotalPageNumber) {
            this.lastDrawCol = (int)wrapIndex;
        }
        this.resetColumnWrapTableUI();
        ReportTable orgTable = tbl;
        this.rows = orgTable.getFormattedRows();
        double[] backupX = ReportUI.backupXPos(relts);
        relts = ReportUI.takeAwaySecuredInvisibleCols(relts, this.report.getPreviewSecurityLevel(), this.report.getReportType());
        this.elementXPos = delta = wrapIndex * this.columnWrapWidth;
        for (int j = 0; j < relts.length; ++j) {
            this.elementXPos = 0.0f;
            for (int l = 0; l <= j; ++l) {
                if (!(relts[l].getY() <= relts[j].getY() && relts[l].getY() + relts[l].getHeight() > relts[j].getY()) && (!(relts[l].getY() >= relts[j].getY()) || !(relts[l].getY() < relts[j].getY() + relts[j].getHeight()))) continue;
                this.incElementXPos(this.rowShifts[l]);
            }
            relts[j].setDrawX(relts[j].getXToPoints() + this.elementXPos);
        }
        ReportUI.recoverXPos(relts, backupX);
        this.oldElementYPos = this.elementYPos;
        for (int i5 = 0; i5 < nRow; ++i5) {
            int ii = i5;
            boolean hasVisibleColumn = false;
            if (tbl.indexArray != null) {
                ii = tbl.indexArray[i5];
            }
            this.elementXPos = delta;
            tbl = this.resizeTable(this.reportGraphics, orgTable, ii);
            if (this.rowElements == null && !tbl.hasVisibleElements() && (i5 > 0 || oneTime.size() == 0 && this.hasNoData(mSection))) continue;
            float tblH = tbl.getHeightToPoints();
            col = tbl.getSortedVisibleColumns();
            if (!this.hasNoData(mSection) && i5 == 0) {
                tblH = (mSection = this.resizeSection(this.reportGraphics, mSection, tbl)).getHeightToPoints() + mSection.getYToPoints() > tblH ? mSection.getHeightToPoints() + mSection.getYToPoints() : tblH;
            }
            int oldpageN = this.currentPageNumber;
            if (tbl.isPrintOnNewPage(this.rowCount)) {
                this.pageBreak(null);
            } else {
                this.pageBreak(tblH, ii);
            }
            ++this.rowCount;
            if (this.wrapInfo != null) {
                wrapIndex = this.wrapInfo[0];
            }
            this.elementXPos = delta = wrapIndex * this.columnWrapWidth;
            if (delta == 0.0f) {
                if (!(this instanceof PDFSubReport)) {
                    this.writeSectionBgColor(tbl);
                } else {
                    ((PDFSubReport)this).shift = 0.0f;
                    for (float shift : this.shifts) {
                        ((PDFSubReport)this).shift += shift;
                    }
                    this.writeSectionBgColor(tbl);
                    ((PDFSubReport)this).shift = 0.0f;
                }
            }
            if (this.currentPageNumber > oldpageN || i5 == 0) {
                this.oldElementYPos = this.elementYPos;
                bottomYOfSection = this.writeVisibleOneTimeElements(oneTime, oneTimeY, remainingSubReports, tbl, relts, this.rowShifts);
            }
            if (!this.hasNoData(mSection) && (i5 == 0 || this.elementYPos - this.oldElementYPos > mSection.getHeightToPoints() && !mSecWritten)) {
                this.elementXPos = 0.0f;
                float temp_elementYPos = this.elementYPos;
                this.elementYPos = this.oldElementYPos;
                this.sectionBreak(mSection.getXToPoints(), mSection.getWidthToPoints());
                this.writeMasterSection(mSection, tbl);
                if (bottomYOfSection < this.elementYPos + (float)mSection.getYPos() + mSection.getHeightToPoints()) {
                    bottomYOfSection = this.elementYPos + (float)mSection.getYPos() + mSection.getHeightToPoints();
                }
                this.elementYPos = temp_elementYPos;
                if (i5 > 0) {
                    mSecWritten = true;
                }
            }
            for (ReportElement relt : relts = tbl.getZSortedVisibleElements()) {
                ReportColumn rc;
                if (relt instanceof ReportImage) {
                    ReportImage img = (ReportImage)relt;
                    if (this.skipCell(img)) continue;
                    if (img instanceof ReportLine || img instanceof ReportGrid) {
                        this.elementXPos = delta + (float)img.getDrawX() - img.getXToPoints();
                        ReportImage newImg = (ReportImage)tbl.formatCell(img, ii, this.getCurrentPageNumber(), this.getSection(), this.getTotalPageNumber(), this.getTotalSections(), this.report, false);
                        if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage) {
                            this.writeTableDataElement(newImg, tbl, tbl, i5);
                        }
                    }
                }
                if (!(relt instanceof ReportColumn) || this.skipCell(rc = (ReportColumn)relt)) continue;
                ReportCell cell = tbl.formatCell(rc, ii, this.getCurrentPageNumber(), this.getSection(), this.getTotalPageNumber(), this.getTotalSections(), i5 - this.columnWrapDisplayRow * (int)wrapIndex - this.columnWrapCount * this.columnWrapInitialRow, this.report);
                if (cell.isVisible()) {
                    hasVisibleColumn = true;
                }
                this.elementXPos = delta + (float)rc.getDrawX() - rc.getXToPoints();
                if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage || this.report.isTocEnabled() && !this.report.getTableOfContentsObject().isUseGroups() && cell.getScript() != null && cell.getScript().toUpperCase().indexOf("BOOKMARK") >= 0) {
                    this.writeTableDataElement(cell, tbl, tbl, i5);
                }
                this.tableDataCellHeight = cell.getHeightToPoints();
            }
            if ((!this.checkTotalPageNumber && !this.checkFitGroupOnPage || this.report.drawBeforeDisplay) && this.rowElements != null) {
                for (int j = 0; j < this.rowElements.size(); ++j) {
                    ReportElement elt = this.rowElements.elementAt(j);
                    this.writeTableDataElement(elt, tbl, tbl, i5);
                }
            }
            if ((!tbl.hasVisibleElements() || !hasVisibleColumn) && this.rowElements == null) continue;
            this.elementYPos += tbl.getHeightToPoints();
        }
        float temp_float = this.elementYPos;
        this.elementYPos = this.oldElementYPos;
        this.elementYPos = temp_float;
        this.background_templates = null;
        if (remainingSubReports.size() > 0 || oneTime.size() > 0) {
            this.elementYPos = this.writeRemainingSubReports(remainingSubReports, oneTime, oneTimeY, null, tbl, relts, this.rowShifts);
        } else if (this.elementYPos < bottomYOfSection) {
            this.elementYPos = bottomYOfSection;
        }
        if (this.doColumnWrap) {
            this.curMaxY = this.wrapInfo != null && this.elementYPos < this.wrapInfo[2] ? this.wrapInfo[2] : this.elementYPos;
        }
        this.elementXPos = 0.0f;
        if (tbl.getScriptObj() != null) {
            tbl.setBgColor(bgColor);
            tbl.setPrintOnNewPage(printOnNewPage);
            tbl.setVisible(visible);
        }
    }

    protected void sectionBreak(float x, float requiredWidth) {
        if (!this.inPageSection) {
            this.currentSection = (int)(x / this.pageWidth) + 1;
        }
        if (Math.ceil((x + this.elementXPos + requiredWidth) / this.pageWidth) != Math.ceil((x + this.elementXPos) / this.pageWidth) && (x + this.elementXPos) % this.pageWidth != 0.0f) {
            this.elementXPos = this.elementXPos + this.pageWidth - (x + this.elementXPos) % this.pageWidth;
        }
    }

    protected boolean skipCell(ReportElement cell) {
        if (cell instanceof ColumnWrap) {
            return true;
        }
        if (!this.doColumnWrap) {
            return false;
        }
        return cell.getXToPoints() + cell.getWidthToPoints() > this.columnWrapWidth;
    }

    protected void writeBorder(float x, float y, float w, float h, float border, Color color, String borderStyle) throws Exception {
        float halfBorder = border * 0.5f;
        this.writeRectangle(this.getContentByteIndex(x), x - halfBorder, y - h - halfBorder + this.pixelToPoints(1), x + w + halfBorder - this.pixelToPoints(1), y + halfBorder, border, color, 15);
        if (borderStyle.equals("double")) {
            this.writeRectangle(this.getContentByteIndex(x), x - 5.0f * halfBorder, y - h - 5.0f * halfBorder, x + w + 5.0f * halfBorder, y + 5.0f * halfBorder, border, color, 15);
        }
    }

    protected float getX(ReportElement elt) {
        return elt.getXToPoints() + this.elementXPos;
    }

    protected float getY(ReportElement elt) {
        return this.pageHeight - this.elementYPos - elt.getYToPoints();
    }

    protected float getAbsoluteX(float pageX, int contentByteIndex) {
        if (contentByteIndex < 0 || contentByteIndex >= this.templates.length) {
            return this.getAbsoluteX(pageX);
        }
        return pageX - this.pageWidth * (float)contentByteIndex + this.leftMargin;
    }

    protected float getAbsoluteX(float pageX) {
        return pageX % this.pageWidth + this.leftMargin;
    }

    protected float getAbsoluteY(float pageY) {
        return pageY + this.pageFooterHeight + this.bottomMargin;
    }

    protected int getContentByteIndex(float x) {
        int index = (int)Math.floor(((double)x + 0.001) / (double)this.pageWidth);
        return index;
    }

    protected boolean isVisible(ReportElement elt) {
        return true;
    }

    protected void writeTableDataElement(ReportElement elt, ReportTable table, ReportTableElement panel) throws Exception, IOException, MalformedURLException {
        this.writeTableDataElement(elt, table, panel, 0);
    }

    protected void writeTableDataElement(ReportElement elt, ReportTable table, ReportTableElement panel, int row) throws Exception, IOException, MalformedURLException {
        if (elt instanceof ReportCell && ((ReportCell)elt).getBookmark() != null && this.report.isTocEnabled()) {
            Bookmark entry = this.report.getTableOfContentsObject().addBookmark(((ReportCell)elt).getBookmark());
            entry.setPageNumber(this.currentPageNumber);
            entry.setYPos(this.elementYPos);
        }
        if (this.checkTotalPageNumber || this.checkFitGroupOnPage) {
            return;
        }
        if (!this.isVisible(elt) || !elt.isVisible()) {
            return;
        }
        Color color = panel.getBgColor();
        if (elt instanceof ReportChartObject) {
            ReportCell[] cells = null;
            if (panel instanceof ReportSection) {
                cells = ((ReportSection)panel).getData();
            }
            this.writeReportChart((ReportChartObject)elt, table, cells, row);
        } else if (elt instanceof ReportLine) {
            this.writeReportLine((ReportLine)elt, panel);
        } else if (elt instanceof ReportGrid) {
            this.writeReportGrid((ReportGrid)elt, panel);
        } else if (elt instanceof ReportImage && !(elt instanceof ReportLine) && !(elt instanceof ReportGrid)) {
            this.writeReportImage((ReportImage)elt, color);
        } else {
            this.writeText(elt, table, row);
        }
    }

    private void writeReportChart(ReportChartObject chart, ReportTable table, ReportCell[] cells, int row) {
        Vector<ImageMapNode> imageMap = new Vector<ImageMapNode>();
        int tplIdx = 0;
        Graphics2D graphics = null;
        try {
            int width = QbUtil.toPixel(chart.getWidth());
            int height = QbUtil.toPixel(chart.getHeight());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            BufferedImage image = new BufferedImage(width, height, 1);
            graphics = image.createGraphics();
            int[] mapping = null;
            String linkPrefix = "";
            if (chart.getDrillDownName() != null) {
                try {
                    DrillDownNode node = this.getDrillDownNode(chart);
                    mapping = node.getColumnMapping();
                    linkPrefix = node.getServletLink(this.report, this.ddBytesSentToServlet, 2);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINEST, "Cannot load drill-down mapping", e);
                }
            }
            Vector<Object[]> preSetParams = ChartObject.getPresetParams(this.report, table, chart, false);
            Chart chartInstance = null;
            chartInstance = !chart.isReportDataUsed() ? ChartObject.getIndependentChart(this.report, chart, preSetParams) : ChartObject.getReportDataUsedChart(this.report, table, cells, chart, preSetParams);
            if (!(chartInstance.isTranslucent() || chartInstance.hasHighlightOverlapControlArea() || !chartInstance.is2DimChart() && chartInstance.isCircularChart())) {
                tplIdx = this.getContentByteIndex(this.getX(chart));
                PdfContentByte cb = this.templates[tplIdx];
                cb.saveState();
                float magicnum = 72.0f / (float)QbUtil.getPixelPerInch_export();
                cb.concatCTM(magicnum, 0.0f, 0.0f, magicnum, this.getAbsoluteX(this.getX(chart)), this.getAbsoluteY(this.getY(chart)) - chart.getHeightToPoints());
                this.compromisePdfGraphics(chartInstance);
                Hashtable<String, String> fontMapping = chartInstance.getFontMapping();
                if (fontMapping == null || fontMapping.size() == 0) {
                    fontMapping = this.report.getFontMapping();
                }
                QbFontMapper fontMapper = new QbFontMapper(fontMapping);
                Graphics2D g2 = cb.createGraphics(width, height, fontMapper);
                ChartObject.draw(g2, this.report, table, cells, chart, width, height, imageMap, 0, 0, mapping, null, null, null, -1, linkPrefix, preSetParams, chartInstance);
                g2.dispose();
                cb.restoreState();
                this.unCompromisePdfGraphics(chartInstance);
            } else {
                ChartObject.draw(graphics, this.report, table, cells, chart, width, height, imageMap, 0, 0, mapping, null, null, null, -1, linkPrefix);
                ImageEncoder.encode(ImageEncoder.ExportFormat.JPEG, image, bout, 99);
                Jpeg img = new Jpeg(bout.toByteArray());
                img.setAbsolutePosition(this.getAbsoluteX(this.getX(chart)), this.getAbsoluteY(this.getY(chart)) - chart.getHeightToPoints());
                img.scaleAbsolute(chart.getWidthToPoints(), chart.getHeightToPoints());
                img.setInterpolation(true);
                tplIdx = this.getContentByteIndex(this.getX(chart));
                if (tplIdx >= 0 && tplIdx < this.templates.length) {
                    this.templates[tplIdx].addImage(img);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Can't export, trying to print text", e);
            try {
                this.writeText(chart, table, row);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to write text", ex);
            }
        }
        try {
            if (chart.getBorderThickness() != 0) {
                this.writeBorder(this.getX(chart), this.getY(chart), chart.getWidthToPoints(), chart.getHeightToPoints(), this.pixelToPoints(chart.getBorderThickness()), chart.getBorderColor(), this.getBorderStyle(chart));
            }
            if (chart.getDrillDownName() == null) {
                imageMap = null;
            }
            if (tplIdx >= 0 && tplIdx < this.templates.length) {
                this.insertLink(this.templates[tplIdx], (ReportElement)chart, imageMap, graphics);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed to write table", e);
        }
        if (graphics != null) {
            graphics.dispose();
        }
    }

    private void compromisePdfGraphics(Chart c) {
        this.j2DRotateEnabled = c.isJ2DRotateEnabled();
        c.setJ2DRotateEnabled(true);
    }

    private void unCompromisePdfGraphics(Chart c) {
        c.setJ2DRotateEnabled(this.j2DRotateEnabled);
    }

    private void writeReportImage(ReportImage elt, Color color) {
        try {
            if (elt.getBorderThickness() != 0) {
                this.writeBorder(this.getX(elt), this.getY(elt), elt.getWidthToPoints(), elt.getHeightToPoints(), this.pixelToPoints(elt.getBorderThickness()), elt.getBorderColor(), this.getBorderStyle(elt));
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Can't write image border", ex);
        }
        int tplIdx = this.getContentByteIndex(this.getX(elt));
        if (tplIdx >= 0 && tplIdx < this.templates.length) {
            this.writeReportImageHelper(elt, color, this.templates[tplIdx], this.getAbsoluteX(this.getX(elt)), this.getAbsoluteY(this.getY(elt)) - elt.getHeightToPoints(), elt.getWidthToPoints(), elt.getHeightToPoints());
        }
    }

    private void writeReportImageHelper(ReportImage elt, Color color, PdfContentByte pdfTemplate, float x, float y, float w, float h) {
        String ifilename = null;
        try {
            byte[] barray;
            Image img = null;
            color = null;
            boolean hasTransparency = false;
            try {
                ifilename = elt.isDBImage() ? elt.getRelativePath() : (elt.getImageURL().toString().startsWith("file:") ? elt.getImageURL().getFile() : elt.getImageURL().toString());
                if (ifilename != null) {
                    ifilename = QbUtil.fixUrlString(ifilename);
                }
                ReadDataFile rdf = new ReadDataFile();
                DataInputStream dis = rdf.getInputStream(null, ifilename);
                Vector<Byte> bs = new Vector<Byte>();
                boolean notEOF = true;
                while (notEOF) {
                    try {
                        bs.addElement(dis.readByte());
                    }
                    catch (EOFException e) {
                        LOGGER.log(Level.FINEST, "Failed to read byte", e);
                        notEOF = false;
                    }
                }
                barray = new byte[bs.size()];
                for (int i = 0; i < bs.size(); ++i) {
                    barray[i] = (Byte)bs.elementAt(i);
                }
                dis.close();
                java.awt.Image image = Toolkit.getDefaultToolkit().createImage(barray);
                BufferedImage bufferedImage = Pictures.toBufferedImage(image);
                hasTransparency = this.fixTransparency(bufferedImage);
                img = Image.getInstance(bufferedImage, color);
            }
            catch (Exception ex) {
                barray = elt.getBytes();
                if (barray != null) {
                    java.awt.Image image = Toolkit.getDefaultToolkit().createImage(barray);
                    BufferedImage bufferedImage = Pictures.toBufferedImage(image);
                    hasTransparency = this.fixTransparency(bufferedImage);
                    img = Image.getInstance(bufferedImage, color);
                }
                LOGGER.log(Level.FINE, "PDF Export: Image file not found", ex);
            }
            if (img != null) {
                img.setFilePath(ifilename);
                img.setAbsolutePosition(x, y);
                img.scaleAbsolute(w, h);
                img.setInterpolation(!hasTransparency);
                img.setTransparency(new int[]{255, 255, 255, 255, 255, 255});
            }
            try {
                pdfTemplate.addImage(img);
            }
            catch (DocumentException e) {
                LOGGER.log(Level.FINEST, "Failed to add image to PDF template", e);
                img = null;
                img = Image.getInstance(Toolkit.getDefaultToolkit().createImage(barray), color);
                if (img != null) {
                    img.setFilePath(ifilename);
                    img.setAbsolutePosition(x, y);
                    img.scaleAbsolute(w, h);
                    img.setInterpolation(true);
                    pdfTemplate.addImage(img);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to write image", e);
        }
        this.insertLink(pdfTemplate, elt);
    }

    private boolean fixTransparency(BufferedImage bufferedImage) {
        boolean hasTransparency = false;
        for (int xx = 0; xx < bufferedImage.getWidth(); ++xx) {
            for (int yy = 0; yy < bufferedImage.getHeight(); ++yy) {
                Color originalColor = new Color(bufferedImage.getRGB(xx, yy), true);
                if (originalColor.getAlpha() >= 128) continue;
                bufferedImage.setRGB(xx, yy, Color.WHITE.getRGB());
                hasTransparency = true;
            }
        }
        return hasTransparency;
    }

    protected void insertLink(PdfContentByte cb, ReportElement elt) {
        this.insertLink(cb, elt, null, 0);
    }

    protected void insertLink(PdfContentByte cb, ReportElement elt, Vector<ImageMapNode> imageMap, Graphics2D graphics2D) {
        for (int i = 0; i < imageMap.size(); ++i) {
            ImageMapNode node = imageMap.elementAt(i);
            try {
                PdfAction action = new PdfAction(node.getLink());
                Object obj = node.getObject();
                float oX = this.getAbsoluteX(this.getX(elt));
                float oY = this.getAbsoluteY(this.getY(elt));
                if (obj instanceof java.awt.Rectangle) {
                    java.awt.Rectangle rect = (java.awt.Rectangle)obj;
                    float x = QbUtil.pixelToPoints((int)rect.getX()) + oX;
                    float y = oY - QbUtil.pixelToPoints((int)rect.getY());
                    float w = QbUtil.pixelToPoints((int)rect.getWidth());
                    float h = QbUtil.pixelToPoints((int)rect.getHeight());
                    float llx = x;
                    float lly = y - h;
                    float urx = x + w;
                    float ury = y;
                    cb.setAction(action, llx, lly, urx, ury);
                    continue;
                }
                if (!(obj instanceof Arc)) continue;
                Arc arc = (Arc)obj;
                if (graphics2D == null) continue;
                Arc2D.Double arc2D = new Arc2D.Double(arc.x - arc.w / 2, arc.y - arc.h / 2, arc.w, arc.h, arc.startangle, arc.angle, 2);
                Rectangle2D rect = arc2D.getBounds2D();
                double segHeight = 3.0;
                double accHeight = 0.0;
                while (accHeight + segHeight < rect.getHeight()) {
                    graphics2D.setClip(arc2D);
                    graphics2D.clipRect((int)rect.getX(), (int)(rect.getY() + accHeight), (int)rect.getWidth(), (int)segHeight);
                    accHeight += segHeight;
                    java.awt.Rectangle rect2 = graphics2D.getClip().getBounds();
                    this.setAction(cb, action, oX, oY, rect2);
                }
                if (!(accHeight < rect.getHeight())) continue;
                graphics2D.setClip(arc2D);
                graphics2D.clipRect((int)rect.getX(), (int)(rect.getY() + accHeight), (int)rect.getWidth(), (int)(rect.getHeight() - accHeight));
                java.awt.Rectangle rect2 = graphics2D.getClip().getBounds();
                this.setAction(cb, action, oX, oY, rect2);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setAction(PdfContentByte cb, PdfAction action, float oX, float oY, Rectangle2D rect) {
        float x = QbUtil.pixelToPoints((int)rect.getX()) + oX;
        float y = oY - QbUtil.pixelToPoints((int)rect.getY());
        float w = QbUtil.pixelToPoints((int)rect.getWidth());
        float h = QbUtil.pixelToPoints((int)rect.getHeight());
        float llx = x;
        float lly = y - h;
        float urx = x + w;
        float ury = y;
        cb.setAction(action, llx, lly, urx, ury);
    }

    private DrillDownNode getDrillDownNode(ReportElement elt) {
        DrillDownNode node = null;
        DrillDownNode parentNode = this.report.currentNode;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            if (!elt.getDrillDownName().equals(parentNode.getChildAt(i).getName())) continue;
            node = parentNode.getChildAt(i);
            i = parentNode.getChildCount();
        }
        return node;
    }

    private void insertLink(PdfContentByte cb, ReportElement elt, ReportTable table, int row) {
        String url;
        block32: {
            if (elt.getDrillDownName() != null) {
                DrillDownNode node = this.getDrillDownNode(elt);
                try {
                    if (!node.isValidDrillDownNode()) break block32;
                    node.setSubReportPath(this.report.getSubReportPath());
                    int[] mapping = node.getColumnMapping();
                    ReportTable tempTable = table;
                    while (tempTable instanceof ReportTreeTable) {
                        tempTable = ((ReportTreeTable)tempTable).getSubTable(0);
                    }
                    String parameters = "";
                    boolean addLink = true;
                    for (int i = 0; i < mapping.length; ++i) {
                        Object value;
                        block33: {
                            value = null;
                            if (mapping[i] < 0) {
                                value = "UnMapped";
                            } else if (mapping[i] >= 1000 && mapping[i] < 2000) {
                                value = this.report.getQueryParameters().elementAt(mapping[i] - 1000).getValue();
                            } else if (mapping[i] >= 2000) {
                                value = this.report.getFormulaParameters().elementAt(mapping[i] - 2000).getValue();
                            } else if (node.isCrossTabDrillDown()) {
                                if (this.report.colInfo[mapping[i]].isColumnBreak() && ((ReportCell)elt).getColumn() instanceof ColumnBreakColumn) {
                                    for (ColData element : this.report.colData) {
                                        if (!this.report.colInfo[mapping[i]].getName().equals(element.getName())) continue;
                                        for (int n = 0; n < element.getSize(); ++n) {
                                            if (!element.getData(n).toString().equalsIgnoreCase(((ColumnBreakColumn)((ReportCell)elt).getColumn()).getText(this.report, mapping[i]).toString())) continue;
                                            value = element.getData(n);
                                            break block33;
                                        }
                                        break;
                                    }
                                } else if (this.report.getColumnType(this.report.getColInfoIndex(((ReportCell)elt).getColumn())).equalsIgnoreCase("ROW BREAK")) {
                                    addLink = false;
                                } else {
                                    value = tempTable.getColumn(this.report.getColumnIndex(mapping[i])).getData(0);
                                }
                            } else {
                                value = tempTable.getColumn(this.report.getColumnIndex(mapping[i])).getDrillDownData(row);
                            }
                        }
                        if (value == null) {
                            throw new Exception("No data available for drill-down.");
                        }
                        parameters = parameters + "&PARAM" + i + "=" + QbUtil.urlEncode(DataType.write(value));
                    }
                    if (addLink) {
                        String link = node.getServletLink(this.report, this.ddBytesSentToServlet, 2);
                        link = link + parameters + "&CHARSET=" + (this.report.getHTMLCharset() == null ? "Cp1252" : this.report.getHTMLCharset());
                        link = link + "&FromPDFDrillDown=true";
                        if (this.report.getDrillDownConnection() != null) {
                            link = link + "&DRILLDOWNCONN=true";
                        }
                        if (this.report.getDrillDownDatabaseInfo() != null) {
                            link = link + "&DRILLDOWNDATABASEINFO=true";
                        }
                        PdfAction action = new PdfAction(link);
                        float llx = this.getX(elt);
                        float lly = this.getY(elt) - elt.getHeightToPoints();
                        float urx = this.getX(elt) + elt.getWidthToPoints();
                        float ury = this.getY(elt);
                        cb.setAction(action, this.getAbsoluteX(llx), this.getAbsoluteY(lly), this.getAbsoluteX(llx) + Math.abs(urx - llx), this.getAbsoluteY(ury));
                    }
                    return;
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Failed to insert link", e);
                    return;
                }
            }
        }
        if ((url = elt.getLink().trim()).equals("")) {
            return;
        }
        URL urlConnection = null;
        try {
            urlConnection = new URL(url);
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.FINEST, "Invalid URL", e);
        }
        try {
            PdfAction action;
            if (urlConnection != null) {
                action = new PdfAction(urlConnection);
            } else {
                url = url.replace('\\', '/');
                while (url.startsWith("/")) {
                    url = url.substring(1);
                }
                action = new PdfAction(url);
            }
            float llx = this.getX(elt);
            float lly = this.getY(elt) - elt.getHeightToPoints();
            float urx = this.getX(elt) + elt.getWidthToPoints();
            float ury = this.getY(elt);
            if (cb.pageNumber > -1) {
                cb.setAction(action, this.getAbsoluteX(llx), this.getAbsoluteY(lly), this.getAbsoluteX(llx) + Math.abs(urx - llx), this.getAbsoluteY(ury));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed to set PdfAction", e);
        }
    }

    protected void insertDestination(PdfContentByte cb, ReportElement elt) {
        if (this.report.isTocEnabled() && this.report.getTableOfContentsObject().isUseGroups()) {
            return;
        }
        if (elt.getBookmark() != null) {
            float llx = this.getX(elt);
            float ury = this.getY(elt);
            PdfDestination dest = new PdfDestination(0, this.getAbsoluteX(llx), this.getAbsoluteY(ury), 0.0f);
            cb.localDestination(elt.getBookmark(), dest);
            if (this.rootOutline == null) {
                PdfDestination rootDestination = new PdfDestination(0, this.report.getPageWidthToPoints(), this.report.getPageHeightToPoints(), 0.0f);
                this.rootOutline = new PdfOutline(this.templates[0].getRootOutline(), rootDestination, "Bookmarks");
            }
            PdfOutline outline = new PdfOutline(this.rootOutline, dest, elt.getBookmark());
            cb.addOutline(outline);
        }
    }

    protected void insertGoToAction(PdfContentByte cb, ReportElement elt) {
        if (elt.getLink() != null && elt.getLink().startsWith("#") && elt.getLink().length() > 1) {
            float llx = this.getX(elt);
            float lly = this.getY(elt) - elt.getHeightToPoints();
            float urx = this.getX(elt) + elt.getWidthToPoints();
            float ury = this.getY(elt);
            cb.localGoto(elt.getLink().substring(1), this.getAbsoluteX(llx), this.getAbsoluteY(lly), this.getAbsoluteX(llx) + Math.abs(urx - llx), this.getAbsoluteY(ury));
        }
    }

    private void writeReportLine(ReportLine line, ReportTableElement panel) throws Exception {
        if (line instanceof ColumnWrap || line.getBorderThickness() == 0) {
            return;
        }
        float w = line.getWidthToPoints();
        float h = line.getHeightToPoints();
        if (line.isVertical()) {
            w = this.toPoints(line.getWidth() - 0.02);
        } else {
            int lineEndPage;
            int lineStartPage = (int)(line.getXToPoints() / this.pageWidth);
            float lineEndPoint = line.getXToPoints() + line.getWidthToPoints();
            int n = lineEndPage = (double)(lineEndPoint % this.pageWidth) < 0.001 ? (int)(lineEndPoint / this.pageWidth - 1.0f) : (int)(lineEndPoint / this.pageWidth);
            if (lineStartPage != lineEndPage) {
                return;
            }
            h = this.toPoints(line.getHeight() - 0.02);
        }
        float x = this.getX(line);
        float y = this.getY(line);
        int contentByteIndex = this.getContentByteIndex(x);
        if (contentByteIndex >= this.templates.length) {
            return;
        }
        if (!line.isVertical()) {
            if (this.getBorderStyle(line).equals("double")) {
                this.writeRectangle(contentByteIndex, x, y, x + w, y, h, line.getBgColor(), 2);
                this.writeRectangle(contentByteIndex, x, y - 2.0f * h, x + w, y - 2.0f * h, h, line.getBgColor(), 2);
            } else if (this.getBorderStyle(line).equals("solid")) {
                float half = h / 2.0f;
                if (half < 1.0f) {
                    half = 0.0f;
                }
                this.writeRectangle(contentByteIndex, x, y - half, x + w, y, h, line.getBgColor(), 2);
            } else {
                for (float i = x; i < x + w - this.dashInterval; i += 3.0f * this.dashInterval) {
                    this.writeRectangle(contentByteIndex, i, y, i + this.dashInterval, y, h, line.getBgColor(), 2);
                }
            }
        } else {
            if (line.getHeight() < 0.0) {
                ReportLine headNode = line.getHeadNode();
                h = headNode == line ? this.toPoints(panel.getHeight() - line.getY()) : panel.getHeightToPoints();
            }
            if (this.getBorderStyle(line).equals("double")) {
                this.writeRectangle(contentByteIndex, x, y - h, x, y, w, line.getBgColor(), 4);
                this.writeRectangle(contentByteIndex, x + 2.0f * w, y - h, x + 2.0f * w, y, w, line.getBgColor(), 4);
            } else if (this.getBorderStyle(line).equals("solid")) {
                this.writeRectangle(contentByteIndex, x, y - h, x, y, w, line.getBgColor(), 4);
            } else {
                for (float i = y; i > y - h + this.dashInterval; i -= 3.0f * this.dashInterval) {
                    this.writeRectangle(contentByteIndex, x, i - this.dashInterval, x, i, w, line.getBgColor(), 4);
                }
            }
        }
    }

    private void writeReportGrid(ReportGrid grid, ReportTableElement panel) throws Exception {
        if (grid.getBorderColor() == null && grid.getBgColor() == null) {
            return;
        }
        float x = this.getX(grid);
        float y = this.pageHeight + this.topMargin - this.getY(grid);
        float bThickness = this.pixelToPoints(grid.getBorderThickness());
        float w = grid.getWidthToPoints();
        float h = grid.getHeightToPoints();
        int roundCornerRadius = grid.getRoundCornerRadius();
        boolean[] roundCornersArray = grid.getRoundCornersArray();
        int contentByteIndex = this.getContentByteIndex(x);
        if (contentByteIndex >= this.templates.length) {
            return;
        }
        x = this.getAbsoluteX(x);
        if (grid.getHeight() < 0.0) {
            ReportGrid headNode = grid.getHeadNode();
            if (headNode == grid) {
                h = this.toPoints(panel.getHeight() - grid.getY());
            } else if (grid.next() != null) {
                h = panel.getHeightToPoints();
            }
        }
        PdfContentByte cb = this.templates[contentByteIndex];
        cb.saveState();
        Graphics2D g2 = cb.createGraphics(this.document.getPageSize().width(), this.document.getPageSize().height());
        boolean drawTop = true;
        boolean drawBottom = true;
        if (grid.getPrev() != null) {
            drawTop = false;
        }
        if (grid.getNext() != null) {
            drawBottom = false;
        }
        Java2DUtil.drawCellWithRoundCornersBySegments(g2, x, y, roundCornerRadius, roundCornersArray, w, h, grid.getBorderColor(), grid.getBgColor(), grid.getGridStyle(), true, drawTop, drawBottom, new float[]{this.pixelToPoints(grid.getTopBorder()), this.pixelToPoints(grid.getRightBorder()), this.pixelToPoints(grid.getBottomBorder()), this.pixelToPoints(grid.getLeftBorder())});
        g2.dispose();
        cb.restoreState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PDFSubReport writeTOCObject(TableOfContents toc, ReportTable tbl, ReportSection parentSection) {
        try {
            ReportElement securityLevel = toc.getSecurityLevel(this.report.getPreviewSecurityLevel());
            if (securityLevel != null && !securityLevel.isVisible()) {
                return null;
            }
            float pageHeight = -1.0f;
            if (!toc.isResizeToFitContent()) {
                pageHeight = toc.getHeightToPoints() + this.elementYPos + toc.getYToPoints();
            }
            PDFTOCObject pdfSub = new PDFTOCObject(toc, tbl, this.getX(toc), this.elementYPos + toc.getYToPoints(), toc.getWidthToPoints(), pageHeight, this);
            pdfSub.setParentSection(parentSection, this.pageHeight);
            Object object = pdfSub.LOCK;
            synchronized (object) {
                new Thread(pdfSub).start();
                try {
                    pdfSub.LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return pdfSub;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to write TOC object", ex);
            return null;
        }
    }

    protected PDFSubReport writeSubReport(SubReportObject subReport, ReportTable tbl) {
        return this.writeSubReport(subReport, tbl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PDFSubReport writeSubReport(SubReportObject subReport, ReportTable tbl, ReportSection parentSection) {
        try {
            ReportElement securityLevel = subReport.getSecurityLevel(this.report.getPreviewSecurityLevel());
            if (securityLevel != null && !securityLevel.isVisible()) {
                return null;
            }
            Report sreport = null;
            if (subReport.hasUsableReport()) {
                sreport = subReport.getSubReport().getReportInfo();
                if (sreport.getQueryParams().size() != 0) {
                    sreport = subReport.reloadReportWithParameters(sreport, this.report, tbl);
                } else {
                    System.out.println("*** PDF.................................");
                    if (sreport.dbInfo.getDriverName() != null) {
                        sreport = subReport.loadReport(this.report, tbl);
                    } else {
                        try {
                            Report temp = ReloadReport.reloadData(new Report(sreport), false);
                            if (temp != null) {
                                sreport = temp;
                            }
                        }
                        catch (Exception ex) {
                            sreport.getReportTables().elementAt(0).setVisible(false);
                            subReport.setHeight(0.0);
                            this.report.setInitializeReportError(LanguageEncoder.getText("Subreport datasource not found!") + "\n" + IOUtil.getStackTrace(ex));
                        }
                    }
                }
            } else {
                sreport = subReport.loadReport(this.report, tbl);
            }
            float pageH = -1.0f;
            float pageW = -1.0f;
            if (!subReport.isResizeToFitContent()) {
                pageH = subReport.getHeightToPoints() + this.elementYPos + subReport.getYToPoints();
            }
            if (!subReport.isResizeWidth() || !this.checkTotalPageNumber) {
                pageW = subReport.getWidthToPoints();
            }
            sreport.setDynamicExport(this.report.isDynamicExport, this.report.serverName, this.report.servletRunnerPort);
            sreport.setDynamicExport(this.report.isDynamicExport, this.report.relativeUrlToServlets());
            sreport.setHttpsDynamicExport(this.report.isHttpsDynamicExport(), this.report.getHttpsServerName(), this.report.getHttpsServletRunnerPort());
            sreport.setServletDirectory(this.report.getServletDirectory());
            sreport.setFontMapping(this.report.getFontMapping());
            sreport.setSubReportPath(this.report.getSubReportPath());
            if (this.report.getDrillDownConnection() != null) {
                sreport.setDrillDownConnection(this.report.getDrillDownConnection());
            }
            if (this.report.getDrillDownDatabaseInfo() != null) {
                sreport.setDrillDownDatabaseInfo(this.report.getDrillDownDatabaseInfo());
            }
            PDFSubReport pdfSub = new PDFSubReport(sreport, this.getX(subReport), this.elementYPos + subReport.getYToPoints(), pageW, pageH, this);
            pdfSub.setParentSection(parentSection, this.pageHeight);
            pdfSub.ddBytesSentToServlet = this.ddBytesSentToServlet;
            Object object = pdfSub.LOCK;
            synchronized (object) {
                new Thread(pdfSub).start();
                try {
                    pdfSub.LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.report.addTriggeredAlerts(sreport.getTriggeredAlerts(), sreport.getFileNameWithoutPath());
            return pdfSub;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to write sub-report", ex);
            return null;
        }
    }

    protected PDFSubReport writeRTFObject(ReportRTFObject rtfObject, ReportTable tbl) {
        return this.writeRTFObject(rtfObject, tbl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PDFSubReport writeRTFObject(ReportRTFObject rtfObject, ReportTable tbl, ReportSection parentSection) {
        try {
            ReportElement securityLevel = rtfObject.getSecurityLevel(this.report.getPreviewSecurityLevel());
            if (securityLevel != null && !securityLevel.isVisible()) {
                return null;
            }
            Vector<Vector<Object[]>> lines = this.reportGraphics.breakRichText(rtfObject, this.report, tbl, QbUtil.toPixel(rtfObject.getColumnWidth()), false);
            float pageHeight = -1.0f;
            if (!rtfObject.isResizeToFitContent()) {
                pageHeight = rtfObject.getHeightToPoints() + this.elementYPos + rtfObject.getYToPoints();
            }
            PDFRTFObject pdfSub = new PDFRTFObject(rtfObject, lines, this.getX(rtfObject), this.elementYPos + rtfObject.getYToPoints(), rtfObject.getWidthToPoints(), pageHeight, this);
            pdfSub.setParentSection(parentSection, this.pageHeight);
            Object object = pdfSub.LOCK;
            synchronized (object) {
                new Thread(pdfSub).start();
                try {
                    pdfSub.LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return pdfSub;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to write PDF object", ex);
            return null;
        }
    }

    protected void writeText(PdfContentByte contentByte, String text, float x, float y, BaseFont bf, float size, Color color, double rotation, short align) {
        if (color == null) {
            return;
        }
        contentByte.beginText();
        contentByte.setFontAndSize(bf, size);
        contentByte.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
        for (rotation = -rotation; rotation < 0.0; rotation = 360.0 + rotation) {
        }
        if (this.hasRtlChars(text)) {
            int pdfAlign;
            switch (align) {
                case 0: {
                    pdfAlign = 1;
                    break;
                }
                case 2: {
                    pdfAlign = 2;
                    break;
                }
                default: {
                    pdfAlign = 0;
                }
            }
            Phrase phrase = new Phrase(text, new Font(bf, size));
            ColumnText.showTextAligned(contentByte, pdfAlign, phrase, this.getAbsoluteX(x), this.getAbsoluteY(y), (float)rotation, 3, 1);
        } else {
            double rad = Math.PI * rotation / 180.0;
            contentByte.setTextMatrix((float)Math.cos(rad), (float)Math.sin(rad), (float)(-Math.sin(rad)), (float)Math.cos(rad), this.getAbsoluteX(x), this.getAbsoluteY(y));
            contentByte.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
            contentByte.showText(text);
        }
        contentByte.resetRGBColorFill();
        contentByte.endText();
    }

    protected void writeTextUnderline(PdfContentByte contentByte, float x1, float y1, float x2, float y2, Color color) {
        if (color == null) {
            return;
        }
        contentByte.setLineWidth(1.0f);
        contentByte.setColorStroke(color);
        contentByte.moveTo(this.getAbsoluteX(x1), this.getAbsoluteY(y1));
        contentByte.lineTo(this.getAbsoluteX(x2), this.getAbsoluteY(y2));
        contentByte.stroke();
        contentByte.resetRGBColorStroke();
    }

    protected void writeWaterMark() throws DocumentException, IOException {
        if (ServerMessage.isEvalVersion()) {
            BaseFont bf = BaseFont.createFont("Times-Roman", "Cp1252", false);
            for (int i = 0; i < this.templates.length; ++i) {
                this.writeText(this.templates[i], this.evalString, (float)i * this.pageWidth + 40.0f, this.pageHeight + this.topMargin - 20.0f, bf, 12.0f, IOUtil.getRandomColor(), 0.0, (short)1);
                this.writeText(this.templates[i], this.contactString, (float)i * this.pageWidth + 40.0f, 10.0f - this.bottomMargin, bf, 12.0f, IOUtil.getRandomColor(), 0.0, (short)1);
            }
        }
    }

    private void writeText(ReportElement elt, ReportTable table, int row) throws IOException, Exception {
        int tplIdx = this.getContentByteIndex(this.getX(elt));
        if (tplIdx < 0 || tplIdx >= this.templates.length) {
            return;
        }
        this.insertLink(this.templates[tplIdx], elt, table, row);
        this.insertDestination(this.templates[tplIdx], elt);
        this.insertGoToAction(this.templates[tplIdx], elt);
        float x = this.toPoints(elt.getX());
        float y = this.toPoints(elt.getY());
        float w = this.toPoints(elt.getX() + elt.getWidth()) - x;
        float h = this.toPoints(elt.getY() + elt.getHeight()) - y;
        x = this.getX(elt);
        y += this.elementYPos + this.topMargin;
        int gridStyle = -1;
        Color borderColor = elt.getBorderColor();
        Color bgColor = elt.getBgColor();
        int roundCornerRadius = elt.getRoundCornerRadius();
        boolean[] roundCornersArray = elt.getRoundCornersArray();
        if (elt instanceof ReportGrid) {
            gridStyle = ((ReportGrid)elt).getGridStyle();
        } else if (elt instanceof ReportLine) {
            gridStyle = ((ReportLine)elt).getLineStyle();
        }
        PdfContentByte cb = this.templates[tplIdx];
        cb.saveState();
        Graphics2D g2d = cb.createGraphics(this.document.getPageSize().width(), this.document.getPageSize().height());
        Java2DUtil.drawCellWithRoundCornersBySegments(g2d, this.getAbsoluteX(x, this.getContentByteIndex(x)), y, roundCornerRadius, roundCornersArray, w, h, borderColor, bgColor, gridStyle, true, true, true, new float[]{this.pixelToPoints(elt.getTopBorder()), this.pixelToPoints(elt.getRightBorder()), this.pixelToPoints(elt.getBottomBorder()), this.pixelToPoints(elt.getLeftBorder())});
        g2d.dispose();
        cb.restoreState();
        if (!(((ReportCell)elt).getDataFormat() instanceof BarcodeFormat)) {
            BaseFont b = this.mapToPDFFont(elt.getRefFont(), IOUtil.containsUnicode(elt.getText()));
            float size = this.mapFontSize(elt.getRefFont().getSize());
            int width = elt.getWidthOfElement(true);
            h = elt.getHeightToPoints();
            short align = elt.getAlign();
            String text = elt.getText();
            try {
                java.awt.Font font = elt.getRefFontToDraw(this.report.isAdjustFont());
                if (this.reportUI.report.getStringCustomizer() != null) {
                    text = this.reportUI.report.getStringCustomizer().encodeString(text);
                }
                FontMetrics fm = this.getFontMetrics(font);
                int offset = 3;
                float charH = this.pixelToPoints(fm.getMaxAscent() + fm.getMaxDescent());
                float descent = this.pixelToPoints(fm.getMaxDescent());
                if (align == 1) {
                    width -= offset;
                } else if (align == 2) {
                    width -= offset;
                }
                if (width < 1) {
                    width = 1;
                }
                String[] strList = null;
                strList = elt.getRotateAngle() != 0.0 ? ReportGraphics.tokenizer(text, fm, elt.getHeightOfElement(true), elt.isNoWrap()) : ReportGraphics.tokenizer(text, fm, width, elt.isNoWrap());
                for (int i = 0; i < strList.length; ++i) {
                    if (i != 0 && charH * (float)(i + 1) > h) {
                        return;
                    }
                    x = 0.0f;
                    y = 0.0f;
                    if (elt.getRotateAngle() == 0.0) {
                        x = this.getTextX(elt, strList[i], b, size, this.pixelToPoints(offset));
                        y = this.getTextY(strList.length, this.getY(elt), h, i, charH, descent, elt.getVAlign());
                    } else {
                        y = this.getRotateTextY(elt.getHeightToPoints(), b.getWidthPoint(strList[i], size), elt.getAlign(), elt, this.pixelToPoints(offset), elt.getRotateAngle());
                        x = this.getRotateTextX(strList.length, this.getX(elt), elt.getWidthToPoints(), i, charH, descent, elt.getVAlign(), elt.getRotateAngle());
                    }
                    this.writeText(this.templates[tplIdx], strList[i], x, y, b, size, elt.getFontColor(), elt.getRotateAngle(), elt.getAlign());
                    if (!elt.isUnderline()) continue;
                    float underlineY = y - QbUtil.pixelToPoints(fm.getDescent());
                    float strWidth = b.getWidthPoint(strList[i], size);
                    this.writeTextUnderline(this.templates[tplIdx], x, underlineY, x + strWidth, underlineY, elt.getFontColor());
                }
            }
            catch (NullPointerException e) {
                LOGGER.log(Level.WARNING, "Cannot write text", e);
            }
        } else {
            this.writeBarcode(elt);
        }
    }

    protected void writeBarcode(ReportElement elt) throws IOException, Exception {
        if (elt.getText().equals("")) {
            return;
        }
        try {
            int tplIdx;
            BufferedImage image = BarcodeUtil.createBarCodeImage(elt);
            Image img = Image.getInstance(image, Color.white);
            img.setAbsolutePosition(this.getAbsoluteX(this.getX(elt)), this.getAbsoluteY(this.getY(elt)) - elt.getHeightToPoints());
            img.scaleAbsolute(elt.getWidthToPoints(), elt.getHeightToPoints());
            if (elt.getBorderThickness() != 0) {
                this.writeBorder(this.getX(elt), this.getY(elt), elt.getWidthToPoints(), elt.getHeightToPoints(), this.pixelToPoints(elt.getBorderThickness()), elt.getBorderColor(), this.getBorderStyle(elt));
            }
            if ((tplIdx = this.getContentByteIndex(this.getX(elt))) >= 0 && tplIdx < this.templates.length) {
                this.templates[tplIdx].addImage(img);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "An error ocurred while exporting barcode", ex);
            throw new Exception("An error ocurred while exporting barcode.");
        }
    }

    protected float mapFontSize(int size) {
        return QbUtil.resizeExportFont(size, this.report.isAdjustFont());
    }

    protected float mapFontSize(int size, boolean isAdjustFont) {
        return QbUtil.resizeExportFont(size, isAdjustFont);
    }

    private float getRotateTextY(float h, float widthOfText, short align, ReportElement elt, float offset, double rotation) {
        float newY = this.getY(elt);
        switch (align) {
            case 2: {
                if (rotation < 0.0 && rotation > -180.0 || rotation > 180.0) {
                    newY = newY - widthOfText - offset;
                    break;
                }
                if (rotation > 0.0 && rotation < 180.0 || rotation < -180.0) {
                    newY = newY - h + widthOfText + offset;
                    break;
                }
                newY = newY + h - widthOfText - offset;
                break;
            }
            case 0: {
                if (rotation < 0.0 && rotation > -180.0 || rotation > 180.0) {
                    newY = newY - h + (h - widthOfText) / 2.0f;
                    break;
                }
                if (rotation > 0.0 && rotation < 180.0 || rotation < -180.0) {
                    newY -= (h - widthOfText) / 2.0f;
                    break;
                }
                newY += (h - widthOfText) / 2.0f;
                break;
            }
            default: {
                if (rotation < 0.0 && rotation > -180.0 || rotation > 180.0) {
                    newY -= h;
                    newY += offset;
                    break;
                }
                if (rotation > 0.0 && rotation < 180.0 || rotation < -180.0) {
                    newY -= offset;
                    break;
                }
                newY += offset;
            }
        }
        if (!elt.isNoWrap() || align != 2 && align != 0) {
            if (rotation < 0.0 && newY > this.getY(elt)) {
                newY = this.getY(elt) + elt.getHeightToPoints();
            } else if (rotation > 0.0 && newY < this.getY(elt) - elt.getHeightToPoints()) {
                newY = this.getY(elt);
            }
        }
        return newY;
    }

    private float getRotateTextX(int numberOfLines, float x, float w, int i, float charH, float descent, short valign, double rotation) {
        float r = 0.0f;
        switch (valign) {
            case 1: {
                if (rotation > 0.0 && rotation < 180.0 || rotation < -180.0) {
                    return x + w - (float)(i + 1) * charH + descent;
                }
                if (rotation < 0.0 && rotation > -180.0 || rotation > 180.0) {
                    return x + (float)(i + 1) * charH - 2.0f * descent + 3.0f;
                }
                return x + (float)(i + 1) * charH - 2.0f * descent + 3.0f;
            }
            case 2: {
                if (rotation > 0.0 && rotation < 180.0 || rotation < -180.0) {
                    r = (float)numberOfLines * charH;
                    if (r < 0.0f) {
                        r = 0.0f;
                    }
                    return x + r - (float)(i + 1) * charH + descent;
                }
                if (rotation < 0.0 && rotation > -180.0 || rotation > 180.0) {
                    r = w - (float)numberOfLines * charH;
                    if (r < 0.0f) {
                        r = 0.0f;
                    }
                    return x + r + (float)(i + 1) * charH - 3.0f;
                }
                r = w - (float)numberOfLines * charH;
                if (r < 0.0f) {
                    r = 0.0f;
                }
                return x + r + (float)(i + 1) * charH - 3.0f;
            }
            case 0: {
                if (rotation > 0.0 && rotation < 180.0 || rotation < -180.0) {
                    r = (int)Math.rint((w - (float)numberOfLines * charH) / 2.0f);
                    if (r < 0.0f) {
                        r = 0.0f;
                    }
                    return x + r + (float)numberOfLines * charH - (float)(i + 1) * charH + descent;
                }
                if (rotation < 0.0 && rotation > -180.0 || rotation > 180.0) {
                    r = (int)Math.rint((w - (float)numberOfLines * charH) / 2.0f);
                    if (r < 0.0f) {
                        r = 0.0f;
                    }
                    return x + r + (float)i * charH + descent + 6.0f;
                }
                r = (int)Math.rint((w - (float)numberOfLines * charH) / 2.0f);
                if (r < 0.0f) {
                    r = 0.0f;
                }
                return x + r + (float)(i + 1) * charH - descent;
            }
        }
        return x + (float)(i + 1) * charH - descent;
    }

    private float getTextY(int numberOfLines, float y, float h, int i, float charH, float descent, short valign) {
        float r = 0.0f;
        switch (valign) {
            case 1: {
                return y - (float)(i + 1) * charH + 2.0f * descent - 3.0f;
            }
            case 2: {
                r = h - (float)numberOfLines * charH;
                if (r < 0.0f) {
                    r = 0.0f;
                }
                return y - r - (float)(i + 1) * charH + 3.0f;
            }
            case 0: {
                r = (int)Math.rint((h - (float)numberOfLines * charH) / 2.0f);
                if (r < 0.0f) {
                    r = 0.0f;
                }
                return y - r - (float)(i + 1) * charH + descent;
            }
        }
        return y - (float)(i + 1) * charH + descent;
    }

    private float getTextX(ReportElement elt, String text, BaseFont b, float size, float offset) {
        float x = this.getX(elt);
        float w = elt.getWidthToPoints();
        float widthOfText = b.getWidthPoint(text, size);
        short align = elt.getAlign();
        if (this.hasRtlChars(text)) {
            switch (align) {
                case 2: {
                    return x + w - offset;
                }
                case 0: {
                    return x + w / 2.0f;
                }
            }
            return x + offset;
        }
        switch (align) {
            case 2: {
                if (this.hasRtlChars(text)) {
                    x = x + w - offset;
                    break;
                }
                x = x + w - widthOfText - offset;
                break;
            }
            case 0: {
                x += (w - widthOfText) / 2.0f;
                break;
            }
            default: {
                x += offset;
            }
        }
        if (x < this.getX(elt) && (!elt.isNoWrap() || align != 2 && align != 0)) {
            x = this.getX(elt);
        }
        return x;
    }

    protected void writeFilledRectangle(float llx, float lly, float urx, float ury, Color color) {
        int tplIdx = this.getContentByteIndex(llx);
        if (tplIdx < 0 || tplIdx >= this.templates.length) {
            return;
        }
        Rectangle rect = new Rectangle(this.getAbsoluteX(llx), this.getAbsoluteY(lly), this.getAbsoluteX(llx) + Math.abs(urx - llx), this.getAbsoluteY(ury));
        rect.setBorder(0);
        rect.setBackgroundColor(color);
        this.templates[tplIdx].rectangle(rect);
    }

    protected void writeRectangle(int contentByteIndex, float llx, float lly, float urx, float ury, float borderWidth, Color borderColor, int borderStyle) {
        if (borderColor == null) {
            return;
        }
        if (contentByteIndex < 0 || contentByteIndex >= this.templates.length) {
            return;
        }
        Rectangle rect = new Rectangle(this.getAbsoluteX(llx, contentByteIndex), this.getAbsoluteY(lly), this.getAbsoluteX(llx, contentByteIndex) + Math.abs(urx - llx), this.getAbsoluteY(ury));
        rect.setBorder(borderStyle);
        rect.setBorderWidth(borderWidth);
        rect.setBorderColor(borderColor);
        this.templates[contentByteIndex].rectangle(rect);
    }

    private String getAFMBaseName(String afm) {
        if (afm == null) {
            return null;
        }
        int index = afm.lastIndexOf(46);
        if (index > -1) {
            return afm.substring(0, index);
        }
        return afm;
    }

    private boolean isTrueTypeFontFile(String name) {
        return name.toLowerCase().endsWith(".ttf") || name.toLowerCase().indexOf(".ttc,") > 0;
    }

    private String getTrueTypeFontName(String name) {
        if (name.toLowerCase().endsWith(".ttc")) {
            return name;
        }
        int index = name.toLowerCase().indexOf(".ttc,");
        if (index > 0) {
            return name.substring(0, index + 4);
        }
        return name;
    }

    public BaseFont mapToPDFFont(java.awt.Font font, boolean containsUnicode) throws IOException, Exception {
        String enc;
        BaseFont cache = (BaseFont)this.baseFontHash.get(font, containsUnicode);
        if (cache != null) {
            return cache;
        }
        String key = font.getName();
        key = font.getStyle() == 1 ? key + " BOLD" : (font.getStyle() == 2 ? key + " ITALIC" : (font.getStyle() == 3 ? key + " BOLDITALIC" : key + " PLAIN"));
        String string = enc = containsUnicode ? "Identity-H" : "Cp1252";
        if (this.fontMapping != null && this.fontMapping.containsKey(key)) {
            String fontValue = this.fontMapping.get(key);
            StringTokenizer tokens = new StringTokenizer(fontValue, "&");
            Vector<String> vec = new Vector<String>();
            while (tokens.hasMoreTokens()) {
                vec.addElement(tokens.nextToken());
            }
            String ttf = null;
            boolean embed = true;
            if (vec.size() == 1) {
                ttf = (String)vec.elementAt(0);
            } else if (vec.size() == 3) {
                ttf = (String)vec.elementAt(0);
                String encStr = (String)vec.elementAt(1);
                String embedStr = (String)vec.elementAt(2);
                if (encStr.startsWith("ENC=") && !(encStr = encStr.substring(4)).equals("")) {
                    enc = encStr;
                }
                if (embedStr.startsWith("EMBED=") && (embedStr = embedStr.substring(6)).equalsIgnoreCase("FALSE")) {
                    embed = false;
                }
            }
            if (ttf != null) {
                BaseFont bf;
                if (this.isTrueTypeFontFile(ttf)) {
                    if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
                        if (new FileInfo(this.getTrueTypeFontName(ttf)).exists()) {
                            bf = BaseFont.createFont(ttf, enc, embed);
                            this.baseFontHash.put(font, bf, containsUnicode);
                            return bf;
                        }
                    } else {
                        String fileName = this.getTrueTypeFontName(ttf);
                        if (new FileInfo(fileName).exists()) {
                            DataInputStream din = new ReadDataFile().getInputStream(null, fileName);
                            byte[] barray = new byte[din.available()];
                            din.read(barray);
                            din.close();
                            BaseFont bf2 = BaseFont.createFont(ttf, enc, embed, true, barray, null);
                            this.baseFontHash.put(font, bf2, containsUnicode);
                            return bf2;
                        }
                    }
                } else {
                    if (ttf.toLowerCase().endsWith(".afm")) {
                        DataInputStream din = new ReadDataFile().getInputStream(null, ttf);
                        byte[] barray = new byte[din.available()];
                        din.read(barray);
                        din.close();
                        byte[] parray = null;
                        if (new FileInfo(this.getAFMBaseName(ttf) + ".pfb").exists()) {
                            String pfbName = this.getAFMBaseName(ttf) + ".pfb";
                            DataInputStream pin = new ReadDataFile().getInputStream(null, pfbName);
                            parray = new byte[pin.available()];
                            pin.read(parray);
                            pin.close();
                        }
                        BaseFont bf3 = BaseFont.createFont(ttf, enc, embed, true, barray, parray);
                        this.baseFontHash.put(font, bf3, containsUnicode);
                        return bf3;
                    }
                    bf = BaseFont.createFont(ttf, enc, false);
                    this.baseFontHash.put(font, bf, containsUnicode);
                    return bf;
                }
            }
        }
        BaseFont bfont = this.mapToEnglishFont(font);
        if (this.language.equalsIgnoreCase("ko")) {
            bfont = this.mapToKoreanFont(font);
        } else if (this.language.equalsIgnoreCase("ja")) {
            bfont = this.mapToJapaneseFont(font);
        } else if (this.language.startsWith("zh")) {
            bfont = this.mapToChineseFont(font);
        }
        this.baseFontHash.put(font, bfont, containsUnicode);
        return bfont;
    }

    private BaseFont mapToEnglishFont(java.awt.Font font) throws IOException, Exception {
        BaseFont cache = this.englishFontHash.get(font);
        if (cache != null) {
            return cache;
        }
        if (font.getName().toLowerCase().startsWith("dialog") || font.getName().toLowerCase().startsWith("sansserif")) {
            if (font.getStyle() == 0) {
                this.fontName = "Helvetica";
            } else if (font.getStyle() == 1) {
                this.fontName = "Helvetica-Bold";
            } else if (font.getStyle() == 2) {
                this.fontName = "Helvetica-Oblique";
            } else if (font.getStyle() == 3) {
                this.fontName = "Helvetica-BoldOblique";
            }
            this.encoding = "Cp1252";
        } else if (font.getName().toLowerCase().startsWith("serif")) {
            if (font.getStyle() == 0) {
                this.fontName = "Times-Roman";
            } else if (font.getStyle() == 1) {
                this.fontName = "Times-Bold";
            } else if (font.getStyle() == 2) {
                this.fontName = "Times-Italic";
            } else if (font.getStyle() == 3) {
                this.fontName = "Times-BoldItalic";
            }
            this.encoding = "Cp1252";
        } else if (font.getName().toLowerCase().startsWith("monospaced") || font.getName().toLowerCase().startsWith("dialoginput")) {
            if (font.getStyle() == 0) {
                this.fontName = "Courier";
            } else if (font.getStyle() == 1) {
                this.fontName = "Courier-Bold";
            } else if (font.getStyle() == 2) {
                this.fontName = "Courier-Oblique";
            } else if (font.getStyle() == 3) {
                this.fontName = "Courier-BoldOblique";
            }
            this.encoding = "Cp1252";
        } else if (font.getName().toLowerCase().startsWith("nsimsun")) {
            this.fontName = "STSong-Light";
            this.encoding = "UniGB-UCS2-H";
        } else if (font.getName().toLowerCase().startsWith("simsun")) {
            this.fontName = "MSung-Light";
            this.encoding = "UniCNS-UCS2-H";
        } else if (font.getName().toLowerCase().startsWith("simhei")) {
            this.fontName = "MHei-Medium";
            this.encoding = "UniCNS-UCS2-H";
        } else if (font.getName().toLowerCase().startsWith("ms gothic") || font.getName().toLowerCase().startsWith("ms pgothic") || font.getName().toLowerCase().startsWith("ms ui gothic")) {
            this.fontName = "HeiseiKakuGo-W5";
            this.encoding = "UniJIS-UCS2-H";
        } else if (font.getName().toLowerCase().startsWith("ms mincho") || font.getName().toLowerCase().startsWith("ms pmincho")) {
            this.fontName = "HeiseiMin-W3";
            this.encoding = "UniJIS-UCS2-HW-H";
        } else if (font.getName().toLowerCase().startsWith("batang") || font.getName().toLowerCase().startsWith("dotum") || font.getName().toLowerCase().startsWith("gulim") || font.getName().toLowerCase().startsWith("gungsuh")) {
            this.fontName = "HYGoThic-Medium";
            this.encoding = "UniKS-UCS2-H";
        } else if (font.getName().toLowerCase().startsWith("dotumche") || font.getName().toLowerCase().startsWith("batangche") || font.getName().toLowerCase().startsWith("gulimche") || font.getName().toLowerCase().startsWith("gungsuhche")) {
            this.fontName = "HYSMyeongJo-Medium";
            this.encoding = "UniKS-UCS2-H";
        } else {
            this.fontName = "Times-Roman";
            if (font.getStyle() == 1) {
                this.fontName = "Times-Bold";
            } else if (font.getStyle() == 2) {
                this.fontName = "Times-Italic";
            } else if (font.getStyle() == 3) {
                this.fontName = "Times-BoldItalic";
            }
            this.encoding = "Cp1252";
        }
        BaseFont bfont = BaseFont.createFont(this.fontName, this.encoding, false);
        this.englishFontHash.put(font, bfont);
        return bfont;
    }

    private BaseFont mapToKoreanFont(java.awt.Font font) throws IOException, Exception {
        BaseFont cache = this.koreanFontHash.get(font);
        if (cache != null) {
            return cache;
        }
        if (font.getStyle() == 0) {
            this.fontName = "HYGoThic-Medium";
        } else if (font.getStyle() == 1) {
            this.fontName = "HYGoThic-Medium,Bold";
        } else if (font.getStyle() == 2) {
            this.fontName = "HYGoThic-Medium,Italic";
        } else if (font.getStyle() == 3) {
            this.fontName = "HYGoThic-Medium,BoldItalic";
        }
        this.encoding = "UniKS-UCS2-H";
        BaseFont bfont = BaseFont.createFont(this.fontName, this.encoding, false);
        this.koreanFontHash.put(font, bfont);
        return bfont;
    }

    private BaseFont mapToJapaneseFont(java.awt.Font font) throws IOException, Exception {
        BaseFont cache = this.japanFontHash.get(font);
        if (cache != null) {
            return cache;
        }
        if (font.getName().toLowerCase().startsWith("ms gothic") || font.getName().toLowerCase().startsWith("ms pgothic") || font.getName().toLowerCase().startsWith("ms ui gothic")) {
            if (font.getStyle() == 0) {
                this.fontName = "HeiseiKakuGo-W5";
            } else if (font.getStyle() == 1) {
                this.fontName = "HeiseiKakuGo-W5,Bold";
            } else if (font.getStyle() == 2) {
                this.fontName = "HeiseiKakuGo-W5,Italic";
            } else if (font.getStyle() == 3) {
                this.fontName = "HeiseiKakuGo-W5,BoldItalic";
            }
            this.encoding = "UniJIS-UCS2-H";
        } else if (font.getName().toLowerCase().startsWith("ms mincho") || font.getName().toLowerCase().startsWith("ms pmincho")) {
            if (font.getStyle() == 0) {
                this.fontName = "HeiseiMin-W3";
            } else if (font.getStyle() == 1) {
                this.fontName = "HeiseiMin-W3,Bold";
            } else if (font.getStyle() == 2) {
                this.fontName = "HeiseiMin-W3,Italic";
            } else if (font.getStyle() == 3) {
                this.fontName = "HeiseiMin-W3,BoldItalic";
            }
            this.encoding = "UniJIS-UCS2-HW-H";
        } else {
            if (font.getStyle() == 0) {
                this.fontName = "HeiseiKakuGo-W5";
            } else if (font.getStyle() == 1) {
                this.fontName = "HeiseiKakuGo-W5,Bold";
            } else if (font.getStyle() == 2) {
                this.fontName = "HeiseiKakuGo-W5,Italic";
            } else if (font.getStyle() == 3) {
                this.fontName = "HeiseiKakuGo-W5,BoldItalic";
            }
            this.encoding = "UniJIS-UCS2-H";
        }
        BaseFont bfont = BaseFont.createFont(this.fontName, this.encoding, false);
        this.japanFontHash.put(font, bfont);
        return bfont;
    }

    private BaseFont mapToChineseFont(java.awt.Font font) throws IOException, Exception {
        BaseFont cache = this.chineseFontHash.get(font);
        if (cache != null) {
            return cache;
        }
        if (font.getStyle() == 0) {
            this.fontName = "MHei-Medium";
        } else if (font.getStyle() == 1) {
            this.fontName = "MHei-Medium,Bold";
        } else if (font.getStyle() == 2) {
            this.fontName = "MHei-Medium,Italic";
        } else if (font.getStyle() == 3) {
            this.fontName = "MHei-Medium,BoldItalic";
        }
        this.encoding = "UniCNS-UCS2-H";
        BaseFont bfont = BaseFont.createFont(this.fontName, this.encoding, false);
        this.chineseFontHash.put(font, bfont);
        return bfont;
    }

    private String getBorderStyle(ReportElement reportelement) {
        String s = "solid";
        if (reportelement instanceof ReportLine) {
            s = ((ReportLine)reportelement).getLineStyle() == 1 ? "solid" : (((ReportLine)reportelement).getLineStyle() == 2 ? "double" : (((ReportLine)reportelement).getLineStyle() == 3 ? "dashed" : "solid"));
        } else if (reportelement instanceof ReportGrid) {
            s = ((ReportGrid)reportelement).getGridStyle() == 1 ? "solid" : (((ReportGrid)reportelement).getGridStyle() == 2 ? "double" : (((ReportGrid)reportelement).getGridStyle() == 3 ? "dashed" : "solid"));
        }
        return s;
    }

    protected boolean hasNoData(ReportSection section) {
        return section == null || section.hasNoDrawableData();
    }

    protected float toPoints(double inch) {
        return (float)Math.rint(QbUtil.toPoints(inch));
    }

    protected float pixelToPoints(int pixel) {
        return QbUtil.pixelToPoints(pixel);
    }

    private double pointsToInch(float points) {
        return QbUtil.pointsToInch(points);
    }

    private void writeMasterSection(ReportSection masterSection, ReportTable table) throws Exception, IOException, MalformedURLException {
        ReportCell[] cells;
        if (this.hasNoData(masterSection)) {
            return;
        }
        if (masterSection.getBgColor() != null && !this.checkFitGroupOnPage) {
            this.writeFilledRectangle(this.getX(masterSection), this.getY(masterSection) - masterSection.getHeightToPoints(), this.getX(masterSection) + masterSection.getWidthToPoints(), this.getY(masterSection), masterSection.getBgColor());
        }
        if (masterSection.getBorderThickness() > 0 && !this.checkFitGroupOnPage) {
            this.writeBorder(this.getX(masterSection), this.getY(masterSection), masterSection.getWidthToPoints(), masterSection.getHeightToPoints(), this.pixelToPoints(masterSection.getBorderThickness()), masterSection.getBorderColor(), this.getBorderStyle(masterSection));
        }
        float old_elementXPos = this.elementXPos;
        float old_elementYPos = this.elementYPos;
        this.elementXPos = this.getX(masterSection);
        this.elementYPos += masterSection.getYToPoints();
        for (ReportCell cell : cells = masterSection.sortCell(2, true)) {
            if (this.skipCell(cell) || !(cell.getX() + cell.getWidth() <= masterSection.getWidth()) || !(cell.getY() + cell.getHeight() <= masterSection.getHeight())) continue;
            ReportCell elt = table.formatCell(cell, this.getCurrentPageNumber(), this.currentSection, this.getTotalPageNumber(), this.totalSections, this.report);
            this.writeTableDataElement(elt, table, masterSection);
        }
        this.elementXPos = old_elementXPos;
        this.elementYPos = old_elementYPos;
    }

    protected float writeRemainingSubReports(Vector<PDFSubReport> remainingSubReports, ReportSection section) throws Exception {
        return this.writeRemainingSubReports(remainingSubReports, null, null, section, null, null, null);
    }

    protected float writeRemainingSubReports(Vector<PDFSubReport> remainingSubReports, Vector<ReportElement> oneTime, Vector<Float> oneTimeY, ReportSection section, ReportTable tbl) throws Exception {
        return this.writeRemainingSubReports(remainingSubReports, oneTime, oneTimeY, section, tbl, null, null);
    }

    protected float writeRemainingSubReports(Vector<PDFSubReport> remainingSubReports, Vector<ReportElement> oneTime, Vector<Float> oneTimeY, ReportSection section, ReportTable tbl, ReportElement[] relts, float[] shifts) throws Exception {
        float bottomYOfSection = 0.0f;
        while (remainingSubReports != null && remainingSubReports.size() > 0 || oneTime != null && oneTime.size() > 0) {
            this.elementYPos += 1.0f;
            this.pageBreak(section);
            bottomYOfSection = this.writeVisibleOneTimeElements(oneTime, oneTimeY, remainingSubReports, tbl, relts, shifts);
        }
        return bottomYOfSection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float writeOnePageOfSubReports(Vector<PDFSubReport> subReports) {
        float bottomY = 0.0f;
        for (int i = subReports.size() - 1; i >= 0; --i) {
            PDFSubReport pdfSub = subReports.elementAt(i);
            if (pdfSub.currentPageNumber > this.currentPageNumber) {
                try {
                    this.pageBreak2(null);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "pageBreak failed", ex);
                }
            }
            pdfSub.elementYPos = this.elementYPos;
            if (!this.checkFitGroupOnPage) {
                for (int j = 0; j < pdfSub.templates.length; ++j) {
                    pdfSub.templates[j] = this.templates[pdfSub.templateIndex + j];
                }
            }
            Object object = pdfSub.LOCK;
            synchronized (object) {
                pdfSub.LOCK.notify();
                try {
                    pdfSub.LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!pdfSub.isFinished()) continue;
            if (pdfSub.elementYPos > bottomY) {
                bottomY = pdfSub.elementYPos;
            }
            subReports.removeElementAt(i);
        }
        return bottomY;
    }

    protected float writeVisibleOneTimeElements(Vector<ReportElement> oneTime, Vector<Float> oneTimeY, Vector<PDFSubReport> remainingSubReports, ReportTable tbl) throws Exception {
        return this.writeVisibleOneTimeElements(oneTime, oneTimeY, remainingSubReports, tbl, null, null);
    }

    protected float writeVisibleOneTimeElements(Vector<ReportElement> oneTime, Vector<Float> oneTimeY, Vector<PDFSubReport> remainingSubReports, ReportTable tbl, ReportElement[] relts, float[] shifts) throws Exception {
        float bottomYOfSection = 0.0f;
        if (remainingSubReports != null && remainingSubReports.size() > 0) {
            bottomYOfSection = this.writeOnePageOfSubReports(remainingSubReports);
        }
        if (oneTime == null) {
            return bottomYOfSection;
        }
        float elementXPos_old = this.elementXPos;
        for (int i = 0; relts != null && i < relts.length; ++i) {
            ReportCell cell;
            int j = 0;
            for (j = oneTime.size() - 1; j >= 0 && !oneTime.elementAt(j).getID().equals(relts[i].getID()); --j) {
            }
            if (j == -1) continue;
            this.elementXPos = elementXPos_old;
            for (int l = 0; l < i && l < shifts.length; ++l) {
                if (!(relts[l].getY() <= relts[i].getY() && relts[l].getY() + relts[l].getHeight() > relts[i].getY()) && (!(relts[l].getY() >= relts[i].getY()) || !(relts[l].getY() < relts[i].getY() + relts[i].getHeight()))) continue;
                this.incElementXPos(shifts[l]);
            }
            if (!(relts[i] instanceof SubReportObject) && shifts.length > i) {
                this.incElementXPos(shifts[i]);
            }
            if (!(cell = tbl.formatCell((ReportCell)oneTime.elementAt(j), this.getCurrentPageNumber(), 1, this.getTotalPageNumber(), 1, this.report)).isVisible()) {
                oneTime.removeElementAt(j);
                oneTimeY.removeElementAt(j);
                return bottomYOfSection;
            }
            float yPos = oneTimeY.elementAt(j).floatValue();
            if (this.pageHeight - this.elementYPos >= yPos + cell.getHeightToPoints()) {
                double oldY = cell.getY();
                if (this.skipCell(cell)) continue;
                cell.setY(this.pointsToInch(yPos));
                if (cell instanceof SubReportObject || cell instanceof ReportRTFObject) {
                    if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage || cell.isResizeToFitContent()) {
                        PDFSubReport pdfSub = null;
                        if (cell instanceof SubReportObject) {
                            pdfSub = this.writeSubReport((SubReportObject)cell, tbl);
                            if (shifts.length > i) {
                                this.incElementXPos(shifts[i]);
                            }
                        } else {
                            pdfSub = this.writeRTFObject((ReportRTFObject)cell, tbl);
                        }
                        if (pdfSub != null && pdfSub.isFinished()) {
                            if (pdfSub.elementYPos > bottomYOfSection && cell.isResizeToFitContent()) {
                                bottomYOfSection = pdfSub.elementYPos;
                            }
                        } else if (pdfSub != null && remainingSubReports != null) {
                            remainingSubReports.insertElementAt(pdfSub, 0);
                        }
                    }
                } else if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage || this.report.isTocEnabled() && !this.report.getTableOfContentsObject().isUseGroups() && cell.getScript() != null && cell.getScript().toUpperCase().indexOf("BOOKMARK") >= 0) {
                    this.writeTableDataElement(cell, tbl, tbl);
                }
                cell.setY(oldY);
                if (bottomYOfSection < this.elementYPos + yPos + cell.getHeightToPoints()) {
                    bottomYOfSection = this.elementYPos + yPos + cell.getHeightToPoints();
                }
                oneTime.removeElementAt(j);
                oneTimeY.removeElementAt(j);
                continue;
            }
            if ((yPos -= this.pageHeight - this.elementYPos) < 0.0f) {
                oneTimeY.setElementAt(Float.valueOf(0.0f), j);
                continue;
            }
            oneTimeY.setElementAt(Float.valueOf(yPos), j);
        }
        return bottomYOfSection;
    }

    private String doDynamicReportExport(byte[] barray, String fileName, String servletName) throws Exception {
        URLConnection servletConnection;
        String servletDirectory = this.report.getServletDirectory();
        if (servletDirectory != null) {
            if (!(servletDirectory = servletDirectory.replace('\\', '/')).startsWith("/")) {
                servletDirectory = "/" + servletDirectory;
            }
            if (!servletDirectory.endsWith("/") && !servletDirectory.endsWith(".")) {
                servletDirectory = servletDirectory + "/";
            }
        } else {
            servletDirectory = "/servlet/";
        }
        if (this.debugMode) {
            System.out.println("Connecting to Servlet...");
        }
        if (this.report.isHttpsDynamicExport()) {
            String reportURL = "https://" + this.report.getHttpsServerName() + ":" + this.report.getHttpsServletRunnerPort() + servletDirectory + servletName;
            servletConnection = HttpsIO.openHttpsConnection(new URL(reportURL));
        } else {
            String reportURL = this.report.protocol + this.report.serverName + ":" + this.report.servletRunnerPort + servletDirectory + servletName;
            URL drilldownServlet = new URL(reportURL);
            servletConnection = drilldownServlet.openConnection();
        }
        if (this.debugMode) {
            System.out.println("Connected");
        }
        servletConnection.setDoInput(true);
        servletConnection.setDoOutput(true);
        servletConnection.setUseCaches(false);
        servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
        if (this.debugMode) {
            System.out.println("Sending Image to servlet....");
        }
        ObjectOutputStream outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
        IOUtil.writeString(outputToServlet, fileName);
        outputToServlet.writeInt(barray.length);
        outputToServlet.write(barray);
        outputToServlet.flush();
        outputToServlet.close();
        if (this.debugMode) {
            System.out.println("Sent");
        }
        BufferedReader inFromServlet = new BufferedReader(new InputStreamReader(servletConnection.getInputStream()));
        String key = inFromServlet.readLine();
        if (this.debugMode) {
            System.out.println("KEY = " + key);
        }
        inFromServlet.close();
        if (this.debugMode) {
            System.out.println("Close");
        }
        return key;
    }

    private void drilldownDynamicExport(Report report) throws Exception {
        if (report == null) {
            return;
        }
        if (report.currentNode != null) {
            for (int i = 0; i < report.currentNode.getChildCount(); ++i) {
                DrillDownNode node = report.currentNode.getChildAt(i);
                this.drilldownDynamicExport(node);
                LoadReport lr = new LoadReport();
                lr.setBackupDataUsed(true);
                lr.setRelativeDomainPath(node.getDomainPath());
                Report r = null;
                try {
                    lr.setSubFilesTable(report.getSubFilesTable());
                    byte[] bytes = report.getSubFilesTable().get(ServerMessage.getPath(node.getFileName()));
                    r = node.getByteArray() != null ? lr.loadReportFromByteArray(node.getByteArray()) : (bytes != null ? lr.loadReportFromByteArray(bytes) : lr.loadReportFromFile(node.getFileName()));
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to load report", ex);
                }
                if (r == null) continue;
                for (int j = 0; j < node.getChildCount(); ++j) {
                    r.currentNode.getChildAt(j).setFileName(node.getChildAt(j).getFileName());
                }
                this.drilldownDynamicExport(r);
            }
        }
        if (report.subReports != null && report.subReports.size() > 0) {
            Report[] subReport;
            for (Report element : subReport = report.getSubReportArray(true)) {
                this.drilldownDynamicExport(element);
            }
        }
    }

    private void drilldownDynamicExport(DrillDownNode node) throws Exception {
        if (node.getByteArray() == null) {
            if (this.report.getSubFilesTable().containsKey(node.getFileName())) {
                node.setByteArray(this.report.getSubFilesTable().get(node.getFileName()));
            } else {
                node.setByteArray(node.getNotPackedByteArray());
            }
        }
        if (node.getByteArray() != null) {
            FileInMemTable subFilesTable = this.report.getSubFilesTable();
            String currentNodeFileName = this.report.currentNode.getFileName(subFilesTable);
            if (this.report.rootNode == null || this.report.rootNode.getFileName(subFilesTable).equals(currentNodeFileName) || subFilesTable != null && subFilesTable.getTopName() != null && subFilesTable.getTopName().equals(currentNodeFileName)) {
                this.doDynamicReportExport(node.getByteArray(), node.getFileName(this.report.getSubFilesTable()), "DrillDownReportServlet");
            }
            if (this.report.getDrillDownReportHashtable() != null && (this.report.rootNode == null || this.report.rootNode.getFileName(this.report.getSubFilesTable()).equals(currentNodeFileName))) {
                this.report.getDrillDownReportHashtable().put(node.getFileName(), node.getByteArray());
            }
            this.doDynamicReportExport(node.getByteArray(), node.getFileName(), "ParamReportGeneratorServlet");
            this.doDynamicReportExport(node.getByteArray(), node.getFileName(), "UnmappedParameterServlet");
            this.ddBytesSentToServlet = true;
        }
    }

    protected Graphics getOffScreenGraphics() {
        if (this.offScreenGraphics == null) {
            this.offScreenGraphics = IOUtil.getOffScreenGraphics();
        }
        return this.offScreenGraphics;
    }

    private FontMetrics getFontMetrics(java.awt.Font f) {
        FontMetrics fm = this.fontMetricsTable.get(f);
        if (fm != null) {
            return fm;
        }
        fm = this.offScreenGraphics.getFontMetrics(f);
        this.fontMetricsTable.put(f, fm);
        return fm;
    }

    private boolean incElementXPos(float f) {
        this.elementXPos += f;
        return true;
    }

    private PdfOutline writeBookmark(String s, PdfOutline outline, boolean bookmarkOnNewPage) throws Exception {
        float llx = this.elementXPos;
        float ury = bookmarkOnNewPage ? 0.0f : this.pageHeight - this.elementYPos;
        PdfDestination dest = new PdfDestination(0, this.getAbsoluteX(llx), this.getAbsoluteY(ury), 0.0f);
        this.templates[0].localDestination(s, dest);
        PdfOutline newOutline = new PdfOutline(outline, dest, s);
        this.templates[0].addOutline(newOutline);
        return newOutline;
    }

    private boolean hasRtlChars(String text) {
        return RTL_CHARS_PATTERN.matcher(text).find();
    }

    public void startToGetData(ReportTable table) throws Exception {
    }

    private static class BaseFontHash {
        Hashtable<Object, Object> uHash = new Hashtable(10);
        Hashtable<Object, Object> hash = new Hashtable(10);

        private BaseFontHash() {
        }

        public Object put(Object key, Object value, boolean unicode) {
            if (unicode) {
                return this.uHash.put(key, value);
            }
            return this.hash.put(key, value);
        }

        public Object get(Object key, boolean unicode) {
            if (unicode) {
                return this.uHash.get(key);
            }
            return this.hash.get(key);
        }
    }
}

