/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.output.DocumentException;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.Aggregation;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.ColDataBuffer;
import quadbase.reportdesigner.report.CrossTabTable;
import quadbase.reportdesigner.report.PDFReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.report.TransformQuery;
import quadbase.reportdesigner.util.ColInfo;

public class PDFReportCrossTab
extends PDFReport {
    private static final Logger LOGGER = Logger.getLogger(PDFReportCrossTab.class.getName());
    Vector footerAggCol;
    Vector footerResCol;
    private Vector[] preAggCol;
    private Vector[] resultCol;
    private ColDataBuffer colDataBuffer;
    private ReportTable stbl = null;
    private int recNo = 0;
    private int numBreakCol = 0;
    private int nRow = 0;
    Object[] oldvalue = null;
    Object[] newvalue = null;
    private short aggr = (short)-1;
    private boolean firstValue = true;
    private int sectionID = 0;

    public PDFReportCrossTab(Report report) throws IOException, DocumentException, Exception {
        super(report);
    }

    @Override
    public void exportPDF(OutputStream out, String fileName, String userPass, String ownerPass, int permissions, String javaScript) throws Exception {
        this.reportUI = new ReportUI(this.report, IOUtil.getOffScreenGraphics(), false);
        try {
            this.reportUI.preCalcTotalSections();
            this.totalSections = this.reportUI.getTotalSections();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Can't get total section number", e);
        }
        this.reportGraphics = this.reportUI.getReportGraphics();
        this.pageFooterHeight = this.hasNoData(this.report.getPageFooter()) ? 0.0f : this.resizeSection(this.reportGraphics, this.report.getPageFooter(), this.report.getReportTables().elementAt(this.report.getReportTables().size() - 1)).getHeightToPoints();
        this.pageHeight = this.report.getPageHeightToPoints() - this.topMargin - this.bottomMargin - this.pageFooterHeight;
        this.checkTotalPageNumber = false;
        this.exportPDF(out, userPass, ownerPass, permissions, javaScript);
        out.flush();
        out.close();
        this.colDataBuffer.join();
    }

    @Override
    void formatTable() throws Exception {
    }

    @Override
    protected void writeReportTable(ReportTable tbl) throws Exception {
        this.writeSection(tbl.getHeader(), tbl);
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.addRepeatSection(tbl.getHeader(), tbl);
        }
        this.footerAggCol = new Vector();
        this.footerResCol = new Vector();
        Aggregation.getAggrColumn(tbl.getFooter(), tbl, this.footerAggCol, this.footerResCol);
        Aggregation.getAggrColumn(this.report.getReportFooter(), tbl, this.footerAggCol, this.footerResCol);
        this.writeCrossTabTable((CrossTabTable)tbl);
        this.writeSection(tbl.getFooter(), tbl, this.footerAggCol, this.footerResCol);
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.removeRepeatSection();
        }
    }

    private void writeCrossTabTable(CrossTabTable tbl) throws Exception {
        if (tbl == null || tbl.mData == null) {
            return;
        }
        Report report = tbl.mData.report;
        this.numBreakCol = report.breakColInfo.length;
        int nCol = report.colInfo.length;
        ColInfo[] colInfo = report.colInfo;
        this.aggr = (short)-1;
        for (int i = 0; i < nCol; ++i) {
            if (colInfo[i] == null || !colInfo[i].isAggregatedColumn()) continue;
            this.aggr = colInfo[i].getAggregation();
        }
        if (this.aggr == -1) {
            throw new Exception("No Column Break Value Aggregation is given");
        }
        this.nRow = 0;
        int startIndex = 0;
        int displayRow = Report.getInputDataBlockSize();
        if (report.dbInfo != null) {
            DBInfoBasic dbinfo = report.dbInfo;
            String sqlstr = dbinfo.getQuery();
            sqlstr = TransformQuery.transformCrossTab(sqlstr, report.colInfo);
            DBInfoBasic tempdbInfo = null;
            tempdbInfo = dbinfo.isUseJNDIDataSource() ? new DBInfoBasic(dbinfo.getJNDIName(), sqlstr, dbinfo.getEnvProperties()) : new DBInfoBasic(dbinfo.getConnection(), dbinfo.getURLString(), dbinfo.getDriverName(), dbinfo.getUserID(), dbinfo.getPassword(), sqlstr);
            this.colDataBuffer = new ColDataBuffer(tempdbInfo, startIndex, displayRow, dbinfo.getQuery());
        } else {
            this.colDataBuffer = new ColDataBuffer(report.originalIResultSet, startIndex, displayRow);
        }
        this.colDataBuffer.start();
        this.stbl = this.createTable(tbl);
        int loop = 0;
        this.preAggCol = new Vector[tbl.dataHeader.length];
        this.resultCol = new Vector[tbl.dataHeader.length];
        for (int i = 0; i < tbl.dataHeader.length; ++i) {
            this.writeSection(tbl.dataHeader[i], this.stbl);
            if (tbl.dataHeader[i].isRepeatOnEveryPage()) {
                this.addRepeatSection(tbl.dataHeader[i], this.stbl);
            }
            this.preAggCol[i] = new Vector();
            this.resultCol[i] = new Vector();
            Aggregation.getAggrColumn(tbl.dataFooter[i], this.stbl, this.preAggCol[i], this.resultCol[i]);
            ++loop;
        }
        this.oldvalue = new Object[this.numBreakCol - 1];
        this.newvalue = new Object[this.numBreakCol - 1];
        boolean init = false;
        this.recNo = 0;
        int group = 0;
        while (true) {
            int cMap;
            int i;
            if (!this.colDataBuffer.isDataReady(startIndex)) {
                Thread.sleep(100L);
                continue;
            }
            ColData[] colData = this.colDataBuffer.getData(startIndex);
            this.colDataBuffer.clearDataBuffer(startIndex);
            this.nRow = colData[0].getSize();
            startIndex = this.nRow + startIndex;
            this.recNo = 0;
            if (!init) {
                for (i = 0; i < this.numBreakCol - 1; ++i) {
                    cMap = report.breakColInfo[i].getMapping();
                    this.oldvalue[i] = colData[cMap].getData(0);
                    this.newvalue[i] = colData[cMap].getData(0);
                }
                this.addRow(report, colData, this.stbl);
                init = true;
                this.firstValue = false;
            }
            if (this.recNo > this.nRow) break;
            while (this.recNo < this.nRow) {
                for (i = 0; i < this.numBreakCol - 1; ++i) {
                    cMap = report.breakColInfo[i].getMapping();
                    this.newvalue[i] = colData[cMap].getData(this.recNo);
                }
                for (i = 0; i < this.numBreakCol - 1; ++i) {
                    int k;
                    cMap = report.breakColInfo[i].getMapping();
                    if (this.noSwap(this.oldvalue, this.newvalue)) continue;
                    if (this.oldvalue[i] == null && this.newvalue[i] == null || this.oldvalue[i] != null && this.newvalue[i] != null && this.oldvalue[i].equals(this.newvalue[i])) {
                        colData[cMap].setData(this.recNo, "");
                        continue;
                    }
                    this.writeCells(this.stbl);
                    for (k = tbl.dataFooter.length - 1; i <= k; --k) {
                        this.writeSection(tbl.dataFooter[k], this.stbl, this.preAggCol[--loop], this.resultCol[loop]);
                        if (tbl.dataHeader[k].isRepeatOnEveryPage()) {
                            this.removeRepeatSection();
                        }
                        this.resultCol[loop] = this.resetResultCol(this.preAggCol[loop]);
                    }
                    this.stbl = this.createTable(tbl);
                    this.sectionID = group > i ? 0 : ++this.sectionID;
                    group = i;
                    for (k = i; k < tbl.dataHeader.length; ++k) {
                        this.writeSection(tbl.dataHeader[k], this.stbl, this.preAggCol[loop], this.resultCol[loop]);
                        if (tbl.dataHeader[k].isRepeatOnEveryPage()) {
                            this.addRepeatSection(tbl.dataHeader[k], this.stbl);
                        }
                        ++loop;
                    }
                }
                for (i = 0; i < this.numBreakCol - 1; ++i) {
                    this.oldvalue[i] = this.newvalue[i];
                }
                this.addRow(report, colData, this.stbl);
            }
            if (displayRow != this.nRow) break;
        }
        this.writeCells(this.stbl);
        for (int k = loop - 1; k >= 0; --k) {
            this.writeSection(tbl.dataFooter[k], this.stbl, this.preAggCol[k], this.resultCol[k]);
            if (!tbl.dataHeader[k].isRepeatOnEveryPage()) continue;
            this.removeRepeatSection();
        }
        this.preAggCol = null;
        this.resultCol = null;
    }

    @Override
    protected boolean isFirstValue() {
        return this.firstValue;
    }

    @Override
    protected int getCurrentSectionID() {
        return this.sectionID;
    }

    private void addRow(Report report, ColData[] colData, ReportTable stbl) throws Exception {
        boolean inRow = true;
        boolean firstLine = true;
        Vector<Integer> hasData = new Vector<Integer>();
        Object[] fieldName = null;
        int columnBreakIndex = -1;
        Vector<Object> rowValues = new Vector<Object>();
        int index = -1;
        do {
            Object value = this.getCurrentValue(report, colData);
            inRow = this.compareRowBreakVal(this.oldvalue, this.newvalue);
            if (!inRow) break;
            index = stbl.getColumnCount();
            for (int j = 0; j < report.colInfo.length; ++j) {
                ColInfo colInfo = report.colInfo[j];
                Object obj = colData[colInfo.getMapping()].getData(this.recNo);
                if (!colInfo.isColumnBreak() && !colInfo.isColumnBreakValue()) {
                    Aggregation.calculateAggregation(obj, j, this.preAggCol, this.resultCol);
                    Aggregation.calculateAggregation(obj, j, this.footerAggCol, this.footerResCol);
                    if (!firstLine) continue;
                    stbl.getColumn(j).addData(obj);
                    continue;
                }
                if (colInfo.isColumnBreak()) {
                    columnBreakIndex = j;
                    ColData rowCol = report.colData[report.colInfo[j].getMapping()];
                    fieldName = rowCol.getFieldName();
                    Aggregation.calculateAggregation(obj, j, this.preAggCol, this.resultCol);
                    Aggregation.calculateAggregation(obj, j, this.footerAggCol, this.footerResCol);
                    for (int k = 0; k < fieldName.length; ++k) {
                        if (!obj.equals(fieldName[k])) continue;
                        Aggregation.calculateAggregation(value, j + k, this.preAggCol, this.resultCol);
                        Aggregation.calculateAggregation(value, j + k, this.footerAggCol, this.footerResCol);
                        stbl.getColumn(j + k).addData(value);
                        rowValues.addElement(value);
                        hasData.addElement(k);
                    }
                    continue;
                }
                if (!colInfo.isColumnBreakValue()) continue;
                Aggregation.calculateAggregation(value, index - 1, this.preAggCol, this.resultCol);
                Aggregation.calculateAggregation(value, index - 1, this.footerAggCol, this.footerResCol);
            }
            if (firstLine) {
                firstLine = false;
            }
            ++this.recNo;
            if (this.recNo >= this.nRow) continue;
            this.newvalue = this.getCurrentRowBreakVal(report, colData);
        } while (inRow && this.recNo < this.nRow);
        if (this.aggr != 4) {
            stbl.getColumn(index - 1).addData(Aggregation.getComputedValue(this.aggr, rowValues.toArray()));
        } else {
            stbl.getColumn(index - 1).addData(Aggregation.getComputedValue((short)1, rowValues.toArray()));
        }
        for (int k = 0; k < fieldName.length; ++k) {
            boolean isNull = true;
            for (int i = 0; i < hasData.size(); ++i) {
                int n = (Integer)hasData.elementAt(i);
                if (k != n) continue;
                isNull = false;
                break;
            }
            if (!isNull) continue;
            stbl.getColumn(columnBreakIndex + k).addData(null);
        }
    }

    private Vector resetResultCol(Vector vec) {
        Vector<Object> res = new Vector<Object>();
        for (int i = 0; i < vec.size(); ++i) {
            res.addElement(null);
        }
        return res;
    }

    private ReportTable createTable(ReportTable tbl) {
        ReportTable newTbl = new ReportTable(tbl);
        int ct = tbl.getColumnCount();
        for (int i = 0; i < ct; ++i) {
            newTbl.addColumn(new ReportColumn(tbl.getColumn(i)));
        }
        return newTbl;
    }

    private Object[] getCurrentRowBreakVal(Report report, ColData[] colData) {
        Object[] currentRowBreakVal = new Object[this.numBreakCol - 1];
        int index = 0;
        for (ColInfo colInfo : report.colInfo) {
            if (!colInfo.isRowBreak()) continue;
            currentRowBreakVal[index] = colData[colInfo.getMapping()].getData(this.recNo);
            ++index;
        }
        return currentRowBreakVal;
    }

    private Object getCurrentValue(Report report, ColData[] colData) {
        Object value = null;
        for (ColInfo colInfo : report.colInfo) {
            if (!colInfo.isColumnBreakValue()) continue;
            value = colData[colInfo.getMapping()].getData(this.recNo);
        }
        return value;
    }

    private boolean noSwap(Object[] oldVal, Object[] newVal) {
        for (int i = 0; i < this.numBreakCol - 1; ++i) {
            if (!newVal[i].equals(oldVal[i])) continue;
            return true;
        }
        return false;
    }

    private boolean compareRowBreakVal(Object[] oldVal, Object[] newVal) {
        for (int i = 0; i < this.numBreakCol - 1; ++i) {
            if (newVal[i].equals(oldVal[i])) continue;
            return false;
        }
        return true;
    }
}

