/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.output.DocumentException;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.Aggregation;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.ColDataBuffer;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.MasterDetailsTable;
import quadbase.reportdesigner.report.PDFReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.report.TransformQuery;

public class PDFReportMasterDetails
extends PDFReport {
    private static final Logger LOGGER = Logger.getLogger(PDFReportMasterDetails.class.getName());
    Vector footerAggCol;
    Vector footerResCol;
    private Vector[] preAggCol;
    private Vector[] resultCol;
    private ColDataBuffer colDataBuffer;
    private boolean firstValue = true;
    private int sectionID = 0;

    public PDFReportMasterDetails(Report report) throws IOException, DocumentException, Exception {
        super(report);
    }

    @Override
    public void exportPDF(OutputStream out, String fileName, String userPass, String ownerPass, int permissions, String javaScript) throws Exception {
        this.reportUI = new ReportUI(this.report, IOUtil.getOffScreenGraphics(), false);
        try {
            this.reportUI.preCalcTotalSections();
            this.totalSections = this.reportUI.getTotalSections();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Can't get total section number", e);
        }
        this.reportGraphics = this.reportUI.getReportGraphics();
        this.pageFooterHeight = this.hasNoData(this.report.getPageFooter()) ? 0.0f : this.resizeSection(this.reportGraphics, this.report.getPageFooter(), this.report.getReportTables().elementAt(this.report.getReportTables().size() - 1)).getHeightToPoints();
        this.pageHeight = this.report.getPageHeightToPoints() - this.topMargin - this.bottomMargin - this.pageFooterHeight;
        this.checkTotalPageNumber = false;
        this.exportPDF(out, userPass, ownerPass, permissions, javaScript);
        out.flush();
        out.close();
        this.colDataBuffer.join();
    }

    @Override
    void formatTable() throws Exception {
    }

    @Override
    protected void writeReportTable(ReportTable tbl) throws Exception {
        this.writeSection(tbl.getHeader(), tbl);
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.addRepeatSection(tbl.getHeader(), tbl);
        }
        this.footerAggCol = new Vector();
        this.footerResCol = new Vector();
        Aggregation.getAggrColumn(tbl.getFooter(), tbl, this.footerAggCol, this.footerResCol);
        Aggregation.getAggrColumn(this.report.getReportFooter(), tbl, this.footerAggCol, this.footerResCol);
        this.writeMasterDetailsTable((MasterDetailsTable)tbl);
        this.writeSection(tbl.getFooter(), tbl, this.footerAggCol, this.footerResCol);
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.removeRepeatSection();
        }
    }

    private void writeMasterDetailsTable(MasterDetailsTable tbl) throws Exception {
        if (tbl == null || tbl.mData == null) {
            return;
        }
        Report report = tbl.mData.report;
        int numBreakCol = report.breakColInfo.length;
        int nRow = 0;
        int startIndex = 0;
        int displayRow = Report.getInputDataBlockSize();
        if (report.dbInfo != null) {
            DBInfoBasic dbinfo = report.dbInfo;
            String sqlstr = dbinfo.getQuery();
            sqlstr = TransformQuery.transformMasterDetails(sqlstr, report.colInfo);
            DBInfoBasic tempdbInfo = null;
            tempdbInfo = dbinfo.isUseJNDIDataSource() ? new DBInfoBasic(dbinfo.getJNDIName(), sqlstr, dbinfo.getEnvProperties()) : new DBInfoBasic(dbinfo.getConnection(), dbinfo.getURLString(), dbinfo.getDriverName(), dbinfo.getUserID(), dbinfo.getPassword(), sqlstr);
            this.colDataBuffer = new ColDataBuffer(tempdbInfo, startIndex, displayRow, dbinfo.getQuery());
        } else {
            this.colDataBuffer = new ColDataBuffer(report.originalIResultSet, startIndex, displayRow);
        }
        this.colDataBuffer.start();
        ReportTable stbl = this.createTable(tbl);
        int loop = 0;
        this.preAggCol = new Vector[tbl.dataHeader.length];
        this.resultCol = new Vector[tbl.dataHeader.length];
        for (int i = 0; i < tbl.dataHeader.length; ++i) {
            this.preAggCol[i] = new Vector();
            this.resultCol[i] = new Vector();
            Aggregation.getAggrColumn(tbl.dataFooter[i], stbl, this.preAggCol[i], this.resultCol[i]);
            ++loop;
        }
        Object[] oldvalue = new Object[numBreakCol];
        Object[] newvalue = new Object[numBreakCol];
        boolean init = false;
        int recNo = 0;
        int group = 0;
        while (true) {
            if (!this.colDataBuffer.isDataReady(startIndex)) {
                Thread.sleep(100L);
                continue;
            }
            ColData[] colData = this.colDataBuffer.getData(startIndex);
            this.colDataBuffer.clearDataBuffer(startIndex);
            nRow = colData[0].getSize();
            startIndex = nRow + startIndex;
            recNo = 0;
            if (!init) {
                for (int i = 0; i < numBreakCol; ++i) {
                    int cMap = report.breakColInfo[i].getMapping();
                    oldvalue[i] = colData[cMap].getData(0);
                }
                this.addRow(report, colData, stbl, recNo);
                init = true;
                recNo = 1;
                for (ReportSection element : tbl.dataHeader) {
                    this.writeSection(element, stbl);
                    if (!element.isRepeatOnEveryPage()) continue;
                    this.addRepeatSection(element, stbl);
                }
                this.firstValue = false;
            }
            while (recNo < nRow) {
                int i;
                boolean doSwap = false;
                for (i = 0; i < numBreakCol; ++i) {
                    int k;
                    int cMap = report.breakColInfo[i].getMapping();
                    newvalue[i] = colData[cMap].getData(recNo);
                    if (doSwap) continue;
                    if (oldvalue[i] == null && newvalue[i] == null || oldvalue[i] != null && newvalue[i] != null && oldvalue[i].equals(newvalue[i])) {
                        colData[cMap].setData(recNo, "");
                        continue;
                    }
                    LOGGER.finest("Swap");
                    doSwap = true;
                    this.writeCells(stbl);
                    for (k = tbl.dataFooter.length - 1; i <= k; --k) {
                        this.writeSection(tbl.dataFooter[k], stbl, this.preAggCol[--loop], this.resultCol[loop]);
                        if (tbl.dataHeader[k].isRepeatOnEveryPage()) {
                            this.removeRepeatSection();
                        }
                        this.resultCol[loop] = this.resetResultCol(this.preAggCol[loop]);
                    }
                    stbl = this.createTable(tbl);
                    if (recNo < nRow - 1) {
                        this.addRow(report, colData, stbl, recNo);
                        ++recNo;
                        this.sectionID = group > i ? 0 : ++this.sectionID;
                        group = i;
                        for (k = i; k < tbl.dataHeader.length; ++k) {
                            this.writeSection(tbl.dataHeader[k], stbl, this.preAggCol[loop], this.resultCol[loop]);
                            if (tbl.dataHeader[k].isRepeatOnEveryPage()) {
                                this.addRepeatSection(tbl.dataHeader[k], stbl);
                            }
                            ++loop;
                        }
                        continue;
                    }
                    init = false;
                    for (k = i; k < tbl.dataHeader.length; ++k) {
                        ++loop;
                    }
                }
                for (i = 0; i < numBreakCol; ++i) {
                    oldvalue[i] = newvalue[i];
                }
                this.addRow(report, colData, stbl, recNo);
                ++recNo;
            }
            if (displayRow != nRow) break;
        }
        this.writeCells(stbl);
        for (int k = loop - 1; k >= 0; --k) {
            this.writeSection(tbl.dataFooter[k], stbl, this.preAggCol[k], this.resultCol[k]);
            if (!tbl.dataHeader[k].isRepeatOnEveryPage()) continue;
            this.removeRepeatSection();
        }
        this.preAggCol = null;
        this.resultCol = null;
    }

    @Override
    protected boolean isFirstValue() {
        return this.firstValue;
    }

    @Override
    protected int getCurrentSectionID() {
        return this.sectionID;
    }

    private Vector resetResultCol(Vector vec) {
        Vector<Object> res = new Vector<Object>();
        for (int i = 0; i < vec.size(); ++i) {
            res.addElement(null);
        }
        return res;
    }

    private ReportTable createTable(ReportTable tbl) {
        ReportTable newTbl = new ReportTable(tbl);
        int ct = tbl.getColumnCount();
        for (int i = 0; i < ct; ++i) {
            newTbl.addColumn(new ReportColumn(tbl.getColumn(i)));
        }
        return newTbl;
    }

    private void addRow(Report report, ColData[] colData, ReportTable stbl, int recNo) throws Exception {
        for (int j = 0; j < report.colInfo.length; ++j) {
            Object obj = null;
            if (report.colInfo[j].getMapping() != -1) {
                obj = colData[report.colInfo[j].getMapping()].getData(recNo);
            } else {
                Formula formulaObj = report.colInfo[j].getFormulaObj();
                obj = formulaObj.getValue(stbl, recNo, 1, 1, 1, 1, report, null, null, false, null, null, colData);
            }
            Aggregation.calculateAggregation(obj, j, this.preAggCol, this.resultCol);
            Aggregation.calculateAggregation(obj, j, this.footerAggCol, this.footerResCol);
            stbl.getColumn(j).addData(obj);
        }
    }
}

